/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorCollectionCall;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorFeatureAccessOrCall;
import org.eclipse.acceleo.query.ast.ErrorStringLiteral;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.FeatureAccess;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.parser.QueryBaseListener;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;

public class AstBuilderListener
extends QueryBaseListener {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.query";
    public static final String CONDITIONAL_OPERATOR = "if";
    public static final String NOT_SERVICE_NAME = "not";
    public static final String NOT_OPERATOR = "not";
    public static final String LET_OPERATOR = "let";
    public static final String DIFFERS_SERVICE_NAME = "differs";
    public static final String DIFFERS_OPERATOR = "<>";
    public static final String EQUALS_SERVICE_NAME = "equals";
    public static final String EQUALS_OPERATOR = "=";
    public static final String GREATER_THAN_EQUAL_SERVICE_NAME = "greaterThanEqual";
    public static final String GREATER_THAN_EQUAL_OPERATOR = ">=";
    public static final String GREATER_THAN_SERVICE_NAME = "greaterThan";
    public static final String GREATER_THAN_OPERATOR = ">";
    public static final String LESS_THAN_EQUAL_SERVICE_NAME = "lessThanEqual";
    public static final String LESS_THAN_EQUAL_OPERATOR = "<=";
    public static final String LESS_THAN_SERVICE_NAME = "lessThan";
    public static final String LESS_THAN_OPERATOR = "<";
    public static final String DIV_SERVICE_NAME = "divOp";
    public static final String DIV_OPERATOR = "/";
    public static final String MULT_SERVICE_NAME = "mult";
    public static final String MULT_OPERATOR = "*";
    public static final String SUB_SERVICE_NAME = "sub";
    public static final String SUB_OPERATOR = "-";
    public static final String ADD_SERVICE_NAME = "add";
    public static final String ADD_OPERATOR = "+";
    public static final String UNARY_MIN_SERVICE_NAME = "unaryMin";
    public static final String UNARY_MIN_OPERATOR = "-";
    public static final String AND_SERVICE_NAME = "and";
    public static final String AND_OPERATOR = "and";
    public static final String OR_SERVICE_NAME = "or";
    public static final String OR_OPERATOR = "or";
    public static final String XOR_SERVICE_NAME = "xor";
    public static final String XOR_OPERATOR = "xor";
    public static final String IMPLIES_SERVICE_NAME = "implies";
    public static final String IMPLIES_OPERATOR = "implies";
    public static final Set<String> OPERATOR_SERVICE_NAMES = AstBuilderListener.initOperatorServiceNames();
    private static final String THIS_SHOULDN_T_HAPPEN = "This shouldn't happen.";
    private static final String INVALID_TYPE_LITERAL = "invalid type literal";
    private static final int NO_ERROR = -1;
    private static final String INTERNAL_ERROR_MSG = "Internal exception occured while evaluating an expression";
    private Stack<Object> stack = new Stack();
    private int errorRule = -1;
    private final Map<Object, Integer> startPositions = new HashMap<Object, Integer>();
    private final Map<Object, Integer> endPositions = new HashMap<Object, Integer>();
    private final List<Error> errors = new ArrayList<Error>();
    private Stack<Diagnostic> diagnosticStack = new Stack();
    private final BasicDiagnostic diagnostic = new BasicDiagnostic();
    private final ANTLRErrorListener errorListener = new QueryErrorListener();
    private final AstBuilder builder = new AstBuilder();
    private final IQueryEnvironment environment;

    public AstBuilderListener(IQueryEnvironment environment) {
        this.environment = environment;
    }

    private static Set<String> initOperatorServiceNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(ADD_SERVICE_NAME);
        result.add("and");
        result.add(DIFFERS_SERVICE_NAME);
        result.add(DIV_SERVICE_NAME);
        result.add(EQUALS_SERVICE_NAME);
        result.add(GREATER_THAN_EQUAL_SERVICE_NAME);
        result.add(GREATER_THAN_SERVICE_NAME);
        result.add("implies");
        result.add(LESS_THAN_EQUAL_SERVICE_NAME);
        result.add(LESS_THAN_SERVICE_NAME);
        result.add(MULT_SERVICE_NAME);
        result.add("not");
        result.add("or");
        result.add(SUB_SERVICE_NAME);
        result.add(UNARY_MIN_SERVICE_NAME);
        result.add("xor");
        return result;
    }

    public IQueryBuilderEngine.AstResult getAstResult() {
        return new IQueryBuilderEngine.AstResult(this.pop(), this.startPositions, this.endPositions, this.errors, (Diagnostic)this.diagnostic);
    }

    private Expression pop() {
        try {
            List data;
            Expression expression = (Expression)this.stack.pop();
            if (!this.diagnosticStack.isEmpty() && (data = this.diagnosticStack.peek().getData()).get(0).equals(this.startPositions.get(expression)) && data.get(1).equals(this.endPositions.get(expression))) {
                Diagnostic tmpDiagnostic = this.diagnosticStack.pop();
                this.diagnostic.add((Diagnostic)new BasicDiagnostic(tmpDiagnostic.getSeverity(), tmpDiagnostic.getSource(), tmpDiagnostic.getCode(), tmpDiagnostic.getMessage(), new Object[]{expression}));
            }
            return expression;
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException cce) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, cce);
        }
    }

    private String popString() {
        try {
            return (String)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private Binding popBinding() {
        try {
            return (Binding)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private VariableDeclaration popVariableDeclaration() {
        try {
            return (VariableDeclaration)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private TypeLiteral popTypeLiteral() {
        try {
            return (TypeLiteral)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private Expression[] popArgs() {
        try {
            return (Expression[])this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private void push(Object obj) {
        this.stack.push(obj);
    }

    private void pushError(Error error, String msg) {
        this.errors.add(error);
        this.diagnostic.add((Diagnostic)new BasicDiagnostic(4, PLUGIN_ID, 0, msg, new Object[]{error}));
        this.stack.push(error);
    }

    @Override
    public void exitIntType(QueryParser.IntTypeContext ctx) {
        TypeLiteral typeLiteral = this.builder.typeLiteral(Boolean.class);
        this.startPositions.put(typeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(typeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(typeLiteral);
    }

    @Override
    public void exitFalseLit(QueryParser.FalseLitContext ctx) {
        BooleanLiteral booleanLiteral = this.builder.booleanLiteral(false);
        this.startPositions.put(booleanLiteral, ctx.start.getStartIndex());
        this.endPositions.put(booleanLiteral, ctx.stop.getStopIndex() + 1);
        this.push(booleanLiteral);
    }

    @Override
    public void exitRealType(QueryParser.RealTypeContext ctx) {
        RealLiteral realLiteral = this.builder.realLiteral(Double.parseDouble(ctx.getText()));
        this.startPositions.put(realLiteral, ctx.start.getStartIndex());
        this.endPositions.put(realLiteral, ctx.stop.getStopIndex() + 1);
        this.push(realLiteral);
    }

    @Override
    public void exitTrueLit(QueryParser.TrueLitContext ctx) {
        BooleanLiteral booleanLiteral = this.builder.booleanLiteral(true);
        this.startPositions.put(booleanLiteral, ctx.start.getStartIndex());
        this.endPositions.put(booleanLiteral, ctx.stop.getStopIndex() + 1);
        this.push(booleanLiteral);
    }

    @Override
    public void exitSeqType(QueryParser.SeqTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        CollectionTypeLiteral collectionTypeLiteral = this.builder.collectionTypeLiteral(List.class, elementType);
        this.startPositions.put(collectionTypeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(collectionTypeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(collectionTypeLiteral);
    }

    @Override
    public void exitSetType(QueryParser.SetTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        CollectionTypeLiteral collectionTypeLiteral = this.builder.collectionTypeLiteral(Set.class, elementType);
        this.startPositions.put(collectionTypeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(collectionTypeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(collectionTypeLiteral);
    }

    @Override
    public void exitNot(QueryParser.NotContext ctx) {
        Call callService = this.builder.callService(CallType.CALLSERVICE, "not", this.pop());
        this.startPositions.put(callService, ctx.start.getStartIndex());
        this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
        this.push(callService);
    }

    @Override
    public void exitStringLit(QueryParser.StringLitContext ctx) {
        String text = ctx.getText();
        StringLiteral stringLiteral = this.builder.stringLiteral(text.substring(1, text.length() - 1));
        this.startPositions.put(stringLiteral, ctx.start.getStartIndex());
        this.endPositions.put(stringLiteral, ctx.stop.getStopIndex() + 1);
        this.push(stringLiteral);
    }

    @Override
    public void exitErrorStringLit(QueryParser.ErrorStringLitContext ctx) {
        String text = ctx.getText();
        ErrorStringLiteral errorStringLiteral = this.builder.errorStringLiteral(text.substring(1, text.length()));
        this.startPositions.put(errorStringLiteral, ctx.start.getStartIndex());
        this.endPositions.put(errorStringLiteral, ctx.stop.getStopIndex() + 1);
        this.pushError(errorStringLiteral, "String literal is not properly closed by a simple-quote: " + text);
    }

    @Override
    public void exitRealLit(QueryParser.RealLitContext ctx) {
        RealLiteral realLiteral = this.builder.realLiteral(Double.valueOf(ctx.getText()));
        this.startPositions.put(realLiteral, ctx.start.getStartIndex());
        this.endPositions.put(realLiteral, ctx.stop.getStopIndex() + 1);
        this.push(realLiteral);
    }

    @Override
    public void exitStrType(QueryParser.StrTypeContext ctx) {
        TypeLiteral typeLiteral = this.builder.typeLiteral(String.class);
        this.startPositions.put(typeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(typeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(typeLiteral);
    }

    @Override
    public void exitOr(QueryParser.OrContext ctx) {
        this.pushBinary("or", ctx);
    }

    @Override
    public void exitXor(QueryParser.XorContext ctx) {
        this.pushBinary("xor", ctx);
    }

    @Override
    public void exitImplies(QueryParser.ImpliesContext ctx) {
        this.pushBinary("implies", ctx);
    }

    @Override
    public void exitBooleanType(QueryParser.BooleanTypeContext ctx) {
        TypeLiteral typeLiteral = this.builder.typeLiteral(Boolean.class);
        this.startPositions.put(typeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(typeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(typeLiteral);
    }

    @Override
    public void exitIntegerLit(QueryParser.IntegerLitContext ctx) {
        IntegerLiteral integerLiteral = this.builder.integerLiteral(Integer.valueOf(ctx.getText()));
        this.startPositions.put(integerLiteral, ctx.start.getStartIndex());
        this.endPositions.put(integerLiteral, ctx.stop.getStopIndex() + 1);
        this.push(integerLiteral);
    }

    @Override
    public void exitAnd(QueryParser.AndContext ctx) {
        this.pushBinary("and", ctx);
    }

    @Override
    public void exitVarRef(QueryParser.VarRefContext ctx) {
        VarRef varRef = this.builder.varRef(ctx.getText());
        this.startPositions.put(varRef, ctx.start.getStartIndex());
        this.endPositions.put(varRef, ctx.stop.getStopIndex() + 1);
        this.push(varRef);
    }

    @Override
    public void exitFeature(QueryParser.FeatureContext ctx) {
        Expression receiver = this.pop();
        FeatureAccess featureAccess = this.builder.featureAccess(receiver, ctx.getChild(1).getText());
        this.startPositions.put(featureAccess, this.startPositions.get(receiver));
        this.endPositions.put(featureAccess, ctx.stop.getStopIndex() + 1);
        this.push(featureAccess);
    }

    private void pushBinary(String service, ParserRuleContext ctx) {
        Expression op2 = this.pop();
        Expression op1 = this.pop();
        Call callService = this.builder.callService(CallType.CALLSERVICE, service, op1, op2);
        this.startPositions.put(callService, this.startPositions.get(op1));
        this.endPositions.put(callService, this.endPositions.get(op2));
        this.push(callService);
    }

    @Override
    public void exitServiceCall(QueryParser.ServiceCallContext ctx) {
        if (this.errorRule != 6) {
            int childCount = ctx.getChild(2).getChildCount();
            int argc = 1 + (childCount == 0 ? 0 : 1 + childCount / 2);
            Expression[] args = new Expression[argc];
            int i = argc - 1;
            while (i >= 1) {
                args[i] = this.pop();
                --i;
            }
            String serviceName = ctx.getChild(0).getText().replace("::", ".");
            args[0] = this.pop();
            this.push(serviceName);
            this.push(args);
        }
    }

    @Override
    public void exitMin(QueryParser.MinContext ctx) {
        Call callService = this.builder.callService(CallType.CALLSERVICE, UNARY_MIN_SERVICE_NAME, this.pop());
        this.startPositions.put(callService, ctx.start.getStartIndex());
        this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
        this.push(callService);
    }

    @Override
    public void exitAdd(QueryParser.AddContext ctx) {
        String op = ctx.getChild(1).getText();
        if (ADD_OPERATOR.equals(op)) {
            this.pushBinary(ADD_SERVICE_NAME, ctx);
        } else if ("-".equals(op)) {
            this.pushBinary(SUB_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitMult(QueryParser.MultContext ctx) {
        String op = ctx.getChild(1).getText();
        if (MULT_OPERATOR.equals(op)) {
            this.pushBinary(MULT_SERVICE_NAME, ctx);
        } else if (DIV_OPERATOR.equals(op)) {
            this.pushBinary(DIV_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitComp(QueryParser.CompContext ctx) {
        String op = ctx.getChild(1).getText();
        if (LESS_THAN_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_SERVICE_NAME, ctx);
        } else if (LESS_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_EQUAL_SERVICE_NAME, ctx);
        } else if (GREATER_THAN_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_SERVICE_NAME, ctx);
        } else if (GREATER_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_EQUAL_SERVICE_NAME, ctx);
        } else if (EQUALS_OPERATOR.equals(op)) {
            this.pushBinary(EQUALS_SERVICE_NAME, ctx);
        } else if (DIFFERS_OPERATOR.equals(op)) {
            this.pushBinary(DIFFERS_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitCallService(QueryParser.CallServiceContext ctx) {
        if (this.errorRule != 6) {
            Expression[] args = this.popArgs();
            String serviceName = this.popString();
            Call callService = this.builder.callService(CallType.COLLECTIONCALL, serviceName, args);
            this.startPositions.put(callService, this.startPositions.get(args[0]));
            this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
            this.push(callService);
        } else {
            this.errorRule = -1;
        }
    }

    @Override
    public void exitApply(QueryParser.ApplyContext ctx) {
        if (this.errorRule != 6) {
            Expression[] args = this.popArgs();
            String serviceName = this.popString();
            Call callService = this.builder.callService(CallType.CALLORAPPLY, serviceName, args);
            this.startPositions.put(callService, this.startPositions.get(args[0]));
            this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
            this.push(callService);
        } else {
            this.errorRule = -1;
        }
    }

    @Override
    public void exitVariableDefinition(QueryParser.VariableDefinitionContext ctx) {
        if (this.errorRule == -1) {
            VariableDeclaration variableDeclaration;
            if (ctx.getChildCount() == 4) {
                TypeLiteral typeLiteral = this.popTypeLiteral();
                Expression variableExpression = this.pop();
                variableDeclaration = this.builder.variableDeclaration(ctx.getChild(0).getText(), typeLiteral, variableExpression);
                this.endPositions.put(variableDeclaration, ((ParserRuleContext)ctx.getChild((int)2)).stop.getStopIndex() + 1);
            } else {
                Expression variableExpression = this.pop();
                variableDeclaration = this.builder.variableDeclaration(ctx.getChild(0).getText(), variableExpression);
                this.endPositions.put(variableDeclaration, ((TerminalNode)ctx.getChild(0)).getSymbol().getStopIndex() + 1);
            }
            this.startPositions.put(variableDeclaration, ctx.start.getStartIndex());
            this.stack.push(variableDeclaration);
        }
    }

    @Override
    public void exitIterationCall(QueryParser.IterationCallContext ctx) {
        String serviceName = ctx.getChild(0).getText();
        Expression ast = this.pop();
        VariableDeclaration iterator = this.popVariableDeclaration();
        Lambda lambda = this.builder.lambda(ast, iterator);
        this.startPositions.put(lambda, this.startPositions.get(ast));
        this.endPositions.put(lambda, (int)this.endPositions.get(ast));
        this.push(serviceName);
        this.push(new Expression[]{iterator.getExpression(), lambda});
    }

    @Override
    public void exitEnumLit(QueryParser.EnumLitContext ctx) {
        if (this.errorRule == -1) {
            EnumLiteral toPush;
            String ePackageName = ctx.getChild(0).getText();
            String eEnumName = ctx.getChild(2).getText();
            String eEnumLiteralName = ctx.getChild(4).getText();
            EEnumLiteral eEnumLiteral = this.environment.getEPackageProvider().getEnumLiteral(ePackageName, eEnumName, eEnumLiteralName);
            if (eEnumLiteral == null) {
                ArrayList<String> segments = new ArrayList<String>(2);
                segments.add(ePackageName);
                segments.add(eEnumName);
                segments.add(eEnumLiteralName);
                toPush = this.builder.errorEnumLiteral(segments.toArray(new String[segments.size()]));
                this.pushError((Error)((Object)toPush), "invalid enum literal");
            } else {
                toPush = this.builder.enumLiteral(eEnumLiteral);
                this.push(toPush);
            }
            this.startPositions.put(toPush, ctx.start.getStartIndex());
            this.endPositions.put(toPush, ctx.stop.getStopIndex() + 1);
        }
    }

    @Override
    public void exitClassifierType(QueryParser.ClassifierTypeContext ctx) {
        if (this.errorRule == -1) {
            TypeLiteral toPush;
            EClassifier type;
            String eClassName;
            String ePackageName = ctx.getChild(0).getText();
            if (ctx.getChild(2) instanceof ErrorNode) {
                eClassName = null;
                type = null;
            } else {
                eClassName = ctx.getChild(2).getText();
                type = this.environment.getEPackageProvider().getType(ePackageName, eClassName);
            }
            if (type == null) {
                ArrayList<String> segments = new ArrayList<String>(2);
                segments.add(ePackageName);
                if (eClassName != null) {
                    segments.add(eClassName);
                }
                toPush = this.builder.errorTypeLiteral(segments.toArray(new String[segments.size()]));
                this.pushError((Error)((Object)toPush), INVALID_TYPE_LITERAL);
            } else {
                toPush = this.builder.typeLiteral(type);
                this.push(toPush);
            }
            this.startPositions.put(toPush, ctx.start.getStartIndex());
            this.endPositions.put(toPush, ctx.stop.getStopIndex() + 1);
        }
    }

    public ANTLRErrorListener getErrorListener() {
        return this.errorListener;
    }

    @Override
    public void exitNullLit(QueryParser.NullLitContext ctx) {
        NullLiteral nullLiteral = this.builder.nullLiteral();
        this.startPositions.put(nullLiteral, ctx.start.getStartIndex());
        this.endPositions.put(nullLiteral, ctx.stop.getStopIndex() + 1);
        this.push(nullLiteral);
    }

    @Override
    public void exitSetLit(QueryParser.SetLitContext ctx) {
        SetInExtensionLiteral setInExtension = this.builder.setInExtension(this.getExpressions(ctx));
        this.startPositions.put(setInExtension, ctx.start.getStartIndex());
        this.endPositions.put(setInExtension, ctx.stop.getStopIndex() + 1);
        this.push(setInExtension);
    }

    @Override
    public void exitExplicitSetLit(QueryParser.ExplicitSetLitContext ctx) {
        SetInExtensionLiteral setInExtension = this.builder.setInExtension(this.getExpressions(ctx));
        this.startPositions.put(setInExtension, ctx.start.getStartIndex());
        this.endPositions.put(setInExtension, ctx.stop.getStopIndex() + 1);
        this.push(setInExtension);
    }

    private List<Expression> getExpressions(QueryParser.LiteralContext ctx) {
        int nbExpressions = (ctx.getChild(1).getChildCount() + 1) / 2;
        Expression[] expressions = new Expression[nbExpressions];
        int i = nbExpressions - 1;
        while (i >= 0) {
            expressions[i] = this.pop();
            --i;
        }
        return Arrays.asList(expressions);
    }

    @Override
    public void exitSeqLit(QueryParser.SeqLitContext ctx) {
        SequenceInExtensionLiteral sequenceInExtension = this.builder.sequenceInExtension(this.getExpressions(ctx));
        this.startPositions.put(sequenceInExtension, ctx.start.getStartIndex());
        this.endPositions.put(sequenceInExtension, ctx.stop.getStopIndex() + 1);
        this.push(sequenceInExtension);
    }

    @Override
    public void exitExplicitSeqLit(QueryParser.ExplicitSeqLitContext ctx) {
        SequenceInExtensionLiteral sequenceInExtension = this.builder.sequenceInExtension(this.getExpressions(ctx));
        this.startPositions.put(sequenceInExtension, ctx.start.getStartIndex());
        this.endPositions.put(sequenceInExtension, ctx.stop.getStopIndex() + 1);
        this.push(sequenceInExtension);
    }

    @Override
    public void exitConditional(QueryParser.ConditionalContext ctx) {
        Expression falseBranch;
        Expression trueBranch;
        Expression predicate;
        int count = ctx.getChildCount();
        if (count <= 3) {
            predicate = this.pop();
            trueBranch = this.builder.errorExpression();
            falseBranch = this.builder.errorExpression();
        } else if (count <= 5) {
            trueBranch = this.pop();
            predicate = this.pop();
            falseBranch = this.builder.errorExpression();
        } else {
            falseBranch = this.pop();
            trueBranch = this.pop();
            predicate = this.pop();
        }
        Conditional conditional = this.builder.conditional(predicate, trueBranch, falseBranch);
        this.startPositions.put(conditional, ctx.start.getStartIndex());
        this.endPositions.put(conditional, ctx.stop.getStopIndex() + 1);
        this.push(conditional);
    }

    @Override
    public void exitBinding(QueryParser.BindingContext ctx) {
        String variable = ctx.getChild(0).getText();
        Expression expression = this.pop();
        Binding binding = this.builder.binding(variable, expression);
        this.startPositions.put(binding, ctx.start.getStartIndex());
        this.endPositions.put(binding, ctx.stop.getStopIndex() + 1);
        this.push(binding);
    }

    @Override
    public void exitLetExpr(QueryParser.LetExprContext ctx) {
        Expression body = !(ctx.getChild(ctx.getChildCount() - 1) instanceof QueryParser.ExpressionContext) ? this.builder.errorExpression() : this.pop();
        int bindingNumber = 1 + (ctx.getChildCount() - 3) / 2;
        Binding[] bindings = new Binding[bindingNumber];
        int i = 0;
        while (i < bindingNumber) {
            bindings[i] = this.popBinding();
            ++i;
        }
        Let let = this.builder.let(body, bindings);
        this.startPositions.put(let, ctx.start.getStartIndex());
        this.endPositions.put(let, ctx.stop.getStopIndex() + 1);
        this.push(let);
    }

    private final class QueryErrorListener
    extends BaseErrorListener {
        private static final String MISSING_EXPRESSION = "missing expression";

        private QueryErrorListener() {
        }

        public void syntaxError(@NotNull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @NotNull String msg, @Nullable RecognitionException e) {
            if (e != null) {
                if (e.getCtx() instanceof QueryParser.IterationCallContext) {
                    this.iterationCallContextError(e);
                } else if (e.getCtx() instanceof QueryParser.TypeLiteralContext) {
                    this.typeLiteralContextError(offendingSymbol, msg, e);
                } else if (e.getCtx() instanceof QueryParser.LiteralContext) {
                    this.literalContextError(offendingSymbol, msg, e);
                } else if (e.getCtx() instanceof QueryParser.VariableDefinitionContext) {
                    this.variableDefinitionContextError(offendingSymbol, e);
                } else if (e.getCtx() instanceof QueryParser.CallExpContext) {
                    this.callExpContextError(offendingSymbol);
                } else if (e.getCtx() instanceof QueryParser.NavigationSegmentContext) {
                    this.navigationSegmentContextError(offendingSymbol);
                } else {
                    this.defaultError(offendingSymbol, e);
                }
            } else if (recognizer instanceof QueryParser) {
                this.noRecognitionException(recognizer, offendingSymbol, msg);
            } else {
                QueryParser parser = (QueryParser)recognizer;
                Integer startPosition = ((QueryParser.EnumLitContext)parser.getContext()).start.getStartIndex();
                Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
                AstBuilderListener.this.diagnosticStack.push(new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{startPosition, endPosition}));
            }
        }

        private void iterationCallContextError(RecognitionException e) {
            AstBuilderListener.this.errorRule = 1;
            ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
            AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
            Integer position = ((QueryParser.IterationCallContext)e.getCtx()).start.getStartIndex();
            AstBuilderListener.this.startPositions.put(errorExpression, position);
            AstBuilderListener.this.endPositions.put(errorExpression, position);
        }

        private void typeLiteralContextError(Object offendingSymbol, String msg, RecognitionException e) {
            Integer startPosition = ((QueryParser.TypeLiteralContext)e.getCtx()).start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            if (e.getCtx().getParent() instanceof QueryParser.VariableDefinitionContext) {
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getParent().getChild(0).getText();
                ErrorTypeLiteral type = AstBuilderListener.this.builder.errorTypeLiteral(new String[0]);
                AstBuilderListener.this.startPositions.put(type, startPosition);
                AstBuilderListener.this.endPositions.put(type, endPosition);
                AstBuilderListener.this.diagnostic.add((Diagnostic)new BasicDiagnostic(4, AstBuilderListener.PLUGIN_ID, 0, AstBuilderListener.INVALID_TYPE_LITERAL, new Object[]{type}));
                AstBuilderListener.this.errors.add(type);
                Expression variableExpression = AstBuilderListener.this.pop();
                VariableDeclaration variableDeclaration = AstBuilderListener.this.builder.variableDeclaration(variableName, type, variableExpression);
                AstBuilderListener.this.startPositions.put(variableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(variableDeclaration, endPosition);
                AstBuilderListener.this.push(variableDeclaration);
                ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
                AstBuilderListener.this.startPositions.put(errorExpression, startPosition);
                AstBuilderListener.this.endPositions.put(errorExpression, endPosition);
            } else if (!(AstBuilderListener.this.stack.peek() instanceof TypeLiteral)) {
                AstBuilderListener.this.errorRule = 13;
                ErrorTypeLiteral errorTypeLiteral = AstBuilderListener.this.builder.errorTypeLiteral(new String[0]);
                AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
                AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
                AstBuilderListener.this.pushError(errorTypeLiteral, AstBuilderListener.INVALID_TYPE_LITERAL);
            } else {
                AstBuilderListener.this.diagnosticStack.push(new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{startPosition, endPosition}));
            }
        }

        private void literalContextError(Object offendingSymbol, String msg, RecognitionException e) {
            QueryParser.LiteralContext ctx = (QueryParser.LiteralContext)e.getCtx();
            Integer startPosition = ctx.start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            String ePackage = ctx.getParent().getStart().getText();
            AstBuilderListener.this.errorRule = 13;
            ErrorTypeLiteral errorTypeLiteral = AstBuilderListener.this.builder.errorTypeLiteral(ePackage);
            AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
            AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
            AstBuilderListener.this.pushError(errorTypeLiteral, AstBuilderListener.INVALID_TYPE_LITERAL);
        }

        private void variableDefinitionContextError(Object offendingSymbol, RecognitionException e) {
            Integer startPosition = ((QueryParser.VariableDefinitionContext)e.getCtx()).start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            if (e.getCtx().getChildCount() > 0) {
                TypeLiteral type;
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getChild(0).getText();
                if (e.getCtx().getChildCount() > 2) {
                    type = AstBuilderListener.this.popTypeLiteral();
                    AstBuilderListener.this.endPositions.put(type, endPosition);
                } else {
                    type = null;
                }
                Expression variableExpression = AstBuilderListener.this.pop();
                ErrorVariableDeclaration errorVariableDeclaration = AstBuilderListener.this.builder.errorVariableDeclaration(variableName, type, variableExpression);
                AstBuilderListener.this.startPositions.put(errorVariableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(errorVariableDeclaration, endPosition);
                AstBuilderListener.this.pushError(errorVariableDeclaration, "incomplete variable definition");
            } else {
                Expression variableExpression = AstBuilderListener.this.pop();
                AstBuilderListener.this.errorRule = 11;
                ErrorVariableDeclaration errorVariableDeclaration = AstBuilderListener.this.builder.errorVariableDeclaration(null, null, variableExpression);
                AstBuilderListener.this.startPositions.put(errorVariableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(errorVariableDeclaration, endPosition);
                AstBuilderListener.this.pushError(errorVariableDeclaration, "missing variable declaration");
            }
            ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
            AstBuilderListener.this.startPositions.put(errorExpression, endPosition);
            AstBuilderListener.this.endPositions.put(errorExpression, endPosition);
            AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
        }

        private void callExpContextError(Object offendingSymbol) {
            AstBuilderListener.this.errorRule = 6;
            Expression receiver = AstBuilderListener.this.pop();
            ErrorCollectionCall errorCollectionCall = AstBuilderListener.this.builder.errorCollectionCall(receiver);
            AstBuilderListener.this.startPositions.put(errorCollectionCall, (Integer)AstBuilderListener.this.startPositions.get(receiver));
            AstBuilderListener.this.endPositions.put(errorCollectionCall, ((Token)offendingSymbol).getStopIndex() + 1);
            AstBuilderListener.this.pushError(errorCollectionCall, "missing collection service call");
        }

        private void navigationSegmentContextError(Object offendingSymbol) {
            Expression receiver = AstBuilderListener.this.pop();
            ErrorFeatureAccessOrCall errorFeatureAccessOrCall = AstBuilderListener.this.builder.errorFeatureAccessOrCall(receiver);
            AstBuilderListener.this.startPositions.put(errorFeatureAccessOrCall, (Integer)AstBuilderListener.this.startPositions.get(receiver));
            AstBuilderListener.this.endPositions.put(errorFeatureAccessOrCall, ((Token)offendingSymbol).getStopIndex() + 1);
            AstBuilderListener.this.pushError(errorFeatureAccessOrCall, "missing feature access or service call");
        }

        private void defaultError(Object offendingSymbol, RecognitionException e) {
            AstBuilderListener.this.errorRule = e.getCtx().getRuleIndex();
            switch (e.getCtx().getRuleIndex()) {
                case 1: {
                    ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                    Integer position = ((ParserRuleContext)e.getCtx()).start.getStartIndex();
                    AstBuilderListener.this.startPositions.put(errorExpression, position);
                    AstBuilderListener.this.endPositions.put(errorExpression, ((Token)offendingSymbol).getStopIndex() + 1);
                    AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
                    break;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void noRecognitionException(Recognizer<?, ?> recognizer, Object offendingSymbol, String msg) {
            QueryParser parser = (QueryParser)recognizer;
            Integer startPosition = parser.getContext().start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            if (parser.getContext() instanceof QueryParser.EnumLitContext) {
                AstBuilderListener.this.errorRule = 13;
                ParserRuleContext context = parser.getContext();
                if (context.getChildCount() != 4) throw new UnsupportedOperationException("there is no error then...");
                ErrorTypeLiteral errorTypeLiteral = AstBuilderListener.this.builder.errorTypeLiteral(context.getChild(0).getText(), context.getChild(2).getText());
                AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
                AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
                AstBuilderListener.this.pushError(errorTypeLiteral, msg);
                return;
            } else if (parser.getContext() instanceof QueryParser.CallExpContext) {
                ParserRuleContext parentNavContext = parser.getContext().getParent();
                while (!(parentNavContext instanceof QueryParser.NavContext) && parentNavContext != null) {
                    parentNavContext = parentNavContext.getParent();
                }
                Integer callStartPosition = parentNavContext == null ? Integer.valueOf(0) : Integer.valueOf(parentNavContext.start.getStartIndex());
                AstBuilderListener.this.diagnosticStack.push(new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{callStartPosition, endPosition}));
                return;
            } else {
                AstBuilderListener.this.diagnosticStack.push(new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{startPosition, endPosition}));
            }
        }
    }
}

