/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IEPackageProvider;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.LambdaValue;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.LambdaType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;

public class CollectionServices
extends AbstractServiceProvider {
    private static final String MESSAGE_SEPARATOR = "\n ";

    @Override
    protected IService getService(Method publicMethod) {
        Service result = "filter".equals(publicMethod.getName()) ? new SecondArgumentTypeInFirstArgumentCollectionType(publicMethod, this) : ("add".equals(publicMethod.getName()) || "concat".equals(publicMethod.getName()) || "union".equals(publicMethod.getName()) ? new ReturnCollectionTypeWithFirstAndSecondArgumentRawCollectionType(publicMethod, this) : ("asSequence".equals(publicMethod.getName()) || "asSet".equals(publicMethod.getName()) || "asOrderedSet".equals(publicMethod.getName()) ? new ReturnCollectionTypeWithFirstArgumentRawCollectionType(publicMethod, this) : ("subOrderedSet".equals(publicMethod.getName()) || "subSequence".equals(publicMethod.getName()) ? new FirstCollectionTypeService(publicMethod, this) : ("first".equals(publicMethod.getName()) || "at".equals(publicMethod.getName()) || "last".equals(publicMethod.getName()) ? new FirstArgumentRawCollectionType(publicMethod, this) : ("excluding".equals(publicMethod.getName()) || "sub".equals(publicMethod.getName()) || "reverse".equals(publicMethod.getName()) ? new FirstCollectionTypeService(publicMethod, this) : ("reject".equals(publicMethod.getName()) ? new RejectService(publicMethod, this) : ("select".equals(publicMethod.getName()) ? new SelectService(publicMethod, this) : ("collect".equals(publicMethod.getName()) ? new CollectService(publicMethod, this) : ("including".equals(publicMethod.getName()) || "prepend".equals(publicMethod.getName()) ? new IncludingService(publicMethod, this) : ("sep".equals(publicMethod.getName()) ? (publicMethod.getParameterTypes().length == 2 ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                result.add(new SequenceType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SequenceType(queryEnvironment, argTypes.get(1)));
                return result;
            }
        } : (publicMethod.getParameterTypes().length == 4 ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                result.add(new SequenceType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SequenceType(queryEnvironment, argTypes.get(1)));
                result.add(new SequenceType(queryEnvironment, argTypes.get(2)));
                result.add(new SequenceType(queryEnvironment, argTypes.get(3)));
                return result;
            }
        } : new Service(publicMethod, this))) : ("any".equals(publicMethod.getName()) ? new AnyService(publicMethod, this) : ("exists".equals(publicMethod.getName()) || "forAll".equals(publicMethod.getName()) || "one".equals(publicMethod.getName()) ? new BooleanLambdaService(publicMethod, this) : ("insertAt".equals(publicMethod.getName()) ? new InsertAtService(publicMethod, this) : ("intersection".equals(publicMethod.getName()) ? new IntersectionService(publicMethod, this) : new Service(publicMethod, this)))))))))))))));
        return result;
    }

    private static boolean isBooleanType(IReadOnlyQueryEnvironment queryEnvironment, Object type) {
        Class<?> typeClass;
        boolean result = type instanceof EClassifier ? (typeClass = queryEnvironment.getEPackageProvider().getClass((EClassifier)type)) == Boolean.class || typeClass == Boolean.TYPE : false;
        return result;
    }

    public List<Object> concat(List<Object> c1, List<Object> c2) {
        ArrayList result;
        if (c1.isEmpty()) {
            result = c2;
        } else if (c2.isEmpty()) {
            result = c1;
        } else {
            result = Lists.newArrayList(c1);
            result.addAll(c2);
        }
        return result;
    }

    public List<Object> add(List<Object> l1, List<Object> l2) {
        return this.concat(l1, l2);
    }

    public List<Object> sub(List<Object> l1, List<Object> l2) {
        if (l2.isEmpty()) {
            return l1;
        }
        ArrayList result = Lists.newArrayList(l1);
        for (Object obj : l2) {
            result.remove(obj);
        }
        return result;
    }

    public Set<Object> sub(Set<Object> l1, Set<Object> l2) {
        if (l2.isEmpty()) {
            return l1;
        }
        LinkedHashSet result = Sets.newLinkedHashSet(l1);
        for (Object obj : l2) {
            result.remove(obj);
        }
        return result;
    }

    public Set<Object> add(Set<Object> l1, Set<Object> l2) {
        return Sets.union(l1, l2);
    }

    public List<Object> select(List<Object> l1, LambdaValue lambda) {
        ArrayList newList;
        if (lambda == null) {
            newList = Collections.emptyList();
        } else {
            newList = Lists.newArrayList();
            for (Object elt : l1) {
                try {
                    if (!Boolean.TRUE.equals(lambda.eval(new Object[]{elt}))) continue;
                    newList.add(elt);
                }
                catch (Exception exception) {}
            }
        }
        return newList;
    }

    public Set<Object> select(Set<Object> l1, LambdaValue lambda) {
        LinkedHashSet newSet;
        if (lambda == null) {
            newSet = Collections.emptySet();
        } else {
            newSet = Sets.newLinkedHashSet();
            for (Object elt : l1) {
                try {
                    if (!Boolean.TRUE.equals(lambda.eval(new Object[]{elt}))) continue;
                    newSet.add(elt);
                }
                catch (Exception exception) {}
            }
        }
        return newSet;
    }

    public Set<Object> reject(Set<Object> l1, LambdaValue lambda) {
        LinkedHashSet newSet;
        if (lambda == null) {
            newSet = Collections.emptySet();
        } else {
            newSet = Sets.newLinkedHashSet();
            for (Object elt : l1) {
                try {
                    if (!Boolean.FALSE.equals(lambda.eval(new Object[]{elt}))) continue;
                    newSet.add(elt);
                }
                catch (Exception exception) {}
            }
        }
        return newSet;
    }

    public List<Object> reject(List<Object> l1, LambdaValue lambda) {
        ArrayList newList;
        if (lambda == null) {
            newList = Collections.emptyList();
        } else {
            newList = Lists.newArrayList();
            for (Object elt : l1) {
                try {
                    if (!Boolean.FALSE.equals(lambda.eval(new Object[]{elt}))) continue;
                    newList.add(elt);
                }
                catch (Exception exception) {}
            }
        }
        return newList;
    }

    public Set<Object> collect(Set<Object> set, LambdaValue lambda) {
        LinkedHashSet result;
        if (lambda == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (Object elt : set) {
                try {
                    result.add(lambda.eval(new Object[]{elt}));
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public List<Object> collect(List<Object> list, LambdaValue lambda) {
        ArrayList result;
        if (lambda == null) {
            result = Collections.emptyList();
        } else {
            result = Lists.newArrayList();
            for (Object elt : list) {
                try {
                    result.add(lambda.eval(new Object[]{elt}));
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public Integer size(Collection<Object> collection) {
        return collection.size();
    }

    public Set<Object> including(Set<Object> source, Object object) {
        if (source.contains(object)) {
            return source;
        }
        LinkedHashSet result = Sets.newLinkedHashSet(source);
        result.add(object);
        return result;
    }

    public Set<Object> excluding(Set<Object> source, Object object) {
        if (!source.contains(object)) {
            return source;
        }
        LinkedHashSet result = Sets.newLinkedHashSet(source);
        result.remove(object);
        return result;
    }

    public List<Object> including(List<Object> source, Object object) {
        if (source.contains(object)) {
            return source;
        }
        ArrayList result = Lists.newArrayList(source);
        result.add(object);
        return result;
    }

    public List<Object> excluding(List<Object> source, Object object) {
        if (!source.contains(object)) {
            return source;
        }
        ArrayList result = Lists.newArrayList(source);
        result.remove(object);
        return result;
    }

    public List<Object> asSequence(Collection<Object> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return Lists.newArrayList(collection);
    }

    public Set<Object> asSet(Collection<Object> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        return Sets.newLinkedHashSet(collection);
    }

    public Set<Object> asOrderedSet(Collection<Object> collection) {
        return this.asSet(collection);
    }

    public Object first(Collection<Object> collection) {
        Iterator<Object> iterator = collection.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public List<Object> reverse(List<Object> collection) {
        return Lists.reverse(collection);
    }

    public Set<Object> reverse(Set<Object> collection) {
        return Sets.newLinkedHashSet((Iterable)Lists.reverse((List)ImmutableList.copyOf(collection)));
    }

    public Boolean isEmpty(Collection<Object> collection) {
        return collection.isEmpty();
    }

    public Boolean notEmpty(Collection<Object> collection) {
        return !collection.isEmpty();
    }

    public Object at(List<Object> list, Integer position) {
        return list.get(position - 1);
    }

    public Set<Object> filter(Set<Object> set, EClass eClassifier) {
        LinkedHashSet result;
        if (set == null) {
            result = null;
        } else if (eClassifier == null) {
            result = Sets.newLinkedHashSet();
        } else {
            result = Sets.newLinkedHashSet();
            for (Object object : set) {
                if (!eClassifier.isInstance(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    public List<Object> filter(List<Object> list, EClassifier eClassifier) {
        ArrayList result;
        if (list == null) {
            result = null;
        } else if (eClassifier == null) {
            result = Lists.newArrayList();
        } else {
            result = Lists.newArrayList();
            for (Object object : list) {
                if (!eClassifier.isInstance(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    public List<Object> sep(Collection<Object> collection, Object separator) {
        ArrayList result;
        if (collection == null) {
            result = null;
        } else {
            result = Lists.newArrayList();
            Iterator<Object> it = collection.iterator();
            if (it.hasNext()) {
                result.add(it.next());
                while (it.hasNext()) {
                    result.add(separator);
                    result.add(it.next());
                }
            }
        }
        return result;
    }

    public List<Object> sep(Collection<Object> collection, Object prefix, Object separator, Object suffix) {
        ArrayList result = Lists.newArrayList();
        result.add(prefix);
        if (collection != null) {
            result.addAll(this.sep(collection, separator));
        }
        result.add(suffix);
        return result;
    }

    public Object last(List<Object> list) {
        ListIterator<Object> it = list.listIterator(list.size());
        if (it.hasPrevious()) {
            return it.previous();
        }
        return null;
    }

    public Boolean excludes(Collection<Object> collection, Object object) {
        return !collection.contains(object);
    }

    public Boolean includes(Collection<Object> collection, Object object) {
        return collection.contains(object);
    }

    public Set<Object> union(Set<Object> c1, Set<Object> c2) {
        return this.add(c1, c2);
    }

    public List<Object> union(List<Object> c1, List<Object> c2) {
        return this.concat(c1, c2);
    }

    public Object any(Collection<Object> self, LambdaValue lambda) {
        Object result = null;
        if (self != null && lambda == null) {
            result = null;
        } else {
            for (Object input : self) {
                try {
                    if (!Boolean.TRUE.equals(lambda.eval(new Object[]{input}))) continue;
                    result = input;
                    break;
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public Integer count(Set<Object> set, Object object) {
        Integer result = set.contains(object) ? Integer.valueOf(1) : Integer.valueOf(0);
        return result;
    }

    public Integer count(List<Object> list, Object object) {
        int result = 0;
        if (object == null) {
            for (Object input : list) {
                if (input != null) continue;
                ++result;
            }
        } else {
            for (Object input : list) {
                if (!object.equals(input)) continue;
                ++result;
            }
        }
        return result;
    }

    public Boolean exists(Collection<Object> collection, LambdaValue lambda) {
        Boolean result = Boolean.FALSE;
        if (collection != null && lambda == null) {
            result = Boolean.FALSE;
        } else {
            for (Object input : collection) {
                try {
                    if (!Boolean.TRUE.equals(lambda.eval(new Object[]{input}))) continue;
                    result = Boolean.TRUE;
                    break;
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public Boolean forAll(Collection<Object> collection, LambdaValue lambda) {
        Boolean result = Boolean.TRUE;
        if (collection != null && lambda == null) {
            result = Boolean.FALSE;
        } else {
            for (Object input : collection) {
                try {
                    if (Boolean.TRUE.equals(lambda.eval(new Object[]{input}))) continue;
                    result = Boolean.FALSE;
                }
                catch (Exception exception) {
                    result = Boolean.FALSE;
                }
                break;
            }
        }
        return result;
    }

    public Boolean excludesAll(Collection<Object> self, Collection<Object> c2) {
        boolean result = true;
        for (Object input : c2) {
            if (!self.contains(input)) continue;
            result = false;
            break;
        }
        return result;
    }

    public Boolean includesAll(Collection<Object> self, Collection<Object> c2) {
        return self.containsAll(c2);
    }

    public Boolean isUnique(Collection<Object> self, LambdaValue lambda) {
        boolean result = true;
        HashSet evaluated = Sets.newHashSet();
        if (self != null && lambda == null) {
            result = false;
        } else {
            for (Object input : self) {
                try {
                    if (evaluated.add(lambda.eval(new Object[]{input}))) continue;
                    result = false;
                    break;
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public Boolean one(Collection<Object> self, LambdaValue lambda) {
        boolean result = false;
        if (self != null && lambda == null) {
            result = false;
        } else {
            for (Object input : self) {
                try {
                    if (!Boolean.TRUE.equals(lambda.eval(new Object[]{input}))) continue;
                    boolean bl = result = !result;
                    if (result) continue;
                    break;
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public Double sum(Collection<Object> self) {
        double result = 0.0;
        for (Object input : self) {
            if (input instanceof Number) {
                result += ((Number)input).doubleValue();
                continue;
            }
            throw new IllegalArgumentException("Can only sum numbers.");
        }
        return result;
    }

    public Integer indexOf(List<Object> self, Object object) {
        return self.indexOf(object) + 1;
    }

    public List<Object> insertAt(List<Object> list, Integer position, Object object) {
        int initialSize = list.size();
        if (position < 1 || position > initialSize) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<Object> result = new ArrayList<Object>(initialSize + 1);
        result.addAll(list.subList(0, position - 1));
        result.add(object);
        result.addAll(list.subList(position - 1, initialSize));
        return result;
    }

    public List<Object> prepend(List<Object> list, Object object) {
        ArrayList<Object> result = new ArrayList<Object>(list.size() + 1);
        result.add(object);
        result.addAll(list);
        return result;
    }

    public <T> Set<T> intersection(Set<T> set1, Collection<?> collection) {
        if (collection instanceof Set) {
            return Sets.intersection(set1, (Set)((Set)collection));
        }
        LinkedHashSet result = Sets.newLinkedHashSet(set1);
        result.retainAll(collection);
        return result;
    }

    public <T> List<T> intersection(List<T> list1, Collection<?> collection) {
        ArrayList result = Lists.newArrayList(list1);
        result.retainAll(collection);
        return result;
    }

    public Set<Object> subOrderedSet(Set<Object> set, Integer startIndex, Integer endIndex) {
        if (startIndex < 1 || endIndex > set.size() || startIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(endIndex - startIndex + 1);
        int index = 1;
        for (Object input : set) {
            if (index >= startIndex) {
                if (index > endIndex) break;
                result.add(input);
            }
            ++index;
        }
        return result;
    }

    public List<Object> subSequence(List<Object> list, Integer startIndex, Integer endIndex) {
        if (startIndex < 1 || endIndex > list.size() || startIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<Object> result = new ArrayList<Object>(endIndex - startIndex + 1);
        int index = 1;
        for (Object input : list) {
            if (index >= startIndex) {
                if (index > endIndex) break;
                result.add(input);
            }
            ++index;
        }
        return result;
    }

    private static final class AnyService
    extends Service {
        private AnyService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LambdaType lambdaType = (LambdaType)argTypes.get(1);
            Object lambdaExpressionType = lambdaType.getLambdaExpressionType().getType();
            if (CollectionServices.isBooleanType(queryEnvironment, lambdaExpressionType)) {
                IType lambdaEvaluatorType = lambdaType.getLambdaEvaluatorType();
                if (lambdaEvaluatorType instanceof EClassifierLiteralType) {
                    lambdaEvaluatorType = new EClassifierType(queryEnvironment, ((EClassifierLiteralType)lambdaEvaluatorType).getType());
                }
                result.add(lambdaEvaluatorType);
            } else {
                result.add(services.nothing("expression in an any must return a boolean", new Object[0]));
            }
            return result;
        }
    }

    private static final class BooleanLambdaService
    extends Service {
        private BooleanLambdaService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LambdaType lambdaType = (LambdaType)argTypes.get(1);
            Object lambdaExpressionType = lambdaType.getLambdaExpressionType().getType();
            if (CollectionServices.isBooleanType(queryEnvironment, lambdaExpressionType)) {
                result.addAll(super.getType(services, queryEnvironment, argTypes));
            } else {
                result.add(services.nothing("expression in %s must return a boolean", this.getServiceMethod().getName()));
            }
            return result;
        }
    }

    private static final class CollectService
    extends Service {
        private CollectService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LambdaType lambdaType = (LambdaType)argTypes.get(1);
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(queryEnvironment, lambdaType.getLambdaExpressionType()));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(queryEnvironment, lambdaType.getLambdaExpressionType()));
            }
            return result;
        }
    }

    private static final class FirstArgumentRawCollectionType
    extends Service {
        private FirstArgumentRawCollectionType(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            result.add(((ICollectionType)argTypes.get(0)).getCollectionType());
            return result;
        }
    }

    private static final class FirstCollectionTypeService
    extends Service {
        public FirstCollectionTypeService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
            }
            return result;
        }
    }

    private static final class IncludingService
    extends Service {
        private IncludingService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SequenceType(queryEnvironment, argTypes.get(1)));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SetType(queryEnvironment, argTypes.get(1)));
            }
            return result;
        }

        @Override
        public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
                for (IType type : entry.getValue()) {
                    if (((ICollectionType)type).getCollectionType() instanceof NothingType) {
                        builder.append(CollectionServices.MESSAGE_SEPARATOR);
                        builder.append(((NothingType)((ICollectionType)type).getCollectionType()).getMessage());
                        continue;
                    }
                    result.add(type);
                }
            }
            if (result.isEmpty()) {
                result.add(services.nothing("Nothing left after %s:" + builder.toString(), this.getServiceMethod().getName()));
            }
            return result;
        }
    }

    private static final class InsertAtService
    extends Service {
        private InsertAtService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SequenceType(queryEnvironment, argTypes.get(2)));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SetType(queryEnvironment, argTypes.get(2)));
            }
            return result;
        }
    }

    private static final class IntersectionService
    extends Service {
        private IntersectionService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result;
            block9: {
                LinkedHashSet<IType> resultRawTypes;
                block8: {
                    result = new LinkedHashSet<IType>();
                    IType selfRawType = ((ICollectionType)argTypes.get(0)).getCollectionType();
                    IType otherRawType = ((ICollectionType)argTypes.get(1)).getCollectionType();
                    resultRawTypes = new LinkedHashSet<IType>();
                    IType loweredType = services.lower(selfRawType, otherRawType);
                    if (loweredType != null) {
                        resultRawTypes.add(loweredType);
                    } else if (selfRawType.getType() instanceof EClass && otherRawType.getType() instanceof EClass) {
                        for (EClass eCls : this.getSubTypesTopIntersection(queryEnvironment.getEPackageProvider(), (EClass)selfRawType.getType(), (EClass)otherRawType.getType())) {
                            resultRawTypes.add(new EClassifierType(queryEnvironment, (EClassifier)eCls));
                        }
                        if (resultRawTypes.isEmpty()) {
                            resultRawTypes.add(services.nothing("Nothing left after intersection of %s and %s", argTypes.get(0), argTypes.get(1)));
                        }
                    } else {
                        resultRawTypes.add(selfRawType);
                        resultRawTypes.add(otherRawType);
                    }
                    if (!List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) break block8;
                    for (IType resultRawType : resultRawTypes) {
                        result.add(new SequenceType(queryEnvironment, resultRawType));
                    }
                    break block9;
                }
                if (!Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) break block9;
                for (IType resultRawType : resultRawTypes) {
                    result.add(new SetType(queryEnvironment, resultRawType));
                }
            }
            return result;
        }

        @Override
        public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
                for (IType type : entry.getValue()) {
                    if (((ICollectionType)type).getCollectionType() instanceof NothingType) {
                        builder.append(CollectionServices.MESSAGE_SEPARATOR);
                        builder.append(((NothingType)((ICollectionType)type).getCollectionType()).getMessage());
                        continue;
                    }
                    result.add(type);
                }
            }
            if (result.isEmpty()) {
                result.add(new SetType(queryEnvironment, services.nothing("Nothing left after intersection:" + builder.toString(), new Object[0])));
            }
            return result;
        }

        private Set<EClass> getSubTypesTopIntersection(IEPackageProvider provider, EClass eCls1, EClass eCls2) {
            LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
            Set<EClass> subTypes1 = provider.getAllSubTypes(eCls1);
            Set<EClass> subTypes2 = provider.getAllSubTypes(eCls2);
            LinkedHashSet<EClass> intersection = new LinkedHashSet<EClass>();
            for (EClass subType1 : subTypes1) {
                if (!subTypes2.contains(subType1)) continue;
                intersection.add(subType1);
            }
            for (EClass eCls : intersection) {
                boolean isTopEClass = true;
                for (EClass superECls : eCls.getEAllSuperTypes()) {
                    if (!intersection.contains(superECls)) continue;
                    isTopEClass = false;
                    break;
                }
                if (!isTopEClass) continue;
                result.add(eCls);
            }
            return result;
        }
    }

    private static final class RejectService
    extends Service {
        private RejectService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LambdaType lambdaType = (LambdaType)argTypes.get(1);
            Object lambdaExpressionType = lambdaType.getLambdaExpressionType().getType();
            if (CollectionServices.isBooleanType(queryEnvironment, lambdaExpressionType)) {
                if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SequenceType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SetType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                }
            } else {
                result.add(services.nothing("expression in a reject must return a boolean", new Object[0]));
            }
            return result;
        }
    }

    private static final class ReturnCollectionTypeWithFirstAndSecondArgumentRawCollectionType
    extends Service {
        private ReturnCollectionTypeWithFirstAndSecondArgumentRawCollectionType(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SequenceType(queryEnvironment, ((ICollectionType)argTypes.get(1)).getCollectionType()));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SetType(queryEnvironment, ((ICollectionType)argTypes.get(1)).getCollectionType()));
            }
            return result;
        }

        @Override
        public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
                for (IType type : entry.getValue()) {
                    if (((ICollectionType)type).getCollectionType() instanceof NothingType) {
                        builder.append(CollectionServices.MESSAGE_SEPARATOR);
                        builder.append(((NothingType)((ICollectionType)type).getCollectionType()).getMessage());
                        continue;
                    }
                    result.add(type);
                }
            }
            if (result.isEmpty()) {
                result.add(services.nothing("Nothing left after %s:" + builder.toString(), this.getServiceMethod().getName()));
            }
            return result;
        }
    }

    private static final class ReturnCollectionTypeWithFirstArgumentRawCollectionType
    extends Service {
        private ReturnCollectionTypeWithFirstArgumentRawCollectionType(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
            }
            return result;
        }
    }

    private static final class SecondArgumentTypeInFirstArgumentCollectionType
    extends FilterService {
        SecondArgumentTypeInFirstArgumentCollectionType(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            EClassifierType rawType = new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType());
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(queryEnvironment, rawType));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(queryEnvironment, rawType));
            }
            return result;
        }
    }

    private static final class SelectService
    extends Service {
        private SelectService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LambdaType lambdaType = (LambdaType)argTypes.get(1);
            Object lambdaExpressionType = lambdaType.getLambdaExpressionType().getType();
            if (CollectionServices.isBooleanType(queryEnvironment, lambdaExpressionType)) {
                IType lambdaEvaluatorType = lambdaType.getLambdaEvaluatorType();
                if (lambdaEvaluatorType instanceof EClassifierLiteralType) {
                    lambdaEvaluatorType = new EClassifierType(queryEnvironment, ((EClassifierLiteralType)lambdaEvaluatorType).getType());
                }
                if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SequenceType(queryEnvironment, lambdaEvaluatorType));
                } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SetType(queryEnvironment, lambdaEvaluatorType));
                }
            } else {
                result.add(services.nothing("expression in a select must return a boolean", new Object[0]));
            }
            return result;
        }
    }
}

