/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public final class TimeOfDayValueConverter
implements ValueConverter<LocalTime> {
    public static final TimeOfDayValueConverter INSTANCE = new TimeOfDayValueConverter();
    static final DateTimeFormatter TIME_OF_DAY_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final Pattern SCANNER_PATTERN = Pattern.compile("\\G\\d[_\\d]++:\\d[_\\d]++:\\d[_\\d]++(?:\\.\\d[_\\d]++)?");

    private TimeOfDayValueConverter() {
    }

    @Override
    public String toString(LocalTime value) {
        return value.format(TIME_OF_DAY_FORMATTER);
    }

    @Override
    public LocalTime toValue(String string) {
        if (string.indexOf("__") != -1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_CONSECUTIVE_UNDERSCORES_ERROR_MESSAGE, string));
        }
        try {
            return LocalTime.parse(string.replace("_", ""), TIME_OF_DAY_FORMATTER);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_InvalidTimeOfDayLiteral, string), e);
        }
    }

    @Override
    public LocalTime toValue(Scanner scanner) throws IllegalArgumentException, NoSuchElementException, IllegalStateException {
        return (LocalTime)this.toValue(scanner, SCANNER_PATTERN);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

