/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;

public abstract class AbstractChangeListElementOrderCommand<T>
extends Command {
    private final T selection;
    private final EList<T> list;
    private final int oldIndex;
    private int newIndex;

    private AbstractChangeListElementOrderCommand(T selection, EList<T> list) {
        this.selection = selection;
        this.list = list;
        this.oldIndex = list.indexOf(selection);
        Assert.isTrue((this.oldIndex >= 0 ? 1 : 0) != 0);
    }

    protected AbstractChangeListElementOrderCommand(T selection, boolean moveUp, EList<T> list) {
        this(selection, list);
        int n = this.newIndex = moveUp ? this.oldIndex - 1 : this.oldIndex + 1;
        if (this.newIndex < 0) {
            this.newIndex = 0;
        }
        if (this.newIndex >= list.size()) {
            this.newIndex = list.size() - 1;
        }
    }

    protected AbstractChangeListElementOrderCommand(T selection, int newIndex, EList<T> list) {
        this(selection, list);
        this.newIndex = newIndex;
    }

    protected AbstractChangeListElementOrderCommand(T selection, T refElement, boolean insertAfter, EList<T> list) {
        this(selection, list);
        int index = list.indexOf(refElement);
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        if (insertAfter) {
            ++index;
        }
        this.newIndex = index;
    }

    public boolean canExecute() {
        return this.selection != null && this.list.size() > 1 && this.list.size() > this.newIndex;
    }

    public void execute() {
        this.moveTo(this.newIndex);
    }

    public void redo() {
        this.moveTo(this.newIndex);
    }

    public void undo() {
        this.moveTo(this.oldIndex);
    }

    private void moveTo(int index) {
        this.list.move(index, this.selection);
    }

    public T getSelection() {
        return this.selection;
    }
}

