/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.ExportFilter;
import org.eclipse.fordiac.ide.export.ICompareEditorOpener;
import org.eclipse.fordiac.ide.export.IExportTemplate;
import org.eclipse.fordiac.ide.export.Messages;
import org.eclipse.fordiac.ide.export.utils.CompareEditorOpenerUtil;
import org.eclipse.fordiac.ide.export.utils.DelayedFiles;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;

public abstract class TemplateExportFilter
extends ExportFilter {
    private static final String[] BUTTON_LABELS = new String[]{Messages.TemplateExportFilter_OVERWRITE_LABEL_STRING, Messages.TemplateExportFilter_OVERWRITE_ALL_LABEL_STRING, Messages.TemplateExportFilter_MERGE_LABEL_STRING, Messages.TemplateExportFilter_CANCEL_ALL_LABEL_STRING, JFaceResources.getString((String)"cancel")};
    private static final int BUTTON_OVERWRITE = Arrays.asList(BUTTON_LABELS).indexOf(Messages.TemplateExportFilter_OVERWRITE_LABEL_STRING);
    private static final int BUTTON_OVERWRITE_ALL = Arrays.asList(BUTTON_LABELS).indexOf(Messages.TemplateExportFilter_OVERWRITE_ALL_LABEL_STRING);
    private static final int BUTTON_MERGE = Arrays.asList(BUTTON_LABELS).indexOf(Messages.TemplateExportFilter_MERGE_LABEL_STRING);
    private static final int BUTTON_CANCEL_ALL = Arrays.asList(BUTTON_LABELS).indexOf(Messages.TemplateExportFilter_CANCEL_ALL_LABEL_STRING);

    protected TemplateExportFilter() {
    }

    private static List<String> reformat(String name, List<String> messages) {
        return name != null ? messages.stream().map(v -> MessageFormat.format(Messages.TemplateExportFilter_PREFIX_ERRORMESSAGE_WITH_TYPENAME, name, v)).toList() : messages;
    }

    @Override
    public final void export(IFile typeFile, String destination, boolean forceOverwrite) throws ExportException.UserInteraction {
        this.export(typeFile, destination, forceOverwrite, null);
    }

    private static String stringsToTextualList(List<String> list) {
        String textualList = "";
        if (list.size() == 1) {
            textualList = MessageFormat.format(Messages.TemplateExportFilter_LIST_ONE_ELEMENT, list.get(0));
        } else if (list.size() == 2) {
            textualList = MessageFormat.format(Messages.TemplateExportFilter_LIST_TWO_ELEMENTS, list.get(0), list.get(1));
        } else if (list.size() == 3) {
            textualList = MessageFormat.format(Messages.TemplateExportFilter_LIST_THREE_ELEMENTS, list.get(0), list.get(1), list.get(2));
        } else if (list.size() > 3) {
            textualList = MessageFormat.format(Messages.TemplateExportFilter_LIST_FOUR_OR_MORE_ELEMENTS, list.get(0), list.get(1), list.get(2));
        }
        return textualList;
    }

    @Override
    public void export(IFile typeFile, String destination, boolean forceOverwrite, EObject source) throws ExportException.UserInteraction {
        if (source == null && typeFile != null && TypeLibraryManager.INSTANCE.getTypeEntryForFile(typeFile) == null) {
            this.getWarnings().add(MessageFormat.format(Messages.TemplateExportFilter_PREFIX_ERRORMESSAGE_WITH_TYPENAME, typeFile.getFullPath(), Messages.TemplateExportFilter_FILE_IGNORED));
            return;
        }
        try {
            boolean overwrite;
            if (source == null && typeFile != null) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)typeFile.getFullPath().toString(), (boolean)true), true);
                source = (EObject)resource.getContents().get(0);
            }
            String name = "anonymous";
            if (source instanceof INamedElement) {
                INamedElement ne = (INamedElement)source;
                name = ne.getName();
            } else if (typeFile != null) {
                name = typeFile.getFullPath().removeFileExtension().lastSegment();
            }
            DelayedFiles files = this.generateFileContent(destination, name, source);
            int res = BUTTON_OVERWRITE;
            boolean filesExisted = files.exist();
            if (!forceOverwrite && filesExisted) {
                String msg = MessageFormat.format(Messages.TemplateExportFilter_OVERWRITE_REQUEST, TemplateExportFilter.stringsToTextualList(files.getFilenames()));
                res = (Integer)Display.getDefault().syncCall(() -> {
                    MessageDialog msgDiag = new MessageDialog(Display.getDefault().getActiveShell(), Messages.TemplateExportFilter_FILE_EXISTS, null, msg, 6, BUTTON_LABELS, 0);
                    return msgDiag.open();
                });
            }
            boolean bl = overwrite = forceOverwrite || BUTTON_OVERWRITE == res;
            if (overwrite || BUTTON_MERGE == res) {
                Iterable<DelayedFiles.StoredFiles> writtenFiles = files.write(overwrite);
                if (!overwrite) {
                    TemplateExportFilter.openMergeEditor(writtenFiles);
                }
            } else {
                if (res == BUTTON_OVERWRITE_ALL) {
                    files.write(true);
                    throw new ExportException.OverwriteAll();
                }
                if (res == BUTTON_CANCEL_ALL) {
                    throw new ExportException.CancelAll();
                }
                this.getWarnings().add(MessageFormat.format(Messages.TemplateExportFilter_PREFIX_ERRORMESSAGE_WITH_TYPENAME, typeFile != null ? typeFile.getFullPath() : name, Messages.TemplateExportFilter_EXPORT_CANCELED));
            }
        }
        catch (ExportException.UserInteraction e) {
            throw e;
        }
        catch (Exception t) {
            FordiacLogHelper.logError((String)Messages.TemplateExportFilter_ErrorDuringTemplateGeneration, (Throwable)t);
            this.getErrors().add(t.getMessage() != null ? t.getMessage() : Messages.TemplateExportFilter_ErrorDuringTemplateGeneration);
        }
    }

    private DelayedFiles generateFileContent(String destination, String name, EObject source) throws ExportException {
        DelayedFiles files = new DelayedFiles();
        Path destinationPath = Paths.get(destination, new String[0]);
        Set<IExportTemplate> templates = this.getTemplates(name, source);
        for (IExportTemplate template : templates) {
            CharSequence content = template.generate();
            this.getErrors().addAll(TemplateExportFilter.reformat(name, template.getErrors()));
            this.getWarnings().addAll(TemplateExportFilter.reformat(name, template.getWarnings()));
            this.getInfos().addAll(TemplateExportFilter.reformat(name, template.getInfos()));
            if (content == null || !template.getErrors().isEmpty()) {
                files.clear();
                break;
            }
            String processed = content.toString().lines().map(String::stripTrailing).collect(Collectors.joining(System.lineSeparator()));
            Path templatePath = destinationPath.resolve(template.getPath());
            files.write(templatePath, processed);
        }
        return files;
    }

    private static void openMergeEditor(Iterable<DelayedFiles.StoredFiles> writtenFiles) throws ExportException {
        for (DelayedFiles.StoredFiles sf : writtenFiles) {
            if (sf.newFile() == null || sf.oldFile() == null) continue;
            ICompareEditorOpener opener = CompareEditorOpenerUtil.getOpener();
            if (opener == null) {
                throw new ExportException(Messages.TemplateExportFilter_MERGE_EDITOR_FAILED);
            }
            opener.setName(sf.newFile().getName());
            opener.setTitle(sf.newFile().getName());
            opener.setNewFile(sf.newFile());
            opener.setOriginalFile(sf.oldFile());
            if (!opener.hasDifferences()) continue;
            Display.getDefault().asyncExec(opener::openCompareEditor);
        }
    }

    protected abstract Set<IExportTemplate> getTemplates(String var1, EObject var2);
}

