/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.editparts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.fordiac.ide.deployment.debug.ui.DeploymentDebugModelPresentation;
import org.eclipse.fordiac.ide.deployment.debug.ui.editparts.AbstractWatchValueEditPart;
import org.eclipse.fordiac.ide.deployment.debug.ui.editparts.WatchValueDirectEditManager;
import org.eclipse.fordiac.ide.deployment.debug.ui.editparts.WatchValueDirectEditPolicy;
import org.eclipse.fordiac.ide.deployment.debug.ui.figures.WatchValueLabel;
import org.eclipse.fordiac.ide.deployment.debug.watch.IInterfaceElementWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVarDeclarationWatch;
import org.eclipse.fordiac.ide.gef.editparts.FigureCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

public class WatchValueEditPart
extends AbstractWatchValueEditPart {
    private int maxWidth = Integer.MAX_VALUE;

    protected IFigure createFigure() {
        return WatchValueLabel.getLabel(this.getInterfaceElement());
    }

    public Label getLabelFigure() {
        IFigure iFigure = this.getFigure();
        if (iFigure instanceof WatchValueLabel) {
            WatchValueLabel interfaceValueWatchLabel = (WatchValueLabel)iFigure;
            return interfaceValueWatchLabel.getLabelFigure();
        }
        IFigure iFigure2 = this.getFigure();
        if (iFigure2 instanceof Label) {
            Label label = (Label)iFigure2;
            return label;
        }
        return null;
    }

    @Override
    protected Dimension calculateSize() {
        InterfaceEditPart host = this.getHost();
        int width = Math.clamp((long)this.getFigure().getPreferredSize().width, 40, this.getMaxWidth());
        int height = host != null ? host.getFigure().getSize().height : FigureUtilities.getFontMetrics((Font)JFaceResources.getFontRegistry().get("org.eclipse.fordiac.ide.preferences.diagramFontDefinition")).getHeight();
        return new Dimension(width, height);
    }

    @Override
    public void activate() {
        this.initializeMaxWidth();
        super.activate();
        this.showPinValues(false);
    }

    @Override
    public void deactivate() {
        this.showPinValues(true);
        super.deactivate();
    }

    private void showPinValues(boolean show) {
        IInterfaceElement iInterfaceElement = this.getInterfaceElement();
        if (iInterfaceElement instanceof VarDeclaration) {
            EditPart editPart;
            VarDeclaration varDeclaration = (VarDeclaration)iInterfaceElement;
            if (this.getViewer() != null && (editPart = this.getViewer().getEditPartForModel((Object)varDeclaration.getValue())) instanceof ValueEditPart) {
                ValueEditPart valueEP = (ValueEditPart)editPart;
                valueEP.setVisible(show);
            }
        }
    }

    protected void createEditPolicies() {
        if (this.getModel().getElement() instanceof VarDeclaration) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new WatchValueDirectEditPolicy());
        }
    }

    @Override
    public boolean understandsRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            return this.getModel() instanceof IVarDeclarationWatch;
        }
        return super.understandsRequest(request);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    protected void performDirectEdit() {
        IInterfaceElementWatch iInterfaceElementWatch = this.getModel().getWatch();
        if (iInterfaceElementWatch instanceof IVarDeclarationWatch) {
            IVarDeclarationWatch varDeclarationWatch = (IVarDeclarationWatch)iInterfaceElementWatch;
            new WatchValueDirectEditManager((GraphicalEditPart)this, (CellEditorLocator)new FigureCellEditorLocator(this.getFigure()), varDeclarationWatch).show();
        }
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getLabelFigure() != null) {
            this.getLabelFigure().setText(this.getModel().getText());
            this.getLabelFigure().setForegroundColor(this.getWatchTextColor());
            this.getLabelFigure().setBackgroundColor(this.getWatchColor());
            this.showPinValues(false);
        }
    }

    protected Color getWatchColor() {
        IVarDeclarationWatch variableWatch;
        IInterfaceElementWatch watch = this.getModel().getWatch();
        if (watch.hasError()) {
            return DeploymentDebugModelPresentation.getWatchErrorColor();
        }
        if (watch instanceof IVarDeclarationWatch && (variableWatch = (IVarDeclarationWatch)watch).isForced()) {
            return DeploymentDebugModelPresentation.getForceColor();
        }
        return DeploymentDebugModelPresentation.getWatchColor();
    }

    protected Color getWatchTextColor() {
        IVarDeclarationWatch variableWatch;
        IInterfaceElementWatch watch = this.getModel().getWatch();
        if (watch.hasError()) {
            return DeploymentDebugModelPresentation.getWatchErrorTextColor();
        }
        if (watch instanceof IVarDeclarationWatch && (variableWatch = (IVarDeclarationWatch)watch).isForced()) {
            return DeploymentDebugModelPresentation.getForceTextColor();
        }
        return DeploymentDebugModelPresentation.getWatchTextColor();
    }

    protected int getMaxWidth() {
        return this.maxWidth;
    }

    private void initializeMaxWidth() {
        int maxLabelSize = ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getMaxValueLabelSize();
        FontMetrics fm = FigureUtilities.getFontMetrics((Font)JFaceResources.getFontRegistry().get("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
        this.maxWidth = (int)((double)(maxLabelSize + 2) * fm.getAverageCharacterWidth()) + 10;
    }
}

