/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.fordiac.ide.debug.AbstractLaunchProcess;
import org.eclipse.fordiac.ide.debug.EvaluatorStreamsProxy;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorCache;
import org.eclipse.fordiac.ide.model.eval.EvaluatorMonitor;
import org.eclipse.fordiac.ide.model.eval.EvaluatorThreadPoolExecutor;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class EvaluatorProcess
extends AbstractLaunchProcess
implements Callable<IStatus> {
    private final Evaluator evaluator;
    private final FutureTask<IStatus> task;
    private final EvaluatorThreadPoolExecutor executor;
    private final EvaluatorStreamsProxy streamsProxy;

    public EvaluatorProcess(String name, Evaluator evaluator, ILaunch launch) throws CoreException {
        super(evaluator.getClass().getSimpleName(), launch);
        this.evaluator = evaluator;
        this.task = new FutureTask<IStatus>(this);
        this.executor = new EvaluatorThreadPoolExecutor(name);
        this.executor.getContext().putAll(launch.getLaunchConfiguration().getAttributes());
        this.executor.addMonitor((EvaluatorMonitor)new EvaluatorTerminationMonitor());
        this.streamsProxy = new EvaluatorStreamsProxy(this.executor);
        launch.addProcess((IProcess)this);
        this.fireCreationEvent();
    }

    @Override
    public IStatus call() throws Exception {
        try {
            IStatus iStatus;
            block18: {
                Throwable throwable = null;
                Object var2_5 = null;
                EvaluatorCache cache = EvaluatorCache.open();
                try {
                    this.evaluator.prepare();
                    long start = System.nanoTime();
                    Value result = this.evaluator.evaluate();
                    if (result != null) {
                        this.streamsProxy.getOutputStreamMonitor().info(String.format("Result: %s", result));
                    }
                    long finish = System.nanoTime();
                    Duration elapsed = Duration.ofNanos(finish - start);
                    this.streamsProxy.getOutputStreamMonitor().info(String.format("Elapsed: %d:%02d:%02d:%03d", elapsed.toHours(), elapsed.toMinutesPart(), elapsed.toSecondsPart(), elapsed.toMillisPart()));
                    iStatus = Status.OK_STATUS;
                    if (cache == null) break block18;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (cache != null) {
                                cache.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (InterruptedException e) {
                        this.streamsProxy.getErrorStreamMonitor().error("Terminated");
                        Thread.currentThread().interrupt();
                        IStatus iStatus2 = Status.error((String)"Terminated");
                        return iStatus2;
                    }
                    catch (Exception t) {
                        this.streamsProxy.getErrorStreamMonitor().error("Exception occurred", t);
                        FordiacLogHelper.logWarning((String)("Exception occurred while evaluating " + this.name), (Exception)t);
                        IStatus iStatus3 = Status.error((String)"Exception occurred", (Throwable)t);
                        return iStatus3;
                    }
                }
                cache.close();
            }
            return iStatus;
        }
        finally {
            this.executor.shutdown();
        }
    }

    public void start() {
        this.executor.execute(this.task);
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public EvaluatorThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public void terminate() throws DebugException {
        this.executor.shutdownNow();
    }

    public int getExitValue() throws DebugException {
        try {
            return this.task.get(-1L, TimeUnit.NANOSECONDS).getCode();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DebugException(Status.error((String)"Couldn't get exit code", (Throwable)e));
        }
        catch (ExecutionException | TimeoutException e) {
            throw new DebugException(Status.error((String)"Couldn't get exit code", (Throwable)e));
        }
        catch (CancellationException e) {
            return -1;
        }
    }

    public IStreamsProxy getStreamsProxy() {
        return this.streamsProxy;
    }

    private class EvaluatorTerminationMonitor
    extends EvaluatorMonitor.NullEvaluatorMonitor {
        private EvaluatorTerminationMonitor() {
        }

        public void terminated(EvaluatorThreadPoolExecutor executor) {
            EvaluatorProcess.this.fireTerminateEvent();
        }
    }
}

