/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.model.commands.change.NegateConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class NegateConnectionsHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            CommandStack stack = (CommandStack)editor.getAdapter(CommandStack.class);
            for (Object obj : structSel.toList()) {
                if (!(obj instanceof ConnectionEditPart)) continue;
                ConnectionEditPart conEP = (ConnectionEditPart)((Object)obj);
                Connection connection = conEP.getModel();
                boolean newNegationState = !connection.isNegated();
                stack.execute((Command)new NegateConnectionCommand(connection, newNegationState));
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public void updateElement(UIElement element, Map parameters) {
        EditPart editPart;
        GraphicalViewer viewer;
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null && (viewer = (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class)) != null && viewer.getSelectedEditParts().size() == 1 && (editPart = (EditPart)viewer.getSelectedEditParts().get(0)) instanceof ConnectionEditPart) {
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart;
            boolean isNegated = connectionEditPart.getModel().isNegated();
            element.setText(isNegated ? Messages.Connection_Unnegate : Messages.Connection_Negate);
        }
    }

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection selection;
        Object object = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(object instanceof IStructuredSelection && (selection = (IStructuredSelection)object).stream().allMatch(element -> {
            ConnectionEditPart conEP;
            return element instanceof ConnectionEditPart && ((conEP = (ConnectionEditPart)((Object)((Object)element))).getModel().supportsNegated() || conEP.getModel().isNegated());
        }));
    }
}

