/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.FluentIterable;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.jvmmodel.JvmIdentifiableMetaData;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelAssociator;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;

public class BatchLinkableResourceStorageLoadable
extends ResourceStorageLoadable {
    public BatchLinkableResourceStorageLoadable(InputStream in, boolean storeNodeModel) {
        super(in, storeNodeModel);
    }

    protected void loadEntries(StorageAwareResource resource, ZipInputStream zipIn) throws IOException {
        super.loadEntries(resource, zipIn);
        if (resource instanceof BatchLinkableResource) {
            this.readAssociationsAdapter((BatchLinkableResource)resource, zipIn);
        }
    }

    protected void handleLoadEObject(InternalEObject loaded, BinaryResourceImpl.EObjectInputStream input) throws IOException {
        super.handleLoadEObject(loaded, input);
        if (input.readBoolean()) {
            DocumentationAdapter documentationAdapter = new DocumentationAdapter(input.readString());
            loaded.eAdapters().add((Object)documentationAdapter);
        }
        if (input.readBoolean()) {
            JvmIdentifiableMetaData metaData = new JvmIdentifiableMetaData();
            metaData.setSynthetic(input.readBoolean());
            loaded.eAdapters().add((Object)metaData);
        }
    }

    protected void readAssociationsAdapter(BatchLinkableResource resource, ZipInputStream stream) throws IOException {
        try {
            JvmModelAssociator.Adapter adapter = (JvmModelAssociator.Adapter)((Object)FluentIterable.from((Iterable)resource.eAdapters()).filter(JvmModelAssociator.Adapter.class).first().or(() -> {
                JvmModelAssociator.Adapter newAdapter = new JvmModelAssociator.Adapter();
                resource.eAdapters().add((Object)newAdapter);
                return newAdapter;
            }));
            stream.getNextEntry();
            Throwable throwable = null;
            Object var5_7 = null;
            try (ObjectInputStream objIn = new ObjectInputStream(new NonClosingFilterInputStream(new BufferedInputStream(stream)));){
                Map logicalMap = (Map)objIn.readObject();
                logicalMap.forEach((key, value) -> adapter.logicalContainerMap.put(resource.getEObject((String)key), (JvmIdentifiableElement)resource.getEObject((String)value)));
                Map sourceToTargetMap = (Map)objIn.readObject();
                sourceToTargetMap.forEach((source, targets) -> adapter.sourceToTargetMap.put(resource.getEObject((String)source), this.fragmentsToObjects(resource, (Set<String>)targets)));
                Map targetToSourceMap = (Map)objIn.readObject();
                targetToSourceMap.forEach((target, sources) -> adapter.targetToSourceMap.put(resource.getEObject((String)target), this.fragmentsToObjects(resource, (Set<String>)sources)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    private Set<EObject> fragmentsToObjects(BatchLinkableResource resource, Set<String> fragments) {
        return (Set)FluentIterable.from(fragments).transform(resource::getEObject).copyInto(new LinkedHashSet());
    }

    private static class NonClosingFilterInputStream
    extends FilterInputStream {
        public NonClosingFilterInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

