/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.p2packing;

import java.util.List;
import org.eclipse.elk.alg.rectpacking.RectPackingLayoutPhases;
import org.eclipse.elk.alg.rectpacking.options.InternalProperties;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.alg.rectpacking.util.DrawingUtil;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.EList;

public class NoPlacement
implements ILayoutPhase<RectPackingLayoutPhases, ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("No Compaction", 1.0f);
        ElkPadding padding = (ElkPadding)graph.getProperty(RectPackingOptions.PADDING);
        EList rectangles = graph.getChildren();
        KVector size = DrawingUtil.calculateDimensions((List<ElkNode>)rectangles);
        double width = Math.max(size.x, (Double)graph.getProperty(InternalProperties.MIN_WIDTH) - padding.getHorizontal());
        double height = Math.max(size.y, (Double)graph.getProperty(InternalProperties.MIN_HEIGHT) - padding.getVertical());
        double additionalHeight = height - size.y;
        graph.setProperty(InternalProperties.ADDITIONAL_HEIGHT, (Object)additionalHeight);
        graph.setProperty(InternalProperties.DRAWING_WIDTH, (Object)width);
        graph.setProperty(InternalProperties.DRAWING_HEIGHT, (Object)(height + additionalHeight));
        progressMonitor.done();
    }

    public LayoutProcessorConfiguration<RectPackingLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }
}

