/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.I4diacTableUtil;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class TablePasteAction
extends Action {
    private final Object part;

    public TablePasteAction(Object part) {
        this.part = part;
        this.setId(ActionFactory.PASTE.getId());
        this.setText(FordiacMessages.TableCopyPaste_TEXT_Paste);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    public void run() {
        I4diacTableUtil editor = TableWidgetFactory.getTableEditor(this.part);
        if (editor != null) {
            CellEditor[] cellEditorArray = editor.getViewer().getCellEditors();
            int n = cellEditorArray.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor cell = cellEditorArray[n2];
                if (cell.isActivated()) {
                    cell.performPaste();
                    return;
                }
                ++n2;
            }
            TablePasteAction.pasteItems(editor);
        }
    }

    private static void pasteItems(I4diacTableUtil editor) {
        TableViewer viewer = editor.getViewer();
        Table table = viewer.getTable();
        int[] pasteIndices = table.getSelectionIndices();
        Object content = Clipboard.getDefault().getContents();
        Object[] entries = TablePasteAction.createEntriesFromContent(content);
        int index = TablePasteAction.getInsertionStartIndex(pasteIndices, table);
        CompoundCommand cmpCommand = new CompoundCommand();
        int[] selectionIndices = new int[entries.length];
        int i = 0;
        while (i < entries.length) {
            selectionIndices[i] = index;
            editor.addEntry(entries[i], index++, cmpCommand);
            ++i;
        }
        editor.executeCompoundCommand(cmpCommand);
        table.forceFocus();
        table.setSelection(selectionIndices);
        viewer.setSelection(viewer.getSelection());
    }

    private static Object[] createEntriesFromContent(Object content) {
        return content instanceof StructuredSelection ? ((StructuredSelection)content).toArray() : (Object[])content;
    }

    private static int getInsertionStartIndex(int[] pasteIndices, Table table) {
        int index = pasteIndices.length == 0 ? (table.getItemCount() > 0 ? table.getItemCount() : 0) : pasteIndices[pasteIndices.length - 1] + 1;
        return index;
    }
}

