/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.fordiac.ide.ui.UIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public final class PreferenceGetter {
    private static final Map<RGB, Color> usedColors = new HashMap<RGB, Color>();

    public static Color getColor(String pref) {
        return PreferenceGetter.getColor(UIPlugin.getDefault().getPreferenceStore(), pref);
    }

    public static Color getColor(IPreferenceStore store, String pref) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)pref);
        return usedColors.computeIfAbsent(rgb, rgbCol -> new Color(null, rgbCol));
    }

    public static Color getDataColor(String dataType) {
        if ("BOOL".equals(dataType)) {
            return PreferenceGetter.getColor("BoolConnectionConnectorColor");
        }
        if (PreferenceGetter.isAnyBit(dataType)) {
            return PreferenceGetter.getColor("AnyBitConnectionConnectorColor");
        }
        if (PreferenceGetter.isAnyInt(dataType)) {
            return PreferenceGetter.getColor("AnyIntConnectionConnectorColor");
        }
        if (PreferenceGetter.isAnyReal(dataType)) {
            return PreferenceGetter.getColor("AnyRealConnectionConnectorColor");
        }
        if (PreferenceGetter.isAnyString(dataType)) {
            return PreferenceGetter.getColor("AnyStringConnectionConnectorColor");
        }
        return PreferenceGetter.getDefaultDataColor();
    }

    public static Color getDefaultDataColor() {
        return PreferenceGetter.getColor("DataConnectionConnectorColor");
    }

    private static boolean isAnyBit(String dataType) {
        return "ANY_BIT".equals(dataType) || "BYTE".equals(dataType) || "WORD".equals(dataType) || "DWORD".equals(dataType) || "LWORD".equals(dataType);
    }

    private static boolean isAnyInt(String dataType) {
        return "ANY_INT".equals(dataType) || "SINT".equals(dataType) || "INT".equals(dataType) || "DINT".equals(dataType) || "LINT".equals(dataType) || "USINT".equals(dataType) || "UINT".equals(dataType) || "UDINT".equals(dataType) || "ULINT".equals(dataType);
    }

    private static boolean isAnyReal(String dataType) {
        return "ANY_REAL".equals(dataType) || "REAL".equals(dataType) || "LREAL".equals(dataType);
    }

    private static boolean isAnyString(String dataType) {
        return "ANY_STRING".equals(dataType) || "STRING".equals(dataType) || "WSTRING".equals(dataType);
    }

    private PreferenceGetter() {
        throw new UnsupportedOperationException("PreferenceGetter utility class should not be instantiated!");
    }
}

