/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.IVarElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.systemconfiguration.Activator;
import org.eclipse.fordiac.ide.systemconfiguration.Messages;
import org.eclipse.fordiac.ide.systemconfiguration.commands.ResourceCreateCommand;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.ui.UIPlugin;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.fordiac.ide.util.YUV;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.RGB;

public class DeviceCreateCommand
extends Command {
    private static final String CREATE_DEVICE_LABEL = Messages.DeviceCreateCommand_LABEL_CreateDevice;
    private final DeviceTypePaletteEntry entry;
    private final SystemConfiguration parent;
    private final Rectangle bounds;
    private Device device;

    public Device getDevice() {
        return this.device;
    }

    public DeviceCreateCommand(DeviceTypePaletteEntry entry, SystemConfiguration parent, Rectangle bounds) {
        this.entry = entry;
        this.parent = parent;
        this.bounds = bounds;
        this.setLabel(CREATE_DEVICE_LABEL);
    }

    public boolean canExecute() {
        return this.entry != null && this.bounds != null && this.parent != null;
    }

    public void execute() {
        this.createDevice();
        this.device.setPaletteEntry((PaletteEntry)this.entry);
        CommonElementImporter.createParamters((IVarElement)this.device);
        this.setDeviceProfile();
        this.device.updatePosition(this.bounds.getTopLeft());
        this.parent.getDevices().add((Object)this.device);
        this.device.setName(NameRepository.createUniqueName((INamedElement)this.device, (String)this.entry.getDeviceType().getName()));
        this.setDeviceAttributes();
        this.createResource();
        SystemManager.INSTANCE.notifyListeners();
    }

    private void setDeviceAttributes() {
        for (AttributeDeclaration attributeDeclaration : this.entry.getDeviceType().getAttributeDeclarations()) {
            Attribute attribute = LibraryElementFactory.eINSTANCE.createAttribute();
            attribute.setName(attributeDeclaration.getName());
            attribute.setComment(attributeDeclaration.getComment());
            attribute.setValue(attributeDeclaration.getInitialValue());
            attribute.setAttributeDeclaration(attributeDeclaration);
            this.device.getAttributes().add((Object)attribute);
        }
    }

    private void setDeviceProfile() {
        String profile = this.device.getType().getProfile() != null && !"".equals(this.device.getType().getProfile()) ? this.device.getType().getProfile() : UIPlugin.getDefault().getPreferenceStore().getString("P_DEFAULT_COMPLIANCE_PROFILE");
        this.device.setProfile(profile);
    }

    protected void createDevice() {
        this.device = LibraryElementFactory.eINSTANCE.createDevice();
        this.device.setColor(this.createRandomDeviceColor());
    }

    private void createResource() {
        for (Resource res : this.entry.getDeviceType().getResource()) {
            ResourceCreateCommand cmd = null;
            if (res.getPaletteEntry() != null) {
                cmd = new ResourceCreateCommand((ResourceTypeEntry)res.getPaletteEntry(), this.device, true);
                cmd.execute();
                Resource copy = cmd.getResource();
                copy.setName(res.getName());
                continue;
            }
            Activator.getDefault().logInfo("Referenced Resource Type: " + (res.getName() != null ? res.getName() : "N/A") + (res.getPaletteEntry() != null ? " (" + res.getTypeName() + ") " : "(N/A)") + " not found. Please check whether your palette contains that type and add it manually to your device!");
        }
        this.createDefaultResource();
    }

    private void createDefaultResource() {
        ResourceTypeEntry type = null;
        type = this.device.getType().getName().contains("FBRT") || this.device.getType().getName().contains("FRAME") ? this.getResourceType("PANEL_RESOURCE") : this.getResourceType("EMB_RES");
        if (type != null) {
            ResourceCreateCommand cmd = new ResourceCreateCommand(type, this.device, false);
            cmd.execute();
        }
    }

    private ResourceTypeEntry getResourceType(String resTypeName) {
        return this.device.getPaletteEntry().getPalette().getResourceTypeEntry(resTypeName);
    }

    private Color createRandomDeviceColor() {
        Color randomColor;
        boolean exist;
        ArrayList<YUV> existingColors = new ArrayList<YUV>();
        for (Device dev : this.parent.getDevices()) {
            Color devcolor = dev.getColor();
            existingColors.add(new YUV(new RGB(devcolor.getRed(), devcolor.getGreen(), devcolor.getBlue())));
        }
        if (existingColors.isEmpty()) {
            return ColorHelper.getStartingColor();
        }
        block1: do {
            randomColor = ColorHelper.createRandomColor();
            YUV randYUV = new YUV(new RGB(randomColor.getRed(), randomColor.getGreen(), randomColor.getBlue()));
            exist = false;
            for (YUV yuv : existingColors) {
                if (!randYUV.nearbyColor(yuv)) continue;
                exist = true;
                continue block1;
            }
        } while (exist);
        return randomColor;
    }

    public void redo() {
        if (this.parent != null) {
            this.parent.getDevices().add((Object)this.device);
            SystemManager.INSTANCE.notifyListeners();
        }
    }

    public void undo() {
        if (this.parent != null) {
            this.parent.getDevices().remove((Object)this.device);
            SystemManager.INSTANCE.notifyListeners();
        }
    }
}

