/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.Activator;
import org.eclipse.fordiac.ide.model.ui.actions.IOpenListener;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public enum OpenListenerManager {
    INSTANCE;

    private List<IOpenListener> openListeners = null;

    List<IOpenListener> getOpenListeners() {
        if (this.openListeners == null) {
            this.loadOpenListeners();
        }
        return this.openListeners;
    }

    public List<IOpenListener> getOpenListener(EObject elementToOpen) {
        ArrayList<IOpenListener> listeners = new ArrayList<IOpenListener>();
        for (IOpenListener openListener : this.getOpenListeners()) {
            if (!OpenListenerManager.listenerSupportsElement(openListener, elementToOpen)) continue;
            openListener.selectionChanged(null, (ISelection)new StructuredSelection((Object)elementToOpen));
            listeners.add(openListener);
        }
        return listeners;
    }

    public static void setDefaultOpenListener(Class<? extends EObject> libElement, String id) {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        ps.setValue(libElement.getName(), id);
    }

    public IOpenListener getDefaultOpenListener(EObject elementToOpen) {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        for (IOpenListener openListener : this.getOpenListeners()) {
            if (!OpenListenerManager.listenerSupportsElement(openListener, elementToOpen)) continue;
            String value = ps.getString(openListener.getHandledClass().getName());
            openListener.selectionChanged(null, (ISelection)new StructuredSelection((Object)elementToOpen));
            if (!"".equals(value) && !value.equals(openListener.getOpenListenerID())) continue;
            return openListener;
        }
        return null;
    }

    public static IEditorPart openEditor(EObject element) {
        IOpenListener openListener = INSTANCE.getDefaultOpenListener(element);
        if (openListener != null) {
            openListener.run(null);
            return openListener.getOpenedEditor();
        }
        if (element instanceof LibraryElement) {
            return OpenListenerManager.openDefaultEditorForFile((LibraryElement)element);
        }
        return null;
    }

    static IEditorPart openDefaultEditorForFile(LibraryElement element) {
        PaletteEntry entry = element.getPaletteEntry();
        if (entry != null) {
            IFile file = entry.getFile();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            try {
                IEditorPart part = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                OpenListenerManager.checkBreadCrumb(part, element);
                return part;
            }
            catch (PartInitException e) {
                Activator.getDefault().getLog().error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    static void checkBreadCrumb(IEditorPart part, LibraryElement element) {
        AbstractBreadCrumbEditor breadCrumbEditor;
        if (part != null && (breadCrumbEditor = (AbstractBreadCrumbEditor)((Object)part.getAdapter(AbstractBreadCrumbEditor.class))) != null) {
            breadCrumbEditor.getBreadcrumb().setInput(element);
        }
    }

    private void loadOpenListeners() {
        IConfigurationElement[] elems;
        this.openListeners = new ArrayList<IOpenListener>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.model.ui", "openListener");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IOpenListener) {
                    this.openListeners.add((IOpenListener)object);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().getLog().error(corex.getMessage(), (Throwable)corex);
            }
            ++n2;
        }
    }

    private static boolean listenerSupportsElement(IOpenListener listener, EObject elementtoOpen) {
        return listener.getHandledClass() != null && listener.getHandledClass().isInstance(elementtoOpen);
    }
}

