/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.ui.actions.IOpenListener;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerAction;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.FileEditorInput;

public abstract class OpenListener
implements IOpenListener {
    private IEditorPart editor = null;
    private static final String SUBAPP_TYPE_EDITOR = "org.eclipse.fordiac.ide.subapptypeeditor.SubAppTypeEditor";
    private static final String FB_TYPE_EDITOR = "org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeEditor";

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    @Override
    public IEditorPart getOpenedEditor() {
        return this.editor;
    }

    @Override
    public final Action getOpenListenerAction() {
        return new OpenListenerAction(this);
    }

    protected void openEditor(IEditorInput input, String editorId) {
        this.editor = EditorUtils.openEditor((IEditorInput)input, (String)editorId);
    }

    protected void openInBreadCrumbEditor(IFile file, String editorId, EObject element) {
        AbstractBreadCrumbEditor breadCrumbEditor;
        this.openEditor((IEditorInput)new FileEditorInput(file), editorId);
        IEditorPart openedEditor = this.getOpenedEditor();
        if (openedEditor != null && (breadCrumbEditor = OpenListener.getBreadCrumbEditor(openedEditor)) != null) {
            breadCrumbEditor.getBreadcrumb().setInput(element);
        }
    }

    protected void openInSubappTypeEditor(SubAppType root, EObject element) {
        this.openInBreadCrumbEditor(root.getPaletteEntry().getFile(), SUBAPP_TYPE_EDITOR, element);
    }

    protected void openInFBTypeEditor(FBType root, EObject element) {
        this.openInBreadCrumbEditor(root.getPaletteEntry().getFile(), FB_TYPE_EDITOR, element);
    }

    private static AbstractBreadCrumbEditor getBreadCrumbEditor(IEditorPart openedEditor) {
        AbstractBreadCrumbEditor breadCrumbEditor = (AbstractBreadCrumbEditor)((Object)openedEditor.getAdapter(AbstractBreadCrumbEditor.class));
        if (breadCrumbEditor == null && openedEditor instanceof FormEditor) {
            breadCrumbEditor = OpenListener.getBreadCrumbFromMultiPageEditor((FormEditor)openedEditor);
        }
        return breadCrumbEditor;
    }

    private static AbstractBreadCrumbEditor getBreadCrumbFromMultiPageEditor(FormEditor openedEditor) {
        IEditorInput input = openedEditor.getActiveEditor().getEditorInput();
        IEditorPart[] iEditorPartArray = openedEditor.findEditors(input);
        int n = iEditorPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart subEditor = iEditorPartArray[n2];
            if (subEditor instanceof AbstractBreadCrumbEditor) {
                openedEditor.setActiveEditor(subEditor);
                return (AbstractBreadCrumbEditor)subEditor;
            }
            ++n2;
        }
        return null;
    }
}

