/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.dataimport.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerRef;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteInterfaceCommand
extends Command {
    private final IInterfaceElement interfaceElement;
    private CompoundCommand cmds;
    private InterfaceList parent;
    private int oldIndex;
    private ErrorMarkerBuilder oldErrorMarker;

    public DeleteInterfaceCommand(IInterfaceElement interfaceElement) {
        this.interfaceElement = interfaceElement;
    }

    public void execute() {
        this.parent = (InterfaceList)this.interfaceElement.eContainer();
        this.cmds = new CompoundCommand();
        this.handleWiths();
        this.handleSubAppConnections();
        if (this.interfaceElement instanceof AdapterDeclaration && this.parent.eContainer() instanceof CompositeFBType) {
            this.cmds.add((Command)new DeleteFBNetworkElementCommand((FBNetworkElement)((AdapterDeclaration)this.interfaceElement).getAdapterFB()));
        }
        this.performDeletion();
    }

    public void undo() {
        if (this.interfaceElement.isIsInput()) {
            if (this.interfaceElement instanceof Event) {
                this.parent.getEventInputs().add(this.oldIndex, (Object)((Event)this.interfaceElement));
            } else if (this.interfaceElement instanceof AdapterDeclaration) {
                this.parent.getSockets().add(this.oldIndex, (Object)((AdapterDeclaration)this.interfaceElement));
            } else if (this.interfaceElement instanceof VarDeclaration) {
                this.parent.getInputVars().add(this.oldIndex, (Object)((VarDeclaration)this.interfaceElement));
            } else if (this.interfaceElement instanceof ErrorMarkerInterface) {
                this.undoErrorMarker();
            }
        } else if (this.interfaceElement instanceof Event) {
            this.parent.getEventOutputs().add(this.oldIndex, (Object)((Event)this.interfaceElement));
        } else if (this.interfaceElement instanceof AdapterDeclaration) {
            this.parent.getPlugs().add(this.oldIndex, (Object)((AdapterDeclaration)this.interfaceElement));
        } else if (this.interfaceElement instanceof VarDeclaration) {
            this.parent.getOutputVars().add(this.oldIndex, (Object)((VarDeclaration)this.interfaceElement));
        } else if (this.interfaceElement instanceof ErrorMarkerInterface) {
            this.undoErrorMarker();
        }
        if (this.cmds.canUndo()) {
            this.cmds.undo();
        }
    }

    private void undoErrorMarker() {
        this.parent.getErrorMarker().add(this.oldIndex, (Object)this.interfaceElement);
        if (this.oldErrorMarker != null) {
            FordiacMarkerHelper.createMarkerInFile((ErrorMarkerBuilder)this.oldErrorMarker);
        }
    }

    public void redo() {
        this.performDeletion();
    }

    private void performDeletion() {
        if (this.interfaceElement.isIsInput()) {
            if (this.interfaceElement instanceof Event) {
                this.oldIndex = this.parent.getEventInputs().indexOf((Object)this.interfaceElement);
                this.parent.getEventInputs().remove((Object)this.interfaceElement);
            } else if (this.interfaceElement instanceof AdapterDeclaration) {
                this.oldIndex = this.parent.getSockets().indexOf((Object)this.interfaceElement);
                this.parent.getSockets().remove((Object)this.interfaceElement);
            } else if (this.interfaceElement instanceof VarDeclaration) {
                this.oldIndex = this.parent.getInputVars().indexOf((Object)this.interfaceElement);
                this.parent.getInputVars().remove((Object)this.interfaceElement);
            } else if (this.interfaceElement instanceof ErrorMarkerInterface) {
                this.deleteErrorMarker();
            }
        } else if (this.interfaceElement instanceof Event) {
            this.oldIndex = this.parent.getEventOutputs().indexOf((Object)this.interfaceElement);
            this.parent.getEventOutputs().remove((Object)this.interfaceElement);
        } else if (this.interfaceElement instanceof AdapterDeclaration) {
            this.oldIndex = this.parent.getPlugs().indexOf((Object)this.interfaceElement);
            this.parent.getPlugs().remove((Object)this.interfaceElement);
        } else if (this.interfaceElement instanceof VarDeclaration) {
            this.oldIndex = this.parent.getOutputVars().indexOf((Object)this.interfaceElement);
            this.parent.getOutputVars().remove((Object)this.interfaceElement);
        } else if (this.interfaceElement instanceof ErrorMarkerInterface) {
            this.deleteErrorMarker();
        }
        if (this.cmds.canExecute()) {
            this.cmds.execute();
        }
    }

    private void deleteErrorMarker() {
        this.oldErrorMarker = FordiacMarkerHelper.deleteErrorMarker((ErrorMarkerRef)((ErrorMarkerRef)this.interfaceElement));
        this.oldIndex = this.parent.getErrorMarker().indexOf((Object)this.interfaceElement);
        this.parent.getErrorMarker().remove((Object)this.interfaceElement);
    }

    private void handleSubAppConnections() {
        for (Connection con : this.interfaceElement.getInputConnections()) {
            this.cmds.add((Command)new DeleteConnectionCommand(con));
        }
        for (Connection con : this.interfaceElement.getOutputConnections()) {
            this.cmds.add((Command)new DeleteConnectionCommand(con));
        }
    }

    private void handleWiths() {
        block3: {
            block2: {
                if (!(this.interfaceElement instanceof VarDeclaration)) break block2;
                VarDeclaration varDecl = (VarDeclaration)this.interfaceElement;
                for (With with : varDecl.getWiths()) {
                    this.cmds.add((Command)new DeleteWithCommand(with));
                }
                break block3;
            }
            if (!(this.interfaceElement instanceof Event)) break block3;
            Event event = (Event)this.interfaceElement;
            for (With with : event.getWith()) {
                this.cmds.add((Command)new DeleteWithCommand(with));
            }
        }
    }
}

