/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.create.LinkConstraints;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;

public abstract class AbstractConnectionCreateCommand
extends Command {
    private final ConnectionRoutingData routingData;
    private FBNetwork parent;
    private Connection connection;
    private IInterfaceElement source;
    private IInterfaceElement destination;
    private boolean performMappingCheck;
    private AbstractConnectionCreateCommand mirroredConnection;

    protected AbstractConnectionCreateCommand(FBNetwork parent) {
        this.parent = parent;
        this.performMappingCheck = true;
        this.routingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
    }

    public void setArrangementConstraints(ConnectionRoutingData routingData) {
        this.routingData.setDx1(routingData.getDx1());
        this.routingData.setDx2(routingData.getDx1());
        this.routingData.setDy(routingData.getDy());
    }

    public void setSource(IInterfaceElement source) {
        this.source = source;
    }

    public IInterfaceElement getSource() {
        return this.source;
    }

    public void setDestination(IInterfaceElement target) {
        this.destination = target;
    }

    public IInterfaceElement getDestination() {
        return this.destination;
    }

    protected FBNetwork getParent() {
        return this.parent;
    }

    public boolean canExecute() {
        if (this.getSource() == null || this.getDestination() == null) {
            return false;
        }
        if (this.getSource() == this.getDestination()) {
            return false;
        }
        this.checkParent();
        if (this.checkUnfoldedSubAppConnections()) {
            return false;
        }
        return this.canExecuteConType();
    }

    private boolean checkUnfoldedSubAppConnections() {
        if (this.getSource().getFBNetworkElement() == null || this.getDestination().getFBNetworkElement() == null) {
            return false;
        }
        if (this.getSource().getFBNetworkElement().getFbNetwork() != this.getDestination().getFBNetworkElement().getFbNetwork()) {
            EObject srcContainer = null;
            EObject destContainer = null;
            if (this.getSource().eContainer().eContainer() instanceof SubApp) {
                srcContainer = this.getSource().eContainer().eContainer();
            }
            if (this.getDestination().eContainer().eContainer() instanceof SubApp) {
                destContainer = this.getDestination().eContainer().eContainer();
            }
            if (srcContainer == null && destContainer == null) {
                return true;
            }
            if (destContainer == null && srcContainer != this.getDestination().eContainer().eContainer().eContainer().eContainer()) {
                return true;
            }
            if (srcContainer == null && destContainer != this.getSource().eContainer().eContainer().eContainer().eContainer()) {
                return true;
            }
        }
        return false;
    }

    public void execute() {
        this.checkParent();
        this.checkSourceAndTarget();
        this.connection = this.createConnectionElement();
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        this.connection.setRoutingData(this.routingData);
        this.parent.addConnection(this.connection);
        if (this.performMappingCheck) {
            this.mirroredConnection = this.checkAndCreateMirroredConnection();
            if (this.mirroredConnection != null) {
                this.mirroredConnection.execute();
            }
        }
    }

    public void undo() {
        if (this.mirroredConnection != null) {
            this.mirroredConnection.undo();
        }
        this.connection.setSource(null);
        this.connection.setDestination(null);
        this.parent.removeConnection(this.connection);
    }

    public void redo() {
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        this.parent.addConnection(this.connection);
        if (this.mirroredConnection != null) {
            this.mirroredConnection.redo();
        }
    }

    private void checkSourceAndTarget() {
        if (LinkConstraints.isSwapNeeded(this.source, this.parent)) {
            IInterfaceElement buf = this.destination;
            this.destination = this.source;
            this.source = buf;
        }
    }

    private void checkParent() {
        FBNetwork dstNetwork;
        FBNetwork srcNetwork;
        FBNetworkElement srcElement = this.getSource().getFBNetworkElement();
        FBNetworkElement dstElement = this.getDestination().getFBNetworkElement();
        if (srcElement != null && dstElement != null && (srcElement instanceof SubApp || dstElement instanceof SubApp) && (srcNetwork = srcElement.getFbNetwork()) != (dstNetwork = dstElement.getFbNetwork())) {
            if (srcElement instanceof SubApp && ((SubApp)srcElement).getSubAppNetwork() == dstNetwork) {
                this.parent = dstNetwork;
            } else if (dstElement instanceof SubApp && ((SubApp)dstElement).getSubAppNetwork() == srcNetwork) {
                this.parent = srcNetwork;
            }
        }
    }

    protected abstract Connection createConnectionElement();

    private AbstractConnectionCreateCommand checkAndCreateMirroredConnection() {
        if (this.source.getFBNetworkElement() != null && this.destination.getFBNetworkElement() != null) {
            FBNetworkElement opSource = this.source.getFBNetworkElement().getOpposite();
            FBNetworkElement opDestination = this.destination.getFBNetworkElement().getOpposite();
            if (opSource != null && opDestination != null && opSource.getFbNetwork() == opDestination.getFbNetwork()) {
                AbstractConnectionCreateCommand cmd = this.createMirroredConnectionCommand(opSource.getFbNetwork());
                cmd.setPerformMappingCheck(false);
                cmd.setSource(opSource.getInterfaceElement(this.source.getName()));
                cmd.setDestination(opDestination.getInterfaceElement(this.destination.getName()));
                return cmd.canExecute() ? cmd : null;
            }
        }
        return null;
    }

    protected abstract AbstractConnectionCreateCommand createMirroredConnectionCommand(FBNetwork var1);

    protected abstract boolean canExecuteConType();

    private void setPerformMappingCheck(boolean performMappingCheck) {
        this.performMappingCheck = performMappingCheck;
    }
}

