/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.impl.FBTypePaletteEntryImpl;
import org.eclipse.fordiac.ide.model.commands.change.AbstractUpdateFBNElementCommand;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class UpdateFBTypeCommand
extends AbstractUpdateFBNElementCommand {
    public UpdateFBTypeCommand(FBNetworkElement fbnElement, PaletteEntry entry) {
        super(fbnElement);
        this.entry = entry instanceof FBTypePaletteEntry || entry instanceof SubApplicationTypePaletteEntry ? entry : fbnElement.getPaletteEntry();
    }

    public boolean canExecute() {
        if (this.entry == null || this.oldElement == null || this.network == null) {
            return false;
        }
        return FBNetworkHelper.isTypeInsertionSave((FBType)((FBType)this.entry.getType()), (EObject)this.network);
    }

    @Override
    protected void createNewFB() {
        this.newElement = this.createCopiedFBEntry(this.oldElement);
        this.setInterface();
        this.newElement.setName(this.oldElement.getName());
        this.newElement.setPosition((Position)EcoreUtil.copy((EObject)this.oldElement.getPosition()));
        this.createValues();
    }

    public void setInterface() {
        this.newElement.setInterface(this.newElement.getType().getInterfaceList().copy());
        if (this.newElement instanceof Multiplexer) {
            ((Multiplexer)this.newElement).setStructTypeElementsAtInterface((StructuredType)((VarDeclaration)((FBTypePaletteEntryImpl)this.entry).getFBType().getInterfaceList().getOutputVars().get(0)).getType());
        }
        if (this.newElement instanceof Demultiplexer) {
            ((Demultiplexer)this.newElement).setStructTypeElementsAtInterface((StructuredType)((VarDeclaration)((FBTypePaletteEntryImpl)this.entry).getFBType().getInterfaceList().getInputVars().get(0)).getType());
        }
    }

    protected void setEntry(PaletteEntry entry) {
        this.entry = entry;
    }

    protected PaletteEntry getEntry() {
        return this.entry;
    }

    protected FBNetworkElement createCopiedFBEntry(FBNetworkElement srcElement) {
        Object copy;
        if (this.invalidType()) {
            copy = LibraryElementFactory.eINSTANCE.createErrorMarkerFBNElement();
        } else if (this.entry instanceof SubApplicationTypePaletteEntry) {
            copy = LibraryElementFactory.eINSTANCE.createSubApp();
        } else if (this.entry instanceof AdapterTypePaletteEntry) {
            copy = LibraryElementFactory.eINSTANCE.createAdapterFB();
            ((AdapterFB)copy).setAdapterDecl(((AdapterFB)srcElement).getAdapterDecl());
        } else {
            copy = this.entry.getType() instanceof CompositeFBType ? LibraryElementFactory.eINSTANCE.createCFBInstance() : (this.isMultiplexer() ? this.createMultiplexer() : LibraryElementFactory.eINSTANCE.createFB());
        }
        copy.setPaletteEntry(this.entry);
        return copy;
    }

    public boolean invalidType() {
        return (this.entry.getFile() == null || !this.entry.getFile().exists()) && !this.reloadErrorType();
    }

    private FBNetworkElement createMultiplexer() {
        Object structManipulator = "STRUCT_MUX".equals(this.entry.getType().getName()) ? LibraryElementFactory.eINSTANCE.createMultiplexer() : LibraryElementFactory.eINSTANCE.createDemultiplexer();
        return structManipulator;
    }

    private boolean isMultiplexer() {
        return this.entry instanceof FBTypePaletteEntryImpl && this.entry.getType() instanceof ServiceInterfaceFBType && this.entry.getType().getName().startsWith("STRUCT");
    }

    public boolean reloadErrorType() {
        TypeLibrary typeLibrary = this.entry.getTypeLibrary();
        PaletteEntry reloadedType = typeLibrary.find(this.entry.getLabel());
        if (reloadedType != null && reloadedType.getFile() != null && reloadedType.getFile().exists()) {
            typeLibrary.getErrorTypeLib().removePaletteEntry(this.entry);
            this.entry = reloadedType;
            return true;
        }
        return false;
    }
}

