/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.dataimport.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerRef;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.validation.ValueValidator;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;

public class ChangeValueCommand
extends Command {
    private static final String CHANGE = Messages.ChangeValueCommand_LABEL_ChangeValue;
    private VarDeclaration variable;
    private VarDeclaration mirroredVar;
    private String newValue;
    private String oldValue;
    private ErrorMarkerBuilder oldErrorMarker;

    public ChangeValueCommand(VarDeclaration variable, String value) {
        this.variable = variable;
        this.newValue = value == null ? "" : value;
    }

    public boolean canExecute() {
        if (this.variable == null || this.variable.getType() == null) {
            return false;
        }
        if (!this.newValue.isBlank()) {
            if (IecTypes.GenericTypes.ANY == this.variable.getType() && !this.newValue.contains("#")) {
                ErrorMessenger.popUpErrorMessage((String)Messages.ChangeValueCommand_ConstantValuesNoAllowedOnAny);
                return false;
            }
            String validationMsg = ValueValidator.validateValue((DataType)this.variable.getType(), (String)this.newValue);
            if (validationMsg != null && !validationMsg.trim().isEmpty()) {
                ErrorMessenger.popUpErrorMessage((String)validationMsg);
                return false;
            }
        }
        return true;
    }

    public ChangeValueCommand() {
        super(CHANGE);
    }

    public void execute() {
        this.mirroredVar = this.getMirroredVariable();
        if (this.variable.getValue() == null) {
            this.variable.setValue(LibraryElementFactory.eINSTANCE.createValue());
            if (this.mirroredVar != null) {
                this.mirroredVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
            }
            this.oldValue = "";
        } else {
            this.oldValue = this.variable.getValue().getValue();
        }
        this.variable.getValue().setValue(this.newValue);
        this.setMirroredVar(this.newValue);
        this.handleErrorMarker();
    }

    public void undo() {
        this.variable.getValue().setValue(this.oldValue);
        this.setMirroredVar(this.oldValue);
        this.restoreErrorMarker();
    }

    public void redo() {
        this.variable.getValue().setValue(this.newValue);
        this.setMirroredVar(this.newValue);
        this.handleErrorMarker();
    }

    private VarDeclaration getMirroredVariable() {
        IInterfaceElement element;
        FBNetworkElement opposite;
        if (this.variable.getFBNetworkElement() != null && this.variable.getFBNetworkElement().isMapped() && (opposite = this.variable.getFBNetworkElement().getOpposite()) != null && (element = opposite.getInterfaceElement(this.variable.getName())) instanceof VarDeclaration) {
            return (VarDeclaration)element;
        }
        return null;
    }

    private void setMirroredVar(String val) {
        if (this.mirroredVar != null) {
            this.mirroredVar.getValue().setValue(val);
        }
    }

    private void handleErrorMarker() {
        if (this.variable.getValue().hasError()) {
            this.oldErrorMarker = FordiacMarkerHelper.deleteErrorMarker((ErrorMarkerRef)this.variable.getValue());
        }
    }

    private void restoreErrorMarker() {
        if (this.oldErrorMarker != null) {
            FordiacMarkerHelper.createMarkerInFile((ErrorMarkerBuilder)this.oldErrorMarker);
        }
    }
}

