/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;

public abstract class AbstractReconnectConnectionCommand
extends Command {
    private final FBNetwork parent;
    private final Connection connection;
    private final boolean isSourceReconect;
    private final IInterfaceElement newTarget;
    private DeleteConnectionCommand deleteConnectionCmd;
    private AbstractConnectionCreateCommand connectionCreateCmd;

    protected AbstractReconnectConnectionCommand(String label, ReconnectRequest request, FBNetwork parent) {
        this(label, (Connection)request.getConnectionEditPart().getModel(), request.getType().equals("Reconnection source"), AbstractReconnectConnectionCommand.getRequestTarget(request), parent);
    }

    protected AbstractReconnectConnectionCommand(String label, Connection connection, boolean isSourceReconnect, IInterfaceElement newTarget, FBNetwork parent) {
        super(label);
        this.connection = connection;
        this.isSourceReconect = isSourceReconnect;
        this.newTarget = newTarget;
        this.parent = parent;
    }

    protected FBNetwork getParent() {
        return this.parent;
    }

    public boolean canExecute() {
        IInterfaceElement sourceIE = this.getNewSource();
        IInterfaceElement targetIE = this.getNewDestination();
        if (sourceIE != null && targetIE != null) {
            return this.checkSourceAndTarget(sourceIE, targetIE);
        }
        return false;
    }

    public IInterfaceElement getNewSource() {
        if (!this.isSourceReconect) {
            return this.getConnnection().getSource();
        }
        return this.newTarget;
    }

    public IInterfaceElement getNewDestination() {
        if (this.isSourceReconect) {
            return this.getConnnection().getDestination();
        }
        return this.newTarget;
    }

    protected Connection getConnnection() {
        return this.connection;
    }

    private static IInterfaceElement getRequestTarget(ReconnectRequest request) {
        EditPart target = request.getTarget();
        if (target.getModel() instanceof IInterfaceElement) {
            return (IInterfaceElement)target.getModel();
        }
        return null;
    }

    public boolean canRedo() {
        return true;
    }

    public void execute() {
        Connection con = this.getConnnection();
        this.deleteConnectionCmd = new DeleteConnectionCommand(con);
        this.connectionCreateCmd = this.createConnectionCreateCommand(this.parent);
        this.connectionCreateCmd.setSource(this.getNewSource());
        this.connectionCreateCmd.setDestination(this.getNewDestination());
        this.connectionCreateCmd.setArrangementConstraints(con.getRoutingData());
        this.connectionCreateCmd.execute();
        this.deleteConnectionCmd.execute();
    }

    public void redo() {
        this.connectionCreateCmd.redo();
        this.deleteConnectionCmd.redo();
    }

    public void undo() {
        this.deleteConnectionCmd.undo();
        this.connectionCreateCmd.undo();
    }

    protected abstract AbstractConnectionCreateCommand createConnectionCreateCommand(FBNetwork var1);

    protected abstract boolean checkSourceAndTarget(IInterfaceElement var1, IInterfaceElement var2);
}

