/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.draw2d.ConnectorBorder;
import org.eclipse.fordiac.ide.gef.draw2d.SetableAlphaLabel;
import org.eclipse.fordiac.ide.gef.editparts.AbstractConnectableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ConnCreateDirectEditDragTrackerProxy;
import org.eclipse.fordiac.ide.gef.editparts.IDeactivatableConnectionHandleRoleEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.gef.figures.ToolTipFigure;
import org.eclipse.fordiac.ide.gef.policies.DataInterfaceLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.InterfaceElementSelectionPolicy;
import org.eclipse.fordiac.ide.gef.policies.ValueEditPartChangeEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.jface.util.IPropertyChangeListener;

public abstract class InterfaceEditPart
extends AbstractConnectableEditPart
implements NodeEditPart,
IDeactivatableConnectionHandleRoleEditPart {
    private ValueEditPart referencedPart;
    private int mouseState;
    private Adapter contentAdapter = null;
    private IInterfaceElement sourcePin = null;
    private Adapter sourcePinAdapter = null;
    private boolean showInstanceName = Activator.getDefault().getPreferenceStore().getBoolean("ShowCommentAtPin");
    private final IPropertyChangeListener preferenceListener = event -> {
        if (event.getProperty().equals("ShowCommentAtPin")) {
            this.showInstanceName = (Boolean)event.getNewValue();
            this.refreshLabelText();
        }
    };

    protected InterfaceEditPart() {
        this.setConnectable(true);
        this.addPreferenceListener();
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new ConnCreateDirectEditDragTrackerProxy((EditPart)this);
    }

    public int getMouseState() {
        return this.mouseState;
    }

    protected void refreshTargetConnections() {
        this.updateSourcePinAdapter();
        super.refreshTargetConnections();
        if (this.getReferencedValueEditPart() != null) {
            this.getReferencedValueEditPart().refreshValue();
        }
    }

    protected String getLabelText() {
        String comment = this.getSourcePinInstanceName();
        if (this.isShowInput() && !comment.isBlank()) {
            return comment;
        }
        return this.getModel().getName();
    }

    private void refreshLabelText() {
        ((InterfaceFigure)this.getFigure()).setText(this.getLabelText());
    }

    private boolean isShowInput() {
        return this.showInstanceName && this.isInput() && !this.getModel().getInputConnections().isEmpty();
    }

    private void addPreferenceListener() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
    }

    private String getSourcePinInstanceName() {
        IInterfaceElement refPin = this.getSourcePin();
        if (refPin != null) {
            FBNetworkElement source = refPin.getFBNetworkElement();
            String pinName = refPin.getName();
            if (source != null && !this.isSubAppPin(source)) {
                String elementName = source.getName();
                return String.valueOf(elementName) + "." + pinName;
            }
            return pinName;
        }
        return "";
    }

    private IInterfaceElement getSourcePin() {
        EList inputConnections = this.getModel().getInputConnections();
        if (!inputConnections.isEmpty()) {
            return ((Connection)inputConnections.get(0)).getSource();
        }
        return null;
    }

    private boolean isSubAppPin(FBNetworkElement connSource) {
        if (connSource instanceof SubApp && this.getModel().getFBNetworkElement() != null) {
            return ((SubApp)connSource).getSubAppNetwork() == this.getModel().getFBNetworkElement().getFbNetwork();
        }
        return false;
    }

    protected IFigure createFigure() {
        return new InterfaceFigure();
    }

    protected void refreshVisuals() {
        this.refreshLabelText();
    }

    protected abstract GraphicalNodeEditPolicy getNodeEditPolicy();

    public void setInOutConnectionsWidth(int width) {
        this.getSourceConnections().forEach(cep -> InterfaceEditPart.checkConnection(width, (ConnectionEditPart)cep));
        this.getTargetConnections().forEach(cep -> InterfaceEditPart.checkConnection(width, (ConnectionEditPart)cep));
    }

    private static void checkConnection(int width, ConnectionEditPart cep) {
        if (cep.getFigure() instanceof PolylineConnection) {
            ((PolylineConnection)cep.getFigure()).setLineWidth(width);
        }
    }

    @Override
    protected void createEditPolicies() {
        GraphicalNodeEditPolicy nodeEditPolicy = this.getNodeEditPolicy();
        if (nodeEditPolicy != null) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)nodeEditPolicy);
        }
        this.installEditPolicy("Selection Feedback", (EditPolicy)new InterfaceElementSelectionPolicy(this));
        if (this.isVariable()) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.getLayoutPolicy());
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ValueEditPartChangeEditPolicy(){

                @Override
                protected ValueEditPart getValueEditPart() {
                    return InterfaceEditPart.this.getReferencedValueEditPart();
                }
            });
        }
    }

    protected LayoutEditPolicy getLayoutPolicy() {
        return new DataInterfaceLayoutEditPolicy();
    }

    @Override
    public void setConnectionHandleRoleEnabled(boolean enabled) {
    }

    public IInterfaceElement getModel() {
        return (IInterfaceElement)super.getModel();
    }

    public boolean isInput() {
        return this.getModel().isIsInput();
    }

    public boolean isEvent() {
        return this.getModel() instanceof Event;
    }

    public boolean isAdapter() {
        return this.getModel() instanceof AdapterDeclaration;
    }

    public boolean isVariable() {
        return this.getModel() instanceof VarDeclaration;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
    }

    private Adapter getContentAdapter() {
        if (this.contentAdapter == null) {
            this.contentAdapter = this.createContentAdapter();
        }
        return this.contentAdapter;
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getIInterfaceElement_InputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_OutputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature)) {
                    InterfaceEditPart.this.refresh();
                }
                super.notifyChanged(notification);
            }
        };
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
            this.addSourcePinAdapter();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
            this.removeSourcePinAdapter();
        }
        this.referencedPart = null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    protected List<?> getModelSourceConnections() {
        if (!this.isInput()) {
            return this.getModel().getOutputConnections();
        }
        return Collections.emptyList();
    }

    protected List<?> getModelTargetConnections() {
        if (this.isInput()) {
            return this.getModel().getInputConnections();
        }
        return Collections.emptyList();
    }

    public void performRequest(Request request) {
        request.getType();
        if (request.getType() == "direct edit" || request.getType() == "open") {
            ValueEditPart part = this.getReferencedValueEditPart();
            if (part != null && this.isVariable() && !(this.getModel() instanceof AdapterDeclaration)) {
                part.performRequest(request);
            }
        } else {
            super.performRequest(request);
        }
    }

    public ValueEditPart getReferencedValueEditPart() {
        Object temp;
        if (this.referencedPart == null && this.getModel() instanceof VarDeclaration && (temp = this.getViewer().getEditPartRegistry().get(((VarDeclaration)this.getModel()).getValue())) instanceof ValueEditPart) {
            this.referencedPart = (ValueEditPart)((Object)temp);
        }
        return this.referencedPart;
    }

    private void addSourcePinAdapter() {
        if (this.isShowInput()) {
            this.sourcePin = this.getSourcePin();
            if (this.sourcePin != null) {
                this.sourcePin.eAdapters().add((Object)this.getSourcePinAdapter());
                FBNetworkElement sourceElement = this.sourcePin.getFBNetworkElement();
                if (sourceElement != null) {
                    sourceElement.eAdapters().add((Object)this.getSourcePinAdapter());
                }
            }
        }
    }

    private void removeSourcePinAdapter() {
        if (this.sourcePin != null) {
            this.sourcePin.eAdapters().remove((Object)this.getSourcePinAdapter());
            FBNetworkElement sourceElement = this.sourcePin.getFBNetworkElement();
            if (sourceElement != null) {
                sourceElement.eAdapters().remove((Object)this.getSourcePinAdapter());
            }
            this.sourcePin = null;
        }
    }

    private void updateSourcePinAdapter() {
        if (this.sourcePin != this.getSourcePin()) {
            this.removeSourcePinAdapter();
            this.addSourcePinAdapter();
        }
    }

    private Adapter getSourcePinAdapter() {
        if (this.sourcePinAdapter == null) {
            this.sourcePinAdapter = this.createSourcePinAdapter();
        }
        return this.sourcePinAdapter;
    }

    private Adapter createSourcePinAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature)) {
                    InterfaceEditPart.this.refreshLabelText();
                }
            }
        };
    }

    protected void updatePadding(int yPosition) {
        IFigure paddingFigure = (IFigure)this.getFigure().getParent().getChildren().get(0);
        int textHeight = ((InterfaceFigure)this.getFigure()).getTextBounds().height();
        paddingFigure.setMinimumSize(new Dimension(-1, yPosition - textHeight));
    }

    protected static int getYPositionFromAttribute(IInterfaceElement ie) {
        Attribute attribute = ie.getAttribute("YPOSITION");
        if (attribute != null) {
            return Integer.parseInt(attribute.getValue());
        }
        return 0;
    }

    public class InterfaceFigure
    extends SetableAlphaLabel {
        public InterfaceFigure() {
            this.setOpaque(false);
            this.setText(InterfaceEditPart.this.getLabelText());
            this.setBorder((Border)new ConnectorBorder(InterfaceEditPart.this.getModel()));
            if (InterfaceEditPart.this.isInput()) {
                this.setLabelAlignment(1);
                this.setTextAlignment(1);
            } else {
                this.setLabelAlignment(4);
                this.setTextAlignment(4);
            }
            this.setToolTip((IFigure)new ToolTipFigure((INamedElement)InterfaceEditPart.this.getModel()));
            if (InterfaceEditPart.this.isAdapter()) {
                this.addMouseMotionListener(new MouseMotionListener(){

                    public void mouseDragged(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseEntered(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseExited(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseHover(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseMoved(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }
                });
            }
        }
    }
}

