/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.compare;

import java.io.File;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.fordiac.ide.export.ICompareEditorOpener;
import org.eclipse.fordiac.ide.export.compare.Activator;
import org.eclipse.fordiac.ide.export.compare.EditorInput;
import org.eclipse.fordiac.ide.export.compare.Messages;

public class DefaultCompareEditorOpener
implements ICompareEditorOpener {
    private String name;
    private String title;
    private File original;
    private File newlyGenerated;

    public boolean hasDifferences() {
        EditorInput input = this.createInput();
        try {
            input.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Activator.getDefault().logError(e.getMessage(), e);
            return false;
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return false;
        }
        return input.getCompareResult() != null;
    }

    private EditorInput createInput() {
        CompareConfiguration compareConfig = new CompareConfiguration();
        compareConfig.setLeftEditable(true);
        compareConfig.setLeftLabel(String.valueOf(Messages.DefaultCompareEditorOpener_NEWLY_Exported) + this.name);
        compareConfig.setRightEditable(false);
        compareConfig.setRightLabel(String.valueOf(Messages.DefaultCompareEditorOpener_ORIGINAL_FILE) + this.name);
        EditorInput input = new EditorInput(compareConfig, this.original, this.newlyGenerated);
        input.setTitle(this.title);
        return input;
    }

    public void openCompareEditor() {
        EditorInput input = this.createInput();
        CompareUI.openCompareEditor((CompareEditorInput)input);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setNewFile(File newFile) {
        this.newlyGenerated = newFile;
    }

    public void setOriginalFile(File original) {
        this.original = original;
    }
}

