/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.wizard;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fordiac.ide.deployment.ui.Activator;
import org.eclipse.fordiac.ide.deployment.ui.Messages;
import org.eclipse.fordiac.ide.deployment.ui.wizard.BootFileDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.ui.wizard.CreateBootFilesWizardPage;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class CreateBootfilesWizard
extends Wizard
implements IExportWizard {
    private static final String FORDIAC_CREATE_BOOTFILES_SECTION = "4DIAC_CREATE_BOOTFILES_SECTION";
    private IStructuredSelection selection;
    private CreateBootFilesWizardPage bootFilePage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = new StructuredSelection(selection.toList());
        this.setWindowTitle(Messages.FordiacCreateBootfilesWizard_LABEL_Window_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.getSection(FORDIAC_CREATE_BOOTFILES_SECTION) != null) {
            settings.addNewSection(FORDIAC_CREATE_BOOTFILES_SECTION);
        }
        this.setDialogSettings(settings);
    }

    public void addPages() {
        super.addPages();
        this.bootFilePage = new CreateBootFilesWizardPage(this.selection);
        this.addPage((IWizardPage)this.bootFilePage);
    }

    public boolean performFinish() {
        IRunnableWithProgress iop = monitor -> {
            String outputDirectory = this.bootFilePage.getDirectory();
            Map<Device, List<Object>> workLoad = this.prepareWorkload();
            monitor.beginTask(Messages.CreateBootfilesWizard_GeneratingBootFilesForTheSelectedResources, workLoad.size());
            for (Map.Entry<Device, List<Object>> entry : workLoad.entrySet()) {
                String fileName = MessageFormat.format(Messages.CreateBootfilesWizard_IProgressMonitorMonitor, outputDirectory, Character.valueOf(File.separatorChar), entry.getKey().getAutomationSystem().getName(), entry.getKey().getName());
                BootFileDeviceManagementCommunicationHandler.createBootFile(entry.getValue(), fileName, this.getShell());
                monitor.worked(1);
            }
            monitor.done();
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, iop);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.showExceptionErrorDialog(e);
        }
        catch (Exception e) {
            this.showExceptionErrorDialog(e);
        }
        return true;
    }

    protected void showExceptionErrorDialog(Exception e) {
        MessageBox msg = new MessageBox(this.getShell(), 1);
        msg.setMessage(String.valueOf(Messages.CreateBootfilesWizard_BootFileCreationError) + e.getMessage());
        msg.open();
        Activator.getDefault().logError(msg.getMessage(), e);
    }

    private Map<Device, List<Object>> prepareWorkload() {
        Object[] selectedElements = this.bootFilePage.getSelectedElements();
        HashMap<Device, List<Object>> workLoad = new HashMap<Device, List<Object>>();
        Object[] objectArray = selectedElements;
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof Resource) {
                CreateBootfilesWizard.insertResource(workLoad, (Resource)object);
            } else if (object instanceof Device) {
                CreateBootfilesWizard.getWorkLoadEntryList(workLoad, (Device)object).add(object);
            }
            ++n2;
        }
        return workLoad;
    }

    private static void insertResource(Map<Device, List<Object>> workLoad, Resource res) {
        List<Object> resList = CreateBootfilesWizard.getWorkLoadEntryList(workLoad, res.getDevice());
        resList.add(res);
    }

    private static List<Object> getWorkLoadEntryList(Map<Device, List<Object>> workLoad, Device device) {
        return workLoad.computeIfAbsent(device, dev -> new ArrayList());
    }
}

