/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class FocusOnPredecessor
extends AbstractHandler {
    private static final int HALF_TRANSPERENT = 50;
    private static final int NON_TRANSPARENT = 255;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HashSet<ConfigurableObject> elementToHighlight = new HashSet<ConfigurableObject>();
        FocusOnPredecessor.getPredecessorFBNetworkElements(FocusOnPredecessor.getSelectedFBElement(event), elementToHighlight);
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Map map = HandlerHelper.getViewer((IEditorPart)editor).getEditPartRegistry();
        for (Map.Entry entry : map.entrySet()) {
            int transparency;
            Object obj = entry.getKey();
            Object editPartAsObject = entry.getValue();
            int n = transparency = elementToHighlight.contains(obj) ? 255 : 50;
            if (editPartAsObject instanceof AbstractViewEditPart) {
                ((AbstractViewEditPart)editPartAsObject).setTransparency(transparency);
                continue;
            }
            if (!(editPartAsObject instanceof ConnectionEditPart)) continue;
            ((ConnectionEditPart)((Object)editPartAsObject)).setTransparency(transparency);
        }
        return null;
    }

    private static void getPredecessorFBNetworkElements(FBNetworkElement element, Set<ConfigurableObject> elementToHighlight) {
        if (element != null) {
            elementToHighlight.add((ConfigurableObject)element);
            for (VarDeclaration inVar : element.getInterface().getInputVars()) {
                for (Connection con : inVar.getInputConnections()) {
                    FBNetworkElement sourceElement;
                    IInterfaceElement source = con.getSource();
                    if (source == null || (sourceElement = source.getFBNetworkElement()) == null) continue;
                    elementToHighlight.add((ConfigurableObject)con);
                    if (elementToHighlight.contains(sourceElement)) continue;
                    FocusOnPredecessor.getPredecessorFBNetworkElements(sourceElement, elementToHighlight);
                }
            }
        }
    }

    private static FBNetworkElement getSelectedFBElement(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            Object selObj = ((StructuredSelection)selection).getFirstElement();
            if (selObj instanceof EditPart) {
                selObj = ((EditPart)selObj).getModel();
            }
            if (selObj instanceof FBNetworkElement) {
                return (FBNetworkElement)selObj;
            }
        }
        return null;
    }
}

