/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.figures.FBNetworkElementTooltipFigure;
import org.eclipse.fordiac.ide.application.figures.InstanceNameFigure;
import org.eclipse.fordiac.ide.gef.draw2d.ITransparencyFigure;
import org.eclipse.fordiac.ide.gef.figures.FBShape;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class FBNetworkElementFigure
extends FBShape
implements ITransparencyFigure {
    private FBNetworkElement model = null;

    public static void openTypeInEditor(FBNetworkElement element) {
        PaletteEntry entry = element.getPaletteEntry();
        if (entry != null) {
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
            EditorUtils.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), (String)desc.getId());
        }
    }

    protected FBNetworkElement getModel() {
        return this.model;
    }

    public FBNetworkElementFigure(FBNetworkElement model, AbstractFBNElementEditPart editPart) {
        super(model.getType());
        this.model = model;
        this.refreshToolTips();
        if (editPart != null) {
            this.setupMouseListener(editPart);
        }
    }

    private void setupMouseListener(final AbstractFBNElementEditPart editPart) {
        this.getMiddle().addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                if ((me.getState() & 0x40000) != 0 && editPart.isOnlyThisOrNothingSelected()) {
                    FBNetworkElementFigure.this.getTypeLabel().setDrawUnderline(true);
                }
            }

            public void mouseExited(MouseEvent me) {
                FBNetworkElementFigure.this.getTypeLabel().setDrawUnderline(false);
            }

            public void mouseHover(MouseEvent me) {
                this.mouseMoved(me);
            }

            public void mouseMoved(MouseEvent me) {
                if ((me.getState() & 0x40000) != 0 && editPart.isOnlyThisOrNothingSelected()) {
                    if (!FBNetworkElementFigure.this.getTypeLabel().isDrawUnderline()) {
                        FBNetworkElementFigure.this.getTypeLabel().setDrawUnderline(true);
                    }
                } else if (FBNetworkElementFigure.this.getTypeLabel().isDrawUnderline()) {
                    FBNetworkElementFigure.this.getTypeLabel().setDrawUnderline(false);
                }
            }
        });
        this.getMiddle().addMouseListener((MouseListener)FBNetworkElementFigure.createOpenTypeMouseListener(editPart));
    }

    private static OpenTypeListener createOpenTypeMouseListener(AbstractFBNElementEditPart editPart) {
        return new OpenTypeListener(editPart);
    }

    public final void refreshToolTips() {
        this.setToolTip((IFigure)new FBNetworkElementTooltipFigure(this.model));
    }

    public void setTransparency(int value) {
        this.setAlpha(value);
    }

    public int getTransparency() {
        return this.getAlpha();
    }

    public Rectangle getFBBounds() {
        int x = this.getTop().getBounds().x();
        int y = this.getLabelBounds().y();
        int width = this.getTop().getBounds().width;
        int height = this.getTop().getBounds().height() + this.getMiddle().getBounds().height() + this.getBottom().getBounds().height() + this.getLabelBounds().height();
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getLabelBounds() {
        for (Object figure : this.getChildren()) {
            if (!(figure instanceof InstanceNameFigure)) continue;
            return ((InstanceNameFigure)((Object)figure)).getBounds();
        }
        return new Rectangle();
    }

    private static final class OpenTypeListener
    implements MouseListener {
        private final AbstractFBNElementEditPart editPart;

        public OpenTypeListener(AbstractFBNElementEditPart editPart) {
            this.editPart = editPart;
        }

        public void mousePressed(MouseEvent me) {
            if ((me.getState() & 0x40000) != 0 && this.editPart.isOnlyThisOrNothingSelected()) {
                FBNetworkElementFigure.openTypeInEditor(this.editPart.getModel());
            }
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }
}

