/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkRootEditPart;
import org.eclipse.fordiac.ide.application.editparts.InstanceComment;
import org.eclipse.fordiac.ide.application.editparts.InstanceCommentEditPart;
import org.eclipse.fordiac.ide.application.figures.InstanceCommentFigure;
import org.eclipse.fordiac.ide.gef.draw2d.SingleLineBorder;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.events.ControlListener;

public abstract class EditorWithInterfaceEditPart
extends AbstractFBNetworkEditPart {
    private static final int MIN_INTERFACE_BAR_WIDTH = 200;
    private static final int TOP_BOTTOM_MARGIN = 1;
    private static final int LEFT_RIGHT_MARGIN = 10;
    private static final Insets RIGHT_LIST_BORDER_INSET = new Insets(1, 0, 1, 10);
    private static final Insets LEFT_LIST_BORDER_INSET = new Insets(1, 10, 1, 0);
    private static final int BASE_WIDTH = 400;
    private static final int BASE_HEIGHT = 200;
    private Figure leftInterfaceContainer;
    private Figure leftEventContainer;
    private Figure leftVarContainer;
    private Figure leftAdapterContainer;
    private Figure rightInterfaceContainer;
    private Figure rightEventContainer;
    private Figure rightVarContainer;
    private Figure rightAdapterContainer;
    private FreeformLayer contentContainer;
    private ControlListener controlListener;
    private InstanceComment instanceComment;
    private Figure commentContainer;

    protected IFigure createFigure() {
        Figure mainFigure = new Figure();
        InterfaceBarLayout mainLayout = new InterfaceBarLayout();
        mainLayout.setVerticalSpacing(-1);
        mainFigure.setLayoutManager((LayoutManager)mainLayout);
        mainFigure.setOpaque(false);
        this.createLeftInterface((IFigure)mainFigure);
        this.contentContainer = new FreeformLayer();
        this.contentContainer.setLayoutManager((LayoutManager)new FreeformLayout());
        mainFigure.add((IFigure)this.contentContainer, (Object)BorderLayout.CENTER);
        this.createRightInterface((IFigure)mainFigure);
        this.createCommentContainer((IFigure)mainFigure);
        IFigure root = super.createFigure();
        root.setBorder(null);
        root.add((IFigure)mainFigure);
        root.setConstraint((IFigure)mainFigure, (Object)new Rectangle(0, 0, -1, -1));
        return root;
    }

    private void createLeftInterface(IFigure mainFigure) {
        this.leftInterfaceContainer = EditorWithInterfaceEditPart.createRootContainer(mainFigure, BorderLayout.LEFT);
        EditorWithInterfaceEditPart.configureLeftContainer(this.leftInterfaceContainer);
        Figure leftInnerContainer = EditorWithInterfaceEditPart.createInnerContainer((IFigure)this.leftInterfaceContainer, LEFT_LIST_BORDER_INSET);
        EditorWithInterfaceEditPart.configureLeftContainer(leftInnerContainer);
        this.leftEventContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)leftInnerContainer);
        EditorWithInterfaceEditPart.configureLeftContainer(this.leftEventContainer);
        this.leftVarContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)leftInnerContainer);
        EditorWithInterfaceEditPart.configureLeftContainer(this.leftVarContainer);
        this.leftAdapterContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)leftInnerContainer);
        EditorWithInterfaceEditPart.configureLeftContainer(this.leftAdapterContainer);
    }

    private void createRightInterface(IFigure mainFigure) {
        this.rightInterfaceContainer = EditorWithInterfaceEditPart.createRootContainer(mainFigure, BorderLayout.RIGHT);
        Figure rightInnerContainer = EditorWithInterfaceEditPart.createInnerContainer((IFigure)this.rightInterfaceContainer, RIGHT_LIST_BORDER_INSET);
        this.rightEventContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)rightInnerContainer);
        this.rightVarContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)rightInnerContainer);
        this.rightAdapterContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)rightInnerContainer);
    }

    private static Figure createRootContainer(IFigure parent, Integer layoutConstraint) {
        Figure rootContainer = new Figure();
        rootContainer.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        rootContainer.setOpaque(true);
        rootContainer.setBorder((Border)new SingleLineBorder());
        parent.add((IFigure)rootContainer, (Object)layoutConstraint);
        return rootContainer;
    }

    private static void configureLeftContainer(Figure container) {
        ((ToolbarLayout)container.getLayoutManager()).setMinorAlignment(2);
    }

    private static Figure createInnerContainer(IFigure parent, Insets borderInset) {
        MinSizeFigure innerContainer = new MinSizeFigure();
        innerContainer.setMinimumSize(new Dimension(200, -1));
        ToolbarLayout innerLayout = new ToolbarLayout(false);
        innerContainer.setLayoutManager((LayoutManager)innerLayout);
        innerContainer.setBorder((Border)new MarginBorder(borderInset));
        parent.add((IFigure)innerContainer);
        return innerContainer;
    }

    private static Figure createInterfaceElementsContainer(IFigure parent) {
        Figure container = new Figure();
        container.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        parent.add((IFigure)container);
        return container;
    }

    private void createCommentContainer(IFigure mainFigure) {
        this.commentContainer = new Figure();
        SingleLineBorder border = new SingleLineBorder(){
            private final Insets insets = new Insets(5);

            public Insets getInsets(IFigure figure) {
                return this.insets;
            }
        };
        this.commentContainer.setBorder((Border)border);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(false);
        this.commentContainer.setOpaque(true);
        this.commentContainer.setLayoutManager((LayoutManager)layout);
        mainFigure.add((IFigure)this.commentContainer, (Object)BorderLayout.TOP);
    }

    public Figure getLeftInterfaceContainer() {
        return this.leftInterfaceContainer;
    }

    public Figure getLeftEventInterfaceContainer() {
        return this.leftEventContainer;
    }

    public Figure getLeftVarInterfaceContainer() {
        return this.leftVarContainer;
    }

    public Figure getLeftAdapterInterfaceContainer() {
        return this.leftAdapterContainer;
    }

    public Figure getRightInterfaceContainer() {
        return this.rightInterfaceContainer;
    }

    public Figure getRightEventInterfaceContainer() {
        return this.rightEventContainer;
    }

    public Figure getRightVarInterfaceContainer() {
        return this.rightVarContainer;
    }

    public Figure getRightAdapterInterfaceContainer() {
        return this.rightAdapterContainer;
    }

    public FreeformLayer getContentPane() {
        return this.contentContainer;
    }

    protected abstract InterfaceList getInterfaceList();

    protected List<?> getModelChildren() {
        if (this.getModel() != null) {
            ArrayList<InstanceComment> children = new ArrayList<InstanceComment>(super.getModelChildren());
            InterfaceList ifList = this.getInterfaceList();
            children.addAll((Collection<InstanceComment>)ifList.getEventInputs());
            children.addAll((Collection<InstanceComment>)ifList.getEventOutputs());
            children.addAll((Collection<InstanceComment>)ifList.getInputVars());
            children.addAll((Collection<InstanceComment>)ifList.getOutputVars());
            if (this.showAdapterPorts()) {
                children.addAll((Collection<InstanceComment>)ifList.getPlugs());
                children.addAll((Collection<InstanceComment>)ifList.getSockets());
            }
            if (this.isInstance()) {
                children.add(this.getInstanceComment());
            }
            return children;
        }
        return Collections.emptyList();
    }

    private boolean isInstance() {
        return this.getModel().eContainer() instanceof FBNetworkElement;
    }

    private InstanceComment getInstanceComment() {
        if (this.instanceComment == null) {
            this.instanceComment = new InstanceComment((FBNetworkElement)this.getModel().eContainer());
        }
        return this.instanceComment;
    }

    private boolean showAdapterPorts() {
        return !(this.getModel().eContainer() instanceof CompositeFBType) || this.getModel().eContainer() instanceof SubAppType;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof InterfaceEditPart) {
            this.addChildVisualInterfaceElement((InterfaceEditPart)childEditPart);
        } else if (childEditPart instanceof InstanceCommentEditPart) {
            InstanceCommentFigure commentFigure = ((InstanceCommentEditPart)childEditPart).getFigure();
            commentFigure.setBorder(null);
            this.commentContainer.add((IFigure)commentFigure);
        } else {
            super.addChildVisual(childEditPart, index);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.controlListener != null && this.getParent() != null && this.getParent().getViewer() != null && this.getParent().getViewer().getControl() != null) {
            this.getParent().getViewer().getControl().removeControlListener(this.controlListener);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof InterfaceEditPart) {
            this.removeChildVisualInterfaceElement((InterfaceEditPart)childEditPart);
        } else if (childEditPart instanceof InstanceCommentEditPart) {
            this.commentContainer.remove((IFigure)((InstanceCommentEditPart)childEditPart).getFigure());
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    public void removeChildVisualInterfaceElement(InterfaceEditPart childEditPart) {
        IFigure child = childEditPart.getFigure().getParent();
        Figure container = this.getChildVisualContainer(childEditPart);
        if (child.getParent() == container) {
            container.remove(child);
        } else {
            this.getContentPane().remove(child);
        }
    }

    protected Figure getChildVisualContainer(InterfaceEditPart childEditPart) {
        if (childEditPart.getModel().isIsInput()) {
            if (childEditPart.isEvent()) {
                return this.getLeftEventInterfaceContainer();
            }
            if (childEditPart.isAdapter()) {
                return this.showAdapterPorts() ? this.getLeftAdapterInterfaceContainer() : this.getLeftInterfaceContainer();
            }
            return this.getLeftVarInterfaceContainer();
        }
        if (childEditPart.isEvent()) {
            return this.getRightEventInterfaceContainer();
        }
        if (childEditPart.isAdapter()) {
            return this.showAdapterPorts() ? this.getRightAdapterInterfaceContainer() : this.getRightInterfaceContainer();
        }
        return this.getRightVarInterfaceContainer();
    }

    public void addChildVisualInterfaceElement(InterfaceEditPart childEditPart) {
        IFigure child = childEditPart.getFigure();
        InterfaceList ifList = this.getInterfaceList();
        Figure targetFigure = this.getChildVisualContainer(childEditPart);
        int index = 0;
        index = childEditPart.getModel().isIsInput() ? (childEditPart.isEvent() ? ifList.getEventInputs().indexOf((Object)childEditPart.getModel()) : (childEditPart.isAdapter() ? ifList.getSockets().indexOf((Object)childEditPart.getModel()) : ifList.getInputVars().indexOf((Object)childEditPart.getModel()))) : (childEditPart.isEvent() ? ifList.getEventOutputs().indexOf((Object)childEditPart.getModel()) : (childEditPart.isAdapter() ? ifList.getPlugs().indexOf((Object)childEditPart.getModel()) : ifList.getOutputVars().indexOf((Object)childEditPart.getModel())));
        int containerSize = targetFigure.getChildren().size();
        targetFigure.add(EditorWithInterfaceEditPart.createSideBarFigure(childEditPart), index >= containerSize ? containerSize : index);
        child.setVisible(this.isVarVisible((EditPart)childEditPart));
    }

    private static IFigure createSideBarFigure(InterfaceEditPart ep) {
        Figure container = new Figure();
        container.setLayoutManager((LayoutManager)new ToolbarLayout());
        int yPositionFromAttribute = EditorWithInterfaceEditPart.getYPositionFromAttribute(ep.getModel());
        if (yPositionFromAttribute > 0) {
            MinSizeFigure paddingFigure = new MinSizeFigure();
            paddingFigure.setMinimumSize(new Dimension(-1, yPositionFromAttribute));
            container.add((IFigure)paddingFigure);
        }
        container.add(ep.getFigure());
        return container;
    }

    private static int getYPositionFromAttribute(IInterfaceElement ie) {
        Attribute attribute = ie.getAttribute("YPOSITION");
        if (attribute != null) {
            return Integer.parseInt(attribute.getValue());
        }
        return 0;
    }

    protected boolean isVarVisible(EditPart childEditPart) {
        return true;
    }

    public void performRequest(Request request) {
        if ((request.getType() == "direct edit" || request.getType() == "open") && request instanceof SelectionRequest) {
            ((FBNetworkRootEditPart)this.getParent()).performDirectEdit((SelectionRequest)request);
        } else {
            super.performRequest(request);
        }
    }

    public DragTracker getDragTracker(Request req) {
        return this.getParent().getDragTracker(req);
    }

    protected void refreshVisuals() {
        List<EditPart> ies = this.getChildren().stream().filter(InterfaceEditPart.class::isInstance).collect(Collectors.toList());
        ies.forEach(arg_0 -> ((EditorWithInterfaceEditPart)this).removeChild(arg_0));
        ies.forEach(ie -> this.addChild((EditPart)ie, -1));
    }

    private class InterfaceBarLayout
    extends BorderLayout {
        private InterfaceBarLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            Rectangle newBounds = new Rectangle();
            newBounds.setSize(super.calculatePreferredSize(figure, wHint, hHint));
            newBounds.setLocation(EditorWithInterfaceEditPart.this.getContentPane().getFreeformExtent().getLocation());
            newBounds.x -= EditorWithInterfaceEditPart.this.leftInterfaceContainer.getPreferredSize().width;
            newBounds.y -= EditorWithInterfaceEditPart.this.commentContainer.getPreferredSize().height;
            if (newBounds.x > 0) {
                newBounds.x = 0;
            }
            if (newBounds.y > 0) {
                newBounds.y = 0;
            }
            FreeformLayer layer = (FreeformLayer)EditorWithInterfaceEditPart.this.getLayer("Feedback Layer");
            layer.validate();
            newBounds.union(layer.getFreeformExtent());
            layer = (FreeformLayer)EditorWithInterfaceEditPart.this.getLayer("Handle Layer");
            layer.validate();
            newBounds.union(layer.getFreeformExtent());
            newBounds.shrink(EditorWithInterfaceEditPart.this.leftInterfaceContainer.getInsets());
            Rectangle resultingBounds = this.calculateModuloExtent(newBounds);
            figure.getParent().setConstraint(figure, (Object)new Rectangle(resultingBounds.x, resultingBounds.y, -1, -1));
            return resultingBounds.getSize();
        }

        private Rectangle calculateModuloExtent(Rectangle newBounds) {
            int x = this.calcAxisOrigin(newBounds.x, 400);
            int y = this.calcAxisOrigin(newBounds.y, 200);
            int width = this.calcAxisExtent(newBounds.x, x, newBounds.width, 400);
            int height = this.calcAxisExtent(newBounds.y, y, newBounds.height, 200);
            return new Rectangle(x, y, width, height);
        }

        private int calcAxisExtent(int baseOrigin, int newOrigin, int sourceExtent, int baseUnit) {
            int startExtent = sourceExtent + baseOrigin - newOrigin;
            int newExtend = (startExtent / baseUnit + 1) * baseUnit;
            if (newExtend < 3 * baseUnit) {
                newExtend = 3 * baseUnit;
            }
            return newExtend;
        }

        private int calcAxisOrigin(int axisPos, int baseUnit) {
            if (axisPos < 0) {
                return (axisPos / baseUnit - 1) * baseUnit;
            }
            return axisPos / baseUnit * baseUnit;
        }
    }

    private static class MinSizeFigure
    extends Figure {
        private MinSizeFigure() {
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Dimension prefSize = super.getPreferredSize(wHint, hHint);
            prefSize.union(this.getMinimumSize());
            return prefSize;
        }
    }
}

