/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)__vTBL_rsqrt.c	1.3	06/01/31 SMI"

#pragma align 32 (__vlibm_TBL_rsqrt)

/*
 i = [0,128]
 TBL[2*i  ] = (double)(1.0 / sqrtl(*(double*)&(0x3fe0000000000000LL + (i << 46))));
 TBL[2*i+1] = (double)(1.0 / sqrtl(*(double*)&(0x3fe0000000000000LL + (i << 46))) - TBL[2*i]);
*/

const double __vlibm_TBL_rsqrt[] = {
 1.4142135623730951455e+00, -9.6672933134529134511e-17,
 1.4032928308912466786e+00,  6.4948026279769118919e-17,
 1.3926212476455828160e+00, -1.1055881989569260189e-16,
 1.3821894809301762397e+00, -6.3734410461405640301e-17,
 1.3719886811400707760e+00, -7.6980807939588139983e-17,
 1.3620104492139977204e+00,  2.8850217265224690802e-17,
 1.3522468075656264297e+00,  9.4322960168092127774e-17,
 1.3426901732747025253e+00,  4.7150841580269266495e-18,
 1.3333333333333332593e+00,  7.4014868308343765253e-17,
 1.3241694217637887121e+00,  7.7131873618846925903e-18,
 1.3151918984428583315e+00, -2.0328800352543524759e-17,
 1.3063945294843617440e+00, -9.1582083631189420602e-17,
 1.2977713690461003537e+00, -4.8412149406758561904e-17,
 1.2893167424406084542e+00,  2.3274915882478143921e-17,
 1.2810252304406970492e+00,  1.8704771066280918649e-17,
 1.2728916546811681609e+00, -8.8457926431820830415e-17,
 1.2649110640673517647e+00, -3.1906346897860143141e-17,
 1.2570787221094177344e+00,  8.6769863266554017163e-17,
 1.2493900951088485751e+00, -5.0929983362732175622e-17,
 1.2418408411301324890e+00,  8.8840637867087758165e-17,
 1.2344267996967352996e+00, -1.7516410189877601154e-17,
 1.2271439821557927896e+00, -9.0396673750943792696e-17,
 1.2199885626608373279e+00,  2.7575041782657058896e-18,
 1.2129568697262453902e+00,  5.0766000649864922701e-17,
 1.2060453783110545167e+00, -2.6141724617295359467e-17,
 1.1992507023933782762e+00,  3.5079005878814235254e-17,
 1.1925695879998878812e+00, -4.3139588510944642176e-17,
 1.1859989066577618644e+00,  2.2700827457352136295e-17,
 1.1795356492391770864e+00, -1.8736930872699025425e-17,
 1.1731769201708264205e+00, -1.0717525135280878089e-16,
 1.1669199319831564665e+00, -1.9717488453279445066e-17,
 1.1607620001760186046e+00,  7.0604910402531185787e-17,
 1.1547005383792514621e+00,  6.6900561478712689458e-17,
 1.1487330537883810866e+00, -1.1022220198146414245e-16,
 1.1428571428571427937e+00,  6.3441315692866084503e-17,
 1.1370704872299222110e+00,  1.0524397995692614457e-16,
 1.1313708498984760276e+00,  1.1479495462389219323e-17,
 1.1257560715684669095e+00,  6.0574394710210801304e-17,
 1.1202240672224077489e+00,  9.3922898547554319150e-17,
 1.1147728228665882977e+00, -4.5491044078590048284e-17,
 1.1094003924504582947e+00, -5.0709657003823779908e-17,
 1.1041048949477667573e+00, -8.8666430365492392908e-18,
 1.0988845115895122806e+00, -8.8730050685366661178e-17,
 1.0937374832394612945e+00, -1.0139924803906119049e-16,
 1.0886621079036347126e+00, -2.3035347176474180687e-18,
 1.0836567383657542685e+00, -9.7789672372212451307e-17,
 1.0787197799411873955e+00, -5.7527821233647078927e-17,
 1.0738496883424388795e+00,  1.9216919863927710029e-17,
 1.0690449676496975862e+00, -4.7415720102268737205e-17,
 1.0643041683803828867e+00, -3.0438242811018816132e-19,
 1.0596258856520350822e+00, -3.6947737086388254690e-17,
 1.0550087574332591700e+00,  3.7548847295491266968e-17,
 1.0504514628777803509e+00,  1.0231500228552561044e-16,
 1.0459527207369814228e+00,  8.0806674896943551777e-17,
 1.0415112878465908608e+00,  7.8292411070687721348e-17,
 1.0371259576834630511e+00, -2.6664053809928624719e-17,
 1.0327955589886446131e+00, -1.1033761728824692438e-16,
 1.0285189544531601058e+00, -7.0307587734203009158e-17,
 1.0242950394631678002e+00, -1.0770393913594349379e-17,
 1.0201227409013413627e+00, -9.8717216425570547616e-17,
 1.0160010160015240377e+00, -3.5150724174046424206e-17,
 1.0119288512538813229e+00,  6.3292764451724411186e-17,
 1.0079052613579393416e+00, -6.9021193162451496902e-17,
 1.0039292882210537616e+00, -6.9245436618476016139e-17,
 1.0000000000000000000e+00,  0.0000000000000000000e+00,
 9.9227787671366762812e-01,  2.1405178579048182592e-17,
 9.8473192783466190203e-01, -4.0158639458782051420e-17,
 9.7735555485044178781e-01, -3.4924457286878990179e-19,
 9.7014250014533187638e-01,  1.7693410507027811240e-17,
 9.6308682468615358641e-01,  1.9691102487554127121e-17,
 9.5618288746751489704e-01,  1.4935376108861049295e-17,
 9.4942532655508271588e-01, -5.3278073247766967031e-17,
 9.4280904158206335630e-01,  9.5662462186576827694e-18,
 9.3632917756904454620e-01, -3.4655680606790736102e-17,
 9.2998110995055427441e-01, -2.8820206372616569176e-17,
 9.2376043070340119190e-01,  3.1315988690467019525e-17,
 9.1766293548224708854e-01, -2.4907828666661326139e-17,
 9.1168461167710357351e-01,  1.7178891233165183242e-17,
 9.0582162731567661407e-01, -1.3578665987704751967e-17,
 9.0007032074081916306e-01, -3.9003513621620290514e-17,
 8.9442719099991585541e-01,  2.3156459848049343849e-17,
 8.8888888888888883955e-01,  4.9343245538895843502e-17,
 8.8345220859877238162e-01, -2.7808199947420238654e-17,
 8.7811407991752277180e-01,  1.2001012979479060187e-17,
 8.7287156094396955996e-01, -3.4900338036123033814e-17,
 8.6772183127462465535e-01,  3.2650033503527982608e-17,
 8.6266218562750729415e-01,  3.1665473509444755614e-17,
 8.5769002787023584933e-01,  1.6930198090043138729e-17,
 8.5280286542244176928e-01, -3.2089317494821048697e-17,
 8.4799830400508802164e-01, -3.8599776100732649845e-17,
 8.4327404271156780613e-01,  1.5736536222265119505e-17,
 8.3862786937753464045e-01, -3.8316227580533944669e-18,
 8.3405765622829908246e-01, -3.1744458177500410304e-17,
 8.2956135578434020417e-01,  1.0522097091084975821e-17,
 8.2513699700703468931e-01,  3.6488948923760358306e-17,
 8.2078268166812329287e-01, -1.6507622733959848503e-17,
 8.1649658092772603446e-01, -1.7276510382355637441e-18,
 8.1227693210689522196e-01,  1.2819865235943699943e-17,
 8.0812203564176865456e-01, -5.5241676076873786747e-17,
 8.0403025220736967782e-01, -1.7427816411530239645e-17,
 8.0000000000000004441e-01, -4.4408920985006264082e-17,
 7.9602975216799132241e-01, -1.3876860654527447191e-17,
 7.9211803438133943089e-01,  1.6428787126265500350e-17,
 7.8826342253143455441e-01, -3.2571002717425679181e-17,
 7.8446454055273617811e-01, -5.0417296289807987128e-17,
 7.8072005835882651859e-01,  2.4898247108034524775e-17,
 7.7702868988581130782e-01,  3.6763699589769887870e-17,
 7.7338919123653082632e-01,  4.9918835031221789176e-17,
 7.6980035891950104876e-01, -2.9414493989201982553e-17,
 7.6626102817692109959e-01,  1.4524522292996552738e-17,
 7.6277007139647390321e-01, -5.0856154603265522966e-17,
 7.5932639660199918730e-01,  8.9842992531287086391e-18,
 7.5592894601845450619e-01, -5.1765894871838619595e-17,
 7.5257669470687782454e-01,  9.6579665081799721467e-18,
 7.4926864926535519107e-01, -1.8380676468162380710e-17,
 7.4600384659225105199e-01, -3.9485726539632463848e-17,
 7.4278135270820744296e-01,  9.6276948503597478238e-18,
 7.3960026163363878915e-01,  4.0208430305794580702e-17,
 7.3645969431865865307e-01,  4.0077997112003520937e-17,
 7.3335879762256905856e-01, -2.2493399096927370000e-17,
 7.3029674334022143256e-01,  5.2048227304015206987e-17,
 7.2727272727272729291e-01, -2.0185873175002846750e-17,
 7.2428596834014824513e-01,  2.3633090263928220565e-18,
 7.2133570773394584119e-01, -9.5131613777431479940e-18,
 7.1842120810709964029e-01, -3.7440154323260191964e-17,
 7.1554175279993270653e-01, -3.6792926140636546510e-18,
 7.1269664509979835376e-01,  5.3969540859927280847e-18,
 7.0988520753289097165e-01,  4.4593566535489654887e-17,
 7.0710678118654757274e-01, -4.8336466567264567255e-17,
};

