**Note:** This file is automatically generated. Please see the [developer
documentation](doc/development/changelog.md) for instructions on adding your own
entry.

## 17.6.5 (2025-02-11)

### Security (7 changes)

- [Security Duo Chat Escape Unknown Domain Hyperlinks](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cdb737c04cdf611b2f6818a294b7157039adcce8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4692))
- [Hide sensitive workhorse headers and fix route confusion between web and workhorse routes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/dd5fb5b4e217868aa8602acee276883ae8e42126) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4763))
- [Reduce memory allocations on create PAT endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d86c90fdfee1aef2eaa958ddc9e0ba379f8e221e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4752))
- [Prevent SSRF attacks for Workspaces](https://gitlab.com/gitlab-org/security/gitlab/-/commit/16659a9efb33ec22055b927fd716f5acc80361e9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4731))
- [Prevent read code access when repository is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ff08db2dd2efa55e4e868591c61c144ec3febe32) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4701))
- [Fixes XSS on the target branch in the merge request widget](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1cc0ad7a4f3f0ab44dd959a58b3ed63786037a06) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4737))
- [Unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/security/gitlab/-/commit/26fff506ff66eedea4dc911eb1c9f4686d643650) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4727))

## 17.6.4 (2025-01-22)

### Fixed (2 changes)

- [Add BoardEpicConnection type policy for pagination](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0fc02660321fef5d2fee627bd9b81c0aaca62a82) **GitLab Enterprise Edition**
- [Fix handling of short gzip metadata files](https://gitlab.com/gitlab-org/security/gitlab/-/commit/09c5801a07e2dcbd48a44ea97cb56aa6fb141105)

### Security (4 changes)

- [Fix protected variable exfiltration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/da2d664ff802e6c961a8e463f39d5b7f179ba0f7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4715))
- [Enhance rich viewer sanitization](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fca347dbd3660d89b1a58d39e1cf4ce680363988) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4710))
- [Avoid recursive sidekiq calls on cyclic work item hierarchies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/db1de035fb5ddfee1849a411020f22f5808e811b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4660))
- [Respect the private profile constraints](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e834095ace85698c4c32f915e280158bb0ae9e88) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4699))

### Other (1 change)

- [Reorder migrations for ci_deleted_objects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/313e91e2a458db2ebcab4a8bb57384467ee295be)

## 17.6.3 (2025-01-08)

### Fixed (2 changes)

- [Backport bugfix for diff_files highlighting](https://gitlab.com/gitlab-org/security/gitlab/-/commit/827c6864e66e9aa4b97f488212f6bb01a3d62342)
- [Fix ability to use password for Git when password for Web is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ba71cf797b32dedfcf83b31af1a09939c12a796c)

### Security (4 changes)

- [Prevent cyclic reference in work item hierarchy widget from frontend](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3eeb33ecc4af1392f8df5ada5ff5447d177bc030) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4685))
- [Allow external_provider config take precedence over external_groups](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e69bec763b1eac5995a0355fac8b6f7a6918cffc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4657))
- [Filter out sensitive parameters on Auth logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2a5927933b15993e61c45f31c86b2416dd16c0d1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4666))
- [Don't allow unauthorized users to close issues automatically](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f5bb3a32dd675185c9072a27313e9fb03fb9fe14) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4675))

## 17.6.2 (2024-12-10)

### Fixed (2 changes)

- [Add guard clause to Wiki#find_page when title is nil](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1be99d9925c659f168dccb4b2cfb3510ac74e7ed)
- [Fix 401 errors when installing the GitLab for Jira app](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8e15de4128733083fe3bf640751aecf95d5471a7)

### Security (11 changes)

- [Add timeout around Parslet in template parser](https://gitlab.com/gitlab-org/security/gitlab/-/commit/74de080527cf262ecec44e97c78705953cfa1cdc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4653))
- [Add authorization check to protectableBranches field](https://gitlab.com/gitlab-org/security/gitlab/-/commit/16152cf39642bd4dc9ed023d52493c9522ef87f2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4652))
- [Check harbor name & digest for path traversal](https://gitlab.com/gitlab-org/security/gitlab/-/commit/734520792bc637580fd79ce2d368268501382d76) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4629))
- [Ignore titles for GFM links in rich text editor](https://gitlab.com/gitlab-org/security/gitlab/-/commit/769b309ded5f3fca7f550ef9972750cd60298b73) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4649))
- [Restrict user and group creation when same pages unique domain exist](https://gitlab.com/gitlab-org/security/gitlab/-/commit/09997ce510251b8f58343464143e40f1f5ed00c2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4618))
- [DoS by repeatedly sending unauthenticated requests for diff-files of a commit or merge request](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c0045078225c4b64fa1dd2582c246df5b7b4a96a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4639))
- [Add query to filter_parameters](https://gitlab.com/gitlab-org/security/gitlab/-/commit/32485a34d6f3ee22fdbe20d0a41cd6b10f0cd511) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4625))
- [Added invalid redirect fragment check](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5c69fef592ceab17eaeda04fd78e120116229b03) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4609))
- [Make confidential threads unresolvable via new issue](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1396d48051a02153a9bd064d39d2d5c09233f3c6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4633))
- [Do not set session cookie for /v2 endpoints in the response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3305b0fafe245a02fa01a5b882e8ad5b565f8736) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4630))
- [HTML injection in vulnerability details, leads to XSS on self hosted servers](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4284532cd6ae8f0166806a81628887f82756ceef) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4619))

## 17.6.1 (2024-11-26)

### Security (6 changes)

- [Add size check for harbor registry](https://gitlab.com/gitlab-org/security/gitlab/-/commit/48579cdb744f994dc0fb2b4f96b1ada3e94a59e6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4614))
- [Adding JobArtifactReport class to pre-emptively validate job artifacts](https://gitlab.com/gitlab-org/security/gitlab/-/commit/83f0e6c1ea1ea6a82e8cf7bdfec0944990f8ec23) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4616))
- [Fix: unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/security/gitlab/-/commit/302ed663e0d9a68c413732e9d7a260b6be1b477d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4621))
- [Allow a LFS token to be used only for LFS related requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/800c79606ab237536ea5cf9a29e541855fc01477) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4613))
- [Fix possible DOS with TOML file parsing](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7b6057a43cd11aae5a5e8f2f91c76a90a4310ec2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4617))
- [Move allow_access_with_scope to class level](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b70cb1e7d430bbbcd8da22b33e7d07cb136189d7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4610))

## 17.6.0 (2024-11-20)

### Added (181 changes)

- [Added type and controls column to requirements and api](https://gitlab.com/gitlab-org/gitlab/-/commit/fcfffdfd869631a4d50e8ccec61dae675557e6ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168478)) **GitLab Enterprise Edition**
- [Allow Sidekiq workers to be disabled by default by configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/64cd00b6fa19b93f420b8153af81b73543f4db7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166652)) **GitLab Enterprise Edition**
- [Remove nuget_extract_nuget_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e2c9f8c0afaf438f37013e31dd4e6ac2d884a6d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172379))
- [Introduce rotation of personal tokens in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/b70f9cd3ff08e4a0a186d505efaa99dc57c000d7) by @shangsuru ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169954))
- [Add worker for member deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/1588f2a9107f4d7b3e0d2f7aee106539649e94b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170820))
- [Adds ciJobTokenScopeAllowlistEntry graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/6edad95e175c72ad3dce1ccd644d8613608c9132) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171497))
- [Update docs to reflect workspaces private container registry support](https://gitlab.com/gitlab-org/gitlab/-/commit/152ec4a7fdea53412fb44732898a87ecfbed3005) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172538))
- [Track epic syncing errors](https://gitlab.com/gitlab-org/gitlab/-/commit/30edaa6801e5d028d8f3ccb7c879828f1aeb1bb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172416)) **GitLab Enterprise Edition**
- [Create ci_runner_tags table](https://gitlab.com/gitlab-org/gitlab/-/commit/3cea0d49e9e3ff470a082528389fff863efca8c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170778))
- [Add ai_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/e829797f9e65f2d198503532d649c84e1fbadadb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172007))
- [Add network polling and pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/ca4822a38aae9cc532b4d20b2cf1a47849921ec6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172143))
- [Added API for Project Security Settings](https://gitlab.com/gitlab-org/gitlab/-/commit/ccfdaeaa4501a8a015a10ea02b00745d1af00df5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171499)) **GitLab Enterprise Edition**
- [Add sep concurrency control documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/c585b437b5b259aa8a5400241c0d9fc0b775926a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161383))
- [Add DORA projects comparison panel to group Value Streams Dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/14eda95a20db647150ecc662e9ed64c10181344d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172118)) **GitLab Enterprise Edition**
- [Add missing fields to WorkspaceType](https://gitlab.com/gitlab-org/gitlab/-/commit/8f1d3b2f24e9de198010ff797cab3480d8c47f98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170854)) **GitLab Enterprise Edition**
- [Update routes to redirect to duo home](https://gitlab.com/gitlab-org/gitlab/-/commit/16f3699d941baa05008a75607add0925209c30b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169501)) **GitLab Enterprise Edition**
- [Support workspace suspension](https://gitlab.com/gitlab-org/gitlab/-/commit/ed88fc037fb7bffc5b6438e7afbb485a03219635) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166065))
- [Backfill security policies table from YAML](https://gitlab.com/gitlab-org/gitlab/-/commit/57407e3fca30a761dc4294aa60e756b1410e1fb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164575)) **GitLab Enterprise Edition**
- [Add spdx column to software_license_policies table](https://gitlab.com/gitlab-org/gitlab/-/commit/03e556c7cdc18bf9fa4c43a45f1aa95471a68926) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171584)) **GitLab Enterprise Edition**
- [Create streamers for audit events streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/0845e8639b122a36a07fa1a3b8f3f2e6efbcc43a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171430)) **GitLab Enterprise Edition**
- [Add job to create missing ExternalIssueLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/3824743972cabee76cf0af2b602242ed20340710) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167564)) **GitLab Enterprise Edition**
- [Persist add on seat assignments records on CH](https://gitlab.com/gitlab-org/gitlab/-/commit/0b08706c845049826ef9392d271b69b610fc4aec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171552)) **GitLab Enterprise Edition**
- [Add base importers for GitHub import user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/a2412081ac03faebd0a0f40224da863edf98ec34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171910))
- [Add rake task to enable work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/c07ad51cec5a6cd7a77eca9b6c8cbd9fa978f3a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169457)) **GitLab Enterprise Edition**
- [Sync Application Settings seat_control value with new_user_signups_cap](https://gitlab.com/gitlab-org/gitlab/-/commit/211f556d0ab7361466328598c289d74658d70702) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172293)) **GitLab Enterprise Edition**
- [Protected packages: Integrate push package protection for conan packages](https://gitlab.com/gitlab-org/gitlab/-/commit/8d8299ff6a9de9d6649703c26f28d913e1b6bbb3) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168224))
- [Backfill project bot user details bot namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/7f5392b6cabd1086240d9a98d46d34b14f612bb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171326))
- [Add placeholder field for work_item related merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/15e86c65acf52ede91ca71ba09f3286157676529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172428))
- [Remove feature flag unblock_rules_using_execution_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e3042c239a34cd3bd6b7c82e025ea82c90f5c9f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172403)) **GitLab Enterprise Edition**
- [Claude 3.5 Haiku model addition gitlab-rails](https://gitlab.com/gitlab-org/gitlab/-/commit/7647a899c279074d915054c860d03c8c3387cdb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171918)) **GitLab Enterprise Edition**
- [Add support for changing group contact source (for CRM)](https://gitlab.com/gitlab-org/gitlab/-/commit/b546410ec20f9e0d42d964f88f3adea8b0a3f152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167475))
- [Add Conda to supported SBoM PURL_TYPES](https://gitlab.com/gitlab-org/gitlab/-/commit/dcaa6b1e31bc2d37a2c0f8c38e61490141927ba7) by @duncanmmacleod ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172109)) **GitLab Enterprise Edition**
- [Add webhook for creating a repo (project)](https://gitlab.com/gitlab-org/gitlab/-/commit/e28cc17f2441f19117e0eaa7ed659c8c7b55e7bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160887)) **GitLab Enterprise Edition**
- [Expose KAS Kubernetes API Proxy URL in metadata APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/fe2cfa8ac063845f9c9f9d707140ce3692a90db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172373))
- [Include model changes and graphql arg for filter by identifier name](https://gitlab.com/gitlab-org/gitlab/-/commit/31f39dae4f63a4f5b6be2cd480b676d41c344f96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171463)) **GitLab Enterprise Edition**
- [User Mapping: Add warning about reasssignments being permanent](https://gitlab.com/gitlab-org/gitlab/-/commit/8c674a68a798e2b0876347404a6bfab9f5930842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172023))
- [Add frameworks tab at project compliance center](https://gitlab.com/gitlab-org/gitlab/-/commit/4051dd84f6cbba2b7e821a51919b52911c5b205d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172326)) **GitLab Enterprise Edition**
- [Add filter by group inside compliance center projects tab](https://gitlab.com/gitlab-org/gitlab/-/commit/80bf146d1348ad4a9bc3064b5009519261ae3a3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172341)) **GitLab Enterprise Edition**
- [Show comment tooltips for markdown links to comments](https://gitlab.com/gitlab-org/gitlab/-/commit/59b3262993c5e1a452fbaee19b052c2162c727c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171353))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/f78ef4ddebd99bd95d56f3c58b78ee05aa25924a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172336))
- [GitHub importer add backticks to imported notes](https://gitlab.com/gitlab-org/gitlab/-/commit/3ff8e1872928fcb4ddabff5d7d0a9b2f6a440d3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171550))
- [Adds user_seat_management setting](https://gitlab.com/gitlab-org/gitlab/-/commit/c95b5457a83c5295e716f9b6384109fc796fdef0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171932))
- [Add frontend and controllers for scheduled merge](https://gitlab.com/gitlab-org/gitlab/-/commit/2a04ffdd32afafd7d77c24bd7f84adffbdff006d) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165250))
- [Create is_known_exploit column in pm_cve_enrichment and add tests](https://gitlab.com/gitlab-org/gitlab/-/commit/47e2136325b66053edbf883508213d0c001ceb57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171519))
- [Allow to regenerate the schema from the beginning by loading init schema](https://gitlab.com/gitlab-org/gitlab/-/commit/9733087af2606593e91bb479480fae903fd0243a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172059))
- [Enable FF true for VR filter in the vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/891e9acac91fc56f43941bf7f32fd5b83dd2aed1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171718)) **GitLab Enterprise Edition**
- [Add licenses without spdx to custom software license table](https://gitlab.com/gitlab-org/gitlab/-/commit/2617b545770682b3f8033056ec1960bfdaee40f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171528))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/ba7875928bbced1c8db500dacc4dd5fc1ed80ee5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172015))
- [Adding adherence check for DAST scanner on UI](https://gitlab.com/gitlab-org/gitlab/-/commit/758c0a6f6f64761c124cbf85cbbaa5211010240a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171650)) **GitLab Enterprise Edition**
- [Add paper trail to seat assignment models](https://gitlab.com/gitlab-org/gitlab/-/commit/25878117ae9508d8858e9ec8d19f7410ba0b83f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169180))
- [Add policy_tuning into merge request approval policies documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/2efd9e8b0dcc87eb076ef8bf5ca18febde71946e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171829))
- [Adds Members::DeletionSchedule model](https://gitlab.com/gitlab-org/gitlab/-/commit/e23307aa25fe4796592b725c49c7a033651c7bc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170268))
- [Allow non-epics to use new related item](https://gitlab.com/gitlab-org/gitlab/-/commit/2bbd07405194716f4a8550203549ca3244e70f1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171264))
- [Model registry: Add actions to models table](https://gitlab.com/gitlab-org/gitlab/-/commit/ac453dcaa5b2665863b33a1d852d113a1510889a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171284))
- [Backfill ci_runner_machines_687967fa8a partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/6b4ac23a93e53b6328801b661b424938b131458a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171901))
- [Add DORA projects comparison analytics dashboard visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/914e25dd87704cf16bd7178341de9ccbdc89b194) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170810)) **GitLab Enterprise Edition**
- [Enable internal Repository X-Ray service](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd8100ae8a7c81337cc455673a7da75bf9db3d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171878))
- [Display project visibility level](https://gitlab.com/gitlab-org/gitlab/-/commit/d2b2fffe9ce55b764d59eb266d22b96720310c66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171749))
- [Enable admin agnostic token finder](https://gitlab.com/gitlab-org/gitlab/-/commit/94e73b4671ecf85e266ea61bf84bfe832f5e4fe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171406))
- [Consolidate audit event streaming strategies to streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/c4e6a892324d4b58ef587c611d221c47ab72bea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171429)) **GitLab Enterprise Edition**
- [Added validation for streaming destinations on secret token](https://gitlab.com/gitlab-org/gitlab/-/commit/51fb0374af8c166623a3c3b82ebd00f64d573c7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143914)) **GitLab Enterprise Edition**
- [Create todos for expiring and expired SSH keys](https://gitlab.com/gitlab-org/gitlab/-/commit/bafda91d715f980215b9af246d46c9fa1b6bd53a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171826))
- [Log current organization id](https://gitlab.com/gitlab-org/gitlab/-/commit/e9f48f37c44860ea6c9a92e523ba0ae9a3368019) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171256))
- [Adds syntax highlight support to richt text editor diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/2342bf264de82802bedf5ec0fb2ff849e3678391) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171276))
- [Model registry: Add artifacts tab on Version card](https://gitlab.com/gitlab-org/gitlab/-/commit/d71910c1845ed3711fe9ed1b3efb5a06595966fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169445))
- [Add application settings to allowlist integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/7186906fd32d1092c9991d48a011d8edc0e9de15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171617)) **GitLab Enterprise Edition**
- [Added headers hash for http destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/b4cf955d2bae8b05ca4465585e77bdfd8815976e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165160))
- [Render description column as HTML in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/47e65fb4737e9cd7e007a3093e45953299b1fc6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168256))
- [Backfill p_ci_runners table](https://gitlab.com/gitlab-org/gitlab/-/commit/676e40c4dfa0071d4931b25ddbaf1375e59baeb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166520))
- [chore: Adding changelog](https://gitlab.com/gitlab-org/gitlab/-/commit/4840c17151498f3e27bfcc627c74b6e55eae48da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157084))
- [Update package registry list to show accurate number of error packages](https://gitlab.com/gitlab-org/gitlab/-/commit/005d93c0874cc457f1b9486619469b61aed27210) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171225))
- [Unset auto-resolved status on Vulnerability when unresolving](https://gitlab.com/gitlab-org/gitlab/-/commit/847a858a8eb80804313974d959d92fc2d7d8bc1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171696)) **GitLab Enterprise Edition**
- [Allow maintainers to admin notes in group level issues](https://gitlab.com/gitlab-org/gitlab/-/commit/e32d44fe83eca20872b03103a859365e14cf38bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171678))
- [Add standards adherence lighthouse metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/cc5ba5db548ed5123c66c2b6f2aa22bd2d673252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168865)) **GitLab Enterprise Edition**
- [Add sorting component for deployments](https://gitlab.com/gitlab-org/gitlab/-/commit/d8c4f3b3735c8fe27f05966d70409f7528afbbfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170650))
- [Adding adherence check for SAST scanner on UI](https://gitlab.com/gitlab-org/gitlab/-/commit/0c159e5ed0df3575c9eede174eb042e68cd94c64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171072)) **GitLab Enterprise Edition**
- [Add limit to concurrent batch exports](https://gitlab.com/gitlab-org/gitlab/-/commit/b247b441d69f189f53523c4b5f440e9d946d82dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169122))
- [Add VSA StageAggregation model](https://gitlab.com/gitlab-org/gitlab/-/commit/6d3fc2dfb2c4c4ce1d7021a3fd7d8112284303a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170988))
- [Add mark_internal_note permission to note](https://gitlab.com/gitlab-org/gitlab/-/commit/a825d8d865f728f06755022f8575fbd0fb9818e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171084))
- [Create Projects::DeployTokens::RevokeService](https://gitlab.com/gitlab-org/gitlab/-/commit/9e070e6df6878eefad1c8a8629e4823c9f6a9278) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170585))
- [Add subtab query param to placeholders section](https://gitlab.com/gitlab-org/gitlab/-/commit/4a4b7d9497f2024dcae668fcc59b72dcf98b3371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170345))
- [Add modal to keep all contributions as placeholders](https://gitlab.com/gitlab-org/gitlab/-/commit/ea84699a0b53196f238b293a2aff5b8d693c46f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169285))
- [Add vulnerability_reference_information table](https://gitlab.com/gitlab-org/gitlab/-/commit/9fcb93fef99fddff157a218fb6596e99caf153bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169293))
- [Create index supporting sbom_occurrences.package_manager search](https://gitlab.com/gitlab-org/gitlab/-/commit/592f692452c4b0f43ef10a008aea491e9a85ed97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171533))
- [Move 'Maximum number of jobs in a single pipeline' from EE to CE](https://gitlab.com/gitlab-org/gitlab/-/commit/05fb2beae141aa726ea49bca77bedce3f404f33b) by @choznerol ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164596)) **GitLab Enterprise Edition**
- [Add security policy bot for container scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/dd149865ea1440baf751fe77008f85bcf71a6a95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167602)) **GitLab Enterprise Edition**
- [Adding adherence check for dast scanner run](https://gitlab.com/gitlab-org/gitlab/-/commit/c4ffc7b6d05eb4b25b4ebbbd789576b69dc3baa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170688)) **GitLab Enterprise Edition**
- [Add admin role option for the default project creation protection](https://gitlab.com/gitlab-org/gitlab/-/commit/cb18fba2672d44e88a9c9ebb77b21ef20f742aec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171245))
- [Configure Sec CI for MR's labelled sec-decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/38961468569106fe6c987c31c7cea22778c8f499) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169907))
- [Model registry: Add actions to versions](https://gitlab.com/gitlab-org/gitlab/-/commit/0a320c8d1460aaabd377e8b0b06912b9f198afe8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170977))
- [Default enable security_policies_sync feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/146edce7fe7854d3b4bad437c34f46afb38356a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170146)) **GitLab Enterprise Edition**
- [Add JobTokenAuthLog resolver and type](https://gitlab.com/gitlab-org/gitlab/-/commit/858f5c3ad9149dd49666aebba764ee0bec1c4cdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169323))
- [Add `solo_owned` filter to the Users#Organizations resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/439076d9e2d8029d45db7b3b36f8b3c36ff2d458) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170385))
- [Adds UI elements for deprecated packages](https://gitlab.com/gitlab-org/gitlab/-/commit/bc58721e8399962bece7d200419b4e3493935ce1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170435))
- [Model registry: Add artifactsCount](https://gitlab.com/gitlab-org/gitlab/-/commit/5d745f231c338016c82e3e2a48bf15ab33300000) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170450))
- [Make GKE runner option generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/9badbb7693e4692d2d78fa78bce2f2339be5006d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171044)) **GitLab Enterprise Edition**
- [Model registry: Add performance tab to Version card](https://gitlab.com/gitlab-org/gitlab/-/commit/a92ef60715068728210ee468426161793979c561) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170802))
- [Enable NOT filtering for target branches in MR List GQL](https://gitlab.com/gitlab-org/gitlab/-/commit/a250628ce585e15b9a7ce34d5f3e073c45b806ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170664))
- [Activate syntaxhighlighting in CI/CD catalog README](https://gitlab.com/gitlab-org/gitlab/-/commit/5d033f2e45bffb09aac17e4dea8137d143c2d781) by @hairmare ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170091))
- [Adding adherence check for sast scanner run](https://gitlab.com/gitlab-org/gitlab/-/commit/6a819456d845f4a4a976834fd29eb3167bb3a4c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163579)) **GitLab Enterprise Edition**
- [Added ability to push multi-result count to sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/0a5a5fb03d2e08d2c6b86ece9ba0199ae17e5f57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170459))
- [Add streamed diffs to rapid diffs commit page](https://gitlab.com/gitlab-org/gitlab/-/commit/4ec2d3aeb3a13bd2a02ec6baa02ce10695c36fb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170255))
- [Add GraphQL API for Wiki notes](https://gitlab.com/gitlab-org/gitlab/-/commit/8eef64ad4e2e050a6da79e0ba161993c5c6548c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164071))
- [Add and backfill project_id for ci_trigger_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/4aae397a23677d2b47ca2363e0b9a3b1c4ffbf4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169236))
- [Create ci_runners_e59bb2812d partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/99890a5265ef517a020c2e5c79d296f608f4c179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166308))
- [Model registry model right sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd86f8104bc475fcbcedfe70a44705ac85215c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170291))
- [Add DeleteNotPresentOccurrencesService for CS4R](https://gitlab.com/gitlab-org/gitlab/-/commit/1ad9b549feb952486f052076e28c42b1e8535779) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169134)) **GitLab Enterprise Edition**
- [Group settting to notify inherited members for access token expiry](https://gitlab.com/gitlab-org/gitlab/-/commit/ee9e781b9404eeaaeefaebe41d6f21bcf8c0628f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168439))
- [Add a setting for text editors](https://gitlab.com/gitlab-org/gitlab/-/commit/0fb1742c8c316f3aa7003218b607b623d5259353) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168077))
- [Create an audit event when SD exclusion is applied](https://gitlab.com/gitlab-org/gitlab/-/commit/cbd1c6334f225b5d4d5a8cdc2b9789301431ea77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168955)) **GitLab Enterprise Edition**
- [Add mailer for duo enterprise seat assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/b7e3924a408117d7b1335432a590de0d4ff115eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170507)) **GitLab Enterprise Edition**
- [Model registry: Add tabs to Version card](https://gitlab.com/gitlab-org/gitlab/-/commit/ba1d73b6221ace42fbbf1a21f464c0666a1c96a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170793))
- [Subscribe to Members::Added event](https://gitlab.com/gitlab-org/gitlab/-/commit/d0291e97cc8ec92d721f1c6b683172d09b5b3503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169267)) **GitLab Enterprise Edition**
- [Add license option to sort options](https://gitlab.com/gitlab-org/gitlab/-/commit/287713d8669e398a598d34094bd20d53b2ed0efb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170776)) **GitLab Enterprise Edition**
- [Add reverse_lock_order on pending_alert_escalations table](https://gitlab.com/gitlab-org/gitlab/-/commit/e1392811b2647aa9506ed8ea5f8e59637a40ea99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168212))
- [Add Feed Tokens to Token information API](https://gitlab.com/gitlab-org/gitlab/-/commit/0e0b2c6af73e69a581bacaea17db8e774717d248) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170690))
- [Remove terraform_extract_terraform_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f8d1feb0676e16a5dcaa54470b33d654c9d8f842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170584))
- [Adds enable_member_management setting to api response](https://gitlab.com/gitlab-org/gitlab/-/commit/bc90c3e9034d61cbcb54d0e49bcfd589ea4c1ec2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168356)) **GitLab Enterprise Edition**
- [Expose /licenses endpoint on Project Dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/520f17a0594f9cc049036c0b5b8ca47a33790f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170619)) **GitLab Enterprise Edition**
- [Add `auto_resolved` column to `vulnerabilities` table](https://gitlab.com/gitlab-org/gitlab/-/commit/cd56249b906ca67ee31abe8e1f1726c877b8b4b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169949))
- [Add archived to NamespaceSettings for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/a45cff79b2014278f78d1fbf4adceead52fc2284) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170388))
- [Add label filter for merge requests scope](https://gitlab.com/gitlab-org/gitlab/-/commit/c5114a8e6357ec1491125f4b832e9e48ece6674b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170294))
- [Add new event Members::DestroyedEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/8506dbc673e6aa0ce9ac24dd449b168e1f15a0f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169756)) **GitLab Enterprise Edition**
- [Audit when multi project down stream pipeline is created](https://gitlab.com/gitlab-org/gitlab/-/commit/3a88218d4be2535c2c492d2753d6f275a7ecb282) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168626)) **GitLab Enterprise Edition**
- [Backfill sharding key for events](https://gitlab.com/gitlab-org/gitlab/-/commit/b3e8ce1827fddbd6ee410c6e60b4a740fd10da95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166563))
- [Make JaCoCo reports Generally Available](https://gitlab.com/gitlab-org/gitlab/-/commit/1a7d16a21ea8b3060ba12e4edd0b859edc59cd82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170513))
- [Add warning to file uploads in confidential/internal notes](https://gitlab.com/gitlab-org/gitlab/-/commit/d87a8befd9e89727e7f57eaa4a0a61e49e446dff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170125))
- [Assume high risk for users who use a duplicate phone number](https://gitlab.com/gitlab-org/gitlab/-/commit/c43ccd96bfe6402cf3706281d2e24b60909cd658) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170508)) **GitLab Enterprise Edition**
- [Added mutation for creating compliance requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/ea17924b49b4bcc67801f2a9486a30785cb49fca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169485)) **GitLab Enterprise Edition**
- [Release Jira deployment gating feature](https://gitlab.com/gitlab-org/gitlab/-/commit/bab9629597d298d9c528f634f786832d7fef8c40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168739))
- [Prepare conversion of abuse_reports to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/fa537e0fd5d1a37b8d99bf03807e894516050901) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170425))
- [Support X-Delivered-To headers for email ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/3c505e9451dea68e62989851b5cf2f81317b0303) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170221))
- [Remove model registry feature flag by releasing the feature](https://gitlab.com/gitlab-org/gitlab/-/commit/7a717bb8643b83edd3cb6bf711288d0b6e5b0e9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170070))
- [Model registry: Display author in model metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/cbab2c881a07b20c206dc3917bdfa56aead252dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170109))
- [Add support for assigning an agent to an environment via CI](https://gitlab.com/gitlab-org/gitlab/-/commit/a9121970c472c2408c1d2c64be7a5656f5ca767c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169675))
- [Add work item iteration to create flow](https://gitlab.com/gitlab-org/gitlab/-/commit/549efa40e5a2c5084a643eafdf699b34614a48bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169087))
- [Expose list of Duo Chat available features](https://gitlab.com/gitlab-org/gitlab/-/commit/c1b1b17ff394a8d5f825e1be523bcbfdc823eb1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168794)) **GitLab Enterprise Edition**
- [Support subscriptions in GraphQL explorer](https://gitlab.com/gitlab-org/gitlab/-/commit/943c0d6cfd53626d9af8b39d2b68616f52dd66bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169619))
- [Release protected npm packages feature](https://gitlab.com/gitlab-org/gitlab/-/commit/ed4d68b173e2c4790b2ae6683a51db5450062e45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169246))
- [Remove `ci_retry_on_exit_codes` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d57fa8ee02997588f34b838f8eb95a114150bcb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169434))
- [Retry some errors](https://gitlab.com/gitlab-org/gitlab/-/commit/fd4e4bff71990f1b49d9d4ff8e19d8225a994f1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167809)) **GitLab Enterprise Edition**
- [Display external author in note header on work items](https://gitlab.com/gitlab-org/gitlab/-/commit/e513a5170e72ea6a876e4fae4fb2eee10e1ecd73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169929))
- [Filter todos when marking all as done](https://gitlab.com/gitlab-org/gitlab/-/commit/7deeb18ec745dc94f57702e60c5101f0c705e085) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170170))
- [Add identity_verification_settings column to application_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/58b635c8f1da119f8f4afc764dc03441ccec7baa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167982))
- [Rake to alter cells only table sequences](https://gitlab.com/gitlab-org/gitlab/-/commit/b1fa834b884803b9ac4d816b2443cb2831c88016) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168941))
- [Model registry: Display author in modelversion metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/d61c2983e8cec361c81c3ac8b6f55fe237af2a54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170106))
- [Protected packages: Integrate package protection rules for pypi packages](https://gitlab.com/gitlab-org/gitlab/-/commit/615721cdd0ced393dd44d7fd239b7148ed99a1c5) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135475))
- [Create unique table visualizations for analytics dashboards](https://gitlab.com/gitlab-org/gitlab/-/commit/afec89eb34ff57e66e8f7ce6bcbedc34b04b39f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169618)) **GitLab Enterprise Edition**
- [Add duo enterprise trial discover page](https://gitlab.com/gitlab-org/gitlab/-/commit/5d522ee10b0cf1cd92d28202b232f90584adef6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168823)) **GitLab Enterprise Edition**
- [Add feature flag for github import user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/25106f1b7f443e1db72e70b02e7801374422bcb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169726))
- [Add duoUsedCount aiMetrics](https://gitlab.com/gitlab-org/gitlab/-/commit/4c05c479e852db5fd482d6bbc9db36bc78fe4216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169722)) **GitLab Enterprise Edition**
- [Add `counts.groups_with_enterprise_users` metric](https://gitlab.com/gitlab-org/gitlab/-/commit/b547b957d21d76b4a8026287621907359ccb077e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169631)) **GitLab Enterprise Edition**
- [Add visibilityLevel to Ci::Catalog::Resource type in GQL](https://gitlab.com/gitlab-org/gitlab/-/commit/b5cb5fc21ca4a11c8dac24fe5ee1863afab5ab57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169480))
- [Create new compute_minutes internal API route](https://gitlab.com/gitlab-org/gitlab/-/commit/7b9e01b3ba83b085ba4e71eb9069992ec1038ba4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169609)) **GitLab Enterprise Edition**
- [Add project_id to ci_pipeline_messages](https://gitlab.com/gitlab-org/gitlab/-/commit/28216b96068458b87052d06a1926a4eb64033b1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169208))
- [Add `theme` parameter to broadcast message API](https://gitlab.com/gitlab-org/gitlab/-/commit/d08706167b6722a2c3280cf3e4b341f571854a7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169762))
- [Customize GraphQL explorer logo and welcome text](https://gitlab.com/gitlab-org/gitlab/-/commit/25497254be78f13382e2c27faa9167f9bf014de7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169610))
- [Add GKE provisioning service](https://gitlab.com/gitlab-org/gitlab/-/commit/f80d3c462e820cf81c0f467bc2c990b32a85291b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167246)) **GitLab Enterprise Edition**
- [Setting for resource token expiry notifications to inherited members](https://gitlab.com/gitlab-org/gitlab/-/commit/09ba517cb5771b5065c6f8bdc5030bb774d10abf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168245))
- [Model registry: Add author to model and model version](https://gitlab.com/gitlab-org/gitlab/-/commit/94b8ce416efee628b36762149afc232f183305d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169447))
- [REST API: add an endpoint to configure pull mirrors](https://gitlab.com/gitlab-org/gitlab/-/commit/ce0aeec2ee7ea66f8f8ca5f01d224d767832d09f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167901)) **GitLab Enterprise Edition**
- [Add forked_from_project_id to project entity](https://gitlab.com/gitlab-org/gitlab/-/commit/8d2f35f32b48b76582e73e8a691375fc5a616b86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168501))
- [Search API: Issue support fields parameter to search by title](https://gitlab.com/gitlab-org/gitlab/-/commit/c64cf2c498a46017326891e3acdcb89a726c0c4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169386)) **GitLab Enterprise Edition**
- [Add AssignDesiredShardingKey to support non id PK](https://gitlab.com/gitlab-org/gitlab/-/commit/64030c654fcbcd977bd5829588933092819c77ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169530))
- [Create rake task to cleanup wrongly provisioned add-on purchases](https://gitlab.com/gitlab-org/gitlab/-/commit/4aa6d9f64f3a9980872e579d73cfdfd1158593c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169614)) **GitLab Enterprise Edition**
- [Auto-ban duplicate users when a user is banned](https://gitlab.com/gitlab-org/gitlab/-/commit/8fc382adc19fa4bc3b17380f853031cd87a56678) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167357))
- [Export CI Job Token Authorizations in CSV](https://gitlab.com/gitlab-org/gitlab/-/commit/13271c49c030fbafbc4f7df16002dbf8e90cc021) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168413))
- [Add skip parameter in network graph list commits](https://gitlab.com/gitlab-org/gitlab/-/commit/4e3baa520bb2f7be8d802b4251bc1b1ab0dce38a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169210))
- [Service Ping count projects using multiple compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/435370dd34b9fe6edc2de075e67d52693e159bd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169047)) **GitLab Enterprise Edition**
- [Add GitLab University link to pipeline editor](https://gitlab.com/gitlab-org/gitlab/-/commit/2b10b290f33c64e1bed8d05138388e075c660a0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169327))
- [Check parents when rendering 'pending deletion' badges](https://gitlab.com/gitlab-org/gitlab/-/commit/70277d13c369e01a1ab779e9f11e573011939da8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168963)) **GitLab Enterprise Edition**
- [Create new gitlab_subscriptions internal API route](https://gitlab.com/gitlab-org/gitlab/-/commit/7412ec02f272f7526baf597bce98a7231fbe0951) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169430)) **GitLab Enterprise Edition**
- [Adds external author to note type](https://gitlab.com/gitlab-org/gitlab/-/commit/0bf5c9714dfd66a0507c6a6da18307f7fbc31f80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168678))
- [Add epic_issue and epic_links work item references](https://gitlab.com/gitlab-org/gitlab/-/commit/8d7df0391ec9b1bab9a5160e5d9e72c960a886ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168122)) **GitLab Enterprise Edition**
- [Validate OmniAuth email length by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d9b253df38631bded2766a102ed1fe5b5e9870ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169337))
- [Use LFK to mark packages nuget symbols for destruction](https://gitlab.com/gitlab-org/gitlab/-/commit/cae0c3adaf0cde0c0a99ebc940d601bffe521b96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166743))
- [Adds email participants widget definition](https://gitlab.com/gitlab-org/gitlab/-/commit/f51b20bd6c5e5481b050e9e252104ae2e6357114) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168536))
- [Add sharding key project_id for p_ci_pipelines_config](https://gitlab.com/gitlab-org/gitlab/-/commit/c031f8ea82252f4a43c0dff950965222d54a9a77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167387))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/58b989588c9bbf60a826c2020b05c13f2b468b60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169233))
- [Add badges to Catalog releases](https://gitlab.com/gitlab-org/gitlab/-/commit/6f0c91310739a0392d263ba74ac573824d9e0829) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167944))
- [Add lastActivityOn field to MemberInterface type](https://gitlab.com/gitlab-org/gitlab/-/commit/52fa24d2e1e0984a3c942bf87a428335b036d3dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168714))

### Fixed (176 changes)

- [Limit follower and following count to 21 before pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/8401215a9f6f4191e471cb14e3d8df8070e54e0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172586))
- [Only highlight file on changes tab](https://gitlab.com/gitlab-org/gitlab/-/commit/ef183cab18d4c6aaa7de590879f7f88f9a1ac6fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173057))
- [Use GlFormSelect for project visibility dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/a983fe9559d82445fe3ef4c1de87cf4b44a3bc3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172125))
- [Update namespace_id when moving issues](https://gitlab.com/gitlab-org/gitlab/-/commit/ee2a308faa7f8b7398edfa64a7926e18ec6ab576) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166617))
- [Fix setting namespace_id for group wiki page notes](https://gitlab.com/gitlab-org/gitlab/-/commit/53863eb7b44da9d9823393d66380d2c354e30fda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171889))
- [Add quickActionsStatus field to create/update note GraphQL mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/478e89b42ea402e37f253f6df5c472d8ab67a247) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172179))
- [No op BBM QueueCreateMissingExternalLinksForVulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/43b9305198f2ec1aa7479977e05dec98928e57ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172875))
- [Fix padding of reply comments so that username and comment content align](https://gitlab.com/gitlab-org/gitlab/-/commit/4a885fb333ecf7c161ab4313c8c75da102b21add) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172861))
- [Merge request: Add correct design token for border bottom](https://gitlab.com/gitlab-org/gitlab/-/commit/a4e5d580d5bd99f2448590cd69d854aeb4a44ee1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172858))
- [Publish AuthorizationsAddedEvent with multiple projects](https://gitlab.com/gitlab-org/gitlab/-/commit/0020784a161249ec3dedf5780926878d9e5a6d9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171991)) **GitLab Enterprise Edition**
- [Fix displaying “unsupported” emojis](https://gitlab.com/gitlab-org/gitlab/-/commit/5a15139a5d822eacf921723446266e90497af25f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172747))
- [Do not run validations on AccessToken revocation](https://gitlab.com/gitlab-org/gitlab/-/commit/357c444badff7cae0ce66525be6b0c4d08c03951) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172480))
- [Save comments on a diff file automatically](https://gitlab.com/gitlab-org/gitlab/-/commit/797bc038d9d6b0d01e27db716e92826724086430) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171571))
- [Remove ci_redis_pipeline_creations flag](https://gitlab.com/gitlab-org/gitlab/-/commit/29ab73390753ab571c7159422703bb1d12980682) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172674))
- [Exclude hidden issues in sidebar count](https://gitlab.com/gitlab-org/gitlab/-/commit/ab1aa8f8ca862a07404cef08ef4f9356fea805b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172665))
- [Return error when unable to create import relation](https://gitlab.com/gitlab-org/gitlab/-/commit/53f201f924ec7c9e3da6149c8f1f4c5e863c73be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172631))
- [Consider manual pipeline for unenforceable policy rules](https://gitlab.com/gitlab-org/gitlab/-/commit/9042c6aa381f4271f45c7fb2403f26872b51ed95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172570)) **GitLab Enterprise Edition**
- [Fix application errors in /user/personal_tokens endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/d053bc06e7867abd6e9b94e9e73ae7c5a4c5b387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172274))
- [Fix check for `Diff::Line#match?`](https://gitlab.com/gitlab-org/gitlab/-/commit/ab2fbeb3dd6762e24fbdb181eb21a7cbd924361e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172067))
- [Update AuthorizationsAddedEvent to handle multiple projects](https://gitlab.com/gitlab-org/gitlab/-/commit/4599571aba14cbc46a283e9e5f0874b51d343c9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171990)) **GitLab Enterprise Edition**
- [Fix pipeline security summary not loading](https://gitlab.com/gitlab-org/gitlab/-/commit/96198287f5a4732ad0668e45cd3d7c3d8885eef5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172495)) **GitLab Enterprise Edition**
- [Fix on call rotation modal styles](https://gitlab.com/gitlab-org/gitlab/-/commit/a99080f7f6de5b57b072f3bba1ba3b275d9403b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172499))
- [Check title and name fields for scope delimiter for labels](https://gitlab.com/gitlab-org/gitlab/-/commit/1b4900ca9ba22e8f35be8639ed8b4a691a81a92f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172452)) **GitLab Enterprise Edition**
- [Display the mermaid plot in terms page when 2FA on](https://gitlab.com/gitlab-org/gitlab/-/commit/e1477b55b1e47790d47e0a97576aa2645f1a9d72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171407))
- [Let activity entries wrap instead of overflowing](https://gitlab.com/gitlab-org/gitlab/-/commit/892ec23733da45f949bf0eeebac46605d61bf299) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172439))
- [Use nav item title as aria-label on nav link](https://gitlab.com/gitlab-org/gitlab/-/commit/e8d5ce480640f42d88f499bda211bac27ac4a72f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172436))
- [Fix warning background color for compare page](https://gitlab.com/gitlab-org/gitlab/-/commit/609e13dc5c107e70d4721905e81b297bf4cea50e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172351))
- [Index work items when project visibility level changes](https://gitlab.com/gitlab-org/gitlab/-/commit/c540267f275647c25f19165abc2a824af89e60d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171978)) **GitLab Enterprise Edition**
- [Conditionally show Users without a group or project in correct section](https://gitlab.com/gitlab-org/gitlab/-/commit/0d2e54e2780632b49b4a78f5dab30ff3859c42ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172028)) **GitLab Enterprise Edition**
- [Add missing namespace IDs header for Code Completion requests](https://gitlab.com/gitlab-org/gitlab/-/commit/caac8c44fab058a1d3f222d65f14ad081e30f47f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171216)) **GitLab Enterprise Edition**
- [Optimize `standardRoles.memberCounts` query](https://gitlab.com/gitlab-org/gitlab/-/commit/061a21e078d5473dac17c8a2dabb59f27f026e87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169783)) **GitLab Enterprise Edition**
- [Re-add utility classes mw-m, mw-l and mw-xl for metadata_item.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/a4978a8149f027c2d83708025e77e070e16e691f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172032))
- [Check work_item_epics FF for legacy date rollup](https://gitlab.com/gitlab-org/gitlab/-/commit/6b7e60ec4ec3225e27f5302b27aaf3d8242f2f4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172241)) **GitLab Enterprise Edition**
- [Fetch left super sidebar counts with async GraphQL calls](https://gitlab.com/gitlab-org/gitlab/-/commit/5ee53e379787cd53f9851cd49107404dece20fda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171454))
- [Vertically align badges in glql lists](https://gitlab.com/gitlab-org/gitlab/-/commit/2c6d1d074b603c192f968758c1549d17d681330f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172141))
- [Fix issue with /label and /unlabel commands](https://gitlab.com/gitlab-org/gitlab/-/commit/84b561d7a01f718ef3e6a1019abd044f79fb01d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172104))
- [Fix updating approvers of multiple merge request rules](https://gitlab.com/gitlab-org/gitlab/-/commit/139f956eb456b2eb5c1cf8492a2c74184d6552e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172097)) **GitLab Enterprise Edition**
- [Adds findings exists check](https://gitlab.com/gitlab-org/gitlab/-/commit/424b149a8fba75a41c3ebfaf0fb77eb576eff2b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171324)) **GitLab Enterprise Edition**
- [Fix LLM AI client not returning a HTTP response with 204 responses](https://gitlab.com/gitlab-org/gitlab/-/commit/98e578c946dbb9ab27fe9fff5cb934c7d3d4c05a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172025))
- [Fix error during project deletion when pipeline sha is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/120b968f5c401969419dfaa7d0a9ab5443da1462) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172046))
- [Fix user caps alert positioning to be above members buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/3dfeba9c2fd0a8091faeaecb3b87830962fdb4d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172039)) **GitLab Enterprise Edition**
- [Fix double API call when inviting a project member](https://gitlab.com/gitlab-org/gitlab/-/commit/18dafa2fedf4036b1d098c5501e5a585e8c9f565) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172011)) **GitLab Enterprise Edition**
- [Check for package_forwarding feature availability in admin's settings](https://gitlab.com/gitlab-org/gitlab/-/commit/d7f92f9a6b7f5821be84ea15c1f95b780fd93990) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171949)) **GitLab Enterprise Edition**
- [Wait until pipeline finishes to evaluate unenforceable scans](https://gitlab.com/gitlab-org/gitlab/-/commit/c6f5ee46e8078fa5f95ee13fa4d2a055d99d94da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171970)) **GitLab Enterprise Edition**
- [Fix AIGW header for chat requests](https://gitlab.com/gitlab-org/gitlab/-/commit/98ad4e2c03df66d938c2a44cb2b5ddc19486dc4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171679)) **GitLab Enterprise Edition**
- [Stop blocking pre-existing policy rules as unenforceable](https://gitlab.com/gitlab-org/gitlab/-/commit/aaf5b53138e0755a83fb92f8ef6ad98538e57836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171931)) **GitLab Enterprise Edition**
- [Use Gitlab::HTTP for outbound filtering rules](https://gitlab.com/gitlab-org/gitlab/-/commit/9cbb009f4bae43dbc8af1507ae812e0da3265ec2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171881))
- [Remove #find_object override in CI job mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/21421bcf752b9deef506d00279c699a2615fbc86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171874))
- [Handle TypeError in parsing webhook template](https://gitlab.com/gitlab-org/gitlab/-/commit/55dbd1673777bf3496bee7fb1d878f7d699ed197) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171871))
- [Create migration to update admin bot profiles](https://gitlab.com/gitlab-org/gitlab/-/commit/2f74b9d9ebd1ccf0e68e89ad0b4197e206e44568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171035))
- [Implement abort pod logs stream](https://gitlab.com/gitlab-org/gitlab/-/commit/18118042141c49d0993b4cb5ee1c645ac264dfda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171415))
- [Fix cron worker that deletes project_bot users to delete inactive only](https://gitlab.com/gitlab-org/gitlab/-/commit/131a942ae94a1242cf5d57879a9ee1b761707358) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169012))
- [Use subscription data for subscription related card](https://gitlab.com/gitlab-org/gitlab/-/commit/885fdbb520254894df161e676f095a80dd20c0f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170925)) **GitLab Enterprise Edition**
- [Fix pagination redirect for protected branches/tags](https://gitlab.com/gitlab-org/gitlab/-/commit/fd70fce5515a64099dbf6d030fe56659f0699d87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171832))
- [Don't change MR closing issues if MR is set to auto merge](https://gitlab.com/gitlab-org/gitlab/-/commit/8751654e580846b8c26a0979e3e493959786d417) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171721))
- [Return an error for an invalid ref_name](https://gitlab.com/gitlab-org/gitlab/-/commit/a47d7f59fe4000ecc820fc1027ae6f9c765e9cd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171808))
- [Fix group wiki activity events breaking the user feed](https://gitlab.com/gitlab-org/gitlab/-/commit/6e1e569ba873bde03a5f65cc28f170ea33373b32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171652))
- [Fix PendingStatusCheckWorker when merge_request is not found](https://gitlab.com/gitlab-org/gitlab/-/commit/f5ba1ca23fbd96f100a2554991837757dff1bd32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171523)) **GitLab Enterprise Edition**
- [Fix RTE rendering bug with empty code blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/a3dbfacfc00b7ec46e664ce40403f0745f94a9df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171730))
- [Fix project subscriptions policy](https://gitlab.com/gitlab-org/gitlab/-/commit/d11431241492bd79cbef6bd9aa03c424940af5d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142700)) **GitLab Enterprise Edition**
- [Fix repository push emails: don't escape commits for plain text emails](https://gitlab.com/gitlab-org/gitlab/-/commit/a702a335cd94d6ebe3753ff92785b4ded7085796) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171640))
- [Changelog API: fix pattern for header detection](https://gitlab.com/gitlab-org/gitlab/-/commit/a6f2b68abc303799e569f4bebb12e054f9cde104) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171654))
- [Allow job play mutation to act on instances of Ci::Bridge](https://gitlab.com/gitlab-org/gitlab/-/commit/d01c2e573123f8218a373d545859cf7a4f0ee19c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171344))
- [Create project security_setting if necessary](https://gitlab.com/gitlab-org/gitlab/-/commit/55110296e58e6928a6d68af73722e1b79dbfad68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171599)) **GitLab Enterprise Edition**
- [Fix update of violation status for non-applicable approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/24dabd81fd6e6786450d1ec8458d2d003b420133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171385)) **GitLab Enterprise Edition**
- [Avoid updating or creating runner managers when deleting runner](https://gitlab.com/gitlab-org/gitlab/-/commit/d2d6f6e0843e5c598f0ce0a8f61c1973ecb3eff3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171575))
- [Fix start and due dates values for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/e0215277b3935033eb7608188a2e58dce2a0e49c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170866)) **GitLab Enterprise Edition**
- [Markdown header: Fix bg color in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/4669f26437f57070b615b20d67168db01d5e34f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171524))
- [fixed: Redirect behaviour for git-upload-pack requests](https://gitlab.com/gitlab-org/gitlab/-/commit/46fbb5fae8d37b64d4cdb42a4458907a73a88f1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166965)) **GitLab Enterprise Edition**
- [Settings footer: increase z-index by 1 from header](https://gitlab.com/gitlab-org/gitlab/-/commit/0fd4aec242df74e0cb5b048039e8e51e39b46852) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171404))
- [Repo language bar: Fix text in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/12ce9fff08c5ca5a6087027d03205ce0171036f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171386))
- [Don't create approval rules without require_approval action](https://gitlab.com/gitlab-org/gitlab/-/commit/ea7d0b7b5b06f683d15a213656fe933cf3eb5a4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171390)) **GitLab Enterprise Edition**
- [Model registry: Allow author to be missing](https://gitlab.com/gitlab-org/gitlab/-/commit/4b129499d33190f01416fa6ede4ea46f7ef2dcb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171367))
- [Update container registry link to settings path](https://gitlab.com/gitlab-org/gitlab/-/commit/7ab9767dc49421962ab7773855380b5dced8ad24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171362))
- [Only set has_vulnerabilities records are ingested](https://gitlab.com/gitlab-org/gitlab/-/commit/7e09ea99fdcbf8b3da9af526e4155b1b0aefb498) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170811)) **GitLab Enterprise Edition**
- [Fix incorrect `has_vulnerabilities` values](https://gitlab.com/gitlab-org/gitlab/-/commit/96038f8c4a1b897c4c51a4b016dda755437fcaef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171029))
- [Replace non-existing path in the profile 2FA page](https://gitlab.com/gitlab-org/gitlab/-/commit/904003e9cc1325c5bd2eeabdc3b06bc3e01f60e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169534))
- [Fix diff hunk header overflow](https://gitlab.com/gitlab-org/gitlab/-/commit/7d12eeb46e907645497480d7069dc0f2f6bc752f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171299))
- [Corrects an inaccuracy in idempotent jobs docs](https://gitlab.com/gitlab-org/gitlab/-/commit/ec19366c3e1abea00e62c65c2d403866277dfa57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171290))
- [Fix GitLab Duo chat session error in the Web IDE](https://gitlab.com/gitlab-org/gitlab/-/commit/f6d1cd25aab61f1f182cb772693e811168f43ff2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171262)) **GitLab Enterprise Edition**
- [Uses tool input rather than user_input for calls](https://gitlab.com/gitlab-org/gitlab/-/commit/ef4b4e366e4e3b43594846d5a3b6b6723b30b08e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169753))
- [Fix: admin group update logic](https://gitlab.com/gitlab-org/gitlab/-/commit/fef6c679a3405612d3e8d88602f6b89e49d82789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170068)) **GitLab Enterprise Edition**
- [Resolve "Correct cve-enrichments to cve-enrichment"](https://gitlab.com/gitlab-org/gitlab/-/commit/62f57fec2776e5c1191e65d4d21ee8009c1fcde7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171094))
- [Ensure auto_merge_enabled is set when validating merge trains](https://gitlab.com/gitlab-org/gitlab/-/commit/2c1ecb070dc16b131888b2a9227b1e5842697b30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170652)) **GitLab Enterprise Edition**
- [Fix nondeterministic `discussions_for_summary` method](https://gitlab.com/gitlab-org/gitlab/-/commit/dd3cba0fdb52bf1235234828cbf7c51fb74dd295) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171131)) **GitLab Enterprise Edition**
- [Convert 20241022181600 to a schema migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6717cbce352496fb3fce11d2fb53ae155e9aa65c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171158))
- [Support namespaces in X-Gitlab-Duo-Seat-Count](https://gitlab.com/gitlab-org/gitlab/-/commit/7c36c68eb54b606d6d6c9bebd3c944cf9ee96ac2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171135)) **GitLab Enterprise Edition**
- [Fix edge case when imprting issues with invalid associations](https://gitlab.com/gitlab-org/gitlab/-/commit/0bddcdf50204d50be029e19de13d0a145178a6f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170786))
- [Go-get: return 404 error code when personal token is invalid](https://gitlab.com/gitlab-org/gitlab/-/commit/fa76ff697f8d44ced7fb59930f82b98336683b8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170831))
- [Group filtered search: Fix bg and border color](https://gitlab.com/gitlab-org/gitlab/-/commit/bd2ca5ac8a34c6a8ff94f6dcabdf8e9c6fadf579) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170564))
- [Unmark project as pending delete if user lacks delete access](https://gitlab.com/gitlab-org/gitlab/-/commit/3acced9dc63ba0203020c55e2e3a990c89fa6ceb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170770))
- [Remove duplicate banner for scheduled project and group deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/39af98537f9da8de2e8ad6ced57ddf421251c809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170887)) **GitLab Enterprise Edition**
- [Fix show/hide logic for licenses tap in pipeline view](https://gitlab.com/gitlab-org/gitlab/-/commit/e1a9e898bf1346766b6b7ad8f40ec1406cb0b5ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170903))
- [Fix error when adding quick actions to diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/97cdad1d77a079791aa3d0ea7f75bad1f1c19394) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170913))
- [Fix markdown editor header background](https://gitlab.com/gitlab-org/gitlab/-/commit/ba5514cd93d7ecde1c5626a245453ca7ab36b029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170993))
- [Catch analytics tracking error during maintenance mode](https://gitlab.com/gitlab-org/gitlab/-/commit/7905c4d9c45b380b01ebe25a1acda83b043a5f22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170436))
- [Fix redirect after sign in when requesting access](https://gitlab.com/gitlab-org/gitlab/-/commit/66bef6cf063cd3d69f93952bec1a789f8efac59b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170956))
- [Fix unlikely race on previous merge train car](https://gitlab.com/gitlab-org/gitlab/-/commit/baeba63afc02a68e6f213d46bcea33cde7603555) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170953)) **GitLab Enterprise Edition**
- [Make merge trains more robust to ref deletion errors](https://gitlab.com/gitlab-org/gitlab/-/commit/1fddbdf0af8cc5cc1b935d43c87c718226cc5f5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170932)) **GitLab Enterprise Edition**
- [Update pdf worker file path in pdf viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/5e730185bf39be9e01f5ffa7125934c4e6795793) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170803))
- [Fix work item assignees ordering GQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9d4d01fe1552503902355496d59cba909eb98b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170168))
- [Specify default query sync values for status token](https://gitlab.com/gitlab-org/gitlab/-/commit/6b98a6ef5897b6991f6ba52f552a5ba7e692e7b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170779)) **GitLab Enterprise Edition**
- [Change TailwindCSS darkMode from default to selector](https://gitlab.com/gitlab-org/gitlab/-/commit/ca186280d8d2cf5ac10efcdbd399b76a56a7bfce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170548))
- [Change root namespace for specific projects](https://gitlab.com/gitlab-org/gitlab/-/commit/7ee8c3dceed249b5c5fb725943808b2e816c4099) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170873)) **GitLab Enterprise Edition**
- [Fix directory resolution for Google Cloud runners services](https://gitlab.com/gitlab-org/gitlab/-/commit/2ff3afe60d4d49596bc17e84f1cfabad37dc88ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170161))
- [RefSwitcher: fix support for `%` symbol in reference names](https://gitlab.com/gitlab-org/gitlab/-/commit/4ee4baffd5482ce005117a96f5f17cda38ff9cba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170815))
- [Fix work item icon when conflicted with cache](https://gitlab.com/gitlab-org/gitlab/-/commit/c4e2098282b6e1b4fbd05e72ab0f79f8b51b5993) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170231))
- [Prevent group restoration during deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/26b4424e19ed87dfdef1e4961b5cbb00eea33473) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170774)) **GitLab Enterprise Edition**
- [History rewrite: handle Gitaly errors](https://gitlab.com/gitlab-org/gitlab/-/commit/6de22b2d6d4dc9982c15306ca1293ff2f053e832) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169916))
- [Fix Module deployment in Terraform template](https://gitlab.com/gitlab-org/gitlab/-/commit/597c1872bcfe971e39a8dd3acbcbf4876a5f763b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170759))
- [Update `has_vulnerabilities` when deleting records](https://gitlab.com/gitlab-org/gitlab/-/commit/fc44f83de6a8ac0587dfe886948410b9a9863e6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170642))
- [Add search for a ful path for polices](https://gitlab.com/gitlab-org/gitlab/-/commit/4e7ab11f26a092efc9e4e63128dc5b535e00e8e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170609)) **GitLab Enterprise Edition**
- [Make sure framework selection is updated](https://gitlab.com/gitlab-org/gitlab/-/commit/657600a5b3482d6a7e42032adca71920ce69f887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170597))
- [Deduplicate issuable_resource_links](https://gitlab.com/gitlab-org/gitlab/-/commit/76d01630efd42d372ff17f468435e8afc67539d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144327))
- [Fix double line number hash on pipeline security tab](https://gitlab.com/gitlab-org/gitlab/-/commit/02d23ce71763ea205317b47f0a3aa483c194ef89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170541)) **GitLab Enterprise Edition**
- [Broadcast message settings: Render message preview](https://gitlab.com/gitlab-org/gitlab/-/commit/fb9e1045fa3a101bf24ee84ef094908888da3950) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170570))
- [Sidebar navigation: Fix skip link position](https://gitlab.com/gitlab-org/gitlab/-/commit/7aa0aff76c52938d93f8e6f5a0d8b8839e9d2f02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170555))
- [Simplify DropCiPipelinesConfig migration](https://gitlab.com/gitlab-org/gitlab/-/commit/ea95f4545369c640d7dbc5faff2fb4db64559a67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170540))
- [Fix trial title for duo info card](https://gitlab.com/gitlab-org/gitlab/-/commit/321309b88e9a918314936592405c15915e89e698) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169349)) **GitLab Enterprise Edition**
- [Fix marking CVS vulnerabilities as no longer detected](https://gitlab.com/gitlab-org/gitlab/-/commit/b845703f7f041509bd5ffe6534836a0549e7918d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170465)) **GitLab Enterprise Edition**
- [Pipeline graph: Fix item hover in lightmode](https://gitlab.com/gitlab-org/gitlab/-/commit/24e9e7172264a3400d7d5eccca2d0b5938e40d10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170409))
- [MR sidebar: Refactor resize handling, remove CSS](https://gitlab.com/gitlab-org/gitlab/-/commit/fa72862ab93c5c7a3073c8e1f518e62e1965ffd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170097))
- [Disable DNS rebinding protection when proxy used](https://gitlab.com/gitlab-org/gitlab/-/commit/4f0eb862f7f1c7551ec5f31b03aeb68a46a3df3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170392))
- [Retry RepositoryUpdateMirror jobs on failure](https://gitlab.com/gitlab-org/gitlab/-/commit/c2f38efdffd09170313281946f84962ad4033ec7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168349)) **GitLab Enterprise Edition**
- [Fix unneeded right sidebar gap for work item epic page](https://gitlab.com/gitlab-org/gitlab/-/commit/252b5d6c21458ecaacaeba5f9714fca831232bcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170319)) **GitLab Enterprise Edition**
- [Localize dates on UI](https://gitlab.com/gitlab-org/gitlab/-/commit/1667741675287ef6f8a547d0e430aad3886d771f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170282))
- [Commit note: Fix commit on image styles](https://gitlab.com/gitlab-org/gitlab/-/commit/f81cc6ba50b9d08cec5f8e977bda8c03dc93c4b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169921))
- [Fix comment template button missing from issue child items](https://gitlab.com/gitlab-org/gitlab/-/commit/8375e509e317cc6f8142c266f261c69fb67d6146) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170269))
- [fix: Admin user can see pipeline trigger token from other project](https://gitlab.com/gitlab-org/gitlab/-/commit/7843c7b266bdead12a7a065dec18a26d1c4ec164) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169169))
- [Include LDAP blocked users in user dropdowns](https://gitlab.com/gitlab-org/gitlab/-/commit/957f2dbda33b3e8a374bbdb1cbaef0b7b9c32b6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170263))
- [Notes app: Fix use of shortcut 'r'](https://gitlab.com/gitlab-org/gitlab/-/commit/d2a6005c3df2a663e048b5876243ad847afe0aa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169936))
- [Fix followees count (only count active users)](https://gitlab.com/gitlab-org/gitlab/-/commit/24d30cec6d9b1fd458015ae7cbce9f8ac68030cd) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170056))
- [Prevent errors in GraphQL notes type](https://gitlab.com/gitlab-org/gitlab/-/commit/6e4cd5c97082d2deffbcd7b21ce45003c8e106b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170023))
- [Reduce batch size when backing up group wiki repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/dff96cf9a6cef2bb9ee4f8df3cc61d2bb696fd71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170141)) **GitLab Enterprise Edition**
- [Increase precision of Value stream analytics time values](https://gitlab.com/gitlab-org/gitlab/-/commit/a1e2967929c6c335245494987099598742b51670) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170065)) **GitLab Enterprise Edition**
- [Secure Policies list: Fix vertical spacing and delete action](https://gitlab.com/gitlab-org/gitlab/-/commit/45fde79aedb4f12174dc2e182bfc13f0a19ee85b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169947))
- [Fix admin groups page LDAP group links display](https://gitlab.com/gitlab-org/gitlab/-/commit/b3a0d91863897b0b481fda2307021821121fdd19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169986)) **GitLab Enterprise Edition**
- [Avoid SELECT 1/LIMIT 1 query in credentials inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/83b9d54f0341486cf140e4dc87b5a0d43ba15afb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169962)) **GitLab Enterprise Edition**
- [Fix broken link to doc on project transfer dialog](https://gitlab.com/gitlab-org/gitlab/-/commit/b6c28b7f63dcafb1f0487d9ef2505a6aff379e77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169955))
- [Remove  from Matrix notify](https://gitlab.com/gitlab-org/gitlab/-/commit/1f2d9661c2f41ba30f891c69d46676b4a9e315f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169577))
- [Fix possible javascript loading order issues with trial widget dismissal](https://gitlab.com/gitlab-org/gitlab/-/commit/e6954d620286284abbeed87ad98276382565be96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169516)) **GitLab Enterprise Edition**
- [Fix performance of deleting MR approval_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/1a95b761eada6000c36df5d4af2cbb77aa57147b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169622)) **GitLab Enterprise Edition**
- [Widgets: Use chevron lg size as design specs indicate](https://gitlab.com/gitlab-org/gitlab/-/commit/18ba27e91d226ea9164ac220201574a2ffaab7db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170052))
- [Remove policy_scope check to stop N+1 queries](https://gitlab.com/gitlab-org/gitlab/-/commit/9bd4e848335dd9890d06b1cd91184b8d4f04b71b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169911)) **GitLab Enterprise Edition**
- [Fix new project group templates pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/b32e0270788a513215524b4b1a44da4d8b5f321a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169902)) **GitLab Enterprise Edition**
- [Gracefully handle timeouts when counting issues](https://gitlab.com/gitlab-org/gitlab/-/commit/410e2cd8a254da8cc7b4dda7fbc5cdc7d06a6ac0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169391))
- [Skip defering scheduled jobs in concurrency limit client middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/6ab2f72935054df828831a938ddd7ea7c5e57dee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169823))
- [Use text-subtle for secondary text color in autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/b556dc391267d2ebacc08f2cd42a1da229854ba4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169811))
- [Security patch upgrade alert: Only expose to admins](https://gitlab.com/gitlab-org/gitlab/-/commit/1f587b1d5b278d72c6c96f27b3d5fd294e202f41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169273))
- [Add check for CodeSuggestions API](https://gitlab.com/gitlab-org/gitlab/-/commit/36e70973f64a4e7717146f05c7423f25fd0121b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169407))
- [Fix creating of terraform module metadatum](https://gitlab.com/gitlab-org/gitlab/-/commit/1b248d17fb83eaca6c103cfc9ad47779119e8604) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169703))
- [Fixed isNarrowScreen helper to not require specific element](https://gitlab.com/gitlab-org/gitlab/-/commit/633eea24e975a06c60bb3395233b0be24f79da40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167992))
- [Only delete protected tags if text matches](https://gitlab.com/gitlab-org/gitlab/-/commit/b3b14722f02d8f77ea2afd630172c2df44a501d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169645))
- [Fixed isNarrowScreen helper to not require specific element](https://gitlab.com/gitlab-org/gitlab/-/commit/ade8638b793e7b26a95bfdf9fcd847bd714b1e51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169261))
- [Fix an intermittent add_on_purchase finding issue with duo trials](https://gitlab.com/gitlab-org/gitlab/-/commit/88b893815246767ea64193aacd9b23453369eb00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169628)) **GitLab Enterprise Edition**
- [Fix work item modal timeline in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/ad492e42992a8004d5528edcb6efb8c7c9018fe8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167973))
- [Dont use blob stitcher when finding oversized blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/5f7fad38245cf3c67f5fee47d0cc6070ebb14aaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169154))
- [Fix two agent authorization UI issues](https://gitlab.com/gitlab-org/gitlab/-/commit/4693163fd0ff9c6e885121f0d09280b962cf2822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169554)) **GitLab Enterprise Edition**
- [Treat a missing fixed_code block as a false positive](https://gitlab.com/gitlab-org/gitlab/-/commit/8baf9c1651e84ed9d29e8903c40be8d52e740dea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168870)) **GitLab Enterprise Edition**
- [Localize dates on UI](https://gitlab.com/gitlab-org/gitlab/-/commit/bd80a5d231b87b50527e80a9f2bb6220b6aa79d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169509))
- [Show SAML badges for projects under nested subgroups](https://gitlab.com/gitlab-org/gitlab/-/commit/65b33e315ee85e572038ce6b0457102f76a32f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167218)) **GitLab Enterprise Edition**
- [Rollback related links on partial success](https://gitlab.com/gitlab-org/gitlab/-/commit/01573ab5157cc81978a5c18b6d08d71bdc7893ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168681)) **GitLab Enterprise Edition**
- [PullMirrors::UpdateService: fix a case with not enough provided params](https://gitlab.com/gitlab-org/gitlab/-/commit/01f71f6d4ef05118c61732c8cc1382c0bc9c5af4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169427)) **GitLab Enterprise Edition**
- [Delete orphaned stages](https://gitlab.com/gitlab-org/gitlab/-/commit/5c7dc783cd06360e638a980d506a0fece8e70b80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168750))
- [Don't show note from background item in work item modal](https://gitlab.com/gitlab-org/gitlab/-/commit/87cd2f7157caafd08d8e541abbeb3665faa6685e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169398))
- [Fix admin_mode enforcement in AdjournedProjectDeletionWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/19205b66d636ac7073f74e21e538b9f854e875e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167779)) **GitLab Enterprise Edition**
- [Include project ancestors when determining agent user access](https://gitlab.com/gitlab-org/gitlab/-/commit/99fe229da1a37dbb6fac52a785225b0dd30aef96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167868))
- [Badges - Migrate to Server Side Pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/0bad0019bd50d981bd7c3fc9436dec0b1ea4a382) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168234))
- [Fix searching in the label filter](https://gitlab.com/gitlab-org/gitlab/-/commit/5f031631659bfaed09084e246c608d9181b2e095) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167624))
- [Fix missing groups in autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/ff96c90e03b0f566dcdc7384846624edf62a7840) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169230))
- [Fix container registry tag cleanup schedule visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/9499125d8866d859c64ac931962258d2a43b6bed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168810))
- [Localize dates in epics and roadmaps UI](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1e23b313a7f0026a0d3f23d642ca1205008cae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169161))
- [Remove Manual sort option from issues dashboard page](https://gitlab.com/gitlab-org/gitlab/-/commit/b853bf4b31e9eead72835e4c7beed08de12d3f31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169158))
- [Have user_ids.size look for greater than or equal to 1 record](https://gitlab.com/gitlab-org/gitlab/-/commit/8815e51dc676a9136378dfe615af968a8f40cc3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169026)) **GitLab Enterprise Edition**
- [Lazy render emoji dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/324d82c9570c232da66671cff3fa74cda2fddb1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168623))
- [Remove &nbsp; on empty task lists](https://gitlab.com/gitlab-org/gitlab/-/commit/b9585df62a40dfd8fb45a5767d3d63f3aadc918b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168250))

### Changed (281 changes)

- [Change yaml format for approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/4bd4c22c545db5996693fdd84d59ac306d283706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172312)) **GitLab Enterprise Edition**
- [Move history button into commit box on repository and blob pages](https://gitlab.com/gitlab-org/gitlab/-/commit/127d55ae0a4944ba3a0ea56e99bf8573909085b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172632))
- [Disable scan_execution_pipeline_concurrency_control ff](https://gitlab.com/gitlab-org/gitlab/-/commit/31d311be0c1bcd4ccea176d5eacddb3024455b0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173047)) **GitLab Enterprise Edition**
- [Disable ViewComponent deprecation warnings in production](https://gitlab.com/gitlab-org/gitlab/-/commit/60e9e83d5357b82f2784e56cbcaeee94669ddc8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172924))
- [Change yaml format for vulnerability management policy](https://gitlab.com/gitlab-org/gitlab/-/commit/21dceddfaa6fb0a317670b2783fd8ec743069152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172911)) **GitLab Enterprise Edition**
- [Refactor notes quick action handling](https://gitlab.com/gitlab-org/gitlab/-/commit/1889ea9efb6b6b00b971fe08c39d9f9d28164c03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172179))
- [Prevent missing records in Direct Transfer when Sidekiq restarts](https://gitlab.com/gitlab-org/gitlab/-/commit/e248bfab819d7cee880d16c1f9a0a84e328d1611) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172568))
- [Update framework detail text on audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/194dd958553d87415ed849ceaf7ba02fbf6808f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172850)) **GitLab Enterprise Edition**
- [Fix broadcast message dismissal for Omniauth/SAML](https://gitlab.com/gitlab-org/gitlab/-/commit/2123ae32c6be2f4b71025967641794f039d96726) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171332))
- [Change yaml format for pipeline execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/a280ff74ad7650828ffa169cff7e660f4ef962a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172868)) **GitLab Enterprise Edition**
- [Initial checkin for Admin Duo Home Page](https://gitlab.com/gitlab-org/gitlab/-/commit/66630e191a7acede585c4a218bd7abdef97b214e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168454)) **GitLab Enterprise Edition**
- [Add ids argument to a group resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/add35204107573eecbf570066ebecf37bfcb429d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172453))
- [Handle mailmaped emails for verified gpg signed commits](https://gitlab.com/gitlab-org/gitlab/-/commit/f44f805ef98061f40d9a1d71544d17f8457ce6c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172792))
- [Allow LLMs to return a full resource definition](https://gitlab.com/gitlab-org/gitlab/-/commit/8eec5cb336b59c85a9de504061a44f978ef121c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172834))
- [Small visual updates to glql UI](https://gitlab.com/gitlab-org/gitlab/-/commit/ff4b76ce357dd20e155af61949fcb2bc97971939) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172147))
- [Enable ai_commit_reader_for_chat feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d35fc8d54cfa72042778ff0429e72f938d894070) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172818)) **GitLab Enterprise Edition**
- [Update edit blob to use commit change modal](https://gitlab.com/gitlab-org/gitlab/-/commit/3d369ee9865ba7c1b2f1ca16f32ae91cbbc4ad45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170512))
- [Collapse Pipeline section when empty on load](https://gitlab.com/gitlab-org/gitlab/-/commit/dcc5c6cdbd9bef89a91b16cb102f8f85efd72913) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171851)) **GitLab Enterprise Edition**
- [Validate sharding constraint on p_ci_stages](https://gitlab.com/gitlab-org/gitlab/-/commit/5ba522fa46848a3fd9776f4eb9ce8f315dd5ec1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170500))
- [AI-Resolution: Add public project warning](https://gitlab.com/gitlab-org/gitlab/-/commit/4b640122d3b57f6b6106ae81d0424950ab1dc28e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172280)) **GitLab Enterprise Edition**
- [Remove search and allow text input for job token allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/84eb3e688d878712cfa4510ba5bdc1eda6d87007) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171659))
- [Put inline blame behind feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/eca111ad2dc685c6c5c9aee4aab033d988ae78e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171249))
- [Updated all audit events to be streamed](https://gitlab.com/gitlab-org/gitlab/-/commit/08581c9c05576ffa3a2d8fcd69b59c4923b06ef1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172757)) **GitLab Enterprise Edition**
- [Replace text-muted class with gl-text-subtle](https://gitlab.com/gitlab-org/gitlab/-/commit/4caee1cbd1399a5b0f1683e0b2925aad01c1c98f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172484))
- [Synchronize prepared security policy indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/99d4e8b5f8c01c473ea7657ccd76b3d1f2b81db4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169442))
- [Remove enable_adherence_check_for_scanners feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b099360d2cf3b301aa441a017316d4029e4a8537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172352))
- [Remove unused policy helper property](https://gitlab.com/gitlab-org/gitlab/-/commit/51cb9e00cd29e3c4149d54da9307f7c2bac2cac4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172182)) **GitLab Enterprise Edition**
- [Update User Cap settings message](https://gitlab.com/gitlab-org/gitlab/-/commit/4f8a27d06a7deb0ae2ef542609c18556f8603042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172346)) **GitLab Enterprise Edition**
- [Change yaml format for scan execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ff9625bc07830ee5ca9996dd4902056d64ea6954) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170470)) **GitLab Enterprise Edition**
- [Fix discover page breadcrumbs title](https://gitlab.com/gitlab-org/gitlab/-/commit/d92500d5399b16e0b01bc8dd5f4f638c07c18a28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172569)) **GitLab Enterprise Edition**
- [Update decompose approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/af2022f23556c82fb092193092630574f806c60d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172549)) **GitLab Enterprise Edition**
- [Model registry: Allows directories in MLflow artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e7eb2b28a46ee017e7e2b24bf11bd356c4659a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172524))
- [Allow project transfer with tags conditionally](https://gitlab.com/gitlab-org/gitlab/-/commit/4de3c7debfe81b368cf1f0e8d12c6dcad5809bbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171036))
- [Clean up ai_build_reader_for_chat feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c905b77f1f4d1898f12af70a3e41b09adaeb9024) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172488)) **GitLab Enterprise Edition**
- [Update outdated links](https://gitlab.com/gitlab-org/gitlab/-/commit/d702a6ec302856b272fc7e2957ffc195f32b9303) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172361))
- [Enable FF enable_add_on_users_pagesize_selection by default](https://gitlab.com/gitlab-org/gitlab/-/commit/acbf06eb5c4e08bd96f15409b5c04693f8dbf8ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172444)) **GitLab Enterprise Edition**
- [Initial checkin for Groups Duo Home Page](https://gitlab.com/gitlab-org/gitlab/-/commit/68913f361cb754b566e782b2caece0e65fc9a23d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169498)) **GitLab Enterprise Edition**
- [Remove search and allow text input for job token allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/b8c7b7a23a9107e49eca69d70caf3168b8f0df09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171544))
- [Clean up gitlab_ci_archived_trace_consistent_reads feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b38b9bd2dfd3d5898f5c108bb8fe676ee9333ff5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172424))
- [Update Admin Dashboard to fetch KAS version from KAS](https://gitlab.com/gitlab-org/gitlab/-/commit/58cfec4c10ea994f25e6c3fddea984b523972761) by @choznerol ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164613))
- [Move creator_id LFKs to routing table ci_runners_e59bb2812d](https://gitlab.com/gitlab-org/gitlab/-/commit/1c4e090c7b6c5d762df79c6712a20af7c7977b55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172377))
- [Migrate text variables to design tokens in sidebars](https://gitlab.com/gitlab-org/gitlab/-/commit/b2483888587c02a97a1517d83faa7f7ac8328f3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171698))
- [Make memberships import optional](https://gitlab.com/gitlab-org/gitlab/-/commit/86b4bbdd93dadb5414b19fd7527d71a64d0e4dd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166658))
- [Require projects to be associated to an organization](https://gitlab.com/gitlab-org/gitlab/-/commit/f7557c2e74f8d9de1baf1d2e7f0e12b7168b0881) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172217))
- [Re-route pmg dropdowns to GraphQL version](https://gitlab.com/gitlab-org/gitlab/-/commit/be4f4da687ff23c04afd0d73f5cbf9ab87b32b77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171862))
- [Improve VSD and AI analytics dashboards panel titles](https://gitlab.com/gitlab-org/gitlab/-/commit/1897e03888e532a7df378fde5db34a6040ecfc7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172300)) **GitLab Enterprise Edition**
- [Error page: use a user friendly error page for ResourceExhausted errors](https://gitlab.com/gitlab-org/gitlab/-/commit/3291d95278d78f9de85af24424f143820287d202) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169039))
- [Remove FF batched_redis_updates_for_kubernetes_agent_events](https://gitlab.com/gitlab-org/gitlab/-/commit/ad79c662dcef325994b5ca0c8bbf310bde75fb57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172038))
- [Update jwt gem to 2.9.3](https://gitlab.com/gitlab-org/gitlab/-/commit/e964c6c0420cdd30054bd9df0dd615ce58babf20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172279))
- [Migrate your work MR dashboard to use Crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/d3367345a167cef9aa906c71d0b517bab045591b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168980))
- [Remove collapse_card.scss stylesheet](https://gitlab.com/gitlab-org/gitlab/-/commit/32faba45616826353bbe7fb3d99fd0259f52878e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172225))
- [Enable reviewer_assign_drawer feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/92204bc98ce789feec388b70bd39fe0dc9eeb44c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171690))
- [Improve layout of workspace items](https://gitlab.com/gitlab-org/gitlab/-/commit/98f2b00c2632aedb4c17b439d5abcd5951f55e16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163093)) **GitLab Enterprise Edition**
- [Remove old format for action approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/52e5f6589f7ce18ead306dd2f71728ddb4a2b508) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172170)) **GitLab Enterprise Edition**
- [Enable scan_execution_pipeline_concurrency_control FF](https://gitlab.com/gitlab-org/gitlab/-/commit/04f9c3eb56be1510dce618736cb61a9f8727bde0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172158)) **GitLab Enterprise Edition**
- [Add user ssh and gpg system signatures using signature author email](https://gitlab.com/gitlab-org/gitlab/-/commit/6da096b6ce786b57dc5a3aad6d3750a329feba09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171259)) **GitLab Enterprise Edition**
- [Allow interrupted RelationBatchExportWorker to bypass limit](https://gitlab.com/gitlab-org/gitlab/-/commit/2d9b7645ec6700162039f43c54b3d17f1768a0cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171977))
- [Model registry: Change create button](https://gitlab.com/gitlab-org/gitlab/-/commit/60cf886150111cb3fa3df8fd71ac306fc184f842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171938))
- [Ensure ID uniqueness for p_ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/0c42e62b5e9d1a09e1c9103084bb92dc66bec2ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164707))
- [Create separate tables for group SCIM](https://gitlab.com/gitlab-org/gitlab/-/commit/acf530da8cc803f071dce56c1200ad8edc7c2393) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171378))
- [Update audit event scope when a group disables 2FA for a user](https://gitlab.com/gitlab-org/gitlab/-/commit/20f7c0bf098d4aca27cf751832b79344eda5fe08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171988)) **GitLab Enterprise Edition**
- [Remove subscriber code from zoekt update used bytes worker](https://gitlab.com/gitlab-org/gitlab/-/commit/dd2649229137f47f6d7313d9c1f0abad5b2f9e3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171993)) **GitLab Enterprise Edition**
- [Use latest tanuki_emoji gem](https://gitlab.com/gitlab-org/gitlab/-/commit/b81c66c3b4573a20fb29982499adc4c310aff455) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171446))
- [Drop requires_credit_card_verification column](https://gitlab.com/gitlab-org/gitlab/-/commit/3cf2e3daf00060260bf26aac143cdfe993be551c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171859))
- [REST API: deprecate old pull mirror configuration process](https://gitlab.com/gitlab-org/gitlab/-/commit/affb12fe3fbcb8ebec816bb1b6b32dc5cf03ad64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169908)) **GitLab Enterprise Edition**
- [Improve formatting of geo:status Rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/3fddf023555a0d5a5cdc3bfac09f1cdad036ff2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171179)) **GitLab Enterprise Edition**
- [Update opt-in email copy and remove deprecated language](https://gitlab.com/gitlab-org/gitlab/-/commit/f9d532aa15393d9b4f3cd755df235e8b393cc8c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171608)) **GitLab Enterprise Edition**
- [Show warning about importing memberships when user namespace is selected](https://gitlab.com/gitlab-org/gitlab/-/commit/d5b1cfc257e3ed3c629fe17e43940f85802371fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171402))
- [Refactor auditor subclasses to their bounded contexts](https://gitlab.com/gitlab-org/gitlab/-/commit/e84a3055bdf717f1e2f14a07c4ee5a6fb9313ab3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170501)) **GitLab Enterprise Edition**
- [Remove cross-join from vuln stat adjustment](https://gitlab.com/gitlab-org/gitlab/-/commit/29fe9b5f68c354ba1dfb4a206acff2069f5538bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171830)) **GitLab Enterprise Edition**
- [Add timeout handling for release evidence workers](https://gitlab.com/gitlab-org/gitlab/-/commit/adb16c686a28cfd4581d55c7af67be527cda8eef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171011))
- [Add user ssh and gpg system signatures using signature author email](https://gitlab.com/gitlab-org/gitlab/-/commit/947c12ea10171f95bb82835e4d4b0dc284545e81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171259)) **GitLab Enterprise Edition**
- [Extract approvers mapping method to utils](https://gitlab.com/gitlab-org/gitlab/-/commit/815c9e6e6457b258f93a9c99a06cacd1330642ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171933)) **GitLab Enterprise Edition**
- [License Scanning metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/58b7203025f1f50fc2e25952be6853ee7d17eabb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169401)) **GitLab Enterprise Edition**
- [Enhance model registry and experiments permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/e24beb46edb336a23d4a3af522ee79afcb930904) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171501))
- [Keep search enabled for namespaces with evicted zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/6a0114fa84354ecd741a69c8355efcd4f07cd96c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171545)) **GitLab Enterprise Edition**
- [Add user to organization after group/project access request is approved](https://gitlab.com/gitlab-org/gitlab/-/commit/174a78a8a67e65814669f15d3149c817f85ecdea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171513))
- [Run CVE Enrichment worker once an hour](https://gitlab.com/gitlab-org/gitlab/-/commit/dade3d3a9747e539ad1cb73f5a58788fba5695f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171907)) **GitLab Enterprise Edition**
- [Remove cross-join from snapshot calculator](https://gitlab.com/gitlab-org/gitlab/-/commit/e86785acae6f8fff7eef8cd68327c4bee91aac61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171846)) **GitLab Enterprise Edition**
- [Project sidebar: Migrate color classes to design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/2be5f8dc396450a4cda1e384a948f16bfa2d01fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171717))
- [Remove autocomplete_group_search_optimization feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b0b540b57fa1527f527acbe748f21a55b0c9e9fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171898))
- [Remove feature flag to rollout code generation](https://gitlab.com/gitlab-org/gitlab/-/commit/c05c66d5498c79619a55c4d80c4dc2a9d44379b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171711))
- [Add multiple approval action support](https://gitlab.com/gitlab-org/gitlab/-/commit/27516f8c4a2aff667b3fbd6f9a735a0bdc68ad84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168297)) **GitLab Enterprise Edition**
- [Update vertical spacing of project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/634e5d51b25d16589ec7c41737d534bd6e497cd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171432))
- [Update zoekt index storage reservations](https://gitlab.com/gitlab-org/gitlab/-/commit/ac7adfbc28bd2759ed1723f907dc42896f6d3f0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168462))
- [Update link size in time tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/18bb6449898bdf015b39c9edc3bf5a16daa2fd0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171850))
- [Diff file too large warning: Migrate to design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/020813282af2faf76a9bee40e247321af0c84c92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171514))
- [Avoid setting spent at value from the frontend when creating a timelog](https://gitlab.com/gitlab-org/gitlab/-/commit/eec2285b153721f02ef62bd8fce9015710477129) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171373))
- [Update pages custom domains](https://gitlab.com/gitlab-org/gitlab/-/commit/8fa7c2845811d937d075d30800ee5d44a1bf453c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170888))
- [Add backend validation for multiple actions](https://gitlab.com/gitlab-org/gitlab/-/commit/358a0afaf093248e5aba16e1bfbc8d8e8fe2bba0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171389)) **GitLab Enterprise Edition**
- [Add actor for CreatePipelineWorker FF check](https://gitlab.com/gitlab-org/gitlab/-/commit/03945ceeb16a8bcee498b15b3081131ccba74efe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168922)) **GitLab Enterprise Edition**
- [Cleanup cte_for_group_search_access_level Feature Flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ce05a11b263d21ae5d1d11026f403a3b24408e29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171822))
- [Cleans up duo_chat_use_tool_input](https://gitlab.com/gitlab-org/gitlab/-/commit/5fb1067f8c79869cfcdff9bf7131f36667e4245a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171803))
- [Sync FK for p_ci_builds.upstream_pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/fb2350366500869537c003de2e9bdb144cd38094) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171800))
- [Model registry: Enhance model create flow](https://gitlab.com/gitlab-org/gitlab/-/commit/cb2d0def2c7a87598f703cbf62acf1e220c65cfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171370))
- [Log TriggerIndexingWorker task argument for debugging](https://gitlab.com/gitlab-org/gitlab/-/commit/a0dea2e2e705eea338c6cff954049d0a64175ec5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171791)) **GitLab Enterprise Edition**
- [Add remaining changes to topics](https://gitlab.com/gitlab-org/gitlab/-/commit/884e581c6b63c19872f64251e9eff9583ba3dd76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165066))
- [Remove search_project_query_builder feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dafe5ae94a40b2e63fd407fe853a07ccc457a162) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171312)) **GitLab Enterprise Edition**
- [Remove feature flag no_locking_for_stop_actions](https://gitlab.com/gitlab-org/gitlab/-/commit/95194c5ededaa866773bdb76ab2f82ccedabef1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171708))
- [It adds a new Keep to change worker data consistency](https://gitlab.com/gitlab-org/gitlab/-/commit/5325b7035f24e8d2d3ee59ca214844aed310224b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167993))
- [Improve standard role type](https://gitlab.com/gitlab-org/gitlab/-/commit/8277b648e3f2360e877f71785a2ae11ea704719b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170013)) **GitLab Enterprise Edition**
- [Update breadcrumbs and page headers](https://gitlab.com/gitlab-org/gitlab/-/commit/cbf63777c7942f5d33c2826eac92b21da8deddee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171025))
- [Post bot message for fail-open violations](https://gitlab.com/gitlab-org/gitlab/-/commit/06684430b6484687ef32842c7100d1195c25ec6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168844)) **GitLab Enterprise Edition**
- [Cleanup v2_chat_agent_integration feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/32daf3535d25c7b1e885c760e4d6cf353e977c20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171631))
- [Use devise authenticate_user! for search controller](https://gitlab.com/gitlab-org/gitlab/-/commit/d2fb982c5c226ea80edabdc5d720ffea7b4a8a23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171368))
- [Refactor ci templates page](https://gitlab.com/gitlab-org/gitlab/-/commit/d55fa4e490a479e763cf255722091fb7f841ad04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170016))
- [Send emails on bulk user duo seat assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/74a8c931f3869ee9991df67e827c43c8db017865) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171030)) **GitLab Enterprise Edition**
- [Update breadcrumbs for edit pages](https://gitlab.com/gitlab-org/gitlab/-/commit/3ce57dbb12b2b390d327e9a71f3169c2d4ea3bac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170637))
- [Enhance model registry version creation](https://gitlab.com/gitlab-org/gitlab/-/commit/f1b86b99985ba388c68d372169a7d5d745d8b60b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171388))
- [Extend merge request approval graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/2a42ec8f3226abeab3b33ac20c11ab2ec5fd2646) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170717)) **GitLab Enterprise Edition**
- [Removed data.js files from filters as part of the code maintenance](https://gitlab.com/gitlab-org/gitlab/-/commit/a73f9a2a77cb72e1c54606b7f5849f45453d9832) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168343))
- [Wells: Update design to match darkmode design direction](https://gitlab.com/gitlab-org/gitlab/-/commit/06a14bc2ec5e0f3730f215c3d0c8c3ac107898ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169570))
- [Add optimization for groups autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/e04506f757f5c5564de6b116f567715f3ab87512) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170948))
- [Rollout two feature flags for self-maneged instances](https://gitlab.com/gitlab-org/gitlab/-/commit/995280387a0d7ba366e7f2d28085c62192cb0a6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171462)) **GitLab Enterprise Edition**
- [Renamed Promotion Management util methods](https://gitlab.com/gitlab-org/gitlab/-/commit/f540bfbe1da5eae36316487f8d8582be31b2d70e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171081)) **GitLab Enterprise Edition**
- [Tree table: Update design for darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/be5c1b2ecc0b4429e31e48b12c0f14e06c297405) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169579))
- [User Account - Block deletion with org ownership](https://gitlab.com/gitlab-org/gitlab/-/commit/c14da813d0ac0de6d0d13898ad4020b3d32141a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170660))
- [Replace toggle with checkbox in upload file, create dir modals](https://gitlab.com/gitlab-org/gitlab/-/commit/c139e900b87bb09eddaa933ccac6cb443c63a7f3) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168789))
- [Update zoekt index used_storage_bytes on interval instead of callbacks](https://gitlab.com/gitlab-org/gitlab/-/commit/f3d15a6f59052a753837e2d7ef18ac86295183f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168668)) **GitLab Enterprise Edition**
- [Enable license_scanning_with_sbom_licenses by default](https://gitlab.com/gitlab-org/gitlab/-/commit/2835b85f6224f66dbc7edd1e286f8d237679df24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171307)) **GitLab Enterprise Edition**
- [Add clarifying help text to legacy issueable linked items input](https://gitlab.com/gitlab-org/gitlab/-/commit/33262f198a4563c69292739cce6bfcb5afc733c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170336))
- [Updates text under container image cleanup policies settings section](https://gitlab.com/gitlab-org/gitlab/-/commit/889880148322a7a76087118b83855493ce808a62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171209))
- [Update semver_dialects gem](https://gitlab.com/gitlab-org/gitlab/-/commit/2231c3029b9c58c61809d1dbf95db4f0938660ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171167))
- [Allow multiple approver actions](https://gitlab.com/gitlab-org/gitlab/-/commit/1d262497294abc47c52dbf58ea0a7cc55cdac77f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166794)) **GitLab Enterprise Edition**
- [Add projects label for exceeding number](https://gitlab.com/gitlab-org/gitlab/-/commit/6c2a8d7cd358bca77bf83d521c112c615b4532a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171342)) **GitLab Enterprise Edition**
- [Use page header component for group members](https://gitlab.com/gitlab-org/gitlab/-/commit/98215d19323005ab1a2f74c45ea7510e0678a7ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171335))
- [Allow users with permission to delete last board](https://gitlab.com/gitlab-org/gitlab/-/commit/363c6e2d9bed7a723fcb1e4be5ae3f1a83d0669b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170317))
- [Model version right sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/7fb1efa8e8d49ca2c119a3c03cc73c57b1fc3fd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170542))
- [Update contents of empty state without any issues](https://gitlab.com/gitlab-org/gitlab/-/commit/bea178f82027b31d21cc5604ed930fed70dad344) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171171))
- [Update license violation checker for custom software licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/be7d2f974d9a10eacb000fbfd308ab372ba51979) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156405)) **GitLab Enterprise Edition**
- [PA team paper cuts 17.6](https://gitlab.com/gitlab-org/gitlab/-/commit/8de2e8c7b847ec4ea6b62dd39508b7e96fde6888) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169492))
- [Replace `duoProAssignedUsersCount` usage with `duoAssignedUsersCount`](https://gitlab.com/gitlab-org/gitlab/-/commit/cbb00a09505dcdb9446a1a1d6f3553a8292736d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171295)) **GitLab Enterprise Edition**
- [Rewrite HostProbe to use Gitlab::HTTP](https://gitlab.com/gitlab-org/gitlab/-/commit/978e766c47c6183d28c0a904087f9edb9b146cc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170951)) **GitLab Enterprise Edition**
- [Feature flag clean up for purchase flow migration](https://gitlab.com/gitlab-org/gitlab/-/commit/e5d1b63e366fb5b97512a9904ee0edc298afb6f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170411)) **GitLab Enterprise Edition**
- [Expose signature author email from gitaly](https://gitlab.com/gitlab-org/gitlab/-/commit/7c6f851067ff6389a00c4dc78d3c542ccbce7c6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171258))
- [Initial checkin for Groups Duo Home Page](https://gitlab.com/gitlab-org/gitlab/-/commit/f100a80382fe71105a54a90ed6f6044983e57f97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168295)) **GitLab Enterprise Edition**
- [Allow for `closed_by_id` param in issues API queries](https://gitlab.com/gitlab-org/gitlab/-/commit/2be56f801726a1b652d6906cef2e739a47b29849) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170655))
- [Update admin breadcrumbs and page headers](https://gitlab.com/gitlab-org/gitlab/-/commit/c1a6aff481af20777e7f717035341a5ecf6e82b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170860))
- [Notes: Migrate to section tokens to unbox darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/4466aa36bae2e882d2375af0fcb426d2a9e32dc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170543))
- [Update layout of alert header](https://gitlab.com/gitlab-org/gitlab/-/commit/48592435ba8d5f1a0b0781ad4c7219a4a3632484) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171168))
- [Add migration for setting Namespace organization_id to 1](https://gitlab.com/gitlab-org/gitlab/-/commit/46cc5315d4fab1faadac9bee0c43029c0e4453e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170997))
- [Job log detail line number: Migrate text value](https://gitlab.com/gitlab-org/gitlab/-/commit/0a029d78a35c967e41c5a3243b5951756e62cf1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171129))
- [Use elastic retry setting for search requests](https://gitlab.com/gitlab-org/gitlab/-/commit/2a6fddae8ff0bd725bcbc2332828c0c92405d3bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170572)) **GitLab Enterprise Edition**
- [Remove FF prevent_job_token_admin_permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/b21f2bd4bf194e4194313a8eff54823c5716bcd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169149))
- [Show release notes on deployment approval page for tagged deployments](https://gitlab.com/gitlab-org/gitlab/-/commit/e36ab700ef980e63feba40e0ec7bf136a5925f51) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169830)) **GitLab Enterprise Edition**
- [Modify text for scheduled policy scan concurrency](https://gitlab.com/gitlab-org/gitlab/-/commit/211045487fc478c702197be5a8dc1485fd4225eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170783)) **GitLab Enterprise Edition**
- [Use lowercase text for environment badges](https://gitlab.com/gitlab-org/gitlab/-/commit/36cde1410d2a2b6706598ca96b353883ca138755) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171033))
- [Use calendar-overdue for past due dates](https://gitlab.com/gitlab-org/gitlab/-/commit/ba8ec0e47cc5817e66d1601e4ddade6283d4366e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167370))
- [Update layout of edit application page](https://gitlab.com/gitlab-org/gitlab/-/commit/3646eb584fca2f3c17a7bd7600fdca5ecaca30c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170858))
- [Add multiple approvers action support](https://gitlab.com/gitlab-org/gitlab/-/commit/2980c5ee7d5b0491f2bcf6bf33b93fa4a3e376c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168583)) **GitLab Enterprise Edition**
- [Changed Global Search modal scoped search position](https://gitlab.com/gitlab-org/gitlab/-/commit/b07ffc0d5097e64d0da646ba0f8fd8f71ed73f72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169780))
- [New runner page: Use PageHeading component](https://gitlab.com/gitlab-org/gitlab/-/commit/6c78b23fec1a25d06e63182f228158eb497061d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170804))
- [Adjust report abuse layout](https://gitlab.com/gitlab-org/gitlab/-/commit/e443306c8cb24da9576dfd566ccdc062ee680543) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170855))
- [Update false positive have uniform text size](https://gitlab.com/gitlab-org/gitlab/-/commit/7e3f413eb01d8def4699807c4ab3cafa763f435a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170952)) **GitLab Enterprise Edition**
- [Update embedding developer docs](https://gitlab.com/gitlab-org/gitlab/-/commit/7fcda2cbd8e120f4deaacb163c1affcfb6368dc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170581)) **GitLab Enterprise Edition**
- [Refactor pipeline editor drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/0890d3c8a89eb1120d435cbd715f362290303794) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170001))
- [Model registry: Improve model listing](https://gitlab.com/gitlab-org/gitlab/-/commit/1beb9ac93e782c723cd4f6848ae5e68ebe4bb932) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170276))
- [Replace prop drilling in pipelines.vue with provide/inject pattern](https://gitlab.com/gitlab-org/gitlab/-/commit/173ab0d11158d9d832d6f90b957f08571a145e65) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170906))
- [Add link to Epic modal trigger button](https://gitlab.com/gitlab-org/gitlab/-/commit/7dbc9e7a9e52741d724c19b02056d5dfdadc059c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168777))
- [Add instance setting to enforce CI job token scope](https://gitlab.com/gitlab-org/gitlab/-/commit/c5db6d1f931607f1ba173a17fe848efa66f2416f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170232))
- [This MR cleans out feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0940d14e9556f52bae481dfe2a342d4f829b5acc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165870)) **GitLab Enterprise Edition**
- [Update layout of admin edit project page](https://gitlab.com/gitlab-org/gitlab/-/commit/24ea9c7b48a79da3593e3be73b6f14bddccd814f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170826))
- [Adds migration to make file_checksum colmumn nullable](https://gitlab.com/gitlab-org/gitlab/-/commit/cbe73c462b249e9bebd283f01bc43b5e08bbc241) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169920))
- [Job page: Migrate to use design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/265144e6b29359f121e8d8bc22ee895f96b9117f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170398))
- [Move WorkerDataConsistency inline disables to external file](https://gitlab.com/gitlab-org/gitlab/-/commit/33153cacc444a9c1d813a96cab40f48e7c8974bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167337))
- [Improves custom email verification SMTP error logging](https://gitlab.com/gitlab-org/gitlab/-/commit/d27ab1307e526b2d8e96eb087857c47d417acb55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169728))
- [Remove feature flag `async_rewrite_history`](https://gitlab.com/gitlab-org/gitlab/-/commit/2ad9140855a541ffdecad4083fcfe640913dcde9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169888))
- [Add slash command GraphQL query for Duo Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/46872ad0c856de80e1f1294a3f46a318fd83479c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169641)) **GitLab Enterprise Edition**
- [Replace `span` element by `button` in the group dependencies to fix a11y](https://gitlab.com/gitlab-org/gitlab/-/commit/112b1f5b09f2353895309d38bbbae4e22fff80a4) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170644)) **GitLab Enterprise Edition**
- [Drop the editor feild from the workspaces table](https://gitlab.com/gitlab-org/gitlab/-/commit/d2924145f440489f4aaa8104bd237adc8448f37c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167823)) **GitLab Enterprise Edition**
- [Fix alignment of actions in requirements drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/35dea2b383be47866313ac1d7a4c0fea20abdaad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170635))
- [Replace GlSegmentedControl with a more modern component with better UI](https://gitlab.com/gitlab-org/gitlab/-/commit/30f76a1f294c97d78adabea5cd23256db0270f06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170594))
- [Improve regexp for system note email obfuscation](https://gitlab.com/gitlab-org/gitlab/-/commit/4e07a7ea87aa73055a7d764573dd6d56c5ed57ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169165))
- [Wiki form: Don't disable submit button](https://gitlab.com/gitlab-org/gitlab/-/commit/6859d11fafc72d9febaf25c8f30948a3c64dce74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170561))
- [Add policy type for breadcrumb](https://gitlab.com/gitlab-org/gitlab/-/commit/863a4a06792232509fd1b0cdbf11c706db5a3760) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168970)) **GitLab Enterprise Edition**
- [Adds application setting for elasticsearch retry on failure](https://gitlab.com/gitlab-org/gitlab/-/commit/fbdb921ee995ac97a8446bc331e8e961456354cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169903)) **GitLab Enterprise Edition**
- [Enhance model registry model version deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/f1a3d6dada8f8fc5346da06ce494dd31d4cfa826) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170210))
- [Add organization_id to oauth_device_grants table](https://gitlab.com/gitlab-org/gitlab/-/commit/5784d3658019d7ccf0e221dc8e92e00b9b1d4e93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170391))
- [Update Duo troubleshooting docs](https://gitlab.com/gitlab-org/gitlab/-/commit/0fe577d5d49edad2522f9efdb43ed4221c062b22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170384))
- [Restore scheduled deletions if the user loses group/project access](https://gitlab.com/gitlab-org/gitlab/-/commit/e6579622695fb50389bda8cd2f7cdf593410830c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165963)) **GitLab Enterprise Edition**
- [Enhance model registry model deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/a313788a04efc56742ebe2df0c3d6c99eb1ff7ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170211))
- [Set zoekt enabled namespaces to have search enabled by default](https://gitlab.com/gitlab-org/gitlab/-/commit/1efc19bf3fc91767a39dd477164c8601334e11f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170480)) **GitLab Enterprise Edition**
- [Remove transition animation of copy code button](https://gitlab.com/gitlab-org/gitlab/-/commit/3b4f7691908a5c814e53ef23a104512fc62d74af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170478))
- [Add edit text to edit snippet breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/c88c93d678a2dc15ec173e225838dde4dff07907) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170157))
- [Clean up the UI for the protected environments settings](https://gitlab.com/gitlab-org/gitlab/-/commit/28c9939ee36616ae719847f6a146e023f03af62d) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169757)) **GitLab Enterprise Edition**
- [Index work_item embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/87dc78309b83cad17c0ecee27e0ebc3de6fa8198) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169260)) **GitLab Enterprise Edition**
- [Adjust Bulk create/remove limit for up to 100 assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/8154d248b42d415b2b94cc53b4df15e1ed594fe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170150)) **GitLab Enterprise Edition**
- [Enabling group_level_dependencies_filtering_by_component by default](https://gitlab.com/gitlab-org/gitlab/-/commit/1cef27de0998eb52f4691e98bd067283fb3ac97b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170453))
- [apps/settings: Extend maximum token and SSH key expiration to 400 days](https://gitlab.com/gitlab-org/gitlab/-/commit/dc4177b1d3e6bdcb731ecc7e2969cf0f8291d6fc) by @ben.boeckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153876))
- [MR widget: Migrate to use design tokens to update darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/6c82986a5659bd75cd9531dab4c35fc1ef7ff0da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169597))
- [Remove cross join exception](https://gitlab.com/gitlab-org/gitlab/-/commit/c10ae321e3adef890a1a447bdd32e2ab962dcf32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169558)) **GitLab Enterprise Edition**
- [Model registry: Improve model version listing](https://gitlab.com/gitlab-org/gitlab/-/commit/472cea564d3db58ea732876d1d4421db5645dd08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169448))
- [Default enable ff_pages_use_open_file feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7a602a1941bdaa5a77e138ec10de2137010de4df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169952))
- [Secure policies edit: Move delete action to right side](https://gitlab.com/gitlab-org/gitlab/-/commit/023e6ade1c8f8e71d4f05a9c7546fc0a72a810e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169943))
- [Fix links in pipeline editor helper](https://gitlab.com/gitlab-org/gitlab/-/commit/b5cdb8009994a1884c92d6a6d2b4e57f3468f976) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170378))
- [Finalize BackfillRootNamespaceClusterAgentMappings migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c9cd32f09398d7fb80aa752b35fbb4c6764f3a2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170341))
- [Always search through zoekt replicas](https://gitlab.com/gitlab-org/gitlab/-/commit/08d4b70624e677fc36079c69fd286a7d83978e7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168427)) **GitLab Enterprise Edition**
- [Move model registry model editing from modals into forms](https://gitlab.com/gitlab-org/gitlab/-/commit/9b1f421c458a1c931f18b7657e8226a190e4acab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169818))
- [Increase zoekt bytes limit to 450 GB](https://gitlab.com/gitlab-org/gitlab/-/commit/2e72cc3420688ad77e3bf46d42bc0bd681ab3f1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170164)) **GitLab Enterprise Edition**
- [Increase zoekt indexing timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/2f1ab58ba2cdf878f2d3fb27ec128943b78622ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170162)) **GitLab Enterprise Edition**
- [Improve security policy comparison before persisting](https://gitlab.com/gitlab-org/gitlab/-/commit/f6ac5ff4c555adec1e508b2176d6f36c96a3b909) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169174)) **GitLab Enterprise Edition**
- [Update empty policy list page svg](https://gitlab.com/gitlab-org/gitlab/-/commit/963ad5545251afe6354ff439756170ffcc4470b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170271)) **GitLab Enterprise Edition**
- [Disable add action button when limit is reached](https://gitlab.com/gitlab-org/gitlab/-/commit/b189041c366d6dbb0eb0187b34e28f06e48acfe3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169953)) **GitLab Enterprise Edition**
- [Deprecate `force_push_regex` and `delete_branch_regex` from push_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/1c586e1351f868c47f6bf4886bf27495791ddf10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170266)) **GitLab Enterprise Edition**
- [Pipeline editor: Replace the commit confirmation alert with a toast](https://gitlab.com/gitlab-org/gitlab/-/commit/776adf4a5172bcbc925824f0624551260e05f439) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168672))
- [Editor: Use design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/474e849b5982112431ead288ff46500f7e5c415c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170256))
- [Sidebar nav: Change background in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/f12409003c25aa9aa3a14cebaeb3e0649d9b13ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169573))
- [Add name to paths in edit label and milestone pages](https://gitlab.com/gitlab-org/gitlab/-/commit/16ebd3a72ba43068e2fe62eb48c72e1bbd283409) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170160))
- [Increase create work item toast delay](https://gitlab.com/gitlab-org/gitlab/-/commit/85c1272ec810903a6457fe80c119b0e4db41b183) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170015))
- [Model registry: Improve empty version description state](https://gitlab.com/gitlab-org/gitlab/-/commit/6756c98e4f3c31d67802c9d3505552da6deca48a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169572))
- [Expose schedule name](https://gitlab.com/gitlab-org/gitlab/-/commit/d1d9eb80e60a84cb7ae649d165740cc899829936) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169500))
- [Modify the way the zoekt multi-result loads](https://gitlab.com/gitlab-org/gitlab/-/commit/94eaf39d21b64e9f2d9c7a9bd8c41bd22aac708e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167435)) **GitLab Enterprise Edition**
- [Cache user project authorizations for faster autocomplete and search](https://gitlab.com/gitlab-org/gitlab/-/commit/09c31ff25305c1e2e66f5e3c916e1553bf4ca8d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169630))
- [Update blob delete modal](https://gitlab.com/gitlab-org/gitlab/-/commit/9a8161bc94cafec3b10cc54f7df636ab0cde66cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168992))
- [Move model registry model editing from modals into forms](https://gitlab.com/gitlab-org/gitlab/-/commit/340e5061819b747d33a4047656b61cbc4443e9d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169544))
- [Store abuse report labels separate from project/group labels](https://gitlab.com/gitlab-org/gitlab/-/commit/e6dd2472980026114dae8143f790680a3a9a02c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168186))
- [Allow overriding of ingest and query O11y URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/17a5f90441be08fbe6a5d02a8577f1312c23e083) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169439)) **GitLab Enterprise Edition**
- [Swap beta badge component on Self-hosted models page](https://gitlab.com/gitlab-org/gitlab/-/commit/0e57ebc6ae1f57db0ef960aae0209a741013a4d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169778))
- [Define sharding key for `snippets`](https://gitlab.com/gitlab-org/gitlab/-/commit/978f7aa2978597ced644761879e0fc1ea58c2577) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160060))
- [Finalize `ResolveVulnerabilitiesForRemovedAnalyzers` migration](https://gitlab.com/gitlab-org/gitlab/-/commit/fc93d5b86846cabd12532e4b9b21b2bef8df0c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169339))
- [Adds knn index setting for opensearch clusters for workitem index](https://gitlab.com/gitlab-org/gitlab/-/commit/bdd0c9f4d4867ae6149874ec2f2650ab6e72854b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169560)) **GitLab Enterprise Edition**
- [Show copy action in milestone list](https://gitlab.com/gitlab-org/gitlab/-/commit/095a8a762382d96b7df9b3776a2004e5e7773976) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168868))
- [Add job to run rubocop docs link check in docs pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/e1dc2875eb7c7fb7331f8cba15d3a1504744d5f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169734))
- [Cleanup feature flag ff_compliance_audit_mr_merge](https://gitlab.com/gitlab-org/gitlab/-/commit/6925d2b0a4de95d3b5144f1278bc0e200d364279) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169892)) **GitLab Enterprise Edition**
- [Your work MR dashboard: Align approval badge icon on left side](https://gitlab.com/gitlab-org/gitlab/-/commit/8e1e3a8f6a292d5abc957064a5353d4796c25e71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168960))
- [Allow changing synced work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/8070812ea33c8cd0d48004fe4457bdaa46c8229d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169875)) **GitLab Enterprise Edition**
- [Update usercap email to use standard email template](https://gitlab.com/gitlab-org/gitlab/-/commit/c3c040cbc932afe3d7f390355d87c4e955d6b25c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169865))
- [Mirror repository email apply standard template](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a77bf1229000cb6af0c9d43c1770d6d2db073b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169859))
- [Remove allow_cross_joins_across_databases](https://gitlab.com/gitlab-org/gitlab/-/commit/cfe5d64af45981f8f19e3dc2b478cd0b4b5b8b3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168348)) **GitLab Enterprise Edition**
- [Groups Projects - Unify Restore UX](https://gitlab.com/gitlab-org/gitlab/-/commit/754f60ae614e060f34c70d90361e88995ed4ccc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168696)) **GitLab Enterprise Edition**
- [Remove `access_token_pagination` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1d0142aad67bd12f5562357e873a2eca19be9d9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169765))
- [Restore opt-in values from temporary table](https://gitlab.com/gitlab-org/gitlab/-/commit/78f57f4b8c1dae45f69bad4377c47c26f123f7c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165155)) **GitLab Enterprise Edition**
- [Add not null constraint on p_ci_stages](https://gitlab.com/gitlab-org/gitlab/-/commit/23539c48a7bf97fefd982dab2bcad840fae9383a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168568))
- [Use search service for project autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/aa4f075cccda7027df738417b92bb4151e72942b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169425))
- [Changed placeholder text in global search modal](https://gitlab.com/gitlab-org/gitlab/-/commit/1119741f9d85a6b88d2b79c5cb1ced396fc56c2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169752))
- [Update delete approval rules query to use index](https://gitlab.com/gitlab-org/gitlab/-/commit/456055d74a174b047c11984d9e06cca666f2429c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169353)) **GitLab Enterprise Edition**
- [Fix rubocop violations from docs links](https://gitlab.com/gitlab-org/gitlab/-/commit/aa5403d5cdfa85c74f2f62a6f71a50df2cf561a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169682)) **GitLab Enterprise Edition**
- [Updated error message when VR MR suggestions can’t be created](https://gitlab.com/gitlab-org/gitlab/-/commit/5fcddce47e87fd03c6abc88a2a62dc406324ca02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168986)) **GitLab Enterprise Edition**
- [Remove unused table classes in alert details](https://gitlab.com/gitlab-org/gitlab/-/commit/a76f31ca4bf3585fbb9775d09018950c80cadb81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169424))
- [Add call to action to issue analytics empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/69cc1320fb23457ab2cce2e975ca745485d5bad1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168132)) **GitLab Enterprise Edition**
- [Allow vertically resizing markdown and rich text fields](https://gitlab.com/gitlab-org/gitlab/-/commit/7ba0ae9ee225041eed2e2b25c204e521d41e2bdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169634))
- [Use routing table name for BuildTraceMetadata model](https://gitlab.com/gitlab-org/gitlab/-/commit/0dc648e18a33931303695dfe36385f4cb88818b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169234))
- [Model registry: Improve empty version description state](https://gitlab.com/gitlab-org/gitlab/-/commit/ecee83d6923274dc04f089c394c856d8fa40d089) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169562))
- [Add title attribute to MR list diff stats](https://gitlab.com/gitlab-org/gitlab/-/commit/6af160ae941b6eb9f70626e929d862e1695581e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169510))
- [Add back refetchQueries to placeholder_actions](https://gitlab.com/gitlab-org/gitlab/-/commit/981584e8202078fab0aa47014ac6a14c2ac01445) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169316))
- [De-emphasize required approvals in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/a5934d21b009abf69b90a7c53738fbeb48c4c0db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168428))
- [Replace label fuzzy search with exact search for VSD](https://gitlab.com/gitlab-org/gitlab/-/commit/706a08d1cda427ef756d602bcade6f3184cb29c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169073)) **GitLab Enterprise Edition**
- [Transition vulnerability feedback to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/079fb26a70038642d935c4171f4ac7c50f11456d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168978)) **GitLab Enterprise Edition**
- [Remove `webauthn_without_totp` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2dcdda2f62c2a763260b9744b6f5ca69a5d73c3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116527))
- [Add feature flag for zoekt index circuit breakers](https://gitlab.com/gitlab-org/gitlab/-/commit/7a90836369b4fe1b1f0ee139b68b96d7403d57cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168566)) **GitLab Enterprise Edition**
- [Move model registry UI away from modals into pages](https://gitlab.com/gitlab-org/gitlab/-/commit/42261e4bed235029741ec58845e2a6ebb6faf275) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168935))
- [Backfill project_id on Ci Stages](https://gitlab.com/gitlab-org/gitlab/-/commit/89d91becd29862b828d3ae48085f9abc538fb2a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168135))
- [Crud: Migrate design tokens to use section tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/30ad484740b9395aa515d70a813172988b43df61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169455))
- [Add organization_id to OAuth tables](https://gitlab.com/gitlab-org/gitlab/-/commit/14c26b5181675aea6e29299e02600bc9064e9ca5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167668))
- [Prepare async fk validation for p_ci_builds.upstream_pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/11317e1aae24a44a65e9a825c9f9caf16b29c14a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169229))
- [Reorder note actions](https://gitlab.com/gitlab-org/gitlab/-/commit/40ee27455ab3e3290531e278f4fa87e3c502fbb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168578))
- [Sync security_policies when project is added to group](https://gitlab.com/gitlab-org/gitlab/-/commit/07815a4a504fd15f60916013f309c62b7deea173) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168850)) **GitLab Enterprise Edition**
- [Remove error message if replication not enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/1abd53e9a1653ba35567e85bdbbc4a71bb7ff2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167925)) **GitLab Enterprise Edition**
- [Bump Gitaly gem to 17.5.0.pre.rc1](https://gitlab.com/gitlab-org/gitlab/-/commit/f15a062e13b7f4c0a2eedb2c49c8113e34f0e10b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169279))
- [Implement new Duo Pro trial widget design](https://gitlab.com/gitlab-org/gitlab/-/commit/b7289103751e4f0a328aa367cbdd422b5c400b4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168790)) **GitLab Enterprise Edition**
- [Update CI templates for Browser Performance Testing](https://gitlab.com/gitlab-org/gitlab/-/commit/800200ee9c543ef64664b9af8fa216212d18a38e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168082))
- [Put Geo::MetricsUpdateWorker behind a feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/601d8b154b2ad7449efe63f94c4b0a76383cdd34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169346)) **GitLab Enterprise Edition**
- [Remove set_delete_failed_container_repository flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2fa07cdd451e8e7a44f8c90f8cc618149d1ee354) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169040))
- [Remove ci_hidden_variables ff](https://gitlab.com/gitlab-org/gitlab/-/commit/8a6d4bdcd81a733f9d33b5b575544ab1bb5741cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165843))
- [Surface which unspecified stage was incorrectly chosen](https://gitlab.com/gitlab-org/gitlab/-/commit/f0502450334c0434b1d322fb323b9127611c6f3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165998))
- [Show the vulnerability report even if 0 vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/721fa3adf40509596910891566882457a1adc4c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167948))
- [Add the bootstrap command to the agent creation modal](https://gitlab.com/gitlab-org/gitlab/-/commit/b06d8a3727b6cb0da82505979df6b089d3bfcac7) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169188))
- [Improve SBoM search performance with a inverted index](https://gitlab.com/gitlab-org/gitlab/-/commit/9f34616c19ed2744c1a271acf02f4b0de80e3848) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168962))
- [Update empty states on group landing page](https://gitlab.com/gitlab-org/gitlab/-/commit/5cb0140b4510fb1ae99c8fadb246b125dd598abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168656))
- [Finalize rename of ::Abuse workers to ::AntiAbuse bounded context](https://gitlab.com/gitlab-org/gitlab/-/commit/8e4f8372fbb6b94b32dddf400111af2c3e5aee10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169198))
- [Rename duoProAssignedUsersCount GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/66d59a54832260d539d87433e91e743aa39a0201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169105)) **GitLab Enterprise Edition**
- [Back up secrets.yml if it changes](https://gitlab.com/gitlab-org/gitlab/-/commit/2169cb60de57a7aa5b3121485a0b3487466e516e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169024))
- [Update pipeline mini graph upstream/downstream](https://gitlab.com/gitlab-org/gitlab/-/commit/13f3ccf3994a6078fd1d317a49d41bfaf0ef8c66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168567))
- [Require password to delete WebAuthn devices](https://gitlab.com/gitlab-org/gitlab/-/commit/ef824d67b766c95d0baaca9ac1c09c6d18bbaa40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168976))
- [Work item hierarchy - Prevent dropping in child when type is not allowed](https://gitlab.com/gitlab-org/gitlab/-/commit/e94f02b836ef8289b64fe73d48c91d3993d11e1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168594))
- [Roadmap - Expand caret does not display if no children in timeframe](https://gitlab.com/gitlab-org/gitlab/-/commit/8db995ef3b05a706ed8d1e3762ccb1c3647b9006) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156595)) **GitLab Enterprise Edition**
- [Identify masked variable output clearly](https://gitlab.com/gitlab-org/gitlab/-/commit/463d8a4da6fbe5f09f948347d06ccb2b30e609fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160097))
- [Adding limit constraints on frameworks and requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/c8bbf4d234972c6f1393e82a1bd7a1704aef6aab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168608)) **GitLab Enterprise Edition**
- [Use `helpPagePath` to render container registry documentation links](https://gitlab.com/gitlab-org/gitlab/-/commit/4ef7cc8bf2b3d09794476c18f1a51c7a7ef76647) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168283)) **GitLab Enterprise Edition**
- [Show confidential action disabled when unavailable](https://gitlab.com/gitlab-org/gitlab/-/commit/0237b7d55e50ad4c22a8727f7ef8fd708160efb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168405))
- [Add "skipped" as valid state for commit status API](https://gitlab.com/gitlab-org/gitlab/-/commit/829cccc24401c7733181cf7891264d3c678dc014) by @marthyn.elzes ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168350))

### Deprecated (1 change)

- [Deprecate GitLab chart NGINX controller image v1.3.1](https://gitlab.com/gitlab-org/gitlab/-/commit/95281fe16aa7a78ad6aa2fa82a6eeca16cf6e83c) ([merge request](https://gitlab.com/gitlab-org/charts/gitlab/-/merge_requests/3901))

### Removed (27 changes)

- [Remove scan_execution_pipeline_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2b19aaf2368eb96c93efe2e8676e90ecabcbd3b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172719))
- [Remove dead legacy pipeline mini graph code](https://gitlab.com/gitlab-org/gitlab/-/commit/eb19a1b96cccd3b9acbcbff3704f2c2d63c0d54a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172155))
- [Remove faulty async index definitions](https://gitlab.com/gitlab-org/gitlab/-/commit/721848957268670ef5948ddf2de79ba618f2401a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172546))
- [Removed feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6f4450c65cbd3cc982f0eaae59bcb1712e03663c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172502))
- [Remove commented code](https://gitlab.com/gitlab-org/gitlab/-/commit/f83666a77be8461c0f1fb9387a24318d2f18e447) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172585))
- [Remove `confidence` column from `vulnerability_occurrences`](https://gitlab.com/gitlab-org/gitlab/-/commit/7aa754f58086e9da84ab8575e604a6f6f0d2d510) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172414))
- [Remove generate description rails feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/25d41c4664c7227ecc8195683b6430a844ba3052) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172192))
- [Removes finalized BBM for project stats](https://gitlab.com/gitlab-org/gitlab/-/commit/3ec2fa300fab10c83672f802ab1e5e6c6524ca88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171531))
- [Remove BAS security configuration option](https://gitlab.com/gitlab-org/gitlab/-/commit/e963dd301ba63f95eb3f988cb778fe3ea3f8e8c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169563)) **GitLab Enterprise Edition**
- [Remove stepper in policy editor](https://gitlab.com/gitlab-org/gitlab/-/commit/1234bcd9019abe5f0276becd817d173a750c37db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171750)) **GitLab Enterprise Edition**
- [Removes finalized background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9b80130cf3d9232869a3f157f76e21109dd9c8b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171396))
- [Cleanup duo_free_access_ending_banner feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0bf4b5816955186e88779adfafdf7a666dbae040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170868))
- [Drop old temporary vulnerability management indices](https://gitlab.com/gitlab-org/gitlab/-/commit/d16898490e7cf6120ea583a94b2544665ef4e1cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170488))
- [Drop user_canonical_emails table](https://gitlab.com/gitlab-org/gitlab/-/commit/fc8875d9d54ae2fda5ea5e73d439f06c7abcabb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169963))
- [Remove `vulnerability_occurrence_pipelines` table and code](https://gitlab.com/gitlab-org/gitlab/-/commit/bdebec6cc8c4c3ca3946e780b8b735f776cd02fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170153)) **GitLab Enterprise Edition**
- [Remove tmp index from vulnerability_reads for bbm](https://gitlab.com/gitlab-org/gitlab/-/commit/ee18e43632a6de0a0c8ba72dbcb8b02e8dcb3308) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164430)) **GitLab Enterprise Edition**
- [Remove `namespace_id` from `vulnerability_reads` table](https://gitlab.com/gitlab-org/gitlab/-/commit/ab89077e9e8a1708ab0633aada5e5fa5f89be79e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167643))
- [Remove database table packages_composer_cache_files](https://gitlab.com/gitlab-org/gitlab/-/commit/a9a6b84473efeb90395bdff77321128fe167b83c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159904))
- [Remove feature flag and code combining queries](https://gitlab.com/gitlab-org/gitlab/-/commit/6154e6d1153d6469ed94c4d35a5d75bd03967d28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170025))
- [Remove sharding key issue url keys](https://gitlab.com/gitlab-org/gitlab/-/commit/652b0566488dd001df1a1a5ac69f11f97adf7f77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169869))
- [Remove Packages::Composer::CacheFile and related code](https://gitlab.com/gitlab-org/gitlab/-/commit/6373f7a1822952d817cfd2550bb31a12fa492a6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166344))
- [Delete no longer used BBM code ahead of Sec Decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/751756c99705c8cb0eaebd724edebc1868766a5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167795))
- [Remove labels parameter](https://gitlab.com/gitlab-org/gitlab/-/commit/db46f90d4827b13cefea113dbd42de46cdf17c28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168671)) **GitLab Enterprise Edition**
- [Remove unused vulnerability header CSS](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c8fd64387ba36f3222a92f2353d749bce25dc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169227))
- [Clean up ci_require_credit_card_on_trial_plan feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/53bfbf6861eabfa1bcdc0da4584674008b7ede5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167139)) **GitLab Enterprise Edition**
- [Remove cross join suppression ahead of sec-decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/448721709339f5c5163ed7da01ba99e689189da3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168227)) **GitLab Enterprise Edition**
- [Remove user canonical emails](https://gitlab.com/gitlab-org/gitlab/-/commit/3c4918cc2946fb661e06f3eb4740a5232d17f94b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167687))

### Security (15 changes)

- [Update rails-related gems in gems folder](https://gitlab.com/gitlab-org/gitlab/-/commit/b8bf70b34db2aa27c7a50686a09300713edfd135) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172257))
- [Removed id from authorize buttons and added specs](https://gitlab.com/gitlab-org/gitlab/-/commit/ddf06283c33c5b7828843421812353dfaeee2551)
- [Prevent agent access via unconfirmed or disallowed group members](https://gitlab.com/gitlab-org/gitlab/-/commit/a4c417f124d62068cbf829248f243f9c2e7d1333)
- [Details of blocking merge request can be exposed via list](https://gitlab.com/gitlab-org/gitlab/-/commit/3ed2ec16854bec0b0463207c3c2c604af0635ddb)
- [Remove is-unsafe-link from product analytics tables to prevent XSS](https://gitlab.com/gitlab-org/gitlab/-/commit/80eb472665efdf13beb9296faa1c4149059fd042)
- [HTML injection in vulnerability Code flow leads to XSS on self hosted instances](https://gitlab.com/gitlab-org/gitlab/-/commit/5e822c1e27a1b26518c6ec8ef4ca8f4650f84c82)
- [Use custom adapter for parsing FogBugz XML](https://gitlab.com/gitlab-org/gitlab/-/commit/3880dcd2b426d3bbc384dbdb3146935c643a30af)
- [Update nokogiri to fix recent CVEs](https://gitlab.com/gitlab-org/gitlab/-/commit/bbcb1c987d2f0df2e7731cee25b4aa9aaf253f45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171655))
- [Limit ProcessCommitWorker by number of branches](https://gitlab.com/gitlab-org/gitlab/-/commit/268840eaf7ca2328cd3dc2307ed10b86618221cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171786))
- [Update rexml to fix CVE-2024-49761](https://gitlab.com/gitlab-org/gitlab/-/commit/311f5b34a38d669dc3e2633f42d81b9f27bf43c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171537))
- [Bump rack minor versions to patch CVEs](https://gitlab.com/gitlab-org/gitlab/-/commit/fe50ebd6cc23b23e3eb859d1b91570d20cbbdf13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169705))
- [Fixed HTML injection in Global Search bug - renamed branch](https://gitlab.com/gitlab-org/gitlab/-/commit/036d7b2cc710cd00a2068b38dfcdf0ea0f8472cb)
- [Limit max size of manifest file upload](https://gitlab.com/gitlab-org/gitlab/-/commit/505c055c8c22a93b32dfc0c0738fd93f81b38335)
- [Update rexml to fix CVE-2024-41946](https://gitlab.com/gitlab-org/gitlab/-/commit/8feae3956828b94ff84f25affc41e61750baa5d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169632))
- [Set Global timeout for Regexp to prevent ReDOS](https://gitlab.com/gitlab-org/gitlab/-/commit/10fd9dfc9473a842fe70a4dd6157b3622215045f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145679))

### Performance (17 changes)

- [Set PipelineProcessWorker to use sticky data consistency for main db](https://gitlab.com/gitlab-org/gitlab/-/commit/36c68da9ee42a84d1aa792d66c2db6d18f405b26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166729))
- [Optimize the upload confirmation endpoint in the virtual registries](https://gitlab.com/gitlab-org/gitlab/-/commit/5c9fdf3d64e99088ae36e7bf07cb8ca0cbd7a1b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171297))
- [Default to sticky for Ci::BuildFinishedWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/cca08652196e49738eda2115dfd60904230a1493) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171794))
- [Use CTE for Group access_level search](https://gitlab.com/gitlab-org/gitlab/-/commit/137d4af853b21e403b386f4bac40f47c839313f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171735))
- [Prepare index for faster search build name](https://gitlab.com/gitlab-org/gitlab/-/commit/8353654aa96a48be325497cec325a8877f81cf96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170836))
- [Optimize: custom ability verification](https://gitlab.com/gitlab-org/gitlab/-/commit/0116846250515a7d95a1813f658156aef2d2fc54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170610)) **GitLab Enterprise Edition**
- [Enable CI kubernetes variables optimization for pipeline creation](https://gitlab.com/gitlab-org/gitlab/-/commit/31c3788b549ba493988bb025d65b9cb0a7813185) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170763))
- [Use `:delayed` or `:sticky` data_consistency for cleanup policy workers](https://gitlab.com/gitlab-org/gitlab/-/commit/aef46aad9676cf191a2766cf538760d5709fc013) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170103))
- [Use sticky data consistency for InitialPipelineProcessWorker by default](https://gitlab.com/gitlab-org/gitlab/-/commit/7d8ecff7a1ff0cfde91099f679cfe9b16616892e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170218))
- [Optimize: association loading for RepositoryController](https://gitlab.com/gitlab-org/gitlab/-/commit/86dd58fcd149947c23b8eb9b36216aa56e4661bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169280))
- [Remove permissions JSONB column from the condition](https://gitlab.com/gitlab-org/gitlab/-/commit/e6cbe19b446047cc3d9c810175d137e851784d82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169094)) **GitLab Enterprise Edition**
- [Update import_export_uploads sharding](https://gitlab.com/gitlab-org/gitlab/-/commit/375b4e6d2b08b0698ef674ab58d70abe170d4a73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168392))
- [feat: Update Occurrence group scope to rely off traversal_ids](https://gitlab.com/gitlab-org/gitlab/-/commit/8da7a6c720236725f962a60078276591864d0a8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168704)) **GitLab Enterprise Edition**
- [Create multi not null constraint for exports](https://gitlab.com/gitlab-org/gitlab/-/commit/7b6dc073fc9ad36c0d3f0f44b39806e96247d366) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168411))
- [Optimization: don't load a User when user_id is missing](https://gitlab.com/gitlab-org/gitlab/-/commit/fea653f28468b9fa996cd881b2fde5d769e07659) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169163))
- [Optimization: don't load group if not needed](https://gitlab.com/gitlab-org/gitlab/-/commit/9e5ad5aa54e684cbe3d8f60187531e6cee07b80b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169276))
- [Improve performance of issues autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/21c3c7c4eb5504ef23672db3c02aba503672a3ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169235))

### Other (258 changes)

- [Backfill project organization_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/588fb65383c52ff25c7741ef2a2cee0a683fc07d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170206))
- [Add non id primary key support for backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/f57eaab1fa59e012f09e0ae2dd11c3506f844219) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170680))
- [Remove dependency_list_exports from wip](https://gitlab.com/gitlab-org/gitlab/-/commit/cf6e3059178e4356d7028e1728e4d29807ae4e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172746))
- [Unquarantine project subscriptions spec](https://gitlab.com/gitlab-org/gitlab/-/commit/0986a9258a55a01762bf469d62c76668eedca7ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172976)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/86a1846acdb6eca7b540bc60a008da835f8a625c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172920))
- [Add PIPL email sent timestamp](https://gitlab.com/gitlab-org/gitlab/-/commit/965e564a8d289a4ceb3f522203b8cddc937d76c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171902))
- [Add models and initial ability for admin related custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/1848798db4dca564e6d9126f758568a7b30c1fab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171581))
- [Quarantine test suite](https://gitlab.com/gitlab-org/gitlab/-/commit/f9976944bea4864bbfd7e7ad6e030f5818799cd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172828)) **GitLab Enterprise Edition**
- [Remove orphaned managers from ci_runner_machines_687967fa8a on .com](https://gitlab.com/gitlab-org/gitlab/-/commit/a0bf8950491c36ac104ce94e0a7128a97bb67794) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172422))
- [Remove FF owasp_top_10_null_filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/33cd3ec3be7e1b2562bb6e0c1260b5ec541ab37f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171813)) **GitLab Enterprise Edition**
- [Finalize migration BackfillSbomOccurrencesVulnerabilitiesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d9689cb7f1e40ddef7de1102c1e92800b4b40823) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172770))
- [Cleanup monolith prompt for glab_ask_git_command](https://gitlab.com/gitlab-org/gitlab/-/commit/9009d712dee4ca3aa117c6737f4077b9fb6a8fc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172760))
- [Add NOT NULL for sharding key on security_scans](https://gitlab.com/gitlab-org/gitlab/-/commit/88d7e314fb1094687ceda819d8792e0a3ca82b0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171845))
- [Quarantine flaky spec](https://gitlab.com/gitlab-org/gitlab/-/commit/6d14d4f3bf14a495d0135b7f07cf648d81180773) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172731)) **GitLab Enterprise Edition**
- [Finalize migration BackfillPkgsDebianProjectDistributionKeysProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/1b4877f58ed9f65cfb6fe3175bae8cae34a292c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172597))
- [Use SessionMap for tracking per-db primary/replica usage](https://gitlab.com/gitlab-org/gitlab/-/commit/34b6032473f0e3bd38122f57fbdf8b2c89b944ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168642))
- [Finalize migration BackfillPackagesDebianPublicationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/c14593770c50261e145bc6ebdf0126a9eb4e5c9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172599))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1b8a3a53544105426a03b14ef9e5483a6a5b2de8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172636))
- [Finalize migration BackfillReleaseLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a52ea07161ae3e37e9bb0c20a2128700994250) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172602))
- [Finalize migration BackfillRelatedEpicLinksGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/1e89c8e38467eb9028cded52e95543e048102c3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172601))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/05e99f9c9ee31b03d7911116743b9d5ee8c942cf) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170715))
- [Model registry: Fix position of actions ellipsis](https://gitlab.com/gitlab-org/gitlab/-/commit/10ea05e722aa134306c1342b11f7b49defe0395b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172552))
- [Remove current partition feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/aa2aa07b28d0e99049a04e0e6365acb539d0ee2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172397))
- [Elasticsearch migration: Backfill correct_work_item_type_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2ee1855452bada094670a2f4152fc1c9aa75d150) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171921)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/150a83e4f8a82285fb0d8cf4ef1d962b603242bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172472))
- [Finalize migration BackfillPackagesDebianGroupDistributionKeysGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/d067e27f5f2ef0db25cb45a3cac0015d4c1bca7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172455))
- [Finalize migration BackfillPackagesBuildInfosProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d4b5be28f91c5a21f48d4a86dbb534c74847e0b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172454))
- [Finalize migration BackfillOperationsStrategiesUserListsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/1d9d82e64a481307c305be7e71a93cdfe27fe1cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172168))
- [Protected containers: Remove field "Minimum access level for delete"](https://gitlab.com/gitlab-org/gitlab/-/commit/f0fe61070f353deee5fccd0f4f07b1ac8e4f5856) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172284))
- [Calls alter_cell_sequences_range rake from db:configure](https://gitlab.com/gitlab-org/gitlab/-/commit/8082c3ecd598bce1f9a6c8d8d4799b9899423852) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170613))
- [Finalize backfill_vulnerability_state_transitions_project_id bbm](https://gitlab.com/gitlab-org/gitlab/-/commit/686cef3e70e954ed3b3308d4a090e14386766c92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172376))
- [Add custom access denied page for ultimate trials in-app](https://gitlab.com/gitlab-org/gitlab/-/commit/ab2127cf39b78b9bf9ce8a30551469670e15a2df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171981)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/ab5a85091963f08f29e089d5f2d2753c29a8c5e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172260))
- [Add NOT NULL for sharding key on dependency_list_exports](https://gitlab.com/gitlab-org/gitlab/-/commit/b0d7c70c86c40ef973f0b9738619d7a60680e32d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172178))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0c8242752dbba611e8933dc2e578a62489dc7578) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172216))
- [Finalize migration BackfillMergeRequestAssigneesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a3395062e13a6b6a4d5efb47e6c8833f4f5d51d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171763))
- [Add issues.correct_work_item_type FK](https://gitlab.com/gitlab-org/gitlab/-/commit/71dd61f74b691e2beb486e9940564e84374c21c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172310))
- [Add tmp issues.correct_work_item_type_id indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/1c38b2f62832f208530faa65ca1f63d66d73a00c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170005))
- [Update postgres_sequences view](https://gitlab.com/gitlab-org/gitlab/-/commit/571df3ee8621bfea80db8a14e1dd810892471dcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170808))
- [Protected packages: Remove scope :matching_package_protection_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/a1bba7cdefae3911d2a23dfe71693672d8519e51) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172258))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a0c705ce3880591eae585df78f0a2fb3260c94fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171620))
- [Finalize migration BackfillMergeRequestContextCommitsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/09dfb8b7cd8ee5c9a27e885d72520d66887614d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172002))
- [Finalize migration BackfillMergeRequestBlocksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/78157b6fb8079b7eaecbf22badb1fa9fb6b1dd55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172001))
- [Finalize migration BackfillOperationsStrategiesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/004f12afbf6923ddf020759d9e3409fda648b9fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172167))
- [Add and backfill work_item_types.old_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/6343cb16b0ff192d05c56fc63f3ed043c1d0df84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172149))
- [Check if user can create package in npm create package service](https://gitlab.com/gitlab-org/gitlab/-/commit/6d1ef41d216da7961a5f3d006b32055c749967b2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171409))
- [Better extraction of variable and rubocop](https://gitlab.com/gitlab-org/gitlab/-/commit/7ee911a1aa86501ac8d94e59639ba3ce7bc214b4) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171425))
- [Change data consistency for workers maintained by integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/5708f0a50728a17937f11588760772b332bb456d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170351))
- [Finalize migration BackfillEpicUserMentionsGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/2c2285acec0b27aba50d83d3965261930ed559d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171614))
- [Use p_ci_build_tags for jobs queuing](https://gitlab.com/gitlab-org/gitlab/-/commit/c4130263d09840388e1a03346eed296a8022c11f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172048))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/f5295ec76f6f4b85d099aaa40faa4da8c644d217) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170700))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b04b0e1e33718709724d6f05dca18a36ff7ce379) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172012))
- [Finalize migration BackfillOperationsFeatureFlagsIssuesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/08ba5a6fdb22fc0039614125754a982f2f15b46c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172004))
- [Finalize migration BackfillIssueLinksNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/3366b74028cfb4e11e33ecff697da81efce7b044) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171615))
- [Use sidekiq_interruptions_exhausted in Direct Transfer jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/6f7bdef804fbfe0066fd767851761ed5cdfb5609) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169183))
- [Remove add_on_purchase_expires_on feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/09a3db4a2fb5d4ec4171a3765fc4e7ecff47c390) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171965)) **GitLab Enterprise Edition**
- [Revert caching authorized_projects](https://gitlab.com/gitlab-org/gitlab/-/commit/11f56525d2be98cd068958659ff4e0883277581b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171798))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5d2bd6cafd520eb3dd6abc4094a148c96f1b7658) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171494))
- [Requeue migration security findings](https://gitlab.com/gitlab-org/gitlab/-/commit/a8e66d87eac136d6cf236733bfd2908262f289b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171503))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/1c6004bd648d91bd16b3c5518def7250cde83795) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170712))
- [Backfill embeddings for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/38173d1fdbd2578d42383ce9b5b656081be7d829) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170784)) **GitLab Enterprise Edition**
- [Finalize BackfillProjectIdToDependencyListExports](https://gitlab.com/gitlab-org/gitlab/-/commit/e792d7a9ad1eec805d307d3a5446d4fb3d362613) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171854))
- [Elasticsearch: Migration to add work item type correct id](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5d65b521ec9bc29138963ddb415bc757781e03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171704)) **GitLab Enterprise Edition**
- [Use p_ci_pipelines by default](https://gitlab.com/gitlab-org/gitlab/-/commit/498c36e17910ec2070d5a6a1af1d1a0171a2b2e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171834))
- [Remove prompt migration feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/f3801f26c5df0064531ee04b06d36f3c83a6e260) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171532)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4bf09088fc4b21f7c19c3a2a8f8999d48f4f22f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171778))
- [Finalize migration BackfillDraftNotesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/39cb7750dbafe7c336a6bdfb2c35718f216457ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171613))
- [Finalize migration BackfillDesignManagementVersionsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/ebd38a95ea212a30f0a61ce38d931dafb1952205) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171611))
- [Finalize migration BackfillDesignManagementRepositoriesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/1fc96881d206ef32cdfc7ecb9d0bddb5f7c64cd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171442))
- [Finalize migration BackfillWorkspaceVariablesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/45d903fad1b4785623ec94e34470def38d568776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171046))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/89274a6ed3ce534d26142fc15c6ebb92330d0b48) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170710))
- [Use 24 hours lease time](https://gitlab.com/gitlab-org/gitlab/-/commit/1a96b6bd00729b68ccd5ed966dc8749ab78adb1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171695)) **GitLab Enterprise Edition**
- [Fix sidekiq warning for ElasticsearchIndexedWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/15e0ab155315b5532aea50412be5ef654c9c57f1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164096)) **GitLab Enterprise Edition**
- [Fix Layout/ExtraSpacing offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/0dc27019c0d22eee2694632a2c163abab9b08411) by @mr1chter ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170970))
- [Finalize BackfillProjectIdToSecurityScans](https://gitlab.com/gitlab-org/gitlab/-/commit/6c3933c3f85ad0c72a5884a0808b2ffd27636f88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171458))
- [Create new internal path for AddOnPurcahse](https://gitlab.com/gitlab-org/gitlab/-/commit/611d6a51f38d7ad622ec4543ea2f5bde7e6bbb7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170994)) **GitLab Enterprise Edition**
- [Groups::DeployTokens::RevokeService should return ServiceResponse](https://gitlab.com/gitlab-org/gitlab/-/commit/2aae45bc59bdcfee16fadb234f6b0a189b0fd7fa) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170640))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/00702a81ae2edf3a1aacec3b29aa77bcf8b3fd0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171489))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/16bc6e3d34a7d26e66d7c86c03197ccdde008670) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171490))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/683d080056437a49ae871ba25d22bbf927affa53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171491))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d10f2dbc482b78864b177e9638df69ea2f2d6b55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171449))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9fe14615e1ae4a2eb8e2a1ed163a1512a45d5165) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171492))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2b2a3a608199c54a76ac7e3d752839b4eebe2cd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171619))
- [Finalize migration BackfillDoraDailyMetricsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f23e6bdd445099cb6c24e1cd0b6bb57f83938d48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171612))
- [Finalize migration BackfillDesignManagementDesignsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/a665e564bbd1bc2dfbbe8f259bafec0fc06dacf6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171346))
- [Add desired sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/2c9ba799d332c6830cdadfbd3882ad8561121182) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171604))
- [Create a new zpekt scheduling task repo_to_index_check](https://gitlab.com/gitlab-org/gitlab/-/commit/4b5b508461e13fad908a8ede43c345f513e24448) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170288)) **GitLab Enterprise Edition**
- [Add desired sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc684077a9995342baa7282f4a3b9d31ecdcd93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171601))
- [Add policy toggle unblock_rules_using_scan_execution_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/167da2e7651788f92df96264665fbb8b36902559) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170605)) **GitLab Enterprise Edition**
- [Cleanup CreateIterableTriggersWorker class and instances](https://gitlab.com/gitlab-org/gitlab/-/commit/32ea9c674ea8fd894ff5cf8e306552d840989bba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171541)) **GitLab Enterprise Edition**
- [Cleanup duo enterprise rollout feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/fb69200aacc4d177a54e8c39359c7c16979a4bf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170864)) **GitLab Enterprise Edition**
- [Use lock_key for BulkRefreshUserAssignmentsWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/9cfcab2275e82912de8a7b49b1684fa82c095483) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170929)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/89dec2564e291d3923c6d7baeccf5fc24803387e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171526))
- [Add pipl_users table](https://gitlab.com/gitlab-org/gitlab/-/commit/cb85e2926b2f2111d143b164a0e0e0d44ed3750e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169769)) **GitLab Enterprise Edition**
- [Protected packages: Add tests for pypi push protection with deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/a6ffc0f9cc1ce711aa7cc20bf626160680a32e25) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171516))
- [Mark 20240410193847 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/9064247184ca4e5a4688ed31db4f82817dd6db6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169314)) **GitLab Enterprise Edition**
- [Introduce histogram for ApplicationRateLimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/2b540efd81f45bf8355a113ac8420de7b2b0759f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169655))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e9ec3295766a3b3f9317998c560335b4ed5a2f8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171493))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/71dd85c5bc6ee79331de3e3ed7ee5fe5fbf34421) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171355))
- [Finalize migration BackfillDefaultBranchProtectionSettings](https://gitlab.com/gitlab-org/gitlab/-/commit/6d8fc9863e98b0ab2f8f26d990062fda4b310583) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171200))
- [Finalize migration BackfillDastSiteProfileSecretVariablesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/32b9635a277d73cd7352f4dc9ad2d4f39eb2b968) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170669))
- [Finalize migration BackfillDastProfilesTagsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/7d036de56f848b7d549ea26699c3a9bc6654e3d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170667))
- [Finalize migration BackfillWorkItemParentLinksNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/ea2dceb7e49708dd2964ddf85c4d2c4c860366b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170879))
- [Finalize migration BackfillJiraTrackerDataProjectKeys](https://gitlab.com/gitlab-org/gitlab/-/commit/9cc605b0b2cdea2f07dfeb89051303b30a7f0734) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170877))
- [Fix Lint/UselessNumericOperation offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/c94fc73a2226ac8eca3ebb6066b28b3a9ae60d7e) by @ksp_1306 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171460))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/e9512e4ad3c3c63b244880a08b6d98df78dfd027) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170711))
- [Create new WorkflowsInternal API for ai_workflows scope](https://gitlab.com/gitlab-org/gitlab/-/commit/5e649ce892ec159ded1b619f31b0fb974d4b051e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171229))
- [Fix Style/IfUnlessModifier offences](https://gitlab.com/gitlab-org/gitlab/-/commit/56258237ddf1826cd7145ffe42d9e8cc21b56aed) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170457))
- [Change data consistency for workers maintained by permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/971558937d6b247d597740cc5680c8b53825966e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170347))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/21f7c2f08821e092d408e0550ab7ddf1d591b4e6) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170704))
- [Add service ping to support tracking runner maintenance notes](https://gitlab.com/gitlab-org/gitlab/-/commit/0bdb6d0d960c8128475ad8742192fc2d6547e2f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170483))
- [Add work item weight sources table](https://gitlab.com/gitlab-org/gitlab/-/commit/4193ae7a2460614f747212473b91f619eddc0e72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170371))
- [Finalize migration BackfillWikiRepositoryStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/71acdb27fbf881ab9b439a1212815be9862db8ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170878))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/6318b592750a246e8d2c3f6a09f12def797e8d09) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170701))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/2d0999f0cddf9eb0e479ac9040779b978d0246b9) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170707))
- [Remove the trial boolean qualification for ultimate trials](https://gitlab.com/gitlab-org/gitlab/-/commit/f1dd21f41295fbd062d97eb6afb7b86bd6197416) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171306)) **GitLab Enterprise Edition**
- [Fix Style/IfUnlessModifier offences](https://gitlab.com/gitlab-org/gitlab/-/commit/4fc6a0cb0b13d413d87b8e72bf17394dfe55a081) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170331))
- [Remove expired cut off date feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2ad2719a5b92c78a84b15b70b4f6918a02401e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170101))
- [Make to-do item spelling in UI consistent](https://gitlab.com/gitlab-org/gitlab/-/commit/9ef27900791d9d06be33bebb6cedcacd15944d07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171007)) **GitLab Enterprise Edition**
- [Update Dependency List docs](https://gitlab.com/gitlab-org/gitlab/-/commit/94527a8624530cc5a51ce8df64cd00a5d19be93c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171115)) **GitLab Enterprise Edition**
- [Remove trial column observance from the eligible trial query](https://gitlab.com/gitlab-org/gitlab/-/commit/e43ea49be52e3bebaa1b135867e91aca1238a6ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171211)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8103e45a701b03e829bbb23b643e08b9e3f3fe17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171220))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4b0d928ae5fcfaf91b081b5d8dd04854e1da66bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171219))
- [Finalize migration PopulateTopicsSlugColumn](https://gitlab.com/gitlab-org/gitlab/-/commit/390edddfe543dd9c7e0c20909fd3b582bb64986e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170875))
- [Add sharding_key_issue_url for manually backfilled](https://gitlab.com/gitlab-org/gitlab/-/commit/7740e0c893c4664232f11ea1acbc1a7c5f5cc0db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171076))
- [Log relation name when exporting projects](https://gitlab.com/gitlab-org/gitlab/-/commit/fd2218d3b5fec0a462db016997f0ddbaf9776bc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171157))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/cca7ab85039a13f33f785ea76a64317b83ad4c70) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170292))
- [Add and backfill namespace_id for analytics_cycle_analytics_value_stream](https://gitlab.com/gitlab-org/gitlab/-/commit/43c52121be28d2ddb65e6ca159661b043a4e9e24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169585))
- [Remove custom_models_vue_app feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/182b6dd64bc0fbb513b0695a3b4bdd5f1dd441c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170891)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/fa96d7437e5237ffeb76af9c918f1b6b47c89ed0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171056))
- [Finalize migration UpdateSbomOccurrencesComponentNameBasedOnPep503](https://gitlab.com/gitlab-org/gitlab/-/commit/ad08d7a6fae3fe2b0b3217a17d425155d3abf6e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170876))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/20460968896de297eb4e02fcd5f9b486f37b3aec) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170709))
- [Fix Style/CombinableLoops offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/af9b15536eda42064501d1f9a2d468b4b8988c31) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169977))
- [Remove custom_models_feature_settings_vue_app feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d64dc841241ef4ae7e49ddfe5eb0ee74586cb0ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170201)) **GitLab Enterprise Edition**
- [Add ci_deleted_objects#project_id not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/1aa273c0c7df5125bc12169375b456483852105d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170215))
- [Mark 20240213091440 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/40f17a4bb78840c5a66ccbc538048bc970cd2c87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169311)) **GitLab Enterprise Edition**
- [chore: Adds additonal properties in duo workflow event definitions](https://gitlab.com/gitlab-org/gitlab/-/commit/5c4e5fabac1cd0139dd19f30e8681c2813a4c890) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170950)) **GitLab Enterprise Edition**
- [Move base integration code to a separate module](https://gitlab.com/gitlab-org/gitlab/-/commit/1ec1990c151800a5c95e4de4e731fdd2464a8691) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170439))
- [Track worker concurrency using Redis hash](https://gitlab.com/gitlab-org/gitlab/-/commit/b6f049e690b040bf34e0a03345d38b11306f7382) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167027))
- [Update instance_integrations table to match integrations schema](https://gitlab.com/gitlab-org/gitlab/-/commit/4917d4151a855cc87b1fb40fb487d8f33e7aca60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170247))
- [GitLab pages: Fix rubocop issues in certain files](https://gitlab.com/gitlab-org/gitlab/-/commit/5fab53761c269d34fb8d59b27562ff0b7bfdb53c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162847))
- [Add `namespace_details.deleted_at` column](https://gitlab.com/gitlab-org/gitlab/-/commit/f75a1bb76a3e5f90956529396d2762abd6bde44f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170898))
- [Exclude qa sbom fixtures from dependency scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/2a887a1cb1d3b64cfdf2c9fc75ba5e8e1181a95f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169761))
- [Add RequeueBackfillApprovalProjectRulesProtectedBranchesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/fc6fb00a6f4919490bb73c39b05c1bf1a7265507) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170799))
- [Change data consistency for workers maintained by not_owned](https://gitlab.com/gitlab-org/gitlab/-/commit/cd5f35fff1f2ff86b2df21cd8a4ddaf2753580af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170350))
- [Remove sync_traversal_ids_nowait feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/333dd2c97b3a6702fac20bdd033ed04e7410b546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170752))
- [Finalize migration DeleteOrphansApprovalProjectRules2](https://gitlab.com/gitlab-org/gitlab/-/commit/ba905bc24ee889c93d7e0de63ab55faa0099ccb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159492))
- [Fix Gitlab/StrongMemoizeAttr offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/361b701f4f5e413331bcfac2074031d81525c05c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170399))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/63a9549049890af0412ebc11108417d5fe818b76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170674))
- [Finalize migration BackfillDastScannerProfilesBuildsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/fb67b4be4a3e6aa996c05615ceeef87b452a2cea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170668))
- [Finalize migration BackfillDastProfilesPipelinesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e1e9dfbd78b0aaa553d112338cfb63bab75bfb46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170666))
- [Finalize migration BackfillAlertManagementAlertMetricImagesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/c2763bae4db5ca06a4dd86f445aa0481ef76bde4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169518))
- [Support data consistency overrides for specific db in ApplicationWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/855dbf096b761702c1d08118347e770e1e8a6f62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166729))
- [Fix Style/IfUnlessModifier offences](https://gitlab.com/gitlab-org/gitlab/-/commit/b0fcf8b93aff19779b04480d39f01a2b10818f72) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170675))
- [Topology Service CellService client](https://gitlab.com/gitlab-org/gitlab/-/commit/3f0d395275394f783f90980afb72a03d30fb70ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169787))
- [Log when placeholder users are created](https://gitlab.com/gitlab-org/gitlab/-/commit/f4e352dfae21fc8e36112b965542def47bf0767a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170599))
- [Finalize BackfillPCiRunnerMachineBuildsProjectId migration](https://gitlab.com/gitlab-org/gitlab/-/commit/cea4e6efbf00c0698b0ed5667c43cebfcaa34ab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170308))
- [Update seed factory exclusion](https://gitlab.com/gitlab-org/gitlab/-/commit/2187c36808be88bf629f6ec774bac05f0b76c755) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170546))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/00a120b6676768dcc56be20b01bae50634a21818) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170529))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/100ee160c7f10a4ebecf803c8d0b9b82cb84e527) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170528))
- [Add created_by and updated_by to custom fields](https://gitlab.com/gitlab-org/gitlab/-/commit/843640c410c8c7a7ea0b28dc8d9f730ac09f4c33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169770))
- [Use exclusive lease for resuming job processing](https://gitlab.com/gitlab-org/gitlab/-/commit/d7f9af35acacc04ef59942913e576fd11ce521e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170537))
- [Finalize migration BackfillDastPreScanVerificationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f00d8124babd3440e09377320a62cac255f5030b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169203))
- [Finalize migration BackfillAuditEventsStreamingEventTypeFiltersGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/1fd3c0986fe4c3635b04f0dfe1fc08081d91b3bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167508))
- [Finalize migration BackfillAlertManagementAlertUserMentionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/31eabf00bd47e972231c70cc5826771c8d86b8a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169519))
- [Finalize migration BackfillAlertManagementAlertAssigneesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/8034565ab755a8b154c0bf1ed62f4c60c47a80db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169517))
- [Finalize BackfillRunnerTypeAndShardingKeyIdOnCiRunnerManagers](https://gitlab.com/gitlab-org/gitlab/-/commit/28bd7776938e80c942f393454f2c10e5440f5558) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169964))
- [Enqueue migration to fix canceling attributes for CI jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/65f9ca582846e5bfbf97e54452eb4574cd1a33ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170253))
- [Mark 20240130154724 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/1ad966a5bf6f606d03a9d3fee4f9dc3c0f5e445f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169304)) **GitLab Enterprise Edition**
- [Check if user can create package in pypi create package service](https://gitlab.com/gitlab-org/gitlab/-/commit/2a24b8e3063e2d9b2c5d6720ae1e61a4afb76b3c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168071))
- [Update to add sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/d2922e4e667768eb57670f74e41b2f37f3623811) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170467))
- [Protected packages: Return ServiceResponse for CreateConanPackageService](https://gitlab.com/gitlab-org/gitlab/-/commit/d0e9e48b6f6a8cdc7f1836cb3d75fb9e689c734c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168214))
- [Change data consistency for workers maintained by importers](https://gitlab.com/gitlab-org/gitlab/-/commit/41d408a910c5163e3a0e9bcf20e62b50a443b89d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170349))
- [Fix docs link in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/270291f91efe0521621a80582becbdf0e8f382be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169461)) **GitLab Enterprise Edition**
- [Add missing test for method #consume_event in Subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/db1306cef4f09a5564f8001fe9a720a195ad4ea3) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164373))
- [Drop search_namespace_index_assignments and search_indices tables](https://gitlab.com/gitlab-org/gitlab/-/commit/bf8ce6cb0f416d6cfe3df7dbb38d6629dfa03876) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170242))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/efd2ff98e0492edd1922d54e29cff6c685229f35) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170165))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/43b94daf6fdf6d9ae6e0f85f12019df6b932ec97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170367))
- [Temporarily unapprove MR for code owner rules to sync](https://gitlab.com/gitlab-org/gitlab/-/commit/571309cd5717d19399a869f54fdcb36ef0807472) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/167592)) **GitLab Enterprise Edition**
- [Use SessionMap for tracking per-db primary/replica usage](https://gitlab.com/gitlab-org/gitlab/-/commit/7ad5ee203d8e8102ba2049080e95ce302035ecb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168642))
- [Use project_id as sharding key for packages_dependencies table](https://gitlab.com/gitlab-org/gitlab/-/commit/3744108d2ec4677f5a1159e12d2c5682f46477ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169394))
- [Finalize migration BackfillBoardsEpicBoardLabelsGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/05b351e1341154ede3e88bf0ee067a557a3b0788) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167978))
- [Change data consistency for workers maintained by auto_devops](https://gitlab.com/gitlab-org/gitlab/-/commit/32af56d2b154b4064b89ae3c25621e661d1b6865) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170348))
- [Improve test performance of conan request tests](https://gitlab.com/gitlab-org/gitlab/-/commit/a55435b71db1c311455b855ea552ca16f688fec3) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168984))
- [Change ultimate trial select namespace form language for duo](https://gitlab.com/gitlab-org/gitlab/-/commit/180ac4c9bfb96d6e512eed634da21038a2903e8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169983)) **GitLab Enterprise Edition**
- [Remove the FF zoekt_initial_indexing_task](https://gitlab.com/gitlab-org/gitlab/-/commit/ee973e1ed4eb7bc3293ed5ceef29e637cd402071) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170274)) **GitLab Enterprise Edition**
- [Refactor Token Identification](https://gitlab.com/gitlab-org/gitlab/-/commit/3b32ce03e0d40f394124ffd6e78e7ad38a640d8b) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169821))
- [Add opensource limit to pages deployments limit](https://gitlab.com/gitlab-org/gitlab/-/commit/1c94996069f3c7b1ed6ce1779cf60f954c4e7152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169910))
- [Mark 20240130215043 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/3497bb85586854b29d1e96528ad06947e3783d37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169306)) **GitLab Enterprise Edition**
- [Finalize the backfill user details migration](https://gitlab.com/gitlab-org/gitlab/-/commit/3f0b7395adb7aae1cebc235910e0e7261a78db66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162735))
- [Finalize BackfillShardingKeyIdOnCiRunners background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/089e327ba1b66ba8b976bb1cf572a329bffb8f27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169958))
- [Add NOT NULL for sharding key on agent_activity_events](https://gitlab.com/gitlab-org/gitlab/-/commit/7312f7d8dec8449c01242cd71b60b232e51a94f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170139))
- [Improve sharding key spec](https://gitlab.com/gitlab-org/gitlab/-/commit/56ca95ed1720fdf32ac9119377cd3012dcb9c461) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170197))
- [Add NOT NULL for sharding key on subscription_user_add_on_assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/d9ddb4a1a5b464aad4a85e566e0579df24b2abb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170136))
- [Cleanup group_protected_branches feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a7b1c6cf1133b74ad2c6d797109419d3a32a1ea0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170128))
- [Add and backfill project_id for security_findings](https://gitlab.com/gitlab-org/gitlab/-/commit/362c9b3afce3f405d0c62ef57d1c67280b298366) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169121))
- [Remove search_indices table related code](https://gitlab.com/gitlab-org/gitlab/-/commit/1a7ee8d73e927907f135b7e5e3382c8e56d7bd44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169909)) **GitLab Enterprise Edition**
- [Fixed rubocop space_inside_parens](https://gitlab.com/gitlab-org/gitlab/-/commit/b77fd9f05ef627cfa15261ae4ce86ce84cde560a) by @b310-jannik ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170123))
- [Fix sidekiq warning for MergeRequests::RemoveUserApprovalRulesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/967940dd873f095c8036856fe4c2e07ec6f2da46) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169957))
- [Bump issues bigint conversion cols removable data](https://gitlab.com/gitlab-org/gitlab/-/commit/80690b527c35f51f61b498b15111c23cdc344403) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170083))
- [Remove unnecessary ExclusiveLeaseHelpers from spec](https://gitlab.com/gitlab-org/gitlab/-/commit/afec8f505e27de430b61433f4caf0374042dadd7) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170082))
- [Use AssignResourceFromResourceGroupWorker instead of V2](https://gitlab.com/gitlab-org/gitlab/-/commit/cbc4af047bc42309a41de4782496763afeec627a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168483))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8f28b7cc2808e3c0619a5572a7f76d5b5f165ef1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169817))
- [Add foreign key constraints to `organization_users`](https://gitlab.com/gitlab-org/gitlab/-/commit/fde94be689e01d6e649fa6b791288b431af5026f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169382))
- [Prepare async index creation for issues.correct_work_item_type_id](https://gitlab.com/gitlab-org/gitlab/-/commit/4516cf901060f3701cdd16f2252337ceb42e8bd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170009))
- [Introduce a checking state for approvals mergeability check](https://gitlab.com/gitlab-org/gitlab/-/commit/9076157ea1442b427d418614aa8485a217424d02) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/169689)) **GitLab Enterprise Edition**
- [Remove the search_issues_uses_work_items_index ff](https://gitlab.com/gitlab-org/gitlab/-/commit/9d7c8b3f154096740d92905dc5162b893c521948) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169418)) **GitLab Enterprise Edition**
- [Mark 20240123181031 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/1ad8278054048a29f683a75f117fe8480d9daab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169300)) **GitLab Enterprise Edition**
- [Projects::Settings::RepositoryController#show: re-enable query limit](https://gitlab.com/gitlab-org/gitlab/-/commit/2fe6f40c2072e5a170d6a0785c18b1513f227aa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169948))
- [Mark 20240130144625 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/c80743a616f004b50566655ebb64522b709b7b38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169302)) **GitLab Enterprise Edition**
- [Set retention period of 1 month for web_hook_logs](https://gitlab.com/gitlab-org/gitlab/-/commit/baad9506130fa1ab988fdd4238dc72ebec60352d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168654))
- [Validate ci_job_variables#project_id constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/0a5d16650da31576533fa344e164ea3d54e635ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169232))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/d9a0032d22d5da3b0d9e1cf9f348fb5dedd4efee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169130))
- [Cleanup allow_protected_branches_for_group feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5628433ccf331016e6c8a198ca836f2b32c92268) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169482))
- [GitLab Pages: Move error handling to model Gitlab::LetsEncrypt::Order](https://gitlab.com/gitlab-org/gitlab/-/commit/38436391e85a39de74617e52e82af9b402e1a4a1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162835))
- [Remove ignore rule for identifier_external_ids column](https://gitlab.com/gitlab-org/gitlab/-/commit/70c48db303703e782f84a555cc4c40b51225f9c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169877)) **GitLab Enterprise Edition**
- [Finalize BackfillSubscriptionUserAddOnAssignmentsOrganizationId](https://gitlab.com/gitlab-org/gitlab/-/commit/b6ad59fe97874c8ce7c5081d6466597cce2d441b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169834))
- [Add NOT NULL for sharding key on approval_group_rules_users](https://gitlab.com/gitlab-org/gitlab/-/commit/20a1f59fe71f26d700fbc751dca39edf7162dd98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169836))
- [Emit concurrency limit stats in background sampler](https://gitlab.com/gitlab-org/gitlab/-/commit/4e3b54a4e0fd5a233f6da7bc3b25477570dbd09d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168926))
- [Change data consistency for workers maintained by source_code_manageme](https://gitlab.com/gitlab-org/gitlab/-/commit/36c74f4effdfeb151ed524f47fb6a7c9b4fef315) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169450))
- [Mark 20240219161432 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/0bbf4341916f3674194fe9767d44813f7a9c66b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169312)) **GitLab Enterprise Edition**
- [Replace ci_build_trace_metadata with dynamic partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/27f6b7e59c872fc7c9ac6b03cd83cc85fc3d31a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169702))
- [Delete orphaned pipeline variables](https://gitlab.com/gitlab-org/gitlab/-/commit/277cf3836684ba446e8252abcbaa2c28b0202ec2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169441))
- [Update work_item_types FKs to UPDATE CASCADE](https://gitlab.com/gitlab-org/gitlab/-/commit/b87d0147df16be3434460ca76df0529b8a38aeb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169351))
- [Change data consistency for workers maintained by user_profile](https://gitlab.com/gitlab-org/gitlab/-/commit/4d669123669235e8b8ecff0e7bceee313fbe385a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169452))
- [Mark 20240119130539 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/3512ce8416cb8a03fe85d1772d75b3c4550f1a74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169299)) **GitLab Enterprise Edition**
- [Ignore last_activity_on column](https://gitlab.com/gitlab-org/gitlab/-/commit/5481b722e65b1094dab7f5a462b3511b8d28e48f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168982))
- [Finalize migration BackfillBoardsEpicUserPreferencesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/cc824bdac9189c0c0af83499f2c39f63e02f3523) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168459))
- [Replace ci_pipelines_config with dynamic partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/175fac5d7a10913e1b227104786cc1a125e1b7ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169251))
- [Remove ignore state_changed_at_pipeline_id rule](https://gitlab.com/gitlab-org/gitlab/-/commit/2faf39f378f38bbfc317e7381dd0a6bd7781411f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169550)) **GitLab Enterprise Edition**
- [Remove FF ci_variables_optimization_for_yaml_and_node](https://gitlab.com/gitlab-org/gitlab/-/commit/e57de1b1814ee1f5dda5ed4804b89d3a7903f3bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169548))
- [Finalize BackfillDeployTokensShardingKey background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c4548003776bb4e73e48b97f7efeedad6f47d665) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166556))
- [Finalize DeleteOrphanedDeployTokens background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f52aa59dec9b7dde8874ade997e7da0d9031ed2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166557))
- [Allow the day 0 option of the trial widget to still show as active](https://gitlab.com/gitlab-org/gitlab/-/commit/ed48bcd921d525d75eb2ff2636280d1138bfb0b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169502)) **GitLab Enterprise Edition**
- [Use project_id as sharding key for packages_npm_metadata_caches table](https://gitlab.com/gitlab-org/gitlab/-/commit/70d6db4ddc987dd9c3ff3eb62b36b0bf7df84a60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169400))
- [Drop `vulnerability_count` column from `project_statistics` table](https://gitlab.com/gitlab-org/gitlab/-/commit/13f6c8abd674e06042120f929255fcc7c53cdd1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169479))
- [Updating Topology Service Client Gem to d88ee3c](https://gitlab.com/gitlab-org/gitlab/-/commit/ee8f40d860576b0d613ca1dd164cf53074be5970) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169326))
- [Suppresses Composite PK warning for Security::Finding](https://gitlab.com/gitlab-org/gitlab/-/commit/c0c3225837465d0bd62498435f3391d9f976ab47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169489)) **GitLab Enterprise Edition**
- [Reduce frequent nodes update](https://gitlab.com/gitlab-org/gitlab/-/commit/e9a71047a6d1ae96cd2651cfe0c6eaf00b2e44a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169148)) **GitLab Enterprise Edition**
- [Add and backfill group_id for dependency_proxy_manifest_states](https://gitlab.com/gitlab-org/gitlab/-/commit/d853077434814bc72990b4901a360415bd5b57e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169239))
- [Remove the search_issues_uses_work_items_index ff](https://gitlab.com/gitlab-org/gitlab/-/commit/c9cf150a71c794d9674795bf67ed89ced30cdbd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169378)) **GitLab Enterprise Edition**
- [Mark 20240201164432 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/1bde603cf2077e1446240b79063595c83dd6b488) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169308)) **GitLab Enterprise Edition**
- [Change data consistency for workers maintained by devops_reports](https://gitlab.com/gitlab-org/gitlab/-/commit/07fd1c1739f087292f218e696e9237dd418618ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169451))
- [Mark 20240208160152 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/0a3226a6b4d369261cc029d10f3683613f3ed36b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169309)) **GitLab Enterprise Edition**
- [Add and backfill group_id for dependency_proxy_blob_states](https://gitlab.com/gitlab-org/gitlab/-/commit/cab0fea2e4756ae1a7e1bb67437346d9f1300574) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169237))
- [Add and backfill project_id for container_repository_states](https://gitlab.com/gitlab-org/gitlab/-/commit/71e3435683457d4813b36e4aa19ad9109a15fb15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169240))
- [Remove cross join suppression from vuln create service](https://gitlab.com/gitlab-org/gitlab/-/commit/69eb5c666d275514443db75db8ec8674c265ff04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169431)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/725deb0e8cc4d8eecc2b55630d072859a8308083) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166799))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/510b3c00d3d18067440b04693fc926ec31dbbfd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166800))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/3cf25d1fb84a404ff9ce03019343e5e4710ffb0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168904))
- [Finalize migration BackfillComplianceFrameworkSecurityPoliciesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/44cf646b76b3b83ff3d711b022c65efe7d961117) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169202))
- [Drop index_for_owasp_top_10_group_level_reports idx](https://gitlab.com/gitlab-org/gitlab/-/commit/f76faed0e14aeb86a0591db0302dd9ff40255f98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165514))
- [Use Job::Setter to indicate resumed job for concurrency limiting](https://gitlab.com/gitlab-org/gitlab/-/commit/2d7b5ab43f92c1720da6263c19bceb759b6da702) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169220))
- [Index namespace historical vulnerability statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/8cc47fbaad449fe8eb12325d65464e70cd667c89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169170))
- [Remove unused Users::RecordLastActivityWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/56ca06fc1b3e582da4b4d2286e24d50101bd0920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169131))
- [Remove block_password_auth_for_saml_users FF and the accompanying code](https://gitlab.com/gitlab-org/gitlab/-/commit/02ecabc6dd80b6a700aeec569014642dcb30704f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160850)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7427f68ca476bd1294900155a2a93b470ef888a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165742))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/81ccade46593d99c938fd8ab03c2e299f6f62377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164711))

## 17.5.2 (2024-11-12)

### Fixed (4 changes)

- [Fix group wiki activity events breaking the user feed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2c10d817d961bf6ae229fb436126713d0199aece)
- [Add param filtering to avoid error while saving project settings](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7e1bf6aa4087c0789ecff48ca716b30d841a3140) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171554)) **GitLab Enterprise Edition**
- [Fix new project group templates pagination](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3fed777c0e1f52816206b546f2063043febedd0b) **GitLab Enterprise Edition**
- [Update pdf worker file path in pdf viewer](https://gitlab.com/gitlab-org/security/gitlab/-/commit/406b66e9140b4ee4e79edc84e2870e0fbb90d149)

### Security (7 changes)

- [Add missing project_id for build_chat_data](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5a4e1bd3443cc786ab7558b1d6fa77962318c173) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4602))
- [Use custom adapter for parsing FogBugz XML](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f8c4b8942e6fca667c6a2b975d9fa792b0d559fa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4592))
- [Removed id from authorize buttons and added specs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7e9ac80271a0c8a7ed73f1cb4a34f053652f07f6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4573))
- [HTML injection in vulnerability Code flow leads to XSS on self hosted instances](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fbff5c445ecc99f438ab56a0c5add0ff5cd1e2aa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4564))
- [Remove is-unsafe-link from product analytics tables to prevent XSS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/605d8bf88e03ec6f447141049952b623eab2200c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4579))
- [Details of blocking merge request can be exposed via list](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0fe3d3020954f79337b6138e7b1ee6baed346c3c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4545))
- [Prevent agent access via unconfirmed or disallowed group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fa41ba0bc926e7b0091e4fb1cb6298b0b86eace5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4559))

### Performance (1 change)

- [Remove permissions JSONB column from the condition](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a5b902c35e60e36f3e98db2af221976093fe2278)

## 17.5.1 (2024-10-22)

### Security (2 changes)

- [Fixed HTML injection in Global Search bug](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a7e8948dba537f4e625c155ab6554919c17377d6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4542))
- [Limit max size of manifest file upload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9bedc6764bd1de6fa694f15898cded41733982f4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4541))

## 17.5.0 (2024-10-16)

### Added (145 changes)

- [Add X-Forwarded-To to allowed headers for email ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/e50f934dc3bcb7e1a9d85680d9c54a8ce8faebb1) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168716))
- [Search API: Merge request support for title search_as_you_type](https://gitlab.com/gitlab-org/gitlab/-/commit/9e0d5caa5d6e07e2868a82a31b24862e06b46ee7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167432)) **GitLab Enterprise Edition**
- [Added the group select to the global timelogs report](https://gitlab.com/gitlab-org/gitlab/-/commit/9b4ed0b57d5cab002520a4fd8c9190ee5ccca459) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167238))
- [Add global work item epics feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/41c10350edd29e5046670756c9844fb0969fa6e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168943)) **GitLab Enterprise Edition**
- [Add support for updating abuse report notes](https://gitlab.com/gitlab-org/gitlab/-/commit/25369ba6fa9a66000d8e12d9afd73e29470814f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167011))
- [Audit merged MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/de051e539c6f4cf1c26b9035fd2ccf17aec9b370) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164846)) **GitLab Enterprise Edition**
- [Add user level AI metrics API](https://gitlab.com/gitlab-org/gitlab/-/commit/838ccd4fb0c806464bced8feea26766888b98147) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166745)) **GitLab Enterprise Edition**
- [Reschedule BackfillPCiRunnerMachineBuildsProjectId migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f447557e7b893457927711f9d856dc3bdb35c61d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168420))
- [Backfill runner_type, sharding_key_id columns on ci_runner_machines](https://gitlab.com/gitlab-org/gitlab/-/commit/a71538127ac2aafe0c8e9f3ffb92648811a28dd9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168651))
- [Add sharding key ci_pipeline_chat_data.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/d28b07c40ab58a4e2663847af820c0e21032770d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167729))
- [Add customize jira issue setting](https://gitlab.com/gitlab-org/gitlab/-/commit/ea22e7d7e6f3d01e32b3bb7029e46d3a3892d76c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164802)) **GitLab Enterprise Edition**
- [Create todos for expired SSH keys](https://gitlab.com/gitlab-org/gitlab/-/commit/dd9383c7162eec67bf62bcc5a9b7fbfff6768f93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166168))
- [Implement project compliance center](https://gitlab.com/gitlab-org/gitlab/-/commit/daa6a9a5119f0d49e6b14458fcf4125dc6bed5f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168318)) **GitLab Enterprise Edition**
- [Add search button back to the header gated by feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e284b809076fbe43661ae47f9bf69461e41503a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165526))
- [History rewrite: send emails after asynchronous processing](https://gitlab.com/gitlab-org/gitlab/-/commit/d0d6a197f7b255df2d2ff6390f5254dde48d47f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167473))
- [Add Project.projectComplianceStandardsAdherence field](https://gitlab.com/gitlab-org/gitlab/-/commit/89007ca5a4a74eedfe72616c41e86b8c671b333c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168299)) **GitLab Enterprise Edition**
- [Add Project.projectComplianceStandardsAdherence field](https://gitlab.com/gitlab-org/gitlab/-/commit/9085b0ab5c92206855208e05007078697f84e6e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168260)) **GitLab Enterprise Edition**
- [Allow disabling password auth for SSO users](https://gitlab.com/gitlab-org/gitlab/-/commit/688786b4c616ed7f93c8eb4165439427c8200df3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168111))
- [Add download button to a health-check page](https://gitlab.com/gitlab-org/gitlab/-/commit/ec0b84cfb03cbadfe22084071a5c212394b1d351) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165032)) **GitLab Enterprise Edition**
- [Release project-level security exclusions feature](https://gitlab.com/gitlab-org/gitlab/-/commit/c1a49219c245e528a81f71ae1b3f9af1c4d36379) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168271)) **GitLab Enterprise Edition**
- [Directly ingest emails by custom email in To header](https://gitlab.com/gitlab-org/gitlab/-/commit/29da1cc92ddebfb4bf90694a52d376213a274a8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167770))
- [Add migrate_memberships to BulkImportEntities](https://gitlab.com/gitlab-org/gitlab/-/commit/21653f70ac61f2abf70a5f3fb2023aa961ceaa3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168128))
- [Ignore column vulnerablity_count in project_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/c4c510e6bc99e3c6f074986a01c929304168b4e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168284))
- [Add custom license to license widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f6762215a74d672c8ed4e5a3e12c1a4ca5e55457) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162488)) **GitLab Enterprise Edition**
- [Update Saml NameID related authentication errors](https://gitlab.com/gitlab-org/gitlab/-/commit/720dad3842fd826c925c379a2600b989e1bc035f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168353)) **GitLab Enterprise Edition**
- [Add /help slash command](https://gitlab.com/gitlab-org/gitlab/-/commit/647bf92af43d1d0507018fffbc7cfcc486770f17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167876)) **GitLab Enterprise Edition**
- [Integrate SD Exclusions with Scan Diffs feature](https://gitlab.com/gitlab-org/gitlab/-/commit/1eaff0b8c33107d5f95f455c6557f548b8b8bbdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168364)) **GitLab Enterprise Edition**
- [Create audit event for container_repository_created](https://gitlab.com/gitlab-org/gitlab/-/commit/f146d9f2eab1f1d2c67f618d4fb21888ad390948) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156037)) **GitLab Enterprise Edition**
- [Document new API endpoint `POST /deploy_keys`](https://gitlab.com/gitlab-org/gitlab/-/commit/a0bacc4da1ce546ba5b68c1908633ee88e90d2c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167873))
- [Pull mirror API: extend response with mirror related fields](https://gitlab.com/gitlab-org/gitlab/-/commit/a2929c517696b305f94742b0d1e5b60c3ba04944) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168377))
- [Add update event handler for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5f343163d5f088335663e3f82de6a64cfd5f857e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165572)) **GitLab Enterprise Edition**
- [Persist additional context in chat history](https://gitlab.com/gitlab-org/gitlab/-/commit/215d12834c623de975e0f277fea9a95c15cf4928) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168127)) **GitLab Enterprise Edition**
- [Model registry: Metrics for pull and push package](https://gitlab.com/gitlab-org/gitlab/-/commit/4064bf4d8fb245ec782adda654d08e3a2ca2531c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167298))
- [Add runner_type, sharding_key_id columns to ci_runner_machines](https://gitlab.com/gitlab-org/gitlab/-/commit/51f67409e49062f7340930b35edb835a7079fae4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168069))
- [Allow setting of weight on work item create](https://gitlab.com/gitlab-org/gitlab/-/commit/9c799b3ed901179eceb0cce2242e4ad66d2b4074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168475)) **GitLab Enterprise Edition**
- [Restoration of object storage through gitlab-backup-cli](https://gitlab.com/gitlab-org/gitlab/-/commit/b6b9c6b9387e9250bff23f79ad7c71d0a0d41e2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163389))
- [Add FK on events.personal_namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1829084aa298519b35ee81e067b007eef886c1be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168320))
- [Create AbuseReportLabelType GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/30968b5187756fc0f171334ef52ab429778e39b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168473))
- [Changed feature flag type from wip to beta](https://gitlab.com/gitlab-org/gitlab/-/commit/cbb6bcb6b262e4480e2ccf27fd00419da3d6b97a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167757)) **GitLab Enterprise Edition**
- [Introduce notes and notes_internal to WorkItems](https://gitlab.com/gitlab-org/gitlab/-/commit/64db46386933e53321994d4a1a20424f8b153ce4) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168216)) **GitLab Enterprise Edition**
- [Changes for allowed_email_domain update audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/7a76a2c665caddc38cbdc2011fe9d1b3e72f871a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166105))
- [Add migration and model for max retries and backoff](https://gitlab.com/gitlab-org/gitlab/-/commit/4a0d167477daf555cc89079cd64baa5407b92f36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166119))
- [Added service ping metric for member management enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e02f9dc1a6bf952ff91377c82415d5e1661c8941) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168096)) **GitLab Enterprise Edition**
- [Add members activity tracker worker](https://gitlab.com/gitlab-org/gitlab/-/commit/5911fc82d8f0cec1190028771f870640132fa171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167423)) **GitLab Enterprise Edition**
- [Show location and ISP in sign in from new location email](https://gitlab.com/gitlab-org/gitlab/-/commit/d6be7a24f833a2f000e903ddfd4516c2a19bf931) by @shangsuru ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163914))
- [Add project.mergeRequestViolations field on project type](https://gitlab.com/gitlab-org/gitlab/-/commit/163bd7a56baefa7d323c5d8bd331c9f34723081f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158884)) **GitLab Enterprise Edition**
- [Added new table and API for Workflow Events](https://gitlab.com/gitlab-org/gitlab/-/commit/d2397278ebfae0ec323400fd9926ad473428cc25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166397)) **GitLab Enterprise Edition**
- [Enable edit_branch_rules feature falg by default](https://gitlab.com/gitlab-org/gitlab/-/commit/724653c4d4cc9883ce18049be5625d2965ddb032) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166654))
- [Add job_token_policies column to CI job token allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/1156ad38b4faa8ea70735876dec644f1378cda02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166688))
- [Add work_item_epics_ssot feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e29682b09ab497bacdfcebfdcda0d256e7d344f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168174)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/59f33e5fdacad2fc90f78c11725314e168787178) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168202))
- [Alert success or file errors with model/version creation](https://gitlab.com/gitlab-org/gitlab/-/commit/c1ff9fc04813bb0a2bf759ef7d82f20c5372550c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166479))
- [Remove pypi_extract_pypi_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/85d5be158023e45cc1bc6c7a217a3c44afae6f47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167762))
- [Model Registry ability to delete experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/18eb2732ed482284d4eb2b2425aa162b86e646f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167414))
- [Display page header and subheader](https://gitlab.com/gitlab-org/gitlab/-/commit/6509f8f185983b3dd9bce06a87a01a1da12f54c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167612)) **GitLab Enterprise Edition**
- [Add a GraphQL mutation for updating `OrganizationUser`](https://gitlab.com/gitlab-org/gitlab/-/commit/95b9e199ee1cdf17853ad4b2f61131f4be4c940c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168037))
- [Adds a cop and a generator to initialize bigint conversion](https://gitlab.com/gitlab-org/gitlab/-/commit/fff3f8369cc87460f6fee80d62ed3516512a083d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164788))
- [Add search argument to contributed projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/addaf622c113c95022e88fb97d6b68c8d138cedb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167966))
- [Add min_access_level and programming_language_name arguments](https://gitlab.com/gitlab-org/gitlab/-/commit/39f4ff2d7b58980f6ef32d08d2a8cb4871e940d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167962))
- [Add audit events for SD Exclusions on create, update and delete](https://gitlab.com/gitlab-org/gitlab/-/commit/bd4c946f826be442037776da4e084366060626ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167943)) **GitLab Enterprise Edition**
- [Add programming language filter to contributed projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/3dff73035f5b784ad929811887da716ba0638f55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167017))
- [Model Registry ability to delete candidate](https://gitlab.com/gitlab-org/gitlab/-/commit/a39b2f0d0b4a415b9af8430abd5f273750d01793) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167718))
- [Create merge request dependency api endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/3b92612d27b4a8dec8f196cbd0e68dbaeeb081e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166700)) **GitLab Enterprise Edition**
- [Add async index to partition table](https://gitlab.com/gitlab-org/gitlab/-/commit/b4a3ad684e40ac20b5dd3e459c6266bc88eba120) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167814))
- [Add instance level job token application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/e1852d2b5b93559512feee725f4084ac3ef1395e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166952))
- [Add async index to partition table](https://gitlab.com/gitlab-org/gitlab/-/commit/68122df51808168f16c851fd4c76c4e21535fba4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167811))
- [Expose code suggestion events on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/29c5c9218936e4d013c87d1541226b59637adb99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165565)) **GitLab Enterprise Edition**
- [Add sharding_key_id to ci_runners table](https://gitlab.com/gitlab-org/gitlab/-/commit/f891e25cda3463904a6c21f6e57850fea150af43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166916))
- [Introduce group-level protected branches](https://gitlab.com/gitlab-org/gitlab/-/commit/a633fc221ff1f83b0d4f720411ffadda0f5cff69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167753)) **GitLab Enterprise Edition**
- [Release "allow anyone to pull" feature for terraform modules](https://gitlab.com/gitlab-org/gitlab/-/commit/0df09a776924dc95bc3428c8faac2432b981439a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167739))
- [Update API and docs to account for non-billable promotions](https://gitlab.com/gitlab-org/gitlab/-/commit/b42f20115b6e83c020db173240f8e8da28e764d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167020)) **GitLab Enterprise Edition**
- [Populate personal namespace for events](https://gitlab.com/gitlab-org/gitlab/-/commit/6f6af234dee87200827153f25b107e069f494c01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164979))
- [Add ml-candidate-metadata sharding-key](https://gitlab.com/gitlab-org/gitlab/-/commit/c770a2096dbaf9908598289631f05eb1ba98a5ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167660))
- [Add aiFeatureSettings GQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/659d8e03f89931638a69b1ec64c161730ad21ee2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166463)) **GitLab Enterprise Edition**
- [Ingest identifier_names of vulnerability_reads](https://gitlab.com/gitlab-org/gitlab/-/commit/f42afba65294540e03067cc950fb1d20e6f70dc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163086))
- [Auto-ban duplicate users when a user is banned](https://gitlab.com/gitlab-org/gitlab/-/commit/0ac977cc965ad2664a7fe02dc8387d44a8dafe78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166673))
- [Add new project redirect route to spec](https://gitlab.com/gitlab-org/gitlab/-/commit/b7cebc25cca7bdaae2751b20b7663db8fb960db2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165889))
- [Add Duo permission ability to vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/35a30d05511e5f4a8c87962193ed4589abf8ab7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167583)) **GitLab Enterprise Edition**
- [Add UserActivity class](https://gitlab.com/gitlab-org/gitlab/-/commit/4dff8c5eea8efdcc227b85e7a4e3af8ffd92d855) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167035)) **GitLab Enterprise Edition**
- [Add a link to navigate to the CI/CD analytics on the pipelines page](https://gitlab.com/gitlab-org/gitlab/-/commit/4cd78d7504f49934c247ce819d384a0349cd46bb) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167311))
- [Enable CI job token authorizations log](https://gitlab.com/gitlab-org/gitlab/-/commit/329342b4b12b9a20e84c9a5f460e2513a8301cef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167416))
- [Model Registry ability to load model](https://gitlab.com/gitlab-org/gitlab/-/commit/9e2df64ca337ac3883e038a4ffabb54aba06c422) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165815))
- [Add migrate_memberships to bulk_import_config](https://gitlab.com/gitlab-org/gitlab/-/commit/70bccda6c6ee42de11d2353c33a3e542ad07b8c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167056))
- [Add duo free access ending alert banner](https://gitlab.com/gitlab-org/gitlab/-/commit/f8ddc764202b359e7aa085999684d02062526b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167061)) **GitLab Enterprise Edition**
- [Delete stale npm metadata caches with background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4d4ca9921889a52190f5f2f894e31800d54ab9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165813))
- [Add suffix strategy selector](https://gitlab.com/gitlab-org/gitlab/-/commit/ceb2fa2c7fb2e4d8d1f4f9ece3a7bbe04ce7eb95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166549)) **GitLab Enterprise Edition**
- [Save draft data in storage](https://gitlab.com/gitlab-org/gitlab/-/commit/9de95c47c3e44b6bec50d07f908b76b9d0939580) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166586))
- [Add ability to remove resolved vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/32e3c13a5985d73e991473594ae118f72417d1f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166914)) **GitLab Enterprise Edition**
- [Add description field environments API](https://gitlab.com/gitlab-org/gitlab/-/commit/345f30d175d5ba270dbd31ad72871524a0242b4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167079))
- [Expose `has_vulnerability_resolution` via GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/7f704def79735d36a980e72fc8b957d2e6a5860c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166312)) **GitLab Enterprise Edition**
- [Add description text field to environment details](https://gitlab.com/gitlab-org/gitlab/-/commit/093182d3e38039e69d8cf5a2e0d591357208a7a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167062))
- [Add description field to environment (BE & DB)](https://gitlab.com/gitlab-org/gitlab/-/commit/c963b54cdfa00a5f21c9ac6905e7cb6a4f740a7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166941))
- [Create the snooze and un-snooze todos mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/9331b24be15f604234eb7b04646dfacba82f8aa9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164262))
- [Filter merge trains by branch param](https://gitlab.com/gitlab-org/gitlab/-/commit/ce725c21a1eaa08b94942661de0bed6b6027fd9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166949)) **GitLab Enterprise Edition**
- [Introduce a delete MR dependency api endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1ae36c0f4fb5d29a9d6e5e4cf5be84e108139d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166339)) **GitLab Enterprise Edition**
- [Add `include_personal` argument to contributed projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/616f6dfb10be465829ab41e64638fa02c7a772d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167174))
- [GraphQL: Add `aggregate` field to PipelineAnalytics](https://gitlab.com/gitlab-org/gitlab/-/commit/719e68074bf30bb9f224d16b0c162bab503db360) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165549))
- [Update Llm completion for VR suggestion](https://gitlab.com/gitlab-org/gitlab/-/commit/cb4252ae300cfe7ed7396922ebf692fbee8bf0f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166230)) **GitLab Enterprise Edition**
- [Add source-branch filter](https://gitlab.com/gitlab-org/gitlab/-/commit/dfa9283d8c1aee78b05f3f1d3f4872d08b52c8fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156491))
- [Enable Ruby support for GitLab Advanced SAST](https://gitlab.com/gitlab-org/gitlab/-/commit/a319102766075cb2597a1365f28b602a246584b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165943))
- [Add ingestion for EPSS data into GitLab DB](https://gitlab.com/gitlab-org/gitlab/-/commit/6a17d43561196e6165c8ec1560ec3bdc4e520660) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164348)) **GitLab Enterprise Edition**
- [Remove feature flag vulnerability_resolution_ga](https://gitlab.com/gitlab-org/gitlab/-/commit/c5456f1548914668659ac06a67dafe9003a96988) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166354)) **GitLab Enterprise Edition**
- [Added membership_modified_by_admin_event](https://gitlab.com/gitlab-org/gitlab/-/commit/7a71e994d79cd3ba9752ce50df32cb54bc194bd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163631)) **GitLab Enterprise Edition**
- [Protected branches API: support `deploy_key_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/ffa03ce93bdfb03a2ceb8b86d87cc596bbc6583c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166598)) **GitLab Enterprise Edition**
- [Remove loose_foreign_keys_update_column_to feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4b159a7f0c266274ed4ff8a4f9bdbacd1d79259c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167006))
- [Add an empty state for MR approvals per branch](https://gitlab.com/gitlab-org/gitlab/-/commit/85ad6180f1d95e55bab21b24875a8298bf60285d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166996)) **GitLab Enterprise Edition**
- [Adds GitlabSubscriptions::SeatAssignment model](https://gitlab.com/gitlab-org/gitlab/-/commit/563a3eb96a81844a5bb495c3812335a4e4ec1b79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164799)) **GitLab Enterprise Edition**
- [Backfill for `vulnerability_reads.has_vulnerability_resolution`](https://gitlab.com/gitlab-org/gitlab/-/commit/5db7c9bf3c95d2185e71ece8e3856036277ee1c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166110)) **GitLab Enterprise Edition**
- [Elasticsearch: Merge requests with title completion](https://gitlab.com/gitlab-org/gitlab/-/commit/eac40c5be6b672138a38c6623ab3edb0101a1032) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166751)) **GitLab Enterprise Edition**
- [Add min_access_level argument to contributed projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/d79ebab6a1b1ed1ba8a1f7c19b8c3977a7dffbc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166409))
- [Use CycloneDX SBOMs licenses in license scanner](https://gitlab.com/gitlab-org/gitlab/-/commit/abdfd55584c321e43e4b427f6d2bd03dc8b4c7aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162631)) **GitLab Enterprise Edition**
- [Add backticks to GitHub import user mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/46dd8d71f2912a2fce793158657e0afecedf48bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166635))
- [Support for editing the model version description in the model registry](https://gitlab.com/gitlab-org/gitlab/-/commit/2ae4f7108fcbbc5112bb1795df28ec3205517094) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165539))
- [Add column 'max_number_of_vulnerabilities' to 'project_settings' table](https://gitlab.com/gitlab-org/gitlab/-/commit/a25e82643726a3f06f019c0fe9461808edf8c4f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166578))
- [Add RewriteHistoryWorker to asynchronously rewrite repository history](https://gitlab.com/gitlab-org/gitlab/-/commit/9b8bb4a8cf2e750ad47c8c7e983f1440d05f58f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162306))
- [Protected tags API: support `deploy_key_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/5e428dfbbebc0692968757d1109f2fb8c0c84fc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166866)) **GitLab Enterprise Edition**
- [Remove work_item_epics_rollout feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3efdcc118619284090d23a08ffb66ed9ce7b6a7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165338))
- [Add cron info to pipeline schedules table](https://gitlab.com/gitlab-org/gitlab/-/commit/1013d760aaa17eaf5f515d4c5265ffa5daed005f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166547))
- [Add subscribed argument to issues query](https://gitlab.com/gitlab-org/gitlab/-/commit/738d8e2cdac5d3b633a1238426b7a6cde8c4133e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134807))
- [Initial checkin for Banner](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc518e510d2e45905c6bec6048e4f9e6eabaaa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165756)) **GitLab Enterprise Edition**
- [Change relationship type of linked items via drag & drop](https://gitlab.com/gitlab-org/gitlab/-/commit/97bdd0a47b648241d90a23f6b58eb17e8c3f0edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164296))
- [Remove references to gitlab_com_duo_pro_bulk_user_assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/6d3312d46ddefb2eb0799bb8a35242cdf08d446a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166747))
- [Add rails endpoinds for workflow status updates](https://gitlab.com/gitlab-org/gitlab/-/commit/16ee928bc5e7d6e16d0feda57e710dc6d2de30d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165818)) **GitLab Enterprise Edition**
- [Add event handlers for security policies changes](https://gitlab.com/gitlab-org/gitlab/-/commit/a9182c9344c1785fe80b2a9a2f14241b59ac633d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165569)) **GitLab Enterprise Edition**
- [Add API endpoint to publish CI Catalog Resource Version](https://gitlab.com/gitlab-org/gitlab/-/commit/9db6aa7ed4820488e817096759d8d4d10622032d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164858))
- [Add language filter to projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/935b8fd064877aec1f37556a569d3eee8b47dcf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166098))
- [Database changes for splitting microsoft applications](https://gitlab.com/gitlab-org/gitlab/-/commit/6467dddd1286a663877d2b8b9d5cc41bbddfe5da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164377))
- [Add vuln counts to container regsitry page](https://gitlab.com/gitlab-org/gitlab/-/commit/70c9d6928209e1d6504c94dbf0d46bc4ac4d26fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161994))
- [Add license checks to group level work items ability checks](https://gitlab.com/gitlab-org/gitlab/-/commit/6800de2b04e5ddab1937d36ba2891ea19a889aea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165909))
- [Add log fingerprint to the created issue](https://gitlab.com/gitlab-org/gitlab/-/commit/3cb1073119f2be42d85dd605ddf27ba5b855061d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166214)) **GitLab Enterprise Edition**
- [Add min_access_level argument to Projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/1f94c52f172b45be3fb72d5a613bf76e97d59368) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166376))
- [Add graphql mutations for project security exclusions](https://gitlab.com/gitlab-org/gitlab/-/commit/1d3f7c7c1336f708a8f03bfd25010a7208ca9235) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165396)) **GitLab Enterprise Edition**
- [Admin API Endpoint: Token Info](https://gitlab.com/gitlab-org/gitlab/-/commit/142cca525f054dae36fdaf9b1368f7c7db9246f9) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165157))
- [Release "allow anyone to pull" feature for group-level maven endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/c4ff30e55761c74c20d4776e724bfb58e8e91f01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166115))
- [Add artifacts archive setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f8d5adce372ebbac2dd1036f658c32961f5019eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166496))
- [Release "allow anyone to pull" feature for group-level NuGet endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/e3020839c59d094d1058b89ccc87a3a9913e785a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164325))
- [Delete `custom_ability_admin_runners` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/68efeab37432d0579da5c16065b0f93c086398f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163234)) **GitLab Enterprise Edition**
- [Persist approval_policy_rule_id for scan_result_policy_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/5068afd1791dfec1817b7f3275ddab680d3ae6d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164808)) **GitLab Enterprise Edition**
- [Move the zoekt_repository to failed if retries_left gets 0](https://gitlab.com/gitlab-org/gitlab/-/commit/11fdad2ff35c1707d03651142bf21428de7d02d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165187)) **GitLab Enterprise Edition**
- [Rename and add fields additional context rest api](https://gitlab.com/gitlab-org/gitlab/-/commit/96006484858a7c8cd5b369f20185e87515ee6d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164944)) **GitLab Enterprise Edition**
- [Show SBOM reports errors on the pipeline security and licenses tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/1f079c0ae6293aff0bf95597001a6c9a56419e96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161235)) **GitLab Enterprise Edition**
- [Enable dependency_scanning_using_sbom_reports by](https://gitlab.com/gitlab-org/gitlab/-/commit/b44bc52692676d7894aaa2c363cb845e12b75491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165775)) **GitLab Enterprise Edition**
- [Add aiSelfHostedModelFeatureSettings query](https://gitlab.com/gitlab-org/gitlab/-/commit/b26d01ea4138e0e2585e8dc2831271f8ab7a3aea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166315)) **GitLab Enterprise Edition**
- [Add merge_after attribute to MergeRequest](https://gitlab.com/gitlab-org/gitlab/-/commit/c36f582d9f5134693add8cde163744ec2344337f) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165092))
- [Suspend/Resume flux reconciliation from the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/9e94ac3afdd5a91464498e1ae721f25339cab13b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165955))

### Fixed (132 changes)

- [Protected containers: Push protection for admin users](https://gitlab.com/gitlab-org/gitlab/-/commit/443b67e0f0a7aa50f6a34b88c2acccc2f69f6b63) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157464))
- [Prevent submitting form when pressing enter in transfer location search](https://gitlab.com/gitlab-org/gitlab/-/commit/4326a77740e85de613744ef3ba84278f9c4300db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168440))
- [Revert "Fix Helm chart appVersion not being quoted in index.yaml"](https://gitlab.com/gitlab-org/gitlab/-/commit/f5468087f7ce77a04f14d054817dfc3be8145b01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169141))
- [Cloud Connector sync: Read license from DB](https://gitlab.com/gitlab-org/gitlab/-/commit/24faba75877ffc5454e98c6b83fc30570587d1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168796)) **GitLab Enterprise Edition**
- [Revert "Merge branch 'sc1-optimise-concurrency-tracking' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/58924e97585f2fe2f5c6cac3ca1bf513ed67f03a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169050))
- [Fix handling of loading secrets with empty section](https://gitlab.com/gitlab-org/gitlab/-/commit/c25f903f3cff73bb47b2d1ee9ade9febfd170b07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168902))
- [Merge requests API: fix cache for "with_labels_details" argument](https://gitlab.com/gitlab-org/gitlab/-/commit/3d7e2858794c7a44225b1c6e8e9ed08095fd4e08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167440))
- [Labels page: Fix vertical alignment and badge](https://gitlab.com/gitlab-org/gitlab/-/commit/6bdc6cb4fd6069f1c821150ca5f64efaf662a7c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168932))
- [Prevent non-ASCII names](https://gitlab.com/gitlab-org/gitlab/-/commit/21020627671ee03012b5f1e8637d11725fc732e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168899))
- [Mini Pipeline graph: Fix height of item and alignment of retry](https://gitlab.com/gitlab-org/gitlab/-/commit/f964a98df5ebf6221ec72539045569051fb08a53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168798))
- [Add response-content-disposition to url in  Workhorse.send_url](https://gitlab.com/gitlab-org/gitlab/-/commit/eeb0598b35e889dc96aa108d59bb36363603643f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167015))
- [PullMirrors::UpdateService: remove previous data after mirror's update](https://gitlab.com/gitlab-org/gitlab/-/commit/c7e9b840d177c74b5dbd208b01d81c3ea2e3c523) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168417)) **GitLab Enterprise Edition**
- [Update export to not hard fail when one batch export fails](https://gitlab.com/gitlab-org/gitlab/-/commit/1e8e9abe799782a8b97c1fdf37cded83d04167b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168768))
- [Requeue BackfillPCiPipelineVariablesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/3afb5bb404dce203a98d2ee5937683d023857803) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168493))
- [Show pending project members on pending members page](https://gitlab.com/gitlab-org/gitlab/-/commit/46f919a9d646abf1003c3d3e2b69b4cce9e43c7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167481)) **GitLab Enterprise Edition**
- [fix: Use hash reference for resolving security finding CWE identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/bb508ac16ed279a5c5611609d3ddbc8ae532efcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168658)) **GitLab Enterprise Edition**
- [Fix access to job logs for anonymous users](https://gitlab.com/gitlab-org/gitlab/-/commit/9186689cdeca4d14511ab43d5d1484093b77588c) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168125))
- [Allow self registered user to trigger user_create hook](https://gitlab.com/gitlab-org/gitlab/-/commit/54a93bc65ed684c1954ed13c0db974e91e18c11a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167867))
- [Reset ci_deleted_objects#pick_up_at](https://gitlab.com/gitlab-org/gitlab/-/commit/bd32a37d9de7e462463ce7e8a38f65c4b4ce0b10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165778))
- [Wrap source user reassignments in a lock](https://gitlab.com/gitlab-org/gitlab/-/commit/e3970a7de431f76f223a486194fd203928150adf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167765))
- [Fix #root_ancestor when parent_id is defined](https://gitlab.com/gitlab-org/gitlab/-/commit/052bab7f670d09d4b16e0b909da7424e39ef0cda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168149))
- [Fix project_settings#has_vulnerabilities data inconsistency issue](https://gitlab.com/gitlab-org/gitlab/-/commit/620686bcb7852527c4f5a1ec5bc6a8dedb729dbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167933))
- [Send correct namespace for the Flux resource](https://gitlab.com/gitlab-org/gitlab/-/commit/a318f28e48c75c95eb37de7ef3dd9e7e28d124d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168571))
- [ansi2json: Handle multiple CRs in line endings](https://gitlab.com/gitlab-org/gitlab/-/commit/713116ba1e34d9b7bfa40c32cb35841bf5f782e8) by @lb90 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167050))
- [Pipeline Graph: Fix badge text color and card header in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/7f60f4e8e7144c115096be37b927b8dfb448dea9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168418))
- [Fix deeplink urls for migrated epics](https://gitlab.com/gitlab-org/gitlab/-/commit/6099d8378f0705d666116dbe1c453e6aa6b671a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167572))
- [Respect model registry and experiment visibility settings](https://gitlab.com/gitlab-org/gitlab/-/commit/416ec82806b6932dafabc7abf29fb0dd5c8d8396) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168148))
- [Add `epic` to confidentiality feature](https://gitlab.com/gitlab-org/gitlab/-/commit/1831dc9521eb13163064b2aacb560d3e48c401c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168455)) **GitLab Enterprise Edition**
- [Flash alerts: Fix sticky position](https://gitlab.com/gitlab-org/gitlab/-/commit/6b06688a56375cf29d75e2ed5bee6170bb8843f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167898))
- [Reset group callout for all seats used banner when deleting a member](https://gitlab.com/gitlab-org/gitlab/-/commit/0c86cba0b2f6621cdf638b96451440340d3dd6b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168429)) **GitLab Enterprise Edition**
- [Fix min-width of user select dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/253f951e6b388279551e5c8b2707f329f3f70173) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167686))
- [Remove bottom padding on images](https://gitlab.com/gitlab-org/gitlab/-/commit/496f232b662f2580b8f599b0674e5bb1b7140257) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168423))
- [Remove vertical scrollbar on GLQL tables](https://gitlab.com/gitlab-org/gitlab/-/commit/8f03055e409b83c8a174dbb628fadcdd178686cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168421))
- [Fix for Personal Projects Settings bug](https://gitlab.com/gitlab-org/gitlab/-/commit/5b8625a1609c755307374189d7c20e955f424252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167066))
- [Separate UI and API checks for user impersonation](https://gitlab.com/gitlab-org/gitlab/-/commit/51c6695194966c8608b98f05285d8baa6f88ac9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166639)) **GitLab Enterprise Edition**
- [Fix policy violations not being deleted properly](https://gitlab.com/gitlab-org/gitlab/-/commit/a1f604ff05a78dbc7f5c063d378c3241940701f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168373)) **GitLab Enterprise Edition**
- [Prevent registration group creation changing registration_type](https://gitlab.com/gitlab-org/gitlab/-/commit/451cf1dc8049547c354c444bbd71974da168af77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167959)) **GitLab Enterprise Edition**
- [Delete deployed Pages on Project archive](https://gitlab.com/gitlab-org/gitlab/-/commit/6a72e7eb5cfa88e10bf1db94a7bfe47448e0ab52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168352))
- [Link compliance frameworks with pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/f6e14854631c53ee2233ba72ebc0d59396f1daf3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167970)) **GitLab Enterprise Edition**
- [Remove `go_get_handle_401_error` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6c0de46aefcdeb8613bd3ecced2955cea363ca3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168338))
- [Clear draft on cancel](https://gitlab.com/gitlab-org/gitlab/-/commit/e9f9a7929b9e7ae1d9c1aacde0e170b6d4f6a8d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168251))
- [Fix project level value stream analytics default date](https://gitlab.com/gitlab-org/gitlab/-/commit/84773751f3595e03333da412690d374490042a3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167476))
- [Distinct select style for user mentions in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/29ec0bae734d49954daae20fdf08cf0cc7e45516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168120))
- [Only show custom emoji from current group in frequently used emoji](https://gitlab.com/gitlab-org/gitlab/-/commit/993a7811f0da4e857d9f8771a383712d192b02ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167665))
- [Update CycloneDX 1.5 json schema with upstream](https://gitlab.com/gitlab-org/gitlab/-/commit/6d18ef2462a0add8a4dc622ebaee64bdc83c9400) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167829))
- [Fixes package tag not being displayed](https://gitlab.com/gitlab-org/gitlab/-/commit/eea81d108fea46106b67a5c5b624dc0ada4d7844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168229))
- [Groups Filter - Fix pagination tree view](https://gitlab.com/gitlab-org/gitlab/-/commit/8759bd95b8ace74f648c5ebd9d17ee7dbdb2ef44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167821))
- [Use error message from backend when updating member role](https://gitlab.com/gitlab-org/gitlab/-/commit/d566faf1e4f46ff2f99d0bb210d7bb0428aaecd9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168115)) **GitLab Enterprise Edition**
- [In Pages build use use_open_file instead of use_file](https://gitlab.com/gitlab-org/gitlab/-/commit/789a78a46b98011c6587ff161656f15c78238272) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167150))
- [Allow Instance Admin to always create projects](https://gitlab.com/gitlab-org/gitlab/-/commit/7c7a2c77fca1588f6e75c7b39f7764edc124c9da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168021))
- [Model Registry model versions empty state typo](https://gitlab.com/gitlab-org/gitlab/-/commit/efc5115666a629ee90634343e8601d43d16a02aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168070))
- [Update haml markdown editor toolbar buttons to match Vue version](https://gitlab.com/gitlab-org/gitlab/-/commit/1986af18c2020bc7a77a3b77501176efdf1b5b1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167486))
- [Recover destroyed ML model version packages](https://gitlab.com/gitlab-org/gitlab/-/commit/3f89d8f0ab46e484c5aa28ebbd7c2fb061d64e5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165214))
- [Fix broken wiki sidebar when slugs contain special characters](https://gitlab.com/gitlab-org/gitlab/-/commit/2d2f164ec58453d8d28f37b5876c3afedee2499e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167331))
- [Drop project_id not null constraint ci_deleted_objects](https://gitlab.com/gitlab-org/gitlab/-/commit/7cb19470ae995db7d008489e884ab2abd30f377f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168024))
- [Fix link color override with increasing specificity](https://gitlab.com/gitlab-org/gitlab/-/commit/af6ef77df854356bd6c3329bad4c4e36df119b8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167921))
- [Remove project_id FK constraint on terraform module metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/2743d2382767682865fc11e868f6c88773804a4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167182))
- [Fix collapsed diff discussions expanding when adding a new discussion](https://gitlab.com/gitlab-org/gitlab/-/commit/e6855e9755cd6138b381346252d93e4c27075959) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167987))
- [Prevent deploy key access when owner is not a member of the project](https://gitlab.com/gitlab-org/gitlab/-/commit/9ad5f83c1ef739e56ad1ec4b002cc93473983aa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167297))
- [Prevent approval rule from overlapping approvals count in drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/bf051cfe3b11cde28172f857a51d718574de9a2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167981)) **GitLab Enterprise Edition**
- [Handle expired CI job artifacts with orphaned projects](https://gitlab.com/gitlab-org/gitlab/-/commit/49b0c18fd57fb920d85a1a6024146216be77ce75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167977))
- [Filter work item children and ancestors out of work item token input](https://gitlab.com/gitlab-org/gitlab/-/commit/ca7b02cbc179b42855d9a506d206047c6bdfbb0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167247))
- [PWA: Respect the screen rotation settings of the user device](https://gitlab.com/gitlab-org/gitlab/-/commit/e269216e49a96e988abfc428a893286aac43911e) by @kurages ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166957))
- [Fix flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6c2ee16bee3cd7d9296ecef98d7aff1fe4c7ba20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167892))
- [Do not fetch license on Duo page when SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/4be030a6cda722426add1c69e402298c5af93eee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167431)) **GitLab Enterprise Edition**
- [Fix Web IDE Oauth domain mismatch screen](https://gitlab.com/gitlab-org/gitlab/-/commit/5fff1ec16ed0afad01b96330ff4a7116e9d8b2e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167598))
- [Fix for Groups Duo Subscription Bug](https://gitlab.com/gitlab-org/gitlab/-/commit/7b5f7b45b459437e9bae691e705dd9dacd5f1105) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167259)) **GitLab Enterprise Edition**
- [Fix Helm chart appVersion not being quoted in index.yaml](https://gitlab.com/gitlab-org/gitlab/-/commit/503f7688f10a703b1e6540435091967a457e60fb) by @djhoese ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166663))
- [Fix styling problems for Escalation policy rule controls](https://gitlab.com/gitlab-org/gitlab/-/commit/b37c422df6e4c2823b02ee93fb010b89724b0c32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167675)) **GitLab Enterprise Edition**
- [Allow `:admin_runners` to clear runners cache](https://gitlab.com/gitlab-org/gitlab/-/commit/f2857a90614adfaf8b9a5c83cf0ce5fa1645d12f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166545)) **GitLab Enterprise Edition**
- [Projects::GraphsController#charts: fix URL generation](https://gitlab.com/gitlab-org/gitlab/-/commit/c644501f79b9c52a9f7a7512c6a7c0550b6d4028) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167616))
- [Handle existing resolved ocs vulns](https://gitlab.com/gitlab-org/gitlab/-/commit/4a13718607a5094a7651babd5f54dcd1d288dd23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166593))
- [Add migration for fixing organization_id inconsistencies](https://gitlab.com/gitlab-org/gitlab/-/commit/fde998e9f5ba4de3f552fc0cdb7468f5894ed5c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166909))
- [Only create system note on color change](https://gitlab.com/gitlab-org/gitlab/-/commit/7d801c2b540e2c99bf3fbfda89ee33c5d9871f69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167479)) **GitLab Enterprise Edition**
- [Fix flaky logger spec](https://gitlab.com/gitlab-org/gitlab/-/commit/88a71a200c17d8ef3cce3af6f71c456dd96092c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167159)) **GitLab Enterprise Edition**
- [Skip status checks for empty diff hashes](https://gitlab.com/gitlab-org/gitlab/-/commit/2c8627f26919e44549bf7d3fd94c45ac1be34d7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167063)) **GitLab Enterprise Edition**
- [Fix NRE when logged out and reading merge trains via GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/0d21ab174b1290fbfd5e34355e40fdba5df816d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167410))
- [Allow reviewer unassign via quick action at MR creation](https://gitlab.com/gitlab-org/gitlab/-/commit/1942d99575ec486f650d6490f30e6d026be9b290) by @kingjan1999 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166379))
- [Fix counting new vulnerabilities in ingestion logic](https://gitlab.com/gitlab-org/gitlab/-/commit/0c9cd9fccdda1d9c6d377ce9af905ec1c3e6dbbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166724)) **GitLab Enterprise Edition**
- [Fixing pipeline config issue for multiple frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/394a004f6867cbc8ce85b9675d9c040d8686b475) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166282)) **GitLab Enterprise Edition**
- [Fix authorized find in project security exclusion mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/4884e709131c72f75ae7b4bd4b8dc70a2c92b252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167340)) **GitLab Enterprise Edition**
- [Skip new branch name validation for some keypresses](https://gitlab.com/gitlab-org/gitlab/-/commit/15c65d468b77ae69379f56dce3e01dbde67cc369) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166754))
- [Remove duplicate ci status](https://gitlab.com/gitlab-org/gitlab/-/commit/474cfb9aa85945431d16fabb5e5fc7cb73bae26d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167198))
- [Make a Vulnerability a proper todo target](https://gitlab.com/gitlab-org/gitlab/-/commit/37ca3ffc0f8bbc9c032e3670f71438c83d967236) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167042)) **GitLab Enterprise Edition**
- [Add auth check to delete tag endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/1af60712cbdb0c9b42e8b65c50c19f07e589af62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166606))
- [Handle merge when checks pass correctly in the api](https://gitlab.com/gitlab-org/gitlab/-/commit/acc30ec6270ab67c0d0f255cdce8f925c7c2c066) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166301))
- [Fix timeline style in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/04fd023b2f93fe4673b554c1e83affdf5e6a5ce5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167230))
- [Add sass file page_bundles/todos_vue.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/c5002ff2e6fbf865c09fc76605dac1ab4fe73128) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167204))
- [Adjust wording for pipeline's license tab](https://gitlab.com/gitlab-org/gitlab/-/commit/979b0bf570973153bbaf35d39a5fdb31f61f1a36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167189)) **GitLab Enterprise Edition**
- [Fix logged out header for auto color mode](https://gitlab.com/gitlab-org/gitlab/-/commit/d723c1e02075ec2bb3aa4c32c3fb00a3c18d22cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167158))
- [Prevent 500 errors when evaluating empty changelog configs](https://gitlab.com/gitlab-org/gitlab/-/commit/c81182ff7acac70803a6f24b08d1530a9bda9e0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166610))
- [Initial commit for hide duo chat](https://gitlab.com/gitlab-org/gitlab/-/commit/707769340d1e6341f4793d2507c138e13dd1e168) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166225))
- [Improvements to markdown "Exit full screen" button](https://gitlab.com/gitlab-org/gitlab/-/commit/1d77947b9e02d4d46d7f187072d355bf1d9d0d90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165838))
- [Prevent footnote backref from displaying as emoji](https://gitlab.com/gitlab-org/gitlab/-/commit/26101bc2b955756b5cc4f9c29696cbd799e0b4de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166768))
- [Fix draft not clearing after submitting description](https://gitlab.com/gitlab-org/gitlab/-/commit/f43381765754c3012a82294264e99f88020b5edb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167069))
- [Fix error when trying to access nil commit author (via GraphQL)](https://gitlab.com/gitlab-org/gitlab/-/commit/689e8aab2b0698c160e19319012aff2f1be127b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166951))
- [Filter out duplicate milestone results in filter search bar](https://gitlab.com/gitlab-org/gitlab/-/commit/8e696e5f22a01821039ec2958ece5abe97077f69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166947))
- [Prevent links in project descriptions from making project rows too wide](https://gitlab.com/gitlab-org/gitlab/-/commit/956324dda2f7bb9d3ab2819d8cda7f9de7b6edb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166930))
- [Update access level for imported protected tags](https://gitlab.com/gitlab-org/gitlab/-/commit/409ae571ce32a6c3dd3666592408fa3d8f6ad414) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166905))
- [Fix partitioning rollback for p_ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/19f7b1e7b68745d0ddea02a93a86c3b04b1160ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166455))
- [Allow to search for todos with commit target type](https://gitlab.com/gitlab-org/gitlab/-/commit/276c8643e217e4b6fc13bc8a440386e8d33bea6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166744))
- [Todos: Add namespace and project target types to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/b6c6b4bd0dd498315a31a6619705e09016a61dd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166744))
- [Grant Auditor users :read_package ability on the group-level](https://gitlab.com/gitlab-org/gitlab/-/commit/2b3b560064b9b02a761f7425e04e868f2aecc7e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166753)) **GitLab Enterprise Edition**
- [Fix decreasing the project vulnerability counts](https://gitlab.com/gitlab-org/gitlab/-/commit/1d0ed78adbf80d9e853470285463094c13622c12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166734)) **GitLab Enterprise Edition**
- [Fix Zoekt global code search](https://gitlab.com/gitlab-org/gitlab/-/commit/136233eac31c236d7061c1fee530408083a49f54) by @skel2007 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165835)) **GitLab Enterprise Edition**
- [Design management: Highlight current user handle](https://gitlab.com/gitlab-org/gitlab/-/commit/d71d0349ccf647d019e9cf9b830cca33ab65b89d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166295))
- [Model Registry version compatability with mlflow endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/46bf0d0d1127a2a7d13e3f4828ce6f888421853b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166458))
- [Restore border on pipelines table](https://gitlab.com/gitlab-org/gitlab/-/commit/2a713329ca0e6c151895fc20724de9bb02a84c8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166645))
- [Fix incorrect gitlab-shell-check filename](https://gitlab.com/gitlab-org/gitlab/-/commit/e30f163ac684362c1536a5cd12d3ad796498fdae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166684))
- [Enable external status checks mutation for Projects::AllBranchesRule](https://gitlab.com/gitlab-org/gitlab/-/commit/f2425195a4370a4ad6b2b76d94b94df4c59c28d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165961)) **GitLab Enterprise Edition**
- [Sync pipeline iid with subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/d7232b9a152ef599cb54dc8652157d18e2a2daa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166538))
- [Fix misleading UI message](https://gitlab.com/gitlab-org/gitlab/-/commit/2bf0d162feb69d3986fd317ee4ddedbd42d55879) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166607)) **GitLab Enterprise Edition**
- [Broadcast message styles remove manual dark mode color override](https://gitlab.com/gitlab-org/gitlab/-/commit/d944b8c97b75633be28ac6f937cfbf958c18c59a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166589))
- [Remove add child console error](https://gitlab.com/gitlab-org/gitlab/-/commit/5b1bd1e47f965e33a14732a2135c6b467d988983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165622))
- [Fix truncated messages for commits](https://gitlab.com/gitlab-org/gitlab/-/commit/82b2d2a26e538c927838ee886810ac0ee346957a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166327))
- [Allow POST to jwt/auth during maintenance mode](https://gitlab.com/gitlab-org/gitlab/-/commit/b4e290ea1040ee7181ec723ecdaef903e09ec487) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166322)) **GitLab Enterprise Edition**
- [Reschedule setting vulnerability counts for projects](https://gitlab.com/gitlab-org/gitlab/-/commit/ceb506aadeb5a5380d3ac7569e316edfc4ffaf8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166471))
- [Fix page jump when reacting to work item comments](https://gitlab.com/gitlab-org/gitlab/-/commit/29f631929b05da75977be94540fef4c46164b38e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166462))
- [Fix regression not allowing clearing out runner tags](https://gitlab.com/gitlab-org/gitlab/-/commit/a4aa25b608881f9322b739dd413ff247fd041c9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166437))
- [Fix work item skeleton loaders for extra pages](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5be723081c60d5e8affaf64180f1e254122d66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166441))
- [Send null memberRoleId instead of undefined](https://gitlab.com/gitlab-org/gitlab/-/commit/23930e78d4076a0972cd5e4777cb5d7793010844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166432))
- [Avoid database reconnections when host disconnected from load balancer](https://gitlab.com/gitlab-org/gitlab/-/commit/934db1c7952db68b8c65c4eacaeabd684a9a8616) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166231))
- [Fix framework link in policy migration merge request](https://gitlab.com/gitlab-org/gitlab/-/commit/3ea8d2fcb90701f78317db41d473064108df9a89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166260)) **GitLab Enterprise Edition**
- [Remove extra container classes on Auto DevOps banner](https://gitlab.com/gitlab-org/gitlab/-/commit/0b68c687821d3aac4b75f994486ac954127a2d75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166216))
- [Check commit message for issue close pattern setting](https://gitlab.com/gitlab-org/gitlab/-/commit/ba347d799733a7b641bdc324caf6f580569f8bb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165877))
- [Initially hide final alert on model registry artifact upload](https://gitlab.com/gitlab-org/gitlab/-/commit/900510a1eb985bf94ad6a20a79c6de93173a4dfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166121))
- [Consider Duo Enterprise when counting Pro users](https://gitlab.com/gitlab-org/gitlab/-/commit/f6245703cbfbfa7db6b0af35655fd9c087e25e95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166120)) **GitLab Enterprise Edition**
- [Fix ci_owned_runners returning other groups](https://gitlab.com/gitlab-org/gitlab/-/commit/da2cabe48a2859d0f0287aef1b682282a9e82245) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165886))
- [Ensure pipeline job items in a stage have appropriate border radius](https://gitlab.com/gitlab-org/gitlab/-/commit/01e428f372da08609b1cfa65d87532147d3c42c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165866))
- [Do not parse SSE events if not streaming](https://gitlab.com/gitlab-org/gitlab/-/commit/4830d389e0def82c2c961b8d7537580502487adf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165771)) **GitLab Enterprise Edition**
- [Fix N+1 in cluster agents resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/e13cb11bc308eebd572c5876f45ef56c233c49a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165734))
- [Fix bug where car left after branch deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/76fd7acb19210c6a239fa14a2989c981e6cbac76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165216)) **GitLab Enterprise Edition**

### Changed (205 changes)

- [Add page refresh when policy type is selected](https://gitlab.com/gitlab-org/gitlab/-/commit/1a799dc1608dbf303bb14aab383ec4462c747be3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168881)) **GitLab Enterprise Edition**
- [Remove allow_cross_joins_across_databases in finding_signature.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/b37fbf55cfdde1755436dcd3f65d80504f8f2978) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168627)) **GitLab Enterprise Edition**
- [GraphQL: Rename CiJobsDurationStatistics to CiDurationStatistics](https://gitlab.com/gitlab-org/gitlab/-/commit/cc9f07ae166b46e7b0644f688b0267b46d6dc0f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167941))
- [Added feature flag gate](https://gitlab.com/gitlab-org/gitlab/-/commit/b586b7e488fcf9d837af6085d883ac83205acc98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168770)) **GitLab Enterprise Edition**
- [UI: Do not expire direct memberships in subgroups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/c12b4adb7e3d4a18cefa68b9cadbe8d5dda563d3) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168183))
- [Separate notes from vulnerabilities update when dismissing](https://gitlab.com/gitlab-org/gitlab/-/commit/b1f2249ca7a9e15e4501d3cf5d1b633b394b1050) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167299)) **GitLab Enterprise Edition**
- [Update Load Performance Testing templates](https://gitlab.com/gitlab-org/gitlab/-/commit/3d609d4edfa874759a4d15d2b624ca0eee644727) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168538))
- [Use file icon for uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/061346deacbe314709956951044a92b79906632e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168869))
- [Support pages deploy jobs with names other than "pages"](https://gitlab.com/gitlab-org/gitlab/-/commit/277c9f6b643c92d00101aca0f2b4b874a144f7c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166731))
- [Remove `finding_resolver_use_pure_finder` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/72cff03c35c3d2f24b3d9b0e9a8347411abcec99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168882)) **GitLab Enterprise Edition**
- [Mark oauth_applications table as clusterwide](https://gitlab.com/gitlab-org/gitlab/-/commit/c54be1640371abbed26bade038ab54b1b5c692bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162438))
- [Remove references for editor field on workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/56cbef665d316101c4fd3cf94166c563989b6f37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167673)) **GitLab Enterprise Edition**
- [Add CI/CD Catalog wrapper to releases](https://gitlab.com/gitlab-org/gitlab/-/commit/42b7f5a1438e61adb7879d05a40badb5a92461a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167664))
- [Load first note on work items](https://gitlab.com/gitlab-org/gitlab/-/commit/c84bb1c35438612a6e0fca57daf1497354ad0d34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164840))
- [Update copy for free registration paths](https://gitlab.com/gitlab-org/gitlab/-/commit/383e63df9a2f81e2a5df456152060499755d8abf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168118)) **GitLab Enterprise Edition**
- [Handle mailmapped emails for ssh verified commits](https://gitlab.com/gitlab-org/gitlab/-/commit/67cada1c739a8c9a5b05220f61e9b8c7b6c425b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167667))
- [Handle Work Item URLs in Duo Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/3a11e0164a024fb2548cfe92da925a6beeb01cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168359)) **GitLab Enterprise Edition**
- [Update license scanning documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/f123ab83eb356e767d93932ebe83661ba4c955f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168771)) **GitLab Enterprise Edition**
- [Remove delete_otp_no_webauthn feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6559857ebc6e52bd8418d4aad62eec7504395d21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168434))
- [Wikilinks now handle characters escpaed in title](https://gitlab.com/gitlab-org/gitlab/-/commit/3c8ab86df5175868e57733621c880f6508cc5396) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168837))
- [Set vulnerability_exports table to gitlab_sec schema](https://gitlab.com/gitlab-org/gitlab/-/commit/8f6e831cc98177cc624d90b1189ca049910f99a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168856)) **GitLab Enterprise Edition**
- [Adjust toggle behaviour for runner registration token setting at group](https://gitlab.com/gitlab-org/gitlab/-/commit/75f7bc6376260e41e7393768bfa0cc1398e45646) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167417))
- [Skip CS components when parsing licenses from SBOM](https://gitlab.com/gitlab-org/gitlab/-/commit/c83412701871e6371664924f45043a36ccc0de44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168828))
- [Update pipeline mini graph variables](https://gitlab.com/gitlab-org/gitlab/-/commit/86b966fbe70e0db3971c92f48c876dc82334190c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167359))
- [Enable FF enable_add_on_users_filtering by default](https://gitlab.com/gitlab-org/gitlab/-/commit/87a1593e1623b680ab3ce165ce810f03a1b335e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168692))
- [Improve status dropdown description](https://gitlab.com/gitlab-org/gitlab/-/commit/27dcde5ec2562568382a4d79ad5984596678acaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168025)) **GitLab Enterprise Edition**
- [Process security policies only when they are changed](https://gitlab.com/gitlab-org/gitlab/-/commit/9a72cd707663a145cde04202b8787bd64200c58b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167969)) **GitLab Enterprise Edition**
- [Settings block: Move collapsible button to left](https://gitlab.com/gitlab-org/gitlab/-/commit/b2ffdfc6c103a789597feb5087e8e2fa319d433d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168523))
- [Display an icon for closed merge requests on branches page](https://gitlab.com/gitlab-org/gitlab/-/commit/448bdc9bfd3d7aa6f050afa39221dfe2dc8ff284) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161879))
- [Security dashboard: Update heading to use shared component](https://gitlab.com/gitlab-org/gitlab/-/commit/ce4f0cbf6234c26400173c686830d49ab93ddc45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168644))
- [Display helper text for severity group](https://gitlab.com/gitlab-org/gitlab/-/commit/48254aa6831dcd76655071c6656b84303d2fbf75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168372)) **GitLab Enterprise Edition**
- [Initial commit for changing admin Duo Utilization routes](https://gitlab.com/gitlab-org/gitlab/-/commit/d2f5079a8484dad1f03426dbb1b330e6448e2a57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167989)) **GitLab Enterprise Edition**
- [Improve documentation `spp_repository_pipeline_access` settings](https://gitlab.com/gitlab-org/gitlab/-/commit/d51dd18a5b8915a392367c6b9e18e9934663deab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168560))
- [Synchronously add vulnerabilities_reads indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/6af2f6d09e4af4c82acfdf7722b093301cad011b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167603))
- [Remove `ai_merge_request_reader_for_chat` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f191302237f5914455e5c1a167d1f4e0f23e5c74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168684)) **GitLab Enterprise Edition**
- [Allow top level group owners to create Service Accounts in Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/commit/872e801070ac439bf7c037925cb909649d612589) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163726)) **GitLab Enterprise Edition**
- [Update GlPagination to use design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/2a47780fe6fa1a9bc47d297a77da0fc029fdb45c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163581))
- [Artifacts page: Update heading to use shared component](https://gitlab.com/gitlab-org/gitlab/-/commit/7bd20124894515ae1ce661b35b5523cc4acb23df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168643))
- [Handle permanently available deprovision parameters](https://gitlab.com/gitlab-org/gitlab/-/commit/d54104038cd259113ebc68fcf84f782535d27a73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168383)) **GitLab Enterprise Edition**
- [Include HTML layouts in project export and project transfer emails](https://gitlab.com/gitlab-org/gitlab/-/commit/88c7f65791135f283bbb99991730f815cb7f847a) by @jimender2 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165600))
- [Fix sbom scanner to work with reported licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/50a42eef656f32ae1a1848c52f6a8ada6d0e0224) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167185)) **GitLab Enterprise Edition**
- [Remove allow_cross_joins_across_databases](https://gitlab.com/gitlab-org/gitlab/-/commit/cdc23a26f715ab24136ebdbb36ed73b0449c4a8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168447)) **GitLab Enterprise Edition**
- [Fix Vue 3 failing test](https://gitlab.com/gitlab-org/gitlab/-/commit/3892ace1ee828c30937428f9e19ceba5adcfb994) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168280)) **GitLab Enterprise Edition**
- [Fix Vue 3 failing test](https://gitlab.com/gitlab-org/gitlab/-/commit/e0fc6599f55420889ed5ae877c47542ee390cd60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168267)) **GitLab Enterprise Edition**
- [Duo Utilization routes setup](https://gitlab.com/gitlab-org/gitlab/-/commit/d460e03b9f67873dd29b1f2d13c643befe1c7a7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167864)) **GitLab Enterprise Edition**
- [Link project_bot user deletion audit event to its resource if possible](https://gitlab.com/gitlab-org/gitlab/-/commit/cba1c715f3156b93470a15754051b9c91928939b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167021)) **GitLab Enterprise Edition**
- [Revise and update repository xray docs](https://gitlab.com/gitlab-org/gitlab/-/commit/180b6eaacaafb88632e1702dd900094272518617) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167752))
- [Remove the beta badge for Secret push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/b7f663d94c33930fbebab26e0140372b4b2880ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167273)) **GitLab Enterprise Edition**
- [Update push check and scanning gem to handle exclusions](https://gitlab.com/gitlab-org/gitlab/-/commit/a190168cfec90fb2ee19ba5e0efc641b196c8228) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511)) **GitLab Enterprise Edition**
- [Update extension for docs links in misc ruby files 2](https://gitlab.com/gitlab-org/gitlab/-/commit/74bc0a4fa97dc6f3b37f6817a2ed712f73d434b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168477)) **GitLab Enterprise Edition**
- [Add regex support for runner tag search](https://gitlab.com/gitlab-org/gitlab/-/commit/df12ac2b67a7fc055ca1add3421cd7680c3d8b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166508))
- [Hide bulk selection column when user doesn't allowed to delete artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/f3b4af9d910531625352bd0f4d2cb4c874399351) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168487))
- [CI/CD Admin: Use shared components](https://gitlab.com/gitlab-org/gitlab/-/commit/57dd64d19de2bae3f9100a2d80ac4c319e232d4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168041))
- [Changing RCA prompt to new prompt](https://gitlab.com/gitlab-org/gitlab/-/commit/59bfd130faafb622d0eb35521435b6fea8f8a024) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168450)) **GitLab Enterprise Edition**
- [Send trial_type param during trial generation](https://gitlab.com/gitlab-org/gitlab/-/commit/bc0f2291b5720027fc30c5d9266a768852712913) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168265)) **GitLab Enterprise Edition**
- [Add API support for webhook feature flag events](https://gitlab.com/gitlab-org/gitlab/-/commit/904ad7a3732dc63b1a7861f8f649d298a0492470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168442))
- [Hide blob ci status](https://gitlab.com/gitlab-org/gitlab/-/commit/ea9135fd4b09b6171e407eb82f1510763ff37420) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167950))
- [Seperate gitlab_sec updates from gitlab_main transaction](https://gitlab.com/gitlab-org/gitlab/-/commit/debda5ddb1d60fa9121ef772a349d7d00c13811a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167048)) **GitLab Enterprise Edition**
- [Add conditional mapping for elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab8c2b4ac3bc413eda556d09ffb8765d122f456) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163946)) **GitLab Enterprise Edition**
- [Localize dates in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/9baa157ba628627efced9abb5725852b7bdf3cf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166627))
- [Convert ml_models.project_id constraint to cascade delete](https://gitlab.com/gitlab-org/gitlab/-/commit/7c5e0bc3ae8e95cdd09da9a6456fcccfb594e352) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168323))
- [Update extension for docs links in misc ruby files](https://gitlab.com/gitlab-org/gitlab/-/commit/003687ff433207cca737c0ef4351dd007eb94884) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168316)) **GitLab Enterprise Edition**
- [Update Harbor Registry illustrations](https://gitlab.com/gitlab-org/gitlab/-/commit/54542b4ef81a891f10ed218d17818b072dadceee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168073))
- [Update extension for docs links in models and presenters](https://gitlab.com/gitlab-org/gitlab/-/commit/72c9f70908284585fad40bbe3fe88a9e9c024d3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167865))
- [Switch to Duo Chat V2](https://gitlab.com/gitlab-org/gitlab/-/commit/b06a85a968065ff653871c4f515a2fa68038ca29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168326))
- [Remove security_policy_bot_shared_avatar feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e971103792d6bf4da641c3268ca36c89732fd00a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168315))
- [Update extension for docs links in ruby helpers](https://gitlab.com/gitlab-org/gitlab/-/commit/52c00c92b3a097fa5aad8ae4269683c2f725ca4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167566))
- [Add bold font for status filter](https://gitlab.com/gitlab-org/gitlab/-/commit/1d4e785949c26ba2575d34c3f8228261b3bd2cf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168130)) **GitLab Enterprise Edition**
- [Remove group_access_request_webhooks feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/275a70a15cf2caffa3f48ba2f42aad204afa0c92) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168279))
- [Clarify 'GitLab' term in signup error message](https://gitlab.com/gitlab-org/gitlab/-/commit/403dedde74ad70a1c066b37ae4a9e92a08bb8bcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166904))
- [Remove gl-new-card](https://gitlab.com/gitlab-org/gitlab/-/commit/269edb35089748995dbd1ece68cabd88a9e45007) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161737))
- [Update extension for docs links in /lib ruby files](https://gitlab.com/gitlab-org/gitlab/-/commit/8efd9495e5a82451a5283ce7826e987cc39ab8e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167863))
- [Fix `tag` icon display in the project ref selector dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/43fb0b6f31d465b965be6222e5657379bcaacb2f) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168109))
- [Use a default value for the parameter that will be parsed by JSON.parse](https://gitlab.com/gitlab-org/gitlab/-/commit/c825dcf0db78a4cba59a6eea7b7bed211de5c028) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168103))
- [Disable heap fragmentation memory watchdog check](https://gitlab.com/gitlab-org/gitlab/-/commit/9dbaa09087500675b4bef1a9a8b2e2b2d7194386) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168100))
- [Return all linked projects/namespaces when fetching policies](https://gitlab.com/gitlab-org/gitlab/-/commit/ac81f7df2422e207cd884f215fa87d1ffd70567d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166605)) **GitLab Enterprise Edition**
- [Fix Vue 3 failing test](https://gitlab.com/gitlab-org/gitlab/-/commit/b08d1b7e8f704719b1e8ffd00093ea6edb50effb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167899)) **GitLab Enterprise Edition**
- [Allow filtering users on backend in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/4fc46eb7f89d9be90fecab3d98d14e8d61008db5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168040))
- [Add probe for checks in air-gapped instances](https://gitlab.com/gitlab-org/gitlab/-/commit/f18719c8f2e122b5ebab01c9b4ff738867fc3603) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167016)) **GitLab Enterprise Edition**
- [Add markdown version to redis cache key](https://gitlab.com/gitlab-org/gitlab/-/commit/d905c0a2b7df63f368f754dded1f990eb84dbdab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165707))
- [Allow watermarks to move from high to low for zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/6bc1d0c61e8015e811d53219bcfc7a615190ee09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167996)) **GitLab Enterprise Edition**
- [Change duo trials duration logic](https://gitlab.com/gitlab-org/gitlab/-/commit/4809632e8982a345fea6cec38216ea314d92c90a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164572)) **GitLab Enterprise Edition**
- [This MR changes layout of filters](https://gitlab.com/gitlab-org/gitlab/-/commit/8909b8bed22f097ff8c90955bb9baf284a1d1b0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160934)) **GitLab Enterprise Edition**
- [Add watermark enum to zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/6499f9911c426a14e00846ce01aa450dfef7f9b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166360))
- [Rename config_version field in workspaces table](https://gitlab.com/gitlab-org/gitlab/-/commit/e08c61cffb5e76b5e492ecb9344e4520795651d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165876)) **GitLab Enterprise Edition**
- [Remove default for organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/d0be8f1f1d752c2af5f17099a181db78f6df5fbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166999)) **GitLab Enterprise Edition**
- [Fixes a bug with the duo free access ending banner](https://gitlab.com/gitlab-org/gitlab/-/commit/7369b3d9715152d1b7e92fbbd01cbcafe3162539) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167926)) **GitLab Enterprise Edition**
- [Add storage watermark to zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/70beddf59706332696c7607ccf2e6a6e5b0f5e98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166222)) **GitLab Enterprise Edition**
- [Add keyboard nav to boards](https://gitlab.com/gitlab-org/gitlab/-/commit/d348d55ab70daa6d59444f97560c09ddbdb98f48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165895)) **GitLab Enterprise Edition**
- [Migrate Admin group edit page to use SettingsSection component](https://gitlab.com/gitlab-org/gitlab/-/commit/b9554daeed9972b7ab5975b9b609d0bfea64f750) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167900))
- [Update kubernates empty states illustrations](https://gitlab.com/gitlab-org/gitlab/-/commit/3ecee77258383800b4e00f4c2ca8baf421f692ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167681))
- [Split AI impact dashboard table into multiple panels](https://gitlab.com/gitlab-org/gitlab/-/commit/51f4e411ee958aaf213ac0bdbf291d4d31d79cfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167057)) **GitLab Enterprise Edition**
- [Add handling big content for a drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/58c5f92fe719c9e780964d846975193a5e164f5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165395)) **GitLab Enterprise Edition**
- [Create work item: Add dividers to items in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/8c1a7a33d852bcaee7b8110f6afd48a5e33686bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167747))
- [Split the Value stream dashboard table into multiple panels](https://gitlab.com/gitlab-org/gitlab/-/commit/186eaf185b640b0f8935fd055af1329261fae290) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167217)) **GitLab Enterprise Edition**
- [Update extension for docs links in ci ruby files](https://gitlab.com/gitlab-org/gitlab/-/commit/917c67cbbe169bcb5bccf9bbf7606d7c26b48168) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167858))
- [Add scheduling worker to update storage used on zoekt index](https://gitlab.com/gitlab-org/gitlab/-/commit/a6b610aa5b09f68629ac6e76b5b7074360b96aa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166403)) **GitLab Enterprise Edition**
- [Add conditional mapping for elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/ea2f2f9266e9928043d8de5cf14dd0e70d9599e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163009)) **GitLab Enterprise Edition**
- [Add stat cards for filtering users](https://gitlab.com/gitlab-org/gitlab/-/commit/fbd2b2162b3615d3ba094cdcd6f4e4b883f24fbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165403))
- [Change the order of fork information](https://gitlab.com/gitlab-org/gitlab/-/commit/6086eac82f9c041c94e5c6ff6ecafbc22754421b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167769))
- [Add an option to track_event API to send events to Snowplow](https://gitlab.com/gitlab-org/gitlab/-/commit/7472945df02616271ff4d2f1baf1265c5c9193a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165748))
- [Discover Duo Pro: Migrate to regular card](https://gitlab.com/gitlab-org/gitlab/-/commit/92df5d1bc0d0e845e12e82ca76faab7cc73e5edb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167761)) **GitLab Enterprise Edition**
- [Update Members page](https://gitlab.com/gitlab-org/gitlab/-/commit/51a4a8d4291b3bd84ffcac06c33c61008049b87d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166384))
- [Use POST request to force unsubscribe by email clients](https://gitlab.com/gitlab-org/gitlab/-/commit/f5d93688699e4226413b8b4cc9c0dedf1c2f1008) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167196))
- [Update Locked Files page](https://gitlab.com/gitlab-org/gitlab/-/commit/043dd1e37ec6f4a91966a6548c2db0613f13834b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166529))
- [Drop randomization_seed from database load balancing log messages](https://gitlab.com/gitlab-org/gitlab/-/commit/ada9c6a52104b201302ca498db96b9f2a26ee6a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167710))
- [Remove load_balancing_disconnect_without_verify feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4faed9ecb481a7544645330a7cb50d5d7051d19f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167661))
- [Add new list between two lists on a board](https://gitlab.com/gitlab-org/gitlab/-/commit/0267db6915f3cbedbf8d227019d47f6cd529e8ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163390))
- [Make roles and permissions page visible to premium](https://gitlab.com/gitlab-org/gitlab/-/commit/c3b3600d80576cae291468bfef4748eecae8cde9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165968)) **GitLab Enterprise Edition**
- [Show specific OmniAuth buttons in signup page](https://gitlab.com/gitlab-org/gitlab/-/commit/7bcbb146b5132b2396f0ab08abc308e842d0832e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167467))
- [Consider multiple target branch pipelines for license policy](https://gitlab.com/gitlab-org/gitlab/-/commit/dd4f2d7bb1bfb064850176d2ba66790f8298c817) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165906)) **GitLab Enterprise Edition**
- [This MR adds extra check for policy scope](https://gitlab.com/gitlab-org/gitlab/-/commit/e643df59a9de62aa04d66d9d4d4f67e1bbfe472b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167601)) **GitLab Enterprise Edition**
- [Backfill PATs seven_days_notification_sent_at column](https://gitlab.com/gitlab-org/gitlab/-/commit/225aaaf4c7282caade83944b7e428a01aa1e4666) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165592))
- [Add integration test for group scope](https://gitlab.com/gitlab-org/gitlab/-/commit/5288f8483aacd247ce3d40bf7a2f0c58187ddc75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167334)) **GitLab Enterprise Edition**
- [Update Escalation Policies empty state illustration](https://gitlab.com/gitlab-org/gitlab/-/commit/754c830c2217b3d32176082d5d411d97830b3903) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167497))
- [Format code blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/1e48162be1b9b9f851c7668284ff3dbacc883c6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167469))
- [Scope ComponentsResolver to Group or Project](https://gitlab.com/gitlab-org/gitlab/-/commit/6e3c725d3b8136385a69952d58cbfddbd9c73b55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166493)) **GitLab Enterprise Edition**
- [Separate gitlab_main updates from gitlab_sec updates](https://gitlab.com/gitlab-org/gitlab/-/commit/e4bc163aaa5931476799ab148e8fab5bbafd54f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167046)) **GitLab Enterprise Edition**
- [Add errors to SecurityPolicyProjectCreated subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/b2181f0fd5b6ea1ae8412b785c3d175e4c428d9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167422)) **GitLab Enterprise Edition**
- [Simplify logic to exclude rules in Scan Execution Policies](https://gitlab.com/gitlab-org/gitlab/-/commit/61ef3cdb7475d4766f663a267c423eb3a508e7d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164804)) **GitLab Enterprise Edition**
- [Finalize UpdateWorkspacesConfigVersion3 migration](https://gitlab.com/gitlab-org/gitlab/-/commit/80ace9b0354b7e502e4726de50c14d0a60d587b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167094))
- [Make tag content more ergonomic on commit list pages](https://gitlab.com/gitlab-org/gitlab/-/commit/ff850af3063c9b8a44b9f1bc8b8b10df8b0a497a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167343))
- [This MR updates linked SPP query](https://gitlab.com/gitlab-org/gitlab/-/commit/d06a5a37c72d2d3343c5e2fcefc4b489f467daab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167314)) **GitLab Enterprise Edition**
- [Adds  to RedisStore sid](https://gitlab.com/gitlab-org/gitlab/-/commit/df89e2c30f6a5f8ca98251657219336134eed665) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167151))
- [Create loose fkeys dast_profiles_schedulus.profile_id](https://gitlab.com/gitlab-org/gitlab/-/commit/68c86edf2344a701f77164facda9425423a1de47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164716))
- [This MR fix remove button layout](https://gitlab.com/gitlab-org/gitlab/-/commit/68af0dc3446b70ad4446ae01eb9e0f2a41659fa3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166681)) **GitLab Enterprise Edition**
- [Raise error on lock retries exhaustion](https://gitlab.com/gitlab-org/gitlab/-/commit/13c6fcf1423f88f2f3670fd7e21aacf077ea7fd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167257))
- [Add watermark enum to zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/ceb0153a5aeb95f15e98313805ac64cf2b69ebe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167112))
- [Add Changelog trailer](https://gitlab.com/gitlab-org/gitlab/-/commit/5bc45a577a78a9e2347e12a9ebabe0b311948ba7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167002))
- [Add option to skip cache with zoekt scheduling service](https://gitlab.com/gitlab-org/gitlab/-/commit/4105b9ef0e96c9eebb29287c224badc0d5d8b264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167232)) **GitLab Enterprise Edition**
- [Align time tracking link size](https://gitlab.com/gitlab-org/gitlab/-/commit/1b6f32ed31ed38ae49b523fc97e9da6cf3a33791) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167187))
- [Show manifest media type for container registry image tag](https://gitlab.com/gitlab-org/gitlab/-/commit/e6a735df721157c0aff366cf708c9ac1855a0526) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166151))
- [Re-enable DocumentationLinks in haml-lint](https://gitlab.com/gitlab-org/gitlab/-/commit/ad7c4c12861ec99c716ad131227c74cb1b984501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166971))
- [Remove index from SBOM tables](https://gitlab.com/gitlab-org/gitlab/-/commit/8856885ffa6934c4db995845d4d540d80174f8e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166912))
- [Fix yaml support for monaco-editor with vite](https://gitlab.com/gitlab-org/gitlab/-/commit/f05bce4435fb73dc7756622836a2bbf2cd1b8d90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152660))
- [Model Registry present latest SemVer instead of ID](https://gitlab.com/gitlab-org/gitlab/-/commit/07a4734f1783fd3e87a96bc6ce94f65314e12a45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166713))
- [Use a `label` instead of `strong` tag in a CI job token allowlist form](https://gitlab.com/gitlab-org/gitlab/-/commit/cbe5dccd1e6f2f91de0cb44a393aa43fe451db94) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166953))
- [Small update to Linked widget help copy](https://gitlab.com/gitlab-org/gitlab/-/commit/1593dabc9bbda74e532419fca2c76d24cf5cc9d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166960))
- [Zoekt nodes skip tasks when over critical storage watermarks](https://gitlab.com/gitlab-org/gitlab/-/commit/9901138d9d30c1eeca5f0bad53387bf7fa9286d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166750)) **GitLab Enterprise Edition**
- [Update container registry tags list toggle details icon](https://gitlab.com/gitlab-org/gitlab/-/commit/d88b345ae65d60ef27fa929da445b88f12f6451f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166746))
- [Switch from Rails.application.secrets to Rails.application.credentials](https://gitlab.com/gitlab-org/gitlab/-/commit/8a88f8cdcd177fec0104940c84bf729d748283f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166431))
- [Ensure zoekt replica router returns distinct set of indices](https://gitlab.com/gitlab-org/gitlab/-/commit/030379350eabc7a2e0568e50d959a4d273c13bf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167064)) **GitLab Enterprise Edition**
- [Remove meta-programming from AutoMergeService](https://gitlab.com/gitlab-org/gitlab/-/commit/4061a20cf3d3a20474b6b639aa2d5414fba2fc1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166778))
- [This MR fix remove button layout](https://gitlab.com/gitlab-org/gitlab/-/commit/40a4150ae7e1b91ac6a9e190bede2c34018e9cbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167060)) **GitLab Enterprise Edition**
- [Send add-on metrics during seat link sync](https://gitlab.com/gitlab-org/gitlab/-/commit/3858ff75159be51769869b0f220d7987a8fd7234) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166182)) **GitLab Enterprise Edition**
- [Set default true for pipeline mainteennce feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f26851fd02b24fe5405c78f206cb4fb3eeebd35c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165760)) **GitLab Enterprise Edition**
- [Add link to error code to Duo Chat response](https://gitlab.com/gitlab-org/gitlab/-/commit/978738f9249d67d9e605e7f5b52923d6037cdc96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166369)) **GitLab Enterprise Edition**
- [Avatar: Refactor img to use GlAvatar](https://gitlab.com/gitlab-org/gitlab/-/commit/f49ea7918cc90e4a0ad0e4cd8d58d66676245ea2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166472))
- [Localize dates in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/ad18c79d5f7f1005602fbe21af3c96a77bd081e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166521))
- [Remove legacy event tracking from Value Streams Dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/886d1edf74176d4d27f338e7edb64df10d47289d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166366)) **GitLab Enterprise Edition**
- [Add pages_domains not null constraint for project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2c82883aeeeb2679d4c52eaccff2b342e3390ef2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166705))
- [Update pipeline migration UI text](https://gitlab.com/gitlab-org/gitlab/-/commit/6e29c0882f0b75c033bc8a6696241707cbd6bdd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166822)) **GitLab Enterprise Edition**
- [Allow to select multiple groups with the same name in MR approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/d50b4bc2ea10fab58d22aa322f3d67382b881639) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166818))
- [Use `GlTable` for the deployment approval settings in the add rule modal](https://gitlab.com/gitlab-org/gitlab/-/commit/b7afb50c652c9647108d88b9e6ed5550d9897ae4) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166495)) **GitLab Enterprise Edition**
- [This MR adds warning for invalid policies](https://gitlab.com/gitlab-org/gitlab/-/commit/fd7530d6921c805cd281e5a32c635a8dee4bc2ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164809)) **GitLab Enterprise Edition**
- [Update approval_policy_rule_id fk to nullify on delete](https://gitlab.com/gitlab-org/gitlab/-/commit/5a561fde9f5d00330a898c270beb73eacffe246f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166482)) **GitLab Enterprise Edition**
- [Remove cache when zoekt replica search FF is changed](https://gitlab.com/gitlab-org/gitlab/-/commit/850cde732dee180e89e801670ba19e8770b0150a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166752))
- [Clean up `scan_execution_policy_cache_ci_templates` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/00745d754d82ed114e9a3f67a7d6c885bd965366) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166594)) **GitLab Enterprise Edition**
- [Update Puma to 6.4.3 and patch PID reaper](https://gitlab.com/gitlab-org/gitlab/-/commit/53dfdcd47cc0da402c188b8b069619a16d300598) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166758))
- [Domain verification: Migrate to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/ba5b53531135f866033e55b5a77b91c7528482d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166144))
- [Let embedded videos be full width with max-width 100%](https://gitlab.com/gitlab-org/gitlab/-/commit/f482759df97eccbf2d443bd449fd262096905aff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166016))
- [Remove default project_id from p_ci_finished_build_ch_sync_event](https://gitlab.com/gitlab-org/gitlab/-/commit/39605fb3f6540aec8901016097fbfd595df75d66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166736)) **GitLab Enterprise Edition**
- [Update UI docs links in app/view/groups files](https://gitlab.com/gitlab-org/gitlab/-/commit/6c31e61b75adc71fbaec294f00b4e6c05be3e7ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166022))
- [Update UI docs links in assorted files](https://gitlab.com/gitlab-org/gitlab/-/commit/20ab7bb7049df44f3e5a76214cb088b8d40b423c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166024))
- [Update UI docs links in app/views/shared files](https://gitlab.com/gitlab-org/gitlab/-/commit/9923e0eeced8927d106a63dfd3a648ae29817ab1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166023))
- [Update UI docs links in app/view/projects files](https://gitlab.com/gitlab-org/gitlab/-/commit/bf326e77acd1a4d031100b43d2005e0214585c24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165885))
- [Add comparison pipelines in bot comments for error cases](https://gitlab.com/gitlab-org/gitlab/-/commit/62d54c02191d13580b5a5f33465187bab55a4899) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162863)) **GitLab Enterprise Edition**
- [Fix Vue 3 failing test](https://gitlab.com/gitlab-org/gitlab/-/commit/87380270de28dd255e445abb465c4ec99d899b58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166714)) **GitLab Enterprise Edition**
- [Made Environments > Deployment details page mobile friendly](https://gitlab.com/gitlab-org/gitlab/-/commit/72c2608b8bfe2add80bc179c0a41da1871ff5e1b) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166261)) **GitLab Enterprise Edition**
- [Show group path in group selection dropdown in purchase flow](https://gitlab.com/gitlab-org/gitlab/-/commit/bd9bb78a8350e3a6827235544222760953a1d0f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166407)) **GitLab Enterprise Edition**
- [Renamed run pipeline button](https://gitlab.com/gitlab-org/gitlab/-/commit/8669e6924ab261f771f0185b31364e3de566eb39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166442))
- [ACTUALLY set the schema to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/02b025571341b90fb51757da6f38c545e9dfb521) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164518)) **GitLab Enterprise Edition**
- [Update pipeline migration text and link](https://gitlab.com/gitlab-org/gitlab/-/commit/7b12f82bc8c204a8ff9330f07326c3415301d9e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166541)) **GitLab Enterprise Edition**
- [Add an OPS FF to avoid flooding sentry with semver dialect errors](https://gitlab.com/gitlab-org/gitlab/-/commit/ff1757dee727548947a68d4de401e4326716748c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165184)) **GitLab Enterprise Edition**
- [There were several problems here:](https://gitlab.com/gitlab-org/gitlab/-/commit/ff81c8a28e30e309e71ec0a8e45ca5cc93d8154e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166644)) **GitLab Enterprise Edition**
- [There were several problems here:](https://gitlab.com/gitlab-org/gitlab/-/commit/00e47f0a14227615f78cd7b9152c9a0c82bef727) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166643)) **GitLab Enterprise Edition**
- [Remove beta mention in metadata database alert on registry pages](https://gitlab.com/gitlab-org/gitlab/-/commit/10a90861c59c883ec2b505086d3928553789d67f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166393))
- [Fix zoekt replica group search](https://gitlab.com/gitlab-org/gitlab/-/commit/544f74fce1797499f9e2016e26e6323cd4c1c12b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165862)) **GitLab Enterprise Edition**
- [Clean up `ci_conditionals_reduce_gitaly_calls` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/90677dc202e82110363279245b257e600601887c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166590))
- [Commits: Migrate non-compliant Avatar sizes](https://gitlab.com/gitlab-org/gitlab/-/commit/339af3ff495dae0f1f5f903f0c302087ac9c7bcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166587))
- [Show an empty state when Protected Environment has no approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/c53b3cbaa4458cbce51e6a31dde8444c9a86adc0) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166309)) **GitLab Enterprise Edition**
- [Update UI docs links in application_settings files](https://gitlab.com/gitlab-org/gitlab/-/commit/283a7bf85cb72c108fbff4b1aad1604687e42491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164986))
- [Update ffi gem to v1.17.0](https://gitlab.com/gitlab-org/gitlab/-/commit/9165bb9ebef94c1ec7f74b8ad91b64f49bd262a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166535))
- [Split remediations query from upload deletion for decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/f687d630e8e76298284b51622eed4961e594bc9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166519)) **GitLab Enterprise Edition**
- [Do not destroy empty ML model packages](https://gitlab.com/gitlab-org/gitlab/-/commit/58a7655ed8c6a8d30d1b8e017aafc662b9ec031b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166186))
- [Finalize migration NullifyOrganizationIdForSnippets](https://gitlab.com/gitlab-org/gitlab/-/commit/5e38f8fb4af576bcdeb70e9c775cd72807f49a65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165353))
- [Add used_storage_bytes column to zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/d0166780291bcd390f62e4950fc6fc45faa2ef6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166398))
- [Modify the way dividers are generated](https://gitlab.com/gitlab-org/gitlab/-/commit/d9402cf62660462732091f99fd5ce3e312fd2633) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166351))
- [Remove cross DB transaction against dast_site_profile](https://gitlab.com/gitlab-org/gitlab/-/commit/56f54a9b8791b717b547284dace34eb5e38509ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166147)) **GitLab Enterprise Edition**
- [Remove feature flag zoekt_create_indexing_tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/82b302a23dbe07726090fbafb79f5ddc3adf603b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165978)) **GitLab Enterprise Edition**
- [Watch for k8s events changes](https://gitlab.com/gitlab-org/gitlab/-/commit/bf3c4eddc1a9663f0d5df51f48c0cb70a47b5cde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165633))
- [Cleanup 'locked_paths_mergeability_check' FF](https://gitlab.com/gitlab-org/gitlab/-/commit/c7de1897616a9328b10561b41f370852e84c965c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166269))
- [Enable summarize_notes_with_duo by default](https://gitlab.com/gitlab-org/gitlab/-/commit/e10a45d4580f2f3c62a9a19194076ba502d750dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165951))
- [Improve messaging for pending approval invited members](https://gitlab.com/gitlab-org/gitlab/-/commit/08f2b377991dc9d3eed049f0e854e7575f05843e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164733)) **GitLab Enterprise Edition**
- [Add loader for pipeline actions](https://gitlab.com/gitlab-org/gitlab/-/commit/6f2cca99dd7013e71b6c44ff8a9ca9a289a5ac0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165982))
- [Hide failed jobs widget logic](https://gitlab.com/gitlab-org/gitlab/-/commit/de8ef80b303e50f5df002b4d6d1084c09e171fb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165704))
- [Tranition vulnerability_state_transitions to gitlab_sec schema](https://gitlab.com/gitlab-org/gitlab/-/commit/059fae9e1955a2cf3cb848a558b0a4ee80d3b639) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165308)) **GitLab Enterprise Edition**
- [Localize dates within issues](https://gitlab.com/gitlab-org/gitlab/-/commit/14629109f134cefe771fd9bae4906ce760ae6632) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162278))
- [Make pages_domains.project_id not nullable](https://gitlab.com/gitlab-org/gitlab/-/commit/cc08641a24c5526020c9d2a5a1dbe36e68fbed4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166123))
- [Permanently delete project: Remove gl-new-card classes](https://gitlab.com/gitlab-org/gitlab/-/commit/b991c6b5f2e438abc92ce011447e80c19625c101) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166142)) **GitLab Enterprise Edition**
- [Add popover for image and tag on vuln report page](https://gitlab.com/gitlab-org/gitlab/-/commit/c7d3bcdc07fa42329fbdd9b2345f15ee18a6cceb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165607))
- [Remove allow_cross_joins_across_databases](https://gitlab.com/gitlab-org/gitlab/-/commit/e9a32751e0ced515f04e20400d47bc61dfeff445) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165941)) **GitLab Enterprise Edition**
- [Only notify user who started BulkImport](https://gitlab.com/gitlab-org/gitlab/-/commit/ce513bfbb65b39c11f9fcf072c7d4d27af02d2df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165939))
- [Update dependency ai-gateway to v1.18.0](https://gitlab.com/gitlab-org/gitlab/-/commit/a2527cb16011d0e70d90495346a04c97e702bfa9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162943))
- [Change the UX of the create model button for Model registry](https://gitlab.com/gitlab-org/gitlab/-/commit/50af6c16518313ed841f9ee757bca778a1b1a9e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163594))

### Deprecated (6 changes)

- [Deprecate Legacy Epics on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/62581f85f497665bd2812028816001f2b6612974) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168182)) **GitLab Enterprise Edition**
- [Adds ContainerTagsExpirationPolicy graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/8520ad0e58baa89764afa4792fed33f581fa6112) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167126))
- [GraphQL: Deprecate CiRunnerUsageByProject.ciUsedMinutes](https://gitlab.com/gitlab-org/gitlab/-/commit/5478d93acfd7b0b187db3315c0bbe8b385a36fe3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168199))
- [GraphQL: Deprecate CiRunnerUsage.ciUsedMinutes in favor of ciDuration](https://gitlab.com/gitlab-org/gitlab/-/commit/42f76ca8db5e8fbc76907cdbcce3617b4ea6c1a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167928))
- [Initial checkin for Issue 479384](https://gitlab.com/gitlab-org/gitlab/-/commit/f647b4769fb8b4e91ff9b5e163339bc506b1c423) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162914)) **GitLab Enterprise Edition**
- [Deprecate namespaces addOnPurchase GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/03437346baf040373fc8a333501031731b1cbc21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166198)) **GitLab Enterprise Edition**

### Removed (40 changes)

- [Removed include_manual_to_pipeline_completion flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2bc56b5dc023c62b6bf758bf05387c5929c6c247) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166156))
- [Clean up account_validation_email feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b4a808a404518f5e1c242ba985c0733d1dce62ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167147)) **GitLab Enterprise Edition**
- [Remove identifier_external_ids column from vulnerability_reads](https://gitlab.com/gitlab-org/gitlab/-/commit/28f9ad96f1d9fd87fe2d87f4ec4ae8afb5adf87e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164883))
- [Remove cross join allowances from vuln ingestion process](https://gitlab.com/gitlab-org/gitlab/-/commit/1ed5fc3fc6cfbb00c803bf0b8acfb90e0f5aa3b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166720)) **GitLab Enterprise Edition**
- [Model Registry removed Candidates tab](https://gitlab.com/gitlab-org/gitlab/-/commit/3c3250c058867d9cf16c29e7daaa2bd04a369490) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168510))
- [Remove flash background colors](https://gitlab.com/gitlab-org/gitlab/-/commit/942b2908713051f019567b8100e7fc5bbe06e6f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165186))
- [Drop zoekt_shards table](https://gitlab.com/gitlab-org/gitlab/-/commit/5e109d41d6781348510073631bcf2bcbc8cb6511) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167720))
- [Remove finalized BBM that contains cross join sec decomp can't support](https://gitlab.com/gitlab-org/gitlab/-/commit/9d7077407728cff8d4c79c4f5b3fa8f8f097443d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167789)) **GitLab Enterprise Edition**
- [Delete migration BackfillSbomOccurrencesTraversalIdsAndArchived](https://gitlab.com/gitlab-org/gitlab/-/commit/c6b51ca94bb64a13dec8cce3a8e221fbf32fb072) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167597))
- [Remove Issue Analytics broken search filters](https://gitlab.com/gitlab-org/gitlab/-/commit/d7ee235aee8cb3d957c46b7c57cda0c887734847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168246))
- [Remove BBM that cannot function post Sec Decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/ef009c0b064aab3c4869d1bd7388108c50ca0f76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167794))
- [Remove sec-decomposition related cross join supression](https://gitlab.com/gitlab-org/gitlab/-/commit/18df0f268088c65d45d743555a99036e10fdab77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168053)) **GitLab Enterprise Edition**
- [Remove sec-decomposition related cross join suppresion](https://gitlab.com/gitlab-org/gitlab/-/commit/acc0184d9ba7781e7a84004b5506fce02d8fb0cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168051)) **GitLab Enterprise Edition**
- [Delete unused BBM code](https://gitlab.com/gitlab-org/gitlab/-/commit/28234fa491169243f15804434ebc536fe8336bf3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167049)) **GitLab Enterprise Edition**
- [Elasticsearch: Reindex to remove title completion](https://gitlab.com/gitlab-org/gitlab/-/commit/c3a23a84594e7028b2e6b57dcb85d136546d02f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167887)) **GitLab Enterprise Edition**
- [Remove no longer needed cross join suppressions](https://gitlab.com/gitlab-org/gitlab/-/commit/453f74f78f897d9777655bf2ac9456e087be4a20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167787))
- [Remove unneeded transitional cross join suppresion](https://gitlab.com/gitlab-org/gitlab/-/commit/f96eb60ccd6b42cb072b4f08bce4cbb9f7f8b195) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167682)) **GitLab Enterprise Edition**
- [Remove unneeded cross db interaction suppressions](https://gitlab.com/gitlab-org/gitlab/-/commit/f208794ce0f0007e1aa0e545fec65076ec444ed9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167679)) **GitLab Enterprise Edition**
- [Remove unneeded cross join suppresion](https://gitlab.com/gitlab-org/gitlab/-/commit/7770d64bf9d246969bd6ed994371ba787e6607d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167676)) **GitLab Enterprise Edition**
- [Drop token_with_ivs table](https://gitlab.com/gitlab-org/gitlab/-/commit/6ba14590090f9021198593602565d751b734069b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157650))
- [Clean up migrated prompts for self-hosted code suggestions](https://gitlab.com/gitlab-org/gitlab/-/commit/8b54635235c0c3ae1537e3dc81e284671c05c9ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167426)) **GitLab Enterprise Edition**
- [Remove cross DB access suppression from remediation creation](https://gitlab.com/gitlab-org/gitlab/-/commit/711062fd0f34349ac5731265cf2149f276df258e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167327)) **GitLab Enterprise Edition**
- [Remove transitional cross DB warning suppresion](https://gitlab.com/gitlab-org/gitlab/-/commit/ca06f505d35a539de02763610764269bd122de8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167347)) **GitLab Enterprise Edition**
- [Place Product Analytics admin settings behind flag](https://gitlab.com/gitlab-org/gitlab/-/commit/716cfa9888166b030bd2034ccbb55b1dc1c1f8b1) by @max.woolf ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167192)) **GitLab Enterprise Edition**
- [Remove faulty async index definitions](https://gitlab.com/gitlab-org/gitlab/-/commit/e74a9c0b5da03c780a780f366a45355a9f75a099) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167102))
- [Remove possibly unnecessary cross join suppresion for vuln helper](https://gitlab.com/gitlab-org/gitlab/-/commit/fc24597f8d932405cdd1e6143bab27f1cf00120d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167054)) **GitLab Enterprise Edition**
- [Remove unneeded cross DB suppression](https://gitlab.com/gitlab-org/gitlab/-/commit/625f465c9b67a2a90547ed6c3f51df70b5a375d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167044)) **GitLab Enterprise Edition**
- [Remove unneeded cross join allowances](https://gitlab.com/gitlab-org/gitlab/-/commit/d4713a3d7f75a668da0821cba134d3138921c931) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166710)) **GitLab Enterprise Edition**
- [Delete the `emoji_webhooks` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f5c2a454198c5ed68fdbecc6c0c2b43d266356e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161133))
- [Remove ci_platform_metrics and related Sidekiq code](https://gitlab.com/gitlab-org/gitlab/-/commit/e5753a8b72bff30ed22c04da1390d8c0a4be757f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165460))
- [Remove early access checkbox](https://gitlab.com/gitlab-org/gitlab/-/commit/4747e4289d13d2b201ccd58a917a383114339eb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166776)) **GitLab Enterprise Edition**
- [Remove transitional cross join allowances](https://gitlab.com/gitlab-org/gitlab/-/commit/37816be66872d15247122cdfa946c2a16b394096) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166723)) **GitLab Enterprise Edition**
- [Remove pipeline reference from state transition](https://gitlab.com/gitlab-org/gitlab/-/commit/44b7985dca17966fa9449ec31d3dda034720c5fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164207))
- [Remove unneeded cross join allowance for sec decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/9b782ac7b949aeedb73f2e32830de4681536f547) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166513)) **GitLab Enterprise Edition**
- [Remove DAG code](https://gitlab.com/gitlab-org/gitlab/-/commit/9f011c483e79a2b45220d9bdfb20969f796b1f22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166367))
- [Remove unneeded transitional cross join suppresions](https://gitlab.com/gitlab-org/gitlab/-/commit/315a0bc810df5cbea1d930bf6e4118e457bd89da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166345)) **GitLab Enterprise Edition**
- [Drop namespace setting column toggle_security_policy_custom_ci](https://gitlab.com/gitlab-org/gitlab/-/commit/47bfeb893a9c47c5adf4bbab329f58f40f8f248f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162712))
- [Remove ensure prepared worker](https://gitlab.com/gitlab-org/gitlab/-/commit/3fdbfd37d8381c1bf1fa502dba4986c86052b1b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166035))
- [Remove validate_target_sha_in_user_commit_files feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dc4605da7432c2e61d29f44267ab665cbf6f6a4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165695))
- [Remove ignore_columns for Packages::BuildInfo](https://gitlab.com/gitlab-org/gitlab/-/commit/004e48e40d75e879f2968764ab28e14f36ae1ee1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165616))

### Security (13 changes)

- [Prevent guest access to project templates](https://gitlab.com/gitlab-org/gitlab/-/commit/30cdc6ad27b6fabcedcd381eedddc306db911546)
- [Skip content when listing conflict files with types](https://gitlab.com/gitlab-org/gitlab/-/commit/00b8a6c8f52722b58d6e2f134579a2bd3aeb62a0)
- [Do not create a pipeline on MR refresh if source branch was deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/480d0bd7ccdca6f93ff715abcd6c2fa7a9bebec2)
- [Escape OAuth application name on authorize page](https://gitlab.com/gitlab-org/gitlab/-/commit/18520b5abefbf3d63b39ca786274cdd388c73e97)
- [Remove access to local requests via cube query service](https://gitlab.com/gitlab-org/gitlab/-/commit/ac39cbe4c47622259b06b92f4557d697fd2a8831)
- [Prevent deploy keys from pushing code to an archived project](https://gitlab.com/gitlab-org/gitlab/-/commit/7950fe587ec01257909ee1c6f4035e4477b97c6a)
- [Hide version info from unauthorized users](https://gitlab.com/gitlab-org/gitlab/-/commit/7cc59acbd64189bc4cd6f6a3a3c829a51ac855ed)
- [Return for admin condition if user authentication with job token](https://gitlab.com/gitlab-org/gitlab/-/commit/f5e8c0286f0245eb5704c036ecabeddfc8c7d757) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167449))
- [External webhook token should be set](https://gitlab.com/gitlab-org/gitlab/-/commit/0dbce3f1a8d18540e9914abfba7d73e8eadf9a80)
- [Updates Summarize Comments LLM Prompt](https://gitlab.com/gitlab-org/gitlab/-/commit/e0ed4fc43edb5da97568a7148f0e0f40f4b41221)
- [Hide system notes with invalid references](https://gitlab.com/gitlab-org/gitlab/-/commit/975ac7740d0b5dc7026020872e73fb1b543f5aed)
- [Reset dependency proxy maven credentials when registry url is changed](https://gitlab.com/gitlab-org/gitlab/-/commit/2e3b0d702470cb6080a8cd329d9f97f27205e3e8)
- [Implement input sanitization for SummarizeComments](https://gitlab.com/gitlab-org/gitlab/-/commit/a0ff56cc58330b1b3e6ad133de203f0655a6e227)

### Performance (11 changes)

- [Update import_data sharding](https://gitlab.com/gitlab-org/gitlab/-/commit/9754abd2b504bbc2387a0c9ed822583c6919a8aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168391))
- [Stop creating keep-arounds on merge base commits](https://gitlab.com/gitlab-org/gitlab/-/commit/396e4a2575a30cdcff985464739a7fc2bded1fa9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168604))
- [Remove cancel_redundant_pipelines_without_hierarchy_cte feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1de53bdea42174e149503833f02300233590ed75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164436))
- [Use sticky data consistency for post receive worker](https://gitlab.com/gitlab-org/gitlab/-/commit/2a98ad6964b326751665c53486218ba65234de0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168514))
- [Enable CI variables optimization for pipeline creation](https://gitlab.com/gitlab-org/gitlab/-/commit/054e53fcc54a93309111e62e9cd6835ea1ab3cc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168061))
- [Add concurrency_limit to ProcessScanResultPolicyWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/ef7ae09cb04607836017b4b0e852ad57053ca470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168086)) **GitLab Enterprise Edition**
- [Move a field check into the query instead of the loop body](https://gitlab.com/gitlab-org/gitlab/-/commit/0187b2d63352b90b27c03d4fc744c7c2c2c0472a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168004))
- [Add deduplication to SynScanPoliciesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/6b5d93995ab52a3906e0b443970c1ee179eab85b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167965)) **GitLab Enterprise Edition**
- [Limit count query in the events APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/e96c39be7fa190d9376a253414586aa93f3db9c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166695))
- [Remove increase_diff_file_performance feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/09413b63c2005afbfe79a2f39ed16aeb2570d3f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166036))
- [Cache Fog::Storage object for CI build chunks](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a21f54f1754a59cce02221f030468ed72f5029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165900))

### Other (146 changes)

- [Add and backfill project_id for dast_site_profiles_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/15eb6afe1f8b680930c83b294f40f2518053adbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167768))
- [Add and backfill project_id for dast_profiles_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/1d9212f7a51b38f9577c6e6211d2edeb1ff58ef9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167633))
- [Clean up send_verification_code_to_secondary_email feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/679969d736b689c018e77ca69041985e0b2436bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166869))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/cfde235e8948ace348a879939c6b884e5852363c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168910))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/057db5079901ad14e514dfcab84d002a44ee5e32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169030))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/634a9262451c2d40c5c60f0a968291d96470b5fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168907))
- [Finalize migration BackfillBoardsEpicListsGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/2a11dd992de0d0c047e1c0b6ce5d8822eca910c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168458))
- [Add expiration wording to duo pro and enterprise trial success](https://gitlab.com/gitlab-org/gitlab/-/commit/1be9b534ac4a56593a0ee24428038ba2968a5a4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168845)) **GitLab Enterprise Edition**
- [Remove in-app trials redirect to stored user location](https://gitlab.com/gitlab-org/gitlab/-/commit/23c5a3c34cc39024faebcf8aa96ec9844fd645f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168838)) **GitLab Enterprise Edition**
- [Finalize BackfillComplianceFrameworkSecurityPoliciesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/892b0b3897fca1571c528ffcfa6a8503be6da82e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168886))
- [refactor: Protected badge as reusable component](https://gitlab.com/gitlab-org/gitlab/-/commit/a3cdc6743df8caed227967f47766bb3da7ca128c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161917))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/53fde6693289a3207f30b582c055bfba423f8b48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168906))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4a29325cb30dd5166240acd4222a8d2ea0cfc4c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168732))
- [Do not subscribe to Users::ActivityEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/f751f18e5c5b33e07f95bf64ee5cd17f62abe329) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168629))
- [Create partitions for p_ci_build_trace_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/84e95d14d400373ab3a4486d1f9e3c5335800ed9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168756))
- [Drop issues.correct_work_item_type_id foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/85bf51031d0cfff970ab91a2a3fbb3f9896a96b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168741))
- [Backfill migration for vulnerability_reads identifier_names](https://gitlab.com/gitlab-org/gitlab/-/commit/92fbabce742a5ac4e510d3ffea6720f5c927a62c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163088))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/859c508fad84e3c6347e01b6f68c3d1acd1b946c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167118))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a5f477e15b14e920854eea99123411d0dc8baa79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167265))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/804a24f9df49d1b70ef1f6d97ead2b9aed088d2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164818))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a37d795f42ed6fe65c5a3d0b8935c2ced473a6a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166852))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/33f75660b6bb1420304fcf61331997a85dd70337) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166853))
- [Add db_config_database into marginalia comments](https://gitlab.com/gitlab-org/gitlab/-/commit/f92e2fc4748478cdb3f96daebe96c8b497e6c80d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168272))
- [Avoid sidekiq warning for FlushCounterIncrementsWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/b27987142bc3a30e55bd38f986898467b931b03a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167145))
- [Finalize migration BackfillBoardsEpicBoardPositionsGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/af48342889a4ae0103ac8ac53d764b22daab07f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167979))
- [Track worker concurrency using Redis hash](https://gitlab.com/gitlab-org/gitlab/-/commit/1667b7e08898d79c5f9bd418005c693a5e5dd47d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167027))
- [Backfill issues.correct_work_item_type_id with correct value](https://gitlab.com/gitlab-org/gitlab/-/commit/44e195be1bb6d9f698ee6ea15b97c438530d604a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167972))
- [Remove upcoming_reconciliations from spec](https://gitlab.com/gitlab-org/gitlab/-/commit/13fbb3e7276780932c991337a63f2134d6cf0bca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168624))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c605c6a099f627f45c55a8396129b0a7f2e91608) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167391))
- [Add trigger to update issues.correct_work_item_type_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6670a9fc44c4056d418a10b8eadc9671b676e592) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167510))
- [Reduce wait time for replica if worker urgency is high](https://gitlab.com/gitlab-org/gitlab/-/commit/cc8dfe47eefd291a856baf1d698311b816c4c783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167877))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/2cb80a94a24c134ec14fcb63d3cfe509df523e86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168547))
- [Add and backfill project_id for packages_composer_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/df81b0d75bb6e9c2125c9da3cb9b0de8d0cc875a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167444))
- [Add and backfill project_id for dast_scanner_profiles_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/170a80a95b611c80d3a3828f7dcedf63bf91c55c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167626))
- [Use routing table name for PipelineConfig model](https://gitlab.com/gitlab-org/gitlab/-/commit/ce8aec8656f2d468239b75cd554e185be5566012) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168088))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/aa9549861cc91c94b853fe591aa13ea49869efb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167698))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6a1b1f38e67d0efe99f6cd9057d1977bdf683ced) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167117))
- [Move Cop/WithoutReactiveCache to gitlab-org/gitlab](https://gitlab.com/gitlab-org/gitlab/-/commit/e51616651746d28b82aba81a7945fed9dddb8754) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164279))
- [Set `vulnerability_count` of project_security_statistics records](https://gitlab.com/gitlab-org/gitlab/-/commit/377f3574934ed708c65ec72e87b3b31642390e72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167812))
- [Create partitions for p_ci_build_trace_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/054c6e8146ab1778bfd2e8799fc513ee78f3f20f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168365))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/849e2394cd1849bf5304abf9adae4ad57b880c1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167999))
- [Finalize migration BackfillAuditEventsStreamingHeadersGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/2f71141963797ae09778b02a1d6b4db0a0eaf607) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167692))
- [Correct tag name restrictions documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/45c865ef61734f4f0d2be9d963367ccb8d78d0ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168300))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/972671b289c4034aca05dda58ee27da1eebbde6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167115))
- [Finalize migration BackfillApprovalProjectRulesUsersProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d48e5535eed9e72243fe11037d3a6878d0e3229f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167506))
- [Protected containers: Align actor for feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ea3051b7c0eb6a64e1e60d6c70f994f42ae02f3a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164083))
- [Add and backfill project_id for ci_secure_file_states](https://gitlab.com/gitlab-org/gitlab/-/commit/4e2af1a4d13d179d06254bba32bca21a49b6b7c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167617))
- [Add and backfill project_id for packages_pypi_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/808c8b9f78685eab1729620d097b9aba788ae8ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167608))
- [Fix Style/SingleArgumentDig offences](https://gitlab.com/gitlab-org/gitlab/-/commit/d6ef31b38f9c175d27eb50c23d86d5a25c91572e) by @rutvikchandla3 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167424))
- [Add and backfill project_id for ci_pipeline_schedule_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/7f74125edf2b1295e7ada3c0c4e8452c281c0fd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168110))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/03732e45b4773774129fd56bb05f729162f0fc82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168223))
- [Add and backfill project_id for packages_rubygems_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/cea51c5cedefadef818490961e92264a4902d649) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167611))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f62ecb9bfa119a33a13f21b0afe88bb33e426037) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167116))
- [Add initial schema for custom field configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/920e98dc24efe75bd930fd4225a875630756fb34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167591))
- [Continue removal of Trial Abandonment worker](https://gitlab.com/gitlab-org/gitlab/-/commit/004b8282445dbab762834174bad3e49b0a3111bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167952)) **GitLab Enterprise Edition**
- [Cleanup of backend and E2E for `pipeline_security_dashboard_graphql`](https://gitlab.com/gitlab-org/gitlab/-/commit/b561c29fb389d16a3d7a727e925c20636ccc4297) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166732))
- [Solve null equality in BBM that deduplicates lfs_objects_projects](https://gitlab.com/gitlab-org/gitlab/-/commit/dc0065b4335415fe18766e9bd246ca91c2cc34db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167468))
- [Add and backfill project_id for pages_domain_acme_orders](https://gitlab.com/gitlab-org/gitlab/-/commit/9ca5697a1fa565356c3e9d472bd3555503ea74d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167614))
- [Remove .issuable-row background in milestone's page_bundles](https://gitlab.com/gitlab-org/gitlab/-/commit/475f644e9196484f655e1db3c7f3be26e639b336) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167934))
- [Add foreign key constraint to `projects.organization_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/a80b66b895271b06731e28b5a65a2a26c46309a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166980))
- [Add and backfill project_id for ci_resources](https://gitlab.com/gitlab-org/gitlab/-/commit/116d28970c5000188291278b3c900d9cb271d985) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167645))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ab5a0c4e6208cbdef96f7e488cfe51e99c372586) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167859))
- [Remove web_ide_oauth flag and its references](https://gitlab.com/gitlab-org/gitlab/-/commit/a709cce3ef830c1d4e7f4eb3d5ee79ae4fea3415) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167464))
- [Finalize migration BackfillApprovalsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/fb06aca117ab018a50c0f11eadeadb9b9221bf61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167507))
- [Finalize migration BackfillApprovalMergeRequestRuleSourcesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/592aea8c2c243ed088f37372c64ccfc13f20a36e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167251))
- [Change the duo pro discover page to match new wording and design](https://gitlab.com/gitlab-org/gitlab/-/commit/1915ffa36f96181f1a9ada32e00d2220697082a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167826)) **GitLab Enterprise Edition**
- [DB Docs are up to date](https://gitlab.com/gitlab-org/gitlab/-/commit/37df8b9a965150924632c640f50f188cde766f9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166584))
- [Add Duo Enterprise product interaction for seat assignment lead](https://gitlab.com/gitlab-org/gitlab/-/commit/52ec6b6af0a656b57bd157e2f0760ee7ae196c25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167685)) **GitLab Enterprise Edition**
- [Add and backfill project_id for packages_nuget_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/34849d27534b4d6655a71b8faac263e511e049bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167607))
- [Remove the nodes which are offline for more than 12 hours](https://gitlab.com/gitlab-org/gitlab/-/commit/5e89958a116d7dbda617d3c396c8bc6d0136194d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166481)) **GitLab Enterprise Edition**
- [Add and backfill project_id for ci_builds_runner_session](https://gitlab.com/gitlab-org/gitlab/-/commit/84e195a20dbba1cf2807369ab497ba46e0b0d947) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167634))
- [Add and backfill project_id for pages_deployment_states](https://gitlab.com/gitlab-org/gitlab/-/commit/7a1f0960202ff3fbc0ef71946e8e32b92b4127c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167613))
- [Add and backfill project_id for packages_rpm_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/7e0b3bfb3ea0033427f7f4a48fb445f070a9c73d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167609))
- [Add and backfill project_id for approval_project_rules_protected_branche](https://gitlab.com/gitlab-org/gitlab/-/commit/ec8450985d455ae76d850285b644a32f52d409eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167648))
- [Add and backfill project_id for packages_npm_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/36adef0b862c019a3c6d2b27c79f040c61969c86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167446))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/26f847dc3d8ad57900021ebbf841ab211dddad2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166798))
- [Remove pipeline_run_keyword feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f38c167adacf21af3ee72c240cd3d3bad6ff55f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167722))
- [Add and backfill project_id for incident_management_pending_alert_escala](https://gitlab.com/gitlab-org/gitlab/-/commit/2af4990b64de20b437266bd098d02a254b2fb8d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166816))
- [Introduce `project_security_statistics` table](https://gitlab.com/gitlab-org/gitlab/-/commit/5ee258fee64d791fe7d9182019037ab33facbf2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167442))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/23443ff5dd7e7f21394230cea3c3b2bc4a0cfe3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167267))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/713ced6b0c985e7d2bff1294ca6df0b41abd867c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167390))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2b107dd3f41780780bd5e685ba6c62f1ca731f4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167270))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7686ebb61f3d13c06e669668df543726bdefabe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167511))
- [Finalize migration BackfillApprovalGroupRulesUsersGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/e9d05ffe7e6092ccc12d77931e025bd045036e64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167250))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/518442bf0c1a29ee63d734c1be3ef6c430c41501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166976))
- [Use defined constants for selector types](https://gitlab.com/gitlab-org/gitlab/-/commit/22aa8612331e85d478b86202d9897afe029d286e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167419)) **GitLab Enterprise Edition**
- [Finalize migration BackfillApprovalMergeRequestRulesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d8d4c9b33e5e9a9ea7e39da271d0d9a8fdffcc2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167252))
- [Finalize migration BackfillApprovalGroupRulesProtectedBranchesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/c08c5deab001904ea17c5bb5a1fc84211e3333e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167249))
- [Finalize migration BackfillAgentActivityEventsAgentProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/93c554737050d14c06da3c190221b2016a091638) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167103))
- [Fix Performance/RegexpMatch offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/384835435286f39ebffb39d48928566a67c737dd) by @bolah2009 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166706)) **GitLab Enterprise Edition**
- [Fully deprecate legacy sidekiq workers for onboarding](https://gitlab.com/gitlab-org/gitlab/-/commit/454adab2d63dc10996e0ffe107dae94f2b8408e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167211))
- [Add metric to track when CVS cannot scan component](https://gitlab.com/gitlab-org/gitlab/-/commit/963b5d448b26f78fc773d5fef6d8dc9aac3f20df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166928)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c977d261ad66a5320e5ec256fd8b0a8219de733a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167114))
- [Add and backfill project_id for incident_management_timeline_event_tag_l](https://gitlab.com/gitlab-org/gitlab/-/commit/f28b7d013796687e4e63c75cac894c021e473339) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166461))
- [Add and backfill project_id for ci_unit_test_failures](https://gitlab.com/gitlab-org/gitlab/-/commit/f6fbec5901a010549aaeecedb4d5978627e70a93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166817))
- [Mark 20231016162120 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/dd761045c83b611cd315db200aa58a3e1d9cd879) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165989)) **GitLab Enterprise Edition**
- [Add issues.correct_work_item_type_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/b33fd7b2bc18a54b2987ad477e67e09e4d38738f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167092))
- [Add `work_item_types.correct_id` column](https://gitlab.com/gitlab-org/gitlab/-/commit/5a49ce40fe455dd462424d973891892ad690f687) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166548))
- [Mark 20231019223356 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/1ea982f3d0cd3de1ec2a76825f9f52c34db262f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165990)) **GitLab Enterprise Edition**
- [Fix packages_packages definition file](https://gitlab.com/gitlab-org/gitlab/-/commit/81e00e9e40b0c0dec8d28cc14061c7f36a6b9956) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167047))
- [Add emails notification for RewriteHistory worker](https://gitlab.com/gitlab-org/gitlab/-/commit/b5147c8f76d0244859b2b304c0573e5935b3358c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166173))
- [Add target_type to refine the query](https://gitlab.com/gitlab-org/gitlab/-/commit/dcac8b142a6cfe0e60a8788c6d64ce024a316cc0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166983))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/79c0ca788472db6c4c777e5323e97354ac17fef3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166811))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ec73bc7896035283180b900bcc8d5864d637b182) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166796))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8588173d926ffa971c6948d9cfb3a2e59a4840de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166975))
- [Drop database table compliance_checks](https://gitlab.com/gitlab-org/gitlab/-/commit/77108c49ccaea585099a157c91eb6da52a75984b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166353))
- [refactor: Fix rubocop offense Layout/space_inside_parens](https://gitlab.com/gitlab-org/gitlab/-/commit/9c5e82136d2fc86e27433602d6d9f6c883669bf8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166802))
- [Drop default for work_item_types.id](https://gitlab.com/gitlab-org/gitlab/-/commit/826ac6bd42d9526337cb054a510f713a8321cad6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166678))
- [Change FF type and default enable flag](https://gitlab.com/gitlab-org/gitlab/-/commit/560789f67e38ca643c39e79ab2bb0bc2521c2a45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166608)) **GitLab Enterprise Edition**
- [Redefine broken foreign keys on p_ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/eda06ec1bda8ed2642459268d9b2047054460ea7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166318))
- [Add accessibility tests to todos filtering dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/49cd60a4b8f86cfdbcd3a5c875d9d3f4bde082f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161036))
- [Add and backfill project_id for milestone_releases](https://gitlab.com/gitlab-org/gitlab/-/commit/5e330b243e58e8ba85feff4019bca60219a74314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166466))
- [Mark 20231005103449 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/12ec00d4319b25f0c6ef7c65edbad0fd453c5b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165988)) **GitLab Enterprise Edition**
- [Rubocop fix](https://gitlab.com/gitlab-org/gitlab/-/commit/b43b2944af17bd579b94aa9d901898ae0ac1c8eb) by @arno_gr ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166805))
- [Change default for org id](https://gitlab.com/gitlab-org/gitlab/-/commit/4377786c3a4a2f2833d18542b8ae9ebc9b7700ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166348)) **GitLab Enterprise Edition**
- [Fix the initial_indexing logic](https://gitlab.com/gitlab-org/gitlab/-/commit/f38dbcecec9122ab6a7bbf27b5869e9eed8aff3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165033)) **GitLab Enterprise Edition**
- [Mark 20231130202203 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/aa4cd9ff3e3954f76bc9e08ca5ea53c45db06e39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165993)) **GitLab Enterprise Edition**
- [Add and backfill project_id for incident_management_oncall_rotations](https://gitlab.com/gitlab-org/gitlab/-/commit/0b3bedadf5cad169294375e60940172f510570b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166153))
- [Add and backfill project_id for alert_management_alert_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/b99f532801dcd3710f11f32a3e0e6c520d02c16e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166145))
- [Remove `project_analytics_dashboard_dynamic_vsd` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bda375a1c0fdc7c320960d749137782b926a8fcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166581)) **GitLab Enterprise Edition**
- [Add and backfill project_id for incident_management_escalation_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/c6154d59871e4d47af68536201180b7044252d6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166149))
- [Remove unused code for build tags](https://gitlab.com/gitlab-org/gitlab/-/commit/2545fe78266478c20f46e66b3a0609d3f797f15a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166613))
- [Mark 20231004124852 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/c6f669877952cf206dad546d694c7a6167252a6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165987)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/30376537273cd0f20e6bdeaf163ffe6c5ed0ff0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166419))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/65a992c617316483e0b11173463eef97870f031b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166562))
- [Mark 20240107132344 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/32177974b4be1d4a0f50b5272fa01f75d0fca92a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165996)) **GitLab Enterprise Edition**
- [DB Docs are up to date](https://gitlab.com/gitlab-org/gitlab/-/commit/83d7e2d9c9fa6ef0e211a00d332da47746280177) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166060))
- [Audit list of classes in dashboard.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/a358925bdfc6e9d538e0d0dcb4966e65a1e56d87) by @NIKU-SINGH ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164651))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/cd4324c765db2fae7eabc61eb33d89efa7b6a90f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162350))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/74b8dc684db2ae608466c388d9a352fa6aaf7c5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162804))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4d572efcfee3b764ef9a7a31a6eebc2e5f7d6f64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163125))
- [Add and backfill project_id for alert_management_alert_metric_images](https://gitlab.com/gitlab-org/gitlab/-/commit/356f5e171895bcef512b1a7d30fba99feccb812d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166074))
- [Mark 20240104134928 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ab39e45fb175cd07484fcb3f2ba3a13179abc68f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165995)) **GitLab Enterprise Edition**
- [Partition ci_build_trace_metadata table - 4](https://gitlab.com/gitlab-org/gitlab/-/commit/93b9e2cadcc7a481036ef7a4779bb15926b1e6b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165316))
- [Add and backfill project_id for ci_job_artifact_states](https://gitlab.com/gitlab-org/gitlab/-/commit/bc4b7118b814becfd0eade0ec6a71a3f9bc450ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165940))
- [Remove obsolete Advanced search migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/b33dc6ee75b1f31f687215841e0dfd33c24066b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165977)) **GitLab Enterprise Edition**
- [Remove feature flag save_policy_violation_data](https://gitlab.com/gitlab-org/gitlab/-/commit/5413f08d1db4e241fdcd913ad1338d29ed969346) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166298)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c2bb4944d7d7b9be83d411047b56d1265556e43d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164150))
- [Mark 20231213172132 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/01c05bbcafa882f4b6a15703f0b528ff54c04232) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165994)) **GitLab Enterprise Edition**
- [Add index for component search on Occurrences table](https://gitlab.com/gitlab-org/gitlab/-/commit/0177ab0fd84ea4554f9afd846001ee49db2e3697) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166180))
- [Mark 20231130152447 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/916e8ec15f74a9382d9bb7baeecb5d80ec14f883) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165991)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/112f51fe5f5894fa791351072b5f9dca7e0f2cb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164578))
- [Remove & clean up set_sbom_report_ingestion_errors FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6f1123d14d1009ca6f17e80cccf556153c0fccf3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165865))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/81385243047622e00d54d83780190666dbf196ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155375))
- [Adjust signup page items for more clarity](https://gitlab.com/gitlab-org/gitlab/-/commit/e272c8a4c7b243758454d6f15363d0c13ca05c04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165202)) **GitLab Enterprise Edition**
- [Removes Unused CSS class](https://gitlab.com/gitlab-org/gitlab/-/commit/4e17154650ee4afc8b1ae4238d27efb908855a19) by @NIKU-SINGH ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164637))

## 17.4.4 (2024-11-12)

### Fixed (4 changes)

- [Fix bug where car left after branch deletion](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d88a8a2b0d5a864220e7ca612a73433fb61aa1e7) **GitLab Enterprise Edition**
- [Ensure auto_merge_enabled is set when validating merge trains](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ec63d25c51b5e129ab9b8fea6c8bb5730ca1ff81) **GitLab Enterprise Edition**
- [Update pdf worker file path in pdf viewer](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bd1436d5e7900ac7ca815302b5bbd8297e43c52d)
- [Security patch upgrade alert: Only expose to admins](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6e852f3bde76486452977159f9597b1947ee84b3)

### Security (6 changes)

- [Use custom adapter for parsing FogBugz XML](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d8cf278590e2f1b496fe7cec05bd58b8adf0703b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4593))
- [Removed id from authorize buttons and added specs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/577432b6e46b9cd6edd4e00a4667e249406f1026) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4574))
- [HTML injection in vulnerability Code flow leads to XSS on self hosted instances](https://gitlab.com/gitlab-org/security/gitlab/-/commit/24eaacb474ad08e0bcd41b6f5a1cdada51ca8d7f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4565))
- [Remove is-unsafe-link from product analytics tables to prevent XSS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6ed52422fcfb1b5ab6702a57df0d564bb552472b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4580))
- [Details of blocking merge request can be exposed via list](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4d5b45a67287865c3e9a80f27755c05c46ae2bea) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4526))
- [Prevent agent access via unconfirmed or disallowed group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e8fd87425e9c7d045986bc50b6f9e401eb695b95) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4560))

### Performance (1 change)

- [Remove permissions JSONB column from the condition](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2f2ae57d46d3774cd483adcb8651c7bc52b2e67c)

## 17.4.3 (2024-10-22)

### Fixed (1 change)

- [Fix Zoekt global code search](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3f7555bec895f46e787c4942ad4f6feb2aa40cd7) **GitLab Enterprise Edition**

### Changed (1 change)

- [Backport LabKit v1.21.2 update to fix broken dependency](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ac25dc56806e6426b24ed951feba202b1a694023)

### Security (2 changes)

- [Fixed HTML injection in Global Search bug](https://gitlab.com/gitlab-org/security/gitlab/-/commit/38e43a2bd1156111126995dee37d08cbeb607c55) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4504))
- [Limit max size of manifest file upload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d85364ec8c87ed3ca31b3d9575906267e9d23c4d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4532))

## 17.4.2 (2024-10-09)

### Fixed (1 change)

- [Drop project_id not null constraint ci_deleted_objects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e02a0c065456a51ad57a93d56150271cc4dd442e)

### Security (8 changes)

- [Do not create a pipeline on MR refresh if source branch was deleted](https://gitlab.com/gitlab-org/security/gitlab/-/commit/66c4e57a3494686a9dc6058d2348074b465f5dd3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4522))
- [Escape OAuth application name on authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/293bb1f70c681b75672e0b41af84ab5ae47d1e1e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4517))
- [Prevent guest access to project templates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/544398bdf7ea2b81100f8b95496f14d9b4698db8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4477))
- [Remove access to local requests via cube query service](https://gitlab.com/gitlab-org/security/gitlab/-/commit/86894edacdaf1cad4b0e85f71918109d48013ccb) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4492))
- [External webhook token should be set](https://gitlab.com/gitlab-org/security/gitlab/-/commit/70fb8bebe2e8f1b85d625a8e496515c3f7e0e6d8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4510))
- [Skip content when listing conflict files with types](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c19d8a96d103680ec874327c1631e179e17da06a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4513))
- [Hide version info from unauthorized users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0dd81e22f819f916c50cf531fa769000e9b5941b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4500))
- [Prevent deploy keys from pushing code to an archived project](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ed7a5173cae50f610d2c0263197f7996653cfc10) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4486))

## 17.4.1 (2024-09-24)

### Fixed (2 changes)

- [Fix incorrect gitlab-shell-check filename](https://gitlab.com/gitlab-org/security/gitlab/-/commit/27d061512878b35507d1228188f33774193c90d4)
- [Check commit message for issue close pattern setting](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6f475e9255dcb23478ae1401320d4bf74d2523b0)

### Security (3 changes)

- [Implement input sanitization for SummarizeComments](https://gitlab.com/gitlab-org/security/gitlab/-/commit/907bbbae5d84d2505bc9aeaaa2276a9d6662014b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4474))
- [Hide system notes with invalid references](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f349ddc9dcff2e5a7d9c496a86ce8a5b8f2192f3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4482))
- [Reset dependency proxy maven credentials when registry url is changed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7770dcc609ec9fe6f51ba36cbc085c1ab97a6560) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4472))

## 17.4.0 (2024-09-18)

### Added (202 changes)

- [Add and backfill project_id for p_ci_runner_machine_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/a59397016256da795da3fc297a9d4a8258d476b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164386))
- [Allow to configure K8s ns and flux resource path in API](https://gitlab.com/gitlab-org/gitlab/-/commit/a741d45320bdaf48388776df213692890129a25a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164886))
- [Create add-on purchases when applying an offline license](https://gitlab.com/gitlab-org/gitlab/-/commit/d34f5caa7c831ccea3b4111fc6f755e22b65bcb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164867)) **GitLab Enterprise Edition**
- [Add Expand and Collapse all files buttons to merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/2320dd7c826e238af26e0c2afe1efe76d86ea0ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165265))
- [Add group scope to policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/18429090a2bd2bae12f4368413485a4c883c3ef9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166015)) **GitLab Enterprise Edition**
- [Add full path to expiring group token](https://gitlab.com/gitlab-org/gitlab/-/commit/86d6290ea28a021a0313b66168593e98d4fe4978) by @shangsuru ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164304))
- [Add group policy scope for SPP](https://gitlab.com/gitlab-org/gitlab/-/commit/5c9eaf6c6b08b0a90d07276bb27cc721e213de97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165958)) **GitLab Enterprise Edition**
- [Add a batch migration to populate detumbled_email in emails table](https://gitlab.com/gitlab-org/gitlab/-/commit/755683e6340aa29fa01cda7f28a0f4e90c9dccdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162924))
- [Add AI vulnerability resolution badge](https://gitlab.com/gitlab-org/gitlab/-/commit/3014a7adc57952c463b246f978c7b139c03a0f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165525)) **GitLab Enterprise Edition**
- [Add GraphQL fragment and queries for project security exclusions](https://gitlab.com/gitlab-org/gitlab/-/commit/c96081dd2432d3b819004ed12f2d57f3a5d3d681) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165102)) **GitLab Enterprise Edition**
- [Multiple artifact uploads to model registry model versions](https://gitlab.com/gitlab-org/gitlab/-/commit/3340c50801045b541f029838eed87a98008c7ef8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165274))
- [Add ci_finished_pipelines_daily_mv ClickHouse materialized view](https://gitlab.com/gitlab-org/gitlab/-/commit/299b61af1cd7c4a9c44b458dfcf401c654ec1ca2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165648))
- [Bump devfile gem to 0.0.28.pre.alpha1](https://gitlab.com/gitlab-org/gitlab/-/commit/29e6be842c8208ae56b21b978a7f92878eff6cf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165888))
- [Create add-on purchases when applying an offline license](https://gitlab.com/gitlab-org/gitlab/-/commit/504369c1be4843a295e9a26719db6cb5162b6d74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161333)) **GitLab Enterprise Edition**
- [Add Reachbility Coulmn to sbom occurancy](https://gitlab.com/gitlab-org/gitlab/-/commit/cd7e63fba2eeb8e963a083521d70390b1c754294) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165421)) **GitLab Enterprise Edition**
- [Audit when job token is used for authentication](https://gitlab.com/gitlab-org/gitlab/-/commit/16345f8e7f8aabdbca54beb56a35bb06f81b3b9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164546)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/1549402eafb73b934ba08946d6db4d049e408f90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165820))
- [Adds audit events for self-hosted model creation](https://gitlab.com/gitlab-org/gitlab/-/commit/d75ccd5236428a5f3302c12d6901320710b210b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165303))
- [Bring back required instance ci template setting in database](https://gitlab.com/gitlab-org/gitlab/-/commit/2a9943600e5741454738fa8b417e4801cc8940fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165111)) **GitLab Enterprise Edition**
- [Refactor Issuable reply hotkey](https://gitlab.com/gitlab-org/gitlab/-/commit/c2cbf9ae103249529f0a1b766e2a3af846660a53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164078))
- [Make wiki sidebar resizable](https://gitlab.com/gitlab-org/gitlab/-/commit/cf6b77739b7253a13df9e81b436d8f01258531b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154167))
- [Implement post-migration workflow message](https://gitlab.com/gitlab-org/gitlab/-/commit/f5b545a83b473fe809dc4a2a29b66d8b9f2c8ce6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165478)) **GitLab Enterprise Edition**
- [Manage uploads API by secret and filename](https://gitlab.com/gitlab-org/gitlab/-/commit/ba9bbe247392ba4630423f6689c329eff45b9f05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164441))
- [Add new update_column_to action to Loose foreign keys](https://gitlab.com/gitlab-org/gitlab/-/commit/bfdfd14efd8aec7b52a6cc70d65699683970e48d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164508))
- [Add toggle for spp_repository_pipeline_access in project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/768ac9b81e26c32f2ac8a373f5ccb2cf6f3433a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165626)) **GitLab Enterprise Edition**
- [Retry - add personal_namespace_id column to events](https://gitlab.com/gitlab-org/gitlab/-/commit/17303baddd648fcbc9fd8200f14d76ca3ee2886b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165127))
- [Add new column to events for self-managed only](https://gitlab.com/gitlab-org/gitlab/-/commit/31e787d01d36a5ce1173cdfd7043c8e7271f3186) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165591))
- [Expose k8s ns and flux resource path in API](https://gitlab.com/gitlab-org/gitlab/-/commit/531411bbe560f5b3196c25f918e3d5667deec6e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164866))
- [Add basic graphql resources for project security exclusions](https://gitlab.com/gitlab-org/gitlab/-/commit/54c284d982413e0a7b33658fc2721447c8ba8e58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164326)) **GitLab Enterprise Edition**
- [Adds audit events for updating self-hosted models](https://gitlab.com/gitlab-org/gitlab/-/commit/b0d37115e4e3db1d8aa6b5bc0e47fc9cab53c4b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165520))
- [Split AccessProbe to Access and Token probe](https://gitlab.com/gitlab-org/gitlab/-/commit/a646a7a77f196d40818ec50e20972a0e86ef1f96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164728)) **GitLab Enterprise Edition**
- [Create feature flag for controlling CVS for CS](https://gitlab.com/gitlab-org/gitlab/-/commit/81dea77ffe4bb252bc55ca2b6aab06e5961523b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165368)) **GitLab Enterprise Edition**
- [Add Anthropic keys pattern to secret detection](https://gitlab.com/gitlab-org/gitlab/-/commit/9e17011fd4ad500366920b02390a1bc09d80c86a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165222))
- [Logs events for self-hosted model deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/019eef3afaf79d8e73625f8534e49ca65e59f479) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165321))
- [Expose abuse report notes in GraphQL endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/d86df88c84c7978852a56cca9de31a7267d0afd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162600))
- [Make the project setting spp_repository_pipeline_access cascading](https://gitlab.com/gitlab-org/gitlab/-/commit/013646b427f09ec060ec0dac6a44901185d8b208) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165190)) **GitLab Enterprise Edition**
- [Add setting for projects to access SPP repository to fetch PEP configs](https://gitlab.com/gitlab-org/gitlab/-/commit/85f987f6fcf0066ad3bc12d9052e1229b548cd50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164918)) **GitLab Enterprise Edition**
- [Set approval_policy_rule_id for approval rules and license policies](https://gitlab.com/gitlab-org/gitlab/-/commit/bc35e63e3b12bf907c1bf4af0527fd558c7a1c93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160718)) **GitLab Enterprise Edition**
- [Add database columns for 7+30+60 day PAT expiry notification](https://gitlab.com/gitlab-org/gitlab/-/commit/774fd50542b74b6db6289a280af73bffd8152b7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165257))
- [Remove feature flag `pipeline_execution_policy_suffix`](https://gitlab.com/gitlab-org/gitlab/-/commit/374363b7c2bb9fc81c5ea482a86c06dc32960625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165542)) **GitLab Enterprise Edition**
- [Show health status rollup data](https://gitlab.com/gitlab-org/gitlab/-/commit/653b5c0b40eacdf018f2b9fca4b01d06a476a6bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163902)) **GitLab Enterprise Edition**
- [Add linkable image to single vuln view](https://gitlab.com/gitlab-org/gitlab/-/commit/e964858da1ce05f9dfd9eacc41e58cb9cf38d184) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165602))
- [Implementation AiFeatureSettingUpdate GraphQL node](https://gitlab.com/gitlab-org/gitlab/-/commit/352664e09cb71909476d3398192dfd0af0319eb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165067)) **GitLab Enterprise Edition**
- [Add organization_id to sbom_component_versions](https://gitlab.com/gitlab-org/gitlab/-/commit/330422f1fad0393a9fdeb09a8faecaa8807409e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165200)) **GitLab Enterprise Edition**
- [Prompt registry access for generate_issue_description](https://gitlab.com/gitlab-org/gitlab/-/commit/e23d518d6d25feb89ce1c318ae38c0e4706bca00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152429)) **GitLab Enterprise Edition**
- [Add  `has_vulnerability_resolution` column to `vulnerability_reads`](https://gitlab.com/gitlab-org/gitlab/-/commit/0f8efd569ca2b90064fff371ee170c61a48ad5e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165548)) **GitLab Enterprise Edition**
- [Introduce duo pro seat assignment email for SM](https://gitlab.com/gitlab-org/gitlab/-/commit/025791c6150e04df8e748ef6bff44b75ec9af646) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164104)) **GitLab Enterprise Edition**
- [Log authentications using CI job token](https://gitlab.com/gitlab-org/gitlab/-/commit/f98d4ab4d3f227233d723faea064459c00373526) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164573))
- [Logs events when changing feature config](https://gitlab.com/gitlab-org/gitlab/-/commit/a19d97eaf37830c6081defb3feae8c79291fe97d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165489))
- [Document receptive agents](https://gitlab.com/gitlab-org/gitlab/-/commit/4dae68e29a09a696fc7accb3f02f77d765ea396d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163870))
- [Add bulk create or update service for add-on purchases for SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/dbc1d30f766d7479af1278038a36cc1c9e59db36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164641)) **GitLab Enterprise Edition**
- [Logs audit event for self-hosted models usage](https://gitlab.com/gitlab-org/gitlab/-/commit/64b55f367e41835effa4e8acf19a9e47ae6ca1f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165480))
- [Work Item rolled up count by type](https://gitlab.com/gitlab-org/gitlab/-/commit/1fb56a942ac01012968108a77b716cb6a41f3ffd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162522)) **GitLab Enterprise Edition**
- [Add webhook events for access requests](https://gitlab.com/gitlab-org/gitlab/-/commit/03a4573c32066cd48e1aae4fbe61d2e4aa6bf183) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163094))
- [Remove elastic_index_work_items ff](https://gitlab.com/gitlab-org/gitlab/-/commit/6c46763b8cf8a27f6e8fb60220defe94a460be81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165148)) **GitLab Enterprise Edition**
- [Delete Status Check](https://gitlab.com/gitlab-org/gitlab/-/commit/e1643c162a0abadbc3de22273ca70d8507883745) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164387)) **GitLab Enterprise Edition**
- [Add health_check rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/20d8c772d9aadcddfeaa06cbeff5e555fff04f83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164539)) **GitLab Enterprise Edition**
- [Add not null constraint to p_ci_pipeline_variables#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6b3518f8480e2ad4bc21d0e7994bb493dd2d5de1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165306))
- [Re-queue BBM to backfill project_id for packages dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/e9e94de4a84f52fed1082cc8d87559a1a256668d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165302))
- [Allow to configure cluster agent in Environments REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/7e9bd594161d49a22648646e03bdd82db16ec078) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164864))
- [Add new permission for external status](https://gitlab.com/gitlab-org/gitlab/-/commit/2e3f61f4358673968cbd60b8e90752dcf569dc4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164366)) **GitLab Enterprise Edition**
- [Add Reachbility Coulmn to sbom occurancy](https://gitlab.com/gitlab-org/gitlab/-/commit/3673f1286f61ca7cd8fd37f834e169c0237d560a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161746)) **GitLab Enterprise Edition**
- [Add bulk create or update service for add-on purchases for SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/dc1a4d5bc6898a2d4638705a2df01dca6e27b259) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164589)) **GitLab Enterprise Edition**
- [Add and backfill project_id for p_ci_pipeline_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/536fb87984e0c0f88a41e4d4d8bd045cb922ac51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164170))
- [Set project_id for existing orphaned packages dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/d1c994c87360d0eaecbbd735125f6312ac1aae97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164270))
- [Adds audit events for MlModelVersion](https://gitlab.com/gitlab-org/gitlab/-/commit/13bf59cbb19927a5150076988528b9b88fcd9684) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165145))
- [Add method to move repository to namespace in API client](https://gitlab.com/gitlab-org/gitlab/-/commit/1d6f2eb4e901860412cdf836f7d6c464d325f485) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161675))
- [Adds audit events for ML Models](https://gitlab.com/gitlab-org/gitlab/-/commit/8f855056cc1eb46bf7a3f9bdd0884f391aa4ca06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165011))
- [Expose cluster agent in Environments REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/48ac71655458b0d284f130e0b60d90fc95ee092d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164862))
- [Feature to cancel machine learning artifact imports](https://gitlab.com/gitlab-org/gitlab/-/commit/edfb8a79075184b1be3eefc4eeec2fa3c53f34f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155977))
- [Add featureFlags to GraphQL metadata field](https://gitlab.com/gitlab-org/gitlab/-/commit/933b5643feebe1feb471be2652d98497c17bc65b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164806))
- [Rename and add fields additional context api](https://gitlab.com/gitlab-org/gitlab/-/commit/36d474a28b79579c8a0c8c34b1342b18fa8b1229) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164919)) **GitLab Enterprise Edition**
- [Add Project.dependencies and Group.dependencies queries](https://gitlab.com/gitlab-org/gitlab/-/commit/eb0cb08830de6d9a172ab25ad375a0e86a1594b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164884)) **GitLab Enterprise Edition**
- [Add branch rules alert on repo setting page](https://gitlab.com/gitlab-org/gitlab/-/commit/05f9cdd5ee8f7edcae2142e04d9dfcb263c133ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163237))
- [Adds CI pipeline for duo workflow execution](https://gitlab.com/gitlab-org/gitlab/-/commit/5f43bb5f9a667d61693efb519d5c583e78e0b4e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162091)) **GitLab Enterprise Edition**
- [Allow projects API to receive order_by=star_count](https://gitlab.com/gitlab-org/gitlab/-/commit/976bbe03ce6eccc73ade34cc1de5d1218e57053a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161504))
- [GraphQL: Merge Request add field "Closed At"](https://gitlab.com/gitlab-org/gitlab/-/commit/97174309fb43a275da211316348cdac7e5b05eed) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164650))
- [Compute policy diff before persisting security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a48f5a84e932c36be4e4b5c98b2b0b3edfdba4a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163942)) **GitLab Enterprise Edition**
- [Backfill vulnerability_count background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f913602afd6ba9a1b74ff6492d1564042ad8802c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163151))
- [Add EPSS field to Vulnerability type in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/78ce095682a0fe4518bdec40d32f3c260ab93c8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162435)) **GitLab Enterprise Edition**
- [Create Instance Integrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/405c8b0ade67fb59a86faf47d7e04f1bab23b65c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164503))
- [Added todos_vue_application feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/db368a66e75d300453c45073e219a396ffdddeb9) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162587))
- [Adding "approver" to merge request resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/ce14377741ee8d5c3bd14734e1c10b5661862cc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161987)) **GitLab Enterprise Edition**
- [Release handle_vulnerability_external_issue_link_via_events feature](https://gitlab.com/gitlab-org/gitlab/-/commit/83d64a5e5c1c244c15830e1c6b460dbcd5c19d56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164849)) **GitLab Enterprise Edition**
- [Add backticks to username mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/8bd0d4cebede6064ebece8df7cbdacbe8363f49a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163779))
- [Create database table to store group-level allowlist entries](https://gitlab.com/gitlab-org/gitlab/-/commit/53fffa7c70448cebd5d82782081799f6a6621de0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163733)) **GitLab Enterprise Edition**
- [Remove generic_extract_generic_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/60c93abd6d42733298fc4704551af56d9f814108) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164914))
- [Add prometheus metrics for scan execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/19844ccbaeaf71f27cd2bf4013144c8171ec7878) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163198)) **GitLab Enterprise Edition**
- [Create database table to store project-level allowlist entries](https://gitlab.com/gitlab-org/gitlab/-/commit/a27a6540274a5f6123deb78cec5f6292a071a44c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163732)) **GitLab Enterprise Edition**
- [Add tag details to vuln list page](https://gitlab.com/gitlab-org/gitlab/-/commit/40e44ff5f7fe23b20a69144b296ca2d6864fc49e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164199)) **GitLab Enterprise Edition**
- [Add tracking and some ux element tweaks](https://gitlab.com/gitlab-org/gitlab/-/commit/e9eaa91cd2b695136286a85218d45ea06a1d64c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161308)) **GitLab Enterprise Edition**
- [Add managing protected branches as custom permission](https://gitlab.com/gitlab-org/gitlab/-/commit/8e47294dd42deea53d38a71b639e7dd3465e1216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162208)) **GitLab Enterprise Edition**
- [Enable Advanced Context for Code Suggestions](https://gitlab.com/gitlab-org/gitlab/-/commit/88e2bc0850039c3cf9638c9d44d2685ad20b6e3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161538)) **GitLab Enterprise Edition**
- [Add API endpoint for token associations](https://gitlab.com/gitlab-org/gitlab/-/commit/3a44995b5cf5029404c7bccf8915e8b7396f4eab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162859))
- [Add Duo chat sub-feature to self-hosted models settings](https://gitlab.com/gitlab-org/gitlab/-/commit/dd067ed879aff49295b824bf2a2a0e103ba5434e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163600)) **GitLab Enterprise Edition**
- [Add project_id for ci_deleted_events](https://gitlab.com/gitlab-org/gitlab/-/commit/4631975e501aa27a120fc8f3b23527e0ada0f754) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164838))
- [Add and backfill project_id for p_ci_job_annotations](https://gitlab.com/gitlab-org/gitlab/-/commit/c1590fe1fc43d680de5e3905420f35cb9d4f2a0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163883))
- [Add personal_namespace_id column to events](https://gitlab.com/gitlab-org/gitlab/-/commit/294b99cbe4e9d9010687415af0d182b334e4802e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164713))
- [Add web-commits/public-key endpoint to get signing public key](https://gitlab.com/gitlab-org/gitlab/-/commit/64d31be431103cac0bb9ab93d6155b14e9108fa4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163430))
- [Add build_project_id column to p_ci_finished_build_ch_sync_events](https://gitlab.com/gitlab-org/gitlab/-/commit/850355ade9891d60ba90c0e9ae4f18bafe2dcacb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163926)) **GitLab Enterprise Edition**
- [Add VSA duration data series to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/8b787c9d2a7c081f59f32cd037d8da0062cbe2f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164310)) **GitLab Enterprise Edition**
- [Add gitlab:keep_around:orphaned raketask](https://gitlab.com/gitlab-org/gitlab/-/commit/28156ab983f34f281fb8433df7c1c0d7a6cbde6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163411))
- [Early access program group admin opt-in](https://gitlab.com/gitlab-org/gitlab/-/commit/25cbcc1f9c2a4313cb99d3e64ca0217159dbd70f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159781)) **GitLab Enterprise Edition**
- [Add static events to the workload details](https://gitlab.com/gitlab-org/gitlab/-/commit/4fc059f60185a56d116a334532d0023521b9724f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164535))
- [Export detailed membership data](https://gitlab.com/gitlab-org/gitlab/-/commit/bad4b6f6286d6aaa533371479c3ae4657b605bb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157296)) **GitLab Enterprise Edition**
- [Show Progress percentage in rollup data](https://gitlab.com/gitlab-org/gitlab/-/commit/8fe60d7214852c54cc08075d8d6745c2b598bc79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163885))
- [Add project level value streams dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/e85da0e149287757236246f0870f12e6d23d0265) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164158)) **GitLab Enterprise Edition**
- [Add informational tooltips to AI Impact Analytics overview tiles](https://gitlab.com/gitlab-org/gitlab/-/commit/12f78f7f6f7d9cbbc394a188bc943db46f29b3b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163989)) **GitLab Enterprise Edition**
- [Support finding Sbom::Occurrences via dependency names](https://gitlab.com/gitlab-org/gitlab/-/commit/0ce1879b8271e01a157ee4b3362cbf454d10a68a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161932)) **GitLab Enterprise Edition**
- [Add image and tag column](https://gitlab.com/gitlab-org/gitlab/-/commit/448cd1a6b41f67d4484e1e9a1a36f8753948e455) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161732))
- [Edit branch rule status check](https://gitlab.com/gitlab-org/gitlab/-/commit/838b24b1571c006cb4224b625adcf01678608854) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163541)) **GitLab Enterprise Edition**
- [Add new status bar and pagination model](https://gitlab.com/gitlab-org/gitlab/-/commit/98dddcd80fa9928ebf1dd2dbe561ab31c24f75eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160959)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/3e68fae88032dfcc6b0b050bce7fa2bec10d33a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164341))
- [Add pipeline license count endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/8ae73bf0f90a07428d5fbfe9a8e5051861cb40aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163780)) **GitLab Enterprise Edition**
- [Help center menu: Add privacy menu link](https://gitlab.com/gitlab-org/gitlab/-/commit/159dd8c38b790e081f007451c04008e7e2e35589) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162295))
- [Adds `check_parent_organization_match` validation](https://gitlab.com/gitlab-org/gitlab/-/commit/4b2f650136393c6971402c8b5f832417cb365407) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159903))
- [Add support for project traces via GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/7a94a3b90d6b03b2c2fe2d34bbd07da4f79d37a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163507)) **GitLab Enterprise Edition**
- [feat: Fix body response for error log](https://gitlab.com/gitlab-org/gitlab/-/commit/d0792a765e5772afc8c9bcb41e89b6a66205ffc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163405)) **GitLab Enterprise Edition**
- [Add additional context to Duo Chat REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/38b04dcbf9935a0b3afbffc4d79f51bfe4a954f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162650)) **GitLab Enterprise Edition**
- [Add user mapping membership table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/0facbdc2f05d49c9b62b88b12e2eb5227407d046) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163076))
- [Add registry id to location](https://gitlab.com/gitlab-org/gitlab/-/commit/225c878af4e77fb7ebd2837fab76b96810aa7c9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159879)) **GitLab Enterprise Edition**
- [Add licensed filters to VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/393ff2145876f93e7c3ec5201b2e8741c7d0b1a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163457)) **GitLab Enterprise Edition**
- [Add GQL interface for project observability logs](https://gitlab.com/gitlab-org/gitlab/-/commit/3f6389bfc04618fd0009ab7607f382de1a2435c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162867)) **GitLab Enterprise Edition**
- [Implement REST API for cluster agent url configurations](https://gitlab.com/gitlab-org/gitlab/-/commit/abdce9527dfe46e7d551f6fd32746cf5b7135b61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163143))
- [Prepare the foreign keys for p_ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/883b141f63b01e01f95efa266f08675502f3928a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164141))
- [Release Jira Service Management feature](https://gitlab.com/gitlab-org/gitlab/-/commit/1bfb9617ba36cce09dccc7ce3c5d6a4b75adc517) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164136))
- [Context aware quote discussion hotkey](https://gitlab.com/gitlab-org/gitlab/-/commit/99f60346cbbd7aaa62bc2706328dcfa6b15388fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163928))
- [Index p_ci_finished_pipeline_ch_sync_events table](https://gitlab.com/gitlab-org/gitlab/-/commit/62ce0425129e1b999a41a91413086096ff0265a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163520))
- [Add WorkItemBulkUpdate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/0fab56d584bcecd84badc5c804d907a66ed00d78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161507))
- [Enable auto merge of Merge Requests](https://gitlab.com/gitlab-org/gitlab/-/commit/214ed9b637c17951dd0729bda3e82e83c2f148d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163949)) **GitLab Enterprise Edition**
- [Adds duo workflow events and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/8c229d25bf3b57b7597d038ed39eccd987a2ed4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163342)) **GitLab Enterprise Edition**
- [Create partitioned table p_ci_pipelines and attach first partition](https://gitlab.com/gitlab-org/gitlab/-/commit/2b6506397eb78006b27588fff5759c2e9ae48938) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163575))
- [Allow labels search by exact title](https://gitlab.com/gitlab-org/gitlab/-/commit/fd348c33d4fec50e252b115007c3bdc52ca78ca2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163303))
- [Add upload zone](https://gitlab.com/gitlab-org/gitlab/-/commit/614046fb8095940b05400ee2bf66b484b62e4ef4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161289))
- [Remove FF: bulk_add_on_assignment_refresh_worker](https://gitlab.com/gitlab-org/gitlab/-/commit/815c37be4a4d2247235ecca8553028a1fc2b7e2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163543)) **GitLab Enterprise Edition**
- [Support for editing the model version description in the model registry](https://gitlab.com/gitlab-org/gitlab/-/commit/595e21c3ea46fa995d5b90ee806722ca70c80b47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163132))
- [Add and backfill project_id for ci_job_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/15f524bbb0b0b5ec817617323dc7c05ac5d3fe65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163445))
- [Add frontend support for markdown in ML Model Versions](https://gitlab.com/gitlab-org/gitlab/-/commit/7bf70ec8933827b109f8d11f89e14639b91739a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162759))
- [Update AliasResolver to work with versions](https://gitlab.com/gitlab-org/gitlab/-/commit/01e59ad1c02ec6d94e9824d9616ade064e063b08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163203))
- [Implement REST API for cluster agent url configurations](https://gitlab.com/gitlab-org/gitlab/-/commit/26e824b17107d77d5db527f20a613e8ea8113011) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163143))
- [Show Terms of Service and Privacy Policy entry within Help if defined](https://gitlab.com/gitlab-org/gitlab/-/commit/0026f82c33ccdb23071f355da52d78c49593d38f) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157269))
- [Ingest component licenses from CycloneDX SBOMs](https://gitlab.com/gitlab-org/gitlab/-/commit/c1b511a0bf6f8262b9ffcb66ef58bf7e2f6ce499) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162102))
- [Audit topic changes on projects](https://gitlab.com/gitlab-org/gitlab/-/commit/5163056a3b81b6e1d2a212eb8929249b1c96bd9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154158)) **GitLab Enterprise Edition**
- [Add official CycloneDX 1.6 JSON schema](https://gitlab.com/gitlab-org/gitlab/-/commit/e4bcc1c6056e3cea7b520f564f68879cf8b20d62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163562))
- [Implement internal REST API for receptive agents](https://gitlab.com/gitlab-org/gitlab/-/commit/3a9b8b6fa40fb6f22bf127ce566266dd9f2cbbfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163144))
- [Add API endpoint for bulk usage_data sending](https://gitlab.com/gitlab-org/gitlab/-/commit/6be835d5e262ee306947838e1382b47b9c0c4577) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161855))
- [Allow to fetch related items on VSA GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/d0ded627a90de920c2431517ad22bd209b7209e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161510)) **GitLab Enterprise Edition**
- [Add Export Subscription History button to Usage Quotas Page](https://gitlab.com/gitlab-org/gitlab/-/commit/7121cf7c5e011b916232e55f45d0b08cd223f4da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159059)) **GitLab Enterprise Edition**
- [Fix pipeline error when invalid CI and using PEP](https://gitlab.com/gitlab-org/gitlab/-/commit/3c16289821976bf2e541d69acceb802438d75bd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160848)) **GitLab Enterprise Edition**
- [Display when locked account email verification code was sent](https://gitlab.com/gitlab-org/gitlab/-/commit/a903dc73f5fb2fe2366261dfe873aa17a75da1cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163298))
- [Notify on assignment rejection](https://gitlab.com/gitlab-org/gitlab/-/commit/b7731501773cd682f405d7a123d330b48f7b1894) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162855))
- [Enable Direct Transfer UI when override flag is set](https://gitlab.com/gitlab-org/gitlab/-/commit/d8436964cb20ad0de61787bfb35516f0718f5f55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163481))
- [Add resend hook event api](https://gitlab.com/gitlab-org/gitlab/-/commit/743ff486e456d1ad0d4c81dd531619bb7205401b) by @lifez ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151130))
- [Add REST API invited groups in a group](https://gitlab.com/gitlab-org/gitlab/-/commit/a7c97c7ae77880d30d339f6da675bec7ab601c18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162423))
- [Add project view to pages usage quotas](https://gitlab.com/gitlab-org/gitlab/-/commit/8ff96edbc09f563297b6b4e84d0cb962090a190d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162054)) **GitLab Enterprise Edition**
- [Add branch rules status check](https://gitlab.com/gitlab-org/gitlab/-/commit/ab2a6aecd2b3701e4894e70734609f1a26d09a85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161380)) **GitLab Enterprise Edition**
- [Allow linking work items to a new work item via GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/8d9ac7978ea43f5026e8dcafb5ca6c6042e68ea1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163339))
- [Prepare async partitioning constraint for ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/cfa072647625cfe4dd90f148f21686e6fca28870) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162668))
- [Create ci_finished_pipelines_daily ClickHouse tables](https://gitlab.com/gitlab-org/gitlab/-/commit/7ddb343fe065036324f8692db0ec0a4d3129dd37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163042))
- [Add `archived` argument to projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/7fb9604a3bbed05feb2faf6e9a0d97289c0ef2d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157826))
- [Set the detumble_email attribute before saving emails](https://gitlab.com/gitlab-org/gitlab/-/commit/6c75f037174a0224fe760816cb662352e7f792b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161663))
- [This MR adds group policy scope](https://gitlab.com/gitlab-org/gitlab/-/commit/ca3f84a842b601cd16cff451bd72c70910d94648) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162318)) **GitLab Enterprise Edition**
- [Add async destruction of billable members](https://gitlab.com/gitlab-org/gitlab/-/commit/a45cf1a9fee7889679b3697fa150f2cb1f421efe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162148)) **GitLab Enterprise Edition**
- [Add reassignment error to Import::SourceUser](https://gitlab.com/gitlab-org/gitlab/-/commit/2ec5e7024eb86f4bff6e98ffe6c63694ab4c5592) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162421))
- [Link issue to metric on creation](https://gitlab.com/gitlab-org/gitlab/-/commit/8e2d68b88d85558371e7e6a6b5950993656f242b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163150)) **GitLab Enterprise Edition**
- [Add table to store O11y trace-details when creating linked issues](https://gitlab.com/gitlab-org/gitlab/-/commit/24b1682ecf2b7969e4ab95d34366c0d316aff0ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162534)) **GitLab Enterprise Edition**
- [Add published_by to CI Catalog Resource Version](https://gitlab.com/gitlab-org/gitlab/-/commit/2c022c6d469e6f3b25bdf472d247dae7a5066588) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162843))
- [Add endpoint with standard roles and members count for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/b73f358073f80b46feb1ac487be6d64ebdf18766) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163248)) **GitLab Enterprise Edition**
- [Add GraphQL interface for linked metrics for issues](https://gitlab.com/gitlab-org/gitlab/-/commit/6a2c544db0af910806a05232a779880a825cf512) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162403)) **GitLab Enterprise Edition**
- [Release Admin Runners custom ability](https://gitlab.com/gitlab-org/gitlab/-/commit/94fb9dac123406301506c400858a03fbd8b4d4da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163231)) **GitLab Enterprise Edition**
- [Convert checklist item to child item in work items](https://gitlab.com/gitlab-org/gitlab/-/commit/792ab912e4d317437d51e166793f850e4dc19e1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160234))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/6011680b2d033e1ec51e5d498cd23e59d6d7f783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163149))
- [Exposed target path and access request data on todo GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/9b70ea7d4fef757b1aeae0b8e29d39337715ffbb) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148782))
- [Add end tutorial button to learn gitlab](https://gitlab.com/gitlab-org/gitlab/-/commit/6e758dbe026af4f2b87e443101113f3f70860a8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161656)) **GitLab Enterprise Edition**
- [Add Whats New section to DuoProDiscover page](https://gitlab.com/gitlab-org/gitlab/-/commit/eb36197ade33f7f3147e823b2580f85b1012a4e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162065)) **GitLab Enterprise Edition**
- [Link issue to metric on creation](https://gitlab.com/gitlab-org/gitlab/-/commit/cebe25f839f6ceb91d04bf7f8c5eb68cb255cdcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161619)) **GitLab Enterprise Edition**
- [Support for editing the model description in the model registry](https://gitlab.com/gitlab-org/gitlab/-/commit/42ed8e21a28cdfb514c9f98ba42079c3f3042cae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162003))
- [Add a user preference for enabling the DPoP feature per User](https://gitlab.com/gitlab-org/gitlab/-/commit/964adb545648e94fac33b7ad8846dcfdbd9f18cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162790))
- [Add table to store O11y log-details when creating linked issues](https://gitlab.com/gitlab-org/gitlab/-/commit/eb11a7b5b138f6b7f3bb441657a7fad4efec824b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162194)) **GitLab Enterprise Edition**
- [Add backend support for markdown in ML Model Versions](https://gitlab.com/gitlab-org/gitlab/-/commit/7f0b450ab2feb2ba56a3100d5d04d8e92c91cf58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162758))
- [Append year to date column headers in AI Impact table](https://gitlab.com/gitlab-org/gitlab/-/commit/94842f9b476aa29fe115d7e29190691b6fa54a4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162942)) **GitLab Enterprise Edition**
- [Add org to sbom_components](https://gitlab.com/gitlab-org/gitlab/-/commit/d3468ebf7093b8a044283bfbc3a67bfc1b394d54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161288)) **GitLab Enterprise Edition**
- [Add migration to backfill project_id for packages dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/8b4415b3d456038cff96ce9a9f02369a42a756ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161798))
- [Feat: manual variables tab frontend part 2](https://gitlab.com/gitlab-org/gitlab/-/commit/3b6af97c6baed81d9f25be93d5c699b1c70e7eb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160018))
- [Add sharding key for personal access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/6a9455f72e903751154d82040d060024ed5d635e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161456))
- [Replace gl-form-text with equivalents](https://gitlab.com/gitlab-org/gitlab/-/commit/37651b84193ceeb5132f0dc9709b61208d87d865) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162180)) **GitLab Enterprise Edition**
- [Add migrations for import placeholder user limits](https://gitlab.com/gitlab-org/gitlab/-/commit/673a7cbe46e47535af4253ab3cf1a50aa5ba57ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162099))
- [Add application setting for enabling receptive cluster agents](https://gitlab.com/gitlab-org/gitlab/-/commit/b814c3a2a81290cb7773eb3c50fc2117a8e055de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162514))
- [Add additional context to Duo Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/68bf7bab53875f555c89d54e67c702e23e51661e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161898)) **GitLab Enterprise Edition**
- [Add Whats New section to DuoProDiscover page                                  ...](https://gitlab.com/gitlab-org/gitlab/-/commit/0b6d7811355b3a6fac10e71b14d3f85779654701) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161506)) **GitLab Enterprise Edition**
- [Send Arkose truth data when auto-banning users](https://gitlab.com/gitlab-org/gitlab/-/commit/f82eff19a910dd150cf1c60672dbc35d311966ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162504))
- [Add cached markdown fields to ML ModelVersion](https://gitlab.com/gitlab-org/gitlab/-/commit/1107c04656415ba095040f913ce048e30cf0bd8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162398))
- [Parse deprecatedProperties for SEP and add banner for custom scan](https://gitlab.com/gitlab-org/gitlab/-/commit/f8442b86480080bfc48e3547fa5162a701b84b84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162027)) **GitLab Enterprise Edition**
- [Validate FK for ci_pipelines.auto_canceled_by_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2bf002bafc93c9c1818f9c470ab9d477b4d60fcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161287))
- [Support for editing the model description in the GitLab model registry](https://gitlab.com/gitlab-org/gitlab/-/commit/07b9897d7c88537e0f902c5a27f48ebbd6a5b605) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161174))
- [Protected containers: Add DELETE REST API for container protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/7be96b71afc1d33294e991b64df792ccca483722) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159619))
- [Allow groups to disable password authentication for enterprise users](https://gitlab.com/gitlab-org/gitlab/-/commit/3128ee535c9556153a1d54d164b0a14b8ef7751e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160750)) **GitLab Enterprise Edition**
- [Add Idempotency-Key header to Webhooks](https://gitlab.com/gitlab-org/gitlab/-/commit/02369b1bcff6014bdd07a88dfe08e4553448720b) by @van.m.anderson ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160952))
- [Add helpers (un)prepare_partitioned_async_check_constraint_validation](https://gitlab.com/gitlab-org/gitlab/-/commit/b50325dab120c83e162ec0ccd9934c3c7a2f6d6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162396))
- [Expose root_storage_statistics in REST API for top level groups](https://gitlab.com/gitlab-org/gitlab/-/commit/444c2f08e0b6b28526782891cc03933749ff8c4e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161318))
- [Validate FK for p_ci_builds.upstream_pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ecfb74f2094340da38b8da60340ee1a621f900d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160710))
- [Add `archived` argument to projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/67d380198ecc17629f8972531f6daeea1d67aab9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161355))

### Fixed (187 changes)

- [Ensure that the titles of collapsed board lists are aligned](https://gitlab.com/gitlab-org/gitlab/-/commit/46cce95e15a5422a57593d4ad7408f27d59a5196) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165389))
- [Remove unnecessary association validation](https://gitlab.com/gitlab-org/gitlab/-/commit/673d674faed7dd169f4db834cbe245cd2527e4d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166157)) **GitLab Enterprise Edition**
- [Restore backup log file](https://gitlab.com/gitlab-org/gitlab/-/commit/3754f5af46c1b787ce4041cd5fa287f550f97d4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163224))
- [Preserve leading spaces in code](https://gitlab.com/gitlab-org/gitlab/-/commit/174b8e8facc0d6f7cf3c0fa431b0880810e150f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165628))
- [Add loading and empty state in commit refs](https://gitlab.com/gitlab-org/gitlab/-/commit/73d5210802c2b2a3ae2cc8d6166c947d9fac7644) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159602))
- [Fix timeline content dark mode rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/767ecc59d1b292f5f6e65383de3b0968803841ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166100))
- [Fix alignment of legacy system notes](https://gitlab.com/gitlab-org/gitlab/-/commit/72a509445fc3d300d858ed8847904df72f26cebb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166051))
- [Fix theme color theme highlighting](https://gitlab.com/gitlab-org/gitlab/-/commit/f3d1cac83a3d1b1e825d5a00c8789b35c38ab7df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165217))
- [Applying Patch for Checkin](https://gitlab.com/gitlab-org/gitlab/-/commit/8120d62231780b3c414b80cec2c88bd0506a8ade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163050))
- [Fix broken docs link for container scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/cc08b0d5698858e0d8fdd9e2512bd12c8896677c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165974))
- [Fix ci_deleted_objects#pick_up_at](https://gitlab.com/gitlab-org/gitlab/-/commit/93bbdec142c4c8870f01052549aa1c88350d1f33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165766))
- [Make sure explain code button doesn't overlap sticky headers and nav](https://gitlab.com/gitlab-org/gitlab/-/commit/bdcc7498513f92c1e246bc640da626d9172feb07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165684)) **GitLab Enterprise Edition**
- [Fix admin user can create top level group UI](https://gitlab.com/gitlab-org/gitlab/-/commit/9239c02fd422ff7647be4c15aea61c0959edbccd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164428))
- [Set cron source to `schedule` to ensure clean up on load](https://gitlab.com/gitlab-org/gitlab/-/commit/2552a1256e74f7c9564643278b8264f28647f36d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165769))
- [Use Gitaly::ListCommitsRequest in network graph to include tags](https://gitlab.com/gitlab-org/gitlab/-/commit/f6bb83cd6ba14632a075c5146a438400627b484c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164081))
- [Initial checkin fix for adding back experiments](https://gitlab.com/gitlab-org/gitlab/-/commit/a4136d1e343e6bb8f6db38c12fdb5fee013420dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165831))
- [Do CommitTrailersFilter before ref filters](https://gitlab.com/gitlab-org/gitlab/-/commit/6748512235da227c3c8e52d30ed367dc0f40302e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165235))
- [Avoid multiple submit of work item comment](https://gitlab.com/gitlab-org/gitlab/-/commit/4cefd6c8ad39fd0e6ede147360bd364237b6220a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165371))
- [Fix Issue entity undefined method `namespace' for nil:NilClass](https://gitlab.com/gitlab-org/gitlab/-/commit/c21c62f0fa7ba58b1681f2e41cc102aceea93847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164499)) **GitLab Enterprise Edition**
- [Fix conflicts warning on work item description](https://gitlab.com/gitlab-org/gitlab/-/commit/dd8bbb92396f1ee8212421f6d46ea2b5499559cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165599))
- [Fix CI Catalog component table layout](https://gitlab.com/gitlab-org/gitlab/-/commit/37dd011cc7bc20f8bd6078131540ca8cf3e8a946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165724))
- [Fix anthropic client to handle nil response](https://gitlab.com/gitlab-org/gitlab/-/commit/8eae038ca8193effb91fc84218d4fa6e3d171e44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165465)) **GitLab Enterprise Edition**
- [Ignore negative index policies and rules for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/58fc663708ee3265dd6d41bc51154ba8c234e916) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165342)) **GitLab Enterprise Edition**
- [Ensure file title wraps on merge conflict resolver screen](https://gitlab.com/gitlab-org/gitlab/-/commit/6d309ba39348bccb505b19fbc663806448108263) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165702))
- [Update regex to capture edge cases](https://gitlab.com/gitlab-org/gitlab/-/commit/0a9644ad015255d709f32b63934173293f91422c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165498))
- [Handle a slow query for CodeNavigationPath](https://gitlab.com/gitlab-org/gitlab/-/commit/78a9e46128dcded7d1f55e316bfe96a9db5c2b10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162894))
- [Remove extra avatar on image diff comments](https://gitlab.com/gitlab-org/gitlab/-/commit/e31a0f68d9d247fd0283fe6b16cbbfcc1cc8b63f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165651))
- [Fix start and due dates widget when work item has a dates source](https://gitlab.com/gitlab-org/gitlab/-/commit/712996d37b98f991009893b67fd0469472e704f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165221))
- [Use keyword_init: true in gitaly server.rb struct](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ac0e567c28d7059b1401919db9fdf7a860708d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165089))
- [Prevent footnote OL from being reorderable](https://gitlab.com/gitlab-org/gitlab/-/commit/4e45697198097ebc58ddbdc58fe44da5a0175653) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164929))
- [Fix Duo for CLI policy to check instance setting for SM](https://gitlab.com/gitlab-org/gitlab/-/commit/3865c77ce30a5a7cf434e467fc40a31211605138) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165021)) **GitLab Enterprise Edition**
- [Fix list item click event on the group-level Analytics Dashboards page](https://gitlab.com/gitlab-org/gitlab/-/commit/948146151015050b7a7180743482cd264534a787) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165390)) **GitLab Enterprise Edition**
- [Fix leading of CiIcon text and make sure it is vertically centered](https://gitlab.com/gitlab-org/gitlab/-/commit/3da1daec04e0c1f68c9cfdb758e533045356d22e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165383))
- [Remove gradient line at beginning and end of activity](https://gitlab.com/gitlab-org/gitlab/-/commit/7ee11a685670665f2a6080dc32f08228adb73d62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165329))
- [Vulnerability: bugfix of add issues form disappearing](https://gitlab.com/gitlab-org/gitlab/-/commit/57250bff19d083cda3937755204387b5b92cb0c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165169))
- [Fix deploy key truncation issue in drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/e3d67aa289802638839845502b779a68a58c01b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165340))
- [Check if project is public before setting cache control to true](https://gitlab.com/gitlab-org/gitlab/-/commit/742a2809e6700dc2b5d0a5f749ff559b9c86224f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164537))
- [Show new notification button in work item sticky header when flag is on](https://gitlab.com/gitlab-org/gitlab/-/commit/373154325462be3c5a263c0182d7476fe5b34e24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165101))
- [Skip the indexing when the zoekt_repository is in failed state](https://gitlab.com/gitlab-org/gitlab/-/commit/77801e5ad707a2ff1c1da88e64323815fb3c8749) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165179)) **GitLab Enterprise Edition**
- [Fix import of pipelines with negative duration to ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/dd26063e1e2613fe1a0e46273c83bf7528d6983c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165081))
- [Fixes logic to set labels filter base path](https://gitlab.com/gitlab-org/gitlab/-/commit/a804f1263f100df3c64e865e966645a2bc67c650) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165254))
- [Fix layout of Comment type dropdown for small viewports](https://gitlab.com/gitlab-org/gitlab/-/commit/0ced2e25ccd4c87ee27a11e0bce97590285fc89f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165248))
- [Fix disabled job action state](https://gitlab.com/gitlab-org/gitlab/-/commit/c58eb73ce82c4d9dc6629a57633cd53827a89fd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165207))
- [Create missing NPM metadata when package is deprecated](https://gitlab.com/gitlab-org/gitlab/-/commit/35234b33bc1d6901aa6eca8ddf03f7b44dbfa075) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164941))
- [Update merge request overview tab changes count to use merge head](https://gitlab.com/gitlab-org/gitlab/-/commit/a29aeea939a8f83df646d46c5385b3bdcb73e323) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162160))
- [Fix overflow issues in branch rule deploy keys](https://gitlab.com/gitlab-org/gitlab/-/commit/05a181bead44c69cf506dda95455ccb9c604c0ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165124))
- [Fix description issues with custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/c2011c8bf252ca80faae5244489602774336fc36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164292))
- [Fixes create workflow param](https://gitlab.com/gitlab-org/gitlab/-/commit/34c8f392afdefc7c6dbfe3828de74f37db74023f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165156)) **GitLab Enterprise Edition**
- [Add search by parents for group links](https://gitlab.com/gitlab-org/gitlab/-/commit/e9614ea33fb0bcc069fcbf60cd38c74450df1d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165006))
- [Initial checkin for checkbox fix](https://gitlab.com/gitlab-org/gitlab/-/commit/3cce7e70812ea81122bdf30ba1197a8f7e232907) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165119)) **GitLab Enterprise Edition**
- [Project, group description: highlighted-text style](https://gitlab.com/gitlab-org/gitlab/-/commit/ee468af225026d56054606653fe95b9905022848) by @santigl ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164269))
- [Fix layout of suggestion management buttons on mobile](https://gitlab.com/gitlab-org/gitlab/-/commit/f0d240d6b81af96cf2d3387e46c99e72288bc322) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164271))
- [Fix flaky specs for creating a work item with linked items](https://gitlab.com/gitlab-org/gitlab/-/commit/697ea5065a2b3a149dbb3b825048d5bad940bfcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165082))
- [Fix reference serialization in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/7270951919bb7a1e175311f6d497a396dc527e41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165017))
- [Flush internal_id records on unique violations](https://gitlab.com/gitlab-org/gitlab/-/commit/50c6dadb89f24c1cbfc60abb0d610c48797225cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164771))
- [Initial checkin of experiments setting fix](https://gitlab.com/gitlab-org/gitlab/-/commit/e4189cb0946a3cb6b3f4c1f3ca4fcc9f9fc2685c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163799)) **GitLab Enterprise Edition**
- [Prevent award tooltip being cut off in modals](https://gitlab.com/gitlab-org/gitlab/-/commit/c9dfff9220464e4ff7d1b0a9fa09c4bed77c9179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165044))
- [Fix JobInjector error when stage does not exist for some jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/72961e1ad7b3e9bc328f9eee7f74c152e238d646) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164997)) **GitLab Enterprise Edition**
- [Update Access data on sync even if data didn’t changed](https://gitlab.com/gitlab-org/gitlab/-/commit/db31e3004bc1442ef3943a332059cbd50d48001a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164789)) **GitLab Enterprise Edition**
- [Fix inputs in pipeline schedule ui not resizeable](https://gitlab.com/gitlab-org/gitlab/-/commit/22d180bbae156bb36366699e2580ec2d7c6116f5) by @wilsonpinto ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164195))
- [Reject OmniAuth sign in when email is too long](https://gitlab.com/gitlab-org/gitlab/-/commit/002a586a255147e88025e638f2f3265cc4ae535a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161205))
- [Add :clean_gitlab_redis_cache to server_spec.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/54e8c7062c61e4d0099e6861caae60698009092e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164887))
- [Cover all scenarios when determining whether chid is within parent epic](https://gitlab.com/gitlab-org/gitlab/-/commit/1d410c7d2cd4abed3a81f421b55b9f2746eccee5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163133)) **GitLab Enterprise Edition**
- [Reduce workItemNotesByIid query complexity](https://gitlab.com/gitlab-org/gitlab/-/commit/17cf0d7afdb23837074aa34e69af6a28ca25bf56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164876))
- [Add default background color to timeline avatars](https://gitlab.com/gitlab-org/gitlab/-/commit/43deed0c0a471d628cb4c224ef76874cedee30ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164725))
- [Do not update descriptionHtml if details blocks are changed](https://gitlab.com/gitlab-org/gitlab/-/commit/292e8c13d5aa610adc5c9418a6238d6b4f78ae34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164860))
- [Fix missing `ci_cd_settings` relation on project creation](https://gitlab.com/gitlab-org/gitlab/-/commit/d93be3b151230d9fb6fb82b7b2d3bd9c7294fcf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164094))
- [GraphQL: Fix empty successful pipeline analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/14187446518e842790bbdf0bcf9ec596ea248d82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164837))
- [Mirror behavior of issuable header status in sticky header status](https://gitlab.com/gitlab-org/gitlab/-/commit/c8e6f32e7a9d082e83b907c20340b8c04475706e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164402))
- [Remove derisk feature flag after rollout](https://gitlab.com/gitlab-org/gitlab/-/commit/7c3037deb6c305e7dfef6e5e455d259a2c57efaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164787))
- [Fix total issues chart](https://gitlab.com/gitlab-org/gitlab/-/commit/7d71d09b87ef3f4108447e2cd5c668839aaa914d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164758)) **GitLab Enterprise Edition**
- [Blame: Fix text overflow and use small text](https://gitlab.com/gitlab-org/gitlab/-/commit/30739856943a9b3486fbc85e873246d51a34645d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164760))
- [Fix sidebar flyout menu closing before cursor can reach it](https://gitlab.com/gitlab-org/gitlab/-/commit/2c2a82e79f495193d0310f89cf35f9fabd8ee55c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163904))
- [Fix blame for sha256 repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/6f0d9fc74b26a06f2d7a9c12124136e9efd6e079) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164738))
- [Conditionally expose member's is using seat info](https://gitlab.com/gitlab-org/gitlab/-/commit/30da71ab303ad316c97fcbcfed0b2b754b40228a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164333)) **GitLab Enterprise Edition**
- [Group label events in deterministic order](https://gitlab.com/gitlab-org/gitlab/-/commit/c1aeaa1fe40fcf48a1ba69aee4ffb7ee0d26423f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164502))
- [Display exhaustive Licensee license list](https://gitlab.com/gitlab-org/gitlab/-/commit/40efef2916a2ea041d979eb076ee029ae8c612fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164085))
- [Handle membership access requests for indirect members](https://gitlab.com/gitlab-org/gitlab/-/commit/8d6fd0c6ef448046a5508b771e18c433dc895eeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164276))
- [Refactor IngestReportsService with execute strategy](https://gitlab.com/gitlab-org/gitlab/-/commit/f73682a0700a321f76d510dfe482b680753aad17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162588)) **GitLab Enterprise Edition**
- [Update schema processing for policy editor](https://gitlab.com/gitlab-org/gitlab/-/commit/06d4ca1dd84058f8920e85b2cbe68448fc22ee0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164415))
- [Fix draft replies on regular comments on MR overview tab](https://gitlab.com/gitlab-org/gitlab/-/commit/0cf954f0bf74c126e107e6f7ef8e2f235dd63bb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164374))
- [Fix alignment of items in performance bar](https://gitlab.com/gitlab-org/gitlab/-/commit/c1bcbedde147d93e280eaa3103d84aaf4b042c3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164355))
- [Fix background avatar color and border on draft notes](https://gitlab.com/gitlab-org/gitlab/-/commit/4b18ea930966ee2ca650a13d955870b5a9def4f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164339))
- [Pages unique domain url update](https://gitlab.com/gitlab-org/gitlab/-/commit/6a300191476ab0bf7af231f11c513f90d96e8370) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163523))
- [Stop using kilobyte conversion for max highlight file size](https://gitlab.com/gitlab-org/gitlab/-/commit/c45449c511d5ff0b6f6b796b2d25286dd03af86d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164290))
- [Re-enable hand raise lead for SaaS usage quota page duo](https://gitlab.com/gitlab-org/gitlab/-/commit/8a0e2e1e3f2ae89899aa6a44942fc57a768540b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164257)) **GitLab Enterprise Edition**
- [Adjust background migration to new schema](https://gitlab.com/gitlab-org/gitlab/-/commit/c5ec6bd1cf676db02b609087318eaa331439de0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164238))
- [Timeline avatars: Add default bg](https://gitlab.com/gitlab-org/gitlab/-/commit/2e1ad01c2b271d43d32f46c061a3b75a63cd4e5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164234))
- [Fix multiline discussion alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/f56256571914951d74ea513adc59174c8de9e882) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164167))
- [Fix 500 when passing non-string to inputs:regex](https://gitlab.com/gitlab-org/gitlab/-/commit/61a814c18fc27dea8efe3f7c648d2fa7d02cd871) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164224))
- [Fix group-level vulnerabilities GraphQL performance issue](https://gitlab.com/gitlab-org/gitlab/-/commit/315d3467b941c6eca6c360853eec497b3104f201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163950)) **GitLab Enterprise Edition**
- [Expand deeplinked resolved thread](https://gitlab.com/gitlab-org/gitlab/-/commit/5e17550569bddf6953fb6214879cc2ee40c9f342) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162022))
- [Fixes link formatting in Matrix integration](https://gitlab.com/gitlab-org/gitlab/-/commit/5c6a1b50759e43cd447c3a55ebb979d1d192eb06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163923))
- [Fix usage overview visualization flex layout](https://gitlab.com/gitlab-org/gitlab/-/commit/eb8e0c212fa45e90fc433331f17a2d5e87404287) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164160)) **GitLab Enterprise Edition**
- [Fix issue where user could not assign runner to a project](https://gitlab.com/gitlab-org/gitlab/-/commit/3ef9a459ad37177cee3b027d399d00e5cb5ddb87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163747))
- [Admin Code Suggestions - Add default injections](https://gitlab.com/gitlab-org/gitlab/-/commit/ca24269b6ffe4e89a467c86edeb157086ec18092) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163984)) **GitLab Enterprise Edition**
- [Fix line height of CI status badge in job header](https://gitlab.com/gitlab-org/gitlab/-/commit/a7a26643d8554f27c52180d1c6307702148c2f22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164116))
- [Rescue TarInvalidError when uploading npm packages](https://gitlab.com/gitlab-org/gitlab/-/commit/27703c5fed2ef19979782a8b7d87a60fd1da1abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164072))
- [Fix 403 error in external status endpoint for admin user](https://gitlab.com/gitlab-org/gitlab/-/commit/c41a25c44f5f0283d2d05ecdbca3c21f6f0caa77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163679)) **GitLab Enterprise Edition**
- [Fix undesired wrapping issue on related items attributes in Safari](https://gitlab.com/gitlab-org/gitlab/-/commit/45517816c9fb93ff420901b11365fb14813b565d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163988))
- [Reset notification email to default when used email got deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/875c497ccfb61e7a746f44be9a7ab19274737326) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163192))
- [Fix bug with label_name search filter](https://gitlab.com/gitlab-org/gitlab/-/commit/511fa30651f96598c9464b60acc3085348b7f182) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163353)) **GitLab Enterprise Edition**
- [Shift anchor icon to the left for headers inside a summary tag](https://gitlab.com/gitlab-org/gitlab/-/commit/8eaccb8f3c18c51b09c81d7172df2d845a9f1c97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161832))
- [Personal access tokens: Open form if url params are set](https://gitlab.com/gitlab-org/gitlab/-/commit/f106ba3d126ab7de59ca8f2a4be8208ec4fc1faa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163944))
- [Use current user instead of @user](https://gitlab.com/gitlab-org/gitlab/-/commit/592f9200ad42386b9329e44f9a9113be54e31f6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163930)) **GitLab Enterprise Edition**
- [Add markdown live preview test & fix mermaid graph not rendering on load](https://gitlab.com/gitlab-org/gitlab/-/commit/533e5ad2ff78b16508c566e501b7379850ad0fb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163674))
- [Fix size of comment counter badge](https://gitlab.com/gitlab-org/gitlab/-/commit/9f7055916b0f23052f1edd6157333964861882a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163796))
- [Trigger workItemUpdated subscription when related MR is updated](https://gitlab.com/gitlab-org/gitlab/-/commit/6beb9773a79badf3a7f3f23d127730cd69c1cab7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162946))
- [Fix 500 error when deleting pending user invite](https://gitlab.com/gitlab-org/gitlab/-/commit/2580cfa06b620beb0ee25b6b0ebf3d01a6f441e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163573)) **GitLab Enterprise Edition**
- [Add payload errors in status check services](https://gitlab.com/gitlab-org/gitlab/-/commit/2c7d059941b477ccecfdd9c63848f3f1f8aa86a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162174)) **GitLab Enterprise Edition**
- [Fix previous/next button styles for date picker in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/a0ed1526f5aaf36184616d456749dd90c6ce3c63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163658))
- [Fix synced attrs when creating linked LDAP user](https://gitlab.com/gitlab-org/gitlab/-/commit/04f85b0687782ab799f5ce96917e95456f3b0702) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163646))
- [Use LFS transformer to create a pointer](https://gitlab.com/gitlab-org/gitlab/-/commit/484b0d8e12eaa17d1a540266f035b6d3ca2df676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163091))
- [Fix missing milestone change system notes](https://gitlab.com/gitlab-org/gitlab/-/commit/c680b177ecdef819007da9a784dccc6177a0b9d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163577))
- [Fix Duo Chat documentation question irrelevant ref](https://gitlab.com/gitlab-org/gitlab/-/commit/c372e40b7c9010e7e6d884e110d6d6e33d8d3b99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163566)) **GitLab Enterprise Edition**
- [Override pushrule for security policy project](https://gitlab.com/gitlab-org/gitlab/-/commit/f019ca3db71d76fe33abebd8fbe262182a59affe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162556)) **GitLab Enterprise Edition**
- [Check only top-level groups on sign-up form endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b995eaa87a4ccaa9f386fb1ebe5d6029f15a8851) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163381))
- [Provide epics list path for labels in work item sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/4f14e04c90007d4a40158c645dd5b8d5d8fceaca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163529)) **GitLab Enterprise Edition**
- [Order on organizations table](https://gitlab.com/gitlab-org/gitlab/-/commit/78f16c93b9c2e7456627bb2f252f7176556262d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162802))
- [Protect against a nil security_setting](https://gitlab.com/gitlab-org/gitlab/-/commit/dae7509a955103ec20c0a8d958dfca3be3e81027) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163023)) **GitLab Enterprise Edition**
- [Fix api_token update bug for self-hosted form](https://gitlab.com/gitlab-org/gitlab/-/commit/daba4142b65c3f830a00ec36fe1c84cad35b2479) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162611))
- [Change additional context to use indiff access](https://gitlab.com/gitlab-org/gitlab/-/commit/2e5e7353514702f992a04114778fe5c0b295f124) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163351)) **GitLab Enterprise Edition**
- [Adds a guard against missing projects in todos](https://gitlab.com/gitlab-org/gitlab/-/commit/b1ae6719ab1f937ed535d5140c0a41274484f6b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161796))
- [Fix alignment of description diff history delete button](https://gitlab.com/gitlab-org/gitlab/-/commit/98822c9951f512b19ed2d27380f16456517cc14c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161540))
- [Show Coverage-Check rule on MR settings](https://gitlab.com/gitlab-org/gitlab/-/commit/27d40d02041ab76286343bc3807e0203281baca0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163325)) **GitLab Enterprise Edition**
- [Remove nil content from Duo Chat message history](https://gitlab.com/gitlab-org/gitlab/-/commit/5f9869c684735d1c2237ed921aa80739224af029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163371)) **GitLab Enterprise Edition**
- [Web IDE update URL when ref changes](https://gitlab.com/gitlab-org/gitlab/-/commit/0703830523f53ec5bf28744174249232bb283389) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157320))
- [Fix icon and alignment of weight widget in sidebar when locked](https://gitlab.com/gitlab-org/gitlab/-/commit/749ec908e41164b059deb514a645c027049565e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162885)) **GitLab Enterprise Edition**
- [Fix issue when resizing images in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/cc50dc662098fe1375db43b42efb419fb111f0a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163382))
- [Disable pipeline must succeed setting for security policy project](https://gitlab.com/gitlab-org/gitlab/-/commit/9aa0c05815f440a0938a20385ce55032db0dfc2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162462)) **GitLab Enterprise Edition**
- [Fix sticky header on work items and legacy issuables](https://gitlab.com/gitlab-org/gitlab/-/commit/c87a638b83f6c8c96072be956a629798753d82d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163343))
- [Asana integration: only close Asana task if closing keyword is followed by asana taskId identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/8c44056f1d74f949178c23783c2543ac51ef824c) by @ivaneG ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162852))
- [Fix icon and alignment of epic widget in sidebar when locked](https://gitlab.com/gitlab-org/gitlab/-/commit/1951010f63dac307bb5f98d206def14e700a7f18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162888)) **GitLab Enterprise Edition**
- [Fix Git HTTP redirects not working with query parameter](https://gitlab.com/gitlab-org/gitlab/-/commit/54bbc490deb168bcc43ad1fffb3d3eb46af257f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163235))
- [Ensure discussion reply for linked comments has correct top padding](https://gitlab.com/gitlab-org/gitlab/-/commit/51034403e337fda92e450d74e75be055d011ccdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163226))
- [Fix gap between buttons in vulnerability report header](https://gitlab.com/gitlab-org/gitlab/-/commit/394d100b5fa4b0bbc846bc81d98dc4bfcedcc9e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163212)) **GitLab Enterprise Edition**
- [Require approvals for missing policy scans without target pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/03d349eab79052489f86e91b62fdc721f36cb2c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161905)) **GitLab Enterprise Edition**
- [MR header: Fix tooltip of copy branch name](https://gitlab.com/gitlab-org/gitlab/-/commit/7f1aa474a154434428f34eb4815cbe6cdaa8e046) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163197))
- [Use default number of participants in work item sidebar widget](https://gitlab.com/gitlab-org/gitlab/-/commit/5d8ad19654ca6ec160c90e9e6fef40225745d464) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163190))
- [Work items: Fix huge gap when not yet edited](https://gitlab.com/gitlab-org/gitlab/-/commit/06e2d9ef32f1bf288ba7216efe946538874a59e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163172))
- [Deleted `vulnerability_remediations` leave behind `uploads` records](https://gitlab.com/gitlab-org/gitlab/-/commit/11bf423c158d83beb3a210bf21968f797a26e8fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160579)) **GitLab Enterprise Edition**
- [Fix vulnerability report page activity docs](https://gitlab.com/gitlab-org/gitlab/-/commit/a27c7114971ffaad6decb6cf3c651d6bc7c2c264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163171)) **GitLab Enterprise Edition**
- [Author badges: Migrate non compliant badges](https://gitlab.com/gitlab-org/gitlab/-/commit/b73c21f0d76cb9d5466eff82bd313ed468b5849a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163139))
- [Fix a double-slash URL problem when MR URL ends with a trailing slash](https://gitlab.com/gitlab-org/gitlab/-/commit/17cf29e9e80533745a27b99d3ae27dba2f702786) by @yasuk ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163097))
- [Fix admin_mode enforcement in AdjournedGroupDeletionWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/2e75af6cc213c5f5f0ae6fdab54577d63b2fe48c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163071)) **GitLab Enterprise Edition**
- [Fix Go Back functionality for duo pro access denied](https://gitlab.com/gitlab-org/gitlab/-/commit/c5df15e71f6b39063b7bc84ed9c16544b3563536) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163044)) **GitLab Enterprise Edition**
- [Fix NoMethodError for blame](https://gitlab.com/gitlab-org/gitlab/-/commit/d0861e79410dc5b1c3801e69926aa048be4ee95b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163013))
- [Always target correct pipeline for cancel](https://gitlab.com/gitlab-org/gitlab/-/commit/7758c9a470b9f592b1c3a492bf77308be082c46d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162317))
- [Fix the bug that replica respect zoekt_enabled_namespace search](https://gitlab.com/gitlab-org/gitlab/-/commit/94470dda070013c93c1f5dd0cba29eff4044ed85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162879)) **GitLab Enterprise Edition**
- [Do not check for permissions when syncing children reordering](https://gitlab.com/gitlab-org/gitlab/-/commit/e09dfdc24449df86c75f947f4933faf2209ccf11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162875)) **GitLab Enterprise Edition**
- [Fix timeout when checking group dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/118a1125b6a15aab7d8a26f46c472582414aba87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162857)) **GitLab Enterprise Edition**
- [Workhorse: fix unix socket path too long](https://gitlab.com/gitlab-org/gitlab/-/commit/bf5bec58f49ce1d802038683b7692eb2873149f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162793))
- [Ensure levels is an array](https://gitlab.com/gitlab-org/gitlab/-/commit/a6ec49a4165a7f2a362a2b8eda4f637acf255db1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162796))
- [Fix: Geo Replication Details incorrectly empty](https://gitlab.com/gitlab-org/gitlab/-/commit/8181080e1aa5a3d835618f8b2d1798efdaee8843) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159666)) **GitLab Enterprise Edition**
- [Branch rule details: Fix spacing and make count optional](https://gitlab.com/gitlab-org/gitlab/-/commit/31cf0f715a640c41b072670171db1905d84854c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162576))
- [Fix vulnerabilities related issues widget](https://gitlab.com/gitlab-org/gitlab/-/commit/a45fb11a37bcb2a4ad8f08fcf59b4b8273b8fa43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162728)) **GitLab Enterprise Edition**
- [Update ee mutations specs](https://gitlab.com/gitlab-org/gitlab/-/commit/125a29d46ebcaa2ea62164fd1d9b081e14fc4854) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162574))
- [Load Participants seperately to speed up page load](https://gitlab.com/gitlab-org/gitlab/-/commit/cff52a1f4f7839f5d20f5fa450b7a616cfefd401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162641))
- [Fix 'e' shortcut triggering unexpected edits](https://gitlab.com/gitlab-org/gitlab/-/commit/a7fb170c32e137995c24c2526b882fd2afc6e9ec) by @salihudickson ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162637))
- [Turn NotFound from Gitaly into 404 for InfoRefs](https://gitlab.com/gitlab-org/gitlab/-/commit/168b06a7cbfcdb88bb3c2f751f33b26a3666f495) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162697))
- [Fix audit flow when audit_log feature is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/f0a50a960a1be6329c5ec4c5a6e580e0d0eced8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162013))
- [Set project_id when deploy tokens are created for Auto DevOps](https://gitlab.com/gitlab-org/gitlab/-/commit/fedf48004e6d64b642fae6d7a90d9add57ecdd45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162669))
- [Fix selected emoji award button style](https://gitlab.com/gitlab-org/gitlab/-/commit/7a7645757d3f12b78834b947adb8ed5637304dab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162620))
- [Remove invalid parents from the Commit object](https://gitlab.com/gitlab-org/gitlab/-/commit/1f02c45bb87c19b94296476d706014edf0638d97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162613))
- [Fix "Variable $refType of type RefType was provided invalid value"](https://gitlab.com/gitlab-org/gitlab/-/commit/5803620a9387a829c7c53e3d75a4584e49f0cea6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162596))
- [Fix "continue editing" sticky header z-index](https://gitlab.com/gitlab-org/gitlab/-/commit/108258393d6546e74062e4957e2725f7b5161e93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162595))
- [Update GitLab version in DELETE REST API docs for protected containers](https://gitlab.com/gitlab-org/gitlab/-/commit/fc99d5ca293501eec635397629dbe07cb90d07bc) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162561))
- [Fix license check for reordering work items](https://gitlab.com/gitlab-org/gitlab/-/commit/0f9d8f6f928486d8a3aa612befdd65acdaaeebe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162557)) **GitLab Enterprise Edition**
- [Fix upgrading to versions > 17.0 without upgrading to 17.0 first](https://gitlab.com/gitlab-org/gitlab/-/commit/8ee4d0a6d737aa8af90cdc5e36dfc1a86b50c155) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162551))
- [Fix inherited source filter for Pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/87bd7188c8f3172f5193ff60124351c644c01f10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162548)) **GitLab Enterprise Edition**
- [Fix loading child items that are also related](https://gitlab.com/gitlab-org/gitlab/-/commit/20493e4535edd84fe31a242bace41f820c75ed23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162545))
- [Update GitLab release version in Group REST API docs](https://gitlab.com/gitlab-org/gitlab/-/commit/31f4e061de225e5d8c58f0a264e03233aa830598) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162541))
- [Remove old finder not needed](https://gitlab.com/gitlab-org/gitlab/-/commit/1e0530dc98516dde08e883d3e1c89a3acec09b44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152556)) **GitLab Enterprise Edition**
- [Fix work item description quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/b8a475033a08c1374cfff7e25665b963e0260c18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162404))
- [Update shortcut hint in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/a79e1b9f17c388465a8b46a9c75d90d0145f6c74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162395))
- [Update graphql specs in prep for update](https://gitlab.com/gitlab-org/gitlab/-/commit/86c64725cef4752c4c3815b8ef6722c0e51de55a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162291))
- [Update container scanning for registry docs link](https://gitlab.com/gitlab-org/gitlab/-/commit/bc6aac87ba07995ddfdbed48fb7e55780fbafd74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162482))
- [Fix show SAML session expiration modal](https://gitlab.com/gitlab-org/gitlab/-/commit/1040281ecec0e26621e1ef42e091d2d0dea48dde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162464))
- [Add GLFM support in single editor preview](https://gitlab.com/gitlab-org/gitlab/-/commit/f5526eaa5c8c120312b7633c5b640720c39fe44f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162467))
- [Avoid errors from Analytics::DateFiller](https://gitlab.com/gitlab-org/gitlab/-/commit/3c09321a16ab160434d0e060e1ca8ed83bec3c06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162465))
- [Encode special characters in find file search](https://gitlab.com/gitlab-org/gitlab/-/commit/46ff0aee6480b9fb7b024efc866fd42e89f893fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162061))
- [Remove rules_exist_expand_globs_early feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/187efd411b6aa10b72e7fd36f0f6894a9c92d66a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160446))
- [Return 404 error when `ref_type` + `ref` combination is incorrect](https://gitlab.com/gitlab-org/gitlab/-/commit/e7a60893d48b3a23c0f953d5c3badf047f0f6e4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162206))
- [Migrate `.bold` to `.gl-font-bold` in HAML files](https://gitlab.com/gitlab-org/gitlab/-/commit/c4507a569f2e378aeef7ddc6fdf45edc8bbcd2a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162412))
- [Allow to edit files from a commit or tag with WebIDE](https://gitlab.com/gitlab-org/gitlab/-/commit/b312e68b220a037cd33a1ce1baa0328d770cf6cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161349))
- [Ensure service accounts for GitLab.com groups restricted during trial](https://gitlab.com/gitlab-org/gitlab/-/commit/44313418b399b222ea1d3746c8a2f2933425c46d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162229)) **GitLab Enterprise Edition**
- [Display newline changes in description diff](https://gitlab.com/gitlab-org/gitlab/-/commit/150340e79153bc3e20f229a913ea4588178734aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161427))

### Changed (249 changes)

- [Remove dast tables allow cross-joins](https://gitlab.com/gitlab-org/gitlab/-/commit/b46168c2cace4545414f70f8cac923bd16adafef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165507)) **GitLab Enterprise Edition**
- [Add dynamic concurrency limit for create pipeline worker](https://gitlab.com/gitlab-org/gitlab/-/commit/7ed63c56495158d5354ee67b1faa59b32595f840) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162339)) **GitLab Enterprise Edition**
- [Adjust error message on project not found for CI_JOB_TOKEN requests](https://gitlab.com/gitlab-org/gitlab/-/commit/eeb6bf247d32ebd1ebfc08d807bce702aabc6e13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163211))
- [Allow reporter+ to read analytics dashboards](https://gitlab.com/gitlab-org/gitlab/-/commit/ecb512b5725753fdea88397019c39ad092784427) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164930)) **GitLab Enterprise Edition**
- [Do not expire direct memberships in subgroups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/ec9369c622854359e369e3f6d486bf65e7249375) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165503))
- [Add border to board card](https://gitlab.com/gitlab-org/gitlab/-/commit/3bf39fb1a00e53219c923049137840a9a7f31cb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165567))
- [Add dropdown popover for empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/993de91a6c70d3ca4ab5f50294287a3c1370050a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165543)) **GitLab Enterprise Edition**
- [Enable summarize_notes_with_duo by default](https://gitlab.com/gitlab-org/gitlab/-/commit/bd8c0e165f67308a8ec5a6eb8539db698eb59c61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162122))
- [Update dependency auto-deploy-image to v2.104.0](https://gitlab.com/gitlab-org/gitlab/-/commit/290743a3dc7caed8a7df605ef192d66995bcf624) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165997))
- [Vulnerability Report: fix Jira error handling](https://gitlab.com/gitlab-org/gitlab/-/commit/8e07307177fd2b0a1857e17acfb2e5076b45d743) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165675)) **GitLab Enterprise Edition**
- [Update @gitlab/web-ide package version](https://gitlab.com/gitlab-org/gitlab/-/commit/8710879d874e6c84fe8abf8ea74eff828b5e1638) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165721))
- [Lighten block quote shadow color in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/31e1ddf7f89bdef148dd63fa52a7b40550511bf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165874))
- [Truncate p_ci_finished_build_ch_sync_events if ClickHouse unconfigured](https://gitlab.com/gitlab-org/gitlab/-/commit/d810110410a67e388aaa1e385e05c15d70688dd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164766)) **GitLab Enterprise Edition**
- [Handle orphaned zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/2a29296a2e85f335325cbcd3bddebeb1c5481f65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165576)) **GitLab Enterprise Edition**
- [Handle orphaned zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/ad93f7eea3b3b9dd6343ea36ab04341c42a7d40f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164222)) **GitLab Enterprise Edition**
- [Don't always set X-Gitlab-Duo-Seat-Count](https://gitlab.com/gitlab-org/gitlab/-/commit/7bc72c1c0be551aaa5224d3ad3761cbf4af4f4be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165625)) **GitLab Enterprise Edition**
- [Migrate "Abuse reports" empty result page to EmptyResult component](https://gitlab.com/gitlab-org/gitlab/-/commit/c2de0ab95bd8fd50916f15685495abcd341513e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165414))
- [Remove allow_cross_joins_across_databases](https://gitlab.com/gitlab-org/gitlab/-/commit/1e6df7764be2b5f0063d043ac405e1e2c37cda68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165496)) **GitLab Enterprise Edition**
- [Prefill policy editor using compliance pipelines migration params](https://gitlab.com/gitlab-org/gitlab/-/commit/aa6c55aaf818d0224f2501f6985ecf7d3dec0f7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164423)) **GitLab Enterprise Edition**
- [Set vulnerability_mr_links project id to lfk](https://gitlab.com/gitlab-org/gitlab/-/commit/4d2941ff4af3fd0d3944c498add042a4f389eb1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162606)) **GitLab Enterprise Edition**
- [Update Container Registry cleanup policies time format](https://gitlab.com/gitlab-org/gitlab/-/commit/683014ae5fd2318da617b8b1e6670037cc8cb323) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165770))
- [Added missing translations from GitLab UI](https://gitlab.com/gitlab-org/gitlab/-/commit/614041da6dac2c91f259cc3ab6080e6ffd9ed4de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165502))
- [Transition dast_pre_scan_verifications to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/f81a02cad28e94b39fc57037b05763b23f84d753) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165024)) **GitLab Enterprise Edition**
- [Deprecate legacy Geo Prometheus repository checks metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/6a8378ea5692926625988720f58a4a5d192afd53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164940)) **GitLab Enterprise Edition**
- [Remove legacy zoekt index code paths](https://gitlab.com/gitlab-org/gitlab/-/commit/d01d6ea9af24c4ba75a4c48a47964b9bc8c18dec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165575)) **GitLab Enterprise Edition**
- [Use small font for resolved text](https://gitlab.com/gitlab-org/gitlab/-/commit/370c98c6ae43ee7f268c64a31bd956f3a008dfb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165713))
- [Update fog-aws to v3.26.0](https://gitlab.com/gitlab-org/gitlab/-/commit/91747065a18db24bbf4d433be705a91f2a50e01d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165708))
- [This MR adds linked items dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/a3ba9c019d893e120e704557dcaa737bfdfe2a6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163998)) **GitLab Enterprise Edition**
- [Remove superfluous HTML length validation refs](https://gitlab.com/gitlab-org/gitlab/-/commit/b2474ed33dcd7a296b70c22f3e9887ef6cca4249) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165680))
- [Stop tracking noisy InvalidConstraintError in sentry](https://gitlab.com/gitlab-org/gitlab/-/commit/feae2d60536d09a92a87c18553cab6a1e043cdf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165087))
- [Update UI docs links in CI files](https://gitlab.com/gitlab-org/gitlab/-/commit/5266460b4961a476ec0824bb362be2500c6b5d1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164835))
- [Transition dast_profiles_pipelines to gitlab_sec schema](https://gitlab.com/gitlab-org/gitlab/-/commit/21ab4071ae15df7a4654ded78a0971b38086e2e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164605)) **GitLab Enterprise Edition**
- [Backfill `pipeline.project_id` to `dependency_list_export.project_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/15aeba7ed77d9b515df853d23fcd41db2932e175) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164399))
- [Invert and Disable temporarily DocumentationLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/e5f5dde5e626d4cdfc49ff3434458682f6e6ab5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164834))
- [Remove default organization_id from PAT](https://gitlab.com/gitlab-org/gitlab/-/commit/1ee2162090cfdfc3a6faffad0a3303c5e96a2138) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164312))
- [Delete inactive groups and projects access tokens after 30 days](https://gitlab.com/gitlab-org/gitlab/-/commit/a12d69dc6537ad3176c5f3b91600b135535c5019) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163461))
- [Deprecate compliance-pipeline fields in graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/c4e108b3ea9447ed2b1d788ca9ee2c8373cd65dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165610)) **GitLab Enterprise Edition**
- [Remove default value from raw_usage_data table](https://gitlab.com/gitlab-org/gitlab/-/commit/4ca7b145f9367379ef5a2cc6f165a05779b106c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164714))
- [AI impact analytics: Rename `Duo seats: Assigned and used` panel](https://gitlab.com/gitlab-org/gitlab/-/commit/da54d20f0726c99b517c90abd76a9263062241be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165362)) **GitLab Enterprise Edition**
- [Prevent line height from being forced into tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/95fe5cad6efda3d333b3c95dc44ceb523fd2cb2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165566))
- [Extract RewriteHistory logic into a service](https://gitlab.com/gitlab-org/gitlab/-/commit/ce6b582866df39912c32b3f01c7d4d95473250cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162312)) **GitLab Enterprise Edition**
- [Allow for attachments in Model and Model Version descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/7557eb1b05cf168ed55787b2e07db39cb51c1c8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163648))
- [Update @gitlab/web-ide package version](https://gitlab.com/gitlab-org/gitlab/-/commit/0642bc906dc702ba23035e5d8c99f71d6efc65c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163597))
- [Allow Conainer-Scanning to scan multiple containers in a pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/e8ec65473668126155842dd514013b59ae3d4158) by @Valkhof ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164468))
- [Enable callers of client.tags for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/ad85102dd31609bddc22b7ac6362f044ca2af407) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163857))
- [Remove -v2 from all system note classes](https://gitlab.com/gitlab-org/gitlab/-/commit/7ee38af7020f2b01d857d9d92c1c8f7d4b57408f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165372))
- [Add support for WorkItem embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/583f00dc5d1d48f7ac6d34f1c5f0a8cb07197eca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164059)) **GitLab Enterprise Edition**
- [Deprecate non-nullable `target` field on Todo type](https://gitlab.com/gitlab-org/gitlab/-/commit/6280baeb3ceb21c152938cdde3b61e176ef02628) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165487))
- [Limit value streams max size to prevent timeouts](https://gitlab.com/gitlab-org/gitlab/-/commit/88c8b8ede6546f01f8c831bf148a690f256a61da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165477))
- [Diff threads: Align toggle function with regular threads](https://gitlab.com/gitlab-org/gitlab/-/commit/205cc4bff46e2f99dde7ed68b7c10dc4916d6e4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165005))
- [Remove unused profile CSS, make activity line darker](https://gitlab.com/gitlab-org/gitlab/-/commit/95d82b42127d9f35a12131e127b5acded15edde0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165239))
- [Update fog-aws to v3.25.0](https://gitlab.com/gitlab-org/gitlab/-/commit/0db1ee6cbfc4a780f0d749152418a9d87351dd2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164424))
- [Add organization id to topics](https://gitlab.com/gitlab-org/gitlab/-/commit/f5eaa3048749dd063483c8e823407dcb9ceb52a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163410))
- [Update dependency auto-deploy-image to v2.103.0](https://gitlab.com/gitlab-org/gitlab/-/commit/38f412d40708d8d906a75940aa06c7e36922c02b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165426))
- [Simplify container registry feature spec](https://gitlab.com/gitlab-org/gitlab/-/commit/b369746857dbe8f42fd64b5b9a2441034bbde6ba) by @sahilsarawagi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164647))
- [Added support for skip_authorization](https://gitlab.com/gitlab-org/gitlab/-/commit/61ae664183780eeff4d2e99be07b59751666e108) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164874)) **GitLab Enterprise Edition**
- [This MR adds linked items dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e728b9e088dd06cd819e5cc8769938dc3472e318) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164946)) **GitLab Enterprise Edition**
- [Update Topic empty states](https://gitlab.com/gitlab-org/gitlab/-/commit/a7dc92224d7bf2386006a016a28edaa95471dbaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165388))
- [Add requested changes and merge to relevant MR activity filters](https://gitlab.com/gitlab-org/gitlab/-/commit/f75e467970174988f960d621d91294cf365f9b1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165233))
- [Clarify when approval policy targets unprotected default branch](https://gitlab.com/gitlab-org/gitlab/-/commit/52be5734c665349515404467b6ec3a54bcd6dfcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164232)) **GitLab Enterprise Edition**
- [Transition dast_site_profile_secret_variables to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/a7d4d6ca0ec6ce9979ac24fda4a99ead49cde3ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163931)) **GitLab Enterprise Edition**
- [Implement checking ref when rendering CI Config blob page](https://gitlab.com/gitlab-org/gitlab/-/commit/ee60ba9d47903c362f1e76b509c9312a10e2d511) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165161))
- [Concurrency limit: allow pausing workers](https://gitlab.com/gitlab-org/gitlab/-/commit/f15f110a0472c4f3eb6561b5a1a59f0aeaa3e1cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165218))
- [Migrate linked resources to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/eb0930d7b99230af028ef5e92b6c899c703f9b92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165323))
- [Remove sharding_key_config for ml_candidate_](https://gitlab.com/gitlab-org/gitlab/-/commit/38a1a7e175cd876fe054a0fb47a2483cf7548961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164759))
- [Adjust DeployKeyItem to data it should receive](https://gitlab.com/gitlab-org/gitlab/-/commit/632976e284ac4355998dd4fcd877bedee218699d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163767))
- [Move timezone selection position in the pipeline schedule form](https://gitlab.com/gitlab-org/gitlab/-/commit/d973d96dffae5e23b958ceb7436a71643c135e76) by @wilsonpinto ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164569))
- [Limit scan execution policy actions to 8](https://gitlab.com/gitlab-org/gitlab/-/commit/703fa5c167d1612ef09a0feef6fa5292d5bfeca7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146760)) **GitLab Enterprise Edition**
- [UI polish the GitLab Duo cards](https://gitlab.com/gitlab-org/gitlab/-/commit/3221c275ecac95f03f535523e8ed794060151288) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163496)) **GitLab Enterprise Edition**
- [Guard editing of branch protection](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c3bd63d99b357c5482379b6828f63533369aaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165192))
- [MR widget: Use regular chevron icons](https://gitlab.com/gitlab-org/gitlab/-/commit/9c36394fa33b881c717d42cd05bde815597d16a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164774))
- [Update GitLab Workhorse to AWS SDK for Go v2](https://gitlab.com/gitlab-org/gitlab/-/commit/4ec5806963c8a6323890d917df8dfa6896476a8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164597))
- [Add slim health status mode](https://gitlab.com/gitlab-org/gitlab/-/commit/88d447763f7e8ac8e3ff350aaa86a95592de663e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164521)) **GitLab Enterprise Edition**
- [Add callout in the admin area about OpenSSL v3](https://gitlab.com/gitlab-org/gitlab/-/commit/f732a69ac0fe31c2de5ceb224b9bee2bb9b63395) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164512))
- [Hide health status on child items when closed](https://gitlab.com/gitlab-org/gitlab/-/commit/485ee68967f6254d134b2fc0939260b55c925782) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164717)) **GitLab Enterprise Edition**
- [Translate severity count limit](https://gitlab.com/gitlab-org/gitlab/-/commit/4aec9d6ac3668f2846faf077e10c2999825ef501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164920)) **GitLab Enterprise Edition**
- [Fix design inconsistencies in work items child/linked widget item metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/a1de933872fa8eaaafc0e4be2d81da6fdd974777) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164957))
- [Add cached markdown fields for Model Registry](https://gitlab.com/gitlab-org/gitlab/-/commit/25289309ef1ae2151c3c058defa06f616ed378e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163762))
- [Resend email verification code if the current code has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/f07d82bfda1735d4840fc54d51208d0188fa1712) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164281))
- [Add optional ref parameter to Contributors API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/c238ef215ab4d92b088052f8682d8c00c613893d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156852))
- [Use white bg for light highlight theme gutter](https://gitlab.com/gitlab-org/gitlab/-/commit/414bafb6caa6477625161f56fa23fc84bb2318fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165070))
- [Avatar: Refactor to use gl-avatar](https://gitlab.com/gitlab-org/gitlab/-/commit/b10671541ce95966fca5a1a31019badd275b7d70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163899))
- [Jira Cloud app only editable via API when active](https://gitlab.com/gitlab-org/gitlab/-/commit/2e1afca583e851bb8dc057db0a1c821d2a8ecc68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163702))
- [Increase model registry description text limits](https://gitlab.com/gitlab-org/gitlab/-/commit/8346b894228ceb2878b9ed1d060e4b11d8579264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163964))
- [Updating features to be uppercase](https://gitlab.com/gitlab-org/gitlab/-/commit/1c096002980b7e19c04538e9b82f6f149ca6af36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164391)) **GitLab Enterprise Edition**
- [refactor conan api to have V1 version](https://gitlab.com/gitlab-org/gitlab/-/commit/7bbf66804d10b26184f5648c6bc99c61d6056076) by @ScanianJP ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164475)) **GitLab Enterprise Edition**
- [Exclude add-on purchases from active that are expiring today](https://gitlab.com/gitlab-org/gitlab/-/commit/e5d1907d102bed3d7df51dce378309b887018ad1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164483)) **GitLab Enterprise Edition**
- [Update container scanning for registry config](https://gitlab.com/gitlab-org/gitlab/-/commit/f7f7bc93e473eade574a81e464c1fd388734deb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164236)) **GitLab Enterprise Edition**
- [Remember user preference for showing labels on work item widgets](https://gitlab.com/gitlab-org/gitlab/-/commit/3d9e1e26c93f9ef61a1c5abf9b05333925e820fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163814))
- [Validate and replace the fk referencing p_ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/16f15d27eb42d2961f2649036f06a94393e440ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164294))
- [Add priority_searchable concern to select search type](https://gitlab.com/gitlab-org/gitlab/-/commit/098d972894f3495c50bf679d177e9ddd59ee770d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162838)) **GitLab Enterprise Edition**
- [Use more info for license add-on provisioning](https://gitlab.com/gitlab-org/gitlab/-/commit/7990d50b13e5fef11d933515eccb11a6d928f68a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164346)) **GitLab Enterprise Edition**
- [Remove `security_report_schemas_rubygem` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/670a27f398611e5abe695b735ade07cd1c799ddb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164868))
- [Add zoekt_cpu_to_tasks_ratio to Zoekt](https://gitlab.com/gitlab-org/gitlab/-/commit/e45417e3f46f3eea88839dcc52cc55bc371042e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164496)) **GitLab Enterprise Edition**
- [Transition dast_site_profiles to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/d1aad2d9f14cf64bce46b30bb3551bd8fde9e961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163154)) **GitLab Enterprise Edition**
- [Handle issue references when project is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/c0034b01a6612c4cc6f630671c108551b2073bc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164737)) **GitLab Enterprise Edition**
- [Remove description and diff from descriptionVersion](https://gitlab.com/gitlab-org/gitlab/-/commit/2f6c30c3d7c39699bf90d3b2bb6f21ab076fd10c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164722))
- [Improve GQL query for fetching groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/77713bf2ec1ccf4c405cfcd7ac4fa8ffaa94b848) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164469))
- [Seperates banners from alerts](https://gitlab.com/gitlab-org/gitlab/-/commit/edc0dbfd7b671eaeb3817515988ddf2d551142b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163612))
- [Move shared note styles into new file](https://gitlab.com/gitlab-org/gitlab/-/commit/b15f4b5e8913719de1f38d47b408535541290dad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164293))
- [Increase default child items batch size to 50](https://gitlab.com/gitlab-org/gitlab/-/commit/e4cc54567051a9b28deffa2292bfc75ee8c4b2a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164551))
- [Don't show Terms and privacy on SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/b17ab02ae04bd7213217659a770c1cb1ba53fcbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164545))
- [Adjust private vizibility description](https://gitlab.com/gitlab-org/gitlab/-/commit/01c1b72ffdb2c7e8cb5f25b0008963f4e521fa2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164046))
- [Expose ETag header of API requests to XHR requests](https://gitlab.com/gitlab-org/gitlab/-/commit/64b9d0f6c0769353ed5f409061a8d1663643b28c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164447))
- [Add missing variables to Policy Editor UI](https://gitlab.com/gitlab-org/gitlab/-/commit/753f054265c449de6637f56703f0b41f6a2c46da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164490)) **GitLab Enterprise Edition**
- [Add illustration to search result empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/08ef528e3f0913799dee163be2af30648cf517fb) by @jimender2 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163849))
- [Updating feature name to be uppercase](https://gitlab.com/gitlab-org/gitlab/-/commit/5e54529e0796408823dfe4c3f105688859bd7392) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164397))
- [This MR adds link option](https://gitlab.com/gitlab-org/gitlab/-/commit/c16dd4d4fa15b9f8953c3affd802a226d80356c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164225)) **GitLab Enterprise Edition**
- [This MR updates wording for group policy scope](https://gitlab.com/gitlab-org/gitlab/-/commit/fff851431984f26cd04733e5dde74e70357ec6ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164413)) **GitLab Enterprise Edition**
- [It raises an error on migration exhaustion](https://gitlab.com/gitlab-org/gitlab/-/commit/db10875a73db316fd8a49a9df5df207e29f4b716) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164240))
- [Add priority_searchable concern to select search type](https://gitlab.com/gitlab-org/gitlab/-/commit/c329499bc66ab290dd7fcb8b526afabb108057c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161999)) **GitLab Enterprise Edition**
- [Avoid gitaly calls when evaluating `exists` conditional](https://gitlab.com/gitlab-org/gitlab/-/commit/23d59c5693eb16f98a861f49a0b963c94a2d797e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162741))
- [Migrate explain_vulnerability to AIGW](https://gitlab.com/gitlab-org/gitlab/-/commit/c4362c0a37a1a9b4f3fb06cbbfdb9d992ad4188b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164210)) **GitLab Enterprise Edition**
- [Rollout the zoekt_tasks_processing_state FF](https://gitlab.com/gitlab-org/gitlab/-/commit/47717d6c212f1c504b177c57fc24a48717c70810) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164323)) **GitLab Enterprise Edition**
- [Cleanup the duo_pro_trial_expired_widget ff](https://gitlab.com/gitlab-org/gitlab/-/commit/e41542a46cd24c9a8603b7588575c9c9325e272b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164316)) **GitLab Enterprise Edition**
- [Set vulnerability_mr_links project id to lfk](https://gitlab.com/gitlab-org/gitlab/-/commit/e2cb38b86854eba8b12c4a5c496029f72a2025b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162605)) **GitLab Enterprise Edition**
- [Decompose vulnerability_occurrence_identifiers to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/b9f7c227ee247fdbea85a78e758f2fac2292da50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162604)) **GitLab Enterprise Edition**
- [Add group scope option for policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/635f059f96cfbfcb84b261331497e861130c7f30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162502)) **GitLab Enterprise Edition**
- [Notes: Change visual order of replies](https://gitlab.com/gitlab-org/gitlab/-/commit/74fad344572a65680f02491b4f63af9aaaa3dfc0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162877))
- [Change button appearance](https://gitlab.com/gitlab-org/gitlab/-/commit/42060a9d0bfcc96aec85a757cccc4757998a6a6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164217)) **GitLab Enterprise Edition**
- [Refactor draft notes CSS](https://gitlab.com/gitlab-org/gitlab/-/commit/67f90d8bef35913cc5b3a2f3bf284b0e117a7c6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163676))
- [Legacy license support for GitLab Duo](https://gitlab.com/gitlab-org/gitlab/-/commit/2ef3ffc566e6a15d3d6be2562a65c2193b494d7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163327)) **GitLab Enterprise Edition**
- [Allow files with spaces in their names for model registry](https://gitlab.com/gitlab-org/gitlab/-/commit/f3ea92efc67db06863133db7a63622f797e16110) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164162))
- [Adds filter empty state to milestone list](https://gitlab.com/gitlab-org/gitlab/-/commit/645c7b2c7ab1f2d881df9dfead56284cd34d7e69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164157))
- [Decouple OccurrencesVulnerabilities & vulnerability_finding_pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/f29fef138a4c792c8d802f2c878634c352e65926) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163877)) **GitLab Enterprise Edition**
- [Update job item styling](https://gitlab.com/gitlab-org/gitlab/-/commit/3b5ba0967c0d2e464c6ad7c8521f16364f96282c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164273))
- [Migrate remote_development_agent_configs table](https://gitlab.com/gitlab-org/gitlab/-/commit/e0471d56761b5468ec3e4b8b98233fa4f5218e3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163846))
- [GraphQL: Update merge train fields](https://gitlab.com/gitlab-org/gitlab/-/commit/6cca476dfd4e8791331903f99ec6b58e589b15a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162747)) **GitLab Enterprise Edition**
- [Update fog-aws to v3.24.0](https://gitlab.com/gitlab-org/gitlab/-/commit/6c82d5c142165517e09c766f70d82ccafcba4cf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158814))
- [Add migration to backfill project_id to security_scans](https://gitlab.com/gitlab-org/gitlab/-/commit/5e9d7e4a76772c54f4fd3d0d408c2064b6f4e68f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164110))
- [Remove expensive guard clause for callout reset](https://gitlab.com/gitlab-org/gitlab/-/commit/958b3418bd3cc8b7d580d354d6e1d680d608eb7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163774)) **GitLab Enterprise Edition**
- [Update gpgme to v2.0.24](https://gitlab.com/gitlab-org/gitlab/-/commit/5ef04e3e84107a9473867198cbcb69c15e077c61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164107))
- [Deploy keys: Migrate empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/2015f06a130f2fb5b639dce79cd030a9124031ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163464))
- [Current user: Change text color to orange to match system notes](https://gitlab.com/gitlab-org/gitlab/-/commit/a626e7f4a7823b27dcbe4f7df513458e387dc3ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163917))
- [Decompose vulnerability_remediations to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/1293bcb939b78c73c672e04174174a9f8a1d9cd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162602)) **GitLab Enterprise Edition**
- [Enable GraphQL Pipeline Security Tab by default](https://gitlab.com/gitlab-org/gitlab/-/commit/278a83d39eea9e6916b38de1f879e48e8eaeca74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163473)) **GitLab Enterprise Edition**
- [Swap out container scanning for registry card](https://gitlab.com/gitlab-org/gitlab/-/commit/e119ea82481f5d3b24093ab2124bdc0b5d803e98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161126))
- [Match the order from REST stage api to GQL stage api](https://gitlab.com/gitlab-org/gitlab/-/commit/90eb48d442da71accc1ff07ffd7241bf4fc1032c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162265))
- [Transition dast_site_profiles_builds to gitlab_sec schema](https://gitlab.com/gitlab-org/gitlab/-/commit/55a9334d364cd587b5cb8764d32ba88d25017d7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161993)) **GitLab Enterprise Edition**
- [Support expected_old_oid in user_commit_files](https://gitlab.com/gitlab-org/gitlab/-/commit/9f6789b08626c22fa917d3211da163c0de84b692) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161981))
- [Add frontend validations for seat controls user cap option](https://gitlab.com/gitlab-org/gitlab/-/commit/f47448af29714e98fefafb326b8b7cffd4107589) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162794)) **GitLab Enterprise Edition**
- [Revert "Improve GQL query for fetching groups and projects"](https://gitlab.com/gitlab-org/gitlab/-/commit/1a6248e757a4b8b4df72754e42346004370e3918) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164019))
- [Scope i18n strings that are incorrectly unscoped](https://gitlab.com/gitlab-org/gitlab/-/commit/73417dec62b1e7926fb597a30ed4087bd32908fc) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164007))
- [This MR fixes layout issues](https://gitlab.com/gitlab-org/gitlab/-/commit/105b611382cf47fd987cc405536de45b8957d49d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162992)) **GitLab Enterprise Edition**
- [Enable post_receive_sync_refresh_cache feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/2a7022d8c7daf543dc289885f60c27d629fa87ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163973))
- [Restrict zoekt indices from having cascade deletes](https://gitlab.com/gitlab-org/gitlab/-/commit/4db92ccbea6243539175f0db63a32049c42292e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163253))
- [Decompose vulnerability_occurrence pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/95bae9a8ea25b347fcff7fac9a475bd8c48abd77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162603)) **GitLab Enterprise Edition**
- [Remove unused DESCRIPTION_HTML_LENGTH_MAX](https://gitlab.com/gitlab-org/gitlab/-/commit/3e9c58b62b9212f508ac74c85ff2256ded8437d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163982))
- [GitLab Duo Health Check - Collapsable status](https://gitlab.com/gitlab-org/gitlab/-/commit/6cb0aabbab0a9a1585979afacec62a64a9e91671) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163064)) **GitLab Enterprise Edition**
- [Set detumbled_email address before saving emails](https://gitlab.com/gitlab-org/gitlab/-/commit/9e7addbccd9c0a764f9e38e8034221752dd9d7fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163556))
- [Remove legend values from DORA Performers Score chart](https://gitlab.com/gitlab-org/gitlab/-/commit/9b9adb6b344da262bfe9ab416f4129ab0a56780a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162904)) **GitLab Enterprise Edition**
- [Cleanup bigint conversions for packages_build_infos](https://gitlab.com/gitlab-org/gitlab/-/commit/2811d35b8bb6936a6bcfadf848f3e9745d2e750d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163842))
- [Secondary email removal: Use tertiary button with trash icon](https://gitlab.com/gitlab-org/gitlab/-/commit/5d426a4ae70ec81c673822a18640c05495aa529f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163910))
- [Broaden the scope of lazyLoader](https://gitlab.com/gitlab-org/gitlab/-/commit/f5f18829d55cc1a29e5e8fcc76c0258507ec8543) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163894))
- [Rollout focusin feature in Dropdowns](https://gitlab.com/gitlab-org/gitlab/-/commit/f92b1a95931bf0b0d020cde68261b09df20af725) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163347))
- [Refactor CI Icons to be independent from GlBadge](https://gitlab.com/gitlab-org/gitlab/-/commit/4e977f4947a9c5a5a796ce81adde57ed27af4d21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163330))
- [Fix Layout/SpaceInLambdaLiteral offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/74a9f535486b96c4d374250abd2f3c49e474983e) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163858))
- [Add loading row to pipelines table](https://gitlab.com/gitlab-org/gitlab/-/commit/e17bb9ac1e9c57751eb7a54974ffee7eb05e83e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163551))
- [Emphasize highlights that have vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/fbfb1a8e4f814ad838d4d57c857d24c71f6f8885) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163719)) **GitLab Enterprise Edition**
- [Update design for vulnerability groups](https://gitlab.com/gitlab-org/gitlab/-/commit/7e9b74184857aa4fd6fb8478c6d1113ff02938b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163176)) **GitLab Enterprise Edition**
- [Added unique index to import_source_users](https://gitlab.com/gitlab-org/gitlab/-/commit/cb16e95fcc9f728561f60b6828278ccd82bfd54b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162619))
- [Adds support for permalinks from description in Work Items](https://gitlab.com/gitlab-org/gitlab/-/commit/21ae769bcee089180b249af0c46135d1d553ca64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163559))
- [Decreases lock timeout for sliding list partition strategy](https://gitlab.com/gitlab-org/gitlab/-/commit/047884c4f47be1b4ae360ba9ade3036a3690855b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162590))
- [Use new CSS file for work items system notes](https://gitlab.com/gitlab-org/gitlab/-/commit/b99134beb53b84cda06599863e830ad0be130b30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163663))
- [Update schema to classify clusterwide table](https://gitlab.com/gitlab-org/gitlab/-/commit/d7f81a8ea4931c6da558d3a4084db0974a581ab1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162258))
- [Rewrite system note CSS](https://gitlab.com/gitlab-org/gitlab/-/commit/79fd82c0550b3bc181803bb693f5719e547a2602) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162639))
- [Remove search_query_milestone_builder feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c8b9d8e8bbfca516ec42b57c17d4368f65c5ea8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163356)) **GitLab Enterprise Edition**
- [Update duo pro docs for GDK setup](https://gitlab.com/gitlab-org/gitlab/-/commit/2b85b1de96a02c3f7b6f7ec73238c321d89c25c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163626))
- [Migrate Operations dashboard cards](https://gitlab.com/gitlab-org/gitlab/-/commit/ac0782f91ecdd8492d986cdd9306901bbcb71f21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163004))
- [Change model used in git_command LLM endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/764d57e6078ef65dea5210a0c531acc6b97ef628) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163438)) **GitLab Enterprise Edition**
- [Rollout FF packages_dependency_proxy_pass_token_to_policy](https://gitlab.com/gitlab-org/gitlab/-/commit/a6a089e2d66e67cf7b4952699a5ac8cb34f49a50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147316))
- [Improve source column of membership table](https://gitlab.com/gitlab-org/gitlab/-/commit/b902a87821149b5bc0f61dd15a9fbd0fac90cb25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150545))
- [Subscription table: Migrate to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/57fd350874d1a395af812d92af2bb2edc451f1f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163463)) **GitLab Enterprise Edition**
- [Allow configuring Duo Workflow Service URL in config/gitlab.yml](https://gitlab.com/gitlab-org/gitlab/-/commit/f96313ad50cee945d14135e73079c0e1d52d3f3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163565))
- [Modifying summarize tool to use claude 3](https://gitlab.com/gitlab-org/gitlab/-/commit/12d678a6b67862908247f5f3b670961b4de7a64c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151392)) **GitLab Enterprise Edition**
- [Makes dashboard titles more general](https://gitlab.com/gitlab-org/gitlab/-/commit/19feb1521ea0a25bed2c0eaa28955b2e160d4b00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162457))
- [Merge branch...](https://gitlab.com/gitlab-org/gitlab/-/commit/20544e9c1a5afc671b1034fb18d09fdb28793d90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162792))
- [MS Teams update MessageCard format to adaptive](https://gitlab.com/gitlab-org/gitlab/-/commit/2a7b4d8a2aba4f184da7ff1cc9f11dc7ec79dc53) by @ivaneG ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162792))
- [Transition dast_site_s to gitlab_sec schema](https://gitlab.com/gitlab-org/gitlab/-/commit/846a9dccec7d3f91e10da066d481df86a5e3d650) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161607)) **GitLab Enterprise Edition**
- [Hide Reset if integration not manually enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/b177b6941b2ebf23ecd63130f48bc9b20d9fd71a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162345))
- [Secrets table: Migrate to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/dc18d5bc12b3249ff0c93a25e23d84796aad4601) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163459)) **GitLab Enterprise Edition**
- [Migrate WriteTests tool](https://gitlab.com/gitlab-org/gitlab/-/commit/93b37dddfbdf5fa53df1648f14ba2b4302e5222b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163449)) **GitLab Enterprise Edition**
- [Display current user's username in email verification page](https://gitlab.com/gitlab-org/gitlab/-/commit/cf89169a8b9a3cdfd200aefc7923de6f7ca2beac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163439))
- [Fix date flex wrapper for smaller breakpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/c8fce9340ebe76eac108ecb372106fac5164f61e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163157))
- [Update labelling of empty MR approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/c5472898320fc1536a4c93905e255608b9f84b50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162020)) **GitLab Enterprise Edition**
- [Add post trial ctas to duo pro usage tab](https://gitlab.com/gitlab-org/gitlab/-/commit/7f40f1af50907499bcf2875476dc12de73590661) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162907)) **GitLab Enterprise Edition**
- [Tabs: Active item badge adjustment](https://gitlab.com/gitlab-org/gitlab/-/commit/26677b15b0327b27572bf42e03fdef532c21dd7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163145))
- [Zoekt: Switch to tasks API by default](https://gitlab.com/gitlab-org/gitlab/-/commit/74b7c29b06cdf3b437157fdc10b70cee1f3e532e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163320)) **GitLab Enterprise Edition**
- [Swap primary key for ci_pipelines to include partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c9586d0e70b63cd3c596c2f5d7a03018f8133512) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162531))
- [Remove zoekt_new_concurrency_limit_logic FF](https://gitlab.com/gitlab-org/gitlab/-/commit/264e197ecdefc59fc4101df78832e0fb26c2c690) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163319)) **GitLab Enterprise Edition**
- [Read security report schemas from RubyGem](https://gitlab.com/gitlab-org/gitlab/-/commit/3db232ca3000c823f4a875c0b7497d43440d738e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158598))
- [Add multiple frameworks filter](https://gitlab.com/gitlab-org/gitlab/-/commit/8f3ddfd3cbc64af6af1b78cde14cd738572036e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161931)) **GitLab Enterprise Edition**
- [Add zoekt processing queue monitoring metric](https://gitlab.com/gitlab-org/gitlab/-/commit/db927a29a4fac6f16b693cda5c9a106d80c8d056) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163229)) **GitLab Enterprise Edition**
- [Remove explain_vulnerability_tool feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/07d8edbfe4be3fb9094dd66fc5b57149aac57bbb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162536)) **GitLab Enterprise Edition**
- [Configure LFK for vulnerability_statistics.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/d3e724bdb0bd0efd03c68fb99e19baecbc53b62b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162601)) **GitLab Enterprise Edition**
- [Update code generation libraries prompt](https://gitlab.com/gitlab-org/gitlab/-/commit/aed9637774a25282fe8fd0782e01b13b513b4fec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163209))
- [Enable web_ide_oauth flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/a76835373b3ef036787bf5035280fdd57e4b8694) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163181))
- [Set vulnerability_finding_evidences to `gitlab_sec` schema](https://gitlab.com/gitlab-org/gitlab/-/commit/db42e15ffc530a194511b98f2f0c085335d1c4bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159120)) **GitLab Enterprise Edition**
- [Update GitLab Duo Chat icon](https://gitlab.com/gitlab-org/gitlab/-/commit/0fd917bad089d3359bb9de0596731daa7b838b35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163080)) **GitLab Enterprise Edition**
- [Remove activity border in work items](https://gitlab.com/gitlab-org/gitlab/-/commit/cda8d9a075e6971105ec974f259d8179b9ea0d29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163073))
- [Allow changing child items batch size via query param](https://gitlab.com/gitlab-org/gitlab/-/commit/f3f8c2308da5d92b72fbe1da28a810115b6e7d8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163072))
- [Split subtitle logic on GitLab Duo page](https://gitlab.com/gitlab-org/gitlab/-/commit/fd748f69ce887535ac6596ebe562fc2d244658f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162761)) **GitLab Enterprise Edition**
- [Filtering projects by all compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/9138bcf319d91d5586342ccc37fc9a1f6dd43294) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161766)) **GitLab Enterprise Edition**
- [Replace work_item_iid query param with show](https://gitlab.com/gitlab-org/gitlab/-/commit/92b313294c9f7966217b5c7e7fc0fcabcb334d13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162437))
- [Update dependency auto-deploy-image to v2.102.0](https://gitlab.com/gitlab-org/gitlab/-/commit/539e04399a45a109c592139e375d29121c3151c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163038))
- [Adjust model names to map the exact model names](https://gitlab.com/gitlab-org/gitlab/-/commit/d6c2348c15dd52cff51ba6bc0ea23d2712c41dbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161023)) **GitLab Enterprise Edition**
- [Change style and text of primary button in pipeline edit modal](https://gitlab.com/gitlab-org/gitlab/-/commit/c733cc7ac52ff3e1ed5aec09f173891722c83081) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162980))
- [feat: Set vulnerability_scanners to gitlab_sec schema](https://gitlab.com/gitlab-org/gitlab/-/commit/d60077df92c14511f5b77fb459611043c7f6c0fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161253)) **GitLab Enterprise Edition**
- [Remove extra whitespace after placeholder in i18n text](https://gitlab.com/gitlab-org/gitlab/-/commit/479b83030589b9b109305f64f70e09e0499e08d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162979)) **GitLab Enterprise Edition**
- [Remove v12p1 elastic files](https://gitlab.com/gitlab-org/gitlab/-/commit/7f2a8c9654cc4edb9b44801b8e4f0a90341b1911) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162861)) **GitLab Enterprise Edition**
- [Clear new_user_signups_cap when seat_control is not user_cap](https://gitlab.com/gitlab-org/gitlab/-/commit/4516407bbd2f470070633536aa2531114c14447c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162751)) **GitLab Enterprise Edition**
- [Update super sidebar theme styles](https://gitlab.com/gitlab-org/gitlab/-/commit/7cff85887276907ff05c2023a2ee344f52140176) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162251))
- [Migrate RefactorCode tool to AIGW](https://gitlab.com/gitlab-org/gitlab/-/commit/769824949ebcde491644c28b6df958ce94a79cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162716)) **GitLab Enterprise Edition**
- [Send language server version in AI gateway requests](https://gitlab.com/gitlab-org/gitlab/-/commit/acb01ae355e2e4fb0b4d81ddb8460d6e51aa28e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162854)) **GitLab Enterprise Edition**
- [Remove feature flag locked_lfs_files_mergeability_check](https://gitlab.com/gitlab-org/gitlab/-/commit/2983ff13982333c5c374e4013eaa9a965160f61e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162886))
- [Update self-managed product analytics onboarding flow](https://gitlab.com/gitlab-org/gitlab/-/commit/476a75f7915674573e3ac48b63cf59aba886a976) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153625)) **GitLab Enterprise Edition**
- [Related issues: Migrate to use crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/5be8f5f1592849e6698eb051b93cc22eae77c429) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161791))
- [Update CI_JOB_TOKEN error message on git repository requests](https://gitlab.com/gitlab-org/gitlab/-/commit/ef8547ac0b6a81a0421b106801c760cc15ba7d13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161795))
- [Moved epic assignees to work_items_beta FF](https://gitlab.com/gitlab-org/gitlab/-/commit/bf814a55d86a37efba019ac7eed4dfc493e69636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162819)) **GitLab Enterprise Edition**
- [Requeue resolve vulnerabilities migration](https://gitlab.com/gitlab-org/gitlab/-/commit/d1a42536bef642e40aa2de3b7f75f158f13418cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162691))
- [Update dependency auto-deploy-image to v2.101.0](https://gitlab.com/gitlab-org/gitlab/-/commit/1c56e35b5a540e6a7641034f8352c1bbf5181c09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162808))
- [This MR fixes initial user selection](https://gitlab.com/gitlab-org/gitlab/-/commit/841e49c31d6269392aefe9e44218b9e3a5e3870a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162776)) **GitLab Enterprise Edition**
- [PA UX Papercuts 17.4](https://gitlab.com/gitlab-org/gitlab/-/commit/d42ced6bde887b1f863f8b8e9375f3fd0d1695fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162220))
- [Mass permit expected foreign keys during decomposition process](https://gitlab.com/gitlab-org/gitlab/-/commit/58073cf4349b4af3d738eb688f5290dc1db3c600) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162726))
- [Set vulnerability_finding_signatures schema to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/b4fc07927be31a9ba5330bac6abfd94b0735c2d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159116)) **GitLab Enterprise Edition**
- [Move framework button to the top](https://gitlab.com/gitlab-org/gitlab/-/commit/4ab92ad46dcb90a04d8cd109da7c8dc3bf464dcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162609)) **GitLab Enterprise Edition**
- [Add View Details button to the popup](https://gitlab.com/gitlab-org/gitlab/-/commit/632495de0c70b7766469fd0f20d6c8aae8b5b5d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162414)) **GitLab Enterprise Edition**
- [Use /epics path for epic work items](https://gitlab.com/gitlab-org/gitlab/-/commit/0681c34519dc3a346a194adf5f524dea1401979c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162562)) **GitLab Enterprise Edition**
- [Add up and down votes to the work items list page](https://gitlab.com/gitlab-org/gitlab/-/commit/bcbb9ed2c203865f3c767c068ded727ec59d4dac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161366))
- [Remove ignore rules related to loose FKs for ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/6ef8ab8cac3b38cfe0899479209db5f0b11cd96b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162674))
- [Use `Months` layout and `This year` timeframe for scoped roadmap](https://gitlab.com/gitlab-org/gitlab/-/commit/742a5a37bb17448c688db51acfb68bf18452bb23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162656)) **GitLab Enterprise Edition**
- [Transition sbom_occurrences to the gitlab_sec schema](https://gitlab.com/gitlab-org/gitlab/-/commit/9e2bfff4c20b0b7b4772f829706d63d026b9a672) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158071)) **GitLab Enterprise Edition**
- [Adding not-null constraint on project_id for ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/2d90a85d9b85438b23f2b2c4a7970f5ab9b43d5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162638))
- [Switch Group Settings UI from User Cap to Seat Controls](https://gitlab.com/gitlab-org/gitlab/-/commit/8dcb0fe8c9b40effda5fd09f505fcedd8b91fb42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161368)) **GitLab Enterprise Edition**
- [Removing experimental RCA feature](https://gitlab.com/gitlab-org/gitlab/-/commit/5a2dbfb90a34e2f447c06cebac82f227ecb70e53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162489)) **GitLab Enterprise Edition**
- [Unbox Duo seat assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/73a8ca10bb02ef53aa24761a76be46fac1b8c335) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162434)) **GitLab Enterprise Edition**
- [Use quarters layout and three years timeframe for scoped roadmap](https://gitlab.com/gitlab-org/gitlab/-/commit/eb506b37bc809ec9e38477effe154d57c16d96a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162510)) **GitLab Enterprise Edition**
- [Remove new-card classes from other instances](https://gitlab.com/gitlab-org/gitlab/-/commit/c2b0ba5e6bf437adb18ec382b5ad569c3ffa6c43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162298))
- [Add clone dashboard to analytics dashboards](https://gitlab.com/gitlab-org/gitlab/-/commit/f63c9f2628e581e180c3566da6956349ef741b0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161908)) **GitLab Enterprise Edition**
- [Parse host and port from service URL](https://gitlab.com/gitlab-org/gitlab/-/commit/a284937832caf6ab0b6eaa944fd4246d4cd55bd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162540)) **GitLab Enterprise Edition**
- [Allow environment alerts to display alerts from any source](https://gitlab.com/gitlab-org/gitlab/-/commit/84b242b9645adc3a64321d1f72519db77d901060) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160511))
- [Update json schema validator to return meaningful error messages](https://gitlab.com/gitlab-org/gitlab/-/commit/3f42f86b319f6fcf3858f2cecabadd5fbd04997d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160236))
- [Enable the submit button after create access token](https://gitlab.com/gitlab-org/gitlab/-/commit/562e9711b2cbb4bb849c276771b7e13b1fbd9542) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162475))
- [Add permission to cloudConnectorStatus GQL call](https://gitlab.com/gitlab-org/gitlab/-/commit/948f5df4bd259fd983286047f11ad637998ea9a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162422)) **GitLab Enterprise Edition**
- [Avatar component: Update to use new design tokens for text](https://gitlab.com/gitlab-org/gitlab/-/commit/3abcf25e2ffe90a436e894584cafe42602337609) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162196))
- [Align position and styling of general settings on group and project](https://gitlab.com/gitlab-org/gitlab/-/commit/5bd11019423e59fe6b42afa15ed3687fdd6c5698) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161741)) **GitLab Enterprise Edition**
- [Allow Redis password to be specified in Workhorse URL](https://gitlab.com/gitlab-org/gitlab/-/commit/51a41e239c7c5d0c1150530e2db3c4b30b75d69b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162325))
- [Migrate milestone labels GlCard to CrudComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/f568f972faf13e77a6140efeb4215389a89b686d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162217))
- [Update dependency ai-gateway to v1.15.0](https://gitlab.com/gitlab-org/gitlab/-/commit/684aae6dd9119da17417ca04a8dd4b014092a66c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160660))

### Deprecated (3 changes)

- [Initial checkin for removing duo experimental settings](https://gitlab.com/gitlab-org/gitlab/-/commit/2b7fee5ab15318d6d19412f9fdd6ba253bd818fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162958)) **GitLab Enterprise Edition**
- [Include deprecation for owasp 2017 GraphQL argument values](https://gitlab.com/gitlab-org/gitlab/-/commit/5785f8d11367744d8ffda5254e8c3da107eb1c33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165966)) **GitLab Enterprise Edition**
- [Drop the following claude instant model](https://gitlab.com/gitlab-org/gitlab/-/commit/c9e6b3aab56c9555f1194e94cbf5b76322e92427) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165584)) **GitLab Enterprise Edition**

### Removed (43 changes)

- [Remove needs tab](https://gitlab.com/gitlab-org/gitlab/-/commit/dda131ac2aeefb90c951ce75196707f256be9a9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156207))
- [Remove confidence usage from Vulnerabilities::Finding](https://gitlab.com/gitlab-org/gitlab/-/commit/de14618f31d671a51bd67f9839f2e8f0308e08f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160712)) **GitLab Enterprise Edition**
- [Removes finalize_after key from BBM dictionary](https://gitlab.com/gitlab-org/gitlab/-/commit/a2d2450d7784ae6f208ece1e5ac307a4f7434795) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165640))
- [Chore: drop vertex_gitlab_docs db](https://gitlab.com/gitlab-org/gitlab/-/commit/096fd388a7eb31e7efdeaff0dd3ebfe3750e508b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156347)) **GitLab Enterprise Edition**
- [Initial checkin of duo group settings FF removal](https://gitlab.com/gitlab-org/gitlab/-/commit/f32a5a25c9669d37071d4e1f2e1aef7ede72ab7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163227))
- [Remove Non DUO Chat explain vulnerability code](https://gitlab.com/gitlab-org/gitlab/-/commit/a0c29b07990feea29392674d8ee8ce1f4db064ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162454)) **GitLab Enterprise Edition**
- [Remove ignore_columns for CommitStatus](https://gitlab.com/gitlab-org/gitlab/-/commit/c14225f8633afccced48f9579df385edac1a9fbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165595))
- [Drop old upcoming_reconciliations endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/cca8b0ffe47e0e7ee9bd6ee5fbc52c36370fe4f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165348)) **GitLab Enterprise Edition**
- [Remove deprecated getAddOnPurchase query](https://gitlab.com/gitlab-org/gitlab/-/commit/9f5171cefba4a9ceaa39d88f31aa5b9199445456) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165380)) **GitLab Enterprise Edition**
- [Remove explain this vulnerability section](https://gitlab.com/gitlab-org/gitlab/-/commit/2e7b9899becb841214c5b4848616b56cbc084f16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165201)) **GitLab Enterprise Edition**
- [Remove FF resolve_vulnerability_ai](https://gitlab.com/gitlab-org/gitlab/-/commit/52aec3bf235287921930f1ff2757237b05573e90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164359)) **GitLab Enterprise Edition**
- [Remove exclusive lock when updating statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/67416ba745008d9451c4073cc2cd4de8849294a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165227))
- [Remove grafana embed and integration metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/0f145af81fd21ec373d055da778f5a9802bf6d92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116849))
- [Remove elasticsearch call during initialize](https://gitlab.com/gitlab-org/gitlab/-/commit/72ff3ecc8e556842261f72d75ff7eaedc71b6006) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164201)) **GitLab Enterprise Edition**
- [Drop all deprecated metrics category tables](https://gitlab.com/gitlab-org/gitlab/-/commit/2f6450b65d5d6efe8fcedba1add064b33d5c8662) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164288))
- [Remove job log from failed job widget](https://gitlab.com/gitlab-org/gitlab/-/commit/a70d0b87e7d36978e600e5a81dbba4f004f823af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164020))
- [Ban AI remove Duo Admin Settings FF](https://gitlab.com/gitlab-org/gitlab/-/commit/03e4c0c98d4b5ce44f5fb057e23f4b35a3bdeada) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163055))
- [Initial checkin of removal of duo project FF](https://gitlab.com/gitlab-org/gitlab/-/commit/59eba17c0c901d51cafb59560964c2bf05d82f34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163218))
- [removal: Feature flag controller_static_context removed](https://gitlab.com/gitlab-org/gitlab/-/commit/5c967e0163f191301ba117c293ce49f9633c4fa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164079))
- [Ignore metadata settings fields in Metadatum](https://gitlab.com/gitlab-org/gitlab/-/commit/ce3c4b5191b9aa17c61043e8b83035382bb95751) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164041))
- [Remove getters setters user_preference](https://gitlab.com/gitlab-org/gitlab/-/commit/b0f15be265881acf929ca850375a76faf158cf0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164755))
- [Removes reset_seat_banner_callouts feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/036891df2322fd42f2c6f4f7914e2244ac34db3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164340)) **GitLab Enterprise Edition**
- [Cleanup legacy routes](https://gitlab.com/gitlab-org/gitlab/-/commit/721329e16625cc417fc45647f264dd6463894c12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164720))
- [Remove redundant index](https://gitlab.com/gitlab-org/gitlab/-/commit/ec40e0e7883e94bba2e4e6fdd3b8e87bf67d4b07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164709))
- [Removes old/finalized batched background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/8db6d92aba116d759a37dbbeeed903f1f2be1596) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162163)) **GitLab Enterprise Edition**
- [Feat: remove vertex embeddings database](https://gitlab.com/gitlab-org/gitlab/-/commit/0086f556f429d29e98f3d30fa8c9cf9886cb57cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161223)) **GitLab Enterprise Edition**
- [GraphQL: Remove deprecated values from CiRunnerStatus](https://gitlab.com/gitlab-org/gitlab/-/commit/030b2bfcfc1e9dc1c3e267cb4c7854bfe76eed60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163967))
- [Drop table ci_platform_metrics and model CiPlatformMetric](https://gitlab.com/gitlab-org/gitlab/-/commit/a2208c18bfd8351411740956fe33c482e1a0b68b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163859))
- [Remove async_merge_request_pipeline_creation](https://gitlab.com/gitlab-org/gitlab/-/commit/44e3687344593ceea55ab6a05a82bfc8c81513ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163907))
- [Remove pre_receive_secret_detection_beta_release feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f09772904698ea02e6a2a4c8ec237f239d6b9c16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162407)) **GitLab Enterprise Edition**
- [Remove data gathering of 2 obsolete AI events](https://gitlab.com/gitlab-org/gitlab/-/commit/abb7c2fa62ef50140eb1be869f05d51a115322e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160553)) **GitLab Enterprise Edition**
- [Remove `vulnerability_reads` indices using `namespace_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/dfc4f27b94f299d376ed5baa72f5b5256dae9780) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163039))
- [Remove bs-callout css](https://gitlab.com/gitlab-org/gitlab/-/commit/484c4c4eccd5f98729a1acfec98e777f312ef2c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163526))
- [Remove duplicate index index_sbom_component_versions_on_component_id](https://gitlab.com/gitlab-org/gitlab/-/commit/49cab49242937b8a211864587ea7a83e1e0d1582) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162621))
- [Remove cloud_connector_status FF](https://gitlab.com/gitlab-org/gitlab/-/commit/bac43c46a70ae0e73ded62e608c3dbf44834d0da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162565)) **GitLab Enterprise Edition**
- [Remove Resolve Vulnerability Vertex prompt](https://gitlab.com/gitlab-org/gitlab/-/commit/dde2264691eb43de8b411e3f18215759e1203f23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162872)) **GitLab Enterprise Edition**
- [Remove Ci::PartitioningIdAnalyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/cd324d7a15ec8dba6c7fa01d4d77ae64247b9094) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162578))
- [Remove the unused FKs referencing ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/53ce4f2e3bbaac351ad7fc042d853e9583f88107) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162529))
- [Remove duplicate vulnerability management indices](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc7c35c7e0bbf2055b003979d7448a85150e1c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162626))
- [Remove `explain_vulnerability_anthropic` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/240185866c54c6e8c4244a36313ce2bdddc44642) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162443))
- [Remove ignored `help_text` and `sign_in_text`](https://gitlab.com/gitlab-org/gitlab/-/commit/3864419ee10e5da1b7df4f454427e6f545f7c6f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151173))
- [Remove `project_level_sbom_occurrences` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/29c2f524c6f6ca3ff9820d0e0917fa06ca117e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162207)) **GitLab Enterprise Edition**
- [Delete the `blame_page_pagination` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d84caf3e8daaaacff0dcf255c85a1cc1ae7957b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161124))

### Security (23 changes)

- [Revert "Merge branch 'security-psk-fix-external-wiki-integration-dos' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/ee5a8b7af26859f16777c014a5be057d99b6d177)
- [Fix external wiki integration DoS by changing request to HEAD](https://gitlab.com/gitlab-org/gitlab/-/commit/03fd80cf91bbc3e3f7a3a8c9e6ffa9daae5ea8b4)
- [Redirect url in the link validated for being external](https://gitlab.com/gitlab-org/gitlab/-/commit/53a745fd8e203ca8f21e0630bc7529da8adec9db)
- [Strip out Set-Cookie header from dependencyproxy auth response](https://gitlab.com/gitlab-org/gitlab/-/commit/8d01129bb26a96e6ed56522bf4504759f0f56301)
- [Fix open redirect due to additional slash added](https://gitlab.com/gitlab-org/gitlab/-/commit/4ece8de829be74e915c61ac0ec8ab2714fcd83f5)
- [Prevent code injection in Product Analytics funnels YAML](https://gitlab.com/gitlab-org/gitlab/-/commit/4453364640da5b3a422af92bb0fbc9356b26f195)
- [Add permissions check to project creations from a project template](https://gitlab.com/gitlab-org/gitlab/-/commit/296bb8bf037fd1e468223943d8c3fc5d3cd480e5)
- [Fix the vulnerability in the glm_source parameter](https://gitlab.com/gitlab-org/gitlab/-/commit/9ab1ddbdb4d3d0a026e42d5972a00962c1e900ae)
- [Fix credentials disclosure in mirroring failure](https://gitlab.com/gitlab-org/gitlab/-/commit/2df401b90febce44425fc03bbb1ba9eceef84a88)
- [Improve GraphQL log security](https://gitlab.com/gitlab-org/gitlab/-/commit/f52d37ba60af4a6411a2a896bd3232a3001368b5)
- [Update edit permissions for DAST profiles](https://gitlab.com/gitlab-org/gitlab/-/commit/e663019be4168b0f42cf895be213d9d9fef06cfc)
- [Prevent users with admin_group_member custom ab. to manage custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/b5f12f834b6e84251274e855c961f97f21f29b0e)
- [Execute environment stop actions as the owner of the action](https://gitlab.com/gitlab-org/gitlab/-/commit/12d8d2f67ce8e8d256ba36faf09536cd3d7ce10c)
- [Commit information visible through release atom endpoint for guest users](https://gitlab.com/gitlab-org/gitlab/-/commit/39dc0863d8fe989069ecc94e538352c5bc57a41b)
- [Group Developers can view group runners](https://gitlab.com/gitlab-org/gitlab/-/commit/924c311d3f9727e118b60b7a1973ab60009d0efa)
- [Fixed frontend regex to parse URI](https://gitlab.com/gitlab-org/gitlab/-/commit/97211a42ba751d3b7e24d763dd18ad99abaae989)
- [Use session instead of params for identity linking](https://gitlab.com/gitlab-org/gitlab/-/commit/e2d183895fdfb4c846c0b8d7b51482f6ef1d19dc)
- [Enforce Pipeline execution policy variables for template rules](https://gitlab.com/gitlab-org/gitlab/-/commit/4f50f93aa73c69bf3076bbb1ea840a130d344b50)
- [Restrict IPs for packages dependency proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/6847e3a69e700ba2ca0dfa5a04d2448a2bf53d27)
- [IP restriction to prevent all group permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/d486737cc363455d6d71d4bc2bcc55f7858de87a)
- [Do not run pipelines when resolving vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/80cb299c28296646c4c8b7dfa1cbee8f2fe9a68b)
- [Destroy associated releases when removing a tag via Git CLI](https://gitlab.com/gitlab-org/gitlab/-/commit/8212ba9bb6cde25f784e1fb9742dfa7a575a390d)
- [Add Octokit::ResponseValidation middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9474ddfcd29ae71df06bb36f7ed3c995252da0)

### Performance (3 changes)

- [Use segmented export for group-level dependency list exports](https://gitlab.com/gitlab-org/gitlab/-/commit/560ef71cda980a088c14a4295d30a5f44e3ee55c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164854)) **GitLab Enterprise Edition**
- [Add composite index to SubscriptionAddOnPurchases](https://gitlab.com/gitlab-org/gitlab/-/commit/19b453b3c6a5562e17fe9ce5c7cdc431fae222e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162227))
- [Drop composite index involving project_fingerprint](https://gitlab.com/gitlab-org/gitlab/-/commit/8c420c4c918298cd75f0226e71887f2eb80c3e18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163443))

### Other (117 changes)

- [Mark 20230928104245 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/8af61b001898d924226c6a895dfa0035edfd84ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165986)) **GitLab Enterprise Edition**
- [Announce deprecation of field add_on_purchase under namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/23620df2ba5b8aa8a057514dff22ed415af76822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166195)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8923b6c41a0467cffd4b5d3c055e46e05c378722) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164817))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9a28b8cc675190bbd75c704f4a7da9159d560ab9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165741))
- [Reorg. of sidebar files](https://gitlab.com/gitlab-org/gitlab/-/commit/ea4ad9e5060af01d7a3a95491d3c82825f2c0326) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165930))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6a4138b783468d96c02d2bf9e421eee02f4e58f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164298))
- [Cleanup remote_development_namespace_agent_authorization feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8147ec5f76c7d02636d6a0a84d8aa4cd4dcceda6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163128))
- [Add and backfill project_id for ml_candidate_metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/ed4c9ab01a5dce0583b1c96354ce59958891bd27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164465))
- [Add and backfill project_id for alert_management_alert_assignees](https://gitlab.com/gitlab-org/gitlab/-/commit/3fdf8e50f6325703b77cac753d6f828eba80d136) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165673))
- [Update status of namespace in URL path to GA from Beta](https://gitlab.com/gitlab-org/gitlab/-/commit/76f5bb4c62b48998765c3117cbc55c85c5ca7b86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165483))
- [Cleanup project_daily_statistic_counter_attribute_fetch feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d3e99e1ba4ac14e43f7467d70a56b216b6fa9019) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165307))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e46a05df0fbf2a4d1e09cf5f44f28834b6b38d2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165740))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/75e89ea43ceb035f93049888390ec3ba31851117) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165739))
- [Add `open_kubernetes_resource_details` event](https://gitlab.com/gitlab-org/gitlab/-/commit/2d2e8c263103b5073b098c7a5cca0b7624984fba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165366))
- [Add and backfill project_id for ml_candidate_params](https://gitlab.com/gitlab-org/gitlab/-/commit/f3a004730babbe25b4a8da6be601e6210509b54a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165336))
- [Add new FK between p_ci_builds and p_ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/9d6692578eab11d97525bcf1ed913fcc28cc5042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165488))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/862608f12a87a8ab8b4f83111766e761ac37c418) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165266))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a2171ad2d934a43c2c43dcfcd656e1dbded6d0b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165129))
- [fix: Use gitlab_sec for vuln_remediation bulk insert](https://gitlab.com/gitlab-org/gitlab/-/commit/c117a3bf58b4b884be93ec27baaf4b9629d84128) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165333)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9b9d07065601997fdf831315e3e15127c341c1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164971))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0831f0ea6698baa6f98b0cd387f8408e6880e4b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164969))
- [Improve github import docs](https://gitlab.com/gitlab-org/gitlab/-/commit/98e7875075f27aea56899ec60d6988b79472c430) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165039))
- [Revised index for owasp group level reports](https://gitlab.com/gitlab-org/gitlab/-/commit/c46f9099ed20ddf2dfc398a252c4684520de35a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164252))
- [Partition ci_pipelines_config table](https://gitlab.com/gitlab-org/gitlab/-/commit/80b1740af264123ca4160bef376ef38f53e90130) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164455))
- [Remove feature flag `not_found_response_for_go_get`](https://gitlab.com/gitlab-org/gitlab/-/commit/58f8b56b72a1246151a2cfae8aecda48d108deb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165178))
- [Removes the extra docs and updates the original BBM dictionary](https://gitlab.com/gitlab-org/gitlab/-/commit/6efe1332284ffb1fab11277c13b7086f379d115a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165164))
- [Upsert single upcoming_reconciliation](https://gitlab.com/gitlab-org/gitlab/-/commit/de0b960117bfc09b3574500b1b1e5b29ca99eec0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165020)) **GitLab Enterprise Edition**
- [Convert integer ID columns to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/68622bfc705bb0cd5b15ce10c60d14135216b4e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145752))
- [Use instance variable @namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/dcf2e2c6144a14db4e9fb29f134122f749adaedc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164985)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7b1d149396051c597084e6e2a3b58c4cac064629) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164018))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/672ca97328f7e60e26851484840f23dd2bda9512) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164970))
- [Make copy changes to trial registrations for duo enterprise](https://gitlab.com/gitlab-org/gitlab/-/commit/5dc11ae1ffa069751b84e3e3168e27c93c9f7160) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164522)) **GitLab Enterprise Edition**
- [Improve error handling for the job logs app](https://gitlab.com/gitlab-org/gitlab/-/commit/8f60fbddfdfb7ba46923e30f38f267e68e87fbcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164947))
- [Add learn duo pro discover link in expired duo pro trial widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ef35c00d33da69a49b39ed15c023bfcef12cf109) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164939)) **GitLab Enterprise Edition**
- [Clean up new_broadcast_message_dismissal](https://gitlab.com/gitlab-org/gitlab/-/commit/74d24f25c843851c299a8aab1d48e614ff3b8ddb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164937))
- [Implement change_allow_force_push tracking event](https://gitlab.com/gitlab-org/gitlab/-/commit/f901180dec74b1c557a5ed05e6ffeaa7e7bac744) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162271))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/140449919efe85a5b13d6c0f7bbaa5f8191dc3a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164710))
- [Remove ci_new_query_for_running_stuck_jobs feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/332c445fa512d175f5ecf6e0cc8d814bc400ff16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164801))
- [Fix Layout/ArrayAlignment offense](https://gitlab.com/gitlab-org/gitlab/-/commit/c49ae1da9d71b009ff870682f2307e5664e5575d) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163911))
- [Add an attribute truncate to do cleanup for the new node](https://gitlab.com/gitlab-org/gitlab/-/commit/44b9a247aec7c051a87c2a2b8b4b04dfe4185222) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164459)) **GitLab Enterprise Edition**
- [Remove cncf logo from trial registrations](https://gitlab.com/gitlab-org/gitlab/-/commit/5cf400a86d7fa7df48b2d6b5bf083cb773c0ec08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164550)) **GitLab Enterprise Edition**
- [Improve Cypress test case names](https://gitlab.com/gitlab-org/gitlab/-/commit/8f11938d78f2fa6661032def1acf2a6d9f2dc5c2) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164024))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/dcd49d0fa87a5d3b01bd88aa49f81696e9257cc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163822))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/147303e9f266651191cf7ee4464226ebd91cb6d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164432))
- [Remove actions and approval_settings from security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a4b4284735ce95d8220cfed512a9e8525991f7d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163753))
- [Remove FF vulnerability_owasp_top_10_group](https://gitlab.com/gitlab-org/gitlab/-/commit/92bdba3ba4fbbb1582712549d58329fa0845fb5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161599)) **GitLab Enterprise Edition**
- [Desired sharding key to accept custom parent table primary key](https://gitlab.com/gitlab-org/gitlab/-/commit/7fc4f18c2c9db1a9d619c419358d71eb10f98937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164392))
- [Fix sidekiq warning in EventStore::Subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/68bb641a5db67a9023b928169422c08f26b5053a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164200))
- [Enable ai impact analytics only for duo enterprise](https://gitlab.com/gitlab-org/gitlab/-/commit/40d6518e955774f00bbd407440220afe141a87e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163036)) **GitLab Enterprise Edition**
- [Upgrade to graphql 2.3.14](https://gitlab.com/gitlab-org/gitlab/-/commit/e6d3a78a46cbbf96c778a789109b2e4177189be9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161286))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/831021ccefe3d80cc5c924e975932370dbf7bb7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164297))
- [Cleanup ensure_lfs_object_project_uniqueness FF](https://gitlab.com/gitlab-org/gitlab/-/commit/297c03d8681c3611eeba5bb8a9e50fcf8c3b1b32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164239))
- [Reschedule DropWorkItemWidgetDefinitionsNamespaceId migration](https://gitlab.com/gitlab-org/gitlab/-/commit/26b945e6933c37fc01ee750e2dd7cb463c49c869) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163987))
- [chore: Fix typo regarding response and successful](https://gitlab.com/gitlab-org/gitlab/-/commit/e31e0915e76552e8ff16b74a09cacc0bb1877adc) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164190))
- [Add and backfill organization_id for subscription_user_add_on_assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/2cfc07d6670481916d04fc7f5cf3deb261dff3c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163912))
- [Removes `webui_members_inherited_users` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/77339d28619deef39a4d0574fbeac9356b3e649b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163627))
- [Partition ci_builds_metadata table](https://gitlab.com/gitlab-org/gitlab/-/commit/609e62a4e478e44d5c590fe27975f71ecc954e7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163746))
- [Optimize ListConfigVariablesService (prefill variables service) (retry)](https://gitlab.com/gitlab-org/gitlab/-/commit/6b2d18f4b2baf267492a68dfd5448c30e057efa9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163880))
- [Fix flaky spec](https://gitlab.com/gitlab-org/gitlab/-/commit/f217f1e6492b9c954e7bc9f92d35f7ab37a26c25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163903))
- [Update vendored Laravel project to match project template](https://gitlab.com/gitlab-org/gitlab/-/commit/5a4606aa9b8738b5d5a1a9bc20c2c974df156139) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164005))
- [Update vendored Cluster Management project to match project template](https://gitlab.com/gitlab-org/gitlab/-/commit/a5d9c9d48d8cbfd88986c16f3ba0fe2a605538d9) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164001))
- [Fix Layout/ArrayAlignment offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/f5f4c24db9888c39551ea749030876e0a3b41037) by @sahilsarawagi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163971))
- [BBM to update owasp_top_10 with null values to -1](https://gitlab.com/gitlab-org/gitlab/-/commit/afc4a9e9a423521d98c731e996b88aebc58488ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161962))
- [Remove ci_partitioning_first_records feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1d19d8f7ad187b3392b303c8c57f88744f459811) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163896))
- [Cleanup write_to_ci_build_tags feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/eb9036f18aad5a3951b75d115302fffe363f93c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163587))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e8cbafe91aeb4528457c297ad6917c0239f1dd64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163820))
- [Backfill published_by_id of catalog_resource_versions](https://gitlab.com/gitlab-org/gitlab/-/commit/50046440bbb6139b54cd9fee31e58740603807cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163301))
- [Cleanup allow git http fetch writes feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/95226f1530850940c2471f2507d1dadb1c30ac21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163807))
- [Organize mocks into categories](https://gitlab.com/gitlab-org/gitlab/-/commit/3b16fbd18b1f42fd575320f72c0f43256556f764) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163482)) **GitLab Enterprise Edition**
- [Correct tests after migration to Crud and SettingsSection components](https://gitlab.com/gitlab-org/gitlab/-/commit/a3e89b6ee3c3ca775f48783b45aa100dd96b7c3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163639))
- [Update docs of `detailed_merge_status`](https://gitlab.com/gitlab-org/gitlab/-/commit/84ba4890a71ec720b693eb645af8362b7623e4d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162008))
- [Fix RSpec/ReturnFromStub offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/c02a603fdcaee74366bea5dffe0fcee7c5eb922d) by @nathanpbrophy ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163018)) **GitLab Enterprise Edition**
- [Change trial group selection placeholder text](https://gitlab.com/gitlab-org/gitlab/-/commit/48897f9f2d7bf2bff7790e059571a1f06f3fe71b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163643)) **GitLab Enterprise Edition**
- [Add policy type to orchestration_policy_rule_schedule](https://gitlab.com/gitlab-org/gitlab/-/commit/36b564678c412afc735e614cf812ca1d1b2a0398) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163293)) **GitLab Enterprise Edition**
- [Backfill p_ci_build_tags with data from taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/dcf44046aeb11087f9e08d1b11e9632dc675e4bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162706))
- [Remove parallel_project_export feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bfaebe9fb31bc92073c6037ea2704fb42e274104) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163366))
- [Partition ci_build_trace_metadata table](https://gitlab.com/gitlab-org/gitlab/-/commit/b3444ec2d4acf98a09b67864037ef40d51998183) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162310))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a4d40b8470a63abca331677fc652530f1ef8ee71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163085))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/bd7aa7e07861129af1c8ee5b1e08bf12cab62fb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163083))
- [Requeue migration to backfill sharding key for deploy_tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/100ff56c1c0afad376a7a5a60eb24101cb78de4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163122))
- [Delete orphaned deploy tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/6acd8aba6e9dae669c8c049ee4e079e52645cb01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162957))
- [Drop unused onboarding_progresses columns](https://gitlab.com/gitlab-org/gitlab/-/commit/87142c5da25ac7b80179ae170dd395a934791729) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162756))
- [Validate p_ci_builds project_id not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/024d896bbbd3f5d42f7f5a6048fc8f4250a9c7a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163148))
- [GitLab Pages: Handle LetsEncrypt errors on ssl renewal](https://gitlab.com/gitlab-org/gitlab/-/commit/6b31b5a22f83d371bf8c1a954c94554607ab6f63) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162300))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2a81546cdd3b403021e1ff70082b223693d1c0fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162803))
- [Remove feature flag allow_ai_features_token_for_graphql_ai_features](https://gitlab.com/gitlab-org/gitlab/-/commit/ec92ea2931960e8f670918fbec13695dd71e1d85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163106))
- [Add identifier_names to vulnerability_reads](https://gitlab.com/gitlab-org/gitlab/-/commit/ace4a7dcb3211069ef191965f843df4eb8f80d3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163059))
- [Add warning when external user accesses internal catalog project](https://gitlab.com/gitlab-org/gitlab/-/commit/5128a6521054aad142d96d68d4fc15044a06ff34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162978))
- [Removing Clusterwide DB CI/CD Jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/f06925601e0215d71956cbd761e81222ca902416) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163057))
- [Add & backfill sharding keys for security_orchestration_policy_rule_sche](https://gitlab.com/gitlab-org/gitlab/-/commit/6cd89ca0c562919c73b5567bed25dc4c0a6b67a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163017))
- [Finalize DeletePackagesComposerCacheFileRecords migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6fd6c375d3ab6b5f64989605d516c9517b17fb55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162995))
- [refactor: Define spacing in parent element](https://gitlab.com/gitlab-org/gitlab/-/commit/568190e6f3988f877edcd3d67febaac3ee51633b) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161875))
- [Clean up ci_require_credit_card_on_free_plan feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/18df31c37a5ff776b92d3a0a2ede75346e1cdc94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162805)) **GitLab Enterprise Edition**
- [Add & backfill sharding keys for protected_environment_deploy_access_lev](https://gitlab.com/gitlab-org/gitlab/-/commit/fab65a0889bfce50a190a42548a0f201188c067a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162834))
- [Fix separation of duties link from UI to docs](https://gitlab.com/gitlab-org/gitlab/-/commit/88c15dae251437bbc6a2d94561b17779fd87a32d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162795)) **GitLab Enterprise Edition**
- [Cleanup "use_pull_mirror_update_service" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3ad2a986c1164de07d6279d59a0115d1dbbed46a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162849))
- [Optimize ListConfigVariablesService (prefill variables service)](https://gitlab.com/gitlab-org/gitlab/-/commit/2ab3ad066e519d9b9a4448413f989953b5635aa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162055))
- [Add & backfill sharding keys for protected_environment_approval_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/6f687d1e0c5afc1e819b1b5fe2d83773d27041f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162704))
- [Update external status checks metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/300e0b69457534ebcd4e63e940dcc73e54b91448) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162788))
- [Add disable CI build for draft MR example](https://gitlab.com/gitlab-org/gitlab/-/commit/0f24bfd168b56e737993d4d121d802b9a7608b27) by @lifez ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161689))
- [Remove rely_on_work_item_type_seeder feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9c64ea2c6da1fe2371a86bda8891eabea6271d7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162740))
- [Query using int when owasp_top_10 is none](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9a9ea712766f17b8f48debad81d59f4ca2784e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161890))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d13d0e4aabeb4cb1a2126b780f5880c733e3305f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162518))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/054ca5025962c3b13452a4da6d0dee4f15e86c6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162663))
- [Validate FK for ci_daily_build_group_report_results.last_pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/da021068f993fe69d166e8239a4fa33156703d7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160672))
- [Log headers from http-router](https://gitlab.com/gitlab-org/gitlab/-/commit/ba15924e3e2a7826b612d216877218d67233fb17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162543))
- [Refactors beyond identity page to remove GlNavItem](https://gitlab.com/gitlab-org/gitlab/-/commit/215cb64f5b9cdb12172745a5aa716a81f6e4c6bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162284))
- [refactor: Use single quotes consistently in the files](https://gitlab.com/gitlab-org/gitlab/-/commit/c7390f269923276b2fc4320c8d9e9205d81c11f1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158470))
- [Change owasp_top_10 column default to int on vulnerability_reads](https://gitlab.com/gitlab-org/gitlab/-/commit/f37344a8b4240aab55c8a70ce5a37bc7572bca8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161823))
- [Remove "disable_ssh_key_used_tracking" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e5f88ecd6f0d344bd218f502bbceac1b38280081) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162451))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b3f955d74803d86d230b9b79e578e4c1fc87fb73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161412))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8902928dfa95aca426a5cdba0d4ce9637284c6b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160520))
- [Deprecate BackupCustomHooks and RestoreCustomHooks RPCs](https://gitlab.com/gitlab-org/gitlab/-/commit/f108fa7665c1f31b1bf7df412de32453d5ec426d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162301))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/03398e7f18b60912fe07d9172ba4836a24ac2953) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155530))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f0b649490a78068f47817f2e515da73bccc2bf06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155532))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0029fc8043524d89d3a2b821f92d63bb8796c0da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155533))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/757258568c50179d1eac9f99e9279cb34f8e44ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155874))

### EE (1 change)

- [Update learn more link and docs formatting](https://gitlab.com/gitlab-org/gitlab/-/commit/6f536fdb20c2d2b96124afe693042c91483a32b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164889))

## 17.3.7 (2024-11-12)

### Security (6 changes)

- [Use custom adapter for parsing FogBugz XML](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8952776336f65ba2f7a182cb42e6714f4f17b97b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4594))
- [Removed id from authorize buttons and added specs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5f2a1b9a8cd823901e1184177fa55d43f20a3200) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4575))
- [HTML injection in vulnerability Code flow leads to XSS on self hosted instances](https://gitlab.com/gitlab-org/security/gitlab/-/commit/59ac206c9475b5713e8aee79dffad95fda802384) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4566))
- [Remove is-unsafe-link from product analytics tables to prevent XSS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1420ca36c7c8fa50949d934ee9eb8a1a2dc3d6a5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4581))
- [Details of blocking merge request can be exposed via list](https://gitlab.com/gitlab-org/security/gitlab/-/commit/aa81586dd7ca7fa7fc2d5c4b74b8d5971c573df7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4527))
- [Prevent agent access via unconfirmed or disallowed group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/58ddb6195652c2d04fb90db5b53889273090c18c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4561))

## 17.3.6 (2024-10-22)

### Security (2 changes)

- [Fixed HTML injection in Global Search bug](https://gitlab.com/gitlab-org/security/gitlab/-/commit/96159ab6cd9af8fc0ceadaf7568c8aaf079a8542) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4506))
- [Limit max size of manifest file upload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/85bf29446c0423ba04339bc95ba546948b91e12e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4531))

## 17.3.5 (2024-10-09)

### Fixed (1 change)

- [Ensure levels is an array](https://gitlab.com/gitlab-org/security/gitlab/-/commit/74594891f31984feaaae6a069f057d6f48a489a6)

### Security (8 changes)

- [Do not create a pipeline on MR refresh if source branch was deleted](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c36869b2e5cb0f88793bec7e20ded3e4d005f942) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4523))
- [Escape OAuth application name on authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b5a704563f746e5c61301d3a7db0eab68d434e24) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4518))
- [Prevent guest access to project templates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/92d177e2c5aaafb4f74bc2ceafe39b9a068e803d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4449))
- [Remove access to local requests via cube query service](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7043d0116cbf2051907dfd88d56ed3f847ab95b2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4493))
- [External webhook token should be set](https://gitlab.com/gitlab-org/security/gitlab/-/commit/77c2a678acfc6fded56c6e10147701b6ef7aaeb5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4511))
- [Skip content when listing conflict files with types](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2b559425cb195a78007db930cbbf8450b5254c89) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4514))
- [Hide version info from unauthorized users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/94e70d423789a50fc8e172b002bf1428593bbc51) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4501))
- [Prevent deploy keys from pushing code to an archived project](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3cd52356b4b1194e7108af832d5da4087e4be05c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4487))

## 17.3.4 (2024-09-24)

### Security (3 changes)

- [Implement input sanitization for SummarizeComments](https://gitlab.com/gitlab-org/security/gitlab/-/commit/034f25d7a760c8027f3c7426ca57ee49459f866f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4411))
- [Hide system notes with invalid references](https://gitlab.com/gitlab-org/security/gitlab/-/commit/484a80474d1f262b45923de365e288140605333e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4483))
- [Reset dependency proxy maven credentials when registry url is changed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/74a4ae92cbb1e74e9e1e6858d6d3b0cf9daa4d09) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4458))

## 17.3.3 (2024-09-16)

No changes.

## 17.3.2 (2024-09-11)

### Fixed (3 changes)

- [Update Access data on sync even if data didn’t changed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4ef29892400e4cfd9d77ae2ed11d577cf94bf026)
- [Fix Sidekiq crashing when GITLAB_LOG_LEVEL set to debug](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e2eba0a9279b9f92d0adda8653474efb0ca1014a)
- [Fix issue when resizing images in RTE](https://gitlab.com/gitlab-org/security/gitlab/-/commit/812f117e1fc8260121c1dfbeb5e503552aedca37)

### Changed (1 change)

- [Backport OpenSSL v3 callout to 17.3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ba9718022b12e627375e166a8731e9cb83fd632b)

### Security (19 changes)

- [Revert "Merge branch 'security-psk-fix-external-wiki-integration-dos-17-3' into '17-3-stable-ee'"](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4adb684182baacf3d351090265c94899b5db1eb3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4453))
- [Fix the vulnerability in the glm_source parameter](https://gitlab.com/gitlab-org/security/gitlab/-/commit/878cda6f69865a8a61d0a3e431ed365bb01fd7a0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4436))
- [Improve GraphQL log security](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ab77ecaffab94c02d4d8054dd900ef853ddb492) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4400))
- [Add permissions check to project creations from a project template](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9aaaaf465c69b9cf80f7b3906338a822f31adadd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4443))
- [Fix credentials disclosure in mirroring failure](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0c2d3c9417a1fccea08bdc817943685f058c7fa5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4446))
- [Redirect url in the link validated for being external](https://gitlab.com/gitlab-org/security/gitlab/-/commit/219cfd97cc2771266d2e92c9bd2e87bad2cdceb4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4440))
- [[17.3] Update edit permissions for DAST profiles](https://gitlab.com/gitlab-org/security/gitlab/-/commit/44638f2465398883881de00a84fea1f724bc3456) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4372))
- [Commit information visible through release atom endpoint for guest users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7e4451c5eb6f7ae20ff9400660d9c8072d378522) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4437))
- [Execute environment stop actions as the owner of the action](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e160b472c887a33122f9ef2894551b167a321377) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4404))
- [Prevent code injection in Product Analytics funnels YAML](https://gitlab.com/gitlab-org/security/gitlab/-/commit/04ee196cf8dde5621404345a35a85c600e294536) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4431))
- [Prevent users with admin_group_member custom ab. to manage custom roles](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8a5aae28a61f67ccaf5a2c2fe7c24c4cc123d427) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4425))
- [Fixed frontend regex to parse URI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ae7d2fddff8fe064bde1bd9ab01bf10e219cbfa8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4419))
- [Use session instead of params for identity linking](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7ae3008fd84476d8995fe9fa7ec0800219cd1370) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4369))
- [Fix external wiki integration DoS by changing request to HEAD](https://gitlab.com/gitlab-org/security/gitlab/-/commit/20a6c608712831e7e9b072fbe0de61bb61105cdf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4381))
- [Restrict IPs for packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b894f3ca69858cceb80362e9f6a8c3d10bafe42a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4391))
- [Strip out Set-Cookie header from dependencyproxy auth response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cafae257663e5e0e2c410fd642c18c2b549b3451) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4399))
- [Fix open redirect due to additional slash added](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4fe66b1075a6023fcb2b5ce219b7ce0037a183b1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4374))
- [Group Developers can view group runners](https://gitlab.com/gitlab-org/security/gitlab/-/commit/084025e6a0ee601f4509ab2f9541d5a9a2c91d44) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4378))
- [Enforce Pipeline execution policy variables for template rules](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5dd7d992fcdcb23dfc32a47977b51303042b1be8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4393))

## 17.3.1 (2024-08-20)

### Fixed (3 changes)

- [Merge branch '444926-fix-bug-in-resolve-vulnerabilities-migration' into 'master'](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ac8a0cdc00b76c5ad84e8d18f3a7e49ebea2a538)
- [Turn NotFound from Gitaly into 404 for InfoRefs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3566c2625d62857246b215e191fb137091de1650)
- [Fix timeout when checking group dependencies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3f3bdb24b185196875a3989f0378d237243e80f6) **GitLab Enterprise Edition**

### Changed (1 change)

- [Include language server version in code suggestions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5b4b98955c5fa55911631800c3cd48f6224bf664) **GitLab Enterprise Edition**

### Security (4 changes)

- [Do not run pipelines when resolving vulnerability](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ef9c251b19c1ad7aedb591870158fc0085ee5fd9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4360))
- [Add Octokit::ResponseValidation middleware](https://gitlab.com/gitlab-org/security/gitlab/-/commit/08d547262c574b00135fb71105e52f03dc3ca8c0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4375))
- [IP restriction to prevent all group permissions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e080f2d2c5a578df52f202505e993c560fec6cb2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4368))
- [Destroy associated releases when removing a tag via Git CLI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b79ada987b82fa756e6ae74f7527dcde8c30d08f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4365))

## 17.3.0 (2024-08-14)

### Added (143 changes)

- [Trigger a Flux reconciliation from the cluster UI](https://gitlab.com/gitlab-org/gitlab/-/commit/be261dabcf80bb62aeec0ecbb7f8d7182e1bcea8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162017))
- [Add REST API invited groups in a group](https://gitlab.com/gitlab-org/gitlab/-/commit/7340e9d4fd361520da764924c8924e74e7a78aab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161792))
- [Sync finished pipelines to ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/fc536baba08a5df805424ccf6c04a90a93a16e3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162145))
- [Add subscription_history to Namespace GraphQL Type](https://gitlab.com/gitlab-org/gitlab/-/commit/0557753c50b8c4a142b16016f43b733335efd546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162042))
- [Add common phrases copy to the password](https://gitlab.com/gitlab-org/gitlab/-/commit/4251bc65f2506121e1e244dccdb4ed4c0d299b7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158789)) **GitLab Enterprise Edition**
- [Set project_id when creating Packages::Dependency](https://gitlab.com/gitlab-org/gitlab/-/commit/47a58a87252853c5743243cedf9c39b3f2c87318) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161039))
- [Extend deprecation properties with custom scan action](https://gitlab.com/gitlab-org/gitlab/-/commit/13626c77eacdea11360434c53e2f93dfe5840afa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162026)) **GitLab Enterprise Edition**
- [Protected containers: Badge "protected" in container registry list](https://gitlab.com/gitlab-org/gitlab/-/commit/f6f61289cd1ebefccaa0993e265786e743e57244) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158600))
- [Add a shared avatar image for security policy bots](https://gitlab.com/gitlab-org/gitlab/-/commit/e32392893acc6531fc06bca68b3f36c0f8428ff8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160803))
- [Add backend support for multiple Vue list filters](https://gitlab.com/gitlab-org/gitlab/-/commit/98184fee58bde0c25a7f87b239a2a95f33947e47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160938)) **GitLab Enterprise Edition**
- [Add EPSS to GitLab database](https://gitlab.com/gitlab-org/gitlab/-/commit/1e1d3d03038ea74054cf9d6e662727ff6e8395d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158908)) **GitLab Enterprise Edition**
- [Script to update Topology Service Gem](https://gitlab.com/gitlab-org/gitlab/-/commit/4ecbc79341a0e0c8af290e964b174bf79fc971c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161064))
- [Add TLS support for Redis Sentinel](https://gitlab.com/gitlab-org/gitlab/-/commit/e161ba73e46386101338317f7587c393f02784a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162132))
- [Create events to measure Branch rule edit adoption](https://gitlab.com/gitlab-org/gitlab/-/commit/2ddb31d3c03cb19f3a6963f28382ccec69fa1b4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160591)) **GitLab Enterprise Edition**
- [Allow the restriction of Kubernetes agent access to protected branches](https://gitlab.com/gitlab-org/gitlab/-/commit/7781be08bea6fe0c774b282f7abff6d22ba5bef9) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156626))
- [Add compliance_checks and compliance_requirements tables](https://gitlab.com/gitlab-org/gitlab/-/commit/b2a57db58eb817eac96235724ce99cd54dcbda1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161382))
- [Cleanup sync_audit_events_to_new_tables feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/155ed664f2252c45e95e8ac1ef4e248b8e136ad1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161982))
- [Add setting for max_artifact_archive_size_bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/5785b4e21bf90f56107a6282280790f84ffec9a8) by @danlamanna ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148554))
- [Add MR mergeability check for locked paths](https://gitlab.com/gitlab-org/gitlab/-/commit/e746530ad02b3734878b18a6e560f554e78b1df0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160929))
- [Refactor Modal form to use native submit](https://gitlab.com/gitlab-org/gitlab/-/commit/177f9524721a3ad0820b717f3f348c3e89f3c456) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161787))
- [Adapt seat assignment logic for both Duo add-ons](https://gitlab.com/gitlab-org/gitlab/-/commit/4523ee88992dce87f44ecd2b3f1106aaf06194ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161473)) **GitLab Enterprise Edition**
- [Add GraphQL PMG to MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/09d08d4cc8b521a12969d95a60494a6d63c35a8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160776))
- [Add field enterprise_users_extensions_marketplace_enabled for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/4f5e0dd020289d57a28c6a1354db3487ad1ee788) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161728))
- [Add  CSV upload modal for user contribution reassignments](https://gitlab.com/gitlab-org/gitlab/-/commit/144a02b3c9a5b642974edcf8ffac6e0f3e92f4bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156906))
- [Frontend for zoekt search results - part 1](https://gitlab.com/gitlab-org/gitlab/-/commit/0d2a2db569ef773acd3506e90d7904875586233c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160957)) **GitLab Enterprise Edition**
- [Provide connect command for agent cluster](https://gitlab.com/gitlab-org/gitlab/-/commit/5102deddc07fc30e661b12bac9981472de46fd9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161092))
- [Async FK for p_ci_builds.upstream_pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/acd118b8d2e6edcd62b13bd2f4b526aaadf05571) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161868))
- [Async FK for ci_pipelines.auto_canceled_by_id](https://gitlab.com/gitlab-org/gitlab/-/commit/15f7246e555a2d9fb4f0a342e28509240ec3b78f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161872))
- [Clean up duo_chat_disabled_button feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4d208f29079a9f57459374b236c9df70247d764a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161889)) **GitLab Enterprise Edition**
- [Add new internal API for credit card validation](https://gitlab.com/gitlab-org/gitlab/-/commit/b0fe49904b187fbf637f4ce14ea67787217ad7ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160540)) **GitLab Enterprise Edition**
- [Add MR mergeability check for locked LFS files](https://gitlab.com/gitlab-org/gitlab/-/commit/518897664a2887f189c01f6efacff955d9ed7bef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158773))
- [VSD Usage Overview - Display alert if background aggregations disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/a91ff26ddfb0f935143cbe8676e2801172ba66ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161529)) **GitLab Enterprise Edition**
- [List owned runners via :admin_runners permission](https://gitlab.com/gitlab-org/gitlab/-/commit/09c78c1f3ea217cc68c1fc9f8e906b956bb82e38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161385)) **GitLab Enterprise Edition**
- [Add endpoint with standard roles and members count for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/2580b03ba6be3f8868980e2d6cdd4ba79604d946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161802)) **GitLab Enterprise Edition**
- [Add work items hierarchy reorder mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/780029ce8f9c757ed68eb5e0c240818b79428224) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161319)) **GitLab Enterprise Edition**
- [Trigger workItemUpdated GQL subscription on MR update](https://gitlab.com/gitlab-org/gitlab/-/commit/489955a7e708ea6e9f77583efdeaa9a702f323f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161103))
- [Frontend for zoekt search results - part 1](https://gitlab.com/gitlab-org/gitlab/-/commit/5961964f5d8c9ffe122fe3da74f21e9432f0e522) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160955)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/b54d4d9654c6e56098ccb925f60998ab5e2e42b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161755))
- [Allow users to customize their JWT sub claim](https://gitlab.com/gitlab-org/gitlab/-/commit/30e17df70d91c1171b89a8576bfdb1b8b95ac3ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160562))
- [Add the DB migration to backfill reserved_storage_bytes in zoekt_indices](https://gitlab.com/gitlab-org/gitlab/-/commit/c42abed8575fee7de7ba020c496eb820f0796b77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160302))
- [Add show_on_profile to UserAchievement](https://gitlab.com/gitlab-org/gitlab/-/commit/b5fcad26f840ec2e45ff340482304b7e5f8fa80c) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161225))
- [Add merge request dependency GET endpoints for REST](https://gitlab.com/gitlab-org/gitlab/-/commit/3a06379314e2afaa25da62cb161e7a58ed83a737) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160432))
- [Add project_id to merge_request_diff_commits_b5377a7a34](https://gitlab.com/gitlab-org/gitlab/-/commit/a50df2a88aa487adfddd7c28b6f9badbb6df3641) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156090))
- [Add project_id to merge_request_diff_files_99208b8fac](https://gitlab.com/gitlab-org/gitlab/-/commit/ed292883a1ac8911e1e96c3d97ff4c59392f7dac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156091))
- [Add GIN index to sbom_components](https://gitlab.com/gitlab-org/gitlab/-/commit/b87435af3e4589074a272f436ef608a56f1f5006) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161654))
- [Add Duo Pro seats panel to AI impact analytics dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/a95b42dca5ea792a476d82812dd2d0dc64b6f8a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161638)) **GitLab Enterprise Edition**
- [Show SBOM reports ingestion errors on the project dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/4d35b7c54cf86efe7773f47e753a724294e1a159) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160270)) **GitLab Enterprise Edition**
- [Add code suggestions acceptance rate tile](https://gitlab.com/gitlab-org/gitlab/-/commit/13c6e01ee111a596102214faa1f864393562e5b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160882)) **GitLab Enterprise Edition**
- [Support custom Redis usernames](https://gitlab.com/gitlab-org/gitlab/-/commit/bd4e9d2067afdc96d4870672a597b437744110d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161495))
- [Make RCA generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/2105ae370cfa30afbf94ebd0e0d166737dd0ab04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161371))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/47021899a01731473bf1025d1264ce39861e2f24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161483))
- [Add trendlines to the AI Impact analytics dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/289cdebd8629c9686d0a0fa6afeff80116844b32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160437)) **GitLab Enterprise Edition**
- [Add new table to connect issues to metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/1607b659d8d837beb5704d15d5c7e7bfb6e44cd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160713)) **GitLab Enterprise Edition**
- [Improve logging and Prometheus metrics of Workhorse endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/d5f902ecc43f00c052140033c3500e858b65ed92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160461))
- [Add observability APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/61bcf01781e143982c233fa0e7a7ad9b30db286f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161069))
- [Adds the code suggestions unique users tile](https://gitlab.com/gitlab-org/gitlab/-/commit/8e5bef6b97be5a6d7980edb814a96f92adf598c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155444)) **GitLab Enterprise Edition**
- [Enable store_sbom_report_ingestion_errors FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/753a8994c3e7dd354cd1112e306dd203295b33fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161379)) **GitLab Enterprise Edition**
- [Update shared groups params](https://gitlab.com/gitlab-org/gitlab/-/commit/70ca4b2d81be567b516169ca834b3d06cd4f5f39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159628))
- [Remove feature flag wiki_redirection](https://gitlab.com/gitlab-org/gitlab/-/commit/db049b459e3a20d97abb6c88a0cfe19d203908e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161305))
- [Allow Duo add-on upgrade and downgrade for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/d3641b19ad998d1b01c43170bc62546fef81c4ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160608)) **GitLab Enterprise Edition**
- [Expose can_modify_blob_with_web_ide](https://gitlab.com/gitlab-org/gitlab/-/commit/afd7d8012b7c72c84ba4296d81dbe1d241bf5490) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161346))
- [Add merge trains viz link](https://gitlab.com/gitlab-org/gitlab/-/commit/ed938702aa9a05107a3014c12b381b00496468e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161219)) **GitLab Enterprise Edition**
- [Add style for `<mark>` in rendered markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/76f607f07fc15786a03a337846694b9ec3778911) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161091))
- [Add .NET tutorial for O11y usage](https://gitlab.com/gitlab-org/gitlab/-/commit/12810b304d17f113ff4d690e8f58e94708233ea4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161193))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/04f43b9bd9ddb00446d46fed0e9aaca70ef1b014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161306))
- [Add project_id column to packages_dependencies table](https://gitlab.com/gitlab-org/gitlab/-/commit/adcd83b78a2c2c9418513cb23e86b6a8930f44be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160830))
- [Remove FF enterprise_disable_personal_access_tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9cbffecbdd34bcfb1467795eb6c2c4ff4d6a0b48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160816))
- [Add terraform module graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/dcd032cd573effa730976f64ef1120949bd7b064) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157305))
- [Added the countable connection to the todo type](https://gitlab.com/gitlab-org/gitlab/-/commit/a32cf8070f8bb24f60d5b3ec8e5b26266bf8bdf8) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159635))
- [Protected containers: Badge "protected" in container detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/b18e8e659ab10a99d57d149799ec8cc9170af026) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156539))
- [Cloud Connector status: Add end-to-end probe](https://gitlab.com/gitlab-org/gitlab/-/commit/930d589bee547142bb598da24afa72e133afc13d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161147)) **GitLab Enterprise Edition**
- [Cloud Connector: Add VerificationService](https://gitlab.com/gitlab-org/gitlab/-/commit/1e72d2326a462ae81832a1d6151f8d70628fcc2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159579)) **GitLab Enterprise Edition**
- [Added field to query memberApprovals for group/project](https://gitlab.com/gitlab-org/gitlab/-/commit/abc4139d47e471c94968fad24d2cb5bb178c2c2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159926)) **GitLab Enterprise Edition**
- [Add id attribute to uploads API](https://gitlab.com/gitlab-org/gitlab/-/commit/c636690b118851c9e0f5e76c9a7bfc0a24aa9912) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161160))
- [Do not allow creating epic notes when synced work item is locked](https://gitlab.com/gitlab-org/gitlab/-/commit/a9f82bfd9faabe611e2b86c9b4b824f7d1e740de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160570)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/51dbcc5ef6055d8453df59b77b171e0804c6d847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161146))
- [Add org to source package](https://gitlab.com/gitlab-org/gitlab/-/commit/a3f990293dca7c9ebb5aaa2ac2ba292895745d85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159026)) **GitLab Enterprise Edition**
- [Trigger `workItemUpdated` with `WorkItemAddClosingMergeRequest`](https://gitlab.com/gitlab-org/gitlab/-/commit/6ab284bf14a4c40383441b019c6792356e74609c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161083))
- [Audit group modifications to CI_JOB_TOKEN](https://gitlab.com/gitlab-org/gitlab/-/commit/90e006ac69a25bb1692609e70ed92f69715228df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159754)) **GitLab Enterprise Edition**
- [Add group settings sections to command mode results](https://gitlab.com/gitlab-org/gitlab/-/commit/bfa14310fb3d5657beed8bb74327a5390d7cf676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158228))
- [Add support for xterm background colors](https://gitlab.com/gitlab-org/gitlab/-/commit/4c33ccd48cdae213730a4cb2970e68337e2f2234) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161030))
- [Add Arkose email intelligence service](https://gitlab.com/gitlab-org/gitlab/-/commit/2b4c3c993751c5c2f12cef5f9b703f91ab145e3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160308)) **GitLab Enterprise Edition**
- [Add contact support links in identity verification page](https://gitlab.com/gitlab-org/gitlab/-/commit/4798606ddd8d840c9d460b55f8e30be769a73955) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160187)) **GitLab Enterprise Edition**
- [Add new merge trains link](https://gitlab.com/gitlab-org/gitlab/-/commit/aea2c40248fdc2e6edc7ba56b84c59d2e14acb8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160757)) **GitLab Enterprise Edition**
- [Add drag and drop feature to work items page](https://gitlab.com/gitlab-org/gitlab/-/commit/df829d03e639426b010f67f979c25f2eca536a2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157541))
- [Integrate Topology Service Gem into GitLab](https://gitlab.com/gitlab-org/gitlab/-/commit/85b5ebad3270be134664b32fff6abc9f1aa5faba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159778))
- [Add Disable Personal Access Tokens setting to Admin Settings UI](https://gitlab.com/gitlab-org/gitlab/-/commit/69e79c2417768d587d46f165f061d291264b9a8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159953)) **GitLab Enterprise Edition**
- [Add job count metric for pipeline execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/c6a9782fc3fd616be39bae139d63bc422ba73236) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159957)) **GitLab Enterprise Edition**
- [Add Mattermost version 9.10 to releases table](https://gitlab.com/gitlab-org/gitlab/-/commit/58f8ae203a7dbdd951ee4a93d3e90465ee624952) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160782))
- [Remove search_add_fork_filter_to_zoekt FF](https://gitlab.com/gitlab-org/gitlab/-/commit/2fd10fdc2b7695939593d807e0f242d1399ba316) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159434)) **GitLab Enterprise Edition**
- [Add mutation to convert note to thread](https://gitlab.com/gitlab-org/gitlab/-/commit/4be15fe60571de2b98d35f7e355cab9d4c3ffd88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160556))
- [Filter merge requests by target branch](https://gitlab.com/gitlab-org/gitlab/-/commit/0d0aa0bd462ee7b11f534960fcab199668316c0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160210)) **GitLab Enterprise Edition**
- [Add Virtual Registry cached responses table](https://gitlab.com/gitlab-org/gitlab/-/commit/a40e49525546072bf8cbeece8d6b1c2bf6996361) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157055))
- [Add models for Virtual Registries, part 1/2](https://gitlab.com/gitlab-org/gitlab/-/commit/3df26ae0cd0dde0d189a9d9bae491ee68992ba7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157793))
- [Add Duo Enterprise to cloud connector configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/551d12fd2be730b98333195412cc0775a1b6aaa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159749)) **GitLab Enterprise Edition**
- [Set reserved_storage_bytes in the node_assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/b8fccf89e0a13c895217d38b32c7f704d3380c99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159736)) **GitLab Enterprise Edition**
- [Add pull_frequency to control the tasks pulling frequency](https://gitlab.com/gitlab-org/gitlab/-/commit/8b9a2db425f36bf253311f9c270591be4c30f9a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160575)) **GitLab Enterprise Edition**
- [Adds support for Matrix notification integration](https://gitlab.com/gitlab-org/gitlab/-/commit/8b5e7fb6fe8434b2f79bcef9b5ed2521217e8ea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160223))
- [Adds last_dormant_member_review_at to namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/99e270842d83ba399de05c627c409f5c911d7152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157924))
- [Add "source" property of jobs to Jobs API, GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/05b7f5664fc67215585e2b1c394f27d5a8238c36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159798))
- [Add delete pod functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/058e7216a3f7163f33c9c40b707199f3e6ebf7f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160299))
- [Allow custom roles to be assigned to invited groups](https://gitlab.com/gitlab-org/gitlab/-/commit/e5405a6262003bee18f28977dbf85131e5045212) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159213)) **GitLab Enterprise Edition**
- [Remove wiki front matter related feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/03318de85c6af137a07db0a4671a4e4f4eda73f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160557))
- [Add approval policy rules and projects link table](https://gitlab.com/gitlab-org/gitlab/-/commit/09b792ba4927003588f71bc919f82207750d7b40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158441)) **GitLab Enterprise Edition**
- [Add Java Spring tutorial for o11y usages](https://gitlab.com/gitlab-org/gitlab/-/commit/c37f32a3a7594a449d4eb262f9d3a80d9c5888f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159922))
- [Rollout code_suggestions_skip_dependency_descriptions ff](https://gitlab.com/gitlab-org/gitlab/-/commit/b9c3b7dae4c5655865d560491df920d6a60f13de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160572)) **GitLab Enterprise Edition**
- [Persist all policy types for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/6187254025fc727ba49f1c6f13f1f660084ef238) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159891)) **GitLab Enterprise Edition**
- [Support organization_path for determining current organization](https://gitlab.com/gitlab-org/gitlab/-/commit/c2863a831ed823d46f9e649ae29b22583c7dc3bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160543))
- [Add delete pod functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/2cc1c7d3d60341e5093cc68727f646a3ab4c6f6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160117))
- [Remove merge_trains_viz flag](https://gitlab.com/gitlab-org/gitlab/-/commit/93f2ac6ef3647a6c601100da4dd57fce97622a8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160262)) **GitLab Enterprise Edition**
- [Show SBOM reports ingestion errors on the vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/55657c338f2074e2d7599602233ec860abb2dbcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158672)) **GitLab Enterprise Edition**
- [Reindex issues from database](https://gitlab.com/gitlab-org/gitlab/-/commit/91dea118cd2d686b69351792d82aaeceb2947442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158039)) **GitLab Enterprise Edition**
- [Skip the tasks with same project_identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/3bcad7cec1dccf668c8b5842850122c6baa29ddc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160240)) **GitLab Enterprise Edition**
- [Schedule DORA DF score recalculation](https://gitlab.com/gitlab-org/gitlab/-/commit/4a915e05d7642bdbc1993eb48d2670dec2f303bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160259)) **GitLab Enterprise Edition**
- [Add Django tutorial for observability tooling](https://gitlab.com/gitlab-org/gitlab/-/commit/9870eeabc48249acb2dee16e2830e1bbd4dbf1b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159440))
- [Show Flux resource details](https://gitlab.com/gitlab-org/gitlab/-/commit/f4797359bc9b842544dfac6b4516a6a51197cb20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158461))
- [Add CreateSecurityPolicyProjectAsync mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/d054075713dd54c1a00a3d9de281be1a8fb686a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158028)) **GitLab Enterprise Edition**
- [Emit audit event for agent creation and deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/ad7c7231ca2f2f3731e45f8e04f59c16973219b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593)) **GitLab Enterprise Edition**
- [Add for_occurrences and with_advisory scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/2e79bcccb8c2be27688ad1baa6b96971e248581e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158791)) **GitLab Enterprise Edition**
- [This MR adds new column to external status checks](https://gitlab.com/gitlab-org/gitlab/-/commit/e1ba61f12574d8e0a31f9bbdc108d04448b3aa7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159745)) **GitLab Enterprise Edition**
- [Add the syntax decoration for multi_match](https://gitlab.com/gitlab-org/gitlab/-/commit/9ff6b14262e9605ce863f9d4cbf82bf844272606) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160046)) **GitLab Enterprise Edition**
- [Add filtering by max role on members pages](https://gitlab.com/gitlab-org/gitlab/-/commit/b099444065af138549d19958f5cfa15a11f53b32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158651))
- [Expose source_url in API::Entities::BulkImport](https://gitlab.com/gitlab-org/gitlab/-/commit/719b157f365f360849944b751b486e23fec2c35a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159756))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/05d22b38a15b24a539e205a2893775c7ba29cca6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160009))
- [Add metrics for pipeline execution policy usage](https://gitlab.com/gitlab-org/gitlab/-/commit/8a12f0b6d087f2e4296b6f41af7c15752fa3257c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158675)) **GitLab Enterprise Edition**
- [Add pagination support for Hierarchy widget](https://gitlab.com/gitlab-org/gitlab/-/commit/2f294b429cbde49b27be93d4f610f3ca47685413) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159598))
- [Add index for purl_type and package_name on](https://gitlab.com/gitlab-org/gitlab/-/commit/8bcc04073e3dcb8f54eeff496cc6f68e74083311) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158792))
- [Feat: manual variables tab frontend part one](https://gitlab.com/gitlab-org/gitlab/-/commit/2d4e7c27ad3fe9cbdb60461fe05b07fd9298d4a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159206))
- [Release inheritance feature for Integrations API](https://gitlab.com/gitlab-org/gitlab/-/commit/b28f767ea3e4788c1cbc5decc72f9ea78ba1c1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159773))
- [Add filtering active and human users in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/ae7620b37f89b30dc37be3085211545a16261691) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159200))
- [Sync namespace_settings seat_control with new_user_signups_cap](https://gitlab.com/gitlab-org/gitlab/-/commit/49c816f9b628caf97d0c373d16b8446625fc671a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159466))
- [Add job action mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/6280733dc6485b26476974fafb213ddfb9781cae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159750))
- [Add nodejs tutorial to Observability docs](https://gitlab.com/gitlab-org/gitlab/-/commit/2747dcf1046391de17faa5a8c4963fa6b4898188) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159321))
- [Add detumbled_email column to emails table](https://gitlab.com/gitlab-org/gitlab/-/commit/920d107da487537522e2e76afd05963c8dc1a460) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159658))
- [Deprecation alert for Needs tab](https://gitlab.com/gitlab-org/gitlab/-/commit/da2eae2e81830e4ecc095be890375ce1e6aaadb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159636))
- [Adds fix slash command](https://gitlab.com/gitlab-org/gitlab/-/commit/df8449bdb0427c43d9a363b831c32a7e760b0347) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158918)) **GitLab Enterprise Edition**
- [Add org to sbom source](https://gitlab.com/gitlab-org/gitlab/-/commit/1715cedb49c2506d5fca15d704d3f86d36821477) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158485)) **GitLab Enterprise Edition**
- [Add member_role_id to group_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/85cd7275e9c3d8bf00e03a3cd75cd978345a2f44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157256))
- [Add filters to import source users Graphql resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/4367038ba3b29ffbd35adb2c05d560ee87770e12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157710))
- [Added .cjs & .mjs matching to SAST CI templates](https://gitlab.com/gitlab-org/gitlab/-/commit/1c9bc1bdd489a05571f49ee2c49feadff76f203b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158767))
- [Access runners via `admin_runners` permission](https://gitlab.com/gitlab-org/gitlab/-/commit/6a49cd658821da314c257b4664965a93bec0a0bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156840)) **GitLab Enterprise Edition**
- [Add job action mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/d3acd6b46aa6d4ee3883c1d9ed2cf84bce82bb2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159143))
- [Add mergeTrainCar to MergeRequestType](https://gitlab.com/gitlab-org/gitlab/-/commit/f85136af4fcb10b3c0c2be3f692a8f9bbdd23a0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158832)) **GitLab Enterprise Edition**

### Fixed (143 changes)

- [Revert "Refactor lavel filter to use labelName attr"](https://gitlab.com/gitlab-org/gitlab/-/commit/a9940b2fdadc92945033a672ad7013f2761afab1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162463)) **GitLab Enterprise Edition**
- [Fix empty dependency list page](https://gitlab.com/gitlab-org/gitlab/-/commit/d6e287a8105b9b82df47901dfb2afccd842d7a0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162352)) **GitLab Enterprise Edition**
- [Fix bug with pasting retina images](https://gitlab.com/gitlab-org/gitlab/-/commit/b6b5d92918da5101d6247d984abdf6e9b7a3785a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161676))
- [Hide invalid closing issues on merge request](https://gitlab.com/gitlab-org/gitlab/-/commit/fb158fa6ae8e2203afb4bd4ac8c82854dc064835) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161940))
- [Fix text on badge for health check](https://gitlab.com/gitlab-org/gitlab/-/commit/0e35d794ea5f0ea1ddc9401702b85ce8b6e5d782) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162309)) **GitLab Enterprise Edition**
- [Kubernetes agent access for protected branches: Mention feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9eca5ac0b5544050f69557245c1cb7b5de0fb5dd) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162221))
- [Fix repo instructions border radius](https://gitlab.com/gitlab-org/gitlab/-/commit/ca58515ac6ea566f04cd8ac54d3ef7c1fcfd2db2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162210))
- [Project Admin - Fix delete project after email message](https://gitlab.com/gitlab-org/gitlab/-/commit/6e68238a418b05cbfec6cda8e4fe79056dde58ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162095))
- [Unify branch protection on rules details with repository settings](https://gitlab.com/gitlab-org/gitlab/-/commit/35bfcc2fa4ba9f6d5abc016988391a9faf372e7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161924)) **GitLab Enterprise Edition**
- [Fix wrong project in the connect command](https://gitlab.com/gitlab-org/gitlab/-/commit/ffab6b684b4a2309fba41b5c240eda718e91037d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162025))
- [Fix installable scope for inherited classes](https://gitlab.com/gitlab-org/gitlab/-/commit/9db09c1ed732c5ddbef44a3ec4dfb56dc9311683) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161203))
- [Prevent re-enabling project sharing when user cap is set](https://gitlab.com/gitlab-org/gitlab/-/commit/42a9fc58c416ca2c6a81df5ed4e93994014c785b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161655)) **GitLab Enterprise Edition**
- [Add Heading 5 and 6 to text style dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/834f2ce2e15b05dabc1c736b4ae01f95bfefb0ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162090))
- [Fix model artifact upload bug](https://gitlab.com/gitlab-org/gitlab/-/commit/4713c757ed46320eb41bcf58d60a035a2cb51f02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162080))
- [Properly handle empty repository.ff_merge in FromTrainRef merge strategy](https://gitlab.com/gitlab-org/gitlab/-/commit/e76a9f9e773459e338b69557ef813cbe626216d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162077)) **GitLab Enterprise Edition**
- [Update synthetic note](https://gitlab.com/gitlab-org/gitlab/-/commit/a286542db4637a333ff79f9c56851777cb795be3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161815))
- [Frecent Items - Use fullPath over webUrl](https://gitlab.com/gitlab-org/gitlab/-/commit/7d2ff723041450d47634e57c34be436d774e06eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161024))
- [Fix feature flag check for](https://gitlab.com/gitlab-org/gitlab/-/commit/dfe1ea1c64dffcbf9c12f409a198cc2cc264a77d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161764)) **GitLab Enterprise Edition**
- [Fix policy scope checker for multiple project compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/22a09c812866fad423333c220d48b3b97d62a8b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162058)) **GitLab Enterprise Edition**
- [Fix quick action urls in work items](https://gitlab.com/gitlab-org/gitlab/-/commit/5c89d2b552bc7ba59cdd9b0a8f2ac843bdc79f31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160202))
- [Catch BlockedUrlError when dispatching external status check](https://gitlab.com/gitlab-org/gitlab/-/commit/fc6e01679ca2cfa8967551e7ddfddacfbf5f13a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161652)) **GitLab Enterprise Edition**
- [Add correct check method for ga ai features](https://gitlab.com/gitlab-org/gitlab/-/commit/d3a92a962900782f1f8fca700c62c87169740c1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161779)) **GitLab Enterprise Edition**
- [Add license check to cs for registry](https://gitlab.com/gitlab-org/gitlab/-/commit/ae0a44e86a5ff061d0082b5f5bd1df84ffa2a83e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161771)) **GitLab Enterprise Edition**
- [Fix work item parent links namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ab928d1dcd2eedbdcf3d9dbe60637cf9e98c2878) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160264))
- [Delete existing policy reads for invalidating policy edits](https://gitlab.com/gitlab-org/gitlab/-/commit/af6ddb0a40f529916d875fa80bffcb6664176ea9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161324)) **GitLab Enterprise Edition**
- [Fix removing conan manifest recipe file by cleanup policy](https://gitlab.com/gitlab-org/gitlab/-/commit/225d6dd534f1a91b5472608bed748294e81bea79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160728))
- [Fix timestamp values in Arkose Data Exchange payload](https://gitlab.com/gitlab-org/gitlab/-/commit/bcf4a3a219eb7cf26dd1f9b914a23f1e79b09711) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161562)) **GitLab Enterprise Edition**
- [Handle invalid webhhook receiver gzip response](https://gitlab.com/gitlab-org/gitlab/-/commit/25ac407627261ceb02167cc5aa60685281652c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161842))
- [Adjust alignment of codeblock "Copy code" button](https://gitlab.com/gitlab-org/gitlab/-/commit/2a6897e0a177267c85e058c372c46e03ead03e2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161835))
- [Make full log viewer section parsing more strict](https://gitlab.com/gitlab-org/gitlab/-/commit/ce307719f1c556e70925d855d9621c720863f5fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161158))
- [Exclude deleted projects from GetProjectsQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/7313f4f624d9b983c212751d08ab38535e7a1662) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161762))
- [Fix vulnerability statistics bug](https://gitlab.com/gitlab-org/gitlab/-/commit/aef900932dbb52e8669719c7b13425e6351d9ecb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160541)) **GitLab Enterprise Edition**
- [Fix missing dependency project dropdown on narrow screen width](https://gitlab.com/gitlab-org/gitlab/-/commit/335412bf3aadabdeaf77207140d1d658f3cc8f70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161153)) **GitLab Enterprise Edition**
- [Backfill verification state table only for enabled replicators](https://gitlab.com/gitlab-org/gitlab/-/commit/0935b5f1c632980c134f3a15a1807949eb956e3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161378)) **GitLab Enterprise Edition**
- [Enable project_daily_statistic_counter_attribute_fetch FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/2617928c9542ce5d44a00251a510269815058edb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161498))
- [Mark projects as vulnerable in CVS logic](https://gitlab.com/gitlab-org/gitlab/-/commit/461023e6a28b04734c4ef5e96a44e60a2eac28ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161178)) **GitLab Enterprise Edition**
- [Fix train removal toast](https://gitlab.com/gitlab-org/gitlab/-/commit/cfbea1c00b83deea20b45c5bb74c9667a4feccd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161080)) **GitLab Enterprise Edition**
- [Fix SBOM merge report service when merging tools of mixed structure](https://gitlab.com/gitlab-org/gitlab/-/commit/49c68f2033407b0ebf6c129ae57e9c1e31b0d74b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161066)) **GitLab Enterprise Edition**
- [Fixes `output_safety` in integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/3df8c5399a59af1c2d5bb15fc42f20df869e93b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161443))
- [Fixes disable style ANSI sequences in full log viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/16502a77d87ade28d14578ef0895dc078a4e90ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161438))
- [Atomically refresh branch/tag cache in PostReceive](https://gitlab.com/gitlab-org/gitlab/-/commit/d19fbcf8f0a0f7fa059720e0b61e8ee280066c69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160946))
- [Handle error when create directory params are missing](https://gitlab.com/gitlab-org/gitlab/-/commit/79ff2da0a892a1f7eea28a3f42f2eeee0fc96c9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161038))
- [Add a batch migration to nullify organization_id for Project snippets](https://gitlab.com/gitlab-org/gitlab/-/commit/a1a7caeff584797876a64671ee32ba3c8a0f363a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160838))
- [Project Topics - Allow new topics created always](https://gitlab.com/gitlab-org/gitlab/-/commit/b3c8922ebbbfc21d2fbf303225562fd35d8ffef3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160759))
- [Fix broken docs links in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/0c502a88a54a12c14b588536ec26a5922ea58de2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160965))
- [Fix segmented export zero division error](https://gitlab.com/gitlab-org/gitlab/-/commit/1f4379f4be883b6dbc90e2467099d538e833b017) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161294)) **GitLab Enterprise Edition**
- [Fix custom role name for admin user views](https://gitlab.com/gitlab-org/gitlab/-/commit/385c945918b821956c6214b3a87af4ff20836069) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160366)) **GitLab Enterprise Edition**
- [Break words in legacy user dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/5d3ae67dcfb9e86e64742902264d611cc30d37f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161220))
- [Use generated identifier for chart range data](https://gitlab.com/gitlab-org/gitlab/-/commit/7761273551a9d7d13a0416a816725399dd4cd442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161138)) **GitLab Enterprise Edition**
- [Allow to edit files from a commit or tag with WebIDE](https://gitlab.com/gitlab-org/gitlab/-/commit/cf6e2631e509259dc4d4ca63dca765e693817618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159557))
- [Ensure DiffCollection is not empty when applying each_gitaly_patch](https://gitlab.com/gitlab-org/gitlab/-/commit/d516b1c598271ebfa55549e2d1b56f7f27cf9904) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160120))
- [Fix cluster check metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/d101b7b50d36e4d68617d79cef91fc5d88f1fb58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161042)) **GitLab Enterprise Edition**
- [Fix missing CSS variables in jira_connect app](https://gitlab.com/gitlab-org/gitlab/-/commit/340652cf2fdf0bef6d6a8208e4864423ad77b0d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160998))
- [Fix toggle replies widget regression](https://gitlab.com/gitlab-org/gitlab/-/commit/05621599c66336b00abdba8b41f85083b0d643ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161136))
- [Update graphql specs in preparation of gem upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/5a133c589ef180d0237bd1b81efab2d1d76a23a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160406))
- [Cleanup allow_custom_root_folder_name_in_npm_upload FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5b6b6659dec396e0c9facd94186aaa185dbda9f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161004))
- [Fix upload after comment preview bug](https://gitlab.com/gitlab-org/gitlab/-/commit/eebcd541b2b9b3685a7026c0306d30df3aa7b7c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161085))
- [Do not index associated issues that are epic work item type](https://gitlab.com/gitlab-org/gitlab/-/commit/fad44730896ff5920f3b89c7f7a5df554579a280) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160656)) **GitLab Enterprise Edition**
- [Re-add no-enforce-focus prop on checkout modal](https://gitlab.com/gitlab-org/gitlab/-/commit/2adad9bdc19b6b836ae7fbee19bcc0eaffb8b7a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161059))
- [Internationalize dates within issues](https://gitlab.com/gitlab-org/gitlab/-/commit/e8f58926e4f9b17fc998b3e09e17903975df3a14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161058))
- [Fix tooltip for suggested similar issue state icon](https://gitlab.com/gitlab-org/gitlab/-/commit/bdc2287eb511c1f20fe65563b46e40b8dbcb4e1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161062))
- [Add a validation for default branch name in group settings](https://gitlab.com/gitlab-org/gitlab/-/commit/09c12b0d76231cedec2288c10212c838fad1612f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160220))
- [Mark project as vulnerable while creating vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/b3d83e367d12584b3b39a5c597de9616f4c18f05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160851)) **GitLab Enterprise Edition**
- [Ignore not search params which are not hashes](https://gitlab.com/gitlab-org/gitlab/-/commit/fb65f91d89d823a33ff1dd96aeb03f77d5d7f0b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160801))
- [Fix help icon shrinks when there are many code owners](https://gitlab.com/gitlab-org/gitlab/-/commit/69741fd1307e49d800d130885b494c9b369e512d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161006)) **GitLab Enterprise Edition**
- [Fix clear bug in create view for health status widget](https://gitlab.com/gitlab-org/gitlab/-/commit/001c2b00045996c3ed888dcafa44841e058f2ff8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160863))
- [Add clipboard btn hover state to checkout MR instructions](https://gitlab.com/gitlab-org/gitlab/-/commit/202759422141aac7fc5940ac2ba22bcda5d77eb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160901))
- [Fix Explain vulnerabilities with AI loading state](https://gitlab.com/gitlab-org/gitlab/-/commit/da739d45d24b8f0f32e24d90aa5e52270728062a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160295))
- [Fixes `output_safety` in integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/25826806ac0eb5a8afc25ed4a4e65be66717306b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160889))
- [Use explicit rule names to avoid flaky specs](https://gitlab.com/gitlab-org/gitlab/-/commit/accc6b0a9bb40c59dcf3b5598d38bf7a69de7e49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160436)) **GitLab Enterprise Edition**
- [Fix GraphQL query returning less than expected projects](https://gitlab.com/gitlab-org/gitlab/-/commit/cc852530b1cef3cdea49ddeb941c3483c6ea55dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160592))
- [Update specs for upcoming graphql upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/2982d156ae61506528f040b7aeaee6c6c4acf1b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160768)) **GitLab Enterprise Edition**
- [Update publish a new release docs link](https://gitlab.com/gitlab-org/gitlab/-/commit/c6e22939a560e089d31e562700b487ac17d34663) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160298))
- [Make sure broadcast notifications do not affect broadcast message height](https://gitlab.com/gitlab-org/gitlab/-/commit/9d4d284a27b016cdb9733b210b8699988f99d537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160787))
- [Reset request data on each filter](https://gitlab.com/gitlab-org/gitlab/-/commit/2063f10ea6248b68b9e481ccf128bcfba70764d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160789))
- [Fix Roadmap not loading when epics have private parents](https://gitlab.com/gitlab-org/gitlab/-/commit/9804dc275b031fb562ce9ef4ddebbc2030a26ae6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160785)) **GitLab Enterprise Edition**
- [Fix new epic work item email](https://gitlab.com/gitlab-org/gitlab/-/commit/d59aaf9efebdfda702d39d750e711af11161e7a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159153))
- [Add missing breadcrumb items to several admin edit pages](https://gitlab.com/gitlab-org/gitlab/-/commit/5bd35d91018780ea85d66b6e8d0f467d7fff4f41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160584))
- [Update graphql specs for coming upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/8f18df634e45c5fe4b7b39f589a18fcb03b028f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160256))
- [Fix badges in runners admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/dbeb6854984f16d9590cad145a86ffcaccbb8ea9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160201))
- [bug: Fix template error due to divided by zero](https://gitlab.com/gitlab-org/gitlab/-/commit/6932a73ea7174eb718c41dd0f743aba7d3f9b133) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160628))
- [Use autolinker filter for commit descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/88559d7f2cb9f3360f336f8bab86735ed95e3150) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160653))
- [Drop sequences that should no longer exist in database](https://gitlab.com/gitlab-org/gitlab/-/commit/5bc47e37a4a3e624f3b1eacb722b712e1f76a978) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160624))
- [Ignore unknown sequences in sequence fix migration](https://gitlab.com/gitlab-org/gitlab/-/commit/61497ca0b7591a3791c2fef46ac3356438301b38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160609))
- [Fixed Zoekt forks filter behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/805a046c5bb39e04e233bc20219a1ebd9f8cd761) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159893))
- [Scrub non-UTF characters from context chunk](https://gitlab.com/gitlab-org/gitlab/-/commit/85997d78685e1af62ef5c5c7e8970f517579eb07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160580))
- [Add support for redirects to go-get middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/41104091f54467e5cb0f8a144b1d88e29845229f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160571))
- [Update postgres_sequences view](https://gitlab.com/gitlab-org/gitlab/-/commit/a001714616c26794c658ceacff0f360730ee02a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160555))
- [Break words in code blocks in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/f8a4afd302a195949ab23df03e44c89eb88ee6de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160550))
- [Fixes `output_safety` in integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/25169f31d4f1797943337fbdcd7cd2e6e35ffca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160535))
- [Fix project name truncation in dependency project count dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/100812c841c252385d6f360c7b87a866fcf2a40d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160363)) **GitLab Enterprise Edition**
- [Fix SQL query for finding sequences owned by table](https://gitlab.com/gitlab-org/gitlab/-/commit/8273652656c573060f403864c123f46128873f4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160528))
- [Use a separate Redis key for rescheduling jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/83584a23b2de403dd7d86a3c07aa8ae96339ebae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159215))
- [Prevent CS SBOM to be parsed as ready for License Scanning rules](https://gitlab.com/gitlab-org/gitlab/-/commit/19c0c8025de3c20510a7a4c22f4f49d3646019d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158831)) **GitLab Enterprise Edition**
- [Clear Gitlab::Geo.proxied_site memoization](https://gitlab.com/gitlab-org/gitlab/-/commit/23e6703d77d0164a8ac78c18d39834f9872956aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160479)) **GitLab Enterprise Edition**
- [Fix clear button in deprecated jQuery dropdown filter](https://gitlab.com/gitlab-org/gitlab/-/commit/47160352e1c0c080f74622881f092657eb7e3550) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160419))
- [Restrict project ID parameters for GAR setup scripts](https://gitlab.com/gitlab-org/gitlab/-/commit/a1d0936d27905409436ea27331e5ee044c1ffbf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156701)) **GitLab Enterprise Edition**
- [Connect null data points in Value Stream Dashboard sparklines](https://gitlab.com/gitlab-org/gitlab/-/commit/681a79ee8bae85910a6790f5ba88c2fac868555f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160444)) **GitLab Enterprise Edition**
- [Skip issue due date validation on work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/da9436fd59253b263f6808bc4d6144ce2e101522) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160442)) **GitLab Enterprise Edition**
- [Update graphql specs in preparation of gem upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/42b63e3b66a9691660411320109b064cf8694d29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160421))
- [Restore collapsible sections in job log viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/5ccb81bb681661056ebed90c0aa56607f40e9d8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160403))
- [Improve image resizing in rich text editor](https://gitlab.com/gitlab-org/gitlab/-/commit/21afdd759ad5b38cc0380614c68742baa357723d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160357))
- [Fix auditor permission in group VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9cb9f6e1be36c18933040d1b30aa0292e53ddb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159530)) **GitLab Enterprise Edition**
- [Fixed empty tooltips in usage trends count charts](https://gitlab.com/gitlab-org/gitlab/-/commit/085d947a0626d0a29afae2af4cb55501d7cf68c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159906))
- [Keep hover effect on section title when flyout is hovered](https://gitlab.com/gitlab-org/gitlab/-/commit/7d6865ec054d109b07352747d41d6d6c51ddb301) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160233))
- [Fix missing spdx licenses in the policy editor](https://gitlab.com/gitlab-org/gitlab/-/commit/c95a042e5ad9cac89c30d71d18bd8aadde570789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159889)) **GitLab Enterprise Edition**
- [Fix duplicated projects in listbox](https://gitlab.com/gitlab-org/gitlab/-/commit/412a8488278f13c29461c4015f6739a4b54e69e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160065))
- [Status badge: Fix use of icon](https://gitlab.com/gitlab-org/gitlab/-/commit/5296f6d0a605bd1bf3e0c2ec2cc714ea47cf5a20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160028))
- [Fix bug with deployment score calculation](https://gitlab.com/gitlab-org/gitlab/-/commit/5b047ec1624d65cb61b47c02c14fe3cd4456c7f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159875)) **GitLab Enterprise Edition**
- [Fix approval policy to include group level protected branch](https://gitlab.com/gitlab-org/gitlab/-/commit/a5e6851bd08555219e538718c00331722186b074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157301)) **GitLab Enterprise Edition**
- [Fix publishing npm package with custom root folder name](https://gitlab.com/gitlab-org/gitlab/-/commit/cd68d1cfa9c3458edf7e14daa2ef63c687326e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159095))
- [Handle Browser::Error exception](https://gitlab.com/gitlab-org/gitlab/-/commit/72ac5e90bb88c9f28f16b11c9653cf06249ce074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158800))
- [Remove project_ref_name_in_variables FF](https://gitlab.com/gitlab-org/gitlab/-/commit/966cad99bf60f18ea0f2a2c8080829dfb5bcbd64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160190))
- [Fix missing/incorrect linked work items from other namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/cd8e42f29ac741f54c9ed290020fd8f64627b8fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160181))
- [Fix SBOM export when tools property has different structure](https://gitlab.com/gitlab-org/gitlab/-/commit/f0197f5a9fb5b085288ae3cee9f0627b14f05c4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159456)) **GitLab Enterprise Edition**
- [Fix PEP when SEC is available](https://gitlab.com/gitlab-org/gitlab/-/commit/ca0d7833a0c6d47484428d7ec3dc30bb51389d29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159845)) **GitLab Enterprise Edition**
- [Add validation for vulnerability identifiers](https://gitlab.com/gitlab-org/gitlab/-/commit/c96afeb84597ad77eb91e4ca4e66faa7ab31d040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160011)) **GitLab Enterprise Edition**
- [Improve printing functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/678ea62e707229b257aaa8f7b4361ce687827487) by @yanglb ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157906))
- [Added Instance scope as valid audit entity type](https://gitlab.com/gitlab-org/gitlab/-/commit/15e37257e930e862678c916e23027c3ea2081506) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157271)) **GitLab Enterprise Edition**
- [fix: Only run advanced SAST job when Ultimate license present](https://gitlab.com/gitlab-org/gitlab/-/commit/7f932fed45120a5ac122e513651e3ee78b185ece) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159238)) **GitLab Enterprise Edition**
- [Pipeline dropdown: Fix spacing and border-radius](https://gitlab.com/gitlab-org/gitlab/-/commit/486b7eb4159f23abe1d07f96d8f02859e7a8ef66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159760))
- [Add copy timelog logic when moving issue](https://gitlab.com/gitlab-org/gitlab/-/commit/352306f235d22a7a56338df397791fddea46d663) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159860))
- [Use SpinnerComponent in users groups/projects view](https://gitlab.com/gitlab-org/gitlab/-/commit/b3f354bef03c94a57a2d72abc6d6052c6eab824b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159820))
- [Remove padding if sections settings have no border](https://gitlab.com/gitlab-org/gitlab/-/commit/46962e77d9c8544a94459d5a86df186f30955b26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159791))
- [Fix merge request list icon alignment in Safari](https://gitlab.com/gitlab-org/gitlab/-/commit/28092994d3a91183c059e6ab97e3a157a1284abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159788))
- [Updates container registry set up cleanup link](https://gitlab.com/gitlab-org/gitlab/-/commit/9f0f237a3c59aadb844a46bb38ba874528ede8db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158015))
- [Fix invalid X-Next-Page header for the first page](https://gitlab.com/gitlab-org/gitlab/-/commit/4b56a5d22e781f80ab1545f430ee472d3ac0e72d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159747))
- [Provide a full commit sha to `CommitReferences` query](https://gitlab.com/gitlab-org/gitlab/-/commit/3d0c244844cd0beae6dc34c816d8f5dbff49b5b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159719))
- [Remove full screen button at ML Model creation](https://gitlab.com/gitlab-org/gitlab/-/commit/1099e7ae1e30149478bd5e7f3f2f130832c238ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159554))
- [Remove uplaods and redirects file results from wiki basic search](https://gitlab.com/gitlab-org/gitlab/-/commit/b2f141946446f70d2c3ddd0ad36c9a3e8a7d35e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159219))
- [Ignore default before and after_script for Scan Execution Policies](https://gitlab.com/gitlab-org/gitlab/-/commit/0e2d85a7875cac86767cbe4d7f083f31adfadfda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159486)) **GitLab Enterprise Edition**
- [Prevent dragging board list if not editable](https://gitlab.com/gitlab-org/gitlab/-/commit/c08b156ae647b446a36e0b31378713d67a191ac5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159605))
- [Prevent export finalisation from overrunning the expected duration](https://gitlab.com/gitlab-org/gitlab/-/commit/c5cab9f41e62c38382435447a2b1b78990bc29da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159546)) **GitLab Enterprise Edition**
- [Release jira_connect_proxy_create_branch](https://gitlab.com/gitlab-org/gitlab/-/commit/554284bd4fb94e6f15f8a68f682643139eca1087) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159413))
- [Display all seats user banner when there is an overage](https://gitlab.com/gitlab-org/gitlab/-/commit/8db6684a285f4bfed1014d7c0bb17670ec9a6452) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158718))
- [Revert "Align the visual presentation of the action between groups and projects"](https://gitlab.com/gitlab-org/gitlab/-/commit/88b48fc9d3c7bd12265d37dfb288ea39852cd374) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159499))
- [Your Work Projects - Fix improper index import](https://gitlab.com/gitlab-org/gitlab/-/commit/e38ffb1b3520e94b1744dbfa27ee98b91f45d657) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159465))
- [Make sure group path is used for getting list of frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/114fb8a7f17917a0d8234830c3f52017359a4b72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159367)) **GitLab Enterprise Edition**
- [Fix pending members member link](https://gitlab.com/gitlab-org/gitlab/-/commit/98d559247cf5dc0d4febdc5f12e90d6261766999) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159134)) **GitLab Enterprise Edition**
- [Show download button in narrow viewports in repo directory view](https://gitlab.com/gitlab-org/gitlab/-/commit/7f8a534bcb1b890c7bdb8e56c5ba24ca395a6fe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159157))
- [Fix namespace path in pending members page](https://gitlab.com/gitlab-org/gitlab/-/commit/272a00240a33fd79a4bcf784eb3793fda1784ccf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159132)) **GitLab Enterprise Edition**
- [Use shared lock for SBoM ingestion and sync workers](https://gitlab.com/gitlab-org/gitlab/-/commit/f1cb744debcf70d4c963da5e720d7b894fa647e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158816)) **GitLab Enterprise Edition**
- [Fix Changelog error on Non-encoded Commit Trailers](https://gitlab.com/gitlab-org/gitlab/-/commit/8a650540c9b5489dc4113d837107637052cb73ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158191))

### Changed (226 changes)

- [Ignore unused columns in onboarding_progress and remove all references](https://gitlab.com/gitlab-org/gitlab/-/commit/698a09cd4fe20ae5dc5ebdc071787b5a35419d81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160892))
- [Enable self-managed UI bulk assignment/unassignment feature by default](https://gitlab.com/gitlab-org/gitlab/-/commit/883062561bee9758dc58d1389a0c66adcf1da0d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162405))
- [Enable traversal_ids for all project search queries](https://gitlab.com/gitlab-org/gitlab/-/commit/8875e07dc46f47c2ef9850bb958f131d5c27c00b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162198)) **GitLab Enterprise Edition**
- [Improve Cloud Connector status host probe](https://gitlab.com/gitlab-org/gitlab/-/commit/9f8b013f28da0a4c79a80443a5e9c9ae364717f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162141)) **GitLab Enterprise Edition**
- [Transition dast_site_tokens to loose foreign keys](https://gitlab.com/gitlab-org/gitlab/-/commit/06123667885295db935337ab8427c19e73982199) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160996))
- [Lower sync event table partition cleanup threshold to 30 days](https://gitlab.com/gitlab-org/gitlab/-/commit/1a46844e42523294f5230b6a944602da7748dd49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162273))
- [Hide search panel when user has no groups](https://gitlab.com/gitlab-org/gitlab/-/commit/202b36099a2c405302972e97ac5c13c3234c4c4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162034))
- [Requeue backfilling of work_item_dates_sources](https://gitlab.com/gitlab-org/gitlab/-/commit/7ab3e1ccd60899b7f90a0cd1fd38f8d8d0197a0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161847))
- [Show empty state also in workspace tab](https://gitlab.com/gitlab-org/gitlab/-/commit/c2cec3dc520a517eb5e9e06e46e0982c138b5c55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161690))
- [Migrate title and cards in ssh key detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/af3934ac4e70ce8a70a5d1838e7151d4d4f22fae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162340))
- [Add database index on emails to detumbled_email column](https://gitlab.com/gitlab-org/gitlab/-/commit/f0b244c043f4a37b17dd35261f09c6a05eced163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162336))
- [Find zoekt index through repository if exists](https://gitlab.com/gitlab-org/gitlab/-/commit/dff4adad7a479232c6872f0ea0119d06788ed768) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161212)) **GitLab Enterprise Edition**
- [Groups Projects - Consistent pending delete alert](https://gitlab.com/gitlab-org/gitlab/-/commit/a247405bce52d3b55daa84f07c1670d68f902d29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161653))
- [Makes job log color palettes consistent](https://gitlab.com/gitlab-org/gitlab/-/commit/691ad73b603e3e119ac4f20b5f90a027b2f1d278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161742))
- [Remove redirect to clear settings for self-managed provider](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1600129a4ace031258439d2a029f2c30625804) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160669)) **GitLab Enterprise Edition**
- [Scheduling service skips cache in non prod environments](https://gitlab.com/gitlab-org/gitlab/-/commit/406e1b9820fb609dab033456bb086978f610f014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161104)) **GitLab Enterprise Edition**
- [Add framework id popover](https://gitlab.com/gitlab-org/gitlab/-/commit/2b65c268bb82c4a0f8608e9dfcc6aaa8799ad9b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162037)) **GitLab Enterprise Edition**
- [Update redis-store gem and drop custom patch](https://gitlab.com/gitlab-org/gitlab/-/commit/0463deff4d61c5c2017983061041898e3c30999d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162257))
- [Expose pre_receive_secret_detection_enabled in the API](https://gitlab.com/gitlab-org/gitlab/-/commit/e740fe906623db3184ca26ddbbe8b601a0df5374) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160960))
- [Remove gl-new-card-body from terms card](https://gitlab.com/gitlab-org/gitlab/-/commit/7dd7bc64c0e13ca414e1797c910b168370d8c862) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162204))
- [Migrate branch rule details cards to crud components](https://gitlab.com/gitlab-org/gitlab/-/commit/6b3507fce557908e4c3259f1befb46c28155ba6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161965))
- [Remove `Security::ReportFetchService` and refactor tests](https://gitlab.com/gitlab-org/gitlab/-/commit/6fdfd67dab49af358fe288684827234c470a6f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161944)) **GitLab Enterprise Edition**
- [Default-enable Cloud Connector status FF](https://gitlab.com/gitlab-org/gitlab/-/commit/4362d74ea185b10ada3bbe1661ca44c5eb4d4ec8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161997)) **GitLab Enterprise Edition**
- [Enable rewrite_history_ui feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d0876ad33fdf10e0bc6bb7713d8153b7c4fd04ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162057))
- [Adjust the visual styling of health check](https://gitlab.com/gitlab-org/gitlab/-/commit/c8697c35679108f467286e3e3371ba48802d272b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161928)) **GitLab Enterprise Edition**
- [This MR adds an icon for disabled policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5b767435aaa8dc97299117ddf43455d89e6b0ec7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162040)) **GitLab Enterprise Edition**
- [This MR adds new badge to status check table](https://gitlab.com/gitlab-org/gitlab/-/commit/93f8988fe2caa22346144b3ddc6ac03aed57b5ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160652)) **GitLab Enterprise Edition**
- [Quarantine spec for old background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/54ff5d0fbb9f9d0e1e23b4dd455657eb9aafa86f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162167)) **GitLab Enterprise Edition**
- [Update terraform empty state illustration](https://gitlab.com/gitlab-org/gitlab/-/commit/bd6e1d28f62002e296b56b67d304101f42b680ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162164))
- [Notifications page: Migrate components used](https://gitlab.com/gitlab-org/gitlab/-/commit/5920871c2472b94dba3f2b6b5bedc1dfc9885669) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161592))
- [Update tags page](https://gitlab.com/gitlab-org/gitlab/-/commit/eb40d8e51dab2d4a906bf11daf9d4c079dcc6f29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162045))
- [Update blocked and blocking icons based on new direction](https://gitlab.com/gitlab-org/gitlab/-/commit/19b73359acbeb7fb43188ab2723abc5806e6e4bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161348))
- [Remove gl-new-card from permanent group deletion card](https://gitlab.com/gitlab-org/gitlab/-/commit/c772ee673ccdd704c2d3f1dfe385f11600b94834) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162104))
- [Move work item note loader above comment box](https://gitlab.com/gitlab-org/gitlab/-/commit/2d15743b9ba81ebe30f6db136a1580ba09a7050b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161604))
- [Remove gl-new-card from failed jobs card](https://gitlab.com/gitlab-org/gitlab/-/commit/c749280c64383d1cdce65f30fc758c1cf7d374ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161897))
- [Switch back to charlock_holmes gem](https://gitlab.com/gitlab-org/gitlab/-/commit/5caab73fb59a5e8d7c5f76a3c87037204b9bbd80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162078))
- [Set vulnerability_finding_links schema to `gitlab_sec`](https://gitlab.com/gitlab-org/gitlab/-/commit/46969d0b2709ac910dd73a20b7e5a15d096de738) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159122)) **GitLab Enterprise Edition**
- [Replace subtle text color style with description label default style](https://gitlab.com/gitlab-org/gitlab/-/commit/ce07132763cb187d1d2c93dafd05cd8caa344c45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162053)) **GitLab Enterprise Edition**
- [Remove gl-new-card from pipeline editor card](https://gitlab.com/gitlab-org/gitlab/-/commit/5b94235f6fcd255f7df0a35ab792db0ad2e53269) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161941))
- [Distinguish index on tags](https://gitlab.com/gitlab-org/gitlab/-/commit/13eb9e4cac6f818a22aefe725c06d4783ede7d8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161644))
- [Remove gl-new-card from group advanced settings](https://gitlab.com/gitlab-org/gitlab/-/commit/40a0b210d920389fbccf9e3c20344b24fce9739c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161838))
- [Rephrase policy bot message errors](https://gitlab.com/gitlab-org/gitlab/-/commit/0ba0f9c1c018bfd1bef97fd2360c843447756bfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161920)) **GitLab Enterprise Edition**
- [Removes the note about billing quotas on the PA GitLab managed provider](https://gitlab.com/gitlab-org/gitlab/-/commit/344ada30e40c3bd856217c8b9665f70e971ed4f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161921)) **GitLab Enterprise Edition**
- [Decrease space between log lines](https://gitlab.com/gitlab-org/gitlab/-/commit/2dfff64d856f3cda3a682039deb67e961b94ed75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161912))
- [Avoid TemplateFinder instantiations](https://gitlab.com/gitlab-org/gitlab/-/commit/6c0766720ebb27e36499dd05a78dbc6492a93736) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157781)) **GitLab Enterprise Edition**
- [Remove search_issue_refactor feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/567bbc5e97bbe2f2aa2c5c717e400a45b5adeb26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161521)) **GitLab Enterprise Edition**
- [Unbox the add license section](https://gitlab.com/gitlab-org/gitlab/-/commit/722f7fe1347ea9e34eeb6943e0ade7441de79f65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161852)) **GitLab Enterprise Edition**
- [Move provider selection component error state inline](https://gitlab.com/gitlab-org/gitlab/-/commit/d163db4412b742978bce724dae7d67eb52f4e026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161109)) **GitLab Enterprise Edition**
- [Add header to contributor analytics page](https://gitlab.com/gitlab-org/gitlab/-/commit/017a8d9686c4ec029aa6bcbab0110d620171cdb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161831))
- [Sentence case access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/7365a54f6a894383cb92a18b8a4920bb860df38f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161074))
- [Refine the activation modal](https://gitlab.com/gitlab-org/gitlab/-/commit/61df41e649bc52e7dc0af2b4e5c1a33dc5a25d30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160314)) **GitLab Enterprise Edition**
- [Migrate terraform states GlCard to CrudComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/09f23a94404c980b55309f37fbc62ccc5d09d7a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161520))
- [Release page: Add page title and migrate to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/665fd2c65a8e62e51c928ce0c499db3cc0fc5f98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161568))
- [Sign-out deletes only GitLab site data, not all subdomains](https://gitlab.com/gitlab-org/gitlab/-/commit/29e70fb405d8fdbf91bc3bf89dadd5250692a734) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156213))
- [Add email template for source_user rejects](https://gitlab.com/gitlab-org/gitlab/-/commit/7369619d5a390e7fabc9e15c145260440b7449ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161811))
- [Cleanup "add_validation_for_push_rules" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c4fd830334ca39e90a28de77c960cbdd6661930c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161800)) **GitLab Enterprise Edition**
- [Make color palettes in logs consistent](https://gitlab.com/gitlab-org/gitlab/-/commit/7e5232715a3aaa17786825a07766a937be7f7248) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161461))
- [Fix dark mode support in minimal and devise_empty](https://gitlab.com/gitlab-org/gitlab/-/commit/58e1cc3430f6b6671309cc0e73cdd6a34c54afd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161780))
- [Replace click with select on add license](https://gitlab.com/gitlab-org/gitlab/-/commit/2180a21b05465d8f5c62860eedecde8b42b7ffc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161499)) **GitLab Enterprise Edition**
- [Migrate workspace variables card to CrudComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/8937f5c9e770e80ec7fba10e3c763fccc4c1e10d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161650))
- [Remove new-card classes from legacy cards](https://gitlab.com/gitlab-org/gitlab/-/commit/c6c71116c85f78a262151b9df652e704fea251c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161637))
- [Fetch product analytics project settings via GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/313ab63ccbdb8b563b054a31fc9c64236a8d4d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160657)) **GitLab Enterprise Edition**
- [Hide /type quick action on epic work items](https://gitlab.com/gitlab-org/gitlab/-/commit/d9bf8cb58041ff9fb707965366ab150549f1c384) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160735)) **GitLab Enterprise Edition**
- [Simplify atomic cache/tag clear code in PostReceive](https://gitlab.com/gitlab-org/gitlab/-/commit/095a409a5e58806b8ae43d6f48f07d77a739f2a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161673))
- [Migrate dashboard projects to filtered search and sort](https://gitlab.com/gitlab-org/gitlab/-/commit/fc0906105ebfa2795b05462bcc2eaf128c815fec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159462))
- [Refactor DuoChat error display](https://gitlab.com/gitlab-org/gitlab/-/commit/3f0856245771bfd7c50ab89b7e6315af65ed370b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161508)) **GitLab Enterprise Edition**
- [Fix broadcast message dismissals cookie not restoring upon login](https://gitlab.com/gitlab-org/gitlab/-/commit/39a47e6ea6c5c1aa2103a809ec310282c0a040cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161363))
- [Update review started icon in MR sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/3418c7e6e673271fe788450c30362f0da9e1b51e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161617))
- [feat: Transition sbom_component_versions to gitlab_sec schema](https://gitlab.com/gitlab-org/gitlab/-/commit/3959cfcf93682c141465592416b36ce52c61fe83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160583)) **GitLab Enterprise Edition**
- [Deploy freeze table migration to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/f79db328fd1c02d0020db5d333c35bed77140ee7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161339))
- [Update visualization designer type selector](https://gitlab.com/gitlab-org/gitlab/-/commit/bfe99c1ae785c14041cfd37daddb93db7a77ac79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161314)) **GitLab Enterprise Edition**
- [This MR updated dispatch service](https://gitlab.com/gitlab-org/gitlab/-/commit/e4933958b7d7115774f032f11beb9e7b2af49bc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160507)) **GitLab Enterprise Edition**
- [Comments templates: Migrates components used](https://gitlab.com/gitlab-org/gitlab/-/commit/5976954c3935387921b834403574dd78fb41d70e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161301))
- [This MR adds new field to status check form](https://gitlab.com/gitlab-org/gitlab/-/commit/bb41b50f586a4636e7edee110293aeda4183c9d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159822)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.100.2](https://gitlab.com/gitlab-org/gitlab/-/commit/6d6d2e4f85a6688ac958d862691c864434574093) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161554))
- [Transition dast_site_tokens to loose foreign keys](https://gitlab.com/gitlab-org/gitlab/-/commit/b4d0172260ee9d6f5577358c3ae5122883a3fe49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160199))
- [Update CI/CD Details tab order](https://gitlab.com/gitlab-org/gitlab/-/commit/14bd72dd7aac1e4d166f3180ead7b9c266d09bff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161548))
- [Use locale date format on the custom emoji page](https://gitlab.com/gitlab-org/gitlab/-/commit/b6245df118994558bc8ec8edd0e27ac784f91074) by @NIKU-SINGH ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161361))
- [Migrate wiki history card to crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/8a56eb0c5f71ee98d0625580737cb92693972878) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161528))
- [Migrate branch rules card to CrudComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/dc3180bac8336a2ef62084db533c682009fa2cbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161460))
- [Update work item parent labels](https://gitlab.com/gitlab-org/gitlab/-/commit/9fc03497ef12ee95a8df23e9c92ba8c875ccd26e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161070))
- [Show warnings for rendered as markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/3679ede136173bfbd3b9e99f5acc64de0f87628d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160431))
- [Update gitaly servers card to CrudComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/44060e9ea82de216cb7e96916075127b71f5f19f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161344))
- [Display error when LLM determines false positive](https://gitlab.com/gitlab-org/gitlab/-/commit/66c998b228e2c8c3e4abb843a4a1e7124199423c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161190)) **GitLab Enterprise Edition**
- [Update cleanup policies page](https://gitlab.com/gitlab-org/gitlab/-/commit/b6010fd7151214d1718df2a102174510616d42a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161313))
- [Migrate badges card to crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/421861f25380548e26617487f7a63c1f7746bf90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161229))
- [Add `fallback_behavior` usage metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/cddeb2e9a797b37cb8a460803eac1d48a51fb600) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155718)) **GitLab Enterprise Edition**
- [Update welcome page question order](https://gitlab.com/gitlab-org/gitlab/-/commit/643b26800c6780f0a5babc0d039b36876ac60cc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159444)) **GitLab Enterprise Edition**
- [Migrate secure files to cardcomponent](https://gitlab.com/gitlab-org/gitlab/-/commit/6d2a08fb01c607b97b7db25762fe1aa21ad04991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161374))
- [Update prompt for Duo Vulnerability Resolution](https://gitlab.com/gitlab-org/gitlab/-/commit/1ac066bbe73f72b954966be411f6ba7f964d3c4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160098)) **GitLab Enterprise Edition**
- [Reverse order of recent month columns in VSD](https://gitlab.com/gitlab-org/gitlab/-/commit/8ca9d55964e39bfa031a51dd72dd82ed2c1ee501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154954)) **GitLab Enterprise Edition**
- [Update google-cloud-core and google-cloud-env gems](https://gitlab.com/gitlab-org/gitlab/-/commit/4e1867aeebb2a4342691a85b47282f6105eda4d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161377))
- [Migrate monitor alerts to crudcomponent](https://gitlab.com/gitlab-org/gitlab/-/commit/a99e38028de1517e03f4db29cc2fe9a2ed5306d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161370))
- [Duo Chat Retry Attempts Update](https://gitlab.com/gitlab-org/gitlab/-/commit/1d5a1735577206b317c8496d716d03aead64676c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160476)) **GitLab Enterprise Edition**
- [Does not load SSF data for disabled replicators](https://gitlab.com/gitlab-org/gitlab/-/commit/55b8934563926e368f5c4a0cd6050e4867e34976) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160623)) **GitLab Enterprise Edition**
- [Update security policies graphql API to filter policies by scope](https://gitlab.com/gitlab-org/gitlab/-/commit/2a2958de528d65757fbb4de08289e75240bf8106) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160477)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.100.1](https://gitlab.com/gitlab-org/gitlab/-/commit/6cc2f06dff1a02a8e89631259a07af5a53f5b055) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161347))
- [Set vulnerability_flags schema to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/64e2b22478352cea29e4ef2b5697bf029fd6d725) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159115)) **GitLab Enterprise Edition**
- [Update cached commit signatures when a gpg key is recreated](https://gitlab.com/gitlab-org/gitlab/-/commit/0894447ad584ef1413266a3d63e8e0ed651a99bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160928))
- [Reverify externally verified gpg keys](https://gitlab.com/gitlab-org/gitlab/-/commit/4c311635e7496889282fb78782fdcf8d463ce925) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160910))
- [Add DuoChat helper menu](https://gitlab.com/gitlab-org/gitlab/-/commit/55ffd22a8dd35ade39ceea260d25c41d711089fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161025)) **GitLab Enterprise Edition**
- [Fix issue on terms page with mermaid plots](https://gitlab.com/gitlab-org/gitlab/-/commit/f37420f31c3c87052a35658c89a7b4954b3625c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161152))
- [Update user pages empty states in admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a00c6321d4a9a8fd53f9462bb4e32be39beca1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161216))
- [Add tmp index on vulnerability_reads for bbm](https://gitlab.com/gitlab-org/gitlab/-/commit/f754febe795aa5b4b6f545ca6c9b367b65c39069) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161296)) **GitLab Enterprise Edition**
- [Update merge request template copy](https://gitlab.com/gitlab-org/gitlab/-/commit/2ff26859ba57d2e7e8841f0dd75e2c3b17510c06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161283)) **GitLab Enterprise Edition**
- [General improvements in the terms pages](https://gitlab.com/gitlab-org/gitlab/-/commit/e5920242c4864c063b51b9a39027ac9e6c1045d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142685))
- [Change the alert message for the invalid invite](https://gitlab.com/gitlab-org/gitlab/-/commit/11287453ffe669db3df40a50375af9aecc1109c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160950))
- [This MR updates approval selector](https://gitlab.com/gitlab-org/gitlab/-/commit/bad89d95f0dac575068509d3c49cbb89729f9c0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160809)) **GitLab Enterprise Edition**
- [Migrate Analyze page headings](https://gitlab.com/gitlab-org/gitlab/-/commit/71c2ca629bce456430346ef364cd4ceebee98841) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160726))
- [Update BBM status](https://gitlab.com/gitlab-org/gitlab/-/commit/17c45e8fcbfb86a9e00ec66f8743026822af85dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160630))
- [Use `gl-text-subtle` instead of `gl-text-secondary` in crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/8821e026827589c125bfc20314a58d6f07bd9b90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161077))
- [Migrate header components in tags and compare revisions](https://gitlab.com/gitlab-org/gitlab/-/commit/875d821590c89f9a077e052e9abae95d25ff5561) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161028))
- [Add "Why GitLab Duo?" section to Duo Pro trial discover page](https://gitlab.com/gitlab-org/gitlab/-/commit/f8ebda46dc5686524aa0f491a72ae33916ea9bcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158977)) **GitLab Enterprise Edition**
- [Refactors primary keys validations](https://gitlab.com/gitlab-org/gitlab/-/commit/3ea64fe7089678eb5cde609d008eb18d13dcb18f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160953)) **GitLab Enterprise Edition**
- [Labels: Migrate label-badge](https://gitlab.com/gitlab-org/gitlab/-/commit/8d2a4747b7edae00afdb154b037e809c23f497e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160833))
- [Remove MemberRole ignored columns](https://gitlab.com/gitlab-org/gitlab/-/commit/ab060799371aa52a269f18f82f90488d31ce4ffa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161194)) **GitLab Enterprise Edition**
- [Issue closing pattern works with work items](https://gitlab.com/gitlab-org/gitlab/-/commit/a9d873c24cca2a764fbebd66ed4091c73b354b43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160324))
- [Update runner edit form](https://gitlab.com/gitlab-org/gitlab/-/commit/33b05d6188f771e27257e9288c33912a42a60bd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159733))
- [ViewComponent documentation: Adds missing shared components](https://gitlab.com/gitlab-org/gitlab/-/commit/ced85c7d8521c2b14d45860820a6bc8dc6618f6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161176))
- [Humanize chart units for Value stream analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/ce546a174ae20738fd6ef1e6d3d492cd345823a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160907)) **GitLab Enterprise Edition**
- [Hide pending todos authored by banned users](https://gitlab.com/gitlab-org/gitlab/-/commit/fb81783ed470d4daf9d3139797df4a79d531fa48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159542))
- [Hide rollup weight when null](https://gitlab.com/gitlab-org/gitlab/-/commit/3d1cdd20f6d6a5c9e474c66b6de2856a202f8176) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160198))
- [Returning multiple compliance frameworks in project api](https://gitlab.com/gitlab-org/gitlab/-/commit/cbcaa2a0049eae52c47fa30c8eb2b9a5cefa4e19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160530)) **GitLab Enterprise Edition**
- [This MR adds new arguments for graphql mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/da72b64f0d963d5ae3cb14bc17fe5824820f0c22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160225)) **GitLab Enterprise Edition**
- [Check for feature flag for user autocomplete in command palette](https://gitlab.com/gitlab-org/gitlab/-/commit/d311e2c52503a64ae9dffb3deecf2eef8cab78c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160780))
- [Put groups_direct field in CI JWT tokens behind feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/88080c3c48ee15f62b5603e82126478e05d63470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161075))
- [Sentence case pipeline editor](https://gitlab.com/gitlab-org/gitlab/-/commit/b86778f66b3c1d22913fa9bf95d343fb515557b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161054))
- [Issue Analytics: Migrate title and optimize loading state](https://gitlab.com/gitlab-org/gitlab/-/commit/e7ef12569b97d179f27cf00c929cefd9ff071b94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160723))
- [Switching default_enabled: true for RCA troubleshoot](https://gitlab.com/gitlab-org/gitlab/-/commit/36490f7a84aecee3b9cb625c5bd1fa97e507ae03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160771)) **GitLab Enterprise Edition**
- [Ensure Current.organization is set in REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/4ef855e8b2807e8701c68ec6e3ea01cb8ac65d3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161008))
- [Add delimiter to label counters](https://gitlab.com/gitlab-org/gitlab/-/commit/628c71dc278373010a02d7b554a23d028fa1aa27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161026))
- [Open k8s details drawer on the pod name click](https://gitlab.com/gitlab-org/gitlab/-/commit/8324e9b4670c2c6243e24a29adab31966cd3178e) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160684))
- [Set schema to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/0d39800d66aff7e2fbdbc1d79d687aea73f7d3ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159111)) **GitLab Enterprise Edition**
- [Use header components and sentence case in code section](https://gitlab.com/gitlab-org/gitlab/-/commit/65ff3eb7a22a507c8d35ce91f5a4dfe22f1fddd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160926))
- [Update error pages](https://gitlab.com/gitlab-org/gitlab/-/commit/adc5ab9e2fa5f97b4c197750373821e301f3baa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160374))
- [Pipeline mini graph clean up](https://gitlab.com/gitlab-org/gitlab/-/commit/cdc96fc55810d49dacb063af7110175d3106b91a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160807))
- [Use page heading component for new snippet](https://gitlab.com/gitlab-org/gitlab/-/commit/b05ea722a1168f8293822c5701ab48e584fcc474) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160923))
- [Update pipeline editor to replace external link icon with catalog icon](https://gitlab.com/gitlab-org/gitlab/-/commit/a7430167da4ae15891dd03ada46e796a80c65b33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160873))
- [Search bar: Migrate buttons to GlButton](https://gitlab.com/gitlab-org/gitlab/-/commit/87054eb6b7348077bc9341540100cfd75c212609) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160717))
- [Use CrudComponent for labels lists](https://gitlab.com/gitlab-org/gitlab/-/commit/85f8ca06b7ae3dbb9e1ada1e4c77af70b8db05c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160613))
- [Applys pending promotion requests](https://gitlab.com/gitlab-org/gitlab/-/commit/4c469555ae07d92b2c7cb7fdcfceb6e9dee67d7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157783)) **GitLab Enterprise Edition**
- [Move glab ask endpoint to AI gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/390a9ae4b7039ceb48d6177fd90ccbe39a0defcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159150)) **GitLab Enterprise Edition**
- [Update stackprof to v0.2.26](https://gitlab.com/gitlab-org/gitlab/-/commit/cfe5d3fb7cbd1828149257a7cff3bc849d29d846) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160760))
- [Remove add_gitlab_tier_cookie feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/aa42f38d513a85dc04a4fbfcec614bf95536243c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160651)) **GitLab Enterprise Edition**
- [This MR adds new field for update service](https://gitlab.com/gitlab-org/gitlab/-/commit/3e50f7947ecb448968c57d7562cc65418d04e4ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160542)) **GitLab Enterprise Edition**
- [Applications group settings: Migrate components](https://gitlab.com/gitlab-org/gitlab/-/commit/347de302c259da7b78e4e4199d34a5836a8dd0be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159712))
- [Hooks: Update components](https://gitlab.com/gitlab-org/gitlab/-/commit/61cfd3475c458246eab94163c6899f44a740ced6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159438))
- [Redirect to group page upon user acceptance](https://gitlab.com/gitlab-org/gitlab/-/commit/9eae662aa4835699e06b41235b682ee15af52e6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157233))
- [User permissions for ML model registry & experiments](https://gitlab.com/gitlab-org/gitlab/-/commit/b77dc5b6d54f29430bd7426c2fa863ca5790fdf3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160074))
- [Update user achievements](https://gitlab.com/gitlab-org/gitlab/-/commit/67ecce4a20eabb4b16d40813cd662a69244d4f47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160318))
- [Switch indexing button to background job](https://gitlab.com/gitlab-org/gitlab/-/commit/61fbea70bd9ed76c9b99a46482abeb5b4c8ce963) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160231)) **GitLab Enterprise Edition**
- [Set default state of web_ide_oauth flag to enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/7f8199c85286ccd3178381ce4128bd8f18597a85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160597))
- [Migrates to use SettingsSection and Crud Components](https://gitlab.com/gitlab-org/gitlab/-/commit/486b652a96a9d90b83ad657639a115e3c80c1d2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159737)) **GitLab Enterprise Edition**
- [Configure ignoring default before and after_script for policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e8a8dca501c4d558cd9164269dfab403c05f79c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160466)) **GitLab Enterprise Edition**
- [Remove updated at from work items](https://gitlab.com/gitlab-org/gitlab/-/commit/7d83705189ff4445fa0dd07ca2beb11f8cc50ed3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160126))
- [Replace toggle by radio buttons in the CI/CD settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a63702b0f539c47743c7a1cd2fb1287f84b0e4d6) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160078))
- [Repository settings: Migrate components](https://gitlab.com/gitlab-org/gitlab/-/commit/948b57de3f2f6179da988755f3d0b0037c95df37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159543))
- [Update help text for job token setting](https://gitlab.com/gitlab-org/gitlab/-/commit/554b690091b4f8b047a43f730ef31633d2ffb631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160523))
- [Cleanup `prevent_registration_from_china` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8e19ddd00908a47135801d680dc75607d21098e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160495)) **GitLab Enterprise Edition**
- [This MR adds new field for external_status_check model](https://gitlab.com/gitlab-org/gitlab/-/commit/e2a314d44af156bae5bdab8741166e94359ff4a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159983)) **GitLab Enterprise Edition**
- [Update OpenID and OAuth2 gems](https://gitlab.com/gitlab-org/gitlab/-/commit/ac734f14580a8d7df75bc95626c26cbc856144c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160480))
- [Clean up SafelyChangeColumnDefault for policy concurrency](https://gitlab.com/gitlab-org/gitlab/-/commit/b5a7d97318e1571ca5b4f80135fdffefcd7da190) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160467)) **GitLab Enterprise Edition**
- [Update illustration for work item empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/55263d1ac13565534ae7079a3260a739cad6bc26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160294))
- [Remove default value from `organization_id` field for snippets](https://gitlab.com/gitlab-org/gitlab/-/commit/d30d70d32d624b567d771886c1baf70fb02b4ef1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160048))
- [Add approval rule: Move action buttons to content](https://gitlab.com/gitlab-org/gitlab/-/commit/d173febd0f2c03e2191038e5c786a9474f84bb65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159883))
- [Fix icons on commit page](https://gitlab.com/gitlab-org/gitlab/-/commit/beaf426c4f43592c924e1e9f6e0e8625b34986fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160396))
- [Cleanup bigint conversions](https://gitlab.com/gitlab-org/gitlab/-/commit/ddab2c93d7e5be7f6c4d13fb162b187d2b096c0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159364))
- [Fix profile passed to API Security analyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/8949379ff133b45876edaa545b77fa1c9bb90bb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160373)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.100.0](https://gitlab.com/gitlab-org/gitlab/-/commit/f68d99a66e9cc2bd35cfe368e8029f6b338c679f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160350))
- [Lock logger version to 1.5.x series](https://gitlab.com/gitlab-org/gitlab/-/commit/e8139571b743d4574ef842e1f76bdab8f65f989d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160349))
- [Apply a daily limit for duplicate credit card validations](https://gitlab.com/gitlab-org/gitlab/-/commit/2f1e488617f0a8271f926b5e8107b0565ff238c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159151))
- [Remove gl-block class on badge](https://gitlab.com/gitlab-org/gitlab/-/commit/1cc0125fc322919ee037a2e87daf943095f1a4d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160336))
- [Validate presence of Organization on Namespace model](https://gitlab.com/gitlab-org/gitlab/-/commit/525dc03ccae2e67a76be4e25a58eb9abca3b56dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155732))
- [Shows releases on group milestones](https://gitlab.com/gitlab-org/gitlab/-/commit/e56ec6fd67e2442f77e680573e66451c9e132857) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159276)) **GitLab Enterprise Edition**
- [Auto close issues for group level issues defaults to false](https://gitlab.com/gitlab-org/gitlab/-/commit/0ade607e188e6abd2301d632929f909c3f38f8c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159459))
- [Analytics settings: Migrate to use SettingsSection](https://gitlab.com/gitlab-org/gitlab/-/commit/edbb0dd6596d6300777098c8c7ae1e6c85a6d15d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159689))
- [Use FrameworkBadge as item for the Frameworks Select](https://gitlab.com/gitlab-org/gitlab/-/commit/bded3141057241479aa70465beda7503c6891a70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159374)) **GitLab Enterprise Edition**
- [Extract authz classes to fetch permitted abilities](https://gitlab.com/gitlab-org/gitlab/-/commit/69be0c77b9ae62570b579e188072037c34d8a3b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159603)) **GitLab Enterprise Edition**
- [Remove deprecated observability_tracing feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fa72bf51cfb0f223325de5dc8a04670f3a1bc98d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159775))
- [Enable sorting by published_at for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/59e4b952861c9095e93d374576875e90e8a977a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158701))
- [Clarifies the availability of dormant user feature](https://gitlab.com/gitlab-org/gitlab/-/commit/6b3d67fdd45dab0891fe4caf87fa69ba7f3e58ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160235))
- [Remove `optimized_vulnerability_report_export` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9c24e864cb897dc11cd110fa09ee685befc3f98e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160071)) **GitLab Enterprise Edition**
- [Update Duo Pro card on Usage Quotas page for trials](https://gitlab.com/gitlab-org/gitlab/-/commit/ec4501c475c1138534ea98a21107a03e1dcb41d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158497)) **GitLab Enterprise Edition**
- [Show newest linked items first](https://gitlab.com/gitlab-org/gitlab/-/commit/268104cda6d2abe906a646ceeda6c731911642bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160068))
- [Add ai_custom_models_prompts_migration FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f058a82aceea43613f7e762393d75e084544c7f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160050)) **GitLab Enterprise Edition**
- [Migrate Integrations settings pages](https://gitlab.com/gitlab-org/gitlab/-/commit/af38e396c271c57a6a272c0d5241a0a2123ebaeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159411))
- [Update source_users/show copy and UI](https://gitlab.com/gitlab-org/gitlab/-/commit/6aa9a2c335ec023b74a9159a57e527374b757556) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159209))
- [This MR updates dropdown text](https://gitlab.com/gitlab-org/gitlab/-/commit/ce338e329084ef1b22236905aa30b8fac5ec3f13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159487)) **GitLab Enterprise Edition**
- [Rename Gitlab::Geo. replication_enabled_replicator_classes](https://gitlab.com/gitlab-org/gitlab/-/commit/0796156fa17cf1b8eb2014e27bfc961ecdcea7f5) by @sahilsarawagi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160140))
- [Reduce the verbosity of package_metadata logs](https://gitlab.com/gitlab-org/gitlab/-/commit/b5f5cf636ad917f376bc319f88693bc4fbe6b042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157809))
- [Add new child work items to the start](https://gitlab.com/gitlab-org/gitlab/-/commit/5b152445c612ca9296293804c2db7319e0499185) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159854))
- [Update the tooltip text on the deployment limits message](https://gitlab.com/gitlab-org/gitlab/-/commit/1a6cb618f6a286035ffdd047feb11cbdd4dde1fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160019)) **GitLab Enterprise Edition**
- [Don't send commit messages from the FE if they're untouched](https://gitlab.com/gitlab-org/gitlab/-/commit/5611eb006ecb4056b538f13c15310761c7bb37b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158881))
- [Update gems for Faraday 2 compatibility](https://gitlab.com/gitlab-org/gitlab/-/commit/49edae93a40429f6ca0311a812463488542b6952) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159692))
- [Update dependency auto-deploy-image to v2.99.0](https://gitlab.com/gitlab-org/gitlab/-/commit/cbdaaaf807718350e9cee5f9e2b3187ba478f3d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156164))
- [Group: Migrate project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a165f27fdbe2374b6b9f6b35a2aa3c03a1823d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159534))
- [Backfill label_ids for merge request](https://gitlab.com/gitlab-org/gitlab/-/commit/22bf678b695df0b4048e11904557e633983accfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159404)) **GitLab Enterprise Edition**
- [Migrate axios call to GraphQL mutation for jobPlay](https://gitlab.com/gitlab-org/gitlab/-/commit/4c64f4f58e93e9013b9b6f812dee83f737d1b6b1) by @missy-davies ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140016))
- [Hides job logs timestamps on mobile size screens](https://gitlab.com/gitlab-org/gitlab/-/commit/b31c62850820c802753da8b0bcadbe184958e04f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159865))
- [Display current user's username in Identity Verification page](https://gitlab.com/gitlab-org/gitlab/-/commit/f71217ffd9ea2ba3ce2fcd286a9d2260ac33ae3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159509)) **GitLab Enterprise Edition**
- [Update dependency auto-build-image to v4.3.0](https://gitlab.com/gitlab-org/gitlab/-/commit/a13ca973d0c514bbde2a0a44785ae36950d7b470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159826))
- [Remove elastic_index_use_trigger_indexing FF](https://gitlab.com/gitlab-org/gitlab/-/commit/00c7f57f680234b59d1a78423e6d34fad1e10442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159435)) **GitLab Enterprise Edition**
- [Set Claude 3.5 Sonnet as code generation default](https://gitlab.com/gitlab-org/gitlab/-/commit/aaef1adb574aa6096dc03824211f52b3a44bccfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159757))
- [Usage quotas: Use PageHeadingComponent for heading and description](https://gitlab.com/gitlab-org/gitlab/-/commit/26da70bf847fe6410e3fb8352bcf676aea305da3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159739))
- [Use tertiary  button for admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/41bcbc0d3c3a908acd0aca549af45ecc4548b978) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159236))
- [Update project report for multi frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/eecfc1931ec84206b01f14a79c071238c4a33d1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158227)) **GitLab Enterprise Edition**
- [Update link to the help page on Geo health help icon](https://gitlab.com/gitlab-org/gitlab/-/commit/6c39a5a5a5bfdec053dfff4cf889e600c724ca8c) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159606)) **GitLab Enterprise Edition**
- [Fix double border at the 'Child items' widget on the Issues page](https://gitlab.com/gitlab-org/gitlab/-/commit/4e82666781f33728b4c01ab244d999cfded6d526) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158055))
- [Add new observability feature and policy](https://gitlab.com/gitlab-org/gitlab/-/commit/be32f492e66e1e99160178ff7f1b21a1aaa1ebd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158786))
- [Set vulnerability_export_part schema to `gitlab_sec`](https://gitlab.com/gitlab-org/gitlab/-/commit/683a98dc793e72c5e98e5e9efb846f741a3a09a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159118)) **GitLab Enterprise Edition**
- [CI/CD Settings: Migrates settings blocks to SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/c189858b846649bafb6bcc5a36be493dbe4c87f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159553))
- [Filter merge requests by author](https://gitlab.com/gitlab-org/gitlab/-/commit/1205630fec8d433e74f78cd3ac2fc3e70d7affaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159218)) **GitLab Enterprise Edition**
- [Project general settings: Add sr-only h1](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d696da2a2c10442e50100557f1cc779c98d5ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155454))
- [Update dependency ai-gateway to v1.12.0](https://gitlab.com/gitlab-org/gitlab/-/commit/cbfa16bea6a78e8d56e9fc8148a8b2ead6a1cce6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159514))
- [Sticky header color alignment between color modes](https://gitlab.com/gitlab-org/gitlab/-/commit/082bed0368fcc2a7ad6133235aa745c38f4e27ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159508))
- [Change page title for subscription page](https://gitlab.com/gitlab-org/gitlab/-/commit/1f261e7e8d7a1f9b93b413c366211b50e994d2a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159488)) **GitLab Enterprise Edition**
- [Update UI text for require auth in MR policies](https://gitlab.com/gitlab-org/gitlab/-/commit/1f00813a763eb370e281cb64c39d256988b700f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159386)) **GitLab Enterprise Edition**
- [Advanced Search: Index label_ids for merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/dcf45f20591ed7eef522b03ca820863a8e157d98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159377)) **GitLab Enterprise Edition**
- [Update admin push rules](https://gitlab.com/gitlab-org/gitlab/-/commit/f9afe5efc4c041d6544fde876695939cc40a3fc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159007))
- [Show group stats when deleting from the Admin Area](https://gitlab.com/gitlab-org/gitlab/-/commit/80ae05fcb109bf1a6f30ae50c20654e2c4121abe) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157627))
- [Remove code behind preserve_unchanged_markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/c308788f5e1c5cb9b01c674ee2e7415b9baecdde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158759))
- [Docs: Add Cloudflare IP range info for Duo](https://gitlab.com/gitlab-org/gitlab/-/commit/10048ed55d3384fa3c69c1bfb5dbf56601464f54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159388)) **GitLab Enterprise Edition**
- [Update deploy keys pages](https://gitlab.com/gitlab-org/gitlab/-/commit/dde6d240811a37d0b9adaa7be7111580c3792380) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159142))
- [Finalizing batchedBackgroundMigration of CiPipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/10924343ec966646be32c69e63b2e26a12a0abca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158377))
- [Make policy migration context aware](https://gitlab.com/gitlab-org/gitlab/-/commit/5ad335c87e8e9b26b241bca43f7df4b55a17d1b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159244)) **GitLab Enterprise Edition**
- [Delete requires_input.js behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/e24f1d5d110648cfa2326d20b6c82488177ea354) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157796))

### Deprecated (1 change)

- [Stop using PrometheusAlertPresenter from graphql and remove class](https://gitlab.com/gitlab-org/gitlab/-/commit/9cd7badde943e0f90d1ea4bbdcd43220da81a464) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160504))

### Removed (30 changes)

- [Remove required_instance_ci_template column](https://gitlab.com/gitlab-org/gitlab/-/commit/3dd223d26442309346bb8dd8977eb6d9f683789c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161992))
- [Remove link_existing_lfs_object feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c2705ed71bf177322578b6e50c57baee5cef3a29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162369))
- [Revert index on web_hook_logs](https://gitlab.com/gitlab-org/gitlab/-/commit/dca0e967fdc584c06fff069a3cb7c6cf0bd44712) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162255))
- [Delete the `enable_environments_search_within_folder` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/06f1e2d81f6ba4191c7ee3505ac43c5ac8015c2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161723))
- [Remove free-tier workspaces pages](https://gitlab.com/gitlab-org/gitlab/-/commit/a4e75fdcf098a695465041c9693ecce5a3c1ce2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161986))
- [Cleanup compliance_pipeline_in_policies feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2a713620d34a3622be245ddb2cd0c6c6315c6d3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160647)) **GitLab Enterprise Edition**
- [Delete the `changelog_commits_limitation` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/68c5a31e09320a6cc87601ea8320096e678c495a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161125))
- [Deprecated and remove continuous vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/f7ad1897c2a05d0ac813e165498eea72ae29f90e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161337)) **GitLab Enterprise Edition**
- [Remove dependency list alerts](https://gitlab.com/gitlab-org/gitlab/-/commit/c1976aa80be607f56506056617456c1ca4736e2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161512)) **GitLab Enterprise Edition**
- [Delete the `json_wrapper_legacy_mode` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/23fb42216fd7d996d68546e34519c5c4fa0b035a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161727))
- [Delete the `order_builds_for_group_runner` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c8ff354c1ef4010ece31cae10edf0e3e6b35b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161725))
- [Remove gitlab_main_clusterwide and connection](https://gitlab.com/gitlab-org/gitlab/-/commit/cb0abad1ac6b11b72b412490e0b98ef36f40b646) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161017))
- [Remove custom CI action from Scan execution policies UI](https://gitlab.com/gitlab-org/gitlab/-/commit/d025790ef56689a7fd53cd07a24955408f061e72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160053)) **GitLab Enterprise Edition**
- [Removing unused project frameworks controller](https://gitlab.com/gitlab-org/gitlab/-/commit/2b32015c5275cade69ff76a175ab5347a1580900) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160531)) **GitLab Enterprise Edition**
- [Remove composer cache files related code and database records](https://gitlab.com/gitlab-org/gitlab/-/commit/428ebd23fb23f6f1add33af587b4ae129afdcc71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159861))
- [Remove wiki_size index on project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/ada613abeedff8a55aafa08ca01ee9ab4d79c14d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158623))
- [Remove packages_size index from project_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/51b3f7b033024a9bce769ad3c1e4363635a25dbb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158620))
- [Cleanup traces of old cron job](https://gitlab.com/gitlab-org/gitlab/-/commit/cc78eec270846f03db837c442cd05808525b5696) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160394))
- [Remove cloud license promotion banner](https://gitlab.com/gitlab-org/gitlab/-/commit/926ad333bd5ff9dbca4190c612c9b638a7d8bbd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159243)) **GitLab Enterprise Edition**
- [Chore: remove the feature flag default](https://gitlab.com/gitlab-org/gitlab/-/commit/71109150539e62321e6d6ea6592ed188655b453c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160292)) **GitLab Enterprise Edition**
- [Remove simplified_badges feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb69907eca0d4d8bac5396c17a53f72e4042ce1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160203))
- [Remove custom CI action from processing](https://gitlab.com/gitlab-org/gitlab/-/commit/d603f29c5366d3e6476a7b08fd75eaea0b5ac995) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159607)) **GitLab Enterprise Edition**
- [Clean up phone_verification_for_low_risk_users experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/6d5bcdf0b22f88c8456861a76c39d77361efea6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159872)) **GitLab Enterprise Edition**
- [Remove store first reviwer assignment timestamp FF](https://gitlab.com/gitlab-org/gitlab/-/commit/c3bfba614ed569c1957d09d02cfbb597af886ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159190))
- [Remove pipeline execution action experiment from group settings](https://gitlab.com/gitlab-org/gitlab/-/commit/bed46e0ebce7c925c8e7eea78b8ddc690b94c3c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159420)) **GitLab Enterprise Edition**
- [Remove geo_use_clone_on_first_sync feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/53ee82629c5e539eeac4c57914218b7bbb69756c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158633)) **GitLab Enterprise Edition**
- [Removes unused index on project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/f95a5d1a59c3f0a81ed0e5844eb9953c732abd9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158614))
- [Drop temporary index on `vulnerability_occurrences` table](https://gitlab.com/gitlab-org/gitlab/-/commit/2c988d3c362b81734d22c3e95a50f641eec52497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158726))
- [Remove Ramon related code](https://gitlab.com/gitlab-org/gitlab/-/commit/50e0327de210ccba4484e54eee23b08b4044f927) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158940)) **GitLab Enterprise Edition**
- [Remove unused arkose_labs_verify_api_url col from application_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/c250b62df565bf32c7b052b239b666a27cfb97cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159379))

### Security (22 changes)

- [Filter parameters in Rack::Attack logs](https://gitlab.com/gitlab-org/gitlab/-/commit/4565d96be79f64541c7aab68ab27f27cd58d6184)
- [Fix Possible asciidoctor include:: directive DOS](https://gitlab.com/gitlab-org/gitlab/-/commit/73f3ea94b844fbc3dfe4e6a4ef9edf3375e67360)
- [Show correct file content](https://gitlab.com/gitlab-org/gitlab/-/commit/56c91e5510ab52f5e74be40f4672ca879babfa2a)
- [Fix the catastrophic backtracking](https://gitlab.com/gitlab-org/gitlab/-/commit/9757b254a51dac68951ac12951f2e1a1e870d02a)
- [Update audit payload](https://gitlab.com/gitlab-org/gitlab/-/commit/82726dd897601e1212641d2c4d1975a4f63b1032)
- [Limit access to project accessed by Security Policy Bot](https://gitlab.com/gitlab-org/gitlab/-/commit/0de6ffe017e4b400641889ac1ea83d903265c10a)
- [Show alert about not rendering files due to path encoding](https://gitlab.com/gitlab-org/gitlab/-/commit/ba3360000e58eb8a0633cfddf94c0743b009b948)
- [Add a project scope to LfsTokens](https://gitlab.com/gitlab-org/gitlab/-/commit/de2022b4a5ee5a708454626bcadce1c50467c812)
- [Security fixes for banzai pipeline part 2](https://gitlab.com/gitlab-org/gitlab/-/commit/9a5b8ae2305b905f4ff6d92041294273b1dda4d4)
- [Remove xhtml extensions from snippets blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/09d9235e3ebdff1af49863701b718a365f2baede)
- [Fix ReDoS in RefMatcher](https://gitlab.com/gitlab-org/gitlab/-/commit/71a408dd12b9a96d6713644938f59d3e7d36f738)
- [Enforce `require_password_to_approve` MR approval policy property](https://gitlab.com/gitlab-org/gitlab/-/commit/42526d753dc6ea54beb7ed7e73a222befbe3ee00)
- [Remove verify authentication token skip in cdot proxy controller](https://gitlab.com/gitlab-org/gitlab/-/commit/c34f64202a013bb6460b40c346d05120ab4182b4)
- [Fix ReDoS when parsing git push options](https://gitlab.com/gitlab-org/gitlab/-/commit/1286b58893505391bb33e915f25bcc00ea1184e2)
- [Attribute BulkImport::Export to a particular user](https://gitlab.com/gitlab-org/gitlab/-/commit/ab8e4a0d4c413daa52d65810d4fb849e03617c91)
- [Refactor import_export_upload to be user-based](https://gitlab.com/gitlab-org/gitlab/-/commit/29d4e4570f642bf0f6697a584bf4eb24be6d60e5)
- [Don't include project-level analytics settings in DOM](https://gitlab.com/gitlab-org/gitlab/-/commit/9925a8a3989b8bda4ca0c76b1002c25a911c2326)
- [Remove prohibited tags after import](https://gitlab.com/gitlab-org/gitlab/-/commit/638447ecfe01cd0c35713ec7a29350f6fde021df)
- [Fix for private dotenv artifacts not accessible to downstream jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/a52656303b62340f8cfe56bd9c9442c30973b6a7)
- [Do not allow script execution on dependency responses](https://gitlab.com/gitlab-org/gitlab/-/commit/2b160f8fa7ac30f840e38b11098499762f351f07)
- [Fix for private txt artifacts being accessible through the artifacts/browse link](https://gitlab.com/gitlab-org/gitlab/-/commit/049e1a244d4ab0d113694c878ff5a7ad0e16f4bc)
- [Disable system hooks on GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/dbb3b7dc3298b67c68545e17f387e91fc7da62a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159437))

### Performance (10 changes)

- [Add preloads to AddOnPurchasesResolver](https://gitlab.com/gitlab-org/gitlab/-/commit/cf1c82daeb7c6643e872a89695841bca5710a1f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162232)) **GitLab Enterprise Edition**
- [Remove `segmented_vulnerability_report_export` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f32a63f6bb7621aac6eb0a821f1a532062ea9b10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161448)) **GitLab Enterprise Edition**
- [Do not attempt to upsert existing cvs scanners](https://gitlab.com/gitlab-org/gitlab/-/commit/71785e5153bcb06d88d24d7115a9c1f844e49e4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161360))
- [Only wait for contribution mapping related exports](https://gitlab.com/gitlab-org/gitlab/-/commit/a7c79a2304403809ae7cf33d9235166356b24db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160398))
- [Prevent timeouts in group autocomplete query](https://gitlab.com/gitlab-org/gitlab/-/commit/b4a70fa2ec90382713f542fbc7b9931a8e28a2b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160836))
- [Skip updates for existing components and versions](https://gitlab.com/gitlab-org/gitlab/-/commit/e4f6455cea823b0c63e5c143728d7ccc5568a3d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160777)) **GitLab Enterprise Edition**
- [Refactor Nuget SearchResultsPresenter](https://gitlab.com/gitlab-org/gitlab/-/commit/8840bdb22157df8544897e707c2802153fb751d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159895))
- [Adjust Bitbucket Cloud issues worker to be resumable](https://gitlab.com/gitlab-org/gitlab/-/commit/5da77cea6b385dcc75644bf1eb56f521170cbc2b) by @ivantedja ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158472))
- [Bulk insert CVS vulnerability scanners](https://gitlab.com/gitlab-org/gitlab/-/commit/067d8440852104040c110a82c438801d8005436b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159968))
- [Remove skip_sbom_occurrences_update_on_pipeline_id_change feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8325878a2da2883fbe1af685957bfc4f855a3bb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159637)) **GitLab Enterprise Edition**

### Other (124 changes)

- [Remove double quotes](https://gitlab.com/gitlab-org/gitlab/-/commit/955a83fad07a25f7e248550589a8efe3da3a0f2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162024)) **GitLab Enterprise Edition**
- [Remove group_multi_select_tokens feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/80e2355efa8b125ef50c027a18d52a933e1058d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159187))
- [Backfill audit events into new audit events table](https://gitlab.com/gitlab-org/gitlab/-/commit/fa79983cc48ec3e8f5de4fc0e7ba67a449eae1f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158316))
- [Improve documentation for the work items reordering mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/d2c382453f0a0bba407997000cd6a8875fafb125) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162041))
- [Fix regex bug](https://gitlab.com/gitlab-org/gitlab/-/commit/873cdb555bc5a85fac76227a9ae2659d70aa7679) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162286))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1f705d566e3184bf1db0cd64949e6453c8d243d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161670))
- [Add background migration for duplicates LFS object projects](https://gitlab.com/gitlab-org/gitlab/-/commit/d6a5d684b015b322d6eb166940580eb5462d6a4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154323))
- [Use Ci::Tag model for autocomplete search](https://gitlab.com/gitlab-org/gitlab/-/commit/4b20d2a9360ff4585b14e14689cc5013cfc8bb63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161788))
- [Add PullMirrors::UpdateService](https://gitlab.com/gitlab-org/gitlab/-/commit/4fb7fb15ea47bc6decdc219d43f2571552e9813c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159240)) **GitLab Enterprise Edition**
- [Alter webhook deleted audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/6a63d4100379451da69545893a90edf80264d3a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161320))
- [Add & backfill multiple sharding keys for compliance_framework_security_](https://gitlab.com/gitlab-org/gitlab/-/commit/d2c5ad64153fdfc8d5b007f628c3c9897b122fcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160211))
- [Add resolve vulns migration](https://gitlab.com/gitlab-org/gitlab/-/commit/aa08924e3f5aa44d3ab9db3ac477bbdd31f91d78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157776))
- [Add indexed_bytes in zoekt_nodes](https://gitlab.com/gitlab-org/gitlab/-/commit/0560eef0c55622cdb37a7e656e2b567242c3cdfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161466))
- [Add the columns size_bytes and index_file_count](https://gitlab.com/gitlab-org/gitlab/-/commit/46c29f0af0c536e5b290ccbbee1b7949e0b8afe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161774))
- [Remove ActsAsTaggableOn from DAST profiles](https://gitlab.com/gitlab-org/gitlab/-/commit/868f2441b3a051f7c544b1390fc38b9853cddf1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161876))
- [Remove redundant test](https://gitlab.com/gitlab-org/gitlab/-/commit/fb2f26127b23974724d0de2086846fa0898fe0a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162036))
- [refactor: Avoid importing string literals in tests](https://gitlab.com/gitlab-org/gitlab/-/commit/a81d4a1ad190a691b3a873053385f256c9af5955) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161933))
- [Clean up pipeline_execution_policy_type feature flag from backend](https://gitlab.com/gitlab-org/gitlab/-/commit/086df500e9adc5f9340ecbe32a86741d447d93ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161892)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6b0a00b44e07e839e47b33bc70b5bb73622f8520) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159314))
- [Enable ensure_lfs_object_project_uniqueness FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/76cddb8c534a2ac3fbd75cb88b721aad04c4e0b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161980))
- [Add dev widget to task work item type](https://gitlab.com/gitlab-org/gitlab/-/commit/446ac39075177ab9a2748787b495c6d924e87d54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161967))
- [Add migration for updating current value of max_yaml_size_bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/f24ce23d91c7e176d4f022e0d0142f3a533bce59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161431))
- [Removes GlCarousel from the app](https://gitlab.com/gitlab-org/gitlab/-/commit/fef89135d35952a8f213393e559f4cc0a80f82d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161297)) **GitLab Enterprise Edition**
- [Validate migration schema message](https://gitlab.com/gitlab-org/gitlab/-/commit/3098145d53072df2df77d0fd718ba4d07c251863) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161884))
- [Check if columns exist before running credit card hashing migration](https://gitlab.com/gitlab-org/gitlab/-/commit/623c29e7603a1ed43c72a96e90ba5e2d15a51253) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161776))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c437ddaf05d6c3f840e2e5287fbdbe359f638fe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161550))
- [Replace `text-tertiary` with `gl-text-tertiary`](https://gitlab.com/gitlab-org/gitlab/-/commit/b4754c76d4b5bb84ea7d3ecebc3e58bdd263566a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160615))
- [Replace cdark with gl-text-default](https://gitlab.com/gitlab-org/gitlab/-/commit/c4db50e97a20a30447d57ce89b0e159b25f7abfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160335))
- [Remove ci_canceling_status feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/299369d4bd87aba76b8b81ccdb9e2f894f1376c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160762))
- [Replace cgreen with gl-text-green-600](https://gitlab.com/gitlab-org/gitlab/-/commit/62bbd46e963dd10e272ca79c5507e350ce4bcd49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160334))
- [Replace `bg-white` with `gl-bg-white`](https://gitlab.com/gitlab-org/gitlab/-/commit/c94c4017c1f57c03eb984065b1c8f393b110218b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160636))
- [workhorse: refactor access to Gitaly Sidechannel](https://gitlab.com/gitlab-org/gitlab/-/commit/fb6f06248da06dcbef2d1aefff28055d70b72b35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161770))
- [Support expected_old_oid for UserApplyPatch](https://gitlab.com/gitlab-org/gitlab/-/commit/adfe87357d70be249df9c1e37979d2ba3c744572) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161743))
- [Enhance hand raise modal button layout for mobile](https://gitlab.com/gitlab-org/gitlab/-/commit/f51ead3ed0813535f64fc50c400db917989f4afb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161621)) **GitLab Enterprise Edition**
- [Add NOT NULL for sharding key on deployment_approvals](https://gitlab.com/gitlab-org/gitlab/-/commit/14d9a0312936dc53153dd9a7ab5cd165c6981bd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161603))
- [Add the default value for reserved_storage_bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/7b6a2bca20cfb11379214c5e9b99fb3c71afdf78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161202))
- [Add and backfill project_id for error_tracking_error_events](https://gitlab.com/gitlab-org/gitlab/-/commit/18bda569ac7232cabf6d2defdb11e19cc875effc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161341))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/fb643a26d3a373088cc9100ca907dc01d870e223) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159999))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a68a2657b83bd3152bed39bed8fe25097c72b041) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161411))
- [Guard PAT last_used_at updates with exclusive lease](https://gitlab.com/gitlab-org/gitlab/-/commit/bdf32e81d10255e373586330d6709d40d2cc1d1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158577))
- [Add and backfill project_id for vulnerability_occurrence_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/6034f424aa07de35e5eb8bc6aa9ff81bd929e17b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161221))
- [Replace `text-success` with `gl-text-success`](https://gitlab.com/gitlab-org/gitlab/-/commit/cc7b971a077e624632828d870fcfce2f08d5290c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160625))
- [Add and backfill project_id for vulnerability_occurrence_identifiers](https://gitlab.com/gitlab-org/gitlab/-/commit/4dfc87cc2a59d3b5f8d73f736e4492d34d467d3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161217))
- [Update default max_yaml_size_bytes to 2 MB](https://gitlab.com/gitlab-org/gitlab/-/commit/437da1dfae66a999e5de01b05a7ade7bad57687c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160826))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2a1752df29b404ce4331bc4b81962076f97d5fdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156998))
- [Protected packages: Push protection for deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/34eb73ead4363a37829cec0704599be9692240e9) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157098))
- [Mark 20230724070100 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/4eafef93213f45614f2dbaf10d6fc655d2de6143) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159912)) **GitLab Enterprise Edition**
- [Override for assign_resource_worker_deduplicate_until_executing](https://gitlab.com/gitlab-org/gitlab/-/commit/894eb23dbfb995a74d2e659f9c67294d2ace6f1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160564))
- [Remove unused text-metric class](https://gitlab.com/gitlab-org/gitlab/-/commit/004227e0b0643005de330d07a9d9a08381a98149) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160800))
- [Use `gl-fill-icon-subtle` for close icon on Dismissible Container](https://gitlab.com/gitlab-org/gitlab/-/commit/d76b653de44c00c6df9a2b1a5710b5ea01579d50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161084))
- [Remove 'text-plain' util class from common.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/65f53bee12e6e8bda205ff6b446cdbb9d393e1e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160599))
- [Add and backfill project_id for packages_package_files](https://gitlab.com/gitlab-org/gitlab/-/commit/0a6f33a9638f8a48a96a6ef214bb54f820bf817b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161035))
- [Add and backfill project_id for vulnerability_finding_links](https://gitlab.com/gitlab-org/gitlab/-/commit/e90c4e049ee025f4f330c66db2fdb857c912be42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161040))
- [Add jacoco file limit](https://gitlab.com/gitlab-org/gitlab/-/commit/1c5d3cec507a62929f1d6a01e166a165173bbb88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159696))
- [Add and backfill project_id for approvals](https://gitlab.com/gitlab-org/gitlab/-/commit/92b7b92dc233baf5b9f7d2f751fbec895406f726) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160035))
- [Replace cgray with gl-text-primary](https://gitlab.com/gitlab-org/gitlab/-/commit/c34af890dc11ffb54fb1257ae2c50306f40b6bf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160330))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/db9cfb6b20a6a062a1df4f80ddd12b1dce8b5eae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160818))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/51b794d023444297f5fbf79a96502bd3b67e9810) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160519))
- [Replace `bold` class with `gl-font-bold`](https://gitlab.com/gitlab-org/gitlab/-/commit/67c75a76a9baf08d6f592868607f0bf90b0f3da0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160640))
- [Replace 'text-danger' with 'gl-text-danger'](https://gitlab.com/gitlab-org/gitlab/-/commit/3694121ff4426e6b8137ac43b55dac279a3e527b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160631))
- [Add and backfill project_id for merge_request_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/7f40079c6b8d194694f11bb2cf9734442efbb46f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160773))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2bd5850996a4df7ce6a79fa39955dc98dbfd5704) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160521))
- [Add and backfill sharding keys for deploy_tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/82c34fedaccf67017f35e52168cbf24c84c2aa34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160526))
- [test: Add missing feature category](https://gitlab.com/gitlab-org/gitlab/-/commit/5410ab83c86828ab9a1d07b88661cc3abe6ffb8c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160708))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9e22a038dda206da801d4783522d1efcd3ee31c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160135))
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/17fdfb4b279345860b31829e20249108239eecf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160560)) **GitLab Enterprise Edition**
- [Use tailwind util classes for semantic color usage in What's New](https://gitlab.com/gitlab-org/gitlab/-/commit/858fd16a6c30f24081ceb01057d6b264c74f7b21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160284))
- [Add and backfill namespace_id for epic_issues](https://gitlab.com/gitlab-org/gitlab/-/commit/603139d33634388d28c061e0a0fccaadc8fe6e3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156640))
- [Use semantic link color in app/assets/stylesheets/errors.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/5bcf82e99f2fd815a6c68943b06524a24b130568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160288))
- [Remove index_vulnerability_occurrences_on_primary_identifier_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c83cf3b55d4ae2997e6beae744f93a1ebb9dac7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157283))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2cd077790465ca9cdab7d819001bfbc20c5e9bde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160346))
- [Replace fgray with gl-fill-gray-500 and remove fwhite](https://gitlab.com/gitlab-org/gitlab/-/commit/ed19dc09419722a541d05202de1197b2ae7b0fbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160471))
- [Move PolicyScopeService to lib](https://gitlab.com/gitlab-org/gitlab/-/commit/539d115b813170dd7cc2a0582c76902d20e83f2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160453)) **GitLab Enterprise Edition**
- [Mark 20230823154049 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/bf74792475b90211b6fb0c3d0b5aa8ae15d81502) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159913)) **GitLab Enterprise Edition**
- [Use semantic token in bootstrap_migration_reset.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/83472694d859f8f2ffad0c0c8148475af8ab1d47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160257))
- [Add advisory lock to lfs_objects_project model](https://gitlab.com/gitlab-org/gitlab/-/commit/b07d6e6a716f88f28b9ab32614aacaa8e0e47349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159264))
- [Add regex argument](https://gitlab.com/gitlab-org/gitlab/-/commit/a1536d0db90ed6d8757c99e5cb80e129ab783af1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159623)) **GitLab Enterprise Edition**
- [Remove unused fetch method and add Storybook entry](https://gitlab.com/gitlab-org/gitlab/-/commit/54542e4dbf1e9d8e7a332629f24bb3f6af15f4f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160367))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/82efe7fd0dcba5a1e7f3e9b90b3a1789e5816b4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157842))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/87826c022a026e2e8dd4d75bb6e647606951f5ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160185))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d44bb35ffb6b9e6c05b60dba12e779e6ce87b698) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159836))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/411fcdb893b136d99b254ecae0bd6362102acbf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160137))
- [Add and backfill project_id for evidences](https://gitlab.com/gitlab-org/gitlab/-/commit/f58dabc1a63a95db49bb739a65adc5f4052833a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159580))
- [Use semantic tokens in broadcast_messages.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/27efd7b48056d5a398c4e37ca2ea599733bbe016) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160301))
- [Use semantic tokens in calendar.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/c3f9992d8719e77873ceea79877b205a594897fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160313))
- [Use semantic tokens in app/assets/stylesheets/framework/blocks.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/7dcb4105a536e1e9e272e7939714af36b8537377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160297))
- [Mark 20230719211400 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/cc87297ec4560f49acc0db40bb00b57af62cc2e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159448)) **GitLab Enterprise Edition**
- [Add basic methods to abuse report note model](https://gitlab.com/gitlab-org/gitlab/-/commit/f456593cce451c6e9c823328de60c0ccbcd50cda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157823))
- [Mark 20230824114205 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/74788dc020ab64dc04d4642a2b846319e05dd359) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159914)) **GitLab Enterprise Edition**
- [Backfills the user_details records for users that do not have one](https://gitlab.com/gitlab-org/gitlab/-/commit/abbb128b6d684dcec252161a25c3901b2a294e6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159632))
- [Mark 20230908120634 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/3e0b006eb56548d0ae7f57d297288b453a79fddd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159918)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/43038670ff3487aa81aecc43dfbae82818a86785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160138))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d17ee14a16f548d2a2ecb30f069edc1fddf2180c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160146))
- [Mark 20230722212041 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/3c5e677e781066093b57d6607c536952b67b756a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159911)) **GitLab Enterprise Edition**
- [Mark 20230901120542 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc0c9430297510607127459a11ff0a4cbf5c42a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159916)) **GitLab Enterprise Edition**
- [Mark 20230720000000 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/fe575e92862660ffd08e4faae853088f566106d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159568)) **GitLab Enterprise Edition**
- [Refactor MirrorsController: move pull mirror code to EE](https://gitlab.com/gitlab-org/gitlab/-/commit/dce63533bb3dd481aef413ba0b87e5f437e4139b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159237)) **GitLab Enterprise Edition**
- [Mark 20230831152648 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/d7fc5ee59dc56ea2360cbf064ab2eb4c33ba6f1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159915)) **GitLab Enterprise Edition**
- [Remove the references of FF zoekt_exact_search](https://gitlab.com/gitlab-org/gitlab/-/commit/d9234e85de05674490cc00380c3b439f96b82a51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159698))
- [Add reserved_storage_bytes to zoekt_indices](https://gitlab.com/gitlab-org/gitlab/-/commit/1665ca684d63a1cb73fd1f486675be298a6680a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159382))
- [Mark 20230911205548 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/74317fc4beb57afd3a98d63b85ecc0ff4ce43783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159919)) **GitLab Enterprise Edition**
- [Use semantic tokens in diff_file_component.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/60f552aea42f63896bb79869b61a3e9e6006fa2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159976))
- [Use semantic tokens in app/assets/stylesheets/components/avatar.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/1cf5c1dc88d88942f6453eef8f21f74e47327ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159587))
- [Requeue partitioning backfill for build group reports](https://gitlab.com/gitlab-org/gitlab/-/commit/5dae18628c2cb770f9e6d80bdce6fd70b85c48aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159702))
- [Implement index addition](https://gitlab.com/gitlab-org/gitlab/-/commit/93b4bb1e9960bbb0f9be2dcef9e9f4d5ddce8c52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158901))
- [Add and backfill group_id for approval_group_rules_protected_branches](https://gitlab.com/gitlab-org/gitlab/-/commit/d673868a1762e218b31c0ed352c14c982cd98e67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159584))
- [Remove diff_preview_in_email feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/89c5a9ba49d09a16e119d6f9be44e6f166dc80b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155140))
- [Remove move_issue_children feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/38a05979dd59f3e3e5674ce186efee6843ea4afe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159779))
- [Remove NOT NULL on policy_id for scan_result_policy_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/0f9ab096685b9b00604de32147d970cbe38455d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158372))
- [Add index for owasp_top_10 group level reports](https://gitlab.com/gitlab-org/gitlab/-/commit/6b2454f65ce020c226003f832c86641bba826803) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158219))
- [Replace flag synced_epic_work_item_editable with work_item_epics](https://gitlab.com/gitlab-org/gitlab/-/commit/44eb338d3582e696999610a6e5add2a1abde795b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158921)) **GitLab Enterprise Edition**
- [GitLab pages: Improve test pages_domain_spec.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/35884c636e25123aad202868f39b0c4da6548bf4) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156192))
- [Add p_ci_builds upstream_pipeline_partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ae183dd5d18f0417513ae1a694bc1a17e0c4906e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158622))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/efd0c1ca19367678a1a71cc118d50d0673ac32d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159672))
- [Introduce lock-free rescheduling for duplicate job](https://gitlab.com/gitlab-org/gitlab/-/commit/259ada02ebf00acb867d1b08857677b0e39d7038) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159215))
- [Remove ignores for imported column](https://gitlab.com/gitlab-org/gitlab/-/commit/0495e2c8dda0a3dd05e84c8fb1f9f47a334473db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159599))
- [Add and backfill group_id for approval_group_rules_users](https://gitlab.com/gitlab-org/gitlab/-/commit/9627199cf51d03571292bf9149c603ec0b05f1e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159585))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/605dc2a81004fe30dd302bc31420b3fd5c184676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159511))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b0e6df690dd8ef4851e22eb33b73f3abbef7579d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159177))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/118f7f3e7ede695d13a2c91a117e0d9f3d52ae38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159185))
- [Run cron job daily](https://gitlab.com/gitlab-org/gitlab/-/commit/e9b2b91420d6f5a018a976c287fa1bee3464a87e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159442))
- [Protected packages: Cleanup renaming of protected_up_to_access_level](https://gitlab.com/gitlab-org/gitlab/-/commit/c84c1efb2b0d204765ba121e9ad523d44fdb3712) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146173))
- [Dynamically gets the column type for assertion](https://gitlab.com/gitlab-org/gitlab/-/commit/1389a3daffd104925cce71776903cbf527723222) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159099))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c94fca35b909440ec66ea35c97ab11aa847dde58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158180))

## 17.2.9 (2024-10-09)

### Fixed (1 change)

- [Ensure levels is an array](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d5450d020895b9fab3c7c6ad4191001308590899)

### Security (8 changes)

- [Do not create a pipeline on MR refresh if source branch was deleted](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3dd89a71b436e8218a5d159a1dd75cb2de078129) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4524))
- [Escape OAuth application name on authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b5cf4d286ae83033912e342177a501ffc2ad6a53) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4519))
- [Prevent guest access to project templates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9666414231dbfc03eb0711ec501b7d02665120df) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4450))
- [Remove access to local requests via cube query service](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1a46c8c1753f08ba55e8a0d2fbcbc710feecf898) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4494))
- [External webhook token should be set](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c795ea96a4dac381cf434aa7e3f379907ec6366d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4512))
- [Skip content when listing conflict files with types](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c7f598b42b0c6cd68cdcdb8b79293e7e2b22b457) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4515))
- [Hide version info from unauthorized users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0184d4e9c665c209e1c67eff2da9059e17304f1d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4502))
- [Prevent deploy keys from pushing code to an archived project](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0a5dc2f0b302123a941a4676eedd52c3423ef73b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4488))

## 17.2.8 (2024-09-24)

### Security (3 changes)

- [Implement input sanitization for SummarizeComments](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4bed1f854c5c7014d7486cc404a5da5321c27070) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4412))
- [Hide system notes with invalid references](https://gitlab.com/gitlab-org/security/gitlab/-/commit/884df0d68bb3f3f2a2029b2851d202949780dd3b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4484))
- [Reset dependency proxy maven credentials when registry url is changed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c43c6ab51a2005958414062c23d5d017a9cba57d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4459))

## 17.2.7 (2024-09-16)

No changes.

## 17.2.6 (2024-09-13)

No changes.

## 17.2.5 (2024-09-11)

### Fixed (2 changes)

- [Fix Sidekiq crashing when GITLAB_LOG_LEVEL set to debug](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b61220ce14c6b2d199f6a6de6d0b79729c15676e)
- [Backport Fixes Geo Replication Details view](https://gitlab.com/gitlab-org/security/gitlab/-/commit/88f24858dc28d1c1ebec07a45cc5e9ef587679cf) **GitLab Enterprise Edition**

### Changed (2 changes)

- [Backport OpenSSL v3 callout to 17.2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0e1195a51214ced5cdfc93ef6cc785a93820f294)
- [Update google-cloud-core and google-cloud-env gems](https://gitlab.com/gitlab-org/security/gitlab/-/commit/85d8fc43006e6b726e2b1887ccf30e2746a105d2)

### Security (19 changes)

- [Revert "Merge branch 'security-psk-fix-external-wiki-integration-dos-17-2' into '17-2-stable-ee'"](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f81601ebba6655d25d1bfe2ff1568cc5fe96059d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4454))
- [Fix the vulnerability in the glm_source parameter](https://gitlab.com/gitlab-org/security/gitlab/-/commit/676a3faddc5e93e38671f41c4e48ce48875364a3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4435))
- [Improve GraphQL log security](https://gitlab.com/gitlab-org/security/gitlab/-/commit/306589f342b7f9aa118c582c55278574291f22c7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4349))
- [Add permissions check to project creations from a project template](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c5e57b452df8ea55f9a7f3870a79c41819f237d1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4444))
- [Fix credentials disclosure in mirroring failure](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2973e7765866d37c1910352fba1c01644d56bf32) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4447))
- [Redirect url in the link validated for being external](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7cdde56d9085dfa2bff8da57f4f9df3b21a2894d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4441))
- [[17.2] Update edit permissions for DAST profiles](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d71e9da0d204366439cdcf0fc577458a1069f089) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4356))
- [Commit information visible through release atom endpoint for guest users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3944f5b91d3d7ff7f30f616c8f5fadd77a6b6fe4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4438))
- [Execute environment stop actions as the owner of the action](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5a037af920b2e621a8dd1b2761dd9cbbc6731ecc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4405))
- [Prevent code injection in Product Analytics funnels YAML](https://gitlab.com/gitlab-org/security/gitlab/-/commit/da77ff49ca023be82a3d1e0102c9d0caf8e7a498) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4430))
- [Prevent users with admin_group_member custom ab. to manage custom roles](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d81400b571b46633603c6d6bfd2657806c9de506) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4426))
- [Fixed frontend regex to parse URI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/99bb822df8102f4e71fa473f11c8767e65759575) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4420))
- [Use session instead of params for identity linking](https://gitlab.com/gitlab-org/security/gitlab/-/commit/114074f667aad583c557ea09350edb5226659d62) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4370))
- [Fix external wiki integration DoS by changing request to HEAD](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4b787a02964a696421d72ae847590d40cf8d2438) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4382))
- [Restrict IPs for packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fc752ed2f6aa9e3c46f5d7b4ee65f0d193f7ffc6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4390))
- [Strip out Set-Cookie header from dependencyproxy auth response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/25dbceaeb243aed695774b232e28cf106898dfbf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4398))
- [Fix open redirect due to additional slash added](https://gitlab.com/gitlab-org/security/gitlab/-/commit/681c6c65912e20e08bbe942cb0b923cfc0db2345) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4352))
- [Group Developers can view group runners](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9b96f9ad80262f2329f08328a2c6f6b10e5032dd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4379))
- [Enforce Pipeline execution policy variables for template rules](https://gitlab.com/gitlab-org/security/gitlab/-/commit/44d70919eb689f73c7c65a2db3476e205b375528) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4394))

## 17.2.4 (2024-08-21)

### Security (1 change)

- [Always build assets image when tagging](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d0e661baad53be4fb7eef3b530b544d05a609953) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4386))

## 17.2.3 (2024-08-20)

### Fixed (3 changes)

- [Turn NotFound from Gitaly into 404 for InfoRefs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cdd5159fa1f8259dbf92333cf13a2968e814d307)
- [Fix empty dependency list page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/71fc48e515cffcbc46ad4f824dc1990a0eb3b08a) **GitLab Enterprise Edition**
- [Properly handle empty repository.ff_merge in FromTrainRef merge strategy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/63c5e1ce261f03549f19a36867ed83cd928a2c5f) **GitLab Enterprise Edition**

### Changed (1 change)

- [Include language server version in code suggestions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c9c47052794e5d5bfc86d78c5fdd91c4b910a8b8) **GitLab Enterprise Edition**

### Security (4 changes)

- [Do not run pipelines when resolving vulnerability](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4a8fa8c6fd40731c93986e54f56d6b581f4dfa92) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4307))
- [Add Octokit::ResponseValidation middleware](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f8cf13d24a0f5aa07c0236238b2a3d61d82615e9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4376))
- [IP restriction to prevent all group permissions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4b540bf88e05c7e39803652bdbba8978c74ebab6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4340))
- [Destroy associated releases when removing a tag via Git CLI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bb033e98e00bc242a92d7091406f7c91e98a3079) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4366))

### Other (1 change)

- [Check if columns exist before running credit card hashing migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f6b7ac482714a0da707cab36e685378d5067d891)

## 17.2.2 (2024-08-06)

### Fixed (2 changes)

- [bug: Fix template error due to divided by zero](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a09aab977c287262a07bec5a267d611c56bf4f9c)
- [Ignore unknown sequences in sequence fix migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7aa835983a46af9edd1ac4699593017e66979e1d)

### Changed (2 changes)

- [Reverify externally verified gpg keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a390e0347e8bd5565d6c324c82221a0f7cccedfc)
- [Put groups_direct field in CI JWT tokens behind feature flag](https://gitlab.com/gitlab-org/security/gitlab/-/commit/59f2133beed57e99c0f8ebab31ea77bb892fef36)

### Security (13 changes)

- [Show correct file content](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1357224fea289ba708f30f528c04e213b29e0b23) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4334))
- [Fix Possible asciidoctor include:: directive DOS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9762e4636b3dd69edac8b235b4706db515e65e79) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4329))
- [Filter parameters in Rack::Attack logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/401bdc5202d7b083f750361a2f1ef57466bc919f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4272))
- [Update audit payload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/864194bebe8a5b2e2187d04a65e0e2b530c7b779) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4325))
- [Limit access to project accessed by Security Policy Bot](https://gitlab.com/gitlab-org/security/gitlab/-/commit/100a915754d858cd18cfb7851c80944c8fda640b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4343))
- [Show alert about not rendering files due to path encoding](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d8533d727a1c036560df59282bf62ab561258a13) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4337))
- [Fix the catastrophic backtracking](https://gitlab.com/gitlab-org/security/gitlab/-/commit/001aab470cfc14b4c1655de2382d0aa4c39a4fac) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4289))
- [Security fixes for banzai pipeline part 2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/266c315f6e825881c36aa78f0203bf6a2c36a132) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4283))
- [Remove xhtml extensions from snippets blobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/73b5fc95468dcc35d796737ebb1a6c11d88ebf64) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4300))
- [Add a project scope to LfsTokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/943c7867ce0d9dc98929af322ecd422438c9f9c6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4319))
- [Fix ReDoS when parsing git push options](https://gitlab.com/gitlab-org/security/gitlab/-/commit/798466f7574554358d770d28df036f60eff31e41) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4312))
- [Fix ReDoS in RefMatcher](https://gitlab.com/gitlab-org/security/gitlab/-/commit/87d308caed2a1ec7f5ae7ddc1131f5c7abbffdbd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4315))
- [Enforce `require_password_to_approve` MR approval policy property](https://gitlab.com/gitlab-org/security/gitlab/-/commit/129139c6eebd257bc5eae142c52267bb83a71307) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4277))

### Other (1 change)

- [Introduce lock-free rescheduling for duplicate job](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9a15c696b06e4240b02bc54b0c36ed10450c7244)

## 17.2.1 (2024-07-24)

### Fixed (1 change)

- [Fix PEP when SEC is available](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5cbd3187cab87e736c260d374f75cf849997d66c) **GitLab Enterprise Edition**

### Security (7 changes)

- [Refactor import_export_upload to be user-based](https://gitlab.com/gitlab-org/security/gitlab/-/commit/07257efc00d8f4984eddf9576debd62edc6d485d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4269))
- [Fix for private txt artifacts being accessible through the artifacts/browse link](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4ccfc7bb6d3b2aca48e6c9ab5580c92cb2df85f9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4295))
- [Attribute BulkImport::Export to a particular user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/53f8ad67517a92f1e914858c07829ec57e261cc1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4284))
- [Don't include project-level analytics settings in DOM](https://gitlab.com/gitlab-org/security/gitlab/-/commit/639bf845ed2537e44487d8c9e804ec9ac4844045) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4271))
- [Fix for private dotenv artifacts not accessible to downstream jobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/49a4b36f4155702f8277e043d1d1c146b5a52e01) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4275))
- [Do not allow script execution on dependency responses](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e1a84f999c73dab1ce45e9027738a59be977304e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4276))
- [Remove prohibited tags after import](https://gitlab.com/gitlab-org/security/gitlab/-/commit/41db34926ea53f45215294138da716fba4ec03dd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4268))

## 17.2.0 (2024-07-17)

### Added (159 changes)

- [Add status to scan result policy violations](https://gitlab.com/gitlab-org/gitlab/-/commit/0a0ae8f1088928daa6b432d9179b0daf9a6feba1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158203)) **GitLab Enterprise Edition**
- [Add new run keyword under job](https://gitlab.com/gitlab-org/gitlab/-/commit/928bb79fccefe9d52ae30272bc333116b9ca3f1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146333))
- [Protected containers: Add PATCH REST API for container protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/481080c01de97ded95e7d5182a6f2302aaac89cc) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158756))
- [Added filters for multiple compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/280906c08eb0df45e8fd89dd6e957ded70fbed04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158229)) **GitLab Enterprise Edition**
- [Add Duo Enterprise to provision service for add-ons](https://gitlab.com/gitlab-org/gitlab/-/commit/f053e045f3eb066c3c6a2b4f915616554ea07126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158969)) **GitLab Enterprise Edition**
- [Add Duo Pro end trial widget](https://gitlab.com/gitlab-org/gitlab/-/commit/bf8e86288372c1c18335105d11dbfefc511016bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155614)) **GitLab Enterprise Edition**
- [Add RoR tutorial to Observability docs](https://gitlab.com/gitlab-org/gitlab/-/commit/25c507c7a5c10fd111407225d6735692a7d17ba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158625))
- [Enable container scanning for registry](https://gitlab.com/gitlab-org/gitlab/-/commit/ccda3ca324318a8825fa032e1a2b853a95929e13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156247))
- [Add willAutoCloseByMergeRequest field to work items API](https://gitlab.com/gitlab-org/gitlab/-/commit/8ea220794cd74f59876a798cdf58ba294af3836f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158145))
- [Add Duo Enterprise to provision service for add-ons](https://gitlab.com/gitlab-org/gitlab/-/commit/ecf4a2c3df04db0105966313e3f4d5b8c81a2963) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158963)) **GitLab Enterprise Edition**
- [Add models for Virtual Registries, part 1/2](https://gitlab.com/gitlab-org/gitlab/-/commit/a7638db2d3bea91d1db1219df57add5986d11169) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156930))
- [Add the API to return the multi_matches in a single file](https://gitlab.com/gitlab-org/gitlab/-/commit/c90c284bc2e9a0f304ab6410866ab0a49862eec1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155984)) **GitLab Enterprise Edition**
- [Ensure uniqueness p_ci_job_annotation](https://gitlab.com/gitlab-org/gitlab/-/commit/760b22da62461eebaae7325c7651cf040349a97a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159071))
- [Add job action button to PMG](https://gitlab.com/gitlab-org/gitlab/-/commit/f3a916e6ba9ee27b345526914a3652fe2915b8fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159004))
- [Add migration to add seat control column to namespace settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/deb3e5bda554bbbfd9341a91e9221b569852627e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158819))
- [Display ratios instead of counts in CI/CD Analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/9cbe9da793af51cb171289f8f505581ec3494988) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158957))
- [Add Importer User for imports user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/9051ecf67b14924bea3b8df52e24dad141e03b5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157979))
- [Workhorse: HTTP endpoint for bidirectional SSH git-receive-pack data](https://gitlab.com/gitlab-org/gitlab/-/commit/bd2f882c422de105ff2bba6b8011fd6270f65651) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155590)) **GitLab Enterprise Edition**
- [Add GraphQL API for Duo Pro seats assigned and used](https://gitlab.com/gitlab-org/gitlab/-/commit/16bed9c42c1bcb03d5a6e0c1591e92ce8b7a5fbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157936)) **GitLab Enterprise Edition**
- [Enable direct code completions by default](https://gitlab.com/gitlab-org/gitlab/-/commit/257c07f0bc44606e4ef54f4ba1fc6bbb26cbf83b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158733)) **GitLab Enterprise Edition**
- [Added mutation for updating frameworks of projects](https://gitlab.com/gitlab-org/gitlab/-/commit/9f9fdd2b4e329b02695880734b534f38cb5593b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157893)) **GitLab Enterprise Edition**
- [Updates AI merge commit message to be GA](https://gitlab.com/gitlab-org/gitlab/-/commit/d207449f66baa0c31943c4a28164683f2bca11fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158339))
- [Add gitlab-advanced-sast as a SAST job template](https://gitlab.com/gitlab-org/gitlab/-/commit/c5a2613a6dc4158a71f78a085e80af28b3c8314c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158533)) **GitLab Enterprise Edition**
- [Update the search code according to the replica](https://gitlab.com/gitlab-org/gitlab/-/commit/1e93b4695a64366da9ac8afa62a4fb425eb4a867) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158371)) **GitLab Enterprise Edition**
- [Add the API to return the multi_matches in a single file](https://gitlab.com/gitlab-org/gitlab/-/commit/9ed731cf614b1fc0d2a345791a096d6c08c93eda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155984)) **GitLab Enterprise Edition**
- [Add merge_request.squash git push option](https://gitlab.com/gitlab-org/gitlab/-/commit/6db3affce8e9bf36aef55a632ae18f3850cfbf24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158778))
- [Add by_pipeline_ids scope for occurrences](https://gitlab.com/gitlab-org/gitlab/-/commit/056008f7418e1b45d2c616bf7da4e09dfea309f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158790))
- [Release secret push protection for self-managed instances](https://gitlab.com/gitlab-org/gitlab/-/commit/b214790b5a358248b38bec911b97fefa0c27f6d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156907)) **GitLab Enterprise Edition**
- [Add ability to delete task list items](https://gitlab.com/gitlab-org/gitlab/-/commit/1b12e01908c312b302096c591266b73afd56471b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158243))
- [Enable store first reviewer FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/a167164de15c9c7212ad83bba26c1b863e4b869a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158919))
- [Add support for LDAP group sync with custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/03c57818738fd8628a7e6561b07483bea7c0b56d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157145)) **GitLab Enterprise Edition**
- [Add delete mutation for deleting self-hosted models](https://gitlab.com/gitlab-org/gitlab/-/commit/55f5a09298d0b5bae2a8bddb920ae1a9f4abe53c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158319)) **GitLab Enterprise Edition**
- [Add REST API endpoints to manage uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/65fc96866782de44427e17c7f21964775e4dbd36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157066))
- [This MR adds performance warning modal](https://gitlab.com/gitlab-org/gitlab/-/commit/6e684693e4cc527976c8f8509e84b7c8f7b9a32c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157745)) **GitLab Enterprise Edition**
- [Protected containers: New GraphQL field "protectionRuleExists"](https://gitlab.com/gitlab-org/gitlab/-/commit/25615f524198cb6e08afabf6e22120d146b1e901) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156741))
- [Add ci_component_source_policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ae3418523c5b20c57becd3426a54fda7240eeb12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157351))
- [Add support for comments in rich text editor](https://gitlab.com/gitlab-org/gitlab/-/commit/2b7c21095ada7258e98ecbdf308e978332e18de1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158618))
- [Add the API to return the multi_matches in a single file](https://gitlab.com/gitlab-org/gitlab/-/commit/975ea866d9f8ff1376f25849286f573ad1d2aacf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155984)) **GitLab Enterprise Edition**
- [Add reviewer first assigned at VSA stage event](https://gitlab.com/gitlab-org/gitlab/-/commit/dcb264ff24fa7822062c736d27fc1f28a3de4900) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158716)) **GitLab Enterprise Edition**
- [Add page metadata to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/d889cbd4339e228193c7011973cf7821aa76b150) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157456))
- [Create p_ci_finished_pipeline_ch_sync_events table](https://gitlab.com/gitlab-org/gitlab/-/commit/9a4b6ad800019e49efc1c4d4f0bc92591b30c33f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158060))
- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/f05e2dcd79b4d0d90074aad4db7dab87da2dc5ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157855))
- [Add and set uploaded_by_user_id on Upload records](https://gitlab.com/gitlab-org/gitlab/-/commit/0321e29e47e24f0b6eeff464a1e16740fbf72ffc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157574))
- [Set first MR assigned for review timestamp metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/c9a1d1bcc59979f4e7968d89e1281fc1254219b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158422))
- [Expose VSD overview counts for projects](https://gitlab.com/gitlab-org/gitlab/-/commit/aa767f85cd6f5e9ada27dc560160614047ec9942) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158017)) **GitLab Enterprise Edition**
- [Create country_access_logs table](https://gitlab.com/gitlab-org/gitlab/-/commit/8e35bd87d23d60547907918f6a938cab88b614a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157480)) **GitLab Enterprise Edition**
- [Show real page title in wiki sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/6c14327fd2fe5d69bf42c90ddb18f477bafa99f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158679))
- [GraphQL: Add PipelineAnalyticsPeriod type](https://gitlab.com/gitlab-org/gitlab/-/commit/baba2199561365b0cd95b025d6a63f147be9871b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157293))
- [CI/CD Catalog: Add description, type to components](https://gitlab.com/gitlab-org/gitlab/-/commit/410bc05a2315afe16dbffefa8b32c7b4a6c376ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157985))
- [Protected containers: POST REST API for container protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/afee9075d1387525ad6138eb9a7ee69f8ec777cc) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157925))
- [Add Users::ActivityEvent and pub/sub logic](https://gitlab.com/gitlab-org/gitlab/-/commit/8fcab5a27db9a4d127c0165e83b32a0e4f938a7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155559))
- [Add status column to duo workflows](https://gitlab.com/gitlab-org/gitlab/-/commit/7d0440e97dd609453f5a1d87450a413a5c4c5906) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158036)) **GitLab Enterprise Edition**
- [Enables inheritance field param via the Integrations API](https://gitlab.com/gitlab-org/gitlab/-/commit/dc7b1b96f97e4d9f361f98f698922259b5d27362) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158218))
- [Add hasParent field to hierarchy widget](https://gitlab.com/gitlab-org/gitlab/-/commit/96e70f6c713e829baf7a2ff0ed252206e34e7bdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156041))
- [Add UI for CI_JOB_TOKEN permission settings](https://gitlab.com/gitlab-org/gitlab/-/commit/0a663c231314259a70a74acebeec62bb05115939) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156752))
- [Document SPP known limitation](https://gitlab.com/gitlab-org/gitlab/-/commit/c6aa84da756e078b228b4dd78cc9ec5233d11b87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157699))
- [Remove ci_expand_variables_in_compare_to FF](https://gitlab.com/gitlab-org/gitlab/-/commit/b3358f2d75daeb810eb06e4b473249de2fb0e8ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158183))
- [Separate wiki page title and URL fields](https://gitlab.com/gitlab-org/gitlab/-/commit/a8f32279fcf6e17d747b8648d705d37af5abfc3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150646))
- [Remove the `gitlab_duo_usage_menu_item` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6b8de4adb6b8387ef65e34f22a4162ebbcd225b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158388)) **GitLab Enterprise Edition**
- [Remove references to hamilton_seat_management feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/00fee8b1853ac7af78c799054052e983bd894402) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156961)) **GitLab Enterprise Edition**
- [Add FK to VSA stage event hashes organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/44e0f713faa6ef866ed829b523921b9bc1d95929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158322))
- [Release pipeline execution policy type](https://gitlab.com/gitlab-org/gitlab/-/commit/c7f9bb825eb2db6c480e557f0af92470c3618eea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158338)) **GitLab Enterprise Edition**
- [Update Analytics Dashboards' viewed/created/edited tracking events](https://gitlab.com/gitlab-org/gitlab/-/commit/f1bf9efbb2e0c358efa133e521352e10ff4155e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157680)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/81abcdb13c823e82e5d416df6ed2f9aa1f93e59f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158248))
- [Add owners internal endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/0e45f6bdf283916ff5a2f8f70195a0b99a5a62cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157620)) **GitLab Enterprise Edition**
- [Add banned/blocked indicator to card matches admin page](https://gitlab.com/gitlab-org/gitlab/-/commit/43ac9f69a4fa42b4720183096ec39d49504a2e95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157220)) **GitLab Enterprise Edition**
- [Recreate ci_finished_pipelines ClickHouse table](https://gitlab.com/gitlab-org/gitlab/-/commit/3db8c2909e09590b47d148a24fb938cb4fb16acc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158246))
- [Add endpoint to update list of X-Ray dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/22f296b34c92e85c1f417f25faa87323daca4b9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156179)) **GitLab Enterprise Edition**
- [Add imported_from value to github importer](https://gitlab.com/gitlab-org/gitlab/-/commit/a29fc47f948df472a21f5a7f056eb3703905f7d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157760))
- [Create ci_finished_pipelines ClickHouse table](https://gitlab.com/gitlab-org/gitlab/-/commit/da90a98e359c6eb0ae7f053bdf26de6929200e34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158078))
- [Add compliance center for premium customers](https://gitlab.com/gitlab-org/gitlab/-/commit/6e68bc862fbcfd78620732995bafe0af5edf36ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156632)) **GitLab Enterprise Edition**
- [Add badge for feedback on new epics](https://gitlab.com/gitlab-org/gitlab/-/commit/e542ebca350e494f7e1b131f164ccc2a726a3424) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157324))
- [Add a validation about project assignment to a replica](https://gitlab.com/gitlab-org/gitlab/-/commit/6ffd1aaa10b9f23a2d0668882369ece60e2400f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157758)) **GitLab Enterprise Edition**
- [Add support for LDAP group sync with custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/b426f3af63b07e64310f92733107b7891a47db52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155680)) **GitLab Enterprise Edition**
- [Create audit event when deploying to protected environment](https://gitlab.com/gitlab-org/gitlab/-/commit/87909ef70f040653c8be4c2dd226dd5580568fa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156111)) **GitLab Enterprise Edition**
- [Add new namespaces/namespace_id route](https://gitlab.com/gitlab-org/gitlab/-/commit/8410d97a8c10317b4e776303cc0e5abfbe5f84c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157341)) **GitLab Enterprise Edition**
- [Add support for groups in policy scope](https://gitlab.com/gitlab-org/gitlab/-/commit/62cd071153e3cf03a5878da052fbab99817f428b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157083)) **GitLab Enterprise Edition**
- [Show TOC of a wiki page in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/2e9921fc57e378437db033ae6f4efeca75d6bba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154050))
- [Add table to record placeholder contributions](https://gitlab.com/gitlab-org/gitlab/-/commit/347fe084d384dd850dec45dc76d48af6bdd2b8cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156241))
- [Migration to populate vulnerability_reads.identifier_external_ids](https://gitlab.com/gitlab-org/gitlab/-/commit/07a5d22507ca7b7d9c072398c9e93d7e2de388d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157639))
- [Add runner fleet dashboard visit metric](https://gitlab.com/gitlab-org/gitlab/-/commit/99554f12c4eb77ffd328de84a73392f0a8bcbe6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157589)) **GitLab Enterprise Edition**
- [Add more log fields in 401 Unauthorized requests](https://gitlab.com/gitlab-org/gitlab/-/commit/eaa8ab73884b9504156e2e2aef1a8c506dbb3f86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157277))
- [Add imported_from to bb cloud resources](https://gitlab.com/gitlab-org/gitlab/-/commit/2b2a583c8e96454a5ccc12f4ff27445b8bcc0e9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157582))
- [Integration for Beyond Identity exclusions by groups](https://gitlab.com/gitlab-org/gitlab/-/commit/5f0492a248e962139237fb40f023ed6f4f1b48ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153957))
- [Add hybrid search query for issues](https://gitlab.com/gitlab-org/gitlab/-/commit/b48f5b540741be978869c50c585794f659724edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156904)) **GitLab Enterprise Edition**
- [Add job item to pipeline mini graph](https://gitlab.com/gitlab-org/gitlab/-/commit/724852d20740a65a61eeafc6b95c97810c11ee7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157798))
- [Add imported_from value to gitea imported resources](https://gitlab.com/gitlab-org/gitlab/-/commit/0a1528a6cbcecc4d071fe04fa517334ff8864ba9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157333))
- [Add GraphQL API for AI Acceptance Rate](https://gitlab.com/gitlab-org/gitlab/-/commit/ba677efb561d0984af5c850ef7b1536702ca4bd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157035)) **GitLab Enterprise Edition**
- [Create audit event for container repository tag deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/0c61c1eb09e9c76acf4093c2c25e3427f119a7b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156066)) **GitLab Enterprise Edition**
- [Add tracking to metric drill-down links in VSD and AI Impact tables](https://gitlab.com/gitlab-org/gitlab/-/commit/85ee54f6b8a3a59e516d35be7c9e05e9055f48bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157363)) **GitLab Enterprise Edition**
- [Perform chat requests via new endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/139b88d87cf26a25c24848d2e807aa66c88afa56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150529)) **GitLab Enterprise Edition**
- [Added mutation for updating MemberApprovals](https://gitlab.com/gitlab-org/gitlab/-/commit/cbcd2bf16233b16ac9065ec7889abeae21711630) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155284)) **GitLab Enterprise Edition**
- [Add new internal users endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/eece4b86cca0ddb603540d54667c8fb0e752800c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156759)) **GitLab Enterprise Edition**
- [Add imported_from value to bb server resources](https://gitlab.com/gitlab-org/gitlab/-/commit/5a6b7359beade96a4110126c70ffaef2bd575cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157507))
- [Add support for legacy epic references in workItemsByReference query](https://gitlab.com/gitlab-org/gitlab/-/commit/4be3f387fa992071c0a0d82cf1af7739b58696f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157787)) **GitLab Enterprise Edition**
- [Add in pipeline stage dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/a55564a041751e6fed4b0accfa84053a7439bdc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157506))
- [Add branch_filter_strategy to system, group and project hooks](https://gitlab.com/gitlab-org/gitlab/-/commit/a120d1f89e4920634c58dc444ec4ac83f2d5454c) by @clxrx ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145970))
- [Add duo enterprise add-on type](https://gitlab.com/gitlab-org/gitlab/-/commit/b4de88cb4d1366991b7ecddca4459ee84983e16a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157730)) **GitLab Enterprise Edition**
- [Add update mutation for the self-hosted models Vue client to leverage](https://gitlab.com/gitlab-org/gitlab/-/commit/1e3ae1075a486c6cd85c93145336f3c6ea6d3d62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156899))
- [Protected packages: Add label "protected" to package list on group level](https://gitlab.com/gitlab-org/gitlab/-/commit/63e733df54f0a5ad24f67115d4b83aa53d26d979) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154809))
- [Protected containers: Add GET to REST API for container protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/215c18a415bc2dfbafb6bb81a3f5a404e8b2d5b2) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155798))
- [Add gitlab_sec db connection and application record](https://gitlab.com/gitlab-org/gitlab/-/commit/c93d2b4e1112ed682c4690fe0c19b78a5dd51141) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157462))
- [Fill out fields on InputType](https://gitlab.com/gitlab-org/gitlab/-/commit/92da7caa9f4148d1d611e3f1e6eda5a24d8f6164) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156328))
- [Adds configurable default Service Desk ticket visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/39be1cc96b11451030e06efea06d956f220b796c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156884))
- [Add error message for failed association deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/a6408f97c1af7e54d63a26edcd65d0fd27a6dd21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157625))
- [Allow `admin_runner` to create a runner linked to a user](https://gitlab.com/gitlab-org/gitlab/-/commit/98564f789a47c63a33387ebdd4a8e262d8da377c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156559)) **GitLab Enterprise Edition**
- [Allow push to the own repo using CI_JOB_TOKEN](https://gitlab.com/gitlab-org/gitlab/-/commit/5c8b0440f95ab67f5503220ba63173f248c9054c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154111))
- [Adds reusable SettingsSection component](https://gitlab.com/gitlab-org/gitlab/-/commit/d66062058592ca8b25f10395546706f8a44e39ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157270))
- [Enable runner dashboard for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/2dbe985b8822a3a5f56da73e4f30387710b7eb2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157423)) **GitLab Enterprise Edition**
- [GraphQL: Add job execution status to runner manager](https://gitlab.com/gitlab-org/gitlab/-/commit/8036c15b59b4194ef3c4dfe491c0f5200ced13bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157429))
- [Auditing framework assign and unassign to a project](https://gitlab.com/gitlab-org/gitlab/-/commit/01e758131649a64b9e925bedf933c5b3d311b501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156605)) **GitLab Enterprise Edition**
- [Add runner CSV export metrics at project and group level](https://gitlab.com/gitlab-org/gitlab/-/commit/c2c334e0f211370dbde828ca05b8c55321df3ab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157197)) **GitLab Enterprise Edition**
- [WorkItems: Fix rolledup dates when removing child](https://gitlab.com/gitlab-org/gitlab/-/commit/dfc2d692cfc9da9d5b3470d9b90aaa390729bcc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157334)) **GitLab Enterprise Edition**
- [feat: Add configuration for sec DB](https://gitlab.com/gitlab-org/gitlab/-/commit/faf789e010b264e31c6db729be8cdff9ed325421) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156952))
- [GraphQL: API for retrieving most used runners](https://gitlab.com/gitlab-org/gitlab/-/commit/1ea8a9d0c44968bc38e64dc6e6dbe85dd0abd9c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157436)) **GitLab Enterprise Edition**
- [GraphQL: Add percentiles to QueueingHistoryTimeSeries](https://gitlab.com/gitlab-org/gitlab/-/commit/2dec0f10284ab11266564c511632ecfb0ba6a67f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157435)) **GitLab Enterprise Edition**
- [GraphQL: Add upgradeStatus field to RunnerType](https://gitlab.com/gitlab-org/gitlab/-/commit/6ecc972d8b5e75a8ac580eca16d9fa2297750b94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157434)) **GitLab Enterprise Edition**
- [Add support for Claude 3.5 Sonnet for code generation](https://gitlab.com/gitlab-org/gitlab/-/commit/b793848806ec66dbf779d000d6c4adb94565dc36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157336)) **GitLab Enterprise Edition**
- [Bump rouge to 4.3.0 with the new IEC 61131-3 Structured Text lexer](https://gitlab.com/gitlab-org/gitlab/-/commit/e8289a931d6cf482c1feac3c0e4a9af9f9b643c2) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157252))
- [Add secure schemas version 15.1.4 and 5.1.3](https://gitlab.com/gitlab-org/gitlab/-/commit/f37ff659e20c823989d6f78f2d7b343b57c785c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157282))
- [Add metadata to group work item page](https://gitlab.com/gitlab-org/gitlab/-/commit/1d065451d1b6677b8e9e2c16f6032ebfd4865e45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157049))
- [Add NOT NULL on merge_request_id](https://gitlab.com/gitlab-org/gitlab/-/commit/fe28d0267fdc2230d59a00cb7841cf17f65d23d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156170))
- [Add merge and closed user ids to MR metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/c9b115a010ad681eb1c57ce31fb333ebdc25e843) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157206))
- [Pass org in export part creation](https://gitlab.com/gitlab-org/gitlab/-/commit/2e8c605e61e1e3ae7a13828ede9e541ec7e44266) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157074)) **GitLab Enterprise Edition**
- [Add support for child pipelines to SBOM ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/6eab3a93690af0b73d4dd32e431a19c6bacedd78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151814)) **GitLab Enterprise Edition**
- [Add option to sort Pipeline Schedules to frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/3573dec857ad905f2de64ee3498ddab78cc5aec4) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157224))
- [Add ability to create label in work item labels widget](https://gitlab.com/gitlab-org/gitlab/-/commit/d327d4ce3ffc63c8b3ba63b1d1742c2324cd6031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156524))
- [Allow `admin_runner` ability to change stale runner pruning setting](https://gitlab.com/gitlab-org/gitlab/-/commit/d903b29f8a0c48475c6045349c4964c1381f9801) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155497)) **GitLab Enterprise Edition**
- [Adds type to issue webhook attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e6017ad32d0b74b224dfaffabaae3db832be84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156760))
- [Add button for adding additional seats to error messages](https://gitlab.com/gitlab-org/gitlab/-/commit/a1c37cf4c5ff40506c0043a752aec1d2fc5e8412) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155737)) **GitLab Enterprise Edition**
- [Adds the CRUD Container component](https://gitlab.com/gitlab-org/gitlab/-/commit/313ca91904b092475e4d62ff90a90dbe17ca9c01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156749))
- [Add variables field into PipelineType](https://gitlab.com/gitlab-org/gitlab/-/commit/a6d441fc18e1df2c8c5bd9e44ae5bd6cf3d93a01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155418))
- [Show latest version on version creation](https://gitlab.com/gitlab-org/gitlab/-/commit/752ff4db28ec6c38eff135bc99953d8173388ddb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155978))
- [Backfills gitlab group issue embeddings on gitlab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/9101e4229aba3224e4916b5557f8d0766885ad4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154940)) **GitLab Enterprise Edition**
- [Enforce rate limits for notification emails](https://gitlab.com/gitlab-org/gitlab/-/commit/4d990b60e1a4341add14437d24398a07b3ce6a7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156945))
- [Release CI/CD popularity count and sort](https://gitlab.com/gitlab-org/gitlab/-/commit/ccc6b38cb6dc01f9f9c2f2b6d168a10c92218095) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156654))
- [Remove ci_expand_nested_resource_group_variables FF](https://gitlab.com/gitlab-org/gitlab/-/commit/cb194188d3540d141d4d21aa679c3bb9485db840) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157146))
- [Protected packages: REST API PATCH package protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/883ad288d8a131398c8c744432aba919d2278866) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153577))
- [Add api to return group's shared groups](https://gitlab.com/gitlab-org/gitlab/-/commit/a015acefff8c8bceaca21193a8c576bf5fe8ec11) by @imskr ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155251))
- [Protected containers: Allow nil value for fields `minimum_access_level`](https://gitlab.com/gitlab-org/gitlab/-/commit/430374098a1e8b078f38585219ba012fb914f996) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146997))
- [Add maintenance mode banner to edit frameworks UI](https://gitlab.com/gitlab-org/gitlab/-/commit/d67604b6a6b900bfda49002d8b3690afaa384239) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155887)) **GitLab Enterprise Edition**
- [Add cargo to supported sbom and sync types](https://gitlab.com/gitlab-org/gitlab/-/commit/114c6191291c84bb3f2fe0a37701ab9604389cf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156072))
- [Add disabled_direct_code_suggestions setting](https://gitlab.com/gitlab-org/gitlab/-/commit/57c2bf6c68e86711699c76c41ff9717c69d0f22c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156147)) **GitLab Enterprise Edition**
- [AI impact analytics dashboard is now generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/b23a75f987231d1b882e6460a57109230c604dfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154148)) **GitLab Enterprise Edition**
- [Adds inheritance settings to API::Integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/56a2f1da6ead60b6ae42633a6263595813576c3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154915))
- [Remove identity_verification_arkose_challenge feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b882650e842bc4b82b7af44507418bd414da396b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156862)) **GitLab Enterprise Edition**
- [Added include_forked filter to the zoek search](https://gitlab.com/gitlab-org/gitlab/-/commit/dda457f63b5b0546ca9e3ab449e0dc902156655c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154099))
- [Extend organization to snippets table](https://gitlab.com/gitlab-org/gitlab/-/commit/1b14e34b38fb9b26c3737a93c189804464ca88fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155580))
- [Include required backend data for the Project Header](https://gitlab.com/gitlab-org/gitlab/-/commit/28c0badf0bead0768a092fb298d1b8cc39162548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156049))
- [Added create and delete apis for instance level namespace filters](https://gitlab.com/gitlab-org/gitlab/-/commit/cd588f8794c57f1b87f899429ff5febdb43f6699) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153156)) **GitLab Enterprise Edition**
- [Add approval_policy_rule_id index and foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/05c2f382674e5951bdd4eb771a14bb203eb286ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155256))
- [Add pod logs buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/7446d3fe32cbb1cb9876714805125640fc5b19cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156544))
- [Add support for rendering readme in terraform package details page](https://gitlab.com/gitlab-org/gitlab/-/commit/67d63b74dff09e7a4fefdfe5e8e77e74bf073bdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155025))
- [Create container_repository_deletion_marked audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/130adeb5bea20ed3934820fd223c58e045110342) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152967)) **GitLab Enterprise Edition**
- [Protected packages: REST API POST package protection rule](https://gitlab.com/gitlab-org/gitlab/-/commit/07af56ad982ac40656fdd907f6626f2bb4f93b1e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153571))
- [Adjust logic to add org to export](https://gitlab.com/gitlab-org/gitlab/-/commit/1b9cea92f6e3cb3317c36388acffd109638b835f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156367)) **GitLab Enterprise Edition**
- [Add mediaType as a field to Tag](https://gitlab.com/gitlab-org/gitlab/-/commit/8bfa8d8f130ca74127e99f85e99c5c5f1bcb3d9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156303))
- [Adds List-Unsubscribe-Post header to notification emails](https://gitlab.com/gitlab-org/gitlab/-/commit/2f6f362ae293171da5882592ef93f2e5e99ca585) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156414))
- [Add member_role_id to ldap_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/83684890db91add42b8651f0562a7d9a7a868152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155676)) **GitLab Enterprise Edition**

### Fixed (162 changes)

- [Exclude scripts from coherence check when publishing npm packages](https://gitlab.com/gitlab-org/gitlab/-/commit/9a6daba70e91fbcc0b46cc5bd50e37de63a58eee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159427))
- [Relax the version comparison for NPM uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/450f299f822649d8772b88d516cd982d46a81bde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159327))
- [Fix worker when record not found](https://gitlab.com/gitlab-org/gitlab/-/commit/ce9477c4c6d2a78d1b270eb4453e5157bbc8170a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158973)) **GitLab Enterprise Edition**
- [Fix Content-Disposition not working for Azure in API download](https://gitlab.com/gitlab-org/gitlab/-/commit/b3c547feccf134234284514d641b2dea42bd50d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159292))
- [Display error when delete framework fails](https://gitlab.com/gitlab-org/gitlab/-/commit/571492480ace5b8e3ad5dbb5fd6df29dd0473545) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159207)) **GitLab Enterprise Edition**
- [Cobertura parser: Extract filename OS-agnostically](https://gitlab.com/gitlab-org/gitlab/-/commit/ad34f313de7ae59910f3b0bbeff6da89ee5199eb) by @bmarconato ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159263))
- [Fixed Productivity Analytics date range calculations](https://gitlab.com/gitlab-org/gitlab/-/commit/3e6f3a9a0f612d1b73a17487fa265a3a7f8505e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158664)) **GitLab Enterprise Edition**
- [Fix IDE Duo Chat timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/bb885d2da7e208424e3f9100b5de78ae5c03a5b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159201)) **GitLab Enterprise Edition**
- [Support auth credentials from URI for pull mirror validation](https://gitlab.com/gitlab-org/gitlab/-/commit/9d5f6d4bd03ef6cc8282ea539b3a50e7383b42f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158076))
- [Remove invalid foreign key fk_87f4cefcda_p](https://gitlab.com/gitlab-org/gitlab/-/commit/8ff55f5255757dcca5f7ec776720f8e6c4e40d62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158585))
- [Fix calculations for predefined date ranges in Value Stream Analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/1a0f0fabf271268e7272d01ba3370985915c34e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156355))
- [Use sentence case for work items "Linked items" header](https://gitlab.com/gitlab-org/gitlab/-/commit/8cd3212b168810bda633c8078250aadc4050ce8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159148))
- [Fix custom emoji display](https://gitlab.com/gitlab-org/gitlab/-/commit/d4d9005c15a6c1d97812b0daf667d4aa2d0a2499) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159136))
- [Fix pipeline subscription error flash message display](https://gitlab.com/gitlab-org/gitlab/-/commit/e21661bfde2afabe49af4e86384eb203664678af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158151)) **GitLab Enterprise Edition**
- [Remove zoekt dependency from elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/cb1027397db9249bd359adec7cdc5b6fb8ea5101) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157921)) **GitLab Enterprise Edition**
- [Fix custom role bug with requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1ddccc5712bf0a346952d666fbf71da675d3ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157115)) **GitLab Enterprise Edition**
- [Fix issues with quick action explanations](https://gitlab.com/gitlab-org/gitlab/-/commit/025d14c15e7ec0c1dfe813730a9194cf2f16b410) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158990))
- [Fix notification emails not being sent when using external authorization](https://gitlab.com/gitlab-org/gitlab/-/commit/6a140058c3e0fb99eaeb1298a357200e319e6d67) by @pR0Ps ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110709))
- [Clear seat assignments cache on bulk upsert](https://gitlab.com/gitlab-org/gitlab/-/commit/068b498bc5072b95c4d7a88db3bb0fad9723f820) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159065)) **GitLab Enterprise Edition**
- [Fix how maven dependency proxy credentials are sent](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc5abe412a364eeb46f811f9b77092839ee3ed1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158593)) **GitLab Enterprise Edition**
- [Remove validation for ProtectedRef access levels](https://gitlab.com/gitlab-org/gitlab/-/commit/42d475a1314f2301c24501f3b7e2e1e3b4f89bf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158296))
- [Make `complianceFrameworks` field work for subgroups](https://gitlab.com/gitlab-org/gitlab/-/commit/3cf82399f3ee900869dfc75f0b9142cf7feb87d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159055)) **GitLab Enterprise Edition**
- [Introduce dedup lock for rescheduling jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/7e469afe690bb59b45456dcb426242e0d07279a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158329))
- [Fix GitHub Import when importing from GHE](https://gitlab.com/gitlab-org/gitlab/-/commit/ea2d574785ac7f080577c64b37864b8c4e214eb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158503))
- [Fix alignment of admin groups header](https://gitlab.com/gitlab-org/gitlab/-/commit/decf1f008d63edd582b5bf6fbc1627269cb209c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158805))
- [Parse the package.json file entirely for NPM uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/6d91ce9ca96b68f720e232582b3ab6d4cdb7f5b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158978))
- [Authenticate the GitLab Duo usage controller](https://gitlab.com/gitlab-org/gitlab/-/commit/2540a50b105bf4971a1501e16d594548ea3b9491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158758)) **GitLab Enterprise Edition**
- [Fix new issue note for group level issues](https://gitlab.com/gitlab-org/gitlab/-/commit/f41a2e170fc0df8969e4404f992994b97e25963e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158496))
- [Remove milestone truncation on issues/merge requests dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/1d6db3dcc9deda7d456735ab2e0920c52bf9e2cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158375))
- [Protected packages: Npm package push protection for admin user](https://gitlab.com/gitlab-org/gitlab/-/commit/7622de8c7eb77596cd4486e16cbe3887e9a6cf5c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156439))
- [Work Item Epic feedback close on click](https://gitlab.com/gitlab-org/gitlab/-/commit/a83a354db835594945f3b6a68cd7a53144725aa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158900))
- [Fix work item sticky header](https://gitlab.com/gitlab-org/gitlab/-/commit/57fd28472e239445bc8a12fc0722857c42adbc36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158896))
- [Fix bug with achievements path when feature flag not globally enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/951b4aa67a1ebbb4124274b46456dee1f243c095) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158895))
- [Protected packages: Fix documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/327f7009058a3dfe11dfc652b27bed787e0a084e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158894))
- [Add workItemType check for weight widget for epics](https://gitlab.com/gitlab-org/gitlab/-/commit/a14fc4ee58210c2accd95c141625d8fdcc2db81f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158878))
- [Exclude disabled custom permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/94a33e125508a13734a62a39ae702e5ce560dba4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158848)) **GitLab Enterprise Edition**
- [Prevent modal close on comment submission](https://gitlab.com/gitlab-org/gitlab/-/commit/eb2277960ec3bf66623fa1d77670fc451823f2f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158478))
- [Remove empty minimum_should_match from query](https://gitlab.com/gitlab-org/gitlab/-/commit/731a7e4953bcc2575d2cb7bd6a7708c1d9d5df2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158645)) **GitLab Enterprise Edition**
- [Prevent running scans from execution policies after downgrading license](https://gitlab.com/gitlab-org/gitlab/-/commit/2f6536064b1d214c268ac78d53e10cbad97ce123) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158817)) **GitLab Enterprise Edition**
- [Fix wildcard package.json search in npm upload](https://gitlab.com/gitlab-org/gitlab/-/commit/917899322e2074f2cd4468a6f5ec3b120e0d6ede) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158806))
- [Fix sync failure retry backoff](https://gitlab.com/gitlab-org/gitlab/-/commit/75b31d017ab5f8bb420e7bb23279131b81d5c590) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157805)) **GitLab Enterprise Edition**
- [Exclude last page link from projects/id/repository/commits endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/f1eca9272f911e1c4c0f2b4e2a67f0c53cc3e4d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158278))
- [Unify spacing in group and project item components](https://gitlab.com/gitlab-org/gitlab/-/commit/aadf1e2079cf96c17de27253d8e07d4f8304f3d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158639))
- [Fix MR approval policy `prevent_pushing_and_force_pushing` enforcement](https://gitlab.com/gitlab-org/gitlab/-/commit/b479126b59dd39b1fc0d738665044ece0e4c8110) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158435)) **GitLab Enterprise Edition**
- [Update static_holmes to v0.7.11](https://gitlab.com/gitlab-org/gitlab/-/commit/6cacaf56940ab272c34a515f2fbaa8f9c388ae8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158714))
- [Fix meta.root_namespace not logging for groups API requests](https://gitlab.com/gitlab-org/gitlab/-/commit/8413bde199dbe4395ceb599cb88aa5d4ffb91f13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158671))
- [Remove `fix_sso_enforcement_for_web_activity` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/29f566014199d4ca90feb26a1dcae982743a82f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158655)) **GitLab Enterprise Edition**
- [Fix layout of filtered search for pipelines page on mobile](https://gitlab.com/gitlab-org/gitlab/-/commit/5085921f9bebccf2b8f03c2be711b02805581216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158649))
- [Fix cached introspection query and graphql-explorer](https://gitlab.com/gitlab-org/gitlab/-/commit/5bab3b90d3d440ae5ee44e8fb937a81deca0c7fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158260))
- [Ignore object pool already exists creation errors](https://gitlab.com/gitlab-org/gitlab/-/commit/cd5c559d81fcbeed4781666eea23ff88624e52a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158412))
- [Fix approval policy type detection for policies list](https://gitlab.com/gitlab-org/gitlab/-/commit/9464813b2a7dcd480f6304f8f1963e5127aae7f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158528)) **GitLab Enterprise Edition**
- [Fix polling when retrying status check](https://gitlab.com/gitlab-org/gitlab/-/commit/9c9a7427d39481ae993fba572b379634b7ead720) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158527)) **GitLab Enterprise Edition**
- [Fix NoMethodError in PathLocksController](https://gitlab.com/gitlab-org/gitlab/-/commit/6b66490ff71e4aa311afe05e541ac69854e6c565) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158434)) **GitLab Enterprise Edition**
- [Protected packages: Remove developer as an example from documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/7d191795eb9413b998d73b1985c02997d999cd88) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158433))
- [Ignore selected project if adding epic](https://gitlab.com/gitlab-org/gitlab/-/commit/3fe3078b6fce5c41c1431c15ef3c053f1b07ef30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158241))
- [Remove Bad spacing in pending comment](https://gitlab.com/gitlab-org/gitlab/-/commit/641ecd1b8134c1d0af00f7a2f9094f4ec07a44af) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158429)) **GitLab Enterprise Edition**
- [Fix merge train merge availability when pipeline is canceling](https://gitlab.com/gitlab-org/gitlab/-/commit/99dfd60511346c843950c911c482b08e19644904) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158126)) **GitLab Enterprise Edition**
- [Fix broken schema path](https://gitlab.com/gitlab-org/gitlab/-/commit/e94b26c861f80efd63361f15da8964a6d62c3093) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157228)) **GitLab Enterprise Edition**
- [Fix incorrect retry warning when merge trains are enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/7e576e008ef04bf7bcefe917e4c33256caa17196) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158283)) **GitLab Enterprise Edition**
- [Fix Zoekt exact match](https://gitlab.com/gitlab-org/gitlab/-/commit/d893df66119a92d4b0bb89c73c841050a4af14b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158379)) **GitLab Enterprise Edition**
- [Forking project to groups with restricted visibility levels](https://gitlab.com/gitlab-org/gitlab/-/commit/fb0a1bf330d184eb0b5901b7a3e39a2c7f273d52) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157202))
- [Title returns a default value if no advisory title](https://gitlab.com/gitlab-org/gitlab/-/commit/31ba4d52d0a7e0a39b454dc8177175fa2e40158d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155841)) **GitLab Enterprise Edition**
- [When activity token is cleared set query to all values](https://gitlab.com/gitlab-org/gitlab/-/commit/e26eeb648b8249684aec6d8d2f461eaa8ebc472f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158098)) **GitLab Enterprise Edition**
- [Fix issues mailer for group level issues](https://gitlab.com/gitlab-org/gitlab/-/commit/b474a0465bbe9c8818a11ea32e8985e33db66cf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156360))
- [Display unverified badge for signed commits without a signature](https://gitlab.com/gitlab-org/gitlab/-/commit/1aceccdb4b372a16a7e8cb71c26666388fa5c7b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153407))
- [Fix related items header in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/298622b5f009c518701835a3f79fee3d13f73fab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158169))
- [Reduce getPipelineDetails query complexity below 200](https://gitlab.com/gitlab-org/gitlab/-/commit/42a009b95acd9df7f78f42eb7afcf6ba9789ec3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158158))
- [Fix issue description task actions focus bug](https://gitlab.com/gitlab-org/gitlab/-/commit/0ab321a080cde133f39971dfc6cb2c96085a1a75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157495))
- [Reset form error when tokens change after submission failure](https://gitlab.com/gitlab-org/gitlab/-/commit/365f13032ca4c186aebfaee78de9cdf407a3631a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157792))
- [Do not create empty rule for branch specific rules](https://gitlab.com/gitlab-org/gitlab/-/commit/e765f4ea1ad6b6f9d97a835e7f4c8eba0985a6d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157723)) **GitLab Enterprise Edition**
- [Reinstate dt disabled message](https://gitlab.com/gitlab-org/gitlab/-/commit/2f8110a741e85ee65f73e6c738260b6475d08fe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156744))
- [Fix submit keyboard shortcut on commit page](https://gitlab.com/gitlab-org/gitlab/-/commit/ff4782d2fd23b5d4ce7cb240e783d9fccc9b3f3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157998))
- [Remove custom CSS to fix modal background color](https://gitlab.com/gitlab-org/gitlab/-/commit/caf6a6e388a98c71a3331ee70b9155222dc94a4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158064))
- [Fix badge issues and sticky header](https://gitlab.com/gitlab-org/gitlab/-/commit/99e5372454a66afa98e65a9b26f00a6438135c0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158047))
- [Skip approval updates for merged MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/bc90a50bc57f11bc252cbc57e7ff4f887d5571c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158042)) **GitLab Enterprise Edition**
- [Fix ambiguous namespace_id in query](https://gitlab.com/gitlab-org/gitlab/-/commit/2f9aa3a181ff09af45b226f72d0e6d1847b481f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157780))
- [Pass session_id to nested sidekiq calls](https://gitlab.com/gitlab-org/gitlab/-/commit/08a9a012054dbd9fdafc48e74165f992e3523255) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157566)) **GitLab Enterprise Edition**
- [Prevent redudant finalisations of segmented exports](https://gitlab.com/gitlab-org/gitlab/-/commit/e51c3bbbadb487a4d64508314fda4a152279706e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157695)) **GitLab Enterprise Edition**
- [Allow Developers to create projects from templates](https://gitlab.com/gitlab-org/gitlab/-/commit/52e43952ea7987940fb07724589b1f6caf8930ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157401))
- [Fix flaky test in SyncFunnelsWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/a2e34f649d3c3c3dfe22721013ee2f2385a5f07d) by @max.woolf ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157763)) **GitLab Enterprise Edition**
- [Fix URL generation for links with spaces](https://gitlab.com/gitlab-org/gitlab/-/commit/23293597ecf724218349450527a1f64f87611d59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157942))
- [Fix Link header for Tree API requests](https://gitlab.com/gitlab-org/gitlab/-/commit/2ef5030ba61668fc00ff83cb088d30902af0f60b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157914))
- [Fix issue creation on board with scope set to No iteration](https://gitlab.com/gitlab-org/gitlab/-/commit/bba2d2b4d030f1ad420ae3472612d0301749255b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157892)) **GitLab Enterprise Edition**
- [Fix setting the `organization_id` for vulnerability exports](https://gitlab.com/gitlab-org/gitlab/-/commit/bb6b92a2d7ab40e5df07bf8b02b0f5f036bf96fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157889)) **GitLab Enterprise Edition**
- [Field needs to be called Url](https://gitlab.com/gitlab-org/gitlab/-/commit/bd553868ae635267f1615927ca7a6656406d16df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157884))
- [Fix bulk_import history prop type check](https://gitlab.com/gitlab-org/gitlab/-/commit/abae316f7bcefaa01afce3bfdf55e6bbff9bf337) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157856))
- [Upgrade graphql-client GEM](https://gitlab.com/gitlab-org/gitlab/-/commit/8ddbcd44cde498b7fb21bf29b550a4a0bc0a1c60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157772))
- [Fix Milestone collapsed sidebar, adjust some aspects of issue sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/947b0449ac1bc882b14c4ed90d3e82dcefc1ce42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157676))
- [Add safeguard for author](https://gitlab.com/gitlab-org/gitlab/-/commit/f63aa04e88334c28958abbfdda1157214cdec008) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157814)) **GitLab Enterprise Edition**
- [Geo: Update the host to build the replication details links](https://gitlab.com/gitlab-org/gitlab/-/commit/9e244068428fa02253cac7edf0514f4338d6d562) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157671)) **GitLab Enterprise Edition**
- [Add missing "Deploy Keys" breadcrumb item](https://gitlab.com/gitlab-org/gitlab/-/commit/fbe188dc81095116f8d7306e7abf10cc6968ff82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157445))
- [Allow viewing hook logs with admin_hook permission](https://gitlab.com/gitlab-org/gitlab/-/commit/4d52095187268809685043493e3b322fb437e22a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153806)) **GitLab Enterprise Edition**
- [Recreate records when moving issues](https://gitlab.com/gitlab-org/gitlab/-/commit/d4b0a967100e83bd22392105f4a46f215fa8f880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157332)) **GitLab Enterprise Edition**
- [Authenticate agent requests using Gitlab-Agentk-Api-Request header](https://gitlab.com/gitlab-org/gitlab/-/commit/cdaca4495de42c17d34f7b06928e52d2f53d08ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157703))
- [Fix Verification concurrency limit](https://gitlab.com/gitlab-org/gitlab/-/commit/58c8f5c0cfaffb54698df5f8bfabe8a05ce29924) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157553)) **GitLab Enterprise Edition**
- [SSO enforcement for web activity should only apply to current_user](https://gitlab.com/gitlab-org/gitlab/-/commit/72c0ce28c980e39c825604fb1ee1f2c593f13ac8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156934)) **GitLab Enterprise Edition**
- [Display the number of rules for a given branch only](https://gitlab.com/gitlab-org/gitlab/-/commit/6a4e41dda7ef955a29ef1d5b20b1b49cc3efbbe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157292)) **GitLab Enterprise Edition**
- [Fix sticky header badges shrinking](https://gitlab.com/gitlab-org/gitlab/-/commit/df2dfef866565edf5c05496548d2dd0321782c5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157580))
- [Fix DML not allowed error when creating views](https://gitlab.com/gitlab-org/gitlab/-/commit/c87295b3a65e6d95b9fb3b50917781347b877589) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156986))
- [Use pajamas default left and right spacings on Roadmap page](https://gitlab.com/gitlab-org/gitlab/-/commit/cd64bfb1757fba9f5a5179ce3fe3f1f9a230060c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156550)) **GitLab Enterprise Edition**
- [Fix orphaned work item parent links](https://gitlab.com/gitlab-org/gitlab/-/commit/811dafe0d4ace122674f20f364f552f6d473d809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156657)) **GitLab Enterprise Edition**
- [Add jwt for jira connect branches](https://gitlab.com/gitlab-org/gitlab/-/commit/dba8992cad989ff4717058a1c945db8a2b1f3d0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149377))
- [Do not wrap flex parent of verified badge and commit copy button](https://gitlab.com/gitlab-org/gitlab/-/commit/db8a0c4c742223639196f18672b44a339dfe3b1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156673))
- [Protected packages: NPM push protection for deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/c6931921bb6dad26cad0c2868dab57744c4e9e84) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156610))
- [Use universal_stylesheet_link_tag in app layout head haml](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5f004d4e2a91f7b6f8ed611734e672afea37d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157356))
- [Improve error message when setting parent of a work item](https://gitlab.com/gitlab-org/gitlab/-/commit/b933e6349919b84a1f6f2571d175eabbf344bd08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154557))
- [Fix search bar accessibility issues](https://gitlab.com/gitlab-org/gitlab/-/commit/ad6f231039e87dd6c6096eccd2c33e0de39f1166) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155091))
- [Allow to set "No one" level for branch protection defaults](https://gitlab.com/gitlab-org/gitlab/-/commit/097cfcc599122e4c43f022f51096ce38713077bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157315))
- [Fix MailRoom not loading in Omnibus](https://gitlab.com/gitlab-org/gitlab/-/commit/802a87d2fea4603d3eb4ac3848ae7c0a83cf14c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157339))
- [Change fixture order](https://gitlab.com/gitlab-org/gitlab/-/commit/2f51e7f4d1383039ebe0c9a391f9453897b9420a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157309))
- [Don't trigger edit wiki shortcut when using search](https://gitlab.com/gitlab-org/gitlab/-/commit/0e2078fec2a8f2ad9e1adcd0be99fb96ec7f8e35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157303))
- [Include action in webhook test payloads](https://gitlab.com/gitlab-org/gitlab/-/commit/3eac576afdfc3a72e1c2750b9640bbcef390a1cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156856))
- [Fix issue using multiple contact quick actions at the same time](https://gitlab.com/gitlab-org/gitlab/-/commit/6965459cba26119b6c0909d6f026dfde6a985312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157299))
- [Correct finalize migration for BackfillEpicBasicFieldsToWorkItemRecord](https://gitlab.com/gitlab-org/gitlab/-/commit/44d3563325e6e58248b92dcdcba75dd114aa6c32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157295))
- [Remove extra gap when 0 roadmap epics have children](https://gitlab.com/gitlab-org/gitlab/-/commit/d2e4c436b848c40d75087a08a294c7752a9cf0b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156694)) **GitLab Enterprise Edition**
- [Fix finding name in regards to image name](https://gitlab.com/gitlab-org/gitlab/-/commit/6fc93a0fc23ce1b3b21630b7225997181a5c24e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157070)) **GitLab Enterprise Edition**
- [Validate provided group parameters](https://gitlab.com/gitlab-org/gitlab/-/commit/97775beb0d5ebcd535758ee2d9033e4ecf7b1a87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156977)) **GitLab Enterprise Edition**
- [Vertically align group and project header](https://gitlab.com/gitlab-org/gitlab/-/commit/642efcacfc1806a09fae2dfcafb7ee3471b6af63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157097))
- [Fix undefined method error for invalid ref](https://gitlab.com/gitlab-org/gitlab/-/commit/34aed5beeb5dd85fb0236cf80635dfb6a082529a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157180))
- [Fix NoMethodError for Files API](https://gitlab.com/gitlab-org/gitlab/-/commit/756ab645265f272b30afc340cc26427f5cd77dcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157193))
- [Do not show minimal access role as option](https://gitlab.com/gitlab-org/gitlab/-/commit/38f785705ef873e7b869f5f76a288f709ce21181) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156882))
- [Include pagination values in request](https://gitlab.com/gitlab-org/gitlab/-/commit/d48821a5f2aff9acb63a7a8ca47c043fecfbfd1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157158))
- [DAST Scan library: Fix Tailwind classname](https://gitlab.com/gitlab-org/gitlab/-/commit/26a52654f5b5ab7530f6b52096e9b0d4db3787f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157170))
- [Fix line number for larger numbers](https://gitlab.com/gitlab-org/gitlab/-/commit/6308ab66ca7ab4bb90d3659cc98e8cd58dc557be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156820))
- [Fix 500 on Changelog config](https://gitlab.com/gitlab-org/gitlab/-/commit/fbf5c11464a6a462542a3ee7e273dc8a846c7be1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156938))
- [Fix spacing info popover icon on dependencies table](https://gitlab.com/gitlab-org/gitlab/-/commit/64b8b263e68d19e57113c708da2250cc365e0588) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157148)) **GitLab Enterprise Edition**
- [Revert "Merge branch '430915-enhance-permission-selector' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/642d945976e52049db6115742a57cce413a881c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157142)) **GitLab Enterprise Edition**
- [Do not show cluster image scanning vulnerabilities on development tab](https://gitlab.com/gitlab-org/gitlab/-/commit/08d6018da94e28bb4371be7974a486b5795848ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157018)) **GitLab Enterprise Edition**
- [Cap vulnerability report tab count if it exceeds cap count limit](https://gitlab.com/gitlab-org/gitlab/-/commit/f355e1e6b328ee9853ba646fe7f2d358515ddb20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157116)) **GitLab Enterprise Edition**
- [Enable the query workItemsByReference to accept a group path](https://gitlab.com/gitlab-org/gitlab/-/commit/1332f34e8f9acc5e3809e0ae8f7f7a2ea2ea9ca1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156881)) **GitLab Enterprise Edition**
- [Improve work item query when sorting by updated_at](https://gitlab.com/gitlab-org/gitlab/-/commit/d0a53cb7cb857d799536aeb00e4d97b3c4ba09e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157075))
- [Don't introduce Unicode null character while escaping it](https://gitlab.com/gitlab-org/gitlab/-/commit/cecc43e3618913788465fd9c9689fd6ee321ff32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157060)) **GitLab Enterprise Edition**
- [Fix related work item links syncing](https://gitlab.com/gitlab-org/gitlab/-/commit/e111fd6754d54c0c9946db008113ec83344d36a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157045)) **GitLab Enterprise Edition**
- [Fix extra blank space above drawer work item attributes sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/c44960893e0942a16034e7a194e2bb50407fb6cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155156))
- [Only enumerate commits in pre-receive check if push came from Web](https://gitlab.com/gitlab-org/gitlab/-/commit/ce85e857b4542999907b7826ce66e4daab26c59d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156965))
- [Fix layout of issue list top area on small viewports](https://gitlab.com/gitlab-org/gitlab/-/commit/24bcaba38df863e2a6ab609655f97e08b46a3f61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156972))
- [Fix the workItemType to be valid](https://gitlab.com/gitlab-org/gitlab/-/commit/0662cbfcbabbf54a1f4f65435f1919474460dce9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156879))
- [Ensure all analytics breadcrumbs display](https://gitlab.com/gitlab-org/gitlab/-/commit/8917292f05cc9f9edeabba64d382491360c76dca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156454)) **GitLab Enterprise Edition**
- [Fix missing forked_from_project in projects API for unauth users](https://gitlab.com/gitlab-org/gitlab/-/commit/ebc53851c0b9e0d627eb84a628612e79480ddf85) by @_ZN3val ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154289))
- [Fixes notebook markdown failing to render](https://gitlab.com/gitlab-org/gitlab/-/commit/ae191bc941275d408475271473b03117167b6a2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156908))
- [Fixed Numpad enter key event](https://gitlab.com/gitlab-org/gitlab/-/commit/b855762ffefb354ce697c47c843ee9c776646824) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156636))
- [Fix error message when adding confidential epic to public issue](https://gitlab.com/gitlab-org/gitlab/-/commit/95ede989758b6db216d0afe82c3189d6bfb5e5eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152972)) **GitLab Enterprise Edition**
- [Include empty groups in mentions autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/38c719cc94eee2165cbae364c1a45780ed960866) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156795))
- [Fix Bitbucket importer MR reviewers](https://gitlab.com/gitlab-org/gitlab/-/commit/dbc9b292da6686335baf1ce784840fb26ee008fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156383))
- [Use widget presence check for rendering Hierarchy widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f449e168011917d571fc018e7ed0c4c2bb79509f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156836)) **GitLab Enterprise Edition**
- [Skip IP lookups in validating URLs on certain conditions](https://gitlab.com/gitlab-org/gitlab/-/commit/e8190bd3d0ad87b98f920f144e098a6a2e08cca0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156547))
- [Add missing ResourceLinkEvent#synthetic_note_class](https://gitlab.com/gitlab-org/gitlab/-/commit/e55071ecfb409e1b7561c0b68f33b6eb90c0d317) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156204))
- [Fix missing require_reauthentication_to_approve in API](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a0f4a5900f5db22d3f2d9c68bf1423910742f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156554)) **GitLab Enterprise Edition**
- [Fix Inactive Project Deletion reset deletion date](https://gitlab.com/gitlab-org/gitlab/-/commit/a5268a1b0b0991464c82aacda538c9054612516e) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156036))
- [Remove the `deduplicate_security_report_ingestion_jobs` FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e5c3e03ae4c6cd916fce92d1d06bbd9317ed42fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156374)) **GitLab Enterprise Edition**
- [Apply `gl-break-word` to test file name in Pipeline test suite detail](https://gitlab.com/gitlab-org/gitlab/-/commit/da5605827e28ce50d88c3c3f7b59459a36ca1d0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156668))
- [Remove null bytes when importing diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/c3a333d5d4995108be679b2a90762f55cd3b70a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156659))
- [Fix resolving namespace conflicts on creating internal user](https://gitlab.com/gitlab-org/gitlab/-/commit/46c2d55b45babf686012ab40077353bb319eb868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156643))
- [Fix redirect to docs.gitlab.com when no custom doc_url is configured](https://gitlab.com/gitlab-org/gitlab/-/commit/44e5d9c9cb3ece3351ca73514b0138011f15e25b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156642))
- [Quarantine metrics_test_fetches_top_job_data](https://gitlab.com/gitlab-org/gitlab/-/commit/b6984b9f600cebee691c81aae8c3f7b798ac4db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156606))
- [Fix rename functionality using "Edit single file"](https://gitlab.com/gitlab-org/gitlab/-/commit/cd94fc7b67c1e46e4879c4f935ba2f74b3e798c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156512))
- [Resolve pagination issue](https://gitlab.com/gitlab-org/gitlab/-/commit/8bf5e49bd5c9d21ab9229505f4893d192d9e3718) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156391))
- [Read more: Fix background color in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/ab86f679430f905647da84f3cd026eea4fd40a6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156483))
- [Use LocalStorage for frequently used emoji](https://gitlab.com/gitlab-org/gitlab/-/commit/b464009dd1682e3946a94b2a504944fdb66b143c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156569))
- [Fix alignment of commit in admin jobs page](https://gitlab.com/gitlab-org/gitlab/-/commit/d630ecb9c8fe9013fced4e2c0df5a4594f56e0a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156565))
- [Fix kubernetes tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/33cf2695a8c4f0980fd11c556cf5766c9cd9b850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156508))
- [Skip conflict check when adding to merge train on pipeline success](https://gitlab.com/gitlab-org/gitlab/-/commit/ff44e19a433d6e2e00be36fd600b59ecf40f9d19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156079)) **GitLab Enterprise Edition**

### Changed (231 changes)

- [Change schema for sbom_sources](https://gitlab.com/gitlab-org/gitlab/-/commit/f3b79455de4cc16d95579f0448e33be91ae72e89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158597))
- [Disables remaining prometheus integration endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/216e81eca14044b99eeb1bf5dca27dec3b8f3e8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158356))
- [Change format of iteration dates](https://gitlab.com/gitlab-org/gitlab/-/commit/b95bd4c7ae6032fffcd6f58f324c1daf00226402) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155894)) **GitLab Enterprise Edition**
- [Use sentence case for security and compliance](https://gitlab.com/gitlab-org/gitlab/-/commit/02c120454f547a081a5e6482e81df0f3ab2bc761) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159260))
- [Rename DAG feature to needs](https://gitlab.com/gitlab-org/gitlab/-/commit/805a9f5fb0237f935a7ac5da0917296d061c22a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157899))
- [Clarifies error text for confidentiality](https://gitlab.com/gitlab-org/gitlab/-/commit/121f9773af11ff71f5272699bfae03bc3e203ad3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159024))
- [Improve AI impact analytics dashboard trend indicator tooltips](https://gitlab.com/gitlab-org/gitlab/-/commit/7e0f21055af23dad7badfabc991a5b5c97ec30ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159128)) **GitLab Enterprise Edition**
- [Update admin health check page UI](https://gitlab.com/gitlab-org/gitlab/-/commit/11a7b3adc2ed5928562c96b73a56ce9924cd0a78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158355))
- [Update scheduled_scans_max_concurrency for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/67dd42dbe5df22c7fa7b2a68bb6d9f7901961032) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157828)) **GitLab Enterprise Edition**
- [Defaulting Duo Chat to use Sonnet 3.5 and updating related documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/9607104202f2614c09b189dc9678060ccee1906f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159248)) **GitLab Enterprise Edition**
- [Cleanup telesign_high_risk_cc_validation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8c8d22d2462b3984cac418ba6b2c155e47a4f8ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159279)) **GitLab Enterprise Edition**
- [Updating LooseForeignKey cleaner service to not raise](https://gitlab.com/gitlab-org/gitlab/-/commit/c17516763c4ea1e8cee50b697f3f874f93877fb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154185))
- [Backfill zoekt replicas on zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/11a0e166b214ca057de5b47d58ff57efefe59507) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157849))
- [Use sentence case for Admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/f7dd3d965a91736f4b8ca7edd8d3a1c227f860d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158935))
- [Use group organization for import user personal namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/ee2aa8f23885690452627c428ba162d7d648d351) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159222))
- [Update background jobs header](https://gitlab.com/gitlab-org/gitlab/-/commit/9f3f0235736b4fe1121e5f098ec489d3fecdf3e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158983))
- [Remove pages from navigation when disabled in settings](https://gitlab.com/gitlab-org/gitlab/-/commit/c81e6fbd69ba5f5532e0b54f3dc716ec96e0f6d9) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158488))
- [Remove view summary experiment label](https://gitlab.com/gitlab-org/gitlab/-/commit/09bdb4dcd7d7ed97b5a2f518426e81795a5c3e37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159139)) **GitLab Enterprise Edition**
- [This MR adds new option for group dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/65b61d7c3b887c1f1b9d5de95c1f547b48b829ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158080)) **GitLab Enterprise Edition**
- [Migrate os sbom occurrences to correct components](https://gitlab.com/gitlab-org/gitlab/-/commit/6015871347123c24c1566e4c0165af887d256675) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152585))
- [Use monospace font for code inputs in Pages setup](https://gitlab.com/gitlab-org/gitlab/-/commit/26a838eeb8563805216faf1ac983d4aa2f0b996f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158673))
- [Add or text between conditions sections for scan result policy](https://gitlab.com/gitlab-org/gitlab/-/commit/dbf35f870009a38f88b5fa2fb5e3092d6edcdb0e) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158508)) **GitLab Enterprise Edition**
- [Move CI lint button](https://gitlab.com/gitlab-org/gitlab/-/commit/8063ab8e34e1c569dee7c828144ac9b407ff057a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158827))
- [Separate terminated workspaces into a new tabbed list view](https://gitlab.com/gitlab-org/gitlab/-/commit/9557c80c736627e0fb28a3dbc078a94f6eb3e429) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153322)) **GitLab Enterprise Edition**
- [Summarize issues using Anthropic](https://gitlab.com/gitlab-org/gitlab/-/commit/2885c45ff2feb15c7333342dd0548fdd31a59dd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159133))
- [Add details to client-side secret detection warnings](https://gitlab.com/gitlab-org/gitlab/-/commit/908d14efd49f636e1fc6a3163dd77d3765e69149) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156503))
- [Enforce job uniqueness with pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/382207a516c91312c9b481f3cf4e17c1e55a3016) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158949)) **GitLab Enterprise Edition**
- [Use sentence case for audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/4231b823a9c173089c4257384e053ad8aeafb09f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158996))
- [Renames TanukiBot to GenerateEmbeddingsCompletionsService](https://gitlab.com/gitlab-org/gitlab/-/commit/77db17e1db5c7d3c2d99abf8aba67137d8c633ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158209)) **GitLab Enterprise Edition**
- [Merge notes unification FF under more generic unification FF](https://gitlab.com/gitlab-org/gitlab/-/commit/270a0d9df6d76d86ad4ef7ea2ad6f46754d12bc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158764))
- [Author admin permissions for PersonalSnippet notes](https://gitlab.com/gitlab-org/gitlab/-/commit/e78544866cec31950d38ba39b540335eca466a30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158715))
- [Merge Request auto close issues now checked on merge](https://gitlab.com/gitlab-org/gitlab/-/commit/22905c5f0808e2b20ecb9d0daadc4cf8227a63be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158395))
- [Verify replicable after create/update](https://gitlab.com/gitlab-org/gitlab/-/commit/358f6dae5e65de9194b313dd5458faadc3bafef3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157697)) **GitLab Enterprise Edition**
- [Add Notify mutation to resend email](https://gitlab.com/gitlab-org/gitlab/-/commit/2b510a42398afbf069c7fe4b4245e80b49f7bf73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159073))
- [feat: Decompose sbom_source_packages from sbom_occurrences](https://gitlab.com/gitlab-org/gitlab/-/commit/b90f4b6e36209c7aa009ecdf5fb916f3518fc02c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158143)) **GitLab Enterprise Edition**
- [Use Duo for summarize comments](https://gitlab.com/gitlab-org/gitlab/-/commit/49499622ba1f4dd3231bff134a329e4c85bf4201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156650))
- [GraphQL: Rename CiRunnerJobExecutionStatus RUNNING to ACTIVE](https://gitlab.com/gitlab-org/gitlab/-/commit/b27d0d92dce5dd10d2986b666c6cd46e4662880e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159002))
- [Update health check page](https://gitlab.com/gitlab-org/gitlab/-/commit/35b777c4e28d6c5e6cb2dc1aaeaf8a01686237e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158986))
- [Update usage trends feature to sentence case](https://gitlab.com/gitlab-org/gitlab/-/commit/c4ea05a622c8d3d21e99bd25eb5b49f15c2e00cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158979))
- [Use sentence case for background migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a6eea7c63e694cb3b25f22f1156c9062f44614) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158981))
- [Used new process to gen gitleaks.toml](https://gitlab.com/gitlab-org/gitlab/-/commit/bc1ca822c2d863df8935121782ce15863f759ade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158259))
- [Merge labels unification FF under more generic unification FF](https://gitlab.com/gitlab-org/gitlab/-/commit/ca57ef643232626642582c2051cc5bdab533049e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158643))
- [Show selected work item labels at top of the list](https://gitlab.com/gitlab-org/gitlab/-/commit/02b81f94c42213d9d9b21ec10be89cc43d558c3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158005))
- [Migrate groups dashboard to filtered search and sort](https://gitlab.com/gitlab-org/gitlab/-/commit/a46b96c154fb88eb533cf9f59fe44a8ed974f0cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157667))
- [Use Active badge instead of Running badge in runners list](https://gitlab.com/gitlab-org/gitlab/-/commit/12fbcaa099cb483fc19b8338ee3303b2e6e949dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157935))
- [Update admin background jobs page](https://gitlab.com/gitlab-org/gitlab/-/commit/653a55a2906304bd647a25a75d0dcdb414d070d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158351))
- [Add license type to overview](https://gitlab.com/gitlab-org/gitlab/-/commit/228878e85b2515faf21c2d188a2db31118d60860) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158245)) **GitLab Enterprise Edition**
- [Update dependency ai-gateway to v1.10.0](https://gitlab.com/gitlab-org/gitlab/-/commit/72ad1b5a449a65297b73e45666960010926f78c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158590))
- [Add title and subtitle on the standalone GitLab Duo settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/7229273fd5694916aad10cd94512564efa90ce2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158482)) **GitLab Enterprise Edition**
- [Exclude archived projects from dependency list search filter](https://gitlab.com/gitlab-org/gitlab/-/commit/504cbe3f2d1627e270d63b643e476dfbd0d28bf6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158799)) **GitLab Enterprise Edition**
- [Hide Service Desk from navigation if disabled in settings](https://gitlab.com/gitlab-org/gitlab/-/commit/b93b46a577c2bc952a0dfabbb824d33d0b6dcf40) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158483))
- [Remove Gitlab.com check for last_published_at](https://gitlab.com/gitlab-org/gitlab/-/commit/73a027be56a2f1c12b10dd1cd29e60f00fa9c82f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156423))
- [Always allow license sorting for group dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/5271ec0ec5c4faf627cbd36c4ac2437c5e239758) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158684)) **GitLab Enterprise Edition**
- [Update spam logs UI](https://gitlab.com/gitlab-org/gitlab/-/commit/1ab4f62f1cd09b8c88a64a738a7a0bdf02a41085) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156950))
- [feat: Add doorkeeper device auth support](https://gitlab.com/gitlab-org/gitlab/-/commit/b33cfbc4d56c1ae808949012dc1dc791b6467080) by @johnwparent ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155622))
- [Explain quick actions inline in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/c4fcb325c334eaa81cd6b2952a34190b3fd1ad60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158367))
- [Add linked projects to framework](https://gitlab.com/gitlab-org/gitlab/-/commit/be668ec4482846931c6da8d3a6de058c292e169c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158403)) **GitLab Enterprise Edition**
- [Enable submit button by default](https://gitlab.com/gitlab-org/gitlab/-/commit/dedda453d11fcf5590723c3dc5dbb684c8a7f6b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158249)) **GitLab Enterprise Edition**
- [AI impact analytics dashboard: Add tooltip when there is no % change](https://gitlab.com/gitlab-org/gitlab/-/commit/f3447df4b029a9fdb443c409326a62ec8d0e6e48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158376)) **GitLab Enterprise Edition**
- [Remove search_merge_request_query_builder FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f3326fa520bfff0751a1821f3c70277e50b1946d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158135)) **GitLab Enterprise Edition**
- [Move merge request files now shown warning to diff panel](https://gitlab.com/gitlab-org/gitlab/-/commit/39f82a3a72ddd33f9f2be15342588f5266d66994) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157597))
- [Notify Admin re: the hierarchy limits in displaying Group(s) statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/47cea8c39958630931cfa294b280eb433cafa64b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155554))
- [Allow filtering Resource Access Tokens by state in the REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/c78720efd9285328a5a653820ed3509a0b29e41b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158155))
- [Add `seats_in_use` to GitlabSubscriptionHistory trarcked attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/a2b3e7bdd7123e46836c4df94efcfcfe84151e07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157311)) **GitLab Enterprise Edition**
- [Sets elaticsearch_issue_upsert flag as default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/9b81c92337a7d933b221f2a9b253ec6633834b34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158194)) **GitLab Enterprise Edition**
- [Add placeholder data to member tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/6b4f5fae5a564da827b00f47c4de69be52ae1248) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158569))
- [Prohibit "default" as compliance framework name](https://gitlab.com/gitlab-org/gitlab/-/commit/9828c418eb60a7fb5a79e46de4dee70b80bd3099) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149548)) **GitLab Enterprise Edition**
- [Backfilling null project_id for p_ci_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/bb06971eb127222b320b8950583c136fc8fe77f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158480))
- [Switch deployment approvals group view to Vue](https://gitlab.com/gitlab-org/gitlab/-/commit/402b8f34d28c6481031de9121c4a1ed00c60d952) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158052)) **GitLab Enterprise Edition**
- [Update protected environments to handle group view](https://gitlab.com/gitlab-org/gitlab/-/commit/52452c34b9d2073acdc982461b3c5873d99ffa19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157686)) **GitLab Enterprise Edition**
- [Add trial and update users_over_license_count in CurrentLicenseType](https://gitlab.com/gitlab-org/gitlab/-/commit/a576f08847f6b2db61cfc18c66f66281c1b45c9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155473)) **GitLab Enterprise Edition**
- [List selector component for groups can fetch project only groups](https://gitlab.com/gitlab-org/gitlab/-/commit/18b39712043b895b1b980a681c355c2fc899ff36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158253)) **GitLab Enterprise Edition**
- [Update admin credentials page](https://gitlab.com/gitlab-org/gitlab/-/commit/b3b59e785ea9a6f389cfe121e0d2a93cdb0d0ab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158451))
- [Update Tools Injector Image, PAT scope with additional ENV](https://gitlab.com/gitlab-org/gitlab/-/commit/228a9ccdab705a96e7513fb8f049e455dcdf07f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156714))
- [Update Cloud Connector architecture docs](https://gitlab.com/gitlab-org/gitlab/-/commit/16dddfacbef791ac45712e3a10ad543b2ea21349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157911)) **GitLab Enterprise Edition**
- [Update admin background migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/618e7c72b88d42275ae53b5dba5e05deccf67ece) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158349))
- [Clarify CI Job Token wording](https://gitlab.com/gitlab-org/gitlab/-/commit/cc67e266a9502e95f1b0cd7dbf3f9741362e9332) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156989))
- [Adds info alert about cleanup policy regexp anchors](https://gitlab.com/gitlab-org/gitlab/-/commit/597e1c2d15f0e533f431a5c7eaf815dc06016f0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157888))
- [Remove unicode_escaped_blob feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b97da58a57d56c8116b342ae1959be8afb825597) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158370))
- [Update admin topic page](https://gitlab.com/gitlab-org/gitlab/-/commit/3a6f47bc121c454f6d0b778790b1eef7e93b177e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157848))
- [Added Promotion Management for CreatorService](https://gitlab.com/gitlab-org/gitlab/-/commit/326329a5d856609a1f9e97aec9caa363af67f209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156891)) **GitLab Enterprise Edition**
- [Allow access token access to usage_data API](https://gitlab.com/gitlab-org/gitlab/-/commit/4bcea84dfecd37e25c532c53bb571ed5634255ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158085))
- [Default cube analytics queries to the last 7 days](https://gitlab.com/gitlab-org/gitlab/-/commit/ff012ea2897764f741c1dc268daf13f61f86e45c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158206)) **GitLab Enterprise Edition**
- [Refactors QueueExistingMemberService](https://gitlab.com/gitlab-org/gitlab/-/commit/61f33606c8661f1cd64c27d8bbd5d0c539941de7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156801)) **GitLab Enterprise Edition**
- [Enable custom dashboards by default on projects](https://gitlab.com/gitlab-org/gitlab/-/commit/80138e0b971eda439ad9f9a38197f7d74c8b6884) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157917)) **GitLab Enterprise Edition**
- [Fixing target_table_name for build_name foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/e77f8bc31e151f1180045bcf88f21126062a36a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158300))
- [Make filter based visualization designer generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/698ef8c44436233ddfa77335ebbdf4291ceb7283) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158072)) **GitLab Enterprise Edition**
- [Ignore `confidence` column on Security::Finding](https://gitlab.com/gitlab-org/gitlab/-/commit/4003634ceb0ed0e4301adb861d0249478559689a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158035)) **GitLab Enterprise Edition**
- [Remove DuoChat from Help center](https://gitlab.com/gitlab-org/gitlab/-/commit/db279dde3ea6c08a74a5bd0e66c42277af6b7452) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157759)) **GitLab Enterprise Edition**
- [Remove wiki sidebar limit](https://gitlab.com/gitlab-org/gitlab/-/commit/6fe5c48e96617b5a201e2ce5bb7df0e8359f9f23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158084))
- [Improve token access add form](https://gitlab.com/gitlab-org/gitlab/-/commit/baabb747fcf91b4c303eb31fcbe372d61e3ac6e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151730))
- [Move create repo position](https://gitlab.com/gitlab-org/gitlab/-/commit/1178913de16f344a5486106377b31f70dd3ebe22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157707))
- [Fix CI icons shape](https://gitlab.com/gitlab-org/gitlab/-/commit/4b3a40e406c3138882bb52c6d880b21a90271524) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158204))
- [Support expanding references for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/603ece973f525e7609f42e6f84304fc69b36089d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157963))
- [Align the visual presentation of the action between groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/08c107ecde68b41339eb711c2b7d0a610904b376) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157727)) **GitLab Enterprise Edition**
- [Update admin project layout](https://gitlab.com/gitlab-org/gitlab/-/commit/e76d5ba332f8599570560c66fb7c854d23eaf5ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157529))
- [Align admin users account content](https://gitlab.com/gitlab-org/gitlab/-/commit/e33210ac0324bffa770e5a573d6472ce0e9d8a76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158067))
- [Clean up signup_intent_step_one experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/78d7591000f0ab105df35017e0a7c608633751d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157181)) **GitLab Enterprise Edition**
- [Show wiki sidebar on a 404 page](https://gitlab.com/gitlab-org/gitlab/-/commit/164db2e91935ac1469f42e1a6597e28408900217) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158088))
- [This MR adds validation for policy action](https://gitlab.com/gitlab-org/gitlab/-/commit/f14353e720e45e59f698309cb8a9c885b53ccac1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156528)) **GitLab Enterprise Edition**
- [Update welcome screen](https://gitlab.com/gitlab-org/gitlab/-/commit/aa1f14c90596e595426c7c841041156fcc5ab47e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156514))
- [Update users page for admin view](https://gitlab.com/gitlab-org/gitlab/-/commit/f55b68653c9c39e9c172e1ea069f637507977ad8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157314))
- [Update concurrency_limit for CreatePipelineWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/169acd04ead7833127f0340dc3330d0de65704f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158075)) **GitLab Enterprise Edition**
- [Added Finder, and correponding scope](https://gitlab.com/gitlab-org/gitlab/-/commit/7269bbba6850f4e791eebc969853b7fe669f1401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154555)) **GitLab Enterprise Edition**
- [Zoekt: Add ctags support](https://gitlab.com/gitlab-org/gitlab/-/commit/fa8d2e1db1ccdc39b6de6b5f1955ae29e7eef992) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158049)) **GitLab Enterprise Edition**
- [Remove creating framework at sub-group level](https://gitlab.com/gitlab-org/gitlab/-/commit/cde82e647ab065dd61fbc8c8e67aa9e42a89e0a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157868)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint for `remote_mirrors.project_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/19daf7b6c5386dc282490f9240708d64ef778e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153959))
- [Add `taskCompletionStatus` to the work item UI](https://gitlab.com/gitlab-org/gitlab/-/commit/22a7a948a5a87db3440efee764734ab8674daddf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156589))
- [Update semver_dialects gem version](https://gitlab.com/gitlab-org/gitlab/-/commit/9cfb70e0df3503e4d3d83faa343ffb647ae5503f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157521))
- [Default enable FF group_level_vulnerability_report_grouping](https://gitlab.com/gitlab-org/gitlab/-/commit/3f5973054c408d9abe137cf150d54d43985f72d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157949))
- [Update abuse reports list view](https://gitlab.com/gitlab-org/gitlab/-/commit/3a15b7fa01bb2baaaffcfc735b81f2c3c7991ee1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157681))
- [Use SettingsBlockComponent for admin push rules](https://gitlab.com/gitlab-org/gitlab/-/commit/a79bec61becdd9d306e9ec835cd690b050226a11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157611))
- [Sync epic work items to legacy epic by default](https://gitlab.com/gitlab-org/gitlab/-/commit/f2c68d054ae098cf54d37421f0952d838fad5ecd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157789)) **GitLab Enterprise Edition**
- [Add organization_id to stage event hashes table](https://gitlab.com/gitlab-org/gitlab/-/commit/16494994cb8544388fd068b9b0396f3a63c8ac12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156621))
- [Admin groups: Improve display of content](https://gitlab.com/gitlab-org/gitlab/-/commit/8014ea9fcbd2232da04fcdf02f3e35c6aedccf98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157420)) **GitLab Enterprise Edition**
- [Update PMG architecture blueprint](https://gitlab.com/gitlab-org/gitlab/-/commit/d782d03cb892334bd1e7142ac1569d4c98b14a16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157806))
- [Fix required approvers validation](https://gitlab.com/gitlab-org/gitlab/-/commit/388f43277c5f82ea00a37ee2e155a8154c1490f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157777)) **GitLab Enterprise Edition**
- [Update graphiql-rails gem](https://gitlab.com/gitlab-org/gitlab/-/commit/313046daf347a0455ca7eab430fcb3b8b5d08af3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135010))
- [Modified UX of command palette](https://gitlab.com/gitlab-org/gitlab/-/commit/4c2f759439605e210980ef1816b756bd2f7e2d08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157015))
- [Admin settings: Migrate network settings to SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/4a7b408efa1375c8d5196b288d2d323c4579f835) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157051))
- [Migrate oauth applications to use CRUD container](https://gitlab.com/gitlab-org/gitlab/-/commit/b5348d678230f1201ec50b71077e939b0e3411fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156903))
- [Migrate broadcast messages page](https://gitlab.com/gitlab-org/gitlab/-/commit/093159d629902435e92561d9bcceb5771ca4576c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156895))
- [Remove the data preview option from the visualization desinger](https://gitlab.com/gitlab-org/gitlab/-/commit/644d80d912d522194ede40687430430008e9b24f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157744)) **GitLab Enterprise Edition**
- [Update dependency ai-gateway to v1.8.0](https://gitlab.com/gitlab-org/gitlab/-/commit/9fbdaef10c2324ea2453e2f87be57f1cde0f06a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157736))
- [Extract SSoT for pipeline sources for which SEP should be enforced](https://gitlab.com/gitlab-org/gitlab/-/commit/c716fd84ceb2db0556918e14dfbe63911d0fec08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157588)) **GitLab Enterprise Edition**
- [Move Mermaid too large alert to the beginning](https://gitlab.com/gitlab-org/gitlab/-/commit/2c21c66ee910b4e07e8a978a0b06609dcfc9564d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157735))
- [Update bulk create service for custom software licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/31025b8cb969cc45ce7f11c1b1b75d714b1c770e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155588)) **GitLab Enterprise Edition**
- [Raising error in mutation when more than 1 frameowrks for project](https://gitlab.com/gitlab-org/gitlab/-/commit/cdad457636d8d7ad0de5ed065ac0fb4efa1460fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155854)) **GitLab Enterprise Edition**
- [Update vendor/spdx.json to v3.24](https://gitlab.com/gitlab-org/gitlab/-/commit/74af77ec2263d9ff12164933cae35c086d40aaf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157653))
- [Add search_type param to SearchService](https://gitlab.com/gitlab-org/gitlab/-/commit/065d10f065ed76394a7e0f17ae8d4c7605911d90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157022))
- [Update wording for pipeline deprecation banner](https://gitlab.com/gitlab-org/gitlab/-/commit/d89e8c6510b3fef6c3404374e29357d542181e95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157595)) **GitLab Enterprise Edition**
- [Route resolve vulnerability through the Anthropic client](https://gitlab.com/gitlab-org/gitlab/-/commit/854029222599e6288722b294811274872738796a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156671)) **GitLab Enterprise Edition**
- [Add read_runners custom ability](https://gitlab.com/gitlab-org/gitlab/-/commit/a0f8c3098e87b8fa09bca3ca6838511a07efdd28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156798)) **GitLab Enterprise Edition**
- [Migrates deploy keys to use CRUD container](https://gitlab.com/gitlab-org/gitlab/-/commit/6652d0ef24c4eafd866011a267ba3eb2b35263e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156909))
- [Allow blob window size to be specified](https://gitlab.com/gitlab-org/gitlab/-/commit/1b472b9a753771ec77bddc3e67cbf2aa7b9785a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157168))
- [Remove ":" for drawer title: overwritten part](https://gitlab.com/gitlab-org/gitlab/-/commit/12a479b2f361049980afc7c4da9f01a77d23f11a) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157550)) **GitLab Enterprise Edition**
- [Adds snowplow form error events](https://gitlab.com/gitlab-org/gitlab/-/commit/2546c6284592d4649a6e66f84603f0969e63a9a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157543)) **GitLab Enterprise Edition**
- [Adjust layout of iteration report issues table](https://gitlab.com/gitlab-org/gitlab/-/commit/0028e3fc79a7bfeb4c62be91c25261327bcd54c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157377)) **GitLab Enterprise Edition**
- [Remove "+" icon and add word "new" to button](https://gitlab.com/gitlab-org/gitlab/-/commit/e01d8f7eaac2dddfa4cf5a3a94028d122a1d7dd9) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157394)) **GitLab Enterprise Edition**
- [Update admin groups layout](https://gitlab.com/gitlab-org/gitlab/-/commit/a1af6477a95333aaf63f46a4a884e8b7840df809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157201))
- [Add support for parsing CI log timestamps](https://gitlab.com/gitlab-org/gitlab/-/commit/76f92b62bbb4c378212372cec41c7704039c7164) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155695))
- [Reduce the amount of variants for GitLab UI badges](https://gitlab.com/gitlab-org/gitlab/-/commit/499a179102694e0ac7c2e1a7d45a207641dbd151) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156880))
- [Duo Chat cancel button integration](https://gitlab.com/gitlab-org/gitlab/-/commit/3f12dc8a3d330d357d5e142b25c53457f8b694ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156880)) **GitLab Enterprise Edition**
- [Remove "scan" word from execution variable](https://gitlab.com/gitlab-org/gitlab/-/commit/e2026f16ed7890dd76181d805b71fd29878e3718) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156415)) **GitLab Enterprise Edition**
- [Update admin product analytics settings](https://gitlab.com/gitlab-org/gitlab/-/commit/d713b19f316db1a69a9a49aa4e8c2ea32380fb7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157088))
- [Allow assigning compliance frameworks at sub-group level](https://gitlab.com/gitlab-org/gitlab/-/commit/08c7ab96dc50691819a0a98da0d9177dc2e595fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157412)) **GitLab Enterprise Edition**
- [Migrate CI/CD Variables settings to CRUD container](https://gitlab.com/gitlab-org/gitlab/-/commit/caba42c7f858e66f859270803669c72672a8c3cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157276))
- [Update admin license and compliance layout](https://gitlab.com/gitlab-org/gitlab/-/commit/384c5ef0f03a996bd73fb8dc887ae0a06d733d0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157095))
- [Remove drill-down link for code suggestions usage metric](https://gitlab.com/gitlab-org/gitlab/-/commit/8a9b34bb78361f818b4fd8ca6b91c1ad4fa12285) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156984)) **GitLab Enterprise Edition**
- [Change History links to 'View import history' buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/609af389f719a76b4c758ec5e0bf668088167961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156373))
- [Update tools injector image](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb33746ed2a41060e51ab226309da5516be40ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156918)) **GitLab Enterprise Edition**
- [Admin labels: Migrate to use CRUD container](https://gitlab.com/gitlab-org/gitlab/-/commit/6fb5e3e24e9d2fce5978d1898c8a9455549ec2ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156923))
- [Admin settings: Migrate reporting section to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/ac82c7fdcb612e8ebbc5bb7704478bae7051a618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157047))
- [Admin settings: Migrates repository page to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/058017c2bfd57cecaaa34d031eaafb89ac92360c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157039))
- [Admin settings: Migrate analytics section to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/a0c84238d13d5bd3eec550898a2084690ffef4b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157054))
- [Admin settings: Migrate preferences to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/1443c2bef7c0598888ae3480cd95380f7d939517) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157053))
- [Admin settings: Migrate metrics settings to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/af2e67d8ce93db82586ef8aac4ea088efda73aa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157050))
- [Admin settings: Migrate templates section to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/9ceddc16cd553a45aaecdc2c4399d6399f18e7d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157048))
- [Admin settings: Migrate CI/CD settings to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/6ea284f56c218f06f6400c43cc434197c565ec6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157040))
- [Admin settings: Migrate settings blocks of general settings](https://gitlab.com/gitlab-org/gitlab/-/commit/f73caead94a079d98b9c487b87e513a98240f24b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157033))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/3c6a6b7270d07856a38dcef472640ece462b2337) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156723))
- [Pipeline graph dropdowns: Use GlBadge for indicating jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/cfcab231757af7fa07ccd5e23fd617140e1013c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156160))
- [Update projects page for admin view](https://gitlab.com/gitlab-org/gitlab/-/commit/30ee894176c4fc42b1c943a4a222a3f395c2bc00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156790))
- [Require user to solve Arkose challenge on every PN verification attempt](https://gitlab.com/gitlab-org/gitlab/-/commit/8d9db028c231f4dc594e78dd5ac35cc69701fcca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156865)) **GitLab Enterprise Edition**
- [Migrates File Hooks to use CRUD Component](https://gitlab.com/gitlab-org/gitlab/-/commit/39b218efe1edae7ca6d05e28d39cf45840a16593) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156900))
- [Admin settings: Migrate advanced search to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/25f6ce6fc714129beeb1d5c4070fbc35d16ce717) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157038))
- [This MR updated approve layout](https://gitlab.com/gitlab-org/gitlab/-/commit/5d184548cc8224176f0764a9b0e32001b817418c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156628)) **GitLab Enterprise Edition**
- [Conditionally handle AuthorizationsChangedEvent when policies exists](https://gitlab.com/gitlab-org/gitlab/-/commit/0b94a9895a58607246b47258cf641ae1d72240e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156775)) **GitLab Enterprise Edition**
- [Add report_type to Approval Rules APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/e67fbe0b7de9bc40c9de2c8218faba608b8ba592) by @PatrickRice ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155772)) **GitLab Enterprise Edition**
- [Update locked application setting popover](https://gitlab.com/gitlab-org/gitlab/-/commit/48b93da24c1cf9c143e73a29bc5c6e2f5176c866) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156926))
- [Enable assign resource v2 by default](https://gitlab.com/gitlab-org/gitlab/-/commit/3bdac40f8c0ebd77a7e4a14fcae063e45bcfb312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157156))
- [Update admin geo page](https://gitlab.com/gitlab-org/gitlab/-/commit/2008e21509833c30718c592e8798352493ae7cf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157080))
- [Refetch job list when an artifactless job remains](https://gitlab.com/gitlab-org/gitlab/-/commit/6e4e17193691300e40f99298bd5cf18221fc3bda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127632))
- [Add start trial CTA to duo pro usage tab](https://gitlab.com/gitlab-org/gitlab/-/commit/2149ae090f50d351e95b2d5d015af779b7c2ac8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155902)) **GitLab Enterprise Edition**
- [Provide consistent interface across scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/3128f3d5f86b11b24d0d0cc7bf37a8de17c90281) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144067)) **GitLab Enterprise Edition**
- [Update snippets empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/637554379ce6e03928dada47d8260792bb4047f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156785))
- [Remove ignored `toggle_security_policies_policy_scope` setting](https://gitlab.com/gitlab-org/gitlab/-/commit/e105c938a7cd849decb95798ecdc0d044725cbd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153266))
- [Update naming of duo group settings](https://gitlab.com/gitlab-org/gitlab/-/commit/3a979af4ccba5da09b2d97bc5ccd90dd632d512f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157010))
- [Add UserStarredProjectsResolver sort argument](https://gitlab.com/gitlab-org/gitlab/-/commit/077ca496eaadc0a9383a552ed32294233de2f7e7) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153651))
- [Migrates gl-display-inline-flex to gl-inline-flex](https://gitlab.com/gitlab-org/gitlab/-/commit/3aa4f990bde82a9c6fb59d7c726a02bddc693cea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154887))
- [Multiple frameworks labels](https://gitlab.com/gitlab-org/gitlab/-/commit/ca5a43e01aadde03cf32218f62f7e56eb5709f05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156570)) **GitLab Enterprise Edition**
- [Add permissions checking to AI Impact Dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/23bf0938f52424ec382ba745b57375234b769949) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156555)) **GitLab Enterprise Edition**
- [Admin settings: Migrate security settings to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/467df2db45835010a9b4210982fe662f2f30e8b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157043))
- [Externalize strings on ldap_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/2fcc3e2fd12ea0c6813e7c88a1548c90cecf24e0) by @MAlvarez32 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155271))
- [Improve usability of environment folders](https://gitlab.com/gitlab-org/gitlab/-/commit/076d3d3a212c3a93ec60863090c3a0fa185ecd05) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157104))
- [Display capped results for large datasets](https://gitlab.com/gitlab-org/gitlab/-/commit/d1d8005ef78e12f960dcf5ddde6b9dcc2266087d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156026)) **GitLab Enterprise Edition**
- [Update GitLab logo on deploy page](https://gitlab.com/gitlab-org/gitlab/-/commit/f3f6e87a1ef799024b4a9e76f88afe9f3cc384d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156261))
- [Update groups page for admin view](https://gitlab.com/gitlab-org/gitlab/-/commit/64125d73f2485bdb6f2400e2db99df134975ce8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156800))
- [Update admin subscription page UI](https://gitlab.com/gitlab-org/gitlab/-/commit/0f48e27e338908ff0935c6024de2bbf8db037560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156839)) **GitLab Enterprise Edition**
- [Add placeholder actions to table](https://gitlab.com/gitlab-org/gitlab/-/commit/dd77d0d5f36c2cffba601a0544ea28727ee5b13a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156533))
- [Update visualization type selection with validation state](https://gitlab.com/gitlab-org/gitlab/-/commit/f7e5cdd2aa4d7eabb99d4490976844d6a111e369) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156976)) **GitLab Enterprise Edition**
- [User friendly date formatting in Container tags_list_row](https://gitlab.com/gitlab-org/gitlab/-/commit/8721191f9f5f3c314d84e28f5e25682abf3116b7) by @Saurabh-Daware ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156376))
- [Remove extra space in board cards](https://gitlab.com/gitlab-org/gitlab/-/commit/49d00c28e62c0550838cb12734651b3f54788d42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156113))
- [Check deploy_key exists during ProtectedRefDeployKeyAccess#valid?](https://gitlab.com/gitlab-org/gitlab/-/commit/d9c9f033c8be3e9ee9e6ad3ca21f8f623f6f046d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155745))
- [Implement AR validations for ProtectedRefAccess](https://gitlab.com/gitlab-org/gitlab/-/commit/849784e42d78d25aa83e9c83b787c98178cad254) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156002)) **GitLab Enterprise Edition**
- [This MR updates yaml schema](https://gitlab.com/gitlab-org/gitlab/-/commit/154b2da8aefb489cae1d42cf3afd04a89138fa3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156363)) **GitLab Enterprise Edition**
- [Remove showcase_free_security_features experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/e9eea5f2cff7648915c6bdec58af9ceae9a56e00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156803)) **GitLab Enterprise Edition**
- [Reverse make_synced_work_item_read_only FF check logic](https://gitlab.com/gitlab-org/gitlab/-/commit/1046966e152bed6adfbb147d248ce92ae8694472) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156648)) **GitLab Enterprise Edition**
- [Renamed autocomplete scopes to use plural form](https://gitlab.com/gitlab-org/gitlab/-/commit/cb4d38de54c7cf1fd8bf3804a1e9675b5f379b9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156492))
- [Show dependency location count if `occurrenceCount` field is present](https://gitlab.com/gitlab-org/gitlab/-/commit/44bc09dbc7339fe9c056153808fa60660a6a3f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156557)) **GitLab Enterprise Edition**
- [This MR removes loading state](https://gitlab.com/gitlab-org/gitlab/-/commit/e7880922f54023e32063fcf0e97ef1783497ce6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156793)) **GitLab Enterprise Edition**
- [Add concurrency_limit to AddApproversToRulesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/790ff68c27495f69be533660910df98909476b33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156778)) **GitLab Enterprise Edition**
- [Update gitaly servers page](https://gitlab.com/gitlab-org/gitlab/-/commit/db83949fb9ab1e1355cbc9648dd42ab8b014f123) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156536))
- [Update trial terms](https://gitlab.com/gitlab-org/gitlab/-/commit/a6d5bc395710a1bf7c45ed4f95aad72937ba5a01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156341))
- [Enable zoekt_exact_search by default](https://gitlab.com/gitlab-org/gitlab/-/commit/741fb8a8dc06422f09a4c75c6146a311182f63b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156748)) **GitLab Enterprise Edition**
- [Remove ai_claude_3_for_docs feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4935a53bca171971c5844a53544725a704bc073e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155281)) **GitLab Enterprise Edition**
- [Increase max body limit for AI GW requests](https://gitlab.com/gitlab-org/gitlab/-/commit/fa2732f43cd308e3a178332a14223a05162aa8b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156738)) **GitLab Enterprise Edition**
- [Remove GCP WLIF setup script API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b637037095f224eee419ef8518db13d7a6704525) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156699)) **GitLab Enterprise Edition**
- [Drop ci_job_artifacts_use_primary_to_authenticate feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3157d57733edbeff16488d545e497d26503c0c0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156697))
- [This MR updates yaml schema](https://gitlab.com/gitlab-org/gitlab/-/commit/26ea84d39e87d36f0b0b97b7b1b6f85d79f9b1c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156325)) **GitLab Enterprise Edition**
- [Adds Zoekt::Replica](https://gitlab.com/gitlab-org/gitlab/-/commit/888775a1207cfeae18dafc62ceaf8ff1d9f2ba00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155317))
- [Update admin system info page](https://gitlab.com/gitlab-org/gitlab/-/commit/13f5c11eed8a8386b76c705105f88f6ea460b3a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156567))
- [Replace approval modal with link to approval page](https://gitlab.com/gitlab-org/gitlab/-/commit/9d00cfb79edfdbac48142147eb24694049813a3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156656))
- [This MR refactors multi select text](https://gitlab.com/gitlab-org/gitlab/-/commit/944cd45e0b61a39408b79b72f8766fe31f16c387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156641)) **GitLab Enterprise Edition**
- [This MR updated user approver dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/283832501708409b15b210c260749a04bfb8a7d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155611)) **GitLab Enterprise Edition**
- [Remove :notify_owners_of_finished_dt FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6f1cfc427a1ef7a22e5afce825bf545e9934cc47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156633))
- [Cleanup the duo_pro_trials feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/172f26857626b38e114792d8a6d0f425d934bc83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156132)) **GitLab Enterprise Edition**
- [Change unit primitive for text embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/e90f96b6b63e907bfb6ecec11e6351b1ed2682e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155835)) **GitLab Enterprise Edition**
- [Extend error-alert Vue component with buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/4a97c359cc09a20e3764ed25001083b34eba0483) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156206)) **GitLab Enterprise Edition**
- [Add external Stripe IDs to CreditCardValidation](https://gitlab.com/gitlab-org/gitlab/-/commit/7bc3183c75dab0616a6fe2431d9820eacbdcec76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156505)) **GitLab Enterprise Edition**
- [Improve compliance center for subgroups](https://gitlab.com/gitlab-org/gitlab/-/commit/d57d6295907736e3c4d99b22ee3a8c026b358c31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156260)) **GitLab Enterprise Edition**
- [Use static AWS credentials for indexer if set](https://gitlab.com/gitlab-org/gitlab/-/commit/14207a5ebee99111fc8696c2ee7d6925acbc2005) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155960)) **GitLab Enterprise Edition**
- [Remove transaction opening for non-basic search count](https://gitlab.com/gitlab-org/gitlab/-/commit/dcf811f417b7910c7aaaf5ff1c08dd77e118bfa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156321))
- [Remove overflow:hidden from card component](https://gitlab.com/gitlab-org/gitlab/-/commit/8af3832ba271bbb766c2b0a19c8a1f2cd3ab892f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156548))
- [Display usage quota tab during duo pro trial even group on free plan](https://gitlab.com/gitlab-org/gitlab/-/commit/5dbeb1485d4fd777104bf72cc87160d9f3a9f879) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155767)) **GitLab Enterprise Edition**
- [Allow self-signed CC tokens in development](https://gitlab.com/gitlab-org/gitlab/-/commit/c7c60323dd09e415533b737d01c92548f375dc95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156496)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint to ci_runner_namespaces.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ba16f8e7548147c4b74867458e11efa361d09457) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156318))
- [Add NOT NULL constraint to ci_runner_projects.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/412604bf443e427faf57497cb1858bd1d1f4fe92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156314))
- [Update create label UI in labels widget](https://gitlab.com/gitlab-org/gitlab/-/commit/920e418ac45df7b2d8b95f135f34b3a7b2d0fca4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156056))
- [Change help link text copy](https://gitlab.com/gitlab-org/gitlab/-/commit/6e7ed1176ae2236ae74ffc6645645eeb084e4fbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156029))
- [Update dependency auto-build-image to v4.2.0](https://gitlab.com/gitlab-org/gitlab/-/commit/62133c84cd65559717213f735d36e9d92382689c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155945))

### Removed (22 changes)

- [Remove triggers and old columns for bigint p_ci_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/944155c2596919d5d70ab5491116cd43f5a1bf93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158711))
- [Removes storage_size index on project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/6c685a9fb1b35e46d3e2f8354d25fc8f815773cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158616))
- [Remove MR review summaries table](https://gitlab.com/gitlab-org/gitlab/-/commit/0b13bb2a53ad6ec8320e1c71934401a818762713) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157572))
- [Drop `index_vulnerability_occurrences_for_issue_links_migration`](https://gitlab.com/gitlab-org/gitlab/-/commit/518ad733fb27471edaf7fc15605a0bc9a2962135) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158736))
- [Reverts 112527 as no longer required](https://gitlab.com/gitlab-org/gitlab/-/commit/3336394f92d8916175b7c4679d4bbf7de54dc300) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158609))
- [Remove EnsureStageService and prep for removal of `stage`](https://gitlab.com/gitlab-org/gitlab/-/commit/f6aaabeff28e897d7f91aa5aed448e7b82f91160) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156892))
- [Drop legacy geo_repositories_changed_events table](https://gitlab.com/gitlab-org/gitlab/-/commit/876d67fadd97b5124f4c54fd2988eaf873c05e53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158660))
- [Remove SafelyChangeColumnDefault include](https://gitlab.com/gitlab-org/gitlab/-/commit/37bf0d05bc6d949e59371706b5901429bb061e5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154212))
- [Remove `issues_mrs_empty_state` feature](https://gitlab.com/gitlab-org/gitlab/-/commit/e63ee4fb40f484ddc6c04876a3ec31c074b3b52c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156693)) **GitLab Enterprise Edition**
- [Remove create_user_details_all_user_creation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7eeb9d74630925207a3699e6f6cc83fceb0b8e3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157958))
- [Remove the template auto fill AI feature](https://gitlab.com/gitlab-org/gitlab/-/commit/15db60a024c937a52036e64b78f5403320194f7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156766))
- [Removes project stats index on packages size](https://gitlab.com/gitlab-org/gitlab/-/commit/7feef107a4e051799be9f632f55a08265acf8ca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156008))
- [Chore: Remove the ai editor assistant feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ae1fd20a598a2c4515ae3ad9f2b456831dd6cb3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157837)) **GitLab Enterprise Edition**
- [Removes storage size idx on project_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/8ff61ea7a5debf8979fe9fc7c87127b125b09c8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156005))
- [Drop unused DAST tables](https://gitlab.com/gitlab-org/gitlab/-/commit/c76555c4a9840b72384ecc428f4222cc107d8232) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153443)) **GitLab Enterprise Edition**
- [Removes project stats index on wiki size](https://gitlab.com/gitlab-org/gitlab/-/commit/e6a2a5a4e31ae200530dc7434c90a3734db06b00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156010))
- [Remove track_ai_metrics_in_usage_data feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d426fa2fe74208662ca3d8c0a3c93e24f9501743) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157196))
- [Removes index on project_statistics async](https://gitlab.com/gitlab-org/gitlab/-/commit/12ffa83842508c0be03fef1842b17beb3bcdd074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155999))
- [Remove obsolete codeSuggestionsUsageRate field](https://gitlab.com/gitlab-org/gitlab/-/commit/19d17c281d9b76756b1dd86e7e2e149c89067d9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156750)) **GitLab Enterprise Edition**
- [Remove sep batching configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/3030bb11d7535ca2950429fe573dedc0e09634b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156835)) **GitLab Enterprise Edition**
- [Removes temp index from project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/158acf6c0a54d5bb79530f7e43822e2bddaa89a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155997))
- [Cleanup prominent_create_board_btn feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/43d17697e2b38cf7f8f0d23b7e1800f7d040d167) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156324))

### Security (23 changes)

- [Check npm package name, version and scripts coherence](https://gitlab.com/gitlab-org/gitlab/-/commit/14ce36e7045252dd74dc59a71a5acc348ceadf13)
- [Disallow serving Pages over disabled custom domains with deployments](https://gitlab.com/gitlab-org/gitlab/-/commit/08a5faf3c92d34407a96b03d6a44c12db00ee1f2)
- [Prevent privilege escalation via custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/30cc4e834c300d18d4e30f052de18f999065ae85)
- [Check if user has ban_group_member access before banning in namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/81594e06ccef46c19dbb2b9e760d3422a9bdf4eb)
- [Check for create_deploy_token policy before creating deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/38d7fcbde55100c6eb63a1c8babd379cb4d205a3)
- [Prevent using quick actions for some bot users](https://gitlab.com/gitlab-org/gitlab/-/commit/a08eaa3dac0eb76fd4135eda412572f24fb28578)
- [Disable raw HTML for quick action pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/049504cecf622189f69b14dbc8895e6f36af0af4)
- [Disable quick actions unless description changed](https://gitlab.com/gitlab-org/gitlab/-/commit/3d20fd45ec2b24ff02a06eea0ef1558f522a211d)
- [Remove comment support from shrug and tableflip](https://gitlab.com/gitlab-org/gitlab/-/commit/8cf683d6f1cea2ac3f0975bcf7d6e156f40a37ba)
- [Pass SSO session data to Sidekiq](https://gitlab.com/gitlab-org/gitlab/-/commit/c7eabd8a76e035e439d27734310dd3d6c83bc2c0)
- [Do not run a new pipeline on re-target](https://gitlab.com/gitlab-org/gitlab/-/commit/7db0608a8e0e76c3a697edf052a9e603367161b0)
- [Remove search results from public projects with unauthorized repos](https://gitlab.com/gitlab-org/gitlab/-/commit/d38ed3d433f51060c7c7daa793ce9aaf14beb513)
- [Reject deletion of security policy project approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/69d6113572c1515f46ddfb1990aa746ae123c518)
- [Add limits on autolinker regex](https://gitlab.com/gitlab-org/gitlab/-/commit/74014108b6811c8ea40813e0981915115742a1d4)
- [Fix for Private job artifacts can be accessed by any user](https://gitlab.com/gitlab-org/gitlab/-/commit/50bd3b7b0cdcedf7efdf3b8b1d8808a4e0aaab76)
- [Prevent non-members from using promote_to quick action for quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/ff425064c3d22341d520fff8abf829a812c5c14f)
- [Fix the catastrophic backtracking in openapi regex](https://gitlab.com/gitlab-org/gitlab/-/commit/faa5c6e04b47aa618ef2fdf7b1242272896d134c)
- [Use permitted_params for standalone and multiplex queries](https://gitlab.com/gitlab-org/gitlab/-/commit/b5afa91ae27c8d9b11461ebeb03b25a230f5bc54)
- [Fix clickjacking on OAuth application page](https://gitlab.com/gitlab-org/gitlab/-/commit/5073499734aa260dc96a6329ff913ae72a3e2e62)
- [Remove collapseLongCommitList method](https://gitlab.com/gitlab-org/gitlab/-/commit/4c970a3095e06a3406bb0cbcc2286d637ee3128c)
- [Security fixes for banzai pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/b32d3189758c48afc0621a806645cb20f83b9864)
- [Hide branch merge request if merge requests are private](https://gitlab.com/gitlab-org/gitlab/-/commit/c376da8991401b8748048cc11e6bdbd61c253724)
- [Mitigate ReDoS attacks via `method_call_regex`](https://gitlab.com/gitlab-org/gitlab/-/commit/ee4cac0f6ca99cbf90724d75d42a9e03137e5ddc)

### Performance (3 changes)

- [Parse affected ranges only once](https://gitlab.com/gitlab-org/gitlab/-/commit/e6867b4399e085f47f76d96501d1e5b72db6ee87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158842))
- [Adjust Bitbucket server importer to be resumable](https://gitlab.com/gitlab-org/gitlab/-/commit/47b0c08f41b8ed39c57959f8bb6523cfc213da6f) by @ivantedja ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156797))
- [Remove group-level vulnerability report performance improvements FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f4fb8398fbbc1d36811634c9fe5777c26cd80daa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157786)) **GitLab Enterprise Edition**

### Other (150 changes)

- [Finalize DeleteOrphansApprovalMergeRequestRules2](https://gitlab.com/gitlab-org/gitlab/-/commit/a92c8f39a61117bf3962689bce8fb77d3c846e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159017))
- [Update display_work_item_epic_issue_sidebar to work_item_epics](https://gitlab.com/gitlab-org/gitlab/-/commit/2cbeed7a47a56f659f0defe1e99f90bdc5f5aa07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158613)) **GitLab Enterprise Edition**
- [Remove bitbucket_cloud_convert_mentions_to_users ff](https://gitlab.com/gitlab-org/gitlab/-/commit/368af21b0ecc97e0c5fb334724b7306bd8f33a20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157957))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e6f582894a15d68d96b1da99e1f8377d884a4f1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159033))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c51b47f0d371e8b75a74367d7ffa1099762eceab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158874))
- [Remove filter_deleted_groups feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8e97da759c8330158fa467313e414adb766f1f15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159214))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/aae6917b0dcc8bafeaafe62a3ce96c420429c92f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159184))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2df953b7f5176226d1301c0874786523b21f2d75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159178))
- [Remove unused index with namespace_id on vulnerability_reads](https://gitlab.com/gitlab-org/gitlab/-/commit/9f2e060a8daa90b8f9ed517eccec76ca6ca0f46d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158941))
- [Sync approval settings for groups for reauth setting](https://gitlab.com/gitlab-org/gitlab/-/commit/2d483935d991f72bb0f712ae77ac2b1569a20144) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158648))
- [Remove self_managed_code_suggestions feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0b19feae781cfbc6127f2cc1cc2f0685b8ae35cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158440)) **GitLab Enterprise Edition**
- [Create table p_ci_build_tags](https://gitlab.com/gitlab-org/gitlab/-/commit/fd0f7a053d2c4953a57bc48ad54290313ba2e60e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158327))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8e737f615f3165c284ab24b6fab14067a7bf9fe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158710))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a1d73b25b38a1921b1a27bb9b80b37eab21e9eb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159034))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f0ec39f8a3d7e47a98ccca9f6da9955277de3535) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159031))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1344908bc4b839baefee9c2d8833ffb00d3bf9bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159030))
- [Remove reference to BBD ODS FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e248a83b765bbdd5fe0c313581445575b3d287ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157902)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/614e6402a938a00524dd7317776a1d5e827fb6d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158871))
- [Remove `rewrite_sbom_occurrences_query` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/915bf7b04257f005312f43ba893f5b8b99486855) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158772)) **GitLab Enterprise Edition**
- [Fix forgotten ability](https://gitlab.com/gitlab-org/gitlab/-/commit/739a6964a41bfb3ee735a8721a8417aa872973b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158698)) **GitLab Enterprise Edition**
- [Fix <Layouts/LineLength> offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/290db2121b2155f3517861c3e6556a0f823851d8) by @Rohit.Kala ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158783))
- [Fix flaky test "#protected_branch_exists?"](https://gitlab.com/gitlab-org/gitlab/-/commit/9fbc1dfd6a04e8a0f4af63e0ac91fc3cbf7cfaa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158779))
- [Implement delete car mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/97e567c212d65890952bd6232a6b747ff72c58b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156488)) **GitLab Enterprise Edition**
- [Rollout Filtered Search on Vulnerability Report](https://gitlab.com/gitlab-org/gitlab/-/commit/3870780a825594d474d7b33523821f9b2eae13e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157172)) **GitLab Enterprise Edition**
- [Fix pipeline schedule error handling](https://gitlab.com/gitlab-org/gitlab/-/commit/4c0152e2428685af535cdc56e57d36eb565f9fb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158436))
- [Remove temp index](https://gitlab.com/gitlab-org/gitlab/-/commit/f7211e0c62b1533f0fb16d69cdda8ff82ba5199c) by @TamsilAmani ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139271))
- [Add a `pending_delete` column to mark namespaces deleted by user](https://gitlab.com/gitlab-org/gitlab/-/commit/03871fbcbed7cde24eb2d80eb2ddd8b7b9126603) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158309))
- [Add partitioned FK from ci_pipeline_artifacts to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/16d0cd7c4edec447d52562d72a8fb7844ad51797) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158086))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b81f0aadb99a88ecfbdd0367da33411390280df1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158506))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/018d27c0cfa54483ff0de92581bbae897a6de4b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158507))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4dd720ee04b03cf4676f936df292c40ac90f318d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158558))
- [Finalize migration CreateComplianceStandardsAdherence](https://gitlab.com/gitlab-org/gitlab/-/commit/8d280d0605411dda077e329b5962be8670346d65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158148))
- [Rspec Test order: run test in random order](https://gitlab.com/gitlab-org/gitlab/-/commit/41360018cefed51bc0edaf49b888929922b2e9c5) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157845))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/20e296a10c1787ce22c5082c357bfcc28b606919) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158181))
- [Refactor SAX document to cobertura](https://gitlab.com/gitlab-org/gitlab/-/commit/60b7d09861b6afe93d5c796123e3c4d312e03bdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158341))
- [Release jira_connect_remove_branches](https://gitlab.com/gitlab-org/gitlab/-/commit/8f2d020a40dbc523afc86291c25f27b12938434f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158224))
- [Finalize BackfillWorkItemHierarchyForEpics migration](https://gitlab.com/gitlab-org/gitlab/-/commit/44702df1c97d0e01c7eb8a25141f16789f2d030d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157981))
- [Improve accessibility of remove icon buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/5c9976313973900497654370de97221c8a1d3153) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157929))
- [Persist all policies instead of active policies](https://gitlab.com/gitlab-org/gitlab/-/commit/dd249a70ec5b944371e27ff517b650877b2b91b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156735)) **GitLab Enterprise Edition**
- [Remove set_ip_address feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f3bdbedf8b6ba727c706e4102ecce306d8c02216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158418))
- [Finalize re-syncing basic epic attribute migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6e7cd743b12fcd155634d82af2247360ac4e23ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158384))
- [Finalize BackfillEpicDatesToWorkItemDatesSources](https://gitlab.com/gitlab-org/gitlab/-/commit/71eefb084e9c9cd34d8687ab693ebde92c87d936) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158037))
- [Enable parallel_project_export feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/64374dc941d86a0e9845cc34d5bb3a4b0963f08f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158369))
- [Add weight widget definition options](https://gitlab.com/gitlab-org/gitlab/-/commit/7c85c228ee21072c318e3117535c1543a316947f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157705))
- [Add partitioned FK from p_ci_builds_execution_configs to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/faf68ca11c79289938d08e2ca1e7800ac2489c43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157908))
- [Sync create index and swap columns](https://gitlab.com/gitlab-org/gitlab/-/commit/8852ca7059369db1a5449e96ec48a496cb5f801f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149671))
- [Fix Style/Lambda offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/cf3980a5712da1d17bb3c6409cc129533ebb5418) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157265)) **GitLab Enterprise Edition**
- [Add index for listing uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/f07a817427e63a9fec4816204d00c04bccd4f9d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157139))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e9abb2af481bee29ca0bda114ba340348c4ff0f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158178))
- [Protected packages: Batch load matching protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/463982894a3ac7ee871f373c98c4f45c0cf5fe72) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154595))
- [Extend a troubleshooting section to cover Xcode SSH keys problem](https://gitlab.com/gitlab-org/gitlab/-/commit/f54883e42feb25cca1d1cd8932384f336d9d4efb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158215))
- [Add partitioned FK from ci_pipeline_chat_data to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/cdfec4f6b7e4953d18beac1e7eeaf48480b8a0b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157938))
- [Rspec Test Order:Run spec/graphql/types in random order](https://gitlab.com/gitlab-org/gitlab/-/commit/0cf119cc43ce8facb883ed33e1eaeb2e323f2d4b) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158172))
- [Add partitioned FK from ci_pipelines_config to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/b42f9a1e167f103a2cd118f678df685677da66d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158065))
- [Finalize backfilling of related epic links on issue links](https://gitlab.com/gitlab-org/gitlab/-/commit/e0fda69bb3a89228d860fb81d0381dabbb0df482) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157492))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7fa3c9217a0b0c0e5d5f1a9a1c14d58d40a89642) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158174))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/569ec66e5b1866de254374383fdd83c4e9987625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158008))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1c1ac1e3efe1d68fb304225a18d599c69a3585d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157711))
- [Fix Layout/LineBreakAfterFinalMixin offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/a710a4065fd660008138594cc603b8fa8f9c6364) by @m.bortlik ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158123))
- [Protected containers: Enable multi-line errors in GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/f11d937169c2b061ae65d0d3444a6d7264239417) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148838))
- [Fix Layout/ExtraSpacing offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/c71dfae62eb6bc9ed9e682b1d0c64b0486cf9482) by @miha-prehcm ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158083))
- [Add partitioned FK from ci_pipeline_messages to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/2cb83573d6127c0b15344a24156e8dee4c7a9d05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158065))
- [Add partitioned FK from ci_pipeline_metadata to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/15d7fadcc85054caf17d76d0d940c1b9f24e6f8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158065))
- [Mark 20230615101400 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/65ecf2b70c32c4f4b41a20cc54c4a984aa9bc9ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157366)) **GitLab Enterprise Edition**
- [Change table ownership](https://gitlab.com/gitlab-org/gitlab/-/commit/d12b8a7105d8f17550ce5a2e221c328e0fa78983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158030))
- [Add and backfill group_id for packages_debian_group_architectures](https://gitlab.com/gitlab-org/gitlab/-/commit/38dba13a0c77b1d814d231a0764fca724cba077e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158027))
- [Add partitioned FK from p_ci_pipeline_variables to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/f0d1874de344f6b6ef6fc7dc139cd9013ab75b60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157747))
- [Regenerate rubocop todo files](https://gitlab.com/gitlab-org/gitlab/-/commit/bb1b277f6d338ea63d81c6f836d5249a04e9ab2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157740))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c0871506caa5e628605add1bf040546d7b788468) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157246))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c4b1fc1e8a5a275135f27061235dfa825c12f488) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156993))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/fb5441026837dd5bbaa048136e8d44e6e6180b6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157712))
- [Prepare ci_pipelines.autocancel_by_id for composite primary key](https://gitlab.com/gitlab-org/gitlab/-/commit/818302e3c6bd466acafdfa5062d74e84c98d53cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157619))
- [Finalize BackfillEpicIssuesIntoWorkItemParentLinks migration](https://gitlab.com/gitlab-org/gitlab/-/commit/95898c8f7b2329fb0c854c8a5b179496dea9391d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157974))
- [refactor: Increase test code quality for package controller test](https://gitlab.com/gitlab-org/gitlab/-/commit/b40706054a43e93f17016061d1d5b34265abe29c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149383))
- [Add partitioned FK from ci_sources_pipelines to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/3d19f526f0deee5ef049df819f92fbe82493fef8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157947))
- [Remove default values for ci_sources_projects#partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/84427538e86c952dd4da3e6121795925ee0ef83d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157909))
- [Add and backfill group_id for packages_debian_group_components](https://gitlab.com/gitlab-org/gitlab/-/commit/a610218dd24bd0589ffb8d197fbd79254829f5f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157905))
- [Add spec to verify FeatureFlagReferenceFilter N+1](https://gitlab.com/gitlab-org/gitlab/-/commit/6a57b5d86957ca675debd1f684c7629dbadcb30f) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157866))
- [Finalize migration ConvertCreditCardValidationDataToHashes](https://gitlab.com/gitlab-org/gitlab/-/commit/c55d426e46aebcd4dd786a7705668bac8b0b1d45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157836))
- [Add test for N+1 query for VulnerabilityReferenceFilter](https://gitlab.com/gitlab-org/gitlab/-/commit/ae717f7d3b513c9cc94a0051905a25f31b0e6778) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157853)) **GitLab Enterprise Edition**
- [Rspec Test Order:Run spec in random order](https://gitlab.com/gitlab-org/gitlab/-/commit/32dd8048a8ecdb4397502171130fbb2b4d101696) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157844))
- [Revert "Merge branch 'bwill/optimize-top-bound-lineage-search' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/05d6aa37ff18eb424567b3631bce94ca12a2d7c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157799))
- [Mark 20230719094243 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/04189615cbf59008f3faca617333ab94523b3a91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157373)) **GitLab Enterprise Edition**
- [Resolve Layout/ArgumentAlignment offenses 76](https://gitlab.com/gitlab-org/gitlab/-/commit/0780a7089def55a53cfabbd815b1c9258d50ece8) by @gauravmarwal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151273))
- [Create Dependencies::DependencyListExport::Part model](https://gitlab.com/gitlab-org/gitlab/-/commit/611693796c17c26017925e8284024a286f7d5923) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157638))
- [Add and backfill project_id for packages_debian_project_architectures](https://gitlab.com/gitlab-org/gitlab/-/commit/31b760f990afd45856d6b9b453e2cce0437d8ff7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157767))
- [Add partitioned FK from p_ci_stages to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/764b3d35fdfda65d8f53a69764cd43618e478c63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157753))
- [Add partitioned FK from p_ci_builds to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/e70f1a202ee685a29473b7c19a7af1f5d6f9bf57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157750))
- [Mark 20230719144243 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/69194636e77626e80f69f41b626da7fea2e712a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157375)) **GitLab Enterprise Edition**
- [Mark 20230628094243 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/69ebc4a04186d13151807c587d53ccc8aca3bb83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157367)) **GitLab Enterprise Edition**
- [Mark 20230702000000 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/af4b7fb6a2d92fa6e0521809cca5a7891d186d69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157369)) **GitLab Enterprise Edition**
- [Mark 20230711140500 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/aeb55e4c74b5cf5382377d23d30462139cfda6fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157372)) **GitLab Enterprise Edition**
- [Add and backfill project_id for packages_debian_project_components](https://gitlab.com/gitlab-org/gitlab/-/commit/3a2d5db6f51b0bf98b3a3e53bb0ded82ee92e206) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157626))
- [Mark 20230719142200 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/a884e64586bfe172d2d7fd17628172a33856c71a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157374)) **GitLab Enterprise Edition**
- [Mark 20230703112233 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/4c875ae756b3849756fe1385a8cb84db743d4ecd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157370)) **GitLab Enterprise Edition**
- [Remove ignored MemberRole columns](https://gitlab.com/gitlab-org/gitlab/-/commit/6bb23bcf406e5e7956d66b3c4ac28ddc04be7ee4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156264))
- [Set internal bots profiles to be private and confirmed](https://gitlab.com/gitlab-org/gitlab/-/commit/f7602f946c819b60e3a54826caa84ee146262826) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157557))
- [Finalize migration BackfillSbomOccurrencesTraversalIdsAndArchived](https://gitlab.com/gitlab-org/gitlab/-/commit/dda5e8c948fa9fb5c481a8673dc81c2bde079d5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157235))
- [Mark 20230628094700 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/7e1286ec975ad0f14341be82b52fc934800309b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157368)) **GitLab Enterprise Edition**
- [Add and backfill project_id for ml_candidate_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/c3e5edf00691b71c71b7531e067713fa72f0cd3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157484))
- [Add and backfill project_id for packages_dependency_links](https://gitlab.com/gitlab-org/gitlab/-/commit/0fc3dbc2be113adb6e36dd330f4a01c67dad708c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157483))
- [Add not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/49fee3d2b8383a6731771126f24298279d6edd2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156893)) **GitLab Enterprise Edition**
- [refactor: Apply best practices to feature test new project](https://gitlab.com/gitlab-org/gitlab/-/commit/65cbde5ccd5684f04d803bc83b95c2625cf591ba) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154086))
- [Rspec Test order: run test in random order](https://gitlab.com/gitlab-org/gitlab/-/commit/58eafbe8bd0ec62cf1654ba691faf9f965b0b419) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157178))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/664b950a95565920a92202dfe46f0d7ee8996dce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156997))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/dd31ad79eab6af213aa840eb093df5bceab693cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157395))
- [Mark 20230710142700 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/25bd3ba8c783dcc885d6373cc09400a659cfe888) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157371)) **GitLab Enterprise Edition**
- [Remove initialize_processable from Seed::Build](https://gitlab.com/gitlab-org/gitlab/-/commit/38fd3829c473eca7f851eb38110e4c993fd72ff6) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157260))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b39d6cf95cd307b3fad5de9b36fc8d201f3b0bf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157247))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5c6062bae55449c954f9eb37e11f0d811f740efa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157245))
- [Remove unused deployments indexes on .com](https://gitlab.com/gitlab-org/gitlab/-/commit/f8389ff2d52178bd0be63dabb5dc95f8135c3c3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157136))
- [Implement cars resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/041224188e2c073a4023d81c7331ee0594b1ed5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156145)) **GitLab Enterprise Edition**
- [Add and backfill project_id for ml_model_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/f8cdfcee0b0276be4099c34512572aebb224f1cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157191))
- [Add and backfill project_id for merge_requests_closing_issues](https://gitlab.com/gitlab-org/gitlab/-/commit/1ec02dca526dc018a2de5d978b28afc10dd6f362) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157186))
- [Add and backfill project_id for vulnerability_external_issue_links](https://gitlab.com/gitlab-org/gitlab/-/commit/4228c0d5f787b0fac105895bf845fb04d7877e98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157179))
- [Add and backfill project_id for packages_conan_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/11ecfcd0a9bb13be235e91949bfacfa2d933a74d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156254))
- [Finalize migration BackfillProjectStatisticsStorageSizeWithRecentSize](https://gitlab.com/gitlab-org/gitlab/-/commit/34511dfdee1149d549f9ce5aea44afa3c0afa98f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155152))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2642174f2cc89fb8fe8f94f2cb4808328078c3da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157005))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/aff7cb9815d4497d005185efba1bd7fd6ddceb1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157107))
- [Check for N+1 in IssueReferenceFilter](https://gitlab.com/gitlab-org/gitlab/-/commit/a39910d8e7deed3e4f60ee7e014467c0271e6ddc) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157110))
- [Drop `security_findings_confidence_idx` index from `security_findings`](https://gitlab.com/gitlab-org/gitlab/-/commit/2809cb8dd101755f59ae19ef2d87d93900baaa52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157071))
- [Add and backfill project_id for packages_maven_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/a03846af1541deaab1ebc9341d12193231f1d879) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157034))
- [Add and backfill project_id for vulnerability_finding_evidences](https://gitlab.com/gitlab-org/gitlab/-/commit/8709db853647b5d2afa117c34d1ffda55dde47d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157032))
- [Add and backfill project_id for merge_request_reviewers](https://gitlab.com/gitlab-org/gitlab/-/commit/ddd51bad31a2ab6ede4eb532a2e11e907291dccc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157031))
- [Finalize migration BackfillUsersColorModeId](https://gitlab.com/gitlab-org/gitlab/-/commit/570f26edab95ec24120e8fdbde7f6d4ca33ff1bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157013))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2d68f1a36f6e899d587eda74156571128c95d5c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156994))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4081d47da3c5a1d96f79a0ace12ac792711392d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156992))
- [Merge ExtractsRef into ExtractsPath](https://gitlab.com/gitlab-org/gitlab/-/commit/6a6aa68de80b2abaf8fd0329000d423d04ff5805) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155245))
- [Add new column to store organization project & group sorting options](https://gitlab.com/gitlab-org/gitlab/-/commit/9f8081fe25dc8f3a11c628b3bc83768bbc1debab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154899))
- [Remove imported column from relevant tables](https://gitlab.com/gitlab-org/gitlab/-/commit/42623a62be2315ad601e1fb88f314a29c649a7b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156540))
- [Add and backfill namespace_id for vulnerability_finding_signatures](https://gitlab.com/gitlab-org/gitlab/-/commit/0586512f2b76761a30f551a508e1ff7738c071d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156794))
- [Add post_migrate to remove invalid record](https://gitlab.com/gitlab-org/gitlab/-/commit/1107cd52bf22de3fcd2e7cb1f400d858b136217e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156518)) **GitLab Enterprise Edition**
- [Remove default values ci_pipeline_messages#partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ea6d8bc0acb8e1f4866d08738c8fdb219cd0f94f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155397))
- [Drop merge_requests_closing_issues.closes_work_item column](https://gitlab.com/gitlab-org/gitlab/-/commit/9f920558b3a917d2775a608f75864ec666893f17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156677))
- [Resolve Layout/ArgumentAlignment offenses 88](https://gitlab.com/gitlab-org/gitlab/-/commit/6f30b452ccb6c137340cf5d4694f5c71f680b631) by @gauravmarwal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151289))
- [Add a new model that will handle abuse report notes](https://gitlab.com/gitlab-org/gitlab/-/commit/33f329bec6779bb8a50f6aac28e4859483e973ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156146))
- [Add and backfill project_id for protected_tag_create_access_levels](https://gitlab.com/gitlab-org/gitlab/-/commit/35ec77d7d15cb131bde663ac124c5e9e5cc7326a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156637))
- [Add and backfill project_id for vulnerability_findings_remediations](https://gitlab.com/gitlab-org/gitlab/-/commit/a03c4ff338e3aaa2cf601301d9058a5d3a427256) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156634))
- [refactor: Remove rubocop issues](https://gitlab.com/gitlab-org/gitlab/-/commit/dba1531363d33bef26bed333ffb28507dbbab9a4) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154189))
- [Change catalog resource last 30-day count updated_at](https://gitlab.com/gitlab-org/gitlab/-/commit/91194027ef72015493c3c8288506a333683c9bdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156575))
- [Finalize BackfillPartitionIdCiPipelineMessage](https://gitlab.com/gitlab-org/gitlab/-/commit/d2591c0ed7caa0e5bfc012eb5b9859a7afe8d4b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155219))
- [Protected packages: Shorten GraphQL field `protectionRuleExists` Part 3](https://gitlab.com/gitlab-org/gitlab/-/commit/13e610a4c2437d24597338829f43b5fcfd1c9217) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152376))
- [Add and backfill project_id for vulnerability_flags](https://gitlab.com/gitlab-org/gitlab/-/commit/a5d8dae907e70bee6d66d67a2c55eef3e4a04fce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156323))
- [Add and backfill project_id for merge_request_context_commits](https://gitlab.com/gitlab-org/gitlab/-/commit/b1860549c3328b6c864c99ad1f952297e18ca643) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156255))
- [Add and backfill namespace_id for issue_links](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c9b0f5fe1c316a51b209a8f0679de24c52bc2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156257))
- [Add and backfill group_id for related_epic_links](https://gitlab.com/gitlab-org/gitlab/-/commit/69d1111d555041a6d3b1086b5cbdaae119c2d33c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156251))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f1913e6a3bfa16d996c053073e3b3dca2fb5ff1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155940))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/121d4e81b497b6795650aef58122a92222d91894) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155349))
- [Remove "use_remote_mirror_destroy_service" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/74e1e921d003960afd6f259384aee2dfec18f30e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155852))
- [Protected containers: Cleanup renaming of protected_up_to_access_level](https://gitlab.com/gitlab-org/gitlab/-/commit/4606b5ef64f75acdd581258a0b93034195626e83) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146177))

## 17.1.8 (2024-09-16)

No changes.

## 17.1.7 (2024-09-11)

### Fixed (2 changes)

- [Fix Sidekiq crashing when GITLAB_LOG_LEVEL set to debug](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1647a587baa81d368cbc3d566598707cb590f430)
- [Backport Fixes Geo Replication Details view](https://gitlab.com/gitlab-org/security/gitlab/-/commit/08ed4596fbd90d9a75f1223d864eaf4e137bfaba) **GitLab Enterprise Edition**

### Changed (1 change)

- [Add callout in the admin area about OpenSSL v3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/03c10c261c9a8e9fee2e5d27a76d187c36ba5104)

### Security (18 changes)

- [Revert 'security-psk-fix-external-wiki-integration-dos-17-1' into '17-1"](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ade7fc8bea4032ca5bb532672efcd5a4dec3d6e8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4455))
- [Fix the vulnerability in the glm_source parameter](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b4e1ecff528c075bb8fe89c83700673f52cc1eb4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4434))
- [Improve GraphQL log security](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8234ed61fa7f5bd4da874b9c390d86dd36de7ad1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4350))
- [Add permissions check to project creations from a project template](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d0c8dcecec6c0b1fad95755c2ea5b781680ceb66) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4445))
- [Fix credentials disclosure in mirroring failure](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e616eef4f91e39d3d98ec1535d7f9bef3a9a0e10) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4448))
- [Redirect url in the link validated for being external](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e358f0c4fadb53715fbe2d5dc031e071193c971c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4442))
- [[17.1] Update edit permissions for DAST profiles](https://gitlab.com/gitlab-org/security/gitlab/-/commit/428ec2f74d1bea5bdcdcac1c8f636a6d800f1441) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4357))
- [Commit information visible through release atom endpoint for guest users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6745cd87ea94fb0f0da8693c1ca1908f13593c89) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4439))
- [Execute environment stop actions as the owner of the action](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ff8085ff4f2fd49cf8c6ae205ee0c31349e970c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4406))
- [Prevent code injection in Product Analytics funnels YAML](https://gitlab.com/gitlab-org/security/gitlab/-/commit/225aa66cd4086800aac24a31dfdcc067f7fc978a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4429))
- [Prevent users with admin_group_member custom ab. to manage custom roles](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9c6ad85f4a22c95d86352da8e15e6bd85de33bf2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4427))
- [Fixed frontend regex to parse URI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ee3b0c7e86cd1f2d11decd28e970e9588cb4c2c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4421))
- [Use session instead of params for identity linking](https://gitlab.com/gitlab-org/security/gitlab/-/commit/850650bb443ff41b49c8ec6e0aa732c0d12f4562) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4371))
- [Fix external wiki integration DoS by changing request to HEAD](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ae880e3a6bef6e520ebf5f41e2b0965791dd199) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4383))
- [Restrict IPs for packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ea51fb0d0c37d54fd5c3aa797327d1149084d01) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4389))
- [Strip out Set-Cookie header from dependencyproxy auth response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1a1859fb40667b0414fe2456885765f57066a073) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4397))
- [Fix open redirect due to additional slash added](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ced539e3fd51cf1bdf136cdceb520af90229e1fa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4353))
- [Group Developers can view group runners](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3e22e9791084827757da7c990c40992a330f8adf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4380))

## 17.1.6 (2024-08-21)

### Security (1 change)

- [Always build assets image when tagging](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b10a04aa687e6fbdf6c26b5756dcbb3748728e9a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4385))

## 17.1.5 (2024-08-20)

### Fixed (1 change)

- [Properly handle empty repository.ff_merge in FromTrainRef merge strategy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b3fa341da06a3cbec69e2c32c5b3a336fcba6df7) **GitLab Enterprise Edition**

### Changed (1 change)

- [Include language server version in code suggestions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/02b9f967f7f68865d6dfcfd550e9967689239791) **GitLab Enterprise Edition**

### Security (4 changes)

- [Do not run pipelines when resolving vulnerability](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b962ee1ac8f2ab653435937008c5c4d869aa17f8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4308))
- [Add Octokit::ResponseValidation middleware](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f0483d356530afafa070302e50f34a12634b28a8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4377))
- [IP restriction to prevent all group permissions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/aecd6dd35b1bfd45d1cb7442afc9a9bf312310b6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4341))
- [Destroy associated releases when removing a tag via Git CLI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7478a869a7a2722377da289a6b16d77b608ccfc2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4367))

## 17.1.4 (2024-08-06)

### Changed (2 changes)

- [Reverify externally verified gpg keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e11bfa6bdfcf0b40f440bf50e104d5d4e4496d74)
- [Put groups_direct field in CI JWT tokens behind feature flag](https://gitlab.com/gitlab-org/security/gitlab/-/commit/024945347ea0b433de65c0ecb80c50cc031cbc52)

### Security (13 changes)

- [Show correct file content](https://gitlab.com/gitlab-org/security/gitlab/-/commit/59df2cc3758c03aff024151f5dfd59fa3263ac7b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4335))
- [Fix Possible asciidoctor include:: directive DOS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6fcbfba6119fcadff61dc4550d244b56f5fe6c70) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4330))
- [Filter parameters in Rack::Attack logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9b807312a2029e6a341962591dcdcfd21ea8ef0c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4273))
- [Update audit payload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7beb230f12ec6270523a269dad39dba42fdc108e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4326))
- [Limit access to project accessed by Security Policy Bot](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b58cad5e32c2b9f399742719006a4e527f773e2d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4344))
- [Show alert about not rendering files due to path encoding](https://gitlab.com/gitlab-org/security/gitlab/-/commit/274a7177f5eea11e258534e5155f878334bf48ca) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4338))
- [Fix the catastrophic backtracking](https://gitlab.com/gitlab-org/security/gitlab/-/commit/88e2d71de74d04e29a8a62527bb147208c86fc29) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4290))
- [Security fixes for banzai pipeline part 2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8167c0e9225c5893043ea34bfc1353035f173924) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4282))
- [Remove xhtml extensions from snippets blobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ba1a3f5a36820995e512b4ec846d57df54ed9c4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4301))
- [Add a project scope to LfsTokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9e684758e31af25bdb69a8d4f95e8e0821bfc40b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4320))
- [Fix ReDoS when parsing git push options](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f49a979105bdfd365738d42406e94f7cabba4601) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4313))
- [Fix ReDoS in RefMatcher](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ec18bbdcb19f831d3732e2ffebe87740982baf24) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4316))
- [Enforce `require_password_to_approve` MR approval policy property](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d9769f6d7a11c2ae23f8816483358f7da3e729be) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4260))

## 17.1.3 (2024-07-24)

### Fixed (2 changes)

- [Fix wildcard search for package.json in npm upload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f319a2257eca7ef742367b9b4636645ad4781ea2)
- [Ignore object pool already exists creation errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/01c080264ccb25ec17c04eeb470014389a916cfa)

### Security (7 changes)

- [Refactor import_export_upload to be user-based](https://gitlab.com/gitlab-org/security/gitlab/-/commit/70145f096f59d1729df3f0e1244a039c6e14f0b7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4264))
- [Fix for private txt artifacts being accessible through the artifacts/browse link](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8889c5c795eb2bd19b1bbcf7e05050c009843f82) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4293))
- [Attribute BulkImport::Export to a particular user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/68eb8994474a9b0fdd15d03ae2f0a75a61eecd1f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4285))
- [Don't include project-level analytics settings in DOM](https://gitlab.com/gitlab-org/security/gitlab/-/commit/caf6a3a26a0bedfc309f8ba45bea605fc37e70f7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4185))
- [Fix for private dotenv artifacts not accessible to downstream jobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ed6d149e28b4c8aafe36d6c6ff2824e1d459c651) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4242))
- [Do not allow script execution on dependency responses](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f412b11cacce187d0d7c463fdba0a3c1d4d378ad) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4254))
- [Remove prohibited tags after import](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fda79ce08be8700a75eadaf9641e1ee00b0d92ec) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4249))

## 17.1.2 (2024-07-09)

### Fixed (2 changes)

- [Update dependency slack-messenger to v2.3.5](gitlab-org/security/gitlab@e21a4599ab21cc6f6b89ca432d9557ed72169c85)
- [Fix MailRoom not loading in Omnibus](gitlab-org/security/gitlab@5547c1164c494705bf29595062124ff8cb266cb3)

### Security (9 changes)

- [Disallow serving Pages over disabled custom domains with deployments](gitlab-org/security/gitlab@176442d616a111667481f22186560925d1175c67) ([merge request](gitlab-org/security/gitlab!4245))
- [Check npm package name, version and scripts coherence](gitlab-org/security/gitlab@917d805ce57e5d0439b4a4c757967d494014a97d) ([merge request](gitlab-org/security/gitlab!4212))
- [Check for create_deploy_token policy before creating deploy token](gitlab-org/security/gitlab@8ae4e9b0b25bec92561698da3c7d0495d6ba61bc) ([merge request](gitlab-org/security/gitlab!4209))
- [Check if user has ban_group_member access before banning in namespace](gitlab-org/security/gitlab@eefb608987d64b9cf58411b8520f260d1fb9b1c3) ([merge request](gitlab-org/security/gitlab!4091))
- [Prevent privilege escalation via custom role](gitlab-org/security/gitlab@a618e86dc4585b0fef049f75f13acf0eec00656d) ([merge request](gitlab-org/security/gitlab!4199))
- [Prevent using quick actions for some bot users](gitlab-org/security/gitlab@5789cc333d04d76ffb4c79239e71be1910f12229) ([merge request](gitlab-org/security/gitlab!4231))
- [Disable raw HTML for quick action pipeline](gitlab-org/security/gitlab@7db9b002b803cb6b53a3e6ce3f8d9b15107e7464) ([merge request](gitlab-org/security/gitlab!4235))
- [Disable quick actions unless description changed](gitlab-org/security/gitlab@a1800c591b38df0e2d143df3ee56f76b4f3a914f) ([merge request](gitlab-org/security/gitlab!4234))
- [Remove comment support from shrug and tableflip](gitlab-org/security/gitlab@fb6bcef1935dc3a7dd60def448a652769c86ee62) ([merge request](gitlab-org/security/gitlab!4229))

## 17.1.1 (2024-06-25)

### Fixed (1 change)

- [Only enumerate commits in pre-receive check if push came from Web](gitlab-org/security/gitlab@09fac947735945114db37b482035ffe8f605a1ad)

### Security (14 changes)

- [Security fixes for banzai pipeline](gitlab-org/security/gitlab@bb484256fab53f248450f49350d44ec246f05e49) ([merge request](gitlab-org/security/gitlab!4184))
- [Fix the catastrophic backtracking in openapi regex](gitlab-org/security/gitlab@d9f51d836d290fc90f6bbfd50937e28ac4382ad6) ([merge request](gitlab-org/security/gitlab!4135))
- [Use permitted_params for standalone and multiplex queries](gitlab-org/security/gitlab@624758559c2ffa452c7d118b4bf438783bf22b96) ([merge request](gitlab-org/security/gitlab!4173))
- [Fix for Private job artifacts can be accessed by any user](gitlab-org/security/gitlab@4c5ac0433595920d2e9e1a0887461fbf9ea58476) ([merge request](gitlab-org/security/gitlab!4194))
- [Remove search results from public projects with unauthorized repos](gitlab-org/security/gitlab@74bebdd2a20be50c13d3696b0cc2ba815fd9e95b) ([merge request](gitlab-org/security/gitlab!4210))
- [Do not run a new pipeline on re-target](gitlab-org/security/gitlab@0a90eb06107fce3a6c2e15dcead5ec9fc0302967) ([merge request](gitlab-org/security/gitlab!4187))
- [Add limits on autolinker regex](gitlab-org/security/gitlab@4854ff9db1ee52c37cab05d5be1eb02b4e5e93b0) ([merge request](gitlab-org/security/gitlab!4126))
- [Fix clickjacking on OAuth application page](gitlab-org/security/gitlab@3620cdabd780c08754f48df7a81b0ed41924f75e) ([merge request](gitlab-org/security/gitlab!4186))
- [Hide branch merge request if merge requests are private](gitlab-org/security/gitlab@551999ae405109144906d3b0fbd254553ba10baa) ([merge request](gitlab-org/security/gitlab!4200))
- [Remove collapseLongCommitList method](gitlab-org/security/gitlab@35a86b9d0cec107e06d56ced48ecbf5ac108250c) ([merge request](gitlab-org/security/gitlab!4203))
- [Pass SSO session data to Sidekiq](gitlab-org/security/gitlab@143598720f040450de58440be4266337278fb87f) ([merge request](gitlab-org/security/gitlab!4197))
- [Prevent non-members from using promote_to quick action for quick actions](gitlab-org/security/gitlab@ce44d723af3e7c117f56e1539da2c12ee1892b90) ([merge request](gitlab-org/security/gitlab!4190))
- [Reject deletion of security policy project approval rules](gitlab-org/security/gitlab@926855938a4a92251b0631b67cad330888e17909) ([merge request](gitlab-org/security/gitlab!4172))
- [Mitigate ReDoS attacks via `method_call_regex`](gitlab-org/security/gitlab@350aa934a38aa9aae0b4216dcaa51e6a17463e4e) ([merge request](gitlab-org/security/gitlab!4174))

## 17.1.0 (2024-06-19)

### Added (180 changes)

- [Allow `admin_runner` ability to change shared runner setting](gitlab-org/gitlab@f8a4a504e3b04875bed19bdef66f7cdcaae7e462) ([merge request](gitlab-org/gitlab!155505)) **GitLab Enterprise Edition**
- [Update services to create custom software license](gitlab-org/gitlab@fef112e156bf0f37f8b1dbd310cd2a2ddc629eb2) ([merge request](gitlab-org/gitlab!155325)) **GitLab Enterprise Edition**
- [Protected containers: Add help text for repository path pattern input](gitlab-org/gitlab@e710daa4b59d0ae74d608490c1cd563437c4ca74) by @gerardo-navarro ([merge request](gitlab-org/gitlab!154932))
- [Move document for CS for registry](gitlab-org/gitlab@06d2a6d2b6cdcb7cffd7ffc81b0706485d5967c2) ([merge request](gitlab-org/gitlab!156259)) **GitLab Enterprise Edition**
- [Add new duo pro discover page](gitlab-org/gitlab@ca64b696dbd33b8cddcd1f887d31afb4290853bf) ([merge request](gitlab-org/gitlab!154478)) **GitLab Enterprise Edition**
- [Changed association of frameworks with projects](gitlab-org/gitlab@ecaf61939432fe08eb7fa8fe48925d04c4685a68) ([merge request](gitlab-org/gitlab!153664)) **GitLab Enterprise Edition**
- [Add support for new placeholders](gitlab-org/gitlab@679bf3a203e041300daf200de432c81d70062b72) by @TamsilAmani ([merge request](gitlab-org/gitlab!155804))
- [Add `admin_runners` custom ability](gitlab-org/gitlab@860f5cc09eca6679d90184fd33a855086f31ac4e) ([merge request](gitlab-org/gitlab!154848)) **GitLab Enterprise Edition**
- [Add worker to aggregate last 30-day catalog resource usage data](gitlab-org/gitlab@56f45cfdc1fa3a94f0e850d54970ac3936ca622a) ([merge request](gitlab-org/gitlab!155001))
- [Add cargo to supported sbom and sync types](gitlab-org/gitlab@11d3dfa2c8385a1d9400b9522d75047735630f4b) ([merge request](gitlab-org/gitlab!155751))
- [Add project settings sections to command mode results](gitlab-org/gitlab@e3d6d8a451ec86581cf04ad24eda35cdd63dbb49) ([merge request](gitlab-org/gitlab!153452))
- [Configuring Topology Service in Rails](gitlab-org/gitlab@8a21caa58fbbbba98451e729f4ed4c3163d0b685) ([merge request](gitlab-org/gitlab!154960))
- [Add ML Model filters to the "package files" screen](gitlab-org/gitlab@24693cd19d01cf068d1583ecaaaafa7b3a435332) ([merge request](gitlab-org/gitlab!155979))
- [Include SAST Advanced in configuration UI allowlist](gitlab-org/gitlab@0f3e2a4bd3615d84560a16ed8135dff8e9f2a836) ([merge request](gitlab-org/gitlab!155008))
- [Group level work items support group level references](gitlab-org/gitlab@d1d21618d3a4b09505237af330d8503316b745f4) ([merge request](gitlab-org/gitlab!155637))
- [Add search in wiki sidebar](gitlab-org/gitlab@88a691503f1b92d90fd4783f677ed99af0763bbc) ([merge request](gitlab-org/gitlab!156054))
- [Render icons beside suggestions](gitlab-org/gitlab@264f9e3fd3578996a697ed8c93f33b77f050ba5c) ([merge request](gitlab-org/gitlab!155976))
- [Display temporary extension expiration banner](gitlab-org/gitlab@eb9ac6e66e76b5a9422c3780f0106300ad265bab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155634)) **GitLab Enterprise Edition**
- [Add logs header details](gitlab-org/gitlab@554fdb0265d264131c7423c02fbea7fa6f3586f6) ([merge request](gitlab-org/gitlab!155970))
- [Cleanup index terraform module archive FF](gitlab-org/gitlab@849296529460dd8dc1660398d4e40c6fc942926a) ([merge request](gitlab-org/gitlab!156156))
- [Create new custom Permission: read_crm_contact](gitlab-org/gitlab@13916c1997d7337fe282d739c33815a5e262c5db) by @ChaelCodes ([merge request](gitlab-org/gitlab!154017)) **GitLab Enterprise Edition**
- [Use custom models for duo chat features](gitlab-org/gitlab@bc3255cc5fb1c190fdd300f05b21bf426f5669aa) ([merge request](gitlab-org/gitlab!155849)) **GitLab Enterprise Edition**
- [Add ssh-upload-pack endpoint to handle Git over SSH requests](gitlab-org/gitlab@611a6b6eb9a1036748612d343b188b43c68212ac) ([merge request](gitlab-org/gitlab!152950)) **GitLab Enterprise Edition**
- [Add embedding reference and call it on condition](gitlab-org/gitlab@2afc4344343a7664884f2661f4b29427284324ca) ([merge request](gitlab-org/gitlab!154297)) **GitLab Enterprise Edition**
- [Add related issues to Merge Request API](gitlab-org/gitlab@d8e0674a01430f6aaf5fb55b3f8399ab72b054ad) by @zzaakiirr ([merge request](gitlab-org/gitlab!155422))
- [Add partition_id to Ci::Sources::Project](gitlab-org/gitlab@0e8c5e2d3c1274442b18c5ed74c92bd042c7afc7) ([merge request](gitlab-org/gitlab!153798))
- [Expose configuration in API and UI](gitlab-org/gitlab@20cf75de599c2310eef2d9acc648256931185a21) ([merge request](gitlab-org/gitlab!155791))
- [Filter projects by marked for deletion](gitlab-org/gitlab@221286e98b3f2649ae488259924449f7c3462990) by @imskr ([merge request](gitlab-org/gitlab!155006)) **GitLab Enterprise Edition**
- [Add urls to generated changelogs](gitlab-org/gitlab@5ecf224b05928c27a0d1497547c3b9d6bc3f85e1) by @Taucher2003 ([merge request](gitlab-org/gitlab!155806))
- [Add count field to WorkItemConnection](gitlab-org/gitlab@709210626b80013a6149ae2cb002a1f26b792d12) ([merge request](gitlab-org/gitlab!154951))
- [Progress bar & status to model artifact importer](gitlab-org/gitlab@0d73432f51793db73e1695439438f826a6ff80b7) ([merge request](gitlab-org/gitlab!154729))
- [Exposed note body first line on GraphQL](gitlab-org/gitlab@3931abe5e167f9e31daf214ba60178240a6d8f51) by @zillemarco ([merge request](gitlab-org/gitlab!148829))
- [Add external MR diffs to `gitlab-backup` task](gitlab-org/gitlab@7c1ce75666229ff0a84d92a8cc16c5644421af7c) by @zzaakiirr ([merge request](gitlab-org/gitlab!154914))
- [Add support for rendering icons](gitlab-org/gitlab@84feccba79c9f7d60376f82a25f8d4f926177af6) ([merge request](gitlab-org/gitlab!155244))
- [Add identifier_external_ids column to vulnerability_reads](gitlab-org/gitlab@314fadea6cce393c7634a01519af129a0141b130) ([merge request](gitlab-org/gitlab!153131))
- [Protected packages: Label "protected" for package detail page on group](gitlab-org/gitlab@3573a068ed23fb94efb28bfeb38d93c40cc399a8) by @gerardo-navarro ([merge request](gitlab-org/gitlab!154811))
- [Clean up duo_chat_display_source feature flag](gitlab-org/gitlab@2baf06a40fae34cdbcd0a7e4150ed5f831fe75ec) ([merge request](gitlab-org/gitlab!155863)) **GitLab Enterprise Edition**
- [Adds sort by publish date for container registry tags list](gitlab-org/gitlab@8407cb55de456ee43f57f84e2b84b9e95ccf650d) ([merge request](gitlab-org/gitlab!153383))
- [GraphQL changes to fetch vulnerability severities count with limits](gitlab-org/gitlab@a950ea5d8a4226b1f07486deba823ee486fb2b55) ([merge request](gitlab-org/gitlab!155452)) **GitLab Enterprise Edition**
- [Allow actor override when GitHub and BBS disabled](gitlab-org/gitlab@01943ffd96aa3cc132bc3114f80f1e776b0b42d7) ([merge request](gitlab-org/gitlab!155796))
- [Early access program participation checkbox](gitlab-org/gitlab@ecf2c7dbf650100803a4b70e1549659ac59dfebd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154957)) **GitLab Enterprise Edition**
- [Add approval_policy_rule_id to approval rules and related tables](gitlab-org/gitlab@e4451d35b8f3f77dcfa72f6af0ed4991064591fe) ([merge request](gitlab-org/gitlab!155232))
- [Add organization to vuln export for sharding](gitlab-org/gitlab@2fbe359eb14671f2a7abf62da760ea11ad91ab9b) ([merge request](gitlab-org/gitlab!154994)) **GitLab Enterprise Edition**
- [Add verified creator badge](gitlab-org/gitlab@c56408a830bc0f765d2340a64d38dc6d6c07bedc) ([merge request](gitlab-org/gitlab!154179))
- [Protected packages: REST API GET package protection rules](gitlab-org/gitlab@8484e6af92d8e4e994c0f1bbb6b66dfa30c1d395) by @nwittstruck ([merge request](gitlab-org/gitlab!153436))
- [Improves empty state on model registry model page](gitlab-org/gitlab@4783ee0070324bb2e3d06df0af3aaf447cfac061) ([merge request](gitlab-org/gitlab!155399))
- [Add star count as sorting option for CICD Catalog](gitlab-org/gitlab@1253250db1b70012b8c122792cb16ca49916ea89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155240))
- [Validate form input for version and model name](gitlab-org/gitlab@072d8c889ad57c1dee9feed9131488d307db5a62) ([merge request](gitlab-org/gitlab!154728))
- [Create partitions for new audit event tables](gitlab-org/gitlab@336efc87b0d0de1fc68a4de318bd471e313ff49c) ([merge request](gitlab-org/gitlab!154418))
- [Add support for Redis extra config command to ActionCable](gitlab-org/gitlab@9ace9e8f59a9dfcd6fe01ff87321e5196e87da44) ([merge request](gitlab-org/gitlab!155546))
- [Filter projects by marked for deletion](gitlab-org/gitlab@67543b86542d6e3216c4c06a22cf48303c14b6d8) by @imskr ([merge request](gitlab-org/gitlab!154770)) **GitLab Enterprise Edition**
- [Allow selecting project for project level items](gitlab-org/gitlab@1c81a23f21b51453283f1c9b3e8076ca5877385f) ([merge request](gitlab-org/gitlab!154554))
- [Protected containers: Update protection rules in project settings ui](gitlab-org/gitlab@dc31dfc0a71cf69ffbf5de4a14cde87fca60c60b) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146623))
- [Handle declined event for bitbucket server importer](gitlab-org/gitlab@241112be0455dc585ee9f7469c30cdaec754a27c) by @ivantedja ([merge request](gitlab-org/gitlab!153298))
- [Adding gcp audit event destination validator](gitlab-org/gitlab@b01fbc9f6cd3d983187f1868f373528efa4c24c1) ([merge request](gitlab-org/gitlab!151662)) **GitLab Enterprise Edition**
- [Add pmg README.md](gitlab-org/gitlab@124334406446c27fdbb9364fe783763bdbc05a09) ([merge request](gitlab-org/gitlab!154964))
- [Add `admin_runners` custom ability](gitlab-org/gitlab@ab0cebe39ec53f99633c09016691e4dfe80f9bf1) ([merge request](gitlab-org/gitlab!151825)) **GitLab Enterprise Edition**
- [Add support for Sentinel usernames in Workhorse](gitlab-org/gitlab@c2da33720ce47d4c13912dbd5acb818640b5577f) ([merge request](gitlab-org/gitlab!155209))
- [Default enable diff_preview_in_email](gitlab-org/gitlab@20ab134ba94807467a25a1b22f30810e3ef6a81d) ([merge request](gitlab-org/gitlab!155143))
- [Add CVS for CS document](gitlab-org/gitlab@bef3d803b03bc7769324fb5402b554d4c07635b5) ([merge request](gitlab-org/gitlab!154388)) **GitLab Enterprise Edition**
- [Add security policies projects join table](gitlab-org/gitlab@6825da6e2ee80412084ccdb101913f7fb23a2b41) ([merge request](gitlab-org/gitlab!154742)) **GitLab Enterprise Edition**
- [Display timestamp in log lines](gitlab-org/gitlab@5d79019ee98f65a69c3b450eee09edd605fa616a) ([merge request](gitlab-org/gitlab!153851))
- [GraphQL: Add fullPath argument in runnerUsage query](gitlab-org/gitlab@b6cd9a3a27c3b2fec6dcb07896a671e0bb57d702) ([merge request](gitlab-org/gitlab!154462)) **GitLab Enterprise Edition**
- [Add sorting by `component_name` to dependency list aggregations](gitlab-org/gitlab@1d5d98f41ded8c8695be033c527821af1df6352e) ([merge request](gitlab-org/gitlab!154779))
- [Backfill work_item_dates_sources with epic dates data](gitlab-org/gitlab@3ab4c15e1db9a58e3ff5d820522a52e1b1e3120e) ([merge request](gitlab-org/gitlab!153115))
- [Add confirmation message on manual job with confirmation message](gitlab-org/gitlab@12525d358bc5a60f27d37706a4f245f59473a4f9) by @lifez ([merge request](gitlab-org/gitlab!151978))
- [Remove `repository_tree_gitaly_pagination` feature flag](gitlab-org/gitlab@f5b4a1f811fd1934d01a7e061003acec3ebeed40) ([merge request](gitlab-org/gitlab!154897))
- [Add source code to `/explain_vulnerability` tool](gitlab-org/gitlab@58410808e409f920d6c66cb1792797b86aed8148) ([merge request](gitlab-org/gitlab!154229)) **GitLab Enterprise Edition**
- [Add Restore Pages Deployment Mutation](gitlab-org/gitlab@1bdb5dafc0520d68a7241daa73206e0077915697) ([merge request](gitlab-org/gitlab!155283))
- [Enable integration API for admin integrations custom ability](gitlab-org/gitlab@59b0d3b699233ffd876fcec058cdfc1cd48b5a38) ([merge request](gitlab-org/gitlab!155228)) **GitLab Enterprise Edition**
- [Add PagesDeployment to deletePagesDeployment Mutation](gitlab-org/gitlab@40b7b2c8032e23248d86a0e18acc21c256028c1f) ([merge request](gitlab-org/gitlab!154399))
- [Adjust the mistral promprt for 22b](gitlab-org/gitlab@d35b60b18f3a4f0ea8c74668793f91639bd8c2d1) ([merge request](gitlab-org/gitlab!155083)) **GitLab Enterprise Edition**
- [GraphQL: Add fullPath argument in runnerUsageByProject query](gitlab-org/gitlab@4f0a1f7665f753c34de10ce7a54b97ce2865f964) ([merge request](gitlab-org/gitlab!154300)) **GitLab Enterprise Edition**
- [Filter by marked_for_deletion_on in groups graphql](gitlab-org/gitlab@3b56b2acdfb4869b30d89c0f9c9f3b0bcbbe19a3) by @imskr ([merge request](gitlab-org/gitlab!154846)) **GitLab Enterprise Edition**
- [Add support for latest_tag](gitlab-org/gitlab@d3791921420e3c253d1ff2dd0d0cf01a2c0727e0) by @TamsilAmani ([merge request](gitlab-org/gitlab!153525))
- [Add PagesDeployments to Project type](gitlab-org/gitlab@0c67d1f5687e11869370a0497d861e2a53d66e13) ([merge request](gitlab-org/gitlab!154104))
- [Enable show_container_registry_tag_signatures feature flag by default](gitlab-org/gitlab@3d600c9a74c75d04257f2ff4baa6d49d8b5b5b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154706)) **GitLab Enterprise Edition**
- [Add admin integrations custom permission](gitlab-org/gitlab@431c9f7392b282686470ef6e1073d7df62c28348) ([merge request](gitlab-org/gitlab!154601)) **GitLab Enterprise Edition**
- [Improve observability by various Git LFS metrics](gitlab-org/gitlab@06350c606ddc8303d2bd0244754cb65ed9933b57) ([merge request](gitlab-org/gitlab!138920))
- [Add GraphQL mutation `projectTextReplace`](gitlab-org/gitlab@f2333f5e6f370301c64d43687e98209789a6e47a) ([merge request](gitlab-org/gitlab!152522))
- [Adds published message for each container registry image repository](gitlab-org/gitlab@a88eac528860f927001ae47d448a1e15c1585f5d) ([merge request](gitlab-org/gitlab!153947))
- [Create separate elastic queue for embeddings](gitlab-org/gitlab@5bd81d3a7449d90ddd43b86d272e80be45b1be3a) ([merge request](gitlab-org/gitlab!154269)) **GitLab Enterprise Edition**
- [Log token info for GraphQL requests](gitlab-org/gitlab@88608f725c17dc6b6a6a50c34ccab16682e3f83a) ([merge request](gitlab-org/gitlab!148885))
- [Add Limit for CVS for CS](gitlab-org/gitlab@b7bfbd0fcc31f7dfd6a879397c3b775199db47c5) ([merge request](gitlab-org/gitlab!154925)) **GitLab Enterprise Edition**
- [Add a new task initial_indexing for Zoekt::SchedulingService](gitlab-org/gitlab@454840f907735112f685d26f9e58244b8cb52298) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149365)) **GitLab Enterprise Edition**
- [Add option to add custom html header tags via gitlab.yml config](gitlab-org/gitlab@8136229ad7f3e95f5ba0e924c8d636a94e2f10b7) by @bufferoverflow ([merge request](gitlab-org/gitlab!153877))
- [Add support for custom headers in webhook API](gitlab-org/gitlab@b79f616bd307b73f6b7cf704a68d4fb6854de85e) by @Taucher2003 ([merge request](gitlab-org/gitlab!153768))
- [Audit when product analytics settings are changed](gitlab-org/gitlab@a454e70e03308842f62cac378442f52032aa471e) ([merge request](gitlab-org/gitlab!154407)) **GitLab Enterprise Edition**
- [Protected packages: REST API DELETE package protection rules](gitlab-org/gitlab@8d65804581cb692c0518710479ba6761675b6962) by @nwittstruck ([merge request](gitlab-org/gitlab!151741))
- [Remove single_relation_import feature flag](gitlab-org/gitlab@83284db7430c50671d129d86399fe5cadbc6c5b3) ([merge request](gitlab-org/gitlab!154786))
- [Add audit event for web hook creation](gitlab-org/gitlab@8f564e9ef7df4c1685427b14d88bb751cf10f3ea) ([merge request](gitlab-org/gitlab!154046)) **GitLab Enterprise Edition**
- [Include custom role name in members exports](gitlab-org/gitlab@c08cfd868522426fa79069629fdeb11d2d6539ca) ([merge request](gitlab-org/gitlab!153980)) **GitLab Enterprise Edition**
- [GraphQL: Add runnerManager field to CiJob](gitlab-org/gitlab@88c0a6d08afd20d2d7d55cdda7bba9750f7ce30a) ([merge request](gitlab-org/gitlab!154737))
- [GraphQL: Add managers field to CiRunner](gitlab-org/gitlab@5c4a13f5d02bf1157e20c0b50c2b658cac3ea06f) ([merge request](gitlab-org/gitlab!154737))
- [Add trigram indexes on email column](gitlab-org/gitlab@46ddd7a42253b6275a3ec55323268b1f567c8b62) by @zzaakiirr ([merge request](gitlab-org/gitlab!152249))
- [Add partition_id to Ci::PipelineMessage](gitlab-org/gitlab@6fe5f634263520dbd6e17a7bfd18377270303584) ([merge request](gitlab-org/gitlab!153391))
- [Backfilling of work_item_parent_links from epics parent_id](gitlab-org/gitlab@98cc1d3cf0561a1154474ee775464418057c228d) ([merge request](gitlab-org/gitlab!153442))
- [Introduce ci_pipeline_variables_minimum_role](gitlab-org/gitlab@79bc51d82b86ae8d000ae947f322d90e3cdb95e3) ([merge request](gitlab-org/gitlab!149343))
- [Finalize BackfillPartitionIdCiDailyBuildGroupReportResult](gitlab-org/gitlab@104bbe7723a86a12c1cdde48b9172ed64a3ca155) ([merge request](gitlab-org/gitlab!154530))
- [Created blueprint for pipeline mini graph](gitlab-org/gitlab@012b8a80f6938465068c80b8f087fb6a736def19) ([merge request](gitlab-org/gitlab!154313))
- [Add explain vulnerability tool](gitlab-org/gitlab@b614184ad6abafe8abeb5a91602851b554fe329f) ([merge request](gitlab-org/gitlab!153961)) **GitLab Enterprise Edition**
- [Add a cleanup worker for removable add-on purchases](gitlab-org/gitlab@9d37fe4c8cef6105530e1df74b82bd4fe6824863) ([merge request](gitlab-org/gitlab!153713)) **GitLab Enterprise Edition**
- [Add WorkItemAddClosingMergeRequest mutation to GQL API](gitlab-org/gitlab@465160c7a5d46bcb02b5559271a6723928cdc421) ([merge request](gitlab-org/gitlab!153775))
- [Audit when product analytics settings are changed](gitlab-org/gitlab@73f397b384a1bfacfd59881c63b1c1620e52d681) ([merge request](gitlab-org/gitlab!154101)) **GitLab Enterprise Edition**
- [Filter groups by marked_for_deletion_on](gitlab-org/gitlab@d80f9c8f2c163b494aba80c538eb177ac28c7f51) by @imskr ([merge request](gitlab-org/gitlab!153873))
- [Add spec for the `handleClusterError` helper](gitlab-org/gitlab@6ef18cfafcbe9639268cafd5a1d55c5d990641cb) by @antonkalmykov ([merge request](gitlab-org/gitlab!153695))
- [Add resolver for product analytics project settings](gitlab-org/gitlab@5438f948a050c210c76c6db3f05503ee1e81cacf) ([merge request](gitlab-org/gitlab!153796)) **GitLab Enterprise Edition**
- [Update doc for single_relation_import flag status](gitlab-org/gitlab@40bd6a923bf53e323fd504e496c223355172ce4c) ([merge request](gitlab-org/gitlab!154355))
- [Add API-Security CI template](gitlab-org/gitlab@99592285a6f1ebd35b0d69c6552c51472c6b0b73) ([merge request](gitlab-org/gitlab!147183)) **GitLab Enterprise Edition**
- [Add index for sorting by highest severity](gitlab-org/gitlab@851c61ebf39e810ff0492a21eeb18bb57dc2d438) ([merge request](gitlab-org/gitlab!154054))
- [Add projects dropdown to work_item_links_form component](gitlab-org/gitlab@b4756440354deb6f9e79cd5d9cfb548e77bae441) ([merge request](gitlab-org/gitlab!150711))
- [Adds support for dynamic schemas with date range filters](gitlab-org/gitlab@817e8cf030cf3ef3278358bf8ff27744f2d79bce) ([merge request](gitlab-org/gitlab!153803)) **GitLab Enterprise Edition**
- [Include none argument owasp_top_10 filter](gitlab-org/gitlab@645e4bdf8aa332295772c60b2069f7cd9fd11c5e) ([merge request](gitlab-org/gitlab!146344)) **GitLab Enterprise Edition**
- [Filter the pods list be clicking at the pod stat](gitlab-org/gitlab@2e693cad136692c44abb569ab1d636b896e1e0a4) ([merge request](gitlab-org/gitlab!153467))
- [feature: Create a new model and version and upload artifacts](gitlab-org/gitlab@309031660104fdd77caafa9cf677c59a520113fa) ([merge request](gitlab-org/gitlab!154079))
- [Send configured API key to AI Gateway](gitlab-org/gitlab@68efd36fba9d4ee9d0d0a35cda4970f8cc0ddcb4) ([merge request](gitlab-org/gitlab!154231)) **GitLab Enterprise Edition**
- [Adds a mergeTrainIndex field to merge requests](gitlab-org/gitlab@4670104daf3a94f5f633382a27fd5d35fa4b91fb) ([merge request](gitlab-org/gitlab!153954)) **GitLab Enterprise Edition**
- [Introduce data source for overtime DORA metrics](gitlab-org/gitlab@c066a28049d3a143731288d591422e923d67f1ca) ([merge request](gitlab-org/gitlab!151885)) **GitLab Enterprise Edition**
- [Add partition_id to Ci::DailyBuildGroupReportResult](gitlab-org/gitlab@58276af81f68f248d075c2bf7ebe00797d078dc0) ([merge request](gitlab-org/gitlab!153236))
- [feature: Create new model version & import artifacts](gitlab-org/gitlab@e82a775276ce13e7b391ec7d5d23ba97de92c265) ([merge request](gitlab-org/gitlab!153522))
- [Adds last_activity_on to Members table](gitlab-org/gitlab@e1b1e2b8040969b5dfa4045e3ed73f707a90d527) ([merge request](gitlab-org/gitlab!153593))
- [Add capability to support error codes on Duo Chat backend](gitlab-org/gitlab@5868366e912c8839b6e89eab7236d6598d0f7e7a) ([merge request](gitlab-org/gitlab!152698)) **GitLab Enterprise Edition**
- [[Feature Flag] Cleans up large_ipynb_diffs](gitlab-org/gitlab@3adb923bcfed405c73e06d4737d23d3837863138) ([merge request](gitlab-org/gitlab!153689))
- [Backfill related epic links to issue links](gitlab-org/gitlab@2f4c73943e238d510a7208805e104c29775dbc84) ([merge request](gitlab-org/gitlab!152104))
- [Add security policy scheduled scans concurrency limit](gitlab-org/gitlab@74f4cd3b72a9513dc9e83ccc1a402447889c37d6) ([merge request](gitlab-org/gitlab!152855)) **GitLab Enterprise Edition**
- [Add graphql mutation endpoint to run VerifyNamespaceService](gitlab-org/gitlab@4e7843e4a3c638fbfeee16d34ecae0ce239c005c) ([merge request](gitlab-org/gitlab!152641)) **GitLab Enterprise Edition**
- [Add not valid foreign key to namespaces.parent_id](gitlab-org/gitlab@6ec6f6754702c2d176d9e0b2dc68be92c5aed887) ([merge request](gitlab-org/gitlab!153402))
- [Expose Vulnerabilities::StateTransition ID in GraphQL](gitlab-org/gitlab@172cc775744f51be39ba655376a6624cd5687f63) ([merge request](gitlab-org/gitlab!153842)) **GitLab Enterprise Edition**
- [Extend label GraphQL search with field list](gitlab-org/gitlab@ab0e019723ef80c7d998cfc9c5f49e295236636f) ([merge request](gitlab-org/gitlab!152761))
- [Add GraphQL filters by deployments](gitlab-org/gitlab@45a20b939bb4e1389672d186c136756aee174019) ([merge request](gitlab-org/gitlab!153660))
- [Add migration helpers (un)prepare_partitioned_async_index](gitlab-org/gitlab@bb069b392968a3c4dac33faf06268e097334d205) ([merge request](gitlab-org/gitlab!153064))
- [Add calendar endpoint for PATs](gitlab-org/gitlab@50f6045b078f86cfc4eb2e6bfa4a4c59d2910df3) ([merge request](gitlab-org/gitlab!153093))
- [Audit event tables](gitlab-org/gitlab@5177e5e9c65c65fb45951b7c9f4581ea29b6acd7) ([merge request](gitlab-org/gitlab!152035))
- [Add two options to configure target availability check in API Security](gitlab-org/gitlab@e8a121c5710487ebecabfeb80be623918d5cdc8f) ([merge request](gitlab-org/gitlab!153779))
- [Add project level filter](gitlab-org/gitlab@d862de1e7165b2eeed22e23bc1b123ee2dcb5981) ([merge request](gitlab-org/gitlab!152045)) **GitLab Enterprise Edition**
- [Create a GraphQL query for contributed projects](gitlab-org/gitlab@185cc42e5719cb58e170dcaa3fd49b9df1f9fb2a) by @yasuk ([merge request](gitlab-org/gitlab!151979))
- [Simplify wiki print functionality](gitlab-org/gitlab@9f5c2958872c6711287aae891d84d3ee85138e7b) ([merge request](gitlab-org/gitlab!153419))
- [Create car type](gitlab-org/gitlab@a62aa62f755d94e2b24280d5eb5f872ea6fd0695) ([merge request](gitlab-org/gitlab!152742)) **GitLab Enterprise Edition**
- [Displays the last published date for container repository](gitlab-org/gitlab@49e76171e1f3c718a6f9cc7db9154f96c5be4062) ([merge request](gitlab-org/gitlab!153274))
- [Render solution html in vulnerability modal](gitlab-org/gitlab@7d338c61f33156ec51809afabb5f24f3ec5d2bf1) ([merge request](gitlab-org/gitlab!153361)) **GitLab Enterprise Edition**
- [Downscale pasted retina images](gitlab-org/gitlab@5dd91aa354b117e6ac278f6293846761b52d2f7c) ([merge request](gitlab-org/gitlab!153043))
- [Add delete_user ability to OrganizationUser permission type](gitlab-org/gitlab@ee2cac1ee9e17841f839afb5ed35e85eb894edbd) ([merge request](gitlab-org/gitlab!153555))
- [Add hand raise lead to the duo pro trial widget popover](gitlab-org/gitlab@a157f949ea97799ef1dd26501c997c885a134ccc) ([merge request](gitlab-org/gitlab!153487)) **GitLab Enterprise Edition**
- [Validate work item presence in epics](gitlab-org/gitlab@26c593853c2883f8098ca61c6d06f09c22102a6d) ([merge request](gitlab-org/gitlab!153157))
- [Add pipeline validator to check identity verification](gitlab-org/gitlab@6678989ee82cb945745a5383310f933252414f66) ([merge request](gitlab-org/gitlab!152126)) **GitLab Enterprise Edition**
- [Remove `google_cloud_support_feature_flag` feature flag](gitlab-org/gitlab@572e7c67c232fe10c2fb714b940ddf32da3f451d) ([merge request](gitlab-org/gitlab!150472))
- [Add Rake task to update project storage](gitlab-org/gitlab@5bd5027ac232ec002f4dd85a80b83cec8601c6a2) ([merge request](gitlab-org/gitlab!153008))
- [Update type of subscription_add_on_purchases started_at column](gitlab-org/gitlab@141350051e319f0783b7fc533d37b387f697eea6) ([merge request](gitlab-org/gitlab!153764)) **GitLab Enterprise Edition**
- [Add GraphQL mutation `projectBlobsRemove`](gitlab-org/gitlab@5bdc99962ad929a48581adeb7d57fa08de31a499) ([merge request](gitlab-org/gitlab!152642))
- [Add BulkImport cancel API for instance admins](gitlab-org/gitlab@f1db82fb4db620ce0cff4f3a9e2ff4277caaca48) ([merge request](gitlab-org/gitlab!153120))
- [Add AI telemetry endpoint](gitlab-org/gitlab@087ae82c5ed794c3998ee7d139002c36e22c82ee) ([merge request](gitlab-org/gitlab!152946)) **GitLab Enterprise Edition**
- [Allow adding members by username](gitlab-org/gitlab@71591d3636d7d7723279ea004e3c935535901155) by @imskr ([merge request](gitlab-org/gitlab!147080))
- [Trigger GraphQl subscription when WorkItem hierarchy change](gitlab-org/gitlab@e53f65c6d16149153e776b0203e1cafcf16c85a8) ([merge request](gitlab-org/gitlab!153136))
- [feature: Delete model version](gitlab-org/gitlab@d2c9a6f0b779dda4391b90d4f602a1ec6afaf66a) ([merge request](gitlab-org/gitlab!152990))
- [Sync unique index creation for ci_pipelines.partition_id](gitlab-org/gitlab@470b65ac74e0ffc15bf1860f1443d6cdece529c0) ([merge request](gitlab-org/gitlab!153552))
- [Create audit events when deployments are approved or rejected](gitlab-org/gitlab@c11dd26b758e87c4d499c837d92e03051cfe8fd0) ([merge request](gitlab-org/gitlab!153375)) **GitLab Enterprise Edition**
- [Upload artifacts to an existing machine learning model version](gitlab-org/gitlab@743cb89e24c3accf6b279212be06e16b9e4d4270) ([merge request](gitlab-org/gitlab!152163))
- [Support directory structure in generic package registry](gitlab-org/gitlab@6a5bc3a417492b9325002f59126a97636e7e049b) ([merge request](gitlab-org/gitlab!153449))
- [Add pipeline validator to check identity verification](gitlab-org/gitlab@3582f4ee00e267012ed38e95125a4d5decff0477) ([merge request](gitlab-org/gitlab!151834)) **GitLab Enterprise Edition**
- [Release Silent Admin Exports feature](gitlab-org/gitlab@17bbff63c91b522bc01176dbadff8a86d8e95922) ([merge request](gitlab-org/gitlab!153351))
- [Added the featureFlagEnabled query field](gitlab-org/gitlab@f57ff57353b028a1b391eb2fdaa2ac2ae3b0d377) ([merge request](gitlab-org/gitlab!152638))
- [Create migration to add started_at to subscription_add_on_purchases](gitlab-org/gitlab@5eaf2667c2091503a67589d067ab4e35221e3ccc) ([merge request](gitlab-org/gitlab!152857)) **GitLab Enterprise Edition**
- [Add new option to filter projects in GraphQL](gitlab-org/gitlab@9e9f0eff9f2a170dcfb656fefdb47bef65d0ae92) ([merge request](gitlab-org/gitlab!153271))
- [Zoekt: Add callback service](gitlab-org/gitlab@d3c0a5d97399709156998abbf80b3dcb2ee4cf2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150157)) **GitLab Enterprise Edition**
- [Use the zoekt_settings in the Admin settings](gitlab-org/gitlab@da21dcea9dac757ad1468291a0d9c1bb5b7821e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148378))
- [Sync funnels when config project changes](gitlab-org/gitlab@07af6dee57361be87446527ede83c34e193ed506) ([merge request](gitlab-org/gitlab!150683)) **GitLab Enterprise Edition**
- [Add X-Gitlab-Version to Cloud Connector headers](gitlab-org/gitlab@8794a28812ba1a97d8af3c2143afb0e3298a7ec1) ([merge request](gitlab-org/gitlab!153065)) **GitLab Enterprise Edition**
- [Run migrations in milestone order](gitlab-org/gitlab@b807a0bae611a0845279270ef22ceb4c8326dc9a) ([merge request](gitlab-org/gitlab!137190))
- [Skip audit event on download of export, if silent](gitlab-org/gitlab@9d1bcbe792437a9aab42f88b20eda9f12b032563) ([merge request](gitlab-org/gitlab!152143))
- [Redirect wiki pages on renaming them](gitlab-org/gitlab@0662fa5b075f175ef6887ad2e0b674df795e448d) ([merge request](gitlab-org/gitlab!150727))
- [Add GraphQL mutation for product analytics project settings](gitlab-org/gitlab@c2f5fc85778555fdb2d6df31eb2d0b7cc4f5f99b) ([merge request](gitlab-org/gitlab!152721)) **GitLab Enterprise Edition**
- [Add initial duo pro trial status popover](gitlab-org/gitlab@8ddbf9005549974956e875deb6ed3af4561015fd) ([merge request](gitlab-org/gitlab!152538)) **GitLab Enterprise Edition**
- [Feature to delete artifacts from a model version](gitlab-org/gitlab@ff055b026489c947176c129fb220f6ebdfff5e88) ([merge request](gitlab-org/gitlab!152606))
- [Add a new IndexingTaskWorker](gitlab-org/gitlab@4722385a497bdb40697f80c70ac97d051dc2ee98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150036)) **GitLab Enterprise Edition**
- [Adds custom API server support for Telegram](gitlab-org/gitlab@8209b308112d1e41764ccd8343999f04c78c1487) ([merge request](gitlab-org/gitlab!152732))
- [Backend code for self-hosted LLM server instance configuration](gitlab-org/gitlab@1820afec649761ec888dd257afe50b9b3e462278) ([merge request](gitlab-org/gitlab!151793))
- [Add API for trigger group test webhook](gitlab-org/gitlab@1714db7b9cc40438a1f5bf61bef07ce45d33e207) by @lifez ([merge request](gitlab-org/gitlab!150486)) **GitLab Enterprise Edition**
- [Prepare async index for ci_pipelines.partition_id related](gitlab-org/gitlab@450c40ebde30bd25a501f3411b024275f1f9f7b3) ([merge request](gitlab-org/gitlab!147860))
- [Add manage_merge_request_settings custom permission](gitlab-org/gitlab@0b75a9ad563f7299ad900dd1994933884f85a242) ([merge request](gitlab-org/gitlab!151586))
- [Add custom software licenses table](gitlab-org/gitlab@4e12e0027592cb573bc059c8b11c209edb781b4a) ([merge request](gitlab-org/gitlab!151445)) **GitLab Enterprise Edition**

### Fixed (191 changes)

- [Check email confirmation status of active users](gitlab-org/gitlab@88e6c6adf8eeb23deff848e277fcf964e5c4a19e) ([merge request](gitlab-org/gitlab!156560)) **GitLab Enterprise Edition**
- [Fix the multiple zoekt_tasks creation for delete_repo](gitlab-org/gitlab@2e5860e05b1fb33db1c9c6bf98e409c3b7c87b2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156125)) **GitLab Enterprise Edition**
- [Force UTF-8 encoding on CSV export files](gitlab-org/gitlab@b22570929ba99f81a8b41ee3b2483bbad86def4c) ([merge request](gitlab-org/gitlab!156517)) **GitLab Enterprise Edition**
- [Ensure Workhorse log writers are closed to avoid Goroutine leaks](gitlab-org/gitlab@c9e7fbb94dc18ac6f9a914635365d41ae55d3a86) ([merge request](gitlab-org/gitlab!156420))
- [Update replication troubleshooting snippets](gitlab-org/gitlab@20fbbbda36292eef3b43c73871ce113c015d4a12) ([merge request](gitlab-org/gitlab!150743)) **GitLab Enterprise Edition**
- [Fix fork badge always shown in pipelines page](gitlab-org/gitlab@e73c4239287c3965f7c1f29d2a26a7a83a962342) ([merge request](gitlab-org/gitlab!156315))
- [Increase JWT expiration from 1 to 10 mins](gitlab-org/gitlab@104ed976d1ae6e44203fb43978f5b007bddb837b) ([merge request](gitlab-org/gitlab!154474)) **GitLab Enterprise Edition**
- [Fixed issue with command palette shortcut](gitlab-org/gitlab@09f50f501f494b2610ed31c13e8b40eaeeb3d754) ([merge request](gitlab-org/gitlab!156012))
- [Remove performance bar from jira connect](gitlab-org/gitlab@73d317ba31738e90cd14be33337a16df77e43704) ([merge request](gitlab-org/gitlab!156277))
- [Update Bitbucket Cloud Importer to map users by uuid](gitlab-org/gitlab@2dc625018b7b2aa0f13149ea2ec7a7c375eef05d) ([merge request](gitlab-org/gitlab!156163))
- [Fix product analytics manager offering UI](gitlab-org/gitlab@9020ae165c484b5f48841e0e509afaa3c00a2dac) ([merge request](gitlab-org/gitlab!156150)) **GitLab Enterprise Edition**
- [Implement segmented vulnerability export mechanism for large groups](gitlab-org/gitlab@a720e41522551d635c9955f0d1d6cd97a6ec7ae9) ([merge request](gitlab-org/gitlab!152517)) **GitLab Enterprise Edition**
- [Create worker to store security reports by project](gitlab-org/gitlab@c96bdc59f4fe7918ae6478b7451cec44622038c6) ([merge request](gitlab-org/gitlab!151541)) **GitLab Enterprise Edition**
- [Work item hierarchy change system notes use full references](gitlab-org/gitlab@d7a15fce8d0d35a0f85ea99725194ddea6da37f5) ([merge request](gitlab-org/gitlab!156080))
- [Allow labels to be specified with absolute path](gitlab-org/gitlab@55070060010d998769cd88fbf846a025fd343f75) ([merge request](gitlab-org/gitlab!152100))
- [Change FF to beta and default enable](gitlab-org/gitlab@1768bc1509610026afe3e8984d82222c3de571b8) ([merge request](gitlab-org/gitlab!155730)) **GitLab Enterprise Edition**
- [Show wiki sidebar content in history and changes](gitlab-org/gitlab@bc1ae03799e9145e4c313bf426d11eceb1d5753d) ([merge request](gitlab-org/gitlab!156089))
- [Increase SQL query threashold on work_items test](gitlab-org/gitlab@fa205fed2286474be4372201e2dcf13bc0eb2ce2) ([merge request](gitlab-org/gitlab!156171))
- [MR widget: Fix alignment](gitlab-org/gitlab@ee9dd4a96fa755416656f82e14da94fcb8ab96fb) ([merge request](gitlab-org/gitlab!156137))
- [Wiki: Fix last edited author](gitlab-org/gitlab@3cee102f59fc2e9c1884e31bafc71f9572404aa2) ([merge request](gitlab-org/gitlab!156143))
- [Remove unused issue card weight filtering functionality](gitlab-org/gitlab@c2a0ff663df5c76a545d42aaaea81a0f73f5eeea) ([merge request](gitlab-org/gitlab!155627))
- [Fix publishing npm package with custom root folder name](gitlab-org/gitlab@85a76d6dca39438755c39df5104266b866339698) ([merge request](gitlab-org/gitlab!155842))
- [Fixed overflowing layout on the compare revisions page](gitlab-org/gitlab@7b0a3e09d055c7a568504122779e9824e7c025c6) by @zillemarco ([merge request](gitlab-org/gitlab!155744))
- [Wiki: Fix header spacings on published pages and create page](gitlab-org/gitlab@a8a4ae87afbc6ecd5cd3b0a93a88faf565ad906f) ([merge request](gitlab-org/gitlab!156131))
- [Delete project_ref_name_in_pipeline feature flag](gitlab-org/gitlab@8263838e425d80a2ecb17641fa9529fda21a4d20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156110))
- [Wrap wiki history commit message](gitlab-org/gitlab@58664e791ef41a530a28eaa75236a96e1761b57e) ([merge request](gitlab-org/gitlab!156082))
- [Fix approvals text alignment](gitlab-org/gitlab@84dae5a9e7c06da98140fd9d0fadaf390049935a) ([merge request](gitlab-org/gitlab!156025))
- [Use gl-background-color-default for .gl-new-card-add-form background](gitlab-org/gitlab@52a9f9cc9564baf32887f63326f930c5ee1cb3b1) ([merge request](gitlab-org/gitlab!155108))
- [Sync updated_at attribute when updating epic](gitlab-org/gitlab@963c0850aa9c26b7f62dee9d1cadd3f3ec36814b) ([merge request](gitlab-org/gitlab!156059)) **GitLab Enterprise Edition**
- [Fix inviting members with a custom role](gitlab-org/gitlab@e441cfea7ad315ca3b3f9c9c1648df65aca899ec) ([merge request](gitlab-org/gitlab!155864)) **GitLab Enterprise Edition**
- [Remove the archived projects from the security dashboard](gitlab-org/gitlab@31eabb2a173455de2ffe5f6a3b7d1322412bc4fb) ([merge request](gitlab-org/gitlab!154330)) **GitLab Enterprise Edition**
- [Remove branch on jira when deleted on gitlab](gitlab-org/gitlab@221f138b09c7873d21ada8e875e18ed97d6c42c9) ([merge request](gitlab-org/gitlab!148712))
- [Update "shared runners enabled" setting on subgroup builds](gitlab-org/gitlab@48a012d87b132962c6ce4bebf56c37175a15d06a) ([merge request](gitlab-org/gitlab!154928))
- [Ignore wiki links that have missing href](gitlab-org/gitlab@8d570b29032133080cce1fb73dde203dcb41a842) ([merge request](gitlab-org/gitlab!155877))
- [Hide Exact code search in preferences when zoekt setting is disabled](gitlab-org/gitlab@06288e9256a1e3a841bef3f098f96ddc5f268e70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155586)) **GitLab Enterprise Edition**
- [This MR fixes project selection](gitlab-org/gitlab@cf845c45504d000294da1f10b4ada9dc0e77b0ce) ([merge request](gitlab-org/gitlab!155862)) **GitLab Enterprise Edition**
- [fix: Add zero-padded mapping for OWASP 2021 vuln categories](gitlab-org/gitlab@51350bfa6aa8ef4a5d6569f31b65729a90b47513) ([merge request](gitlab-org/gitlab!155860)) **GitLab Enterprise Edition**
- [Fix links and tree drag and drop on FF](gitlab-org/gitlab@ce592ead2f2fb5ec17faa1e4c8350b2ba1cd5a03) ([merge request](gitlab-org/gitlab!154787))
- [Update Merge train system note](gitlab-org/gitlab@d71fd369baee49cce5bbe38576a7e1b77f2b7d22) ([merge request](gitlab-org/gitlab!155551))
- [Fix calculating direct_members count](gitlab-org/gitlab@e8a438c3c92c93599de58c0a292b15f6a5e58600) ([merge request](gitlab-org/gitlab!155838)) **GitLab Enterprise Edition**
- [Fix the limit logic for containing refs requests](gitlab-org/gitlab@ae365c5d59713bd5780ef244dca5880a9743fc4c) ([merge request](gitlab-org/gitlab!155735))
- [Add reject_non_dco_commits to push rules REST API](gitlab-org/gitlab@ce371744d27ea0a463b0a221eb6888ce57814a74) ([merge request](gitlab-org/gitlab!155005)) **GitLab Enterprise Edition**
- [Use primary DB for authenticating artifacts downloads](gitlab-org/gitlab@db4e7f82c379296b1bdbafc5a41f4977a559fb81) ([merge request](gitlab-org/gitlab!155684))
- [Cleanup ci_runner_projects records with null project_id](gitlab-org/gitlab@5fc53aea1399ee8e4d0fb025193482d465f7f656) ([merge request](gitlab-org/gitlab!155760))
- [Cleanup ci_runner_namespaces records with null namespace_id](gitlab-org/gitlab@757d1ec2d1335e3d91d99be0d70fadd3115a6fd9) ([merge request](gitlab-org/gitlab!155761))
- [Take broadcast message height into account in board height](gitlab-org/gitlab@50d8593755d0ae3d9eba74d755566846b08404f8) ([merge request](gitlab-org/gitlab!155326))
- [Use blue color for subscribed state and active todo](gitlab-org/gitlab@1eb3453bd230bb89394b2286c157cb310668a3c5) ([merge request](gitlab-org/gitlab!155623))
- [Fix Epics::UpdateService to only sync changed attributes](gitlab-org/gitlab@c13b5b850af2c9795529de59d5a1337b16c1047a) ([merge request](gitlab-org/gitlab!155468)) **GitLab Enterprise Edition**
- [Respect carraige return in new job log viewer](gitlab-org/gitlab@6c6c829426ed17ed499d302ca5f8a1dd20240642) ([merge request](gitlab-org/gitlab!153704))
- [Update an expired test certificate](gitlab-org/gitlab@5c21cdd681b61e718654b73bb05befc3cb161423) ([merge request](gitlab-org/gitlab!155694))
- [Do not error when assigning issue to same epic](gitlab-org/gitlab@8f1692dbc66079c337971b3fa963a8f57af6b2f0) ([merge request](gitlab-org/gitlab!155632)) **GitLab Enterprise Edition**
- [Restrict GraphQL 