# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    class BackfillIdentifierExternalIdsOfVulnerabilityReads < BatchedMigrationJob
      operation_name :backfill_identifier_external_ids
      feature_category :vulnerability_management

      UPDATE_SQL = <<~SQL
        UPDATE vulnerability_reads AS vr
        SET identifier_external_ids = selected_ids.external_ids
        FROM (
            SELECT
                vr.id,
                ARRAY_AGG(vi.external_id ORDER BY vi.external_id) AS external_ids
            FROM
                vulnerability_reads vr
            JOIN
                vulnerability_occurrences vo ON vr.vulnerability_id = vo.vulnerability_id
            JOIN
                vulnerability_occurrence_identifiers voi ON vo.id = voi.occurrence_id
            JOIN
                vulnerability_identifiers vi ON voi.identifier_id = vi.id
            WHERE
                vr.id IN (?)
            GROUP BY
                vr.id
        ) AS selected_ids
        WHERE vr.id = selected_ids.id
      SQL

      class VulnerabilitiesRead < ::ApplicationRecord
        self.table_name = 'vulnerability_reads'
      end

      def perform
        each_sub_batch do |sub_batch|
          update_query = VulnerabilitiesRead.sanitize_sql([UPDATE_SQL, sub_batch.select(:id)])
          connection.execute(update_query)
        end
      end
    end
  end
end
