/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  fsm_phrase.lex
Dates:		  10 Mar 2004
Purpose:	  parse fsm construct
              Monolithic grammar that launches its thread.
              Properly handles threads and errors. Starts
              from a procedure using another parser's
              token stream from a specific point.
Note: Use of ||| |?| phrase to catch other returned terminals 
      or errors. In this case, it is errors. 
      One can be selective within various contexts:
         1) within arbitration
         2) sub-rule level
      The symbol's enumerated id is the fodder to filter on.
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |fsm_phrase| grammar.\fbreak
Dispatch grammar to parse the fsm construct.\fbreak
Gets launched from |PROCESS_KEYWORD_FOR_SYNTAX_CODE|
external procedure.
@/
fsm	
(fsm-id "fsm_phrase.lex",fsm-filename fsm_phrase,fsm-namespace NS_fsm_phrase
,fsm-class Cfsm_phrase{
  user-prefix-declaration
#include "fsm_phrase_th.h"
    using namespace NS_yacco2_terminals;
  ***
  user-declaration
   public: yacco2::AST* cweb_marker__;
  ***
  op
   cweb_marker__ = 0;
  ***
}
,fsm-version "1.0",fsm-date "4 mar 2004",fsm-debug "false"
,fsm-comments "Dispatcher to parse ``fsm'' construct.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rfsm_phrase (){
  -> Rphrase
}

Rphrase (){
  ->  ||| "fsm-phrase" NS_fsm_phrase_th::TH_fsm_phrase_th {
  op
    ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
  ***
  } 
  ->  ||| |?| NULL { // thread has stop parsing with RSVP error
  op
    ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
  ***
  }
  ->  |?| { // error due to no first set to start thread
  op
    CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
    sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
    ADD_TOKEN_TO_ERROR_QUEUE(*sym);
  ***
  }
}
}// end of rules
