% File:          notice.sl      -*- mode: SLang -*-
%
% Author:        Guido Gonzato, guido.gonzato@univr.it
%
% Description:   this is a module for latex4jed.
%                
% Installation:  copy notice.sl to $JED_ROOT/lib/latex, or to your
%                LaTeX_Modules_Dir.
%                
% Version:       1.0.0
%
% Last updated:	 3 May 2003

define notice_template ()
{
  vinsert ("\\documentclass[%s]{article}\n\n",
	   LaTeX_Article_Default_Options);
  insert ("\\usepackage{type1cm}\n");
  insert ("\\usepackage{times}\n");
  insert ("\\usepackage{color}\n");
  insert ("\\usepackage{rotating}\n");
  insert ("\\pagestyle{empty}\n");
  insert ("\\begin{document}\n\n");
  
  insert ("\\begin{sidewaysfigure}\n");
  push_spot ();
  insert ("  \\fontsize{2.5cm}{2.5cm}\\selectfont\n");
  insert ("  \\centerline{\\textcolor{blue}{\\textbf{Please:}}}\n");
  insert ("  \\vskip 1cm\n\n");
  insert ("  \\fontsize{4cm}{3cm}\\selectfont\n");
  insert ("  \\centerline{\\textcolor{red}{DO NOT}}\n");
  insert ("  \\centerline{\\textcolor{red}{SMOKE}}\n");
  insert ("  \\centerline{\\textcolor{red}{HERE!}}\n");
  insert ("  \\vskip 1cm\n\n");
  insert ("  \\fontsize{2cm}{2cm}\\selectfont\n");
  insert ("  \\centerline{\\textcolor{magenta}{If you do,}}\n");
  insert ("  \\centerline{\\textcolor{magenta}" + 
          "{you'll be \\emph{deboned!}}}\n");
  insert ("\\end{sidewaysfigure}\n\n");
  insert ("\\end{document}");
  pop_spot ();
}

$1 = "LaTeX-Mode";
$2 = "Global.M&ode.Mod&ules.notice";
definekey_reserved ("notice_template", "tn", $1);
definekey_reserved ("notice_template", "^T^N", $1);
menu_append_item ($2, "&Template", "notice_template");

% ----- End of file notice.sl
