;;; thai-word.el -- find Thai word boundaries

;; Copyright (C) 2000 Electrotechnical Laboratory, JAPAN.

;; Author: Kenichi HANDA <handa@etl.go.jp>

;; Keywords: thai, word break, emacs

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;; XXX: The copyright status of the dictionary is not clean -- there
;;      was no copyright at all in the used Thai word list file.


;; This file implements an algorithm to find Thai word breaks using a
;; dictionary.  It is based on the C program `cttex' written by
;; Vuthichai Ampornaramveth <vuthi@nii.ac.jp>.


;; Table of Thai words.  It is a nested alist (see `nested-alist-p'),
;; which means that you can easily index the list character by
;; character.

(defconst thai-word-table nil)


;; Set up `thai-word-table'.

(let
    ((l
      '(""
	"ظѳ"
	""
	""
	""
	""
	""
	""
	"Թ"
	""
	"ѭ"
	"ѭص"
	"ѭ"
	"Ҹԡ"
	"Թ"
	"ԡ"
	"ǷԵ"
	""
	""
	""
	""
	""
	"ɰ"
	""
	""
	"ҹ"
	""
	""
	"Թ"
	""
	""
	""
	""
	"á"
	"áҤ"
	"ç"
	"ó"
	"ó"
	"ó¡Ԩ"
	"ó"
	"ô"
	"ù"
	"ú"
	"ú"
	""
	""
	""
	"êԧ"
	"ó"
	"óԡ"
	""
	""
	""
	"ҵ"
	"Ҫ"
	"Ҫվ"
	"Ҹԡ"
	"¡"
	"§"
	"⪡"
	""
	"Ǵ"
	"Ǻ"
	""
	""
	"͡"
	"͡á"
	"ͧ"
	"ͧ"
	"ʹ"
	"ͺ"
	""
	""
	"Ч"
	"Чͧ"
	"Ч͹"
	"Ш"
	"Ш͡"
	"Шͧ"
	"Шѧ"
	"ШѺ"
	"ШҴ"
	"ШҺ"
	"Ш"
	"ШԴ"
	"ШԺ"
	"ШԴ"
	"Шء"
	"ШغШԺ"
	"Ш"
	"Ш맡Ш"
	"ШШ"
	"Шҧ"
	"Ш͹"
	"Щ͡"
	"ЩѺ੧"
	"Щش"
	"Щ͹"
	"Ъ͹"
	"ЪѺ"
	"Ъ"
	"Ъҡ"
	"Ъ"
	"Ыԡ"
	"ЫԺ"
	"д"
	"дͧ"
	"дѧ"
	"дҡ"
	"дҧҧ"
	"дҹ"
	"д"
	"дԡ"
	"д"
	"д"
	"д׺"
	"д"
	"д١"
	"д"
	"дҧ"
	"еԡ"
	"еԺ"
	"е"
	"е"
	"еء"
	"е駡е"
	"е"
	"еͧ"
	"е"
	"е"
	"еͺ"
	"жԹ"
	"з"
	"зǧ"
	"з"
	"з"
	"зԧ"
	"з׺"
	"зا"
	"з"
	"з"
	"з͹"
	"з"
	"кǹ"
	"к"
	"к͡"
	"кͧ"
	"к"
	"к"
	"к"
	"к"
	"кا"
	"л"
	"лǡ"
	"л"
	"л͡"
	"лͧ"
	"мաм"
	"мա"
	"о"
	"о"
	"о"
	"пѴ´"
	"пп"
	""
	""
	"ѧ"
	"˧ѹ"
	"֡"
	"͹"
	"͡"
	""
	""
	"Թ"
	"աҴ"
	""
	"һ"
	"ͺ"
	"ѧ"
	"ѹ"
	""
	""
	"اԧ"
	"ع"
	"˹"
	"˹Һ"
	"˹"
	"Ժ"
	""
	""
	""
	""
	""
	"ͺ"
	"ѡ"
	"ѡǹ"
	"ҡЧʹ"
	""
	"ԧ"
	"Դԧ"
	"º"
	""
	""
	"ԧ"
	""
	""
	"Դ"
	"´"
	"͡"
	"ͧ"
	""
	""
	"൧"
	""
	"ͧ"
	""
	"Ժ"
	""
	"͹"
	"ູ"
	"´"
	"ͧ"
	""
	""
	""
	""
	"͡"
	"¹"
	"¹"
	""
	"繡"
	""
	"紡"
	""
	""
	""
	""
	""
	"ᷡ"
	""
	""
	"⨹"
	""
	"⩡੡"
	"ⴡ"
	"ⴡഡ"
	"ⴧ"
	"ⶹ"
	""
	"ç"
	""
	"ѡ"
	"ѧ"
	"ѹ"
	"Ѻ"
	""
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҹ"
	"Һ"
	"ҿ"
	""
	""
	""
	""
	"ԡ"
	"ԧ"
	"Ԫ"
	"Ժ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ա"
	"ձ"
	"մ"
	"ո"
	"չ"
	""
	""
	"ء"
	"ا"
	"س"
	"سҸԤس"
	"ع"
	"غ"
	""
	""
	""
	""
	""
	"ٴ"
	"͡"
	"͹"
	""
	"ҧ"
	""
	""
	""
	""
	"ҹ"
	""
	"ɮա"
	"ɳ"
	"ɳ"
	""
	"Ŵ"
	"ź"
	""
	"ǧ"
	"͡"
	"ͧ"
	"͹"
	""
	"ѡ"
	"Ѵ"
	"Ѻ"
	""
	""
	""
	""
	"ҡ"
	"ҧ"
	"Ҵ"
	""
	""
	""
	""
	""
	""
	"պ"
	""
	"֧"
	"׹"
	""
	""
	""
	""
	"ͧ"
	""
	""
	""
	""
	""
	"ͧ"
	"͹"
	""
	""
	""
	""
	"Ǵ"
	"ǹ"
	""
	""
	"¨"
	"¨"
	"ѡ"
	"Ѵ"
	"ҧ"
	"ҧ"
	"Ҵ"
	""
	""
	""
	"ҧ"
	"ҹ"
	"ҹ"
	"ѵ"
	""
	"һ"
	""
	"ԡ"
	"ԡ"
	"Գ"
	""
	"͡"
	"ͧ"
	"ͫ"
	"ʹ"
	"ͺ"
	"ͻ"
	""
	""
	""
	""
	""
	"Ъ衡Ъ"
	"Ыǡ"
	"д"
	"е"
	"еҡ"
	"зá"
	"з"
	"з"
	"кѧ"
	"к"
	"лԴл"
	"лǡ¡"
	"л"
	"л"
	"о"
	"оԺ"
	"оͧ"
	"о"
	"ѵ"
	"觡"
	""
	"лѧ"
	"ѧ"
	""
	""
	""
	""
	""
	"¡Ժ"
	""
	"˹ا˹ԧ"
	"˹ͧ˹"
	"ʹ"
	""
	""
	"ͧ"
	""
	"ءԡ"
	""
	"ഡ"
	"൧"
	""
	""
	"꺡лҺ"
	"š"
	"¡Ҵ"
	"Դ"
	"͡"
	"§"
	""
	""
	"ⵧ൧"
	""
	""
	"ç"
	""
	"šš"
	"š"
	"ѡ"
	"ѡ"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѧԹ"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѧʴ"
	"ѧѹ"
	"ѧ"
	"ѭ"
	"ѭ"
	"ѳ"
	"Ѵ"
	"ѹ"
	"ѹ"
	"ѹ"
	"ѹ¹"
	"ѹ"
	"Ѻ"
	"ѻ"
	"ѻѹ"
	"ҷ"
	""
	"٪"
	"ѹҾѧ"
	"ź"
	"Żġ"
	"Żҹ"
	"Żѧ"
	"Ż"
	""
	"ҳ"
	"ҳ"
	""
	""
	""
	""
	""
	""
	"ҡ"
	"ҡ"
	"ҧ"
	"ҧࡧ"
	"ҧࢹ"
	"ҫͧ"
	"ҭ"
	"Ҵ"
	"ҹ"
	"ҹ"
	"Һ"
	"ҽҡ"
	"Ҿ"
	""
	""
	""
	"¡"
	"Ҿ"
	"Ҥ"
	"Է"
	"Ҿ¾"
	""
	"á"
	"ó"
	"ú"
	"ࡴ"
	"ѳ"
	"ѹ"
	"س"
	"ǡ"
	""
	"ٹ"
	""
	"šԳ"
	""
	""
	""
	""
	""
	"ŧ"
	""
	""
	""
	"硫"
	""
	"ӡ"
	"ӡѴ"
	"ӡѺ"
	"Ө"
	"ӨѴ"
	"Ө"
	"ӪѺ"
	"ӫҺ"
	"ӴѴ"
	"Ӹ"
	"ӹѹ"
	"ӹ"
	"Ӻѧ"
	"ӻ"
	"Ӿ"
	"Ӿ״"
	"жѹ"
	""
	""
	"ҹ"
	""
	"Һ"
	"ѧ"
	""
	"˹"
	"˹Ѵ"
	""
	"Դ"
	"Ժ"
	"˹"
	"ᾧ"
	"˧"
	""
	""
	"ԡ"
	"Ԩ"
	"Ԩѡɳ"
	"Ԩ"
	"Ե"
	"ԵԤس"
	"Եѡ"
	"ԵѾ"
	"Թ"
	"Թ"
	"Թ"
	"Գ"
	""
	"Ź"
	""
	""
	"µչ"
	""
	"š"
	"Ե"
	""
	"õ"
	""
	""
	"駡"
	"駡"
	""
	""
	"կԷ"
	"մ"
	"յ"
	"պ"
	""
	""
	""
	""
	"֡"
	"֡ͧ"
	""
	""
	""
	"ء"
	"ءѡ"
	"ح"
	"ح"
	"خѧ"
	"خ"
	"د"
	"س"
	"ش"
	"شѧ"
	"شѹ"
	"ع"
	"ع§"
	"غ"
	""
	""
	""
	""
	""
	""
	""
	"ª"
	"Χ"
	""
	"ŸԴ"
	"źص"
	"ʵ"
	""
	""
	"աب"
	""
	"Һ"
	""
	""
	""
	""
	""
	""
	""
	"ٳ"
	"ٴ"
	"ٺ"
	""
	""
	"ҡ"
	""
	""
	""
	""
	"ͧ"
	"͹"
	""
	""
	""
	""
	""
	""
	"ͧ"
	"͹"
	""
	""
	"͡͵ԡ"
	"ҧ"
	"ҹ"
	""
	""
	""
	"ӡ"
	"Թ"
	""
	""
	"͡"
	"ͺ"
	"ҫ"
	"Ҵ"
	""
	""
	""
	""
	""
	""
	"Ѵ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"Ѵ"
	"ѹ"
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҹ"
	"Һ"
	""
	"ɰ"
	"ع"
	""
	""
	"ǹ"
	""
	"Ǵ"
	"ͧ"
	""
	"ѧ"
	"Ѻ"
	""
	"Ժ"
	""
	"բѹ"
	"֧"
	"ء"
	"غ"
	"غԺ"
	""
	""
	"͡"
	"ͧ"
	""
	"ѡ"
	"ѹ"
	"Ѻ"
	""
	"Ҵ"
	"Һ"
	""
	""
	"ԡ"
	"Ժ"
	""
	""
	"ءԡ"
	"غ"
	"غԺ"
	""
	""
	""
	""
	"͹"
	"͹"
	""
	""
	"ä"
	""
	"Ժ"
	""
	"آ"
	"ѧ"
	""
	"Ҵ"
	"Ժ"
	"ء"
	"ءѡ"
	"ءԡ"
	"غ"
	""
	""
	"ǧ"
	"Ǵ"
	"ǹ"
	"Ǻ"
	""
	"ѡ"
	"ѭ"
	"Ѵ"
	"Ѻ"
	"Ѻ"
	""
	""
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҹ"
	"¢ǹ"
	"Դ"
	"ҧ"
	""
	"͡"
	"ͧ"
	"ʹ"
	"͹"
	"ͺ"
	"ͺس"
	"ͺ"
	""
	""
	"ѡ"
	"ء"
	"ԡ"
	"ء"
	""
	""
	"ѧ"
	"ѳʡ"
	"ѳ"
	"Ѵ"
	"ѵҹ"
	"ѹ"
	"ѹ"
	"ѹ"
	"ѹ"
	"ѹ"
	"ѹҡ"
	"ѹⵡ"
	"Ѻ"
	""
	""
	""
	""
	"ҡ"
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҹ"
	"Һ"
	""
	""
	""
	""
	""
	"ԡ"
	"ԧ"
	""
	""
	"մ"
	"ջظ"
	""
	""
	""
	"֧"
	""
	""
	"鹩"
	"׹"
	""
	""
	"ء"
	"ش"
	"ع"
	"عͧ"
	"عἹ"
	""
	""
	""
	"ٴ"
	""
	""
	""
	"ǹ"
	""
	"͹"
	""
	""
	"ҧ"
	""
	""
	""
	""
	"ͧ"
	"͹"
	""
	""
	"ҧ"
	"Ҿ"
	""
	""
	""
	""
	"⾴"
	"֡"
	"ǧ"
	""
	"ҧ"
	"ҹ"
	""
	""
	"Ҫ"
	""
	"Ҫҵ"
	"Ҫվ"
	"Ҹ"
	"ó"
	""
	""
	""
	""
	"Ҩ"
	"Ҹԡ"
	"ҸԻ"
	"ҹѺ"
	"ԡ"
	"Ե"
	""
	""
	""
	"Ը"
	"Ծ"
	""
	"þ"
	""
	""
	""
	"ҡ"
	"Ҥ"
	"á"
	"ú"
	""
	"ͧ"
	""
	"ǭ"
	"ѡ"
	""
	""
	"͡"
	"ͧ"
	"ͧç"
	"ͺ"
	""
	"˧ҹ"
	"Ѵ"
	"ѹ"
	"Ѻ"
	""
	""
	""
	""
	""
	"ҡ"
	"ҧ"
	"ҭ"
	"Ҵ"
	"Һ"
	""
	""
	""
	""
	"ʵ"
	"ʵѧ"
	"ʵ"
	"¹"
	"պ"
	""
	""
	"֡"
	"֡"
	"ֹ"
	""
	""
	""
	"״"
	"׹"
	""
	""
	"鹤֡"
	""
	"ر"
	""
	""
	""
	""
	"ٴ"
	""
	""
	""
	""
	""
	""
	"ҹ"
	""
	""
	"ʶ"
	"ʹ"
	""
	"͡"
	"ͧ"
	"ʹ"
	"͹"
	"չ"
	"ÿ"
	"ÿ"
	""
	"ѡ"
	"ѧ"
	"ѵ"
	"Ѻ"
	""
	""
	""
	"ҧŧ"
	"Ҵ"
	"ҹ"
	""
	""
	"Թԡ"
	""
	""
	"֧"
	""
	"¹"
	""
	"ء"
	""
	""
	""
	"ͧ"
	"ͧ"
	""
	"ͧ"
	""
	""
	""
	"ǧ"
	"Ǻ"
	""
	"ѡ"
	"ѹ"
	""
	"ҡ"
	"ҭ"
	"ҹ"
	""
	""
	"ԹԹ"
	""
	""
	"ҧ"
	"ҹ"
	"ˡ"
	"ˡʵ"
	"˺"
	""
	"͡"
	"ʹ"
	"͹"
	"͹յ"
	"͹ഹ"
	"͹"
	"͹ǹ"
	""
	""
	"ҹ"
	"ǹʵ"
	"ٹप"
	""
	""
	""
	"ԡ"
	""
	""
	"ʵԡ"
	"फ´"
	""
	"йͧ"
	"й֧"
	"й"
	""
	"鹤"
	""
	""
	"ṹ"
	"ѡ"
	"Ѥ"
	"Ѥҧ"
	"Ѥҹ"
	"ѳٵ"
	"Ѵ"
	"ѷ"
	"ѹ"
	"ѹ"
	"ѹ"
	"Ѻ"
	"Ҿ"
	""
	""
	""
	""
	""
	""
	""
	"ҧ"
	"ҧ"
	"Ҵ"
	"Ҷ"
	"ҷԡ"
	"ҹ"
	"Һ"
	""
	""
	""
	""
	""
	"ҹ"
	""
	"͹"
	"͹͹͡䫴"
	"ԡ"
	"๵"
	""
	"õ"
	""
	""
	""
	"ӹǳ"
	"ӹѺ"
	"ӹ֧"
	"ù"
	"ú"
	""
	"˧"
	"ԡ"
	"ԧ"
	"Դ"
	"ѹ"
	""
	""
	"յ"
	"չ"
	"պ"
	""
	""
	""
	""
	"֡"
	""
	"׹"
	"׺"
	""
	""
	"ء"
	"ء"
	"س"
	"سҾ"
	"سص"
	"سѵ"
	"سҡ"
	"سٻ"
	"ش"
	"شҴ"
	""
	""
	""
	"⳻"
	""
	""
	""
	""
	""
	""
	"ٳ"
	"ٹ"
	"ٻͧ"
	""
	""
	""
	"๨"
	"͡"
	"͹"
	""
	""
	""
	""
	"ҧ"
	""
	""
	""
	"͹"
	""
	""
	"ҧ"
	"ҧ"
	"ҧ"
	"ҹ"
	""
	""
	"ҵ"
	"ҵ"
	"ҵ"
	""
	"ͧ"
	""
	""
	""
	""
	""
	""
	"ǧ"
	"Ǵ"
	"§"
	""
	"͡"
	"͡᧡"
	"ʹ"
	"ʹ᧴"
	"͹"
	"͹˧"
	"ͺ"
	""
	""
	""
	""
	"ѡ"
	"Ѵ"
	"ѹ"
	"Ѻ"
	""
	""
	""
	""
	""
	""
	"ҹ"
	"Һ"
	""
	""
	""
	""
	"պ"
	"֡"
	""
	""
	"ش"
	"ع"
	"غ"
	"غԺ"
	""
	"蹧ҹ"
	""
	""
	""
	"Ѵ"
	"ǧ"
	"ǹ"
	"ͧ"
	"͹"
	""
	"ҹ"
	""
	""
	""
	"ǹ"
	""
	""
	"ҧ"
	""
	""
	""
	""
	"Ź"
	"ҧ"
	""
	""
	"ç"
	"þԸ"
	"ʴ"
	""
	""
	""
	"١"
	""
	"ô"
	""
	"ŧ"
	""
	"Ǵ"
	""
	""
	""
	"Ҩ"
	"ԧ"
	"Ե"
	"¸"
	"ʵ"
	"֡"
	""
	"ا"
	"٭"
	""
	"Źʵ"
	"Źʵ"
	"Ҩ"
	"ǡ"
	"ǧ"
	"ǹ"
	"Ǻ"
	"ѡ"
	""
	"͡"
	"ͧ"
	"ͧͧ"
	"ʹ"
	"͹"
	"ͺ"
	""
	"ᴹ"
	""
	""
	"С"
	"С"
	""
	""
	""
	"ѡ"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѡþô"
	"ѡ"
	"ѡҹ"
	"ѡô"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѧ"
	"ѧͺ"
	"ѧ"
	"ѧѧ"
	"ѧ"
	"ѧѴ"
	"ѧѹ"
	"ѧ"
	"ѭ"
	"ѳ"
	"ѳ"
	"Ѵ"
	"ѵ"
	"ѵ"
	"ѹ"
	"ѹ"
	"ѹ"
	"ѹä"
	"ѹä"
	"ѹػҤ"
	"ѹ"
	"Ѻ"
	"Ѻѧ"
	"Ѻ"
	""
	""
	""
	"ꡨ"
	""
	""
	"ҡ"
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҵçѹԺҵ"
	"ҹ"
	"Һ"
	"Һ"
	"Һ"
	""
	""
	""
	""
	""
	"к"
	""
	"ԡ"
	""
	"յ"
	"֡"
	""
	""
	""
	"ӡѴ"
	"ӹ"
	"ӹ"
	"ӹè"
	"ӹè"
	"ӹǹ"
	"ӹͧ"
	"ӹ"
	"ӻ"
	"ӻ"
	"Ӿǡ"
	""
	"٭"
	"ͧ"
	"˹"
	"Ǵ"
	""
	"ԭ"
	"§"
	""
	"ṡ"
	"ԡ"
	"ԧ"
	"Ե"
	"Ե"
	"Եá"
	"Եá"
	"ԵŴ"
	"ԵԷ"
	"ԵǪ"
	"Եᾷ"
	"Թ"
	"Թ"
	"Թ"
	"Թҡ"
	"ԹҾ"
	"Ժ"
	"ԻҶ"
	""
	"駨"
	"駨͡"
	"մ"
	"Ź"
	""
	""
	""
	"չ"
	"չ"
	"պ"
	""
	""
	""
	""
	""
	"֧"
	""
	""
	"״"
	""
	"ء"
	"ش"
	"ص"
	"ع"
	"غ"
	"غԺ"
	""
	"Ե"
	"Ũ"
	"Ūվ"
	"Ūѹ"
	"ŪԹ"
	"ŷȹ"
	"Ҥ"
	"ä"
	"ѡҪ"
	""
	"Թ"
	""
	""
	""
	""
	""
	"鹨"
	""
	""
	"ꡡ"
	""
	"ᨧ"
	"맨"
	""
	""
	"٧"
	"ٺ"
	""
	""
	""
	""
	""
	""
	""
	""
	"ҧ"
	""
	""
	"ǧ"
	""
	"͡"
	"͡"
	"ͧ"
	"͹"
	""
	""
	""
	"ҧ"
	"ҹ"
	""
	""
	""
	"Ө"
	""
	"͡"
	""
	""
	"ͧ"
	""
	""
	""
	""
	"è"
	"ѵ"
	"Ҩ"
	"Ҿ"
	""
	""
	"ǹ"
	"ѧ"
	"ҡ"
	""
	"ѧ"
	"Ѻ"
	""
	"ǡ"
	"ѧ"
	""
	""
	""
	""
	"ͧ"
	""
	"ѡ"
	"ҡ"
	"Ҵ"
	""
	""
	""
	""
	"ء"
	""
	""
	"Ѵ¹"
	"ҧ"
	""
	"ȡ"
	"͡"
	"ʹ"
	""
	""
	"Щҹ"
	"й"
	"й"
	"͹"
	"ѵ"
	"ѹ"
	"ѹѡɳ"
	"ѹ"
	"ѹ"
	"ѹҹѵ"
	"ѹ"
	"Ѻ"
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҹ"
	"Һ"
	""
	""
	""
	"ө"
	"Թ"
	"Ժ"
	""
	""
	""
	"ա"
	"մ"
	""
	""
	"ء"
	"ءԹ"
	"ش"
	"ع"
	""
	"ٴ"
	""
	"ͧ"
	""
	""
	"ҧ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ǹ"
	""
	"ѡ"
	"Դ"
	""
	""
	""
	""
	"ٹ"
	"ٹط"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"Ÿ"
	"Ÿ"
	"Ź"
	"Żзҹ"
	""
	""
	""
	"Ǵ"
	"ǹ"
	""
	""
	"͡"
	"͡"
	"͹"
	"ͺ"
	""
	""
	""
	""
	""
	""
	"Чѡ"
	"ЧѴ"
	"Ч"
	"Ч͹"
	"Ч"
	"е"
	"й"
	""
	"Ѵ"
	""
	""
	""
	"ٴ"
	""
	""
	""
	""
	"ŧ"
	"⧡"
	""
	"ѡ"
	"ѧ"
	"Ѫ"
	"ѯ"
	"Ѵ"
	"Ѵਹ"
	"ѹ"
	"ѹе"
	"ѹ"
	"ѹٵ"
	""
	"¾ġ"
	""
	""
	""
	""
	""
	""
	"ҭ"
	"Ҵ"
	"Ҵ"
	"ҵ"
	"ҵ"
	"ҵ"
	"ҹ"
	"ҹ"
	""
	""
	""
	""
	""
	""
	""
	"ӹѭ"
	"ӹҭ"
	"ӹ"
	""
	"ش"
	""
	"¹"
	""
	""
	"ͧ"
	""
	""
	"ԧ"
	"ԧ"
	"Դ"
	"Թ"
	""
	"ỹ"
	""
	""
	""
	""
	"ջТ"
	"վ"
	"վԵѡ"
	"ǻѵ"
	"Է"
	"ҵ"
	""
	"Ե"
	"Եѡ"
	"Թ"
	""
	""
	""
	"״"
	""
	""
	""
	""
	""
	"ء"
	"ش"
	"ع"
	"غ"
	""
	""
	""
	"ع"
	""
	""
	""
	""
	""
	""
	""
	"ŷ"
	""
	""
	"͡ŵ"
	"͡ŵ"
	"ǧ"
	""
	""
	"ͧ"
	"͹"
	"ҧ"
	""
	"Ӫͧ"
	"ͧ"
	"͹"
	""
	""
	"ҧ"
	""
	""
	""
	""
	""
	""
	"ǹ"
	"ǹ"
	""
	""
	"͡"
	"ͧ"
	"͹"
	"Ϳ"
	""
	""
	""
	""
	"ѡ"
	"ѧ"
	"Ѵ"
	"Ѻ"
	"ſ"
	""
	"ҡ"
	"ҧ"
	"ҹ"
	"Һ"
	"Һҹ"
	""
	""
	""
	"ԡ"
	"ԡ"
	"ԡ"
	"Թ"
	"Ժ"
	"Ի"
	"Կ"
	"Ԥ͹"
	""
	""
	""
	"ա"
	"մ"
	"չ͹"
	""
	""
	""
	""
	"֧"
	""
	""
	""
	""
	""
	"ء"
	"ا"
	"ع"
	"غ"
	"ػ"
	""
	""
	""
	""
	"ٴҴ"
	"ٴҹ"
	"ٺ"
	""
	""
	""
	"ͧ"
	"͹"
	""
	""
	"ҹ"
	""
	""
	"ͧ"
	"͹"
	""
	""
	""
	"ҹ"
	"һԨ"
	"һʶҹ"
	"ǹ"
	"ѵ"
	"ҳ"
	"ҵ"
	""
	"ҹ"
	"ҹ"
	"ҹѹ"
	"һ"
	""
	""
	""
	""
	""
	""
	"ê"
	"ҿ"
	"س"
	"س"
	""
	"ǧ"
	"Ǵ"
	"͡"
	"ͧ"
	"ʹ"
	"͹"
	""
	""
	""
	""
	"ѡ"
	"ѡҹ"
	"ѡ"
	"ѧ"
	"Ѫ"
	"Ѵ"
	"ѹ"
	"Ѻ"
	""
	"ʡ"
	""
	""
	""
	""
	"ҡ"
	"Ҵ"
	"ҹ"
	"Һ"
	"Һ"
	""
	""
	"ó"
	"ô"
	""
	""
	"Ѵ"
	""
	"Ǵ֧"
	""
	"ɴ"
	""
	"ç"
	""
	""
	"ɳ"
	"ԧ"
	"ᤧ"
	"ԡ"
	"ԩѹ"
	"Զ"
	"Թ"
	"Ժ"
	"Ѩҹ"
	"š"
	"ࡵ"
	""
	""
	""
	""
	""
	"մ"
	"մշ"
	"պء"
	""
	"ʪ"
	"֡"
	"֡Ӻþ"
	"֧"
	"֧"
	""
	""
	""
	""
	""
	""
	"ء"
	"ب"
	"ش"
	"ع"
	"غ"
	""
	"ç"
	"ҧʵ"
	"ҧŻ"
	"ҧ"
	""
	"žԹԨ"
	"Ҥ"
	"¾ԹԨ"
	"Ҿ"
	"ɮ"
	"ɳ"
	"Ե"
	"Ե"
	""
	""
	""
	""
	"駴"
	""
	""
	"١"
	"ٴ"
	""
	"ǹ"
	"͹"
	""
	""
	"ҧ"
	"ҹ"
	""
	""
	""
	""
	"ǧ"
	"ǹ"
	""
	""
	""
	"ҹ"
	""
	""
	""
	""
	""
	""
	"Թ"
	"Դ"
	""
	"Ҥ"
	""
	""
	""
	""
	"ç"
	""
	""
	"áԷ"
	"áʵ"
	"á"
	"Ǩ"
	"ǹ"
	"͡"
	"ͧ"
	""
	""
	""
	"С"
	"˹"
	"˹"
	"ǹ"
	"ѧ"
	"Ѻ"
	""
	""
	""
	"ҡ"
	"Һ"
	"ѧ"
	""
	""
	""
	""
	"⡳"
	"֡"
	"֧"
	""
	""
	""
	""
	"ĳ"
	"š"
	"ź"
	"ʹ"
	"Ѻ"
	"Ҵ"
	""
	"ǧ"
	"Ѵ"
	"Ҵ"
	"˻ҹ"
	""
	"͡"
	"ͧ"
	"ʹ"
	"͹"
	"ͺ"
	""
	""
	""
	""
	""
	"Сѹ"
	"Сش"
	"С"
	"С"
	"С"
	"С"
	"С"
	"С͹"
	"Сѧ"
	"С"
	"СءСѡ"
	"Т"
	"ТҺ"
	"ТԴТǧ"
	"Ф"
	"Фغ"
	"Ф͡"
	"й"
	"кͧ"
	"к"
	"кѹ"
	"лл"
	"оҺ"
	"оִ"
	"оִо"
	"о"
	"յҹ"
	"֧"
	"͹"
	"ء"
	""
	"ѹ"
	""
	"¡С"
	"§"
	"º"
	""
	"¹"
	""
	""
	"Դ"
	""
	"¹"
	""
	"ŧ"
	"ç"
	"ᤧ"
	"ầ"
	""
	"⡡"
	"⡹"
	""
	"⢧"
	""
	"⾡"
	"˧"
	""
	""
	""
	""
	""
	"ѡ"
	"ѡ"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѳ"
	"Ѵ"
	"ѹ"
	"ѹ§"
	"Ѻ"
	""
	""
	""
	""
	""
	"ᵹ"
	""
	""
	"ҡ"
	"Ҵ"
	"ҹ"
	"ҹ"
	"Һ"
	""
	""
	""
	"Żѵ"
	""
	"ӹҹ"
	"Ӻ"
	"Ǩ"
	"Ѻ"
	""
	"֧"
	"˹ѡ"
	"˹"
	""
	"˹"
	""
	"ԡѧ"
	"ԧ"
	"Գ"
	"Դ"
	"Ѩҹ"
	"š"
	""
	""
	""
	""
	""
	"չ"
	"պ"
	""
	""
	""
	"֡"
	"֧"
	"ִ"
	""
	"页"
	"괵"
	"״"
	""
	""
	""
	""
	""
	"ءԡ"
	"ا"
	"ع"
	"ع˧ѹ"
	"غ"
	"á"
	""
	"ҡ"
	"Ҥ"
	"Ѵ"
	""
	""
	""
	"駡"
	"駵"
	""
	""
	""
	""
	""
	""
	""
	""
	"꺻ͧ"
	""
	""
	""
	"µ"
	""
	"١"
	"ٴ"
	"ٺ"
	""
	""
	""
	"ǹ"
	""
	"ͧ"
	""
	""
	"ҧ"
	"ҧ"
	""
	""
	""
	""
	""
	"ͧ"
	"͹"
	""
	"µ"
	"µԴ"
	"ҹ"
	"͡"
	"͡"
	""
	""
	""
	""
	""
	""
	"Ѵ"
	"Ѵ"
	""
	""
	"֧֧"
	"š"
	"Ź"
	"͡"
	"ѹ"
	""
	"ҡ"
	""
	"ն"
	"֧"
	"ا"
	"ع"
	""
	""
	""
	""
	"͡"
	"ͧ"
	"ʹ"
	"͹"
	""
	""
	"ѡ"
	"ѧ"
	"Ѵ"
	"ѹ"
	""
	""
	""
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҹ"
	""
	""
	""
	"պ"
	""
	"֡"
	"֧"
	""
	"ا"
	"ع"
	""
	""
	"١"
	""
	"ǧ"
	""
	"ͧ"
	""
	""
	"ҧ"
	"ҹ"
	""
	"ǹ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ǧ"
	""
	""
	"á"
	"ç"
	"ê"
	"êҵ"
	"þ"
	"þ"
	"ҹ"
	""
	"ؤ"
	"û"
	"ȹ"
	"Ҫ"
	"ѡɳ"
	"ǧ"
	"Ǵç"
	"˴"
	"Ѿҡ"
	"Ѿ"
	""
	"ҹ"
	"Һ"
	""
	""
	"ش"
	"ɮ"
	""
	"ǧ"
	"Ǵ"
	"ǹ"
	""
	"ҷ"
	""
	""
	""
	""
	"ոɡ"
	"ջ"
	""
	""
	"ȹ"
	""
	""
	"͡"
	"ͧ"
	"ͧ"
	"ͧҧ"
	"ʹ"
	"͹"
	"͹"
	"Ϳ"
	""
	"й"
	"йҹ"
	"й"
	"Ѵ"
	"ֹ"
	""
	"ҹ"
	"ǧ"
	"ѡ"
	""
	""
	""
	""
	"¹"
	"ͷҹ"
	""
	""
	"ͷ"
	""
	""
	"ѡ"
	"ѡԭ"
	"ѡԳ"
	"ѡԳѮ"
	"ѡ"
	"ѡ"
	"ѡԳ"
	"ѡԳ"
	"ѡԳõ"
	"ѡ⳷"
	"ѧʵ"
	"ѳ"
	"ѳҵ"
	"ѳʶҹ"
	"ѳ"
	"Ѵ"
	"ѹ"
	"ѹ"
	"ѹᾷ"
	"ѹ"
	"Ѻ"
	"Ѻԧ"
	"Ѿ"
	"Ѿ"
	"ȹ"
	"ȹ"
	"ȹ֡"
	"ȹ"
	"ȹ"
	"ȹҨ"
	"ȹҾ"
	"ȹ"
	"ȹٻó"
	"ȹ"
	""
	""
	""
	""
	""
	"ҡ"
	"ҧ"
	"ҹ"
	"Һ"
	""
	""
	"Ҵ"
	"ҷ"
	"á"
	"ԡ"
	"س"
	""
	""
	"ӹ"
	"ӹͧ"
	"ӹ"
	"ӹ"
	""
	""
	"º"
	""
	""
	"Ԥ"
	"Ԧ"
	"ԧ"
	"԰"
	"Դ"
	"Ծ¨ѡ"
	"Ծ­ҳ"
	"Ծ"
	"Ծ๵"
	"Ծ"
	"Ծҡ"
	""
	""
	"ǧ"
	"Ƿȹ"
	""
	""
	""
	"ҹط"
	"ີ"
	""
	""
	""
	""
	"ҵ"
	"͹"
	""
	"֡"
	"ֹ֡"
	"ֺ"
	""
	""
	""
	""
	""
	""
	"ء"
	"ء"
	"ء"
	"ءǷ"
	"ء"
	"ءá"
	"ؤ"
	"بԵ"
	"ش"
	"ع"
	"غ"
	"ؾ"
	"ؾԡ"
	""
	"áѹ"
	"ê"
	"êҵ"
	"ù"
	"þ"
	"ѡ"
	""
	""
	"¹"
	""
	""
	""
	""
	""
	""
	""
	""
	"ٵ"
	"ٵҹطٵ"
	"ٹ"
	""
	""
	""
	"§"
	""
	"ǧӹͧ"
	"ǧ"
	"ǧ"
	""
	""
	"ͧ"
	"͹"
	""
	"ҹ"
	"ҧ"
	""
	"ǧ"
	"ǹ"
	""
	""
	"ͧ"
	""
	""
	""
	""
	""
	"ѵ"
	"ѵ"
	""
	""
	""
	"Ҥ"
	"ҳѵ"
	""
	""
	"ó"
	""
	""
	"и"
	"ҷԵ"
	"Ҹ"
	"ҸԻ"
	"Ҹɰҹ"
	"ҹҹ"
	"آ"
	""
	"µ"
	""
	"ʹ"
	"ԡ"
	"Ҹ"
	"Ҹ"
	"ҸԺ"
	"ҸԻ"
	"ѭ"
	"ѭ"
	"ѭת"
	"ѹҤ"
	""
	"ҵ"
	"ҹ"
	""
	""
	"ç"
	"ç"
	"Դ"
	"ີ"
	"ش"
	"á"
	"á"
	"áԨ"
	""
	""
	"Ǵ"
	"Ҥ"
	""
	"ٻ"
	""
	""
	"Թ"
	""
	"ҭ"
	"ت"
	"Ч"
	""
	""
	"ѡɳ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ȡ"
	""
	""
	""
	""
	"ʡ"
	"á"
	"ԧ"
	"Ҹ"
	"Ǫ"
	"ᾷ"
	"ĤԵ"
	"Ĺҷ"
	""
	"Ե"
	"Ү"
	"Թ"
	"Ǵ"
	"ǹ"
	""
	""
	""
	""
	"ͧ"
	""
	"͡"
	"ͧ"
	"͵"
	"͹"
	"ͺ"
	""
	""
	"ѡ"
	"ѡѵ"
	"ѡѵ"
	"ѧ"
	"Ѵ"
	"Ѵ"
	"ѵ"
	"ѹҡ"
	"Ѻ"
	""
	"¹"
	""
	""
	""
	""
	""
	"ҡ"
	"Ҥ"
	"Ҥ"
	"ҤҪ"
	"Ҥ"
	"ҧ"
	"ү"
	"Ҵ"
	"Ҷ"
	"ҷ"
	"ҷ"
	"ҹ"
	"ҹѻ"
	"ҹ"
	"Һ"
	""
	""
	""
	"ʡ"
	"ҹء"
	""
	""
	"¡"
	"³"
	""
	"ԡ"
	"Թ"
	""
	"ԡ"
	"ԡ"
	""
	""
	""
	""
	"ԡ"
	"ԡ´"
	"ԡ"
	"ԡ"
	"Ԥ"
	"Ԥù"
	"ԤԵ"
	"Ԩ"
	"Դ"
	"Ե"
	"Ե"
	"Ե"
	"Է"
	"Է"
	"Էȹ"
	"Էҹ"
	"Թ"
	"Ժҵ"
	"Ծ"
	"Ծҹ"
	""
	"ҹ"
	"ҹô"
	"Ե"
	""
	""
	""
	"÷ء"
	"ù"
	""
	""
	"Ե"
	"ѹ"
	""
	""
	""
	"غ"
	"ǡԹ"
	"Ǥԡ"
	"ǫŹ"
	"ǵ͹"
	""
	"ó"
	"ѵ"
	"ѵ"
	"ҵ"
	""
	""
	""
	"ѹ"
	""
	"Ե"
	""
	""
	"ȹ"
	"⤵Թ"
	"ø"
	"ź"
	""
	""
	""
	""
	"͹"
	""
	""
	"֡"
	"֧"
	""
	"ا"
	"ت"
	""
	""
	""
	""
	"ٹ"
	""
	""
	""
	"º"
	"ô"
	""
	"ͧ"
	""
	"ҹ"
	"ͧ"
	""
	""
	"˹"
	"˹"
	""
	""
	""
	""
	""
	""
	""
	"Թ"
	""
	""
	""
	"Ե"
	"Ը"
	""
	"ѵ"
	"è"
	"èó"
	"è"
	"èǺ"
	"è"
	"ó"
	"óҡ"
	"óҤ"
	"óҸԡ"
	"óҹء"
	"óѡʵ"
	"óѡ"
	"ô"
	"÷"
	"÷Ѵ"
	"÷ء"
	"þ"
	"þ"
	"þԵ"
	"þ"
	"þ"
	"§"
	"§"
	"ҡ"
	""
	""
	""
	"ѷ"
	"Դ"
	""
	"ŧ"
	""
	"蹴"
	"ԡ"
	"ԡ"
	"Ԣ"
	"Ԥ"
	"ԨҤ"
	"Ԩԡ"
	"Ժ"
	"Ժó"
	"Ծѵ"
	"Ծ"
	"ѳ"
	""
	"ѡ"
	"Ҫ"
	""
	"ѷ"
	"ط"
	""
	"੷"
	"൹"
	"ǳ"
	""
	"͡"
	"ǡ"
	"ǧ"
	"Ǫ"
	"ǹ"
	"Ǻ"
	""
	""
	""
	"͡"
	"ʹ"
	"͹"
	"ͺ"
	""
	""
	""
	"ٹ"
	""
	"ѡ"
	"Ѥ"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѧѺ"
	"ѧء"
	"ѧ"
	"ѧҨ"
	"ѧ¹"
	"ѧԭ"
	"ѭ"
	"ѭ"
	"ѭ"
	"ѭѵ"
	"ѳԵ"
	"ѳԵ"
	"ѳ"
	"ѳ"
	"ѳ"
	"ѳ"
	"ѳ"
	"ѳС"
	"ѳ"
	"Ѵ"
	"Ѵ"
	"Ѵ"
	"ѵ"
	"ѹ"
	"ѹ"
	"ѹкѹѧ"
	"ѹ"
	"ѹԧ"
	"ѹ"
	"ѻ"
	"Ѿ"
	"š"
	"ѧ"
	"ٹ"
	""
	""
	""
	""
	""
	"ҡ"
	"ҧ"
	"Ҵ"
	"Ҵѡ"
	"Ҵ"
	"ҵ"
	"ҵ"
	"ҷ"
	"ҷ"
	"ҷǧ"
	"ҷҸ֡"
	"ҷء"
	"ҹ"
	"ҹ"
	"ҹ"
	"ҹ"
	"ҹ"
	"ҹ"
	"һ"
	""
	""
	""
	""
	""
	""
	""
	"ʡ"
	"ࡵ"
	""
	"ӹҭ"
	"ӺѴ"
	"Һ"
	""
	"ا"
	""
	""
	""
	"˹"
	""
	"԰"
	"Գҵ"
	"Դ"
	"Դ"
	"Դ"
	"Թ"
	""
	"´"
	""
	""
	"ձ"
	"պ"
	""
	"֡"
	"ֹ֡"
	"֧"
	""
	""
	""
	"ء"
	"ءɡ"
	"ؤ"
	"ؤҡ"
	"ؤҸɰҹ"
	"ؤԡ"
	"ؤԡҾ"
	"ح"
	"حҹҾ"
	"حԹ"
	"سԡ"
	"س"
	"ص"
	"ص"
	"غ"
	"ػҵ"
	"ؾ"
	"ؾ"
	"ؾԨ"
	"ؾҵ"
	"ؾѡԳ"
	"ؾԵ"
	"ؾ"
	"ؾҨ"
	"ؾѹ"
	"þ"
	"þ"
	"þҨ"
	"ҳ"
	""
	""
	"Է"
	""
	""
	"ɡ"
	"ɺ"
	"ɺ"
	""
	"Ҥ"
	"˧ѹ"
	"˧"
	"ç"
	""
	"ѹ"
	"÷"
	""
	""
	""
	""
	"٪"
	"٪ѭ"
	"ٴ"
	"óҾ"
	"ó"
	"þ"
	"þҨ"
	""
	""
	""
	""
	""
	""
	"ǧ"
	""
	"ͧ"
	"͹"
	""
	""
	"ҧ"
	""
	""
	"ǹ"
	"ͧ"
	"ͧ"
	""
	""
	"ҧ"
	"ҹ"
	""
	""
	""
	"ͧ"
	""
	""
	""
	""
	""
	""
	""
	"ó"
	""
	"Գ"
	"ѡ"
	"ԡó"
	"ԡ"
	"ԡ"
	"ԡ"
	"Ԥ"
	"Ԫǹ"
	"ԭ"
	"ԭҳ"
	"ԷԹ"
	"Ժ"
	"Ժѵ"
	"Ի"
	"Իѡ"
	"Ծѷ"
	"Ծҡ"
	"Ҥ"
	"ҳ"
	""
	"ҡ"
	"ط"
	"ٻ"
	"ѵ"
	"ҵ"
	"ҷ"
	"ʹ"
	"ѧó"
	"ѹ"
	"ѹ"
	"Ǹ"
	"ʸ"
	""
	""
	""
	"ȹ"
	""
	"Һ"
	"ġ"
	""
	"ȹ"
	""
	"Ըҹ"
	""
	""
	"ҹء"
	""
	""
	"Ѵ"
	""
	""
	""
	"á"
	"á"
	"ç"
	"ù"
	"ùԺѵ"
	"ù"
	"ú"
	"ûѡ"
	"ѵ"
	"Ҩ"
	"ҳ"
	"ɡ"
	""
	"Ǵ"
	"ǹ"
	"ҷ"
	"Ե"
	"ͧͧ"
	"ʹ"
	"ͷ"
	""
	""
	"С"
	"СǴ"
	"Сͺ"
	"Сѹ"
	"СѺ"
	"С"
	"С"
	"С"
	"Сȹºѵ"
	"СԵ"
	"СԵ"
	"Ф"
	"Ф˧"
	"Фͧ"
	"Ф"
	"Ш"
	"ШǺ"
	"Шѡ"
	"Шѭ"
	"Шѹ"
	"ШҤ"
	"Шҹ"
	"Ш"
	"Ш"
	"Ш"
	"Шͻ"
	"Ъ"
	"Ъ"
	"Ъѹ"
	"Ъ"
	"ЪҸԻ"
	"ЪԺ"
	"ЪԴ"
	"Ъ"
	"г"
	"г"
	"г"
	"гԸ"
	"гҹ"
	"гյ"
	"д"
	"дǹ"
	"д͹"
	"дѡԴ"
	"дѧ"
	"дѺ"
	"д"
	"дһ"
	"д"
	"дԴд"
	"дԷԹ"
	"дɰҹ"
	"дɰ"
	"дا"
	"дب"
	"д"
	"е"
	"ж"
	"зǹ"
	"зѡ"
	"зѧ"
	"зѴ"
	"зѺ"
	"зҹ"
	"зԹ"
	"з"
	"зջ"
	"зع"
	"з"
	"з"
	"зǧ"
	"иҹ"
	"иҹҸԺ"
	"й"
	"й"
	"йջй"
	"л"
	"л"
	"оĵ"
	"оĸ"
	"оѷ"
	"оѹ"
	"оҵ"
	"о"
	"о"
	"оԳ"
	"оط"
	""
	""
	"Ҥ"
	"Ҿ"
	""
	""
	"ǭ"
	""
	"ҳ"
	"ҷ"
	"آ"
	"ط"
	""
	"ء"
	"ط"
	""
	""
	""
	"ҵ"
	"õ"
	"õ"
	"ѵ"
	"ѵԡó"
	"ѵʵ"
	"ҵ"
	""
	""
	"ԧ"
	"Ԫ"
	"Ե"
	"ճ"
	""
	"ʹ"
	"ʡ"
	"ʧ"
	"ʺ"
	"ʺó"
	"ʾ"
	""
	"ҷ"
	"ҹ"
	"ԷԼ"
	"ԷҾ"
	"Է"
	"ٵ"
	""
	"Ҵ"
	""
	""
	"ह"
	"ਡ"
	"Դ"
	""
	""
	"§"
	""
	"ǻд"
	""
	""
	"Ҫ"
	"ͧ"
	"ླ"
	""
	"Թ"
	"ǳ"
	""
	"ȹ"
	"԰"
	"ᡡ"
	""
	"¤"
	"ѡ"
	"ѧ"
	"Ѫ"
	"ѵصѹ"
	"ѵغѹ"
	"ѹ"
	"Ѻ"
	""
	"ȹ"
	""
	""
	"ҡ"
	"ҡ"
	"ҡ"
	"ҡ"
	"Ҥ"
	"ҧ"
	"ҧ"
	"Ҩչ"
	"Ҫ"
	"Ҫ"
	"Ҫ"
	"ҪԵ"
	"ҳ"
	"ҳ"
	"Ҵ"
	"ҹ"
	"Һ"
	"Һɡ"
	"һ"
	""
	""
	""
	""
	"ö"
	""
	""
	""
	""
	""
	"ɳ"
	"ҳ"
	"ҷ"
	""
	""
	""
	""
	"ԡ"
	"Ԥ"
	"ԨҤ"
	"Ԩԡ"
	"ԫ"
	"ԭ"
	"Գ"
	"Գ¡"
	"Ե"
	"Ե"
	"Ե"
	"Էȹ"
	"Էȹ"
	"ԹԾҹ"
	"Ժ"
	""
	"ҳ"
	"ҵ"
	"ѵ"
	""
	"õ"
	""
	"ȹ"
	"੷"
	""
	"ժ"
	"մ"
	"մ"
	""
	""
	""
	"֡"
	"ѷ"
	""
	""
	""
	"ا"
	"ٴ"
	"괻Ҵ"
	""
	"š"
	""
	""
	"Ĩ"
	"ɮҧ"
	"š"
	"ŧ"
	"Ŵ"
	"ǡ"
	"͡"
	"ʹ"
	"ͺ"
	""
	""
	"ѡ"
	"Ѵ"
	""
	""
	""
	"ҵ"
	"Һ"
	""
	""
	"ʹҡ"
	""
	"ԧ"
	"Դ"
	""
	"⾸"
	""
	""
	"ա"
	""
	"ء"
	"١"
	""
	"ͧ"
	""
	""
	"ͧ"
	"͹"
	""
	"ǡ¡"
	"ǧ"
	"Ǵ"
	"ó"
	""
	""
	"͡"
	"ͧ"
	"ʹ"
	"͹"
	"͹"
	"ͺ"
	""
	""
	""
	"С"
	"з"
	"з"
	"˧Ѻ"
	""
	""
	"ѡ"
	"ѡ"
	"ѡҹ"
	"ѡԳ"
	"ѡ"
	"ѡ"
	"ѧ"
	"Ѩѹ"
	"Ѩѹ"
	"Ѩѹ"
	"Ѩѹ"
	"Ѩ"
	"ѨԵ"
	"Ѩغѹ"
	"Ѩ"
	"Ѩ"
	"Ѩਡ"
	"ѭѤ"
	"ѭ"
	"ѭ"
	"Ѵ"
	"ѵ"
	"ѷ"
	"ѹ"
	"Ѻ"
	"ѻ"
	""
	""
	""
	""
	""
	""
	""
	"ҡ"
	"ҡ"
	"ҡʶҹ"
	"ҧ"
	"ү"
	"Ұ"
	"Ұ"
	"ҳҵԺҵ"
	"Ҵ"
	"ҵ"
	"ҷѧ"
	"ҷͧ"
	"ҹ"
	"һ"
	""
	""
	"Ҫԡ"
	"ԩѵ"
	"Ԫҵ"
	""
	""
	"ࡵ"
	""
	""
	""
	""
	"˹ѹ"
	""
	""
	""
	"ԡԡ"
	"ԧͧ"
	"Ԯ"
	"Դ"
	"Ե"
	"Ե"
	"Ե"
	"Եئҵ"
	"Ե"
	"Ե"
	"Ե"
	""
	"Ҩ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ա"
	"չ"
	"պ"
	""
	"Ҩ"
	""
	""
	""
	""
	""
	"֡"
	""
	""
	""
	"׹"
	""
	""
	""
	"ء"
	"ب"
	"ش"
	"ضت"
	"غ"
	""
	"Ե"
	""
	"駡"
	""
	""
	""
	""
	""
	""
	"٪ºؤ"
	"٪ѵ"
	"ٴ"
	"ٹ"
	""
	""
	""
	"ǳ"
	""
	"ǧ"
	"ǹ"
	""
	"ͧ"
	""
	"ҹ"
	""
	"ǹ"
	"ǹ¹"
	""
	"ͧ"
	"͹"
	""
	""
	""
	""
	"ҧ"
	"ҹ"
	"Һ"
	""
	""
	"Һ"
	""
	""
	""
	""
	""
	""
	""
	""
	"Ҵ"
	""
	""
	""
	"ا"
	"ǡ"
	"Ǫ"
	"ѧ"
	"֡"
	""
	"ͺ"
	"ͧ"
	"ҷ"
	""
	""
	"ѡ"
	"Ѵ"
	""
	"ҭ"
	"ҹʧ"
	"Ҽ"
	""
	""
	"Ե"
	"ռ"
	"֡"
	""
	""
	"ا"
	"ش"
	"ع"
	"غ"
	""
	""
	""
	"ǹ"
	""
	""
	""
	"ҹ"
	""
	"͡"
	"ͧ"
	"ʹ"
	"ͺ"
	""
	"Ǵ"
	"ٹ"
	""
	"ѡ"
	"ѧ"
	"Ѵ"
	"ѹ"
	"Ѻ"
	""
	""
	""
	"ҡ"
	"ҧ"
	"ҳԵ"
	"Ҵ"
	""
	""
	"ԧ"
	"Դ"
	"Թ"
	""
	""
	"֧"
	""
	""
	"׹"
	""
	""
	"ش"
	"¼"
	"١"
	""
	""
	"ͧ"
	"͹"
	""
	""
	"ҹ"
	"¼"
	""
	""
	""
	""
	""
	""
	"ѡ"
	"ѧ"
	"Ѵ"
	"ѹ"
	""
	""
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҹ"
	""
	""
	""
	"֡"
	"״"
	"׹"
	""
	"٧"
	""
	""
	""
	""
	""
	""
	""
	"Ǵ"
	""
	""
	""
	"ҹء"
	"ö"
	""
	""
	"ҹ"
	""
	""
	""
	"Ԫ"
	"Ԫ"
	""
	""
	""
	"ѡ"
	"ѡҹ"
	"ѧ"
	"ѹ"
	""
	""
	"Ҥ"
	""
	""
	"Ԫ"
	"Դ"
	""
	""
	"¹"
	""
	"ѡ"
	"ѡԴ"
	"Ѥ"
	"ѤԹ"
	"Ѥ"
	"Ѥ"
	"ѭ"
	"ѵ"
	"Ѻ"
	"ҡó"
	"ҧ"
	"Ҹ"
	"ҹ"
	"Һҷ"
	"Һ"
	""
	""
	"ا"
	"ҵ"
	""
	"ʹ"
	""
	"õ"
	""
	"ä"
	"ä"
	"ó"
	"ó"
	""
	""
	"Ǵ"
	"ǹ"
	""
	""
	"Գ"
	""
	"ʹ"
	""
	"ѡ"
	"Ѵ"
	""
	""
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҹ"
	""
	""
	""
	""
	"ԡ"
	"Ժ"
	""
	""
	"֧"
	"ֹ"
	"ֺ"
	"״"
	""
	"ء"
	"ع"
	""
	""
	"ٴ"
	"ͧ"
	""
	""
	""
	"ҧ"
	""
	"ͧ"
	""
	"ѡ"
	""
	""
	""
	"ġɪҵ"
	"ġɷ"
	"ġҪ"
	"ġʵ"
	"ġ"
	"ġǴ"
	"ġ"
	"Ĳ"
	"Ĳ"
	"ĲҨ"
	"Ĳ"
	"ĵ"
	"ĵ"
	"ĵԡ"
	"ĵԡó"
	"ĵԹ"
	"ķ"
	"ķ"
	"Ĺ"
	"Ĺ"
	"Ȩ"
	"Ȩס¹"
	""
	"Ҥ"
	""
	"ʺ"
	""
	"š"
	"Ť"
	"ź"
	"ǧ"
	"֡"
	"ͧ"
	"ʹ"
	""
	""
	""
	"ѧ"
	"Ѵ"
	"ѹ"
	"Ѻ"
	"Ѻ"
	"Ѻ֧"
	""
	""
	""
	""
	"ҡ"
	"ҧ"
	"ҫ"
	"Ҵ"
	"Ҹԡ"
	"ҹ"
	""
	""
	"ʵԡ"
	""
	"ˡ"
	"ԡ"
	""
	""
	""
	"ء"
	""
	""
	""
	""
	"ͧ"
	"š"
	""
	""
	"ҹ"
	""
	""
	"ǡ"
	"ǧ"
	"ǹ"
	""
	"ʡ"
	"ظ"
	""
	""
	""
	"پ"
	"ٵ"
	""
	"͡"
	"ͧ"
	""
	"ٹ"
	"اѧ"
	"ǧ"
	"ѡǹ"
	"Ҿѧ"
	"ͧ"
	"״"
	"§"
	"Ҿй"
	"Ժ"
	"ԺҺ"
	"ṧ"
	""
	"ѡ"
	"ѡ"
	"ѧ"
	"ѧ"
	"ѧ״"
	"ѧ"
	"ѧ͹"
	"ѧҺ"
	"ѧ"
	"Ѫ"
	"Ѳ"
	"Ѳ"
	"Ѵ"
	"ѵ"
	"ѷ"
	"ѷ"
	"ѷا"
	"ѹ"
	"ѹó"
	"ѹҡ"
	"ѹѵ"
	"ѹԵ"
	"ѹ"
	"ѹ"
	"ѹ"
	"ѹ"
	"Ѻ"
	""
	"ѹ"
	""
	""
	"ȴ"
	"ȵ"
	"ʴ"
	"ʶҹ"
	""
	"ҡ"
	"ҡ"
	"ҧ"
	"ҳ"
	"ҳԪ"
	"ҳԪ"
	"ҳԪ"
	"ҳ"
	"ҳչ"
	"Ҵ"
	"ҵ"
	"ҷ"
	"ҷ"
	"Ҹ"
	"Ҹ"
	"ҹ"
	"ҹ"
	""
	""
	"Ѿ"
	""
	"ó"
	"ҿԹ"
	""
	""
	""
	""
	"ʹ"
	"ʹ"
	"ء"
	"˹"
	""
	""
	""
	"Ѵ"
	""
	""
	""
	""
	"ԡ"
	"ԡѴ"
	"ԡѵ"
	"ԡ"
	"ԡ"
	"Ԧҵ"
	"Ԧ"
	"ԧ"
	"Ԩó"
	"ԨԵ"
	"Ԫ"
	"Ԫҹ"
	"ԪԵ"
	"Գ"
	"ԶվԶѹ"
	"Է"
	"Էѡ"
	"Ըҹ"
	"Ը"
	"Թ"
	"Թͺ"
	"Թ"
	"Թ"
	"ԹԨ"
	"ԹԵ"
	"Թ"
	"Ժѵ"
	"Ժ"
	"ԾѡԾǹ"
	"ԾѲ"
	"Ծҡ"
	"Ծҡ"
	"Ծҷ"
	"ԾԸ"
	"ԾԸѳʶҹ"
	"ԾԸѳ"
	""
	""
	""
	"ҹ"
	"آ"
	"ʹ"
	"ʹ"
	"Һ"
	""
	""
	"س"
	"ظ"
	"һ"
	""
	"֡"
	"֡֡"
	"֡"
	""
	""
	"ǧ"
	""
	""
	"ط"
	"ط"
	""
	"ɳš"
	"ɴ"
	"ʧ"
	""
	""
	"԰"
	"ط"
	"٨"
	""
	""
	""
	""
	"¡ࡹ"
	"¤"
	"ø"
	""
	""
	""
	"ժԵ"
	""
	""
	"֧"
	""
	""
	""
	"ת"
	"״"
	""
	""
	"ء"
	"ا"
	"ز"
	"ز"
	"ش"
	"ط"
	"ط"
	"ط"
	"ط"
	"ط"
	"ط"
	"ظ"
	""
	""
	""
	""
	"ٴ"
	"ٹ"
	""
	""
	""
	"๨"
	""
	"ǧ"
	""
	"ҧ"
	"ҹ"
	""
	""
	""
	""
	"ͧ"
	""
	""
	"´"
	"ҹʵ"
	""
	"ù"
	""
	"չ"
	"͡"
	"ͧ"
	"ʹ"
	"͹"
	"͹"
	"Ŵδ"
	"Թ"
	"ʿ"
	"࿵"
	"ѡ"
	"ѧ"
	"ѧ"
	"Ѵ"
	"ѹ"
	""
	""
	"ҡ"
	"ҧ"
	"Ҵ"
	"ҷ"
	"ҹ"
	""
	""
	"ԡ"
	"Դ"
	"ԹŹ"
	"Ժ"
	"ԻԹ"
	""
	""
	"ԡ"
	""
	""
	""
	""
	""
	"ص"
	"ع"
	"غ"
	"ؿ"
	""
	""
	""
	""
	"١"
	""
	""
	""
	""
	"ͧ"
	"͹"
	"ҧ"
	""
	""
	"ͧ"
	"͹"
	""
	""
	""
	""
	"ѹ"
	"õ"
	""
	"Ҵ"
	""
	"ǵѳ"
	"ѧ"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѳ"
	"ѵ"
	"ѷ"
	"Ѿ"
	""
	"ʴ"
	"ʵ"
	"Ҥ"
	"Ҥ"
	"Ҫ"
	"ҳ"
	"Ҿ"
	""
	""
	"ô"
	"õ"
	""
	""
	"ǹ"
	""
	""
	"ɡ"
	"ɳ"
	""
	"Ե"
	""
	"ʡ"
	"ʹ"
	""
	"ԡ"
	"ԡҨ"
	"ԡ"
	"ԡع"
	"ԡ"
	"ԡ"
	"ԡس"
	"ԧ"
	"ԭ"
	"Թҡ"
	"Թ"
	""
	"ت"
	"ت"
	""
	"Թ"
	""
	""
	"ٵ"
	""
	"Ի"
	"Ծ"
	"Ҥ"
	""
	"ʵ"
	""
	""
	"Ǵ"
	"ǹҶ"
	"๵"
	""
	"Ե"
	""
	""
	""
	"Ҥ"
	"د"
	""
	"د"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ԡ"
	""
	""
	""
	"ªҵ"
	"¸"
	"ʵ"
	"ѹ"
	"෾"
	"š"
	""
	""
	""
	""
	""
	""
	""
	""
	"á"
	"ó"
	"ó"
	"ô"
	"ä"
	"ä¡"
	"ô"
	"ҷ"
	""
	"Ĥ"
	"ĵ"
	""
	"ŷԹ"
	""
	""
	"ҧ"
	"ǹ"
	""
	""
	"ˡ"
	"Ҥ"
	"ó"
	"ʾ"
	"ѹ"
	"ѹ"
	"Ȩ"
	""
	"Ҵ"
	"Ҵ"
	"ҵ"
	"ҹ"
	"Ҫ"
	"Է"
	""
	"ط"
	"ԧ"
	"ԧ"
	"Դ"
	""
	""
	""
	"ͧ"
	"ͧ´"
	"ͭ"
	"ʹ"
	"ͺ"
	""
	""
	"ͤ"
	"չ"
	""
	""
	""
	""
	"Сٴ"
	"С͡"
	"Сù"
	"ТԴ"
	"Т"
	"Ф"
	"Ч"
	"ЧЧ"
	"дѹ"
	"ек"
	"е"
	"й"
	"лҧ"
	"о"
	"оѺ"
	"оٴ"
	"ǧ"
	""
	""
	"׹"
	"С"
	""
	"Ѵ"
	"͡ҹ"
	""
	""
	""
	"ͧ"
	""
	""
	""
	"ç"
	""
	"ѡ"
	"ѡѹ"
	"Ѥȡ"
	"Ѥ¡"
	"Ѧҹ"
	"ѧ"
	"ѧش"
	"ѧ"
	"Ѩ"
	"Ѩ"
	"Ѫҹ"
	"Ѫ"
	"Ѫ"
	"ѳŻ"
	"ѳ"
	"Ѵ"
	"ѵ"
	"ѷ"
	"ѷ"
	"ѷ"
	"Ѹ°ҹ"
	"Ѹ"
	"Ѹʶ"
	"ѹ"
	"Ѻ"
	""
	""
	"ԡ"
	""
	""
	"ʵ"
	""
	"Դ"
	"Թ"
	""
	""
	""
	""
	"ҡ"
	"Ҧ٪"
	"Ҧ"
	"ҳ"
	"ҳԡ"
	"Ҵ"
	"ҵ"
	"ҵ"
	"ҵ"
	"ҵ"
	"ҹ"
	"ҹ"
	"ҹ"
	"ҹԵ"
	"ҹ"
	"ҹ"
	"ҹԷ"
	"Һ"
	""
	""
	""
	""
	""
	"ô"
	"ô"
	"ô"
	""
	"ҷ"
	""
	"ص"
	""
	""
	""
	""
	""
	""
	""
	"⹪"
	""
	"Ԥѭ"
	"Ԩ"
	"Դ"
	"Ե"
	"Ե"
	"Զع¹"
	"ѹ"
	""
	"ԡ"
	"Ժ"
	"Ե"
	""
	"ҵ"
	"ʪ"
	""
	""
	""
	""
	"մ"
	"չ"
	"չҤ"
	"෹"
	""
	""
	"֧"
	"ֹ"
	"״"
	"׹"
	""
	""
	""
	""
	"ء"
	"ء"
	"آ"
	"ا"
	"بԹ"
	"رԵ"
	"ش"
	"صԴ"
	"ط"
	"عԹ"
	"ع"
	"غ"
	"غԺ"
	""
	""
	""
	""
	""
	""
	""
	"١"
	"ٵ"
	"ٹ"
	""
	""
	"Űҹ"
	"ŹԸ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ʾ"
	"з֡"
	""
	""
	"ǧ"
	"ǹ"
	"͵"
	""
	""
	"ҹ"
	""
	"ǹ"
	""
	""
	"ҹ"
	""
	"¡"
	"§"
	"§"
	"µ"
	"¶ҡ"
	"¹"
	"¹"
	""
	""
	"§"
	"Ԩá"
	""
	"ǧ"
	"Ǵ"
	"ǹ"
	"Ǻ"
	""
	""
	"͡"
	"ͧ"
	"ʹ"
	"͹"
	"ͺ"
	""
	""
	"ѡ"
	"ѡԹ"
	"ѡ"
	"ѡԳ"
	"ѡ"
	"ѡ"
	"ѧ"
	"Ѵ"
	"Ѵ´"
	"ѹ"
	"ѹá"
	"ѹ"
	"ѹ"
	"Ѻ"
	"׹"
	""
	""
	""
	""
	""
	"ҡ"
	"ҧ"
	"Ҩ"
	"Ҵ"
	"Ҵ"
	"ҵ"
	"ҵ"
	"ҹ"
	"ҹ"
	"Һ"
	""
	""
	""
	""
	"ԡ"
	"ԧ"
	"Թ"
	"Ժ"
	"Ի"
	"Ի"
	""
	""
	""
	""
	""
	"չ"
	"ҿ"
	""
	"ʡ"
	"ʧ"
	""
	"ҹ"
	""
	""
	""
	"֡"
	"ִ"
	"״"
	"׹"
	""
	""
	""
	""
	"ء"
	"ؤ"
	"ؤ"
	"ا"
	"ش"
	"ص"
	"ط"
	"ط"
	"ط"
	"ط⸻ó"
	"غ"
	"ؾ"
	"ؾ§"
	"ؾҪ"
	"ؾ"
	"ؾ"
	"ҵ"
	"Ǫ"
	"û"
	""
	""
	""
	""
	""
	""
	"٧"
	"ҵ"
	"ԡ"
	"ù"
	""
	""
	""
	""
	""
	""
	""
	"ͧ"
	""
	""
	""
	""
	"ҧ"
	"ҹ"
	""
	""
	""
	"͹"
	""
	""
	""
	""
	"á"
	"ç"
	"çѵ"
	"ç"
	"è"
	"èԵ"
	"èè"
	"èŢ"
	"ó"
	"ô"
	"ô"
	"õ"
	"õ"
	"ö"
	"ù"
	"ú"
	"þ"
	"þ"
	""
	""
	""
	"ҧ"
	"ǡ"
	"ǧ"
	"Ǵ"
	"ǹ"
	"ǹ"
	"Ǻ"
	""
	""
	""
	""
	"ȹ"
	""
	"ʹ"
	"¹Ƿ"
	"ԡ"
	""
	"Ե"
	""
	"͡"
	"ͧ"
	"ͧ"
	"ʹ"
	"͹"
	"ͺ"
	"ͺͺ"
	""
	""
	""
	"Ф"
	"Ф"
	"Цѧ"
	"Ч"
	"ЧѺ"
	"д"
	"дѺ"
	"д"
	"з"
	"з֡"
	"йҴ"
	"йҺ"
	"й"
	"к"
	"к"
	"кͺ"
	"кѺ"
	"кҭ"
	"кҴ"
	"к"
	"к"
	"к"
	"к"
	"к"
	""
	"Ѻ"
	""
	""
	"ԡ"
	"֡"
	"ѧ"
	"ҧ"
	"ҧ"
	""
	""
	""
	"๹"
	"йҴ"
	"´"
	"Դ"
	"§"
	"¹"
	"º"
	""
	""
	""
	"Դ"
	""
	""
	"ṧ"
	"ǧ"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѧ"
	"ѧ"
	"Ѩ"
	"Ѫ"
	"Ѫɡ"
	"Ѫ"
	"ѭǹ"
	"Ѱ"
	"Ѱ٭"
	"Ѱ"
	"Ѱ"
	"Ѱʵ"
	"Ѱ"
	"Ѱ"
	"ѰˡԨ"
	"Ѱʵ"
	"Ѱ"
	"Ѵ"
	"ѵ"
	"ѵ"
	"ѵ"
	"ѵ"
	"ѵѧ"
	"ѵ"
	"ѵ"
	"ѵԹ"
	"ѵ"
	"Ѷ"
	"ѹ"
	"Ѻ"
	""
	""
	""
	"ѵ"
	"ҹ"
	""
	"ɮҡ"
	""
	""
	""
	""
	""
	""
	"ҡ"
	"ҡ"
	"Ҥ"
	"Ҥ"
	"ҤԹ"
	"Ҥ"
	"ҧ"
	"ҧҧ"
	"ҧ"
	"Ҫ"
	"Ҫԡ"
	"ҪѳԵʶҹ"
	"Ҫ"
	"Ҫç"
	"Ҫ"
	"Ҫѹ"
	"Ҫ"
	"ҪҸҪ"
	"Ҫҹԡ"
	"Ҫɡ"
	"ҪǴ"
	"ҪԹ"
	"Ҫٻ"
	"ҭ"
	"Ҵ"
	"ҵ"
	"ҵ"
	"ҵ"
	"ҹ"
	"Һ"
	"Ҿ"
	""
	""
	"ѭ"
	"ҸԺ"
	"õ"
	""
	""
	""
	""
	"ɮ"
	"ɮ"
	""
	"હ"
	"ҷ"
	""
	"Ӥҭ"
	"֡"
	""
	""
	"ԡ"
	"Դմǧ"
	"Թ"
	"Ժ"
	"Ժ"
	""
	""
	""
	""
	""
	"մ"
	"յ"
	"պ"
	""
	""
	""
	"֧"
	""
	""
	""
	""
	"ء"
	"ء"
	"ءҵ"
	"ء"
	"ءǴ"
	"ء"
	"اѧ"
	"ب"
	"ب"
	"ش"
	"ص"
	"ط"
	"ط"
	"ع"
	"غ"
	""
	"ɮ"
	""
	""
	""
	""
	""
	""
	""
	""
	"ٴ"
	"ٻ"
	""
	""
	""
	"絵"
	""
	""
	""
	""
	"ǧ"
	"ǹ"
	""
	""
	"ͧ"
	"͹"
	""
	""
	"ҧ"
	"ҹ"
	""
	""
	""
	"ͧ"
	"͹"
	""
	""
	"ҧ"
	"ҹ"
	""
	""
	"ġ"
	"Ī"
	"Ī"
	"ĳ"
	"Ĵ"
	"Ĵ"
	"ĵ"
	"ķ"
	"ķ"
	"ķ"
	""
	""
	"ŧ"
	"Ŵ"
	"Ŵ"
	"Ŵ"
	"Ź"
	"ź"
	""
	"Ź"
	"ү"
	"Ե"
	"ǡ"
	"ǧ"
	"Ǵ"
	"ǹ"
	"ǹ"
	""
	""
	"͡"
	"͡Է"
	"ͧ"
	"ͧԨٴ"
	"ʹ"
	"͹"
	"ͺ"
	""
	""
	""
	""
	"Ф"
	"еԨٴ"
	"кѴ"
	"ع"
	""
	""
	""
	"Ҵ"
	"ҹ"
	""
	"ͧ"
	""
	""
	"Դ"
	"´"
	"ŧ"
	"ԧ"
	"´"
	"ǧ"
	""
	"´"
	"ǡ"
	""
	""
	""
	"ѡ"
	"ѡ"
	"ѡɳ"
	"ѡ"
	"Ѥ"
	"Ѥ"
	"Ѥ"
	"ѧ"
	"ѧ"
	"Ѫ"
	"Ѫ"
	"ѭ"
	"ѭ"
	"ѭ"
	"ѭ"
	"ѭ"
	"Ѵ"
	"Ѵ"
	"ѷ"
	"ѷ"
	"ѹ"
	"Ѻ"
	"Ѿ"
	""
	""
	"蹷"
	""
	"ҡ"
	"ҧ"
	"ҭ"
	"Ҵ"
	"ҹ"
	"Һ"
	"һ"
	""
	""
	""
	""
	""
	"Ź"
	""
	""
	"ǡ"
	"ѳ"
	"ʹ"
	""
	"Ӵǹ"
	"Ӻҡ"
	"Ӿǹ"
	"آѹ"
	""
	"¡"
	""
	""
	"ԡ"
	"§"
	"⾧"
	""
	""
	"ԡ乵"
	"ԢԷ"
	"ԢԵ"
	"ԧ"
	"ԧ"
	"Դ"
	"Ե"
	"Ե"
	"Ե"
	"ԹԹ"
	"Ժ"
	"Ի"
	"Ի"
	"Իʵԡ"
	"Ի"
	"Կ"
	"Ե"
	""
	"ʧ"
	""
	""
	""
	""
	""
	"鹨"
	""
	""
	"պ"
	""
	""
	""
	""
	"֡"
	"֧"
	"״"
	"׺"
	""
	""
	""
	""
	""
	""
	""
	"ء"
	"ا"
	""
	""
	""
	""
	""
	""
	"١"
	"١ȡ"
	"ٺ"
	"ٻ"
	""
	"͡ࡵ"
	""
	""
	"ǧ"
	""
	""
	"ͧ"
	"͹"
	""
	""
	""
	""
	"ҧ"
	"ҹ"
	""
	""
	""
	""
	""
	"ǧ"
	"ǹ"
	""
	""
	""
	"ҧ"
	"ҵ"
	"ҹ"
	""
	"ǡ"
	"ǡ"
	"ǧ"
	"ǧ"
	"ǧ"
	"ǧȡ"
	"ǧ"
	"ǧ"
	"ǧ"
	"Ǩ"
	"Ǩ"
	"Ǩ"
	"Ǫ"
	"Ǫ"
	"Ǫظ"
	"ǳѵ"
	"ǳѹ"
	"ǳ"
	"ǳԪ"
	"ǳԪ"
	"ǳԪ"
	"ǳԪ"
	"ǳԾ"
	"Ǵ"
	"ǵ"
	"Ƿ"
	"Ƿѭص"
	"Ǹء"
	"Ǹ"
	"ǹ"
	"ǹ"
	"ǹ"
	"ǹҹ"
	"ǹԴ"
	"ǹԾ"
	""
	"ç"
	"ó"
	""
	"ä"
	"ä"
	"ê"
	"ê"
	"ó"
	"ó"
	"ó"
	"ó"
	"óĵ"
	"óء"
	"óص"
	"óŻ"
	"ó"
	"ó֡"
	"ø"
	"ø"
	""
	""
	""
	"ѭ"
	"ҧ"
	""
	""
	"س"
	"ѭ"
	""
	"ˡ"
	""
	""
	""
	""
	""
	"ѹš"
	"ѹ"
	""
	""
	""
	"ظ"
	"ع"
	""
	""
	""
	""
	"͡"
	"͡ǡ"
	"ʹ"
	"͹"
	""
	""
	""
	"ѡ"
	"ѡ"
	"Ѥ"
	"Ѥ"
	"Ѥ"
	"Ѥչ"
	"ѧ"
	"ѧ"
	"ѧǧ"
	"Ѩ"
	"Ѫ"
	"Ѫ"
	"Ѫ"
	"ѪԹ"
	"Ѫ"
	"ѯѡ"
	"ѯ"
	"ѯʧ"
	"Ѳ"
	"Ѳ"
	"Ѳ"
	"Ѳ"
	"Ѳ"
	"ѳ"
	"ѳ"
	"ѳ"
	"Ѵ"
	"ѵ"
	"ѵ"
	"ѵ"
	"ѵ"
	"ѵ"
	"ѵ"
	"ѵ"
	"ѵ"
	"ѹ"
	"ѹ"
	"ѹ"
	"ѹѵ"
	"ѹظ"
	"ѹ"
	"Ѻ"
	"ѻ"
	"ԡ"
	""
	""
	""
	""
	""
	"ʴ"
	""
	"ҹ"
	"ʷ"
	""
	"ҡѹ"
	"ҡ"
	"ҧ"
	"Ҩ"
	"Ҩ"
	"ҳԪ"
	"ҳԪ"
	"ҳ"
	"Ҵ"
	"ҵ"
	"ҵ"
	"ҷ"
	"ҷ"
	"ҷ¡"
	"ҷ"
	"ҷԵ"
	"ҷԹ"
	"ҷ"
	"ҹ"
	"ҹ׹"
	"ҹ"
	"ҹԹ"
	"ҹԪ"
	"Һ"
	"һ"
	"һԵ"
	"һ"
	""
	""
	""
	""
	""
	""
	""
	"س"
	"س"
	""
	""
	""
	"ʹ"
	"ʹ"
	"ʾ"
	""
	"Թ"
	""
	""
	"ԡ"
	"ԡĵ"
	"ԡĵ"
	"ԡ"
	"ԡԵ"
	"ԡѻ"
	"ԡ"
	"Ԥ"
	"ԧ"
	"Ԩص"
	"Ԩó"
	"Ԩ"
	"Ԩѡ"
	"Ԩѡɳ"
	"Ԩ"
	"Ԩ"
	"Ԩóҳ"
	"Ԩó"
	"Ԩ"
	"ԨԡԨ"
	"ԨԵ"
	"ԨԵ"
	"ԨԹ"
	"Ԩس"
	"Ԩó"
	"Ԫ"
	"Ԫ"
	"ԪŴ"
	"Ԫ"
	"Ԫ"
	"Ԫ"
	"Ԫҹ"
	"ԪԵ"
	"ԭѵ"
	"ԭҳ"
	"ԭ"
	"Ա"
	"Դ"
	"Ե"
	"Ե"
	"ԵԹ"
	"Զ"
	"Է°ҹ"
	"Է"
	"Է"
	"Էص"
	"Է"
	"Էó"
	"ԷŹ"
	"ԷԵ"
	"Է"
	"Է"
	"Ը"
	"Ը"
	"Ըҹ"
	"Ը"
	"Ըٻ"
	"Թѹ"
	"Թ"
	"Թҷ"
	"Թ"
	"ԹԨ"
	"ԹԨ"
	"ԹԵ"
	"ԹԺҵ"
	"ԹԻҵԡ"
	"Ժѵ"
	"Ժҡ"
	"Ժ"
	"Ժ"
	"Ժ"
	"Ժ"
	"Ի"
	"Ի"
	"ԻС"
	"Իе"
	"Իһ"
	"Ի"
	"ԻԵ"
	"Իһ"
	"Ի"
	"Ի"
	"Իѡ"
	"Իʡ"
	"Իʹ"
	"Ի¤"
	"Ծҡ"
	"ԾԸȹ"
	"ǵѳ"
	"ѧ"
	"Ѫ"
	"ѵ"
	""
	""
	"ѵ"
	"ص"
	"ص"
	"õ"
	""
	"ø"
	""
	"Ѫ"
	"ѵ"
	"ѵ"
	"Ҿ"
	""
	"ظ"
	"ˡ"
	""
	"ѹ"
	"Ҵ"
	"һ"
	"ѳ"
	""
	""
	"Թ"
	""
	"ó"
	""
	"ѯ"
	"Ѳҡ"
	"Ѳ"
	"ҷ"
	""
	""
	""
	"Ԩ"
	"Ե"
	"Ը"
	"ص"
	"ǡ"
	"ǡ"
	""
	"Ң"
	"Ң"
	"ҧ"
	""
	"ɰ"
	"ط"
	"ط"
	"ɳ"
	"ɸ"
	"ѵ"
	"ѡ"
	""
	"ҳ"
	"ʡ"
	"ê"
	"ĵ"
	"ء"
	"Ѫ"
	"ѭ"
	""
	"Ң٪"
	"Ң"
	"ѭ"
	""
	"ˡԨ"
	"԰"
	"ا"
	"ط"
	"ط"
	"ٵ"
	"ˤ"
	"˧"
	""
	""
	""
	"ԧ"
	"ԧ"
	"ѧ"
	""
	""
	""
	""
	""
	""
	"Ⱥ"
	"๵"
	"¹"
	"ù"
	"Ż"
	"ǡ"
	""
	"ɳ"
	"ʷ"
	""
	"⹷"
	""
	"¤"
	"è"
	"è"
	"ò"
	"ø"
	"ø"
	"Ũ"
	""
	""
	""
	""
	""
	"ը"
	"ժ"
	"ճ"
	""
	"á"
	"ê"
	"ú"
	"ʵ"
	"ѹ"
	""
	""
	"ذ"
	"ز"
	"ز"
	"ش"
	"غ"
	""
	""
	""
	""
	"ٴҴ"
	"ٸ"
	"ٺ"
	""
	""
	""
	"๨"
	"⹷ҹ"
	"á"
	"ô"
	"ͧ"
	"͹"
	""
	"ҧ"
	"ҹ"
	""
	""
	""
	"ҧ"
	""
	"ȡ"
	"ȵ"
	"Ⱦ"
	""
	"ѳ"
	"ѷ"
	""
	""
	""
	""
	"ħ"
	""
	""
	"͡"
	"ѡ"
	"ѡԹ"
	"ѡ"
	"ѡҾ"
	"ѡ"
	"ѡ"
	"ѡҪ"
	"ѵ"
	"Ѿ"
	"¡"
	"ʵ"
	"ᾷ"
	""
	"ҡ¾ط"
	"ҡع"
	"ҡ"
	"ҵҨ"
	"ҹ"
	"ҹ"
	"÷"
	"÷"
	""
	""
	"ʡ"
	"ʴ"
	"ʵ"
	"ʵҨ"
	"ʵ"
	"ʹѡ"
	"ʹ"
	"ʹٻ"
	"ʹ"
	"ԢԹ"
	"Ҫ"
	"Ż"
	"Ż"
	"Ż"
	"ŻԨ"
	"ŻԷ"
	"Żʵ"
	"Ż"
	"Żҡ"
	"ŻԹ"
	"Ż"
	"Ż"
	""
	"֧"
	""
	"Ƿ"
	""
	""
	"Һ"
	""
	"֡"
	"֡"
	"֡Ҹԡ"
	"֡ҹȡ"
	"ء"
	""
	"Ե"
	"ʴ"
	"ҵ"
	""
	"ѡ"
	"ҧ"
	""
	"šҡ"
	"šѡ"
	""
	"ٷ"
	"ٹ"
	"ʡ"
	"ʡ"
	"ʡá"
	"ʡ"
	"ʡҷ"
	"ʡѴ"
	"ʡ"
	"ʡ"
	"ʡ"
	"ʡس"
	"ʡس"
	"ʡس"
	"ʡع"
	"ʡ"
	"ʡ͵Ź"
	"ʧ"
	"ʧҹ"
	"ʧ"
	"ʧ"
	"ʧ"
	"ʧ"
	"ʧǹ"
	"ʧ"
	"ʧ"
	"ʧѯ"
	"ʧѴ"
	"ʧ"
	"ʧ"
	"ʳ"
	"ʴ"
	"ʴ"
	"ʴѺ"
	"ʴش"
	"ʵ"
	"ʵѿ"
	"ʵҧ"
	"ʵ"
	"ʵ"
	"ʵ"
	"ʶ"
	"ʶҹ"
	"ʶҹ"
	"ʶҹ"
	"ʶҺѹ"
	"ʶһ"
	"ʶһԡ"
	"ʶһѵ¡"
	"ʶҾ"
	"ʶ"
	"ʶԵ"
	"ʶԵʵ"
	"ʶԵ"
	"ʶٻ"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʹҤ"
	"ʹ"
	"ʹͧ"
	"ʹѺ"
	"ʹѺʹع"
	"ʹ"
	"ʹҹ"
	"ʹ"
	"ʹԷ"
	"ʹ"
	"ʹء"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʺ"
	"ʺ"
	"ʺ"
	"ʺ"
	"ʺ"
	"ʻԧ"
	"ʻࡵ"
	""
	"Ҿ"
	""
	""
	""
	""
	"ѡ"
	""
	""
	""
	"Ҥس"
	"ѵ"
	"óҭԷҪ"
	"ó"
	"д"
	"Ĵ"
	""
	""
	""
	""
	"ҵ"
	"ص"
	""
	"ö"
	"ö"
	""
	""
	"ͧ"
	"Ѥ"
	"Ѫ"
	"ѹ"
	""
	""
	"Ҥ"
	"Ҩ"
	"Ҫԡ"
	"Ҹ"
	"ҹ"
	"Һѵ"
	""
	"ԧ"
	"Ե"
	"ԵǪ"
	""
	"دҹ"
	"ش"
	"ط"
	"ط"
	"ع"
	""
	""
	"ྪ"
	"⾸"
	""
	""
	""
	"´"
	"º"
	""
	"ͧ"
	""
	""
	""
	""
	""
	"ç"
	"ó"
	"óҤ"
	"õ"
	""
	"ä"
	"þ"
	"þ"
	"þҧ"
	"Է"
	"ྪ"
	"ԭ"
	"ǧ"
	""
	""
	""
	"ҭ"
	"áԨ"
	"øҵ"
	"ʵ"
	""
	"ػ"
	""
	"ҧ"
	""
	"ҧ"
	""
	"ĵ"
	"ɮ"
	""
	"Ŵ"
	"ź"
	"ǹ"
	""
	"ʹ"
	"͹"
	""
	""
	"ѡ"
	"ѡ"
	"Ѵ"
	"Ѵ"
	"Ѻ"
	""
	""
	"ҡ"
	"Ҵ"
	"ҵѹ"
	"Һ"
	""
	"Ե"
	""
	"֡"
	"֧"
	"ص"
	"غ"
	""
	"ҧ"
	"ǡ"
	"Ǵ"
	"ǹ"
	"ǹ"
	"ǹҡ"
	"Ǻ"
	""
	""
	"ä"
	"ä"
	"ä"
	""
	""
	"ʴԡ"
	"ʴҾ"
	"ʴ"
	"ʴ"
	"ʵԡ"
	""
	"ҧ"
	"Ҵ"
	"ҷ"
	""
	""
	""
	"ʴ"
	""
	"ԧ"
	"Ե"
	"Ź"
	"ഹ"
	"ҧ"
	"ҹ"
	"ҹ"
	"ʶ"
	""
	"ˡó"
	"ˡ"
	"˨"
	"˪ҵ"
	"˻ЪҪҵ"
	"˾ѹѰ"
	"˾ѹ"
	"Ҿ"
	"Ѱ"
	"֡"
	"Ѫ"
	""
	"ʹ¹"
	""
	""
	""
	""
	"ͧ"
	"ʹ"
	"͹"
	"ͺ"
	";"
	""
	""
	"СԴ"
	"Фҭ"
	"дǡ"
	"д"
	"д"
	"дش"
	"д"
	"е"
	"е"
	"з͹"
	"зҹ"
	"кѡ"
	"кѴ"
	"кѴк"
	"к"
	"оѡ"
	"оѴ"
	"о"
	"оҹ"
	"о"
	"е"
	"˹"
	""
	"Ҵ"
	"ҧ"
	"Ҵ"
	"Դ¹"
	""
	"֡"
	""
	"ҹ"
	""
	""
	"͹"
	"͹"
	""
	""
	"⾡"
	"ʹͧ"
	""
	"ѡ"
	"ѡ"
	"ѡ"
	"ѡҴ"
	"Ѣ"
	"ѧѾ"
	"ѧ"
	"ѧó"
	"ѧеѧ"
	"ѧ"
	"ѧѴ"
	"ѧѻ"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѧҵ"
	"ѧ"
	"ѧѧ"
	"ѧ¹"
	"ѧ¹"
	"ѧյ"
	"ѧ"
	"ѧ"
	"ѧ¡"
	"ѧ"
	"ѧ"
	"ѧҪ"
	"ѧ"
	"ѧү"
	"ѧ"
	"ѧ"
	"ѧѸ"
	"ѧ"
	"ѧ"
	"ѧʴ"
	"ѧä"
	"ѧѯ"
	"ѧ"
	"ѧó"
	"ѧ"
	"ѧѾ"
	"ѧԵ"
	"ѧࡵ"
	"ѧࢻ"
	"ѧ"
	"ѧǤ"
	"ѧǪ"
	"ѧ"
	"ѧ¹"
	"ѧ¤"
	"ѧª"
	"Ѩ"
	"Ѩ"
	"Ѩ"
	"Ѩҳ"
	"Ѩ"
	"Ѩ"
	"Ѫ"
	"ѭ"
	"ѭ"
	"ѭҵҳ"
	"ѭҵ"
	"ѭ"
	"ѭ"
	"ѭҳ"
	"ѭ"
	"ѭС"
	"ѭѡɳ"
	"ѭਵ"
	"ѳҹ"
	"ѳ"
	"ѳ"
	"Ѵ"
	"ѵ"
	"ѵ"
	"ѵҺѹ"
	"ѵ"
	"ѵǺ"
	"ѵԷ"
	"ѵ"
	"ѵ"
	"ѵᾷ"
	"ѵš"
	"ѵ"
	"ѷ"
	"ѷ"
	"ѷʵ"
	"ѹ"
	"ѹҹ"
	"ѹһ"
	"ѹлһ"
	"ѹ"
	"ѹ"
	"ѹ"
	"ѹѵ"
	"ѹ"
	"ѹ"
	"ѹҡ"
	"ѹ"
	"ѹѴ"
	"ѹҹ"
	"ѹԺҵ"
	"ѹ"
	"ѹɰҹ"
	"ѹ"
	"ѹʡĵ"
	"ѹ"
	"Ѻ"
	"Ѻô"
	"ѺѺ"
	"ѻѺ"
	"ѻ"
	"ѻ"
	"ѻ"
	"ѻط"
	"ѻ˧"
	"ѻ"
	"Ѿ"
	"Ѿ"
	"Ѿ͡"
	"Ѿѭ"
	"Ѿ"
	""
	"ó"
	"ѭ"
	""
	"ҹ"
	"ص"
	"Է"
	""
	""
	"ԡ"
	"¤"
	""
	"ѷ"
	"ѹ"
	"ѹҾ"
	"ѹԵ"
	"ѹ"
	"ѹ"
	"Ҹ"
	"ط"
	""
	"ɳ"
	""
	"Ҫվ"
	"ķ"
	"⾸"
	"¡"
	"ʴ"
	""
	""
	""
	""
	""
	"ҡ"
	"ҡè"
	"ҡ"
	"Ң"
	"Ҥ"
	"Ҥ"
	"Ҥ"
	"ҧ"
	"Ҵ"
	"ҷ"
	"ҷ"
	"Ҹ"
	"Ҹ"
	"Ҹó"
	"ҸóѰ"
	"Ҹóآ"
	"Ҹó"
	"Ҹóٻ"
	"Ҹóٻ"
	"ҸԵ"
	"Ҹ"
	"ҹ"
	"ҹ"
	"Һ"
	"Һҹ"
	"һ"
	""
	"Ѥ"
	"ѭ"
	"ҹ"
	"ö"
	"Ե"
	"ѡ"
	""
	""
	""
	"ѳ"
	""
	"ö"
	"÷"
	"ú"
	"úó"
	"úѭ"
	"úѺ"
	"úҭ"
	"þѴ"
	"þѹ"
	"þҧ"
	"Ҿ"
	""
	"ѵ"
	""
	""
	"ѷ"
	""
	"ҳҡ"
	"ҹء"
	"ԡҵ"
	"ǹ"
	"ԡ"
	"Թ"
	""
	""
	""
	"ǡ"
	"ԡ"
	"Ե"
	"Ե"
	"ʹ"
	""
	""
	"˵"
	"á"
	""
	"ê"
	""
	""
	"Ӥѭ"
	"ӷѺ"
	"ӹǹ"
	"ӹѡ"
	"ӹ֡"
	"ӺѴӹǹ"
	"ӻѧ"
	"ӻ"
	""
	""
	"⹤"
	"Ǩ"
	""
	""
	""
	"͡"
	"ͧ"
	"Ѻ"
	"ҡ"
	"ҭ"
	"Դ"
	"ѡ"
	"ҹ"
	""
	"͹"
	"Ѻ"
	""
	""
	"ҧ"
	""
	"§"
	""
	"ԧ"
	""
	"˹¡"
	""
	"ᴧ"
	"ŧ"
	"ç"
	""
	"ԡ"
	"Ԣ"
	"Ԥ"
	"ԧ"
	"ԧ"
	"ԧ"
	"ԧ"
	"ԧ"
	"ԧѵ"
	"ԧ˹ҷ"
	"ԧ˺ѭ"
	"ԧҪ"
	"ԧ"
	"ԧҤ"
	"ԧʹ"
	"ԧ"
	"ԧ"
	"ԭ"
	"Ե"
	"Զ"
	"Է"
	"Է"
	"Էö"
	"Է"
	"Է"
	"Թ"
	"Թ"
	"Թ"
	"Թ"
	"Ժ"
	""
	""
	"ԡԵ"
	""
	""
	"ˡ"
	""
	""
	""
	""
	""
	""
	"մ"
	""
	"֡"
	"׺"
	""
	"ء"
	"ء"
	"ء"
	"ءҡ"
	"آ"
	"آ"
	"آԺ"
	"آ"
	"آǴ"
	"آ"
	"آ"
	"آ"
	"ؤ"
	"ؤ"
	"ؤø"
	"ؤø"
	"ؤø"
	"اҡ"
	"اԧ"
	"بԵ"
	"ب˹"
	"ب"
	"ت"
	"تҴ"
	"س"
	"س"
	"ش"
	"ش"
	"ص"
	"ص"
	"صó"
	"ص"
	"ط"
	"ط"
	"ط"
	"طȹ"
	"ظ"
	"ظ"
	"ع"
	"ع"
	"عҾ"
	"عʵ"
	"عѢ"
	"عѹ"
	"غó"
	"غԹ"
	"ؾó"
	"Ѥ"
	"Ҿ"
	"Ե"
	""
	""
	""
	""
	""
	"˹ҷ"
	"ѵ"
	"Ǵ"
	""
	"ҧ"
	"ҧҧ"
	"ѡ"
	""
	"Թ"
	"¡"
	"¡"
	"¤"
	"¤"
	"§"
	"¹"
	""
	""
	"ѹ"
	""
	"ػҤ"
	""
	"¹"
	""
	""
	""
	""
	"§"
	"ŵҹ"
	"Ҿ"
	"ó"
	"ҹ"
	"Թ"
	""
	"ҹ"
	"˹ѵ"
	""
	""
	""
	""
	"ͫ"
	""
	""
	"٧"
	"٨"
	"٭"
	"٭ҡ"
	"ٴ"
	"ٵ"
	"ٵ"
	"ٵԡ"
	"ٵԺѵ"
	"ٵʵ"
	"ٵᾷ"
	"ٷ"
	"ٺ"
	""
	""
	"ࡵ"
	"൵"
	""
	"໡"
	"໹"
	"ŧ"
	""
	"ê"
	""
	"Ŵ"
	""
	"ǹ"
	""
	""
	"ͧ"
	"͹"
	""
	"ҹ"
	""
	""
	""
	""
	""
	""
	""
	"ǧ"
	""
	""
	"ͧ"
	""
	"ˡ"
	"˧"
	"˧"
	"˧"
	"˧͡"
	"˧ʹ"
	"˧͹"
	"˧"
	"˧ѡ"
	"˧Ѻ"
	"˧"
	"˧"
	"˧ԡ"
	"˧ԧ"
	"˧"
	"˧֡"
	"˧ا˧ԧ"
	"˧ش˧Դ"
	"˧غ"
	"˧"
	"˧"
	"˧ҧ"
	"˧"
	"˭ԧ"
	"˭Ժ"
	"˭"
	"˴"
	"˷"
	"˹"
	"˹ǡ"
	"˹Ǵ"
	"˹"
	"˹͡"
	"˹ͧ"
	"˹͹"
	"˹ѡ"
	"˹ѧ"
	"˹ѧ"
	"˹Ѻ"
	"˹"
	"˹"
	"˹Ҵ"
	"˹ҹ"
	"˹"
	"˹"
	"˹"
	"˹º"
	"˹"
	"˹պ"
	"˹"
	"˹ֺ"
	"˹"
	"˹״"
	"˹"
	"˹ع"
	"˹غ"
	"˹"
	"˹"
	"˹"
	"˹"
	"˹ǧ"
	"˹"
	"˹¡Ե"
	"˹"
	"˹"
	"˹ҧ"
	"˹"
	"˹"
	""
	""
	"ǡ"
	"Ǵ"
	""
	"͡"
	"ͧ"
	"͹"
	"ͺ"
	""
	"ѡ"
	"Ѵ"
	"ѹ"
	"Ѻ"
	""
	""
	""
	"ҡ"
	"ҡ"
	"ҧ"
	"Ҵ"
	""
	""
	""
	""
	"֡"
	""
	"ش"
	"ع"
	"غ"
	"غԺ"
	""
	""
	""
	""
	"ͧ"
	"͹"
	""
	""
	""
	""
	"¡"
	"´"
	"ǡ"
	"Ǻ"
	"͡"
	"͡Թ"
	"ͧ"
	"ʹ"
	""
	""
	"ѡ"
	"ѧ"
	"Ѵ"
	"ѹ"
	"Ѻ"
	""
	"ҡ"
	"Ҵ"
	"Һ"
	""
	""
	""
	"ԡ"
	"Ժ"
	""
	""
	""
	"ءԡ"
	"ش"
	"غ"
	""
	""
	"١"
	"ͧ"
	""
	"ͧ"
	"͹"
	""
	""
	""
	"ô"
	""
	""
	"͡"
	""
	""
	""
	""
	"մ"
	""
	""
	"غ"
	"غ"
	""
	""
	""
	"ķ"
	""
	"˴"
	""
	"ŧ"
	"Ŵ"
	"Ź"
	"ź"
	"ǧ"
	""
	""
	"͡"
	"ʹ"
	"͹"
	""
	""
	"ѡ"
	"ѧ"
	"Ѵ"
	"Ѻ"
	""
	""
	""
	""
	"ҡ"
	"ҹ"
	"Һ"
	""
	""
	""
	"ԡ"
	""
	""
	""
	""
	"ա"
	""
	"ֺ"
	"ءԡ"
	"ش"
	"ع"
	"غ"
	""
	""
	""
	""
	""
	"͹"
	""
	"ǧ"
	"Ǵ"
	""
	""
	"ʹ"
	""
	"ѧ"
	"Ѵ"
	""
	""
	""
	""
	"Ҵ"
	"ҹ"
	""
	""
	""
	""
	""
	"մ"
	""
	""
	"ش"
	"شԴ"
	""
	""
	""
	"ҧ"
	"ҹ"
	""
	""
	"͡"
	"ͧ"
	"͹"
	"ͺ"
	""
	""
	"á"
	"ѡ"
	"ѵ"
	"ѵ"
	"ѵԨ"
	"ѵ"
	"ѵ֡"
	"ѵ"
	"ѵ"
	"ѹ"
	"Ѻ"
	""
	""
	""
	""
	""
	""
	"ҡ"
	"ҧ"
	"ҭ"
	"Ҵ"
	"ҹ"
	"Һ"
	""
	""
	"¹"
	""
	""
	""
	""
	"ԧ"
	"ԧ"
	"Դ"
	"Թ"
	""
	""
	"ѭ"
	""
	""
	""
	""
	""
	"չҹ"
	"պ"
	""
	"֧"
	""
	"״"
	""
	""
	""
	"ا"
	"ع"
	"غ"
	""
	""
	""
	""
	""
	"١"
	"ٴ"
	""
	"´"
	""
	"ǧ"
	""
	"͹"
	""
	"ҧ"
	"ҹ"
	""
	"ǧ"
	"ǹ"
	""
	""
	"ͧ"
	""
	""
	""
	"ҧ"
	""
	""
	""
	"͡"
	"͡ɰ"
	"͡ѭص"
	"͡ѭ"
	"͡ó"
	"͡"
	"͡"
	"ͤ"
	"ͤҸ"
	"ͧ"
	"ͧҵ"
	"ͧ"
	"ͧ"
	"ͧѡ"
	"ͧԷ"
	"ͧҾ¾"
	"ͧ"
	"ͧ"
	"ͧ"
	"ͧ"
	"ͧҨ"
	"ͧ"
	"ͨ"
	"ͨԵ"
	"ͨԹ"
	"ͨԹ"
	"ͨ"
	"ͪ"
	"ͪ"
	"ͪԹ"
	"ͪԹ"
	"ͪ"
	"ͮ"
	"ͳ"
	"ͳ"
	"ͳ"
	"ʹ"
	"ʹԶ"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʹ෾"
	"ʹá"
	"ʹյ"
	"ʹ"
	"ʹപ"
	"ʹ"
	"͵ҹ"
	"͵Ԫҵ"
	"͵Ҫ"
	"͵"
	"͵á"
	"ͷԹҷҹ"
	"͸"
	"͸ԡ"
	"͸ԡó"
	"͸ԡ"
	"͸ԡ÷Թ"
	"͸ԡ"
	"͸Ԥ"
	"͸ԯҹ"
	"͸Ժ"
	"͸Ժ"
	"͸Ի"
	"͸Ի"
	"͸Ҫ"
	"͸ɰҹ"
	"͸֡"
	"͹"
	"͹Ţ"
	"͹"
	"͹Ţ"
	"͹"
	"͹ѵ"
	"͹ѹ"
	"͹Ҥ"
	"͹Ҥ"
	"͹Ҩ"
	"͹Ҷ"
	"͹Ҷ"
	"͹ҷ"
	"͹ҸԻ"
	"͹"
	"͹ª"
	"͹¸"
	"͹"
	"͹"
	"͹Ԩ"
	"͹Ԩѧ"
	"͹Ԩ"
	"͹ԯ"
	"͹"
	"͹"
	"͹"
	"͹ء"
	"͹ء"
	"͹ء"
	"͹ءҪҴ"
	"͹ء"
	"͹ء"
	"͹ب"
	"͹ت"
	"͹تҵ"
	"͹تԵ"
	"͹حҵ"
	"͹ح⵵ҡ"
	"͹طԹ"
	"͹غ"
	"͹غ"
	"͹ػԭ"
	"͹ؾ"
	"͹ؾѹ"
	"͹"
	"͹"
	"͹Ҥ"
	"͹ѵ"
	"͹ҵ"
	"͹ҹ"
	"͹"
	"͹ѡ"
	"͹Ҫ"
	"͹ٻ"
	"͹ǧ"
	"͹ѵ"
	"͹ʡ"
	"͹ʵҨ"
	"͹ʹ"
	"͹ɯ"
	"͹ʵ"
	"͹ʹ"
	"͹"
	"͹ó"
	"͹ѭ"
	"͹"
	"͹"
	"͹ʹ"
	"͹"
	"͹"
	"͹"
	"͹¤"
	"͹"
	"ͺ"
	"ͺ"
	"ͺ"
	"ͺآ"
	"ͻ"
	";¾"
	""
	"Ԫ"
	"Ԫҵ"
	"ԭ"
	"Ը"
	"Ըҹ"
	"Թ"
	"Թ"
	"Ժ"
	"ԻѪ"
	"Ի"
	"ӹҨ"
	"ҹ"
	"آ"
	"ô"
	""
	"ѡ"
	"ѡԵ"
	"ѹ"
	"ҷ"
	""
	"Ҩ"
	"⾸"
	"⾸"
	"Է"
	"Ż"
	"ɡ"
	""
	"׹ѹ"
	""
	""
	""
	""
	""
	"Ǵ"
	"Թ"
	"ĵ"
	"ĵ"
	"Ե"
	""
	"ҡ"
	"ظ"
	""
	""
	"ҧ"
	""
	"ê"
	"ó"
	"ö"
	"öҸԺ"
	""
	"ѧ"
	"ѹ"
	"ѭ"
	""
	"ºؤ"
	""
	""
	"س"
	"ѡɹ"
	"⳷"
	""
	""
	""
	"ŧ"
	"ŧó"
	"ŧ"
	"ǹ"
	"ҹ"
	"ѧ"
	"Ѫ"
	"觩"
	"ǧ"
	"ͧͧ"
	"ҧҧ"
	"ǡ"
	"Ǵ"
	"ǵ"
	"ǹ"
	"Ǻ"
	""
	""
	""
	"ҹ"
	""
	""
	"Ԫ"
	"ʧ"
	"ʹպҵ"
	""
	"ҵ"
	"þ"
	"ѧѾ"
	"ѭ"
	"ѭ"
	"ѵ"
	"յ"
	"ب"
	"عպҵ"
	""
	""
	"á"
	"ѧ"
	"ԧ"
	"ҵä"
	""
	"͡"
	"͡ਹ"
	"͡പѹ"
	"͡"
	"͡䫴"
	"ʹ"
	"͹͹"
	"͹"
	"͹ت"
	"Ϳ"
	""
	""
	"Ф"
	"дչԹ"
	"е"
	""
	""
	""
	""
	"૷չ"
	""
	""
	"ѡ"
	"ѡ"
	"ѡԸ"
	"ѡԺѵ"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѡ"
	"ѡʺ"
	"ѡ"
	"Ѥ"
	"Ѥ"
	"Ѥ"
	"Ѥê"
	"Ѥ"
	"ѤҪٵ"
	"ѧ"
	"ѧ"
	"ѧا"
	"ѧ"
	"ѧ"
	"ѧ"
	"ѧʵ"
	"ѧʹ"
	"ѨѺ"
	"Ѩѹ"
	"Ѩ"
	"Ѩ"
	"Ѩ"
	"ѨԺؤ"
	"Ѩ"
	"Ѩ"
	"Ѫ"
	"Ѫ"
	"ѭ"
	"ѭ"
	"ѭѹ"
	"ѭС"
	"ѭ"
	"ѭѭ"
	"ѭٻ"
	"ѭԭ"
	"Ѯ"
	"ѯ"
	"Ѱ"
	"Ѱ"
	"Ѱ"
	"ѲѹѲҤ"
	"Ѳ"
	"Ѳ"
	"Ѳѵ"
	"ѳ"
	"ѳ"
	"ѳҡ"
	"Ѵ"
	"ѵѴ"
	"ѵǻѵ"
	"ѵ"
	"ѵ"
	"ѵҸԻ"
	"ѵ"
	"ѵҾ"
	"ѵ"
	"ѵԹԺҵ"
	"ѵѵ"
	"Ѹ"
	"ѹ"
	"ѹøҹ"
	"ѹ"
	"ѹ"
	"ѹ"
	"Ѻ"
	"ѻҤ"
	"ѻ"
	"ѻ"
	"ѻҳ"
	"ѻҪ"
	"ѻ"
	"ѻѡɳ"
	"ѻ"
	"ѻ"
	""
	"ġ"
	""
	"ҵ"
	"ت"
	""
	"¡"
	"¡"
	"ԡ"
	"Ũ"
	"ź"
	"Ȩ"
	"Թ"
	"Թ"
	""
	"ɮط"
	"ɮظ"
	"ʴ"
	"ʴ"
	"ʴ"
	"ʹ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ҡ"
	"ҡѻ"
	"ҡ"
	"ҡ"
	"ҡ"
	"Ңҹ"
	"Ҥ"
	"Ҥѹء"
	"Ҥ"
	"Ҥ"
	"Ҧҵ"
	"ҧҧ"
	"Ҩ"
	"Ҩ"
	"ҨҴ"
	"Ҩ"
	"Ҩѵ"
	"ҨԳ"
	"Ҫ"
	"Ҫ"
	"Ҫ"
	"Ҫվ"
	"Ҫ֡"
	"Ҫ"
	"ҭ"
	"ҳѵ"
	"ҳ"
	"Ҵ"
	"Ҵ"
	"ҵҾ"
	"ҵ"
	"ҷ"
	"ҷ"
	"ҷԵ"
	"ҹ"
	"ҹʧ"
	"ҹҾ"
	"Һ"
	"Һѵ"
	"ҾҸ"
	"ҿҹʶҹ"
	"ҿԡ"
	"ó"
	"þ"
	"Ѿ"
	""
	""
	""
	"µ"
	""
	"Ǫ"
	"ᾷ"
	"ʵ"
	""
	"ª"
	"ªҵ"
	"¸"
	"»"
	""
	"ѹ"
	"ѡ"
	""
	""
	"Ҹ"
	""
	"ԡ"
	""
	""
	""
	"줵ԡ"
	"Ż"
	"Ҵ"
	"ѡɳ"
	""
	""
	"ó"
	""
	""
	"ظ"
	""
	""
	""
	""
	"ҷ"
	"ʹ"
	"ʹ"
	"ѭ"
	""
	"˺٪"
	""
	"Ѻ"
	""
	"¹"
	""
	""
	"Ǥ"
	""
	"ҷ"
	""
	"ӹ"
	"ӹҨ"
	"Ӿй"
	"ĵ"
	"Ե"
	"ҵ"
	""
	"ԧ"
	"Ԩ"
	"ԩѹ"
	"ԯ"
	"԰"
	"Դ"
	"Ե"
	"Ե"
	"Ե¹"
	"Է"
	"ԹԹ"
	"Թ"
	"Թ"
	"Թø"
	"Թǧ"
	"Թ"
	"Թ"
	"ԹѧԹ"
	"Թ"
	"Թ"
	"Թô"
	"Թѧ"
	"Թ"
	"Թ¹ᴧ"
	"Թⴹ"
	"Ի"
	"Һ"
	""
	"ɮ"
	"ɮ"
	"ʵ"
	"Ҿ"
	""
	""
	""
	""
	"ó"
	""
	""
	""
	""
	"ҹ"
	"ѡ"
	"硵͹"
	"硷͹ԡ"
	"ⷹ"
	""
	""
	"ա"
	"ա"
	""
	"Ի"
	"ااѧ"
	"©ᩡ"
	""
	"ҹ"
	"ͺ"
	"ѡ"
	""
	""
	""
	"Т"
	"ššš"
	""
	""
	""
	"֡"
	"֡֡"
	"֡ѡ"
	"֧"
	"֧"
	"֧"
	"ִ"
	""
	"鴷"
	""
	"״"
	""
	""
	""
	""
	""
	""
	"ء"
	"ءҺҵ"
	"ءɮ"
	"ب"
	"بҴ"
	"بä"
	"ب੷"
	"ت"
	"دҡ"
	"س"
	"س"
	"س"
	"س"
	"ش"
	"ش"
	"ش"
	"صԴ"
	"ص"
	"صش"
	"صˡ"
	"ص"
	"ص"
	"ص"
	"ط"
	"طó"
	"طѨ"
	"طҹ"
	"ط"
	"ط"
	"طѪ"
	"ط"
	"طҹ"
	"ط"
	"طó"
	"ط"
	"ط"
	"ظѨ"
	"غ"
	"غ"
	"غԺ"
	"غ"
	"غѵ"
	"غҷ"
	"غ"
	"غʡ"
	"غԡ"
	"غ"
	"ػó"
	"ػ"
	"ػ"
	"ػ"
	"ػ"
	"ػ"
	"ػҹ"
	"ػٵ"
	"ػ"
	"ػ¡"
	"ػ"
	"ػ"
	"ػҹ"
	"ػҪ"
	"ػʧ"
	"ػ"
	"ػä"
	"ػ"
	"ػѪ"
	"ػѪ"
	"ػѯҡ"
	"ػѯҹ"
	"ػѷѹ"
	"ػѷ˵"
	"ػҷҹ"
	"ػ"
	"ػ¤"
	"ػš"
	"ػ"
	""
	""
	""
	""
	"اصѧ"
	"ɳ"
	""
	""
	""
	"ມ"
	""
	""
	""
	"ʶ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ٰ"
	"ٴ"
	""
	""
	""
	""
	""
	""
	"š"
	""
	"๡"
	"๡س"
	"๨͹Ҷ"
	""
	"ԡѹ"
	"ԡ"
	"Ǩ"
	""
	"⳷"
	"⹪"
	"⹴ҵ"
	""
	"ȡ"
	""
	"ͧ"
	"͹"
	""
	""
	"ҧ"
	"ҹ"
	""
	""
	""
	"ǡ"
	"ǹ"
	""
	"͹"
	"͹"
	""
	""
	""
	""
	""
	"ҧ"
	""
	""
	""
	"ʹ"
	""
	""
	"ͧ"
	""
	"Ρ¹"
	"ǧ"
	"ǹ"
	"Ǻ"
	"͡"
	"ʹ"
	"͹"
	""
	"Դ"
	"Ź"
	""
	"ѡ"
	"ѧ"
	""
	""
	""
	""
	"촴ʤ"
	""
	""
	"Թ"
	"Ի"
	"ʷ"
	""
	""
	"֡"
	"ִ"
	"ִѴ"
	""
	""
	""
	"״Ҵ"
	""
	""
	""
	"غ"
	""
	"١"
	""
	""
	""
	"ͧ"
	""
	""
	""
	""
	""
	""
	"ࡡá"
	"ࡨҨ"
	"ࡳ"
	"ࡴ"
	"ࡵ"
	"ࡹ"
	""
	""
	""
	"ç"
	""
	""
	"ԡ"
	""
	"¡"
	"§"
	"¹"
	"º"
	""
	""
	""
	""
	""
	""
	""
	""
	"§"
	"´"
	""
	""
	""
	"§"
	""
	"͡"
	"͹"
	""
	"͹"
	""
	""
	"¹"
	""
	""
	"Թ"
	"ɵ"
	"ɵ"
	""
	"¹"
	""
	"Ԫ"
	""
	"С"
	""
	"ҵ"
	"ҷѳ"
	"Ѵ"
	""
	""
	""
	"Դ"
	"Թ"
	""
	"¨"
	"´"
	"¹"
	"õ"
	"õԤس"
	"õԹ"
	"õԻѵ"
	"õ"
	"õ"
	"õѡ"
	"õ"
	""
	"§"
	""
	""
	""
	""
	""
	""
	"͡"
	"ͺ"
	""
	""
	""
	""
	""
	""
	"觡Ҩ"
	""
	""
	""
	""
	"駡ҧ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ࢡ"
	"ࢵ"
	"ࢹ"
	"ࢹ"
	"ࢹ"
	"ࢹ"
	"ࢺ稢ǹ"
	"ࢺ"
	""
	""
	"ͺ"
	""
	""
	""
	""
	""
	"¡"
	"Ժ"
	"͹"
	""
	""
	""
	""
	"ŧ"
	""
	""
	""
	""
	""
	""
	""
	"Т"
	""
	"Թ"
	"§"
	"´"
	"¹"
	""
	""
	""
	""
	""
	"ͧ"
	"͹"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ह"
	"ऺ"
	""
	""
	"ç"
	"ôԵ"
	""
	""
	"´"
	""
	"ͧ"
	""
	"觤Ѵ"
	"Ժ"
	""
	""
	"ͺ"
	"͹"
	""
	""
	""
	""
	""
	""
	""
	""
	"ҹ"
	"þ"
	""
	"§"
	"´"
	"¹"
	""
	""
	""
	""
	"ͧ"
	""
	""
	""
	""
	""
	"¹"
	"ৡ"
	""
	""
	"Ч"
	""
	""
	"Թ"
	"º"
	"§"
	"¹"
	""
	""
	"͡"
	"ʹ"
	"ͺ"
	"ͧ"
	"͹"
	""
	""
	""
	""
	""
	"਴ʶҹ"
	"਴"
	"ਵ"
	"ਵ"
	"ਵӹ"
	"ਵ"
	"ਵ"
	"ਵٵ"
	"ਵԡ"
	"ਹ"
	"è"
	"ԭ"
	"Դ"
	""
	"ɮ"
	""
	""
	""
	"Դ"
	""
	""
	""
	"´"
	"¹"
	""
	""
	""
	"¹"
	""
	"º"
	"Ǩ"
	""
	"͹"
	""
	""
	""
	""
	""
	""
	"Ҫ"
	""
	""
	""
	""
	""
	""
	"੡"
	"ੴ"
	"੾"
	""
	""
	""
	""
	""
	"§"
	""
	""
	"§"
	"¹"
	";"
	""
	""
	"Դ"
	"Ժ"
	"§"
	"´"
	"º"
	""
	""
	"͹"
	""
	""
	""
	"હ"
	""
	""
	""
	"ɰ"
	"ǹ"
	""
	"ԧ"
	"ԭ"
	"Դ"
	""
	""
	"§"
	"º"
	""
	""
	"¹"
	""
	"͡"
	"ʹ"
	"͹"
	""
	"ͧ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"૵"
	"ૹ"
	"ૹԡ"
	"ૹô"
	"ૹ"
	"ૻѡС"
	""
	"´"
	""
	""
	""
	""
	""
	"ԧ"
	"¹"
	""
	""
	"ͧ"
	""
	""
	""
	""
	""
	"ҫ"
	""
	""
	""
	""
	"ഡ"
	"തҡ"
	"തԵ"
	"പ"
	"പ"
	"ഫԡ"
	"ഫԵ"
	"ഫ"
	"ഹ"
	"ഹ"
	"ഹ"
	"Ѩҹ"
	"Դ"
	""
	""
	"Թ"
	""
	"§"
	"´"
	"ô"
	"ö"
	"Ѩҹ"
	""
	""
	""
	""
	"ʹ"
	"͹"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ʹ"
	""
	"´"
	""
	""
	""
	"״"
	""
	""
	""
	""
	""
	""
	""
	"Ժ"
	""
	""
	"§"
	"¹"
	"º"
	""
	""
	""
	"͹"
	""
	""
	"繷"
	""
	""
	""
	""
	""
	""
	"ҷ֧"
	""
	""
	""
	""
	""
	"ඡԧ"
	"ඹ"
	""
	"ҹ"
	"ԧ"
	"͡Ź"
	""
	""
	""
	""
	""
	"ԡ"
	"Դ"
	"Դԧ"
	"Թ"
	"§"
	""
	"͡"
	"͹"
	""
	""
	""
	"෤Ԥ"
	"෤"
	"෹"
	"෻"
	"෾"
	"෾"
	"෾"
	"෾"
	"෾´"
	"෾"
	"෾ѡ"
	"෾"
	"෾"
	"Ǵ"
	"Ƿѳ"
	"Ƿٵ"
	"Ǹ"
	"ǸԴ"
	"ǹ"
	"ٻ"
	""
	"ʶҹ"
	"ѭ"
	"ѹ"
	""
	""
	"š"
	""
	"ȡ"
	"ȹ"
	"ȹ"
	"Ⱥ"
	""
	"Ժ"
	"ѵ"
	""
	"ͭ"
	"ʹ"
	""
	""
	"з"
	""
	"Դ"
	"Թ"
	"Ժ"
	""
	""
	"¹"
	"º"
	""
	""
	"§"
	""
	"͡"
	"Ť"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"๵"
	"๵"
	"๵"
	"๺"
	"๻ٹ"
	"๻"
	""
	"äس"
	"Ե"
	""
	""
	"Թ"
	"Ժ"
	""
	"¹"
	""
	""
	"ͧ"
	""
	"ͧ"
	""
	""
	""
	""
	"ວ"
	"ອ"
	"ອ"
	"ອҳ"
	"ອس"
	"ອ"
	"ອþ"
	"ອ"
	"ອç"
	"ອ"
	"ອҧдɰ"
	"ອҧ"
	"ອ"
	"ູ"
	"ູԹ"
	"ä"
	""
	""
	""
	"Թ"
	""
	"к"
	""
	""
	""
	"ԡ"
	""
	"´"
	"¹"
	""
	"§"
	""
	""
	""
	"͹"
	""
	""
	"ͧ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"໡"
	"õ"
	""
	""
	""
	""
	""
	"§"
	"­"
	"º"
	""
	""
	"§"
	""
	""
	"ͧ"
	""
	""
	""
	""
	"¹"
	""
	""
	"͡"
	"ͧ"
	""
	"ͧ"
	""
	""
	""
	"繵"
	""
	""
	""
	"ԡ"
	"ԧ"
	"Դ"
	"Ժ"
	""
	""
	""
	"¡"
	""
	""
	"¡"
	""
	"͡"
	""
	"͹"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"༧"
	"༪ԭ"
	"༴"
	"༴§"
	"༴"
	""
	""
	""
	""
	""
	""
	""
	"ԭ"
	""
	""
	""
	""
	"Թ"
	"͡"
	"ʹ"
	""
	""
	""
	""
	""
	""
	"͡"
	"͹"
	""
	""
	"ྪҵ"
	"ྪ"
	"ྪظ"
	"ྴҹ"
	"ྷ"
	"ྷغ"
	"ྐྵ´"
	"ç"
	""
	""
	"Դ"
	""
	"¡"
	"§"
	"º"
	""
	""
	""
	"ŧ"
	""
	""
	"ԧ"
	"ԴԹ"
	"Թ"
	""
	"§"
	""
	""
	""
	"ԡ"
	"ԧ"
	""
	""
	"§"
	"º"
	""
	""
	"§"
	"¹"
	""
	"͹"
	""
	""
	""
	"紷"
	""
	"蹾ҹ"
	""
	""
	""
	""
	""
	"Թ"
	""
	""
	""
	"ͧ"
	"͹"
	""
	"ͧ"
	""
	"ͧ"
	""
	""
	""
	""
	""
	""
	"غ"
	""
	"Ѫ"
	"õ"
	""
	""
	""
	"Թ"
	""
	""
	""
	"ԡ"
	"ԡ"
	"ع"
	""
	"Թ"
	""
	""
	""
	""
	""
	""
	"ͧ"
	""
	""
	""
	""
	""
	"¹"
	""
	""
	""
	""
	""
	"Թ"
	""
	"§"
	"§"
	"¹"
	"͡"
	"ͧ"
	""
	""
	"硫"
	""
	""
	""
	""
	""
	"§"
	"«"
	"¹"
	""
	""
	"ѹ"
	"ѹ"
	""
	""
	"Ǫ"
	"Ǿ"
	"Ǿҹ"
	""
	"ʹ"
	"Ҫ"
	"ѡɳ"
	""
	""
	""
	"Թ"
	"Ժ"
	""
	""
	""
	""
	"¹"
	"º"
	""
	"§"
	""
	""
	"͡"
	"͹"
	""
	""
	"ͧ"
	"͹"
	""
	""
	""
	""
	""
	""
	"â"
	"â"
	"ó"
	"ô͹"
	"ô"
	"ǹ"
	"Ǵ"
	""
	""
	""
	"ԧ"
	"Դ"
	""
	""
	""
	""
	"¡"
	"§"
	"´"
	"¹"
	"º"
	""
	""
	""
	""
	"á"
	""
	"͡"
	"ͧ"
	"ʹ"
	"͹"
	""
	"ͧ"
	""
	""
	"͹"
	""
	""
	""
	""
	""
	""
	""
	""
	"Ţ"
	"Ţ"
	"ŢҸԡ"
	"Ţҹء"
	"ŵ"
	"Ź"
	"Ź"
	"źҹ͹"
	""
	""
	""
	"ѧ"
	""
	""
	""
	""
	""
	""
	""
	"ԡ"
	"ԡ"
	"Թ"
	""
	""
	""
	"§"
	"¹"
	"º"
	""
	""
	"§"
	"¹"
	""
	"§"
	""
	"͡"
	"ʹ"
	"͹"
	"ͧ"
	"͹"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ǡ"
	"Ǥ"
	"ǤԹ"
	"Ǥ"
	"Ǩ"
	"Ǫ"
	"ǰ"
	"ǳ"
	"ǳ"
	"ǳԡ"
	"ǳ"
	"ǵ"
	"ǵ"
	"ǵ"
	"Ƿ"
	"Ƿ"
	"Ƿ"
	"Ƿҧʵ"
	"Ƿҧ"
	"Ƿҹ"
	"Ƿҹ"
	"Ƿ"
	"Ƿ"
	"ǹ"
	"ǹ"
	"ǹ"
	""
	"ѵ"
	"ҵԡ"
	""
	""
	"ѳ"
	"ѳ"
	""
	""
	""
	""
	""
	""
	""
	"ʹ"
	""
	""
	""
	"ѳ"
	""
	"ѹ"
	"ء"
	"ѳ"
	"Ѫ"
	""
	""
	"˹"
	""
	"ѧ"
	"ѻ"
	""
	""
	""
	""
	""
	"ԡ"
	""
	""
	"§"
	"´"
	"¹"
	"è"
	""
	""
	""
	""
	""
	""
	"ɰԨ"
	"ɰʵ"
	"ɰҹ"
	"ɰ"
	"ɰ"
	""
	"ǵ"
	""
	""
	""
	"ʡ"
	"ʧ"
	"ʴ"
	"ʴ"
	"ʶ"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʹҸԡ"
	"ʹҺ"
	"ʹʹ"
	"ʹ"
	"ʹ´"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʹ"
	"ʺ"
	"ʺ§"
	"ʾ"
	"ʾ"
	""
	""
	""
	""
	"¹"
	"͹"
	""
	""
	"Դ"
	""
	""
	""
	"Ŵ"
	""
	"§"
	"͡Ź"
	"ǡ"
	"ǡҵ"
	"ǹ"
	"ǹ"
	"Ҿ"
	""
	""
	"¹"
	""
	""
	"Ǥ"
	"ǳԵ"
	"ǹ"
	""
	"Ҥ"
	""
	"ѡɳ"
	""
	""
	""
	"§"
	"´"
	"º"
	""
	""
	"§"
	""
	"¹"
	""
	""
	""
	"͡"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"˧"
	"˧"
	"˧͡"
	"˧"
	"˧"
	"˵"
	"˹"
	"˹˹"
	"˹"
	"˹§"
	"˹"
	"˹"
	"˹"
	"˹"
	"˹"
	"˹"
	"˹"
	"˹"
	"˹"
	"˹"
	""
	"Ǵ"
	"ѹ"
	""
	""
	""
	""
	"ͧ"
	"ʹ"
	"͹"
	""
	""
	""
	""
	""
	"§"
	""
	"ԧ"
	"´"
	"º"
	""
	"͡"
	""
	""
	"ѭԡ"
	""
	"­"
	"Ź"
	""
	""
	""
	""
	"ԧ"
	"¹"
	""
	""
	""
	"͡"
	"ͧ"
	"ͺ"
	""
	""
	""
	""
	""
	""
	"ǧ"
	""
	""
	""
	"§"
	""
	""
	""
	""
	"Թ"
	""
	"¹"
	""
	""
	"¹"
	""
	"ʹ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"͡"
	"͡ѹ"
	"͡"
	"͡"
	"͡Ҿ"
	"͡"
	"͡ö¤"
	"͡Ҫ"
	"͡ѡɳ"
	"͡ѵ"
	"͡ҸԻ"
	"͡ࢹ"
	"͡"
	"ͧ"
	"ͪ"
	"ʹ"
	"͵Ѥ"
	"͹"
	"͹"
	"Ϳ"
	""
	""
	"ѳ"
	""
	""
	""
	"̡"
	""
	""
	""
	""
	""
	""
	"ԡ"
	"Ժ"
	""
	"§"
	"´"
	"¹"
	"¹"
	""
	""
	"§"
	""
	""
	"´"
	""
	""
	"͹"
	""
	""
	""
	"ͧ"
	"͹"
	""
	""
	""
	""
	""
	""
	"硫"
	""
	""
	""
	"紵"
	"֧"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"Χ"
	""
	"Ԥͻ"
	"õ"
	"¹"
	"º"
	""
	"͡"
	"͹"
	"չ"
	""
	""
	""
	""
	""
	"ᡧ"
	"᡹"
	""
	""
	"á"
	"ùԵ"
	""
	"俵"
	""
	""
	""
	""
	"ź"
	"͹"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ᢡ"
	"ᢹ"
	"ᢹ"
	""
	""
	""
	"§"
	""
	"ǡ"
	"ǧ"
	"ǹ"
	""
	""
	""
	""
	""
	""
	"ᤪ"
	"᤹"
	"᤺"
	""
	"ç"
	""
	""
	"Ť"
	"ŧ"
	"Ź"
	""
	"Ǥͧ"
	""
	""
	"ǡ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ᨡ"
	"ᨧ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ᩡ"
	"ᩧ"
	"ź"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"᫧"
	"᫴"
	"᫺"
	""
	"Դ"
	""
	""
	""
	""
	""
	"ᴡ"
	"ᴧ"
	"ᴴ"
	"ᴹ"
	""
	""
	""
	""
	""
	"ᵡ"
	"ᵧ"
	"ᵧ"
	"ᵧ"
	"ᵧ"
	"ᵴ"
	"ᵹ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ᶡ"
	"ᶺ"
	""
	"ŧ"
	""
	"ᷧ"
	"᷹"
	"᷹"
	"᷺"
	"á"
	"á"
	"ç"
	""
	"硫"
	"秡"
	""
	""
	""
	""
	"Ṻ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ạ"
	"Ấ"
	"ầ"
	"ẴԹѹ"
	"ẵ"
	"ẹ"
	"ẹ"
	"Ẻ"
	""
	""
	""
	""
	""
	"ừԿԤ"
	"Ỵ"
	"Ỻ"
	""
	"á"
	"ç"
	"ûǹ"
	""
	""
	""
	""
	""
	""
	"š"
	"ŧ"
	"Ź"
	"ź"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ἡ"
	"ἧ"
	"ἴ"
	"Ἱ"
	"Ἱ"
	""
	"ŧ"
	""
	""
	""
	""
	""
	""
	""
	"ὡ"
	"ὧ"
	"ὴ"
	""
	"ᾧ"
	"ᾷʵ"
	"ᾷ"
	"ᾷ"
	"ᾷ"
	"Ᾱ"
	"Ᾱ"
	"Ᾱԭ"
	""
	"á"
	""
	""
	""
	""
	"ŧ"
	"ŷԹ"
	""
	""
	""
	""
	""
	""
	""
	""
	"ῡ"
	"ῧ"
	"Ὺ"
	"Ὼ"
	"š"
	"ŵ"
	""
	""
	""
	""
	""
	"ҹ"
	""
	""
	"ŧ"
	""
	""
	""
	""
	""
	"ͧ͹"
	""
	""
	""
	"¡"
	"§"
	"º"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"á"
	"ç"
	"ô"
	""
	""
	"ࡵ"
	""
	""
	""
	""
	""
	""
	"š"
	"Ź"
	"ź"
	""
	""
	""
	""
	""
	""
	""
	"ǧ"
	"Ǵ"
	"Ǻ"
	""
	""
	""
	""
	""
	""
	""
	""
	"ʡ"
	"ʧ"
	"ʴ"
	"ʴ"
	"ʵ"
	"ʹ"
	"ʹҡ"
	"ʹùҾ"
	"ʺ"
	""
	"¡"
	"§"
	""
	""
	"ŧ"
	"ǧ"
	""
	""
	""
	""
	""
	"ˡ"
	"˧"
	"˧"
	"˧"
	"˧"
	"˧"
	"˹"
	"˹"
	"˹"
	"˹"
	"˺"
	""
	""
	""
	""
	"§"
	""
	""
	""
	""
	""
	"š"
	"Ź"
	""
	""
	""
	""
	""
	"ǡ"
	"ǹ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"͡"
	"ʹ"
	"͹"
	"͹졵ԡ"
	"͹Ժʹ"
	"͹ਹ"
	"ͺ"
	""
	""
	""
	""
	""
	"š"
	"ſ"
	"ʿŵ"
	"Թ"
	"⹴"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ι"
	""
	""
	""
	""
	""
	"⡡"
	"⡧"
	"⡧ҧ"
	"⡯"
	"⡴ѧ"
	"⡹"
	""
	""
	"á"
	"ø"
	"ø"
	""
	""
	"Ź"
	""
	""
	"ʹ"
	"Թ"
	""
	""
	"ˡ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"⢡"
	"⢧"
	"⢴"
	"⢹"
	"⢹"
	""
	""
	""
	"¡"
	"§"
	""
	"š"
	"ŧ"
	""
	""
	"⤡"
	"⤨"
	"⤵"
	"⤹"
	"⤺ŵ"
	""
	""
	"á"
	"ç"
	""
	"Ҫ"
	""
	""
	""
	"ŧ"
	"ŧŧ"
	"Ź"
	""
	"ǵ"
	"ह"
	""
	""
	""
	""
	"ɡ"
	"ɳ"
	""
	"Ե"
	""
	"⧡"
	"⧧"
	"⧧১"
	"⧹"
	""
	""
	""
	""
	""
	"⨡"
	"⨧"
	"⨷"
	"⨷"
	"⨷"
	"⨹"
	""
	""
	""
	"觤"
	""
	""
	"매"
	""
	"⩧੧"
	"⩴"
	"⩹"
	""
	"š"
	""
	"觩ҧ"
	"⪡"
	"⪤"
	"⪴"
	"⪴֡"
	"⪵"
	"⪹"
	""
	""
	""
	"⫡"
	"⫴"
	""
	""
	""
	""
	"µ"
	""
	""
	"ⴡഡ"
	"ⴴ"
	"ⴹ"
	""
	""
	""
	""
	""
	"ⵡ"
	"ⵧ൧"
	"⵹"
	"⵹"
	""
	"á"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"⶧"
	"ⶺ"
	""
	""
	"ⷡ෡"
	"ⷧ"
	"ⷧ෧"
	"ⷹ"
	""
	""
	"äҤ"
	"÷ȹ"
	"÷ȹ"
	"þ"
	"Ҿ"
	""
	"Ѿ"
	"Ţ"
	""
	"ҹ"
	""
	""
	"Ҥ"
	""
	""
	""
	""
	"⹹"
	""
	""
	""
	""
	""
	""
	""
	"⺡"
	"⺡ó"
	"⺵"
	"⺹"
	""
	"չ"
	"͹"
	"ҳ"
	""
	"ʶ"
	""
	""
	""
	"⻡"
	"⻧"
	"⻹"
	""
	"ç"
	"ô"
	"õ͹"
	"õչ"
	"õ"
	""
	""
	""
	"ᵹ"
	""
	""
	""
	""
	"ʡ"
	""
	""
	"Ź"
	""
	"觢"
	""
	""
	""
	""
	""
	"¹"
	""
	""
	"⼧"
	"⼹"
	""
	"šš"
	"Ź"
	""
	""
	""
	""
	"⾡"
	"⾧"
	"⾫Ե͹"
	"⾸ԭҳ"
	"⾸Ժѧ"
	"⾸"
	"⾸ѵ"
	"⾸"
	"⾹"
	"⾹й"
	""
	"¡ǹ"
	""
	"á"
	"ç"
	"д"
	""
	"ŧ"
	"Ź"
	""
	""
	""
	"ʾ"
	""
	""
	"⿡"
	"⿹"
	""
	"Թ"
	""
	""
	""
	"ҡ"
	"ҡ"
	""
	""
	"ѭ"
	""
	"¡"
	""
	""
	""
	"ѹ"
	"Ժչ"
	""
	""
	"Ҥ"
	""
	""
	"š"
	"ʡ"
	""
	""
	""
	""
	""
	""
	""
	"¡"
	"¡"
	"¤"
	"¤"
	"§"
	"ª"
	"¸"
	"¸Թ"
	"¹"
	"¹"
	""
	""
	""
	""
	""
	""
	""
	"ä"
	"äԵ"
	"ä"
	"äҾҸ"
	"ç"
	"ç"
	"è"
	"è"
	"õ"
	"ø"
	"ø"
	""
	"ѹ"
	""
	""
	""
	"Ե"
	""
	""
	"š"
	"šԷ"
	"šѹ"
	"š"
	"šҸԺ"
	"šҸԻ"
	"š"
	"šԹ"
	"š"
	"šѵ"
	"š"
	"šصø"
	"šص"
	"ŧ"
	"Ũ"
	"ų"
	"Ŵ"
	"Ź"
	""
	""
	""
	""
	"Ѫ"
	"Ե"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ȡ"
	"ȡѹ"
	"ȡ"
	"ȡҴ"
	"ȡ"
	"ȡ"
	"ȳ"
	"ȳ"
	"ȸ"
	"ȸ"
	"ʴ"
	"ʴ"
	"ʴҺѹ"
	"ʵ"
	"ʷ"
	"ʷ"
	"ʹ"
	""
	""
	"Գ"
	""
	""
	""
	""
	""
	"è"
	""
	"ó"
	""
	""
	""
	"á"
	"˧"
	"˴"
	"˹"
	"˹"
	""
	""
	""
	""
	"¡¡"
	"§"
	""
	""
	"çç"
	"о"
	""
	"Ҩ"
	"ʵ"
	""
	"ŧ"
	"Ź"
	""
	""
	"ǡǡ"
	"ǧ"
	"ǵ"
	""
	""
	""
	"͡"
	"͡"
	"͡Թ"
	"ͧ"
	"ͧ⢴"
	"ͪ"
	"ͪ"
	"ʹ"
	"͵ѻ"
	"͹"
	"ͺ"
	""
	""
	""
	""
	""
	"о"
	"ԡ"
	"ҷ"
	"ɰ"
	"ɰ"
	"ʶ"
	"ѧ"
	""
	""
	"ԡ"
	"֡"
	"ͫ"
	"⫹"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"η"
	"λ"
	"λ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"˭"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"䩹"
	""
	""
	""
	""
	""
	"䫹"
	"䫺"
	"䫻"
	"乴"
	""
	""
	"ù"
	"Ź"
	""
	""
	"䴹"
	"䴹"
	""
	""
	""
	""
	"ͧ"
	""
	""
	""
	""
	"ѹ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"乵Ѻ"
	"͹"
	""
	"ਹ"
	""
	"ɳºó"
	"ɳºѵ"
	"ɳѳ"
	"ɳѵ"
	"ɳҡ"
	"ɳ"
	""
	""
	""
	""
	"伷"
	""
	""
	""
	"侨Ե"
	"侱"
	"侺"
	""
	""
	""
	"Թ"
	""
	""
	""
	"è"
	""
	"͡"
	""
	"俿"
	""
	"͹"
	""
	"Һ"
	""
	""
	"ǿ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"ǡٳ"
	"Ǳ"
	"Ƿ"
	"ǹ"
	"Ǿ"
	"ҡó"
	"Ѩ"
	"Ѩ"
	""
	"Թ"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"˹"
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	""
	"Ź"
	"ȡ"
	""
	""
	"͹"
	"ⷻ"
	"ʹչ"
	""
	"δ"
	"෤"
	""
	""
	"ä͹"
	"ਹ"
	""
	)))
  (setq thai-word-table (list 'thai-words))
  (while l
    (set-nested-alist (car l) 1 thai-word-table)
    (setq l (cdr l))))


(defun thai-update-word-table (file &optional append)
  "Update Thai word table by replacing the current word list with
FILE.  If called with a prefix argument, FILE is appended instead to
the current word list."
  (interactive "FThai word table file: \nP")
  (let ((buf (generate-new-buffer "*thai-work*"))
	(coding-system-for-read 'thai-tis620)
	(table (if append thai-word-table (list 'thai-words))))
    (unwind-protect
	(save-excursion
	  (set-buffer buf)
	  (insert-file-contents file)
	  (goto-char (point-min))
	  (while (re-search-forward "\\ct+" nil t)
	    (set-nested-alist (match-string 0) 1 table)))
      (kill-buffer buf))
    (setq thai-word-table table)))


;; Two special Thai characters regarded as suffix of words.

(defconst thai-MaiYaMok (make-char 'thai-tis620 ?\xE6))
(defconst thai-PaiYanNoi (make-char 'thai-tis620 ?\xCF))


;; Find Thai words starting at POS and return a list of positions of
;; the Thai word ends.  It doesn't move point.  LIMIT limits the
;; maximum position.  IGNORE is a list of positions to ignore.  It is
;; assumed that all following characters to LIMIT are Thai.  If the
;; following char is not Thai (i.e., POS is equal to LIMIT), return t.
;;
;; Note that the longest word position comes first.

(defun thai-find-word-ends (pos limit &optional ignore)
  (if (>= pos limit)
      t
    (let* ((char (char-after pos))
	   (this (cdr (assq char (cdr thai-word-table))))
	   category-set
	   positions)
      ;; Look up the following character sequence in `thai-word-table'
      ;; character by character.
      (while this
	(setq pos (1+ pos)
	      char (char-after pos)
	      category-set (char-category-set char))
	;; If the current sequence is recorded in `thai-word-table'
	;; (i.e. (car THIS) is 1) and the following Thai character is
	;; not an upper-vowel, lower-vowel, or tone-mark, we have
	;; found a possible word ending position.
	(if (and (eq (car this) 1)
		 (not (or (aref category-set ?2)
			  (aref category-set ?3)
			  (aref category-set ?4))))
	    (progn
	      ;; Skip possible Thai suffices.
	      (while (or (eq char thai-MaiYaMok) (eq char thai-PaiYanNoi))
		(setq pos (1+ pos)
		      char (char-after pos)))
	      ;; Skip character positions in IGNORE list.
	      (or (memq pos ignore)
		  (setq positions (cons pos positions)))))
	;; Set up next loop.
	(setq this (and (< pos limit) (cdr (assq char this)))))
      positions)))


;; Move point forward to the end of Thai word which follows point and
;; update VEC.	VEC is a vector of three elements used to cache word
;; end positions.  The Nth element, if non-nil, is a list of end
;; points of the Nth word, or t indicating that there is no Thai
;; character.  LIMIT limits the point movement.

(defun thai-forward-word-update-info (vec limit)
  (let ((pos (point))
	v0 v1 v2 v3
	second-best
	tried
	positions)
    (if
	;; If four succeeding Thai words are found, throw t, otherwise
	;; throw nil.
	(catch 'tag
	  ;; Start with first vector element.
	  (setq v0 (aref vec 0))
	  (unless v0
	    ;; Update VEC if V0 is empty.
	    (setq v0 (thai-find-word-ends pos limit))
	    (aset vec 0 v0)
	    (aset vec 1 nil))
	  ;; In case we haven't found any wordbreaks resp. point has
	  ;; reached LIMIT, exit the catch body.
	  (if (symbolp v0)		; i.e. nil or t?
	      (throw 'tag nil))
	  ;; OK, V0 holds possible word ends for the current position.
	  ;; We save V0 for later reference.
	  (setq tried v0)
	  (setq v1 (aref vec 1))
	  ;; Now we try all end word positions to find the next word.
	  (while v0
	    (setq pos (car v0))
	    (unless v1
	      ;; Update VEC if V1 is empty, ignoring positions already
	      ;; found -- for Thai, we need the longest match, so if
	      ;; we have
	      ;;
	      ;;   start(long-word) = start(short-word1)
	      ;;   end(short-word1) = start(short-word2)
	      ;;   end(short-word2) = end(long-word)
	      ;;
	      ;; only long-word is used.
	      (setq v1 (thai-find-word-ends pos limit tried))
	      (aset vec 1 v1)
	      (aset vec 2 nil))
	    ;; If point has reached LIMIT, exit the catch body.
	    (if (eq v1 t)
		(throw 'tag t))
	    ;; Save SECOND-BEST, if this hasn't been done already.
	    ;; The `second best' solution is the end position of the
	    ;; longest first word followed by the longest second word.
	    (or second-best
		(not v1)
		(setq second-best (cons v0 v1)))
	    ;; Update the already tried end word positions.
	    (setq tried (append tried v1))
	    ;; Now repeat the whole process to find a third word.
	    (when v1
	      (setq v2 (aref vec 2))
	      (while v1
		(setq pos (car v1))
		(unless v2
		  (setq v2 (thai-find-word-ends pos limit tried))
		  (aset vec 2 v2))
		(if (eq v2 t)
		    (throw 'tag t))
		(setq tried (append tried v2))
		;; And the same for a fourth word.
		(while v2
		  (setq pos (car v2))
		  (setq v3 (thai-find-word-ends pos limit tried))
		  (if v3
		      (throw 'tag t))
		  (setq v2 (cdr v2)))
		(setq v1 (cdr v1))))
	    (setq v0 (cdr v0)))
	  ;; No success.
	  nil)
	(progn
	  ;; We found four succeeding Thai words (or LIMIT has been
	  ;; reached).	Move to the end of the first word.
	  (goto-char (car v0))
	  ;; Update VEC for the next function call.  If no larger word
	  ;; positions have been found, set the corresponding vector
	  ;; element to nil.
	  (if (and (consp v1) (< (car v1) (car (aref vec 1))))
	      (aset vec 0 nil)
	    (aset vec 0 v1)
	    (if (and (consp v2) (< (car v2) (car (aref vec 2))))
		(aset vec 1 nil)
	      (aset vec 1 v2)
	      (aset vec 2 v3)))) ; exit function successfully

      ;; We didn't find four consecutive words.	 If we have found a
      ;; `second best' solution and the length of those two words is
      ;; longer than the longest word we can see at the current point,
      ;; adopt the second best solution.  This decision is based on
      ;; heuristic tests.
      (if (and second-best
	       (< (car (aref vec 0)) (car (cdr second-best))))
	  (progn
	    (goto-char (car (car second-best)))
	    (aset vec 0 (cdr second-best)))
	;; We finally failed to find a word break.  For Thai, the best
	;; solution is to extend the first longest word so that the
	;; end point starts a second word.
	(setq pos (or (car (aref vec 0)) pos))
	(while (and (< pos limit)
		    (not (setq positions (thai-find-word-ends pos limit))))
	  (setq pos (1+ pos)))
	(goto-char pos)
	(aset vec 0 positions))
      (aset vec 1 nil)
      nil)))


;; Return a list of Thai word boundary positions after the current
;; point.  LIMIT, if non-nil, limits the region to check.

(defun thai-find-word-boundaries (&optional limit)
  (or limit
      (setq limit (point-max)))
  (save-excursion
    (let ((vec (make-vector 3 nil))
	  (boundaries nil)
	  this-limit)
      ;; Loop over all (consecutive) Thai regions by using the
      ;; character property `t' until LIMIT is reached.
      (while (and (< (point) limit)
		  (re-search-forward "\\ct+" nil t))
	(setq this-limit (point))
	(goto-char (match-beginning 0))
	(fillarray vec nil)
	;; Check the first word, initializing VEC.
	(thai-forward-word-update-info vec this-limit)
	;; Then loop over the remaining words in the current Thai
	;; region, collecting the boundaries.
	(while (< (point) this-limit)
	  (setq boundaries (cons (point) boundaries))
	  (thai-forward-word-update-info vec this-limit)))
      boundaries)))


(defun thai-break-words (separator &optional limit)
  "Break Thai words by inserting a separator string at word boundaries."
  (interactive "sSeparator: ")
  (save-excursion
    (let ((boundaries (thai-find-word-boundaries limit)))
      (while boundaries
	(goto-char (car boundaries))
	(insert separator)
	(setq boundaries (cdr boundaries))))))


(defun thai-forward-word (count)
  "Move point forward COUNT words considering Thai word boundaries.
If COUNT is negative, move point backward (- COUNT) words."
  (interactive "p")
  (if (> count 0)
      (while (> count 0)
	(skip-syntax-forward "^w")
	(if (looking-at "\\ct+")
	    ;; We have reached a Thai region, so we must do something
	    ;; special instead of using forward-word.
	    (let ((start (point))
		  (limit (match-end 0))
		  boundaries
		  tail)
	      ;; If thai-forward-word has been called within a Thai
	      ;; region, we must go back until the Thai region starts
	      ;; to do the contextual analysis for finding word
	      ;; breaks.
	      (while (aref (char-category-set (preceding-char)) ?t)
		(forward-char -1))
	      ;; OK, we ask for the list of word boundaries in
	      ;; reversed order.
	      (setq boundaries (nreverse (thai-find-word-boundaries limit)))
	      ;; Now we search for the next boundary after START.
	      (while (and boundaries (<= (car boundaries) start))
		(setq boundaries (cdr boundaries)))
	      ;; Adjust loop for next while loop.
	      (setq count (1- count))
	      ;; Now we skip Thai words until the BOUNDARIES list is
	      ;; empty or count-1 words have been passed.
	      (if (not boundaries)
		  (goto-char limit)
		(while (and (> count 0)
			    boundaries)
		  (setq boundaries (cdr boundaries)
			count (1- count)))
		;; If BOUNDARIES is empty, the word counter is not
		;; zero yet (remember that we have decreased COUNT by
		;; one), so we go to LIMIT.  Otherwise go to next
		;; boundary.
		(if boundaries
		    (goto-char (car boundaries))
		  (goto-char limit))))
	  ;; No Thai region.
	  (forward-word 1)
	  (setq count (1- count))))
    ;; The symmetrical action for negative values.
    (if (< count 0)
	(while (< count 0)
	  (skip-syntax-backward "^w")
	  (if (aref (char-category-set (preceding-char)) ?t)
	      (let ((start (point))
		    (limit (if (looking-at "\\ct+") (match-end 0)
			     (point)))
		    boundaries)
		(forward-char -1)
		(while (aref (char-category-set (preceding-char)) ?t)
		  (forward-char -1))
		(setq boundaries (thai-find-word-boundaries limit))
		(while (and boundaries (>= (car boundaries) start))
		  (setq boundaries (cdr boundaries)))
		(setq count (1+ count))
		(if boundaries
		    (progn
		      (while (and (< count 0) boundaries)
			(setq boundaries (cdr boundaries)
			      count (1+ count)))
		      (if boundaries
			  (goto-char (car boundaries))))))
	    (forward-word -1)
	    (setq count (1+ count)))))))


(defun thai-backward-word (count)
  "Move point backward COUNT words considering Thai word boundaries.
If COUNT is negative, move point forward (- COUNT) words."
  (interactive "p")
  (thai-forward-word (- count)))


(provide 'thai-word)


;; Local Variables:
;; coding: tis-620
;; End:

;; end of thai-word.el
