/* findfile.c 2.9.0 92/07/06 -- small routine to find a file using a searchpath
   (Simplified from earlier version) */

/* Copyright (c) 1991 Damian Cugley -- see file COPYING for details. */

#include <errno.h>

#include "config.h"
#include "strmisc.h"		/* includes <string(s).h> */
#include "searchpath.h"

extern int errno;

#define OK_P(FNAME,SUFFIX) \
  (access((FNAME), 04) == 0 || \
   ((SUFFIX) && *(SUFFIX) && access(strcat((FNAME), (SUFFIX)), 04) == 0))

#define TRUE 1
#define FALSE 0

int				/* boolean */
findfile(buf, fname, path, suffix)
     char      *buf;
     const char *fname, *path, *suffix;
{
  int		access ARGS((const char *, int));  
  const char   *p;
  char         *q;
  int		ok = FALSE;

  /*
   *  If no file name, give up:
   */
  if (!fname || !*fname || !buf) {errno = EINVAL; return FALSE;}

  /*
   *  If no path, or file is absolute, then don't search:
   */
  if (!path || *path == '\0' || absolute_path_p(fname))
    return OK_P(strcpy(buf, fname), suffix);

  q = buf, p = path; 
  for ( ;; ) /* scan the path */
    if ( !(*q++ = *p++) || *(q - 1) == path_sep_ch
#ifdef path_sep_ch2
	|| *(q - 1) == path_sep_ch2
#endif
	)
      {
	if (--q != buf && (*(q - 1) != dir_sep_ch
#ifdef dir_sep_ch2
			   || *(q - 1) != dir_sep_ch2
#endif
			   ))
	  *q++ = dir_sep_ch;	
				/* append / iff nonempty dirname */
	(void)strcpy(q, fname);
	if ((ok = OK_P(buf, suffix)) || !*(p - 1)) break;
				/* if match or end of path then break */
	q = buf;
      }

  return ok;
}
