{$N-,V-,W-,G+}

Unit wbibabv2;
           
Interface

Uses
  Strings, WObjects, WinTypes, WinProcs, Wbibdisp, wbibgui, rc_id, WinDOS,
  commdlg, wbibslct, rc_strng, win31,
  bibvars, bibfile, bibstrg, bibutil, bibreadb, bibreach, bib8bit, lfnunit,
  wc_help, wbibabv1;

type

  PEditAnAbbrevDlg = ^TEditAnAbbrevDlg;
  TEditAnAbbrevDlg = object(TBasicDialog)
    P: POneStringObj;
    NameEBox:  PEditNoCr;
    ValueEBox: PEditBalanced;
    Title: PChar;
    Abbrevs: PAbbrevList;
    Exclude: integer;
    AllowPreamble: boolean;
    constructor init(AParent: PWindowsObject; AP: POneStringObj;
                     ATitle: PChar; AAbbrevs: PAbbrevList; AExclude: integer;
                     AAllowPreamble: boolean);
    procedure   Update;
    procedure   SetupWindow;       virtual;
    function    CanClose: boolean; virtual;
    procedure   PreambleCBox(var Msg: TMessage); virtual id_first+dl_EditAStringPreamble;
    procedure   ok(var Msg: TMessage);           virtual id_first+id_ok; 
  end;

  PEdAbbrevsDlg = ^TEdAbbrevsDlg;
  TEdAbbrevsDlg = object(TResizableDialog)
    Abbrevs: PAbbrevList;
    changed,Sorted,AmWaiting,AllowPreamble,LoadHook: boolean;
    SymbolFont,ListFont: HFont;
    StrUpFont,StrDnFont: HFont;
    Title: PChar;
    LineHeight,Width: integer;
    constructor init(AParent: PWindowsObject; AName: PChar;
                     APosRec: InitialSizePtr; AAbbrevs: PAbbrevList;
                     ATitle: PChar; AAllowPreamble, ALoadHook: boolean);
    procedure   wmActivate(var Msg: TMessage);    virtual wm_first+wm_Activate;
    procedure   wmMeasureItem(var Msg: TMessage); virtual wm_first+wm_MeasureItem;
    procedure   wmDrawItem(var Msg: TMessage);    virtual wm_first+wm_DrawItem;
    procedure   FixControlPos; virtual;
    procedure   SetupWindow;   virtual;
    procedure   wmDestroy(var Msg: TMessage); virtual wm_first+wm_Destroy;
    procedure   UploadList;
    procedure   Update;        virtual;
    procedure   Import(var Ab: TAbbrevList; fname: string);

    procedure   Accels(var Msg: TMessage);     virtual wm_first+bib_KbHook;
    procedure   EditBtn(var Msg: TMessage);    virtual id_first+dl_EdStringsEdit;
    procedure   UpDown(up: boolean);
    procedure   UpBtn(var Msg: TMessage);      virtual id_first+dl_EdStringsUp;
    procedure   DownBtn(var Msg: TMessage);    virtual id_first+dl_EdStringsDown;
    procedure   DeleteBtn(var Msg: TMessage);  virtual id_first+dl_EdStringsDelete;
    procedure   InsertAppend(DoAppend: boolean);
    procedure   InsertBtn(var Msg: TMessage);  virtual id_first+dl_EdStringsInsert;
    procedure   AppendBtn(var Msg: TMessage);  virtual id_first+dl_EdStringsAppend;

    procedure   Resort(Up,Down: boolean);      virtual;
    procedure   HandleLBox(var Msg: TMessage); virtual id_first+dl_EdStringsLBox;
    procedure   ok(var Msg: TMessage);         virtual id_first+id_ok;
    destructor  done; virtual;
  end;

  PViewAbbrevsDlg = ^TViewAbbrevsDlg;
  TViewAbbrevsDlg = object(TEdAbbrevsDlg)
    CopyList: PCopyListCol;
    constructor init(AParent: PWindowsObject; AAbbrevs: PAbbrevList;
                     ATitle: PChar; ACopyList: PCopyListCol);
    procedure   FixControlPos; virtual;
    procedure   SetupWindow;   virtual;
    procedure   Update;        virtual;
    procedure   HandleLBox(var Msg: TMessage); virtual id_first+dl_EdStringsLBox;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PEdStringsDlg = ^TEdStringsDlg;
  TEdStringsDlg = object(TEdAbbrevsDlg)
    constructor init(AParent: PWindowsObject; AAbbrevs: PAbbrevList);
    procedure   SetupWindow;   virtual;
    procedure   FixControlPos; virtual;
    procedure   Resort(Up,Down: boolean);      virtual;
    procedure   HandleAsc(var Msg: TMessage);  virtual id_first+dl_EdStringsAscending;
    procedure   HandleDesc(var Msg: TMessage); virtual id_first+dl_EdStringsDescending;
    procedure   HandleUns(var Msg: TMessage);  virtual id_first+dl_EdStringsUnsorted;
    procedure   ImpBibBtn(var Nsg: TMessage);  virtual id_first+dl_EdStringsImpBIB;
    procedure   ImpBstBtn(var Nsg: TMessage);  virtual id_first+dl_EdStringsImpBST;
  end;

  PEdIniAbbrevsDlg = ^TEdIniAbbrevsDlg;
  TEdIniAbbrevsDlg = object(TEdAbbrevsDlg)
    constructor init(AParent: PWindowsObject; AAbbrevs: PAbbrevList);
    procedure   FixControlPos; virtual;
    procedure   SetupWindow;   virtual;
    procedure   SortUpBtn(var Msg: TMessage);   virtual id_first+dl_EdStringsSortUp;
    procedure   SortDownBtn(var Msg: TMessage); virtual id_first+dl_EdStringsSortDown;
    procedure   BrowseBibBtn(var Msg: TMessage);virtual id_first+dl_AbbrevsBIBBtn;
    procedure   BrowseBstBtn(var Msg: TMessage);virtual id_first+dl_AbbrevsBSTBtn;
    procedure   ViewBibBtn(var Msg: TMessage);  virtual id_first+dl_AbbrevsBIBView;
    procedure   ViewBstBtn(var Msg: TMessage);  virtual id_first+dl_AbbrevsBSTView;
    procedure   ok(var Msg: TMessage);          virtual id_first+id_ok;
  end;

var
  BibAbbrevsFile, BSTAbbrevsFile: PString;

procedure LoadStringAbbrevs(var Abbrevs: TAbbrevList; Entry: EntryRecPtr);
procedure LoadIniAbbrevs(var Abbrevs: TAbbrevList);
procedure LoadBSTAbbrevs(var Abbrevs: TAbbrevList; fname: string);
procedure LoadBibAbbrevs(var Abbrevs: TAbbrevList; fname: string;
                         Entry: EntryRecPtr);


implementation

const
  MaxLineLen = 990;
  BibTeXStylesExtension='.bst';
  LookForBIBPrompt='@STRINGs file';
  LookForBSTPrompt='BibTeX style file';


function IsBalanced(S: string): boolean;
var
  i,nbr: integer;
  o_k: boolean;
begin
  nbr:=0; o_k:=true;
  for i:=1 to length(S) do
  begin
    if (S[i]=lbrace) then inc(nbr)
    else if (S[i]=rbrace) then dec(nbr);
    if nbr<0 then o_k:=false;
  end;
  IsBalanced:=o_k and (nbr=0);
end;

{ TEditAnAbbrevDlg methods }

constructor TEditAnAbbrevDlg.Init(AParent: PWindowsObject; AP: POneStringObj;
                                  ATitle: PChar; AAbbrevs: PAbbrevList;
                                  AExclude: integer;
                                  AAllowPreamble: boolean);
begin
  TBasicDialog.init(AParent,PChar(rc_EditAStringDlg));
  P:=AP;
  Title:=ATitle;
  Abbrevs:=AAbbrevs;
  Exclude:=AExclude;
  AllowPreamble:=AAllowPreamble;
  New(NameEBox, InitResource(@Self,dl_EditAStringName,255,NameForbid));
  New(ValueEBox,InitResource(@Self,dl_EditAStringValue,MaxBig,[#0..#31]));
end;                          { TEditAnAbbrevDlg.Init }

procedure TEditAnAbbrevDlg.Update;
var
  F: array[0..30] of char;
  name: string[30];
begin
  if not AllowPreamble then Exit;
  EnableWindow(GetItemHandle(dl_EditAStringName),true);
  if IsDlgButtonChecked(HWindow,dl_EditAStringPreamble)=bf_Checked then
  begin
    StrPCopy(F,PreambleEntryName);
    SetDlgItemText(HWindow,dl_EditAStringName,F);
    EnableWindow(GetItemHandle(dl_EditAStringName),false);
  end else
  begin
    GetDlgItemText(HWindow,dl_EditAStringName,F,length(PreambleEntryName)+1);
    name:=StrPas(F); StrLwr(name);
    if name=PreambleEntryName then
    begin
      StrPCopy(F,'');
      SetDlgItemText(HWindow,dl_EditAStringName,F);
    end;
  end;
end;                               { TEditAnAbbrevDlg.Update }

procedure TEditAnAbbrevDlg.SetupWindow;
var
  F: array[0..255] of char;
begin
  TBasicDialog.SetupWindow;
  if Title<>Nil then SetWindowText(HWindow,Title);
  if (P^.SName<>Nil) then
  begin
    StrPCopy(F,P^.SName^);
    SetDlgItemText(Hwindow,dl_EditAStringName,F);
  end;
  if (P^.SValue<>Nil) then
    SetDlgItemText(HWindow,dl_EditAStringValue,P^.SValue);
  if AllowPreamble then
  begin
    if (P^.SName<>Nil) and (StrCmpI(P^.SName^,PreambleEntryName,1,1,255)=0) then
      CheckDlgButton(HWindow,dl_EditAStringPreamble,bf_Checked);
  end else
  begin
    EnableWindow(GetItemHandle(dl_EditAStringPreamble),false);
    ShowWindow(GetItemHandle(dl_EditAStringPreamble),sw_Hide);
  end;
  Update;
end;                      { TEditAnAbbrevDlg.SetupWindow }

function TEditAnAbbrevDlg.CanClose: boolean;
var
  F: array[0..255] of char;
  name: string;
  Pre: boolean;
  i: integer;
begin
  CanClose:=false;
  if not ValueEBox^.CanClose then Exit;
  GetDlgItemText(HWindow,dl_EditAStringName,F,255);
  if StrLen(F)=0 then Exit;
  name:=StrPas(F); StrLwr(name);
  pre:=(IsDlgButtonChecked(HWindow,dl_EditAStringPreamble)=bf_Checked);
  if pre and (name<>PreambleEntryName) then Exit;
  if not pre then
    for i:=1 to length(name) do
    if name[i] in NameForbid then Exit;

  if GetDlgItemText(HWindow,dl_EditAStringValue,F,9)=0 then Exit;

  if (Abbrevs<>Nil) and (Abbrevs^.FindName(name,Exclude)<>-1) then
  begin
    ErrorMessageRC(Str_ItemExists,StrPas(F)); Exit;
  end;
  CanClose:=true;
end;                           { TEditAnAbbrevDlg.CanClose }

procedure TEditAnAbbrevDlg.PreambleCBox(var Msg: TMessage);
begin
  Update;
end;

procedure TEditAnAbbrevDlg.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
  l: longint;
begin
  if not CanClose then Exit;
  with P^ do
  begin
    GetDlgItemText(HWindow,dl_EditAStringName,F,255);
    if SName<>Nil then DisposeStr(SName);
    SName:=NewStr(StrPas(F));

    l:=GetWindowTextLength(ValueEBox^.HWindow);
    if SValue<>Nil then FreeMem(SValue,StrLen(SValue)+1);
    GetMem(SValue,l+1);
    GetWindowText(ValueEBox^.HWindow,SValue,l+1);
  end;

  EndDlg(id_ok);
end;                          { TEditAnAbbrevDlg.ok }


{ TEdAbbrevDlg methods }
var
  ghAbbrevHook: HHook;
  AbbrevHookInst: TFarProc;
  AbbrevDlgActive: boolean;
  AbbrevAccelWnd: HWnd;

{$F+}
function TrapAbbrevHook(Code: integer; wParam: Word;
                                     lParam: longint): longint; export;
var
  Send: word;
begin
  Send:=0;
  if (Code<0) or (Code<>HC_ACTION) or (not AbbrevDlgActive) or
     (lParam and (wmChar_BeingReleased or  wmChar_KeyWasDown
                  or wmChar_AltPressed) <> 0) or AmWaiting then
       { Repeats, key releases and the like - ignore }
  else begin
    if (GetKeyState(vk_Control)<0) or (GetKeyState(vk_Shift)<0) then
    begin
      if wParam=vk_Up        then Send:=dl_EdStringsUp
      else if wParam=vk_Down then Send:=dl_EdStringsDown;
    end;
  end;

  if Send<>0 then
  begin
    PostMessage(AbbrevAccelWnd,bib_KbHook,Send,0);
    TrapAbbrevHook:=1;
  end else
      TrapAbbrevHook:=CallNextHookEx(ghAbbrevHook,Code,wparam,lparam);
end;                           { TrapAbbrevHook }
{$F-}

constructor TEdAbbrevsDlg.init(AParent: PWindowsObject; AName: PChar;
            APosRec: InitialSizePtr;
            AAbbrevs: PAbbrevList; ATitle: PChar;
            AAllowPreamble, ALoadHook: boolean);
begin
  TResizableDialog.init(AParent,AName,APosRec);
  Abbrevs:=AAbbrevs;
  Title:=ATitle;
  LoadHook:=ALoadHook;
  if AbbrevAccelWnd<>0 then LoadHook:=false;
  changed:=false; Sorted:=false;
  SymbolFont:=0;
  ListFont:=CreateHelvFont(true,@LineHeight);
  Width:=0;
  AllowPreamble:=AAllowPreamble;
  HelpContext:=hc_Abbreviations;
  if LoadHook then AbbrevDlgActive:=false;
end;                                { TEdAbbrevsDlg.init }

procedure TEdAbbrevsDlg.wmActivate(var Msg: TMessage);
begin
  if LoadHook then AbbrevDlgActive:=(Msg.wParam<>wa_InActive);
  TResizableDialog.wmActivate(Msg);
end;

procedure TEdAbbrevsDlg.FixControlPos;
begin
  NewControl(dl_EdStringsLBox,  RelTo_Left, RelTo_Right,RelTo_Top,RelTo_Bottom);

  NewControl(id_Cancel,         RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(id_ok,             RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);

  NewControl(dl_EdStringsEdit,  RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(dl_EdStringsUp,    RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(dl_EdStringsDown,  RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(dl_EdStringsInsert,RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(dl_EdStringsAppend,RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(dl_EdStringsDelete,RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
end;                                { TEdAbbrevsDlg.FixControlPos }

procedure TEdAbbrevsDlg.wmMeasureItem(var Msg: TMessage);
begin
  with PMeasureItemStruct(Msg.lParam)^ do
  begin
    ItemWidth:=0;
    ItemHeight:=LineHeight;
  end;
end;

procedure TEdAbbrevsDlg.wmDrawItem(var Msg: TMessage);
begin
  DrawTabbedLBoxItem(PDrawItemStruct(Msg.lParam),ListFont,false,Width,1,false);
end;

procedure TEdAbbrevsDlg.SetupWindow;
var
  L: TLogFont;
  OldFont: HFont;
  DC: HDC;
  Metrics: TTextMetric;
  F: array[0..1] of char;
begin
  TResizableDialog.SetupWindow;
  DisableSysMinimize;
  InitPos;

  StrUpFont:=HFont(SendDlgItemMsg(dl_EdStringsUp,wm_GetFont,0,0));
  StrDnFont:=HFont(SendDlgItemMsg(dl_EdStringsDown,wm_GetFont,0,0));
  DC:=GetDC(GetItemHandle(dl_EdStringsUp));
  OldFont:=SelectObject(DC,StrUpFont);
  GetTextMetrics(DC,Metrics);
  SelectObject(DC,OldFont);
  ReleaseDC(GetItemHandle(dl_EdStringsUp),DC);
  FillChar(L,sizeof(L),0);
  with L do
  begin
    lfHeight        := MulDiv(Metrics.tmHeight,9,10);
{    lfHeight        := -MulDiv(80,ScreenresY,720);}
    lfWidth         := 0;
    lfWeight        := fw_Bold;
    lfEscapement    := 0;
    lfCharSet       := Symbol_CharSet;
    lfOutPrecision  := Out_Default_Precis;
    lfClipPrecision := Clip_Default_Precis;
    lfQuality       := Default_Quality;
    lfPitchAndFamily:= Variable_Pitch or ff_DontCare;
    StrLCopy(@lfFaceName,'Symbol',lf_FaceSize-1);
  end;

  SymbolFont:=CreateFontIndirect(L);
  F[0]:=char($AD); F[1]:=#0;
  SetDlgItemText(HWindow,dl_EdStringsUp,F);
  SendDlgItemMsg(dl_EdStringsUp,  wm_SetFont,SymbolFont,1);
  F[0]:=char($AF); F[1]:=#0;
  SetDlgItemText(HWindow,dl_EdStringsDown,F);
  SendDlgItemMsg(dl_EdStringsDown,wm_SetFont,SymbolFont,1);

  if LoadHook then
  begin
    { Set keyboard hook for the accelerators }
    AbbrevHookInst:=MakeProcInstance(@TrapAbbrevHook,HInstance);
    ghAbbrevHook:=SetWindowsHookEx(wh_Keyboard,THookProc(AbbrevHookInst),
                                   Hinstance,GetCurrentTask);
    AbbrevDlgActive:=true;
    AbbrevAccelWnd:=HWindow;
  end;

  UploadList;
  SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,1,0);
  Update;
end;                               { TEdAbbrevsDlg.SetupWindow }

procedure TEdAbbrevsDlg.wmDestroy(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_EdStringsUp,  wm_SetFont,StrUpFont,0);
  SendDlgItemMsg(dl_EdStringsDown,wm_SetFont,StrDnFont,0);
  TResizableDialog.wmDestroy(Msg);
end;

procedure TEdAbbrevsDlg.UploadList;
const
  NTabs = 10;
var
  i,j,du,w: integer;
  ValueWidth: integer;
  F: PChar;
  H: HWnd;
  DC: hDC;
  OldFont: HFont;
begin
  SendDlgItemMsg(dl_EdStringsLBox,lb_ResetContent,0,0);
  GetMem(F,MaxLineLen+1);
  Width:=0; ValueWidth:=0;
  H:=GetItemHandle(dl_EdStringsLBox);
  DC:=GetDC(H);
  OldFont:=SelectObject(DC,ListFont);
  for i:=0 to Abbrevs^.Count-1 do
  with POneStringObj(Abbrevs^.at(i))^ do
  begin
    w:=LoWord(GetTextExtent(DC,@SName^[1],length(SName^)));
    if w>Width then Width:=w;
    
    j:=StrLen(SValue);
    if StrLen(F)+1+j>MaxLineLen then j:=MaxLineLen-StrLen(F)-1;
    w:=LoWord(GetTextExtent(DC,SValue,j));
    if w>ValueWidth then ValueWidth:=w;

    StrPCopy(F,SName^+#9);
    StrLCat(F,SValue,MaxLineLen);
    w:=LoWord(GetTextExtent(DC,SValue,StrLen(SValue)));
    if w>ValueWidth then ValueWidth:=w;
    SendDlgItemMsg(dl_EdStringsLBox,lb_AddString,0,longint(F));
  end;
  SelectObject(DC,OldFont);
  ReleaseDC(H,DC);
  du:=LoWord(GetDialogBaseUnits) div 4;
  width:=Width+8*du+TabbedLBox_XShift;
  SendDlgItemMsg(dl_EdStringsLBox,lb_SetHorizontalExtent,
        Width+ValueWidth+4*du,0);
  
  FreeMem(F,MaxLineLen+1);
end;                              { TEdAbbrevsDlg.UploadList }

procedure TEdAbbrevsDlg.Update;
var
  Ind,Count,Nsel: Integer;
begin
  Nsel:=SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelCount,0,0);
  SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelItems,1,Longint(@Ind));
  Count:=SendDlgItemMsg(dl_EdStringsLBox,lb_GetCount,0,0);

  EnableWindow(GetItemHandle(dl_EdStringsEdit),  (NSel=1) and (Count>0) and (Ind<>lb_Err));
  EnableWindow(GetItemHandle(dl_EdStringsDelete),(Count>0) and (Ind<>lb_Err));
  EnableWindow(GetItemHandle(dl_EdStringsInsert),(Count=0) or
                    ((Nsel=1) and (Sorted or ((Count>0) and (Ind<>lb_Err)))));
  EnableWindow(GetItemHandle(dl_EdStringsAppend),(Nsel=1) and (not Sorted) and
                                 ((Ind<>lb_Err) or (Count=0)));
  EnableWindow(GetItemHandle(dl_EdStringsUp),  (Nsel=1) and (not Sorted) and (Ind<>lb_Err)
                                                and (Ind>0));
  EnableWindow(GetItemHandle(dl_EdStringsDown),(NSel=1) and (not Sorted) and (Ind<>lb_Err)
                                                and (Ind<Count-1));
end;

procedure TEdAbbrevsDlg.Accels(var Msg: TMessage);
begin
  case Msg.wParam of
    dl_EdStringsUp:   UpDown(true);
    dl_EdStringsDown: UpDown(false);
  end;
end;

procedure TEdAbbrevsDlg.Import(var Ab: TAbbrevList; fname: string);
var
  i: integer;
  CopyList: TCopyListCol;
  F: array[0..255] of char;
begin
  if Ab.Count=0 then Exit;
  StrPCopy(F,fname);
  CopyList.Init(Ab.Count,50);
  if Application^.ExecDialog(New(PViewAbbrevsDlg,
                            init(@Self,@Ab,@F,@CopyList)))=id_ok then
  begin
    for i:=0 to CopyList.Count-1 do
    with PCopyListObj(CopyList.at(i))^ do
      if Abbrevs^.FindPName(Ab.at(Ind),-1)=-1 then
      with POneStringObj(Ab.at(Ind))^ do
        Abbrevs^.AtInsert(-1,New(POneStringObj,ValueInit(SName^,SValue)));
    UploadList; Update;
    Changed:=true;
  end;
  CopyList.Done;
end;                                 { TEdAbbrevsDlg.Import }

procedure TEdAbbrevsDlg.EditBtn(var Msg: TMessage);
var
  Ind,NSel,Tlen: integer;
  F: PChar;
  P: POneStringObj;
begin
  if SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelCount,0,0)<>1 then
  begin
    messagebeep(0); Exit;
  end;
  SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelItems,1,Longint(@Ind));
  if Ind=lb_Err then
  begin
    MessageBeep(0); Exit;
  end;
  P:=Abbrevs^.at(Ind);
  TLen:=StrLen(Title);
  GetMem(F,Tlen+1);
  StrCopy(F,Title);F[Tlen-1]:=#0;
  if (Application^.ExecDialog(New(PEditAnAbbrevDlg,Init(@Self,P,F,Abbrevs,Ind,
                                  AllowPreamble)))=id_ok) then
  begin
    Abbrevs^.AtDelete(Ind);
    Abbrevs^.AtInsert(Ind,P);
    Ind:=Abbrevs^.FindPName(P,-1);
    UploadList;
    Changed:=true;
    if ind>=0 then SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,1,Ind);
  end;
  FreeMem(F,TLen+1);
end;                               { TEdAbbrevsDlg.EditBtn }

procedure TEdAbbrevsDlg.UpDown(Up: boolean);
var
  Ind: integer;
  P: Pointer;
begin
  if SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelCount,0,0)<>1 then
  begin
    messagebeep(0); Exit;
  end;
  SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelItems,1,Longint(@Ind));
  if Sorted or (Ind=lb_Err) or (Up and (Ind=0)) or
                      (not up and (Ind>=Abbrevs^.Count-1))then
  begin
    MessageBeep(0); Exit;
  end;
  P:=Abbrevs^.at(Ind);
  Abbrevs^.AtDelete(Ind);
  if Up then dec(Ind) else inc(Ind);
  Abbrevs^.AtInsert(Ind,P);
  UploadList; Changed:=true;
  SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,0,MakeLong(Word(-1),0));
  SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,1,Ind);
  Update;
end;                                { TEdAbbrevDlg.UpDown }

procedure TEdAbbrevsDlg.UpBtn(var Msg: TMessage);
begin UpDown(true); end;

procedure TEdAbbrevsDlg.DownBtn(var Msg: TMessage);
begin UpDown(false); end;

procedure TEdAbbrevsDlg.DeleteBtn(var Msg: TMessage);
type
  IndArr = array[1..$7FFF div sizeof(Integer)] of Integer;
var
  Ind: ^IndArr;
  NSel,i,j,MaxI,MaxJ,Nread: integer;
begin
  Nsel:=SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelCount,0,0);
  if NSel<1 then Exit;

  GetMem(Ind,(NSel+2)*sizeof(Integer));
  Nread:=SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelItems,NSel,Longint(Ind));
  for i:=1 to NRead do
  begin
    MaxI:=-1; MaxJ:=0;
    for j:=1 to NRead do if MaxI<Ind^[j] then
    begin
      MaxI:=Ind^[j]; MaxJ:=j;
    end;
    if (MaxI>-1) and (MaxJ>0) then
    begin
      Abbrevs^.AtFree(MaxI);
      Ind^[MaxJ]:=-2;
    end;
  end;
  FreeMem(Ind,(NSel+2)*sizeof(Integer));

  UploadList;

  SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,0,MakeLong(Word(-1),0));
  if MaxI>=Abbrevs^.Count then dec(MaxI);
  if MaxI<0 then MaxI:=0;
  SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,1,MaxI);
  Changed:=true;
  Update;
end;                              { TEdAbbrevsDlg.DeleteBtn }

procedure TEdAbbrevsDlg.InsertAppend(DoAppend: boolean);
var
  P: POneStringObj;
  Ind,i,Count: integer;
begin
  Count:=SendDlgItemMsg(dl_EdStringsLBox,lb_GetCount,0,0);
  if (Count>0) and
    (SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelCount,0,0)<>1) then
  begin
    messagebeep(0); Exit;
  end;
  SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelItems,1,Longint(@Ind));
  if Ind=lb_Err then
  begin
    if Count<>0 then
    begin
      MessageBeep(0); Exit;
    end;
    Ind:=0;
  end else if DoAppend then inc(Ind);
  New(P,Init(Nil));
  if (Application^.ExecDialog(New(PEditAnAbbrevDlg,
           Init(@Self,P,Nil,Abbrevs,-1,AllowPreamble)))=id_ok) then
  begin
    if Count=0 then Abbrevs^.Insert(P)
    else Abbrevs^.AtInsert(Ind,P);
    Ind:=Abbrevs^.FindPName(P,-1);
    UploadList;
    SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,0,MakeLong(Word(-1),0));
    SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,1,Ind);
    Changed:=true;
  end else Dispose(P,Done);
  Update;
end;                            { TEdAbbrevsDlg.InsertAppend }

procedure TEdAbbrevsDlg.InsertBtn(var Msg: TMessage);
begin
  InsertAppend(false);
end;

procedure TEdAbbrevsDlg.AppendBtn(var Msg: TMessage);
begin
  InsertAppend(true);
end;

procedure TEdAbbrevsDlg.HandleLBox(var Msg: TMessage);
begin
  Update;
  if Msg.lParamhi=lbn_DblClk then EditBtn(Msg)
  else DefWndProc(Msg);
end;

procedure TEdAbbrevsDlg.ReSort(Up,Down: boolean);
var
  T: TAbbrevList;
  P: pointer;
  i: integer;
begin
  if not (Up or Down) then Exit;

  T.init(Abbrevs^.Count,10,Up,Down);
  for i:=0 to Abbrevs^.count-1 do T.Insert(Abbrevs^.at(i));
  Abbrevs^.DeleteAll;
  Abbrevs^.SortUp:=false; Abbrevs^.SortDown:=false;
  for i:=0 to T.Count-1 do Abbrevs^.AtInsert(i,T.at(i));
  T.DeleteAll; T.Done;
  Changed:=true;
  UploadList;
  SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,0,MakeLong(Word(-1),0));
  SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,1,0);
end;                             { TEdAbbrevsDlg.ReSort }

procedure TEdAbbrevsDlg.ok(var Msg: TMessage);
begin
  if not CanClose then Exit;
  if (not Changed) then EndDlg(id_cancel)
  else EndDlg(id_ok);
end;

destructor TEdAbbrevsDlg.Done;
begin
  if ListFont<>0   then DeleteObject(ListFont);
  if SymbolFont<>0 then DeleteObject(SymbolFont);
  if LoadHook then
  begin
    UnhookWindowsHookEx(ghAbbrevHook);
    FreeProcInstance(AbbrevHookInst);
    AbbrevAccelWnd:=0;
  end;
  TResizableDialog.done;
end;

{ TViewAbbrevsDlg methods }

constructor TViewAbbrevsDlg.init(AParent: PWindowsObject; AAbbrevs: PAbbrevList;
                                 ATitle: PChar; ACopyList: PCopyListCol);
begin
  TEdAbbrevsDlg.init(AParent,Pchar(rc_ViewAbbrevsDlg),@ViewAbbrevsSize,AAbbrevs,
                     ATitle,false,false);
  CopyList:=ACopyList;
  HelpContext:=hc_Abbreviations;
end;

procedure TViewAbbrevsDlg.FixControlPos;
begin
  NewControl(dl_EdStringsLBox, RelTo_Left, RelTo_Right,RelTo_Top,   RelTo_Bottom);
  NewControl(id_cancel,        RelTo_Right,RelTo_Size, RelTo_Bottom,RelTo_Size);
  NewControl(id_ok,            RelTo_Right,RelTo_Size, RelTo_Bottom,RelTo_Size);
end;

procedure TViewAbbrevsDlg.SetupWindow;
begin
  TResizableDialog.SetupWindow;
  DisableSysMinimize;
  InitPos;
  SetWindowText(HWindow,Title);

  UploadList;
  CopyList^.FreeAll;
  SendDlgItemMsg(dl_EdStringsLBox,lb_SetSel,1,0);
  Update;
end;                              { TViewAbbrevsDlg.SetupWindow }

procedure TViewAbbrevsDlg.Update;
begin
  EnableWindow(GetItemHandle(id_ok),
     SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelCount,0,0)>0);
end;

procedure TViewAbbrevsDlg.ok(var Msg: TMessage);
type
  IndArr = array[1..$7FFF div sizeof(Integer)] of Integer;
var
  Ind: ^IndArr;
  NSel,i,Nread: integer;
begin
  Nsel:=SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelCount,0,0);
  if NSel<1 then
  begin
    messagebeep(0); Exit;
  end;

  CopyList^.FreeAll;
  GetMem(Ind,(NSel+2)*sizeof(Integer));
  Nread:=SendDlgItemMsg(dl_EdStringsLBox,lb_GetSelItems,NSel,Longint(Ind));
  for i:=1 to NRead do CopyList^.Insert(New(PCopyListObj,init(Ind^[i])));
  FreeMem(Ind,(NSel+2)*sizeof(Integer));
  EndDlg(id_ok);
end;                           { TViewAbbrevsDlg.CopyBtn }

procedure TViewAbbrevsDlg.HandleLBox(var Msg: TMessage);
begin
  Update;
  DefWndProc(Msg);
end;

{ TEdStringsDlg methods }

constructor TEdStringsDlg.init(AParent: PWindowsObject;
            AAbbrevs: PAbbrevList);
begin
  TEdAbbrevsDlg.init(AParent,PChar(rc_EdStringsDlg),@EdStringsSize,AAbbrevs,
                     'Strings',true,true);
  Sorted:=Abbrevs^.SortUp or Abbrevs^.SortDown;
  HelpContext:=hc_EditStrings;
end;                                { TEdStringsDlg.init }

procedure TEdStringsDlg.SetupWindow;
var
  L: TLogFont;
  CurFont,OldFont: HFont;
  DC: HDC;
  Metrics: TTextMetric;
  F: array[0..1] of char;
begin
  TEdAbbrevsDlg.SetupWindow;

  if Abbrevs^.SortUp then
    CheckDlgButton(HWindow,dl_EdStringsAscending,1)
  else if Abbrevs^.SortDown then
    CheckDlgButton(HWindow,dl_EdStringsDescending,1)
  else
    CheckDlgButton(HWindow,dl_EdStringsUnsorted,1);
end;                               { TEdStringsDlg.SetupWindow }

procedure TEdStringsDlg.FixControlPos;
begin
  TEdAbbrevsDlg.FixControlPos;
  NewControl(dl_EdStringsImpBIB,RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(dl_EdStringsImpBST,RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
end;

procedure TEdStringsDlg.ReSort(Up,Down: boolean);
begin
  if (Up=Abbrevs^.SortUp) and (Down=Abbrevs^.SortDown) then Exit;
  if Up or Down then TEdAbbrevsDlg.ReSort(Up,Down);
  Abbrevs^.SortUp:=Up; Abbrevs^.SortDown:=Down;
  Sorted:=Up or Down;
  Update;
end;                             { TEdStringsDlg.ReSort }

procedure TEdStringsDlg.HandleAsc(var Msg: TMessage);
begin
  ReSort(IsDlgButtonChecked(HWindow,dl_EdStringsAscending) <>0,
         IsDlgButtonChecked(HWindow,dl_EdStringsDescending)<>0);
end;

procedure TEdStringsDlg.HandleDesc(var Msg: TMessage);
begin
  ReSort(IsDlgButtonChecked(HWindow,dl_EdStringsAscending) <>0,
         IsDlgButtonChecked(HWindow,dl_EdStringsDescending)<>0);
end;

procedure TEdStringsDlg.HandleUns(var Msg: TMessage);
begin
  ReSort(IsDlgButtonChecked(HWindow,dl_EdStringsAscending) <>0,
         IsDlgButtonChecked(HWindow,dl_EdStringsDescending)<>0);
end;

procedure TEdStringsDlg.ImpBibBtn(var Nsg: TMessage);
var
  fname: string;
  accept: boolean;
  F: array[0..255] of char;
  Ab: TAbbrevList;
  CopyList: TCopyListCol;
  i: integer;
begin
  fname:='*';
  FileChoose(fname,DefExtension[BibTeXFormat]^,TexInputList,
                   AnyFile and (not (Directory or SysFile)),
                   true,true,false,Nil,LookForBIBPrompt,DatabaseDesc,accept);
  if Accept then
  begin
    Ab.init(50,50,false,false);
    WaitingMessage('Reading...');
    IncludePreambles:=true;
    LoadBibAbbrevs(Ab,fname,Entry);
    IncludePreambles:=false;
    WaitingOff;
    Import(Ab,fname);
    Ab.Done;
  end;
end;                                     { TEdStringsDlg.ImpBibBtn }

procedure TEdStringsDlg.ImpBstBtn(var Nsg: TMessage);
var
  fname: string;
  accept: boolean;
  F: array[0..255] of char;
  Ab: TAbbrevList;
  CopyList: TCopyListCol;
  i: integer;
begin
  fname:='*';
  FileChoose(fname,BibTeXStylesExtension,BstInputList,
                   AnyFile and (not (Directory or SysFile)),
                   true,true,false,Nil,LookForBSTPrompt,BstDesc,accept);
  if Accept then
  begin
    Ab.init(50,50,false,false);
    WaitingMessage('Reading...');
    LoadBstAbbrevs(Ab,fname);
    WaitingOff;
    Import(Ab,fname);
    Ab.Done;
  end;
end;                             { TEdStringsDlg.ImpBstBtn }

{ TEdIniAbbrevsDlg methods }

constructor TEdIniAbbrevsDlg.init(AParent: PWindowsObject; AAbbrevs: PAbbrevList);
begin
  TEdAbbrevsDlg.init(AParent,PChar(rc_EdIniAbbrevsDlg),@EdAbbrevsSize,
                     AAbbrevs, 'Abbreviations',false,true);
  HelpContext:=hc_EditAbbreviations;
end;

procedure TEdIniAbbrevsDlg.FixControlPos;
begin
  TEdAbbrevsDlg.FixControlPos;

  NewControl(dl_AbbrevsBIBEBox,RelTo_Left,RelTo_Right,RelTo_Top,RelTo_Size);
  NewControl(dl_AbbrevsBSTEBox,RelTo_Left,RelTo_Right,RelTo_Top,RelTo_Size);
  NewControl(dl_AbbrevsBIBBtn, RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(dl_AbbrevsBstBtn, RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(dl_AbbrevsBIBView,RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(dl_AbbrevsBstView,RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
end;                                { TEdIniAbbrevsDlg.FixControlPos }

procedure TEdIniAbbrevsDlg.SetupWindow;
var
  F: array[0..255] of char;
begin
  TEdAbbrevsDlg.SetupWindow;
  if BIBAbbrevsFile^<>'' then
  begin
    StrPCopy(F,BIBAbbrevsFile^);
    SetDlgItemText(HWindow,dl_AbbrevsBIBEbox,F);
  end;
  if BSTAbbrevsFile^<>'' then
  begin
    StrPCopy(F,BSTAbbrevsFile^);
    SetDlgItemText(HWindow,dl_AbbrevsBSTEbox,F);
  end;
end;                            { TEdIniAbbrevsDlg.SetupWindow }

procedure TEdIniAbbrevsDlg.SortUpBtn(var Msg: TMessage);
begin
  ReSort(true,false);
  Update;
end;

procedure TEdIniAbbrevsDlg.SortDownBtn(var Msg: TMessage);
begin
  ReSort(false,true);
  Update;
end;

procedure TEdIniAbbrevsDlg.BrowseBIBBtn(var Msg: TMessage);
var
  fname: string;
  accept: boolean;
  F: array[0..255] of char;
begin
  fname:='*';
  FileChoose(fname,DefExtension[BibTeXFormat]^,TexInputList,
             AnyFile and (not (Directory or SysFile)),
             true,true,false,Nil,LookForBIBPrompt,DatabaseDesc,accept);
  if Accept then
  begin
    StrPCopy(F,fname);
    SetDlgItemText(HWindow,dl_AbbrevsBIBEbox,F);
    changed:=true;
  end;
end;                            { TEdIniAbbrevsDlg.BrowseBIBBtn }

procedure TEdIniAbbrevsDlg.BrowseBSTBtn(var Msg: TMessage);
var
  fname: string;
  accept: boolean;
  F: array[0..255] of char;
begin
  fname:='*';
  FileChoose(fname,BibTeXStylesExtension,BstInputList,
             AnyFile and (not (Directory or SysFile)),
             true,true,false,Nil,LookForBSTPrompt,BstDesc,accept);
  if Accept then
  begin
    StrPCopy(F,fname);
    SetDlgItemText(HWindow,dl_AbbrevsBSTEbox,F);
    changed:=true;
  end;
end;                         { TEdIniAbbrevsDlg.BrowseBSTBtn }

procedure TEdIniAbbrevsDlg.ViewBibBtn(var Msg: TMessage);
var
  F: array[0..255] of char;
  fname: string;
  l: integer;
  Ab: TAbbrevList;
  accept: boolean;
begin
  l:=GetDlgItemText(HWindow,dl_AbbrevsBibEBox,F,255);
  if l=0 then messagebeep(0)
  else begin
    fname:=StrPas(F);
    Ab.init(50,50,false,false);
    WaitingMessage('Reading...');
    LoadBibAbbrevs(Ab,fname,Entry);
    WaitingOff;
    if Ab.Count=0 then ErrorMessageRC(Str_AbNoStringsFound,fname)
    else begin
      FileChoose(fname,DefExtension[BibTeXFormat]^,TexInputList,
                   AnyFile and (not (Directory or SysFile)),
                   false,false,false,Nil,'',DatabaseDesc,accept);
      Import(Ab,fname);
    end;
    Ab.Done;
  end;
end;                              { TEdIniAbbrevsDlg.ViewBibBtn }

procedure TEdIniAbbrevsDlg.ViewBstBtn(var Msg: TMessage);
var
  F: array[0..255] of char;
  fname: string;
  l: integer;
  Ab: TAbbrevList;
  accept: boolean;
begin
  l:=GetDlgItemText(HWindow,dl_AbbrevsBstEBox,F,255);
  if l=0 then messagebeep(0)
  else begin
    fname:=StrPas(F);
    Ab.init(50,50,false,false);
    WaitingMessage('Reading...');
    LoadBstAbbrevs(Ab,fname);
    WaitingOff;
    if Ab.Count=0 then ErrorMessageRC(Str_AbNoMacrosFound,fname)
    else begin
      FileChoose(fname,BibTeXStylesExtension,BSTInputList,
                   AnyFile and (not (Directory or SysFile)),
                   false,false,false,Nil,'',DatabaseDesc,accept);
      Import(Ab,fname);
    end;
    Ab.Done;
  end;
end;                              { TEdIniAbbrevsDlg.ViewBstBtn }

procedure TEdIniAbbrevsDlg.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
begin
  if not CanClose then Exit;
  if (SendDlgItemMsg(dl_AbbrevsBibEBox,em_GetModify,0,0)<>0) or
     (SendDlgItemMsg(dl_AbbrevsBSTEBox,em_GetModify,0,0)<>0) then changed:=true;
  if (not Changed) then EndDlg(id_cancel)
  else begin
    GetDlgItemText(HWindow,dl_AbbrevsBibEbox,F,255);
    BIBAbbrevsFile^:=StrPas(F);
    GetDlgItemText(HWindow,dl_AbbrevsBstEbox,F,255);
    BSTAbbrevsFile^:=StrPas(F);
    EndDlg(id_ok);
  end;
end;                            { TEdIniAbbrevsDlg.ok }

{ Others }

procedure LoadStringAbbrevs(var Abbrevs: TAbbrevList; Entry: EntryRecPtr);
var
  Oreal,Oentry,Obeginning,n,i: longint;
  WasStrings,ok,WasLinked: boolean;
  P: POneStringObj;
  Ind,OCurrent,FirstFile,LastFile: integer;
begin
  Abbrevs.FreeAll;
  if not ExpandStrings then Exit;
  if not BibFileExists then Exit;

  WaitingMessage('Reading...');
  WasStrings:=EditOnlyStrings; WasLinked:=Linked;
  Oentry:=Entry^.EntryNum; Oreal:=Entry^.RealNum;
  OBeginning:=Entry^.Beginning;
  OCurrent:=CurrentBibFile;
  EditOnlyStrings:=true; Linked:=false;
  if WasLinked then
  begin 
    FirstFile:=1; LastFile:=MaxBibFiles;
  end else
  begin
    FirstFile:=CurrentBibFile; LastFile:=FirstFile;
  end;
  CloseFile(bib);
  for i:=FirstFile to LastFile do
  begin
    Bibname^:=BibFiles^[i].name; LFNAssign(bib,bibname^);
    ResetBib(Entry);
    n:=1; ok:=true;
    GetEntry(Entry,Nil,1,true,Nil,ok);
    if entry^.entrynum<1 then ok:=false;
    while ok do
    with Entry^ do
    begin
      inc(n);
      New(P,Init(Entry));
      with Abbrevs do
        if not Search(P,Ind) then AtInsert(-1,P)
        else Dispose(P,Done);
      GetEntry(Entry,Nil,n,true,Nil,ok);
      if Entry^.EntryNum<>n then ok:=false;
    end;
    CloseFile(bib);
  end;
  EditOnlyStrings:=WasStrings;
  if WasLinked then
  begin
    CurrentBibFile:=OCurrent;
    BibName^:=BibFiles^[OCurrent].name; LFNAssign(bib,bibname^);
    ResetBib(Entry);
    ReachEntry(Entry,oreal-BibFiles^[OCurrent].RealStart,
               oentry-BibFiles^[OCurrent].EntryStart,Obeginning,false);
    Entry^.EntryNum:=OEntry; Entry^.RealNum:=OReal;
    Linked:=true; CurrentBibFile:=OCurrent;
  end else
  begin
    ResetBib(Entry);
    if Oreal>0 then ReachEntry(Entry,oreal,oentry,Obeginning,false);
  end;
  WaitingOff;
end;                           { LoadStringAbbrevs }

procedure LoadIniAbbrevs(var Abbrevs: TAbbrevList);
const
  BufSize = 4096;
var
  i: integer;
  Buf,BufRoot,Value: PChar;
  SLen,Blength: word;
  P: POneStringObj;
  tmp: string;
  AbbrevSec: array[0..32] of char;
begin
  Abbrevs.FreeAll;
  if not ExpandIniAbbrevs then Exit;

  LoadString(HInstance,IniStr_AbbrevSec,AbbrevSec,32);
  GetMem(Buf,BufSize); BufRoot:=Buf;
  i:=GetPrivateProfileString(AbbrevSec,Nil,'',Buf,BufSize,IniFile);
  if i<3 then
  begin
    FreeMem(Buf,BufSize); Exit;
  end;
  i:=0;
  GetMem(Value,MaxBig+1);
  SLen:=StrLen(Buf);
  while Slen>0 do
  begin
    if SLen<=255 then
    begin
      tmp:=StrPas(Buf); StrLwr(tmp);
      GetPrivateProfileString(AbbrevSec,Buf,'',Value,MaxBig,IniFile);
      Blength:=StrLen(Value);
      if Blength>0 then
      with Abbrevs do
      begin
        if Prog8bit then
        begin
          Conv28bit(Value^,Blength,false);
          Value[Blength]:=#0;
        end;
        New(P,ValueInit(tmp,Value));
        if not Search(P,i) then AtInsert(-1,P)
        else Dispose(P,Done);
      end;
    end;
    Buf:=Buf+Slen+1;
    Slen:=StrLen(Buf);
  end;
  FreeMem(Value,MaxBig+1);
  FreeMem(BufRoot,BufSize);
end;                            { LoadIniAbbrevs }

procedure LoadBstAbbrevs(var Abbrevs: TAbbrevList; fname: string);
var
  b: text;
  line,tmp,value: string;
  P: POneStringObj;
  i: integer;
  Ind: byte;
  F: array[0..255] of char;
  accept: boolean;

begin
  Abbrevs.FreeAll;
  if fname='' then Exit;
  FileChoose(fname,BibTeXStylesExtension,BSTInputList,
                   AnyFile and (not (Directory or SysFile)),
                   false,false,false,Nil,'',BstDesc,accept);
  if (fname='') or (not accept) or (not IsFileName(fname)) or
                   (not LFNFileExist(fname)) then Exit;
  LFNNew(b,true); LFNAssign(b,fname);
  if LFNReset(b,0)<>0 then
  begin
    LFNDispose(b); Exit;
  end;
  repeat
    ReadLine(b,line,true);
    UnTabify(line); ChrDelL(line,' '); ChrDelR(line,' ');
    ind:=1; tmp:=''; value:='';
    WrdToken(tmp,line,' '+lbrace+rbrace,Ind); StrLwr(tmp);
    if tmp='macro' then
    begin
      if Ind=0 then line:=''
      else Delete(line,1,Ind-1);
      while (not eof(b)) and (line='') do
      begin
        ReadLine(b,line,true);
        UnTabify(line); ChrDelL(line,' '); ChrDelR(line,' ');
      end;
      if not eof(b) then
      begin
        StrRepl(line,'\"','\'#1,1,255,255);
        Ind:=1;
        WrdToken(tmp,line,' '+lbrace+rbrace,Ind); StrLwr(tmp);
        if Ind=0 then line:=''
        else delete(line,1,Ind-1);
        while (not eof(b)) and ((line='') or (line[1]<>'"')) do
        begin
          ReadLine(b,line,true);
          UnTabify(line);
          StrRepl(line,'\"','\'#1,1,255,255);
          i:=Pos('"',line); if i>0 then delete(line,1,i-1);
        end;
        if not eof(b) then
        begin
          delete(line,1,1);
          repeat
            i:=Pos('"',line);
            if i=0 then
            begin
              if value='' then value:=value+line
              else value:=value+' '+line;
              ReadLine(b,line,true);
            end else
            begin
              if value='' then value:=value+Copy(line,1,i-1)
              else value:=value+' '+Copy(line,1,i-1);
            end;
          until (eof(b)) or (i>0);
        end;
      end;
      if not IsBalanced(value) then value:='';
      if (tmp<>'') and (value<>'') then
      begin
        StrRepl(value,'\'#1,'\"',1,255,255);
        if Prog8bit then SConv28bit(value,false);
        StrPCopy(F,value);
        New(P,ValueInit(tmp,F));
        with Abbrevs do
        if not Search(P,i) then AtInsert(-1,P)
        else Dispose(P,Done);
      end;
    end;
  until eof(b);
  LFNDispose(b);
end;                            { LoadBstAbbrevs }

procedure LoadBibAbbrevs(var Abbrevs: TAbbrevList; fname: string;
                         Entry: EntryRecPtr);
var
  P: POneStringObj;
  OldBibName: string;
  OReal,OEntry,OBeg,n: longint;
  OLink,OEdOnlyStr,OldBibExists,OldUnixBib,ok,accept: boolean;
  OldBibInRing,i: integer;
begin
  Abbrevs.FreeAll;
  if fname='' then Exit;
  oreal:=Entry^.realnum; oentry:=Entry^.entrynum; obeg:=Entry^.beginning;
  CloseFile(bib);
  FileChoose(fname,DefExtension[BibTeXFormat]^,TexInputList,
                   AnyFile and (not (Directory or SysFile)),
                   false,false,false,Nil,'',DatabaseDesc,accept);
  if (fname='') or (not accept) or (not IsFileName(fname)) or (not LFNFileExist(fname)) then
  begin
    ResetBib(Entry);
    ReachEntry(Entry,oreal,oentry,Obeg,false);
    Exit;
  end;
  OldBibName:=BibName^;
  OldUnixBib:=UnixBib; OldBibInRing:=BibInRing;
  OldBibExists:=BibFileExists;
  OLink:=Linked; OEdOnlyStr:=EditOnlyStrings;
  oreal:=Entry^.realnum; oentry:=Entry^.entrynum; obeg:=Entry^.beginning;
  Linked:=false; EditOnlyStrings:=true;
  bibname^:=fname; BibFileExists:=true;

  CloseFile(bib);
  LFNAssign(bib,bibname^);
  ResetBib(Entry);
  n:=1;
  GetEntry(Entry,Nil,1,true,Nil,ok);
  if entry^.entrynum<1 then ok:=false;
  while ok do
  with Entry^ do
  begin
    inc(n);
    New(P,Init(Entry));
    with Abbrevs do
      if not Search(P,i) then AtInsert(-1,P)
      else Dispose(P,Done);
    GetEntry(Entry,Nil,n,true,Nil,ok);
    if Entry^.EntryNum<>n then ok:=false;
  end;
  CloseFile(bib);

  bibname^:=OldBibName; Linked:=OLink; UnixBib:=OldUnixBib;
  BibInRing:=OldBibInRing; EditOnlyStrings:=OEdOnlyStr;
  BibFileExists:=OldBibExists;
  LFNAssign(bib,bibname^);
  ResetBib(Entry);
  ReachEntry(Entry,oreal,oentry,Obeg,false);
end;                               { LoadBibAbbrevs }



begin
  New(BIBAbbrevsFile); New(BSTAbbrevsFile);
  BIBAbbrevsFile^:=''; BSTAbbrevsFile^:='';
  AbbrevAccelWnd:=0;
end.
