{$IFDEF WINDOWS}
{$N-,V-,W-,G+,R-}
{$ELSE}
{$E-,N-,V-,R-}
{$ENDIF}

Unit bibPchec;

Interface

uses
  bibstrg, bibvars, bibutil, bibwild
{$IFDEF WINDOWS}
  ,strings,wbibdisp
{$ENDIF}
  ;


procedure PatternCheck(Entry: EntryRecPtr; Pattern: PatRecptr;
                       var answer : boolean; CheckTag: boolean);


Implementation


procedure PatternCheck(Entry: EntryRecPtr; Pattern: PatRecptr;
                       var answer : boolean; CheckTag: boolean);
var
  i,j,k,chpoint,opi,ind,Slen,icode: integer;
  highyear,thisyear,lowyear: real;
  index,ifld: byte;
  checks: array[0..50] of boolean;
  tmp,tmp2,tmp3 : string;
  running: string;
  tmplogic,CaseSen,RegExp: boolean;

procedure CheckField(tmp: string; fld: byte);
var
  tmp4: string;
  IncLen: word;
  icode: integer;
{$IFDEF WINDOWS}
  P: PChar;
  Srch: array[0..255] of char;
{$ENDIF}
begin
  if tmp='' then checks[chpoint]:=true
  else if FieldParams^[fld].numeric then
  begin
    tmp2:=entry^.content[entry^.index[fld]];
    icode:=17;
    index:=1; LowYear:=0;
    WrdToken(tmp3,tmp,' ,-;',index);
    Val(tmp3,lowyear,icode);
    if (icode=0) then
    begin
      highyear:=lowyear;
      WrdToken(tmp3,tmp,' ,-;',index);
      Val(tmp3,highyear,icode);
      if (index>0) and (icode>0) then
      begin
        WrdToken(tmp3,tmp,' ,-;',index);
        Val(tmp3,highyear,icode);
      end;
      if icode<>0 then highyear:=lowyear;
      icode:=0;
    end;
    if icode=0 then Val(tmp2,thisyear,icode);
    if icode=0 then checks[chpoint]:=checks[chpoint] or
              ((thisyear>=lowyear) and (thisyear<=highyear));
    if icode<>0 then
    begin
      if not CaseSen then StrLwr(tmp2);
      checks[chpoint]:=checks[chpoint] or (Pos(tmp,tmp2)>0);
    end;
  end else
  begin
    if RegExp then                { RegExp search }
    begin
      if entry^.BigIndex[fld]>0 then
      begin
        tmplogic:=PartMatch(tmp,entry^.Big[entry^.BigIndex[fld]]^,
           entry^.Blen[entry^.BigIndex[fld]], CaseSen);
      end else
        tmplogic:=PartMatch(tmp,entry^.content[entry^.index[fld]][1],
          length(entry^.content[entry^.index[fld]]), CaseSen);
      checks[chpoint]:=checks[chpoint] or tmplogic;
    end else                           { Regular search, currently brute force }
    begin
      tmp2:=entry^.content[entry^.index[fld]];
      icode:=17;
      if not CaseSen then StrLwr(tmp2);
      tmplogic:= (Pos(tmp,tmp2)>0);
      checks[chpoint]:=checks[chpoint] or tmplogic;
      if (not tmplogic) and (entry^.BigIndex[fld]>0) then
      begin
{$IFDEF WINDOWS}
        entry^.Big[entry^.BigIndex[fld]]^[entry^.Blen[entry^.BigIndex[fld]]+1]:=#0;
        P:=StrNew(PChar(entry^.Big[entry^.BigIndex[fld]]));
        if not CaseSen then StrLower(P);
        StrPCopy(Srch,tmp);
        tmplogic:=StrPos(P,Srch)<>Nil;
        StrDispose(P); P:=Nil;
        checks[chpoint]:=checks[chpoint] or tmplogic;
{$ELSE}
        Slen:=entry^.Blen[entry^.BigIndex[fld]];
        IncLen:=256-length(tmp); ind:=IncLen+1;
        while (not tmplogic) and (ind<=Slen) do
        begin
          Delete(tmp2,1,IncLen);
          tmp4:=Scopy(entry^.Big[entry^.BigIndex[fld]],ind,
                imin(length(tmp),Slen-ind+1));
          if not CaseSen then StrLwr(tmp4);
          PStrCat(tmp2,tmp4,255);
          tmplogic:= (Pos(tmp,tmp2)>0);
          checks[chpoint]:=checks[chpoint] or tmplogic;
          ind:=imin(ind+IncLen-1,Slen)+1;
        end;
{$ENDIF}
      end;
    end;
  end;
end;                       { CheckField }

begin                      { PatternCheck }
  if (Pattern=Nil) or (not Pattern^.on) or (Pattern^.noper=0) then
  begin
    answer:=true;
    Exit;
  end;
  CaseSen:=false; RegExp:=false;
  answer:=false;
  checks[0]:=true;
  with pattern^ do
  begin
    chpoint:=0;
    for i:=1 to noper do
    begin
      opi:=operation[i];
      if opi>0 then                      { An actual pattern string }
      begin
        chpoint:=chpoint+1;
        tmp:=patrn[opi];
        CaseSen:=(flag[i] and PattFlag_CaseSen)<>0;
        RegExp :=(flag[i] and PattFlag_RegExp)<>0;
        if not CaseSen then StrLwr(tmp);
        checks[chpoint]:=false;
        for j:=1 to length(field[opi]) do
        if not checks[chpoint] then
        begin
          if field[opi,j]=PattField_Name then              { Name }
          begin
            if RegExp then
            begin
              tmplogic:=PartMatch(tmp,entry^.name[1],length(entry^.name),CaseSen);
            end else
            begin
              icode:=17;
              if CaseSen then tmplogic:=(StrPosL(entry^.name,tmp)>0)
              else tmplogic:=(StrPosLI(entry^.name,tmp)>0);
            end;
            checks[chpoint]:=checks[chpoint] or tmplogic;
          end else if field[opi,j]=PattField_Type then   { Type }
          begin
            tmp2:=entry^.EntryType; StrLwr(tmp2);
            icode:=17; tmplogic:=false;
            for k:=1 to length(tmp) do
            if (Ord(tmp[k])<=StringTypeInd) and (tmp2=TypeEntry^[Ord(tmp[k])])
               then tmplogic:=true;
            checks[chpoint]:=checks[chpoint] or tmplogic;
          end else if field[opi,j]=PattField_Tagged then   { Tag }
          begin
            if CheckTag then
              checks[chpoint]:=checks[chpoint] or
                IsTagged(entry^.realnum,Tags) or AllEntriesTagged
            else checks[chpoint]:=true;
          end else if field[opi,j]=PattField_Undec then   { Undeclared }
          begin
            for k:=OrigFieldLast+1 to FieldLast do
            if (not checks[chpoint]) and (entry^.index[k]>0) then
                CheckField(tmp,k);
          end else if entry^.index[ord(field[opi,j])]>0 then
            CheckField(tmp,Ord(field[opi,j]));
        end;
      end else if opi=Patt_AND then                     { AND }
      begin
        checks[chpoint-1]:=(checks[chpoint-1]) and (checks[chpoint]);
        chpoint:=chpoint-1;
      end else if opi=Patt_OR then                  { OR }
      begin
        checks[chpoint-1]:=(checks[chpoint-1]) or (checks[chpoint]);
        chpoint:=chpoint-1;
      end;
      if (flag[i] and PattFlag_NOT)<>0 then checks[chpoint]:=not checks[chpoint];
      answer:=checks[chpoint];
    end;
  end;
end;                       { PatternCheck }

end.
