/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import proguard.Configuration;

public class PrintWriterUtil {
    public static PrintWriter createPrintWriterOut(File outputFile) throws FileNotFoundException, UnsupportedEncodingException {
        return PrintWriterUtil.createPrintWriterOut(outputFile, false);
    }

    public static PrintWriter createPrintWriterOut(File outputFile, boolean append) throws FileNotFoundException, UnsupportedEncodingException {
        return PrintWriterUtil.createPrintWriter(outputFile, new PrintWriter(System.out, true), append);
    }

    public static PrintWriter createPrintWriterErr(File outputFile) throws FileNotFoundException, UnsupportedEncodingException {
        return PrintWriterUtil.createPrintWriter(outputFile, new PrintWriter(System.err, true));
    }

    public static PrintWriter createPrintWriter(File outputFile, PrintWriter console) throws FileNotFoundException, UnsupportedEncodingException {
        return PrintWriterUtil.createPrintWriter(outputFile, console, false);
    }

    public static PrintWriter createPrintWriter(File outputFile, PrintWriter console, boolean append) throws FileNotFoundException, UnsupportedEncodingException {
        return outputFile == Configuration.STD_OUT ? console : new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, append), "UTF-8")));
    }

    public static void closePrintWriter(File file, PrintWriter printWriter) {
        if (file == Configuration.STD_OUT) {
            printWriter.flush();
        } else {
            printWriter.close();
        }
    }

    public static String fileName(File file) {
        if (file == Configuration.STD_OUT) {
            return "standard output";
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            return file.getPath();
        }
    }

    private PrintWriterUtil() {
    }
}

