﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/neptune-graph/NeptuneGraph_EXPORTS.h>
#include <aws/neptune-graph/model/Format.h>
#include <aws/neptune-graph/model/ImportOptions.h>
#include <aws/neptune-graph/model/ImportTaskStatus.h>
#include <aws/neptune-graph/model/ParquetType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace NeptuneGraph {
namespace Model {
class StartImportTaskResult {
 public:
  AWS_NEPTUNEGRAPH_API StartImportTaskResult() = default;
  AWS_NEPTUNEGRAPH_API StartImportTaskResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_NEPTUNEGRAPH_API StartImportTaskResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier of the Neptune Analytics graph.</p>
   */
  inline const Aws::String& GetGraphId() const { return m_graphId; }
  template <typename GraphIdT = Aws::String>
  void SetGraphId(GraphIdT&& value) {
    m_graphIdHasBeenSet = true;
    m_graphId = std::forward<GraphIdT>(value);
  }
  template <typename GraphIdT = Aws::String>
  StartImportTaskResult& WithGraphId(GraphIdT&& value) {
    SetGraphId(std::forward<GraphIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the import task.</p>
   */
  inline const Aws::String& GetTaskId() const { return m_taskId; }
  template <typename TaskIdT = Aws::String>
  void SetTaskId(TaskIdT&& value) {
    m_taskIdHasBeenSet = true;
    m_taskId = std::forward<TaskIdT>(value);
  }
  template <typename TaskIdT = Aws::String>
  StartImportTaskResult& WithTaskId(TaskIdT&& value) {
    SetTaskId(std::forward<TaskIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A URL identifying the location of the data to be imported. This can be an
   * Amazon S3 path, or can point to a Neptune database endpoint or snapshot.</p>
   */
  inline const Aws::String& GetSource() const { return m_source; }
  template <typename SourceT = Aws::String>
  void SetSource(SourceT&& value) {
    m_sourceHasBeenSet = true;
    m_source = std::forward<SourceT>(value);
  }
  template <typename SourceT = Aws::String>
  StartImportTaskResult& WithSource(SourceT&& value) {
    SetSource(std::forward<SourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the format of Amazon S3 data to be imported. Valid values are CSV,
   * which identifies the Gremlin CSV format or OPENCYPHER, which identies the
   * openCypher load format.</p>
   */
  inline Format GetFormat() const { return m_format; }
  inline void SetFormat(Format value) {
    m_formatHasBeenSet = true;
    m_format = value;
  }
  inline StartImportTaskResult& WithFormat(Format value) {
    SetFormat(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The parquet type of the import task.</p>
   */
  inline ParquetType GetParquetType() const { return m_parquetType; }
  inline void SetParquetType(ParquetType value) {
    m_parquetTypeHasBeenSet = true;
    m_parquetType = value;
  }
  inline StartImportTaskResult& WithParquetType(ParquetType value) {
    SetParquetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the IAM role that will allow access to the data that is to be
   * imported.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  StartImportTaskResult& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the import task.</p>
   */
  inline ImportTaskStatus GetStatus() const { return m_status; }
  inline void SetStatus(ImportTaskStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline StartImportTaskResult& WithStatus(ImportTaskStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const ImportOptions& GetImportOptions() const { return m_importOptions; }
  template <typename ImportOptionsT = ImportOptions>
  void SetImportOptions(ImportOptionsT&& value) {
    m_importOptionsHasBeenSet = true;
    m_importOptions = std::forward<ImportOptionsT>(value);
  }
  template <typename ImportOptionsT = ImportOptions>
  StartImportTaskResult& WithImportOptions(ImportOptionsT&& value) {
    SetImportOptions(std::forward<ImportOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartImportTaskResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_graphId;

  Aws::String m_taskId;

  Aws::String m_source;

  Format m_format{Format::NOT_SET};

  ParquetType m_parquetType{ParquetType::NOT_SET};

  Aws::String m_roleArn;

  ImportTaskStatus m_status{ImportTaskStatus::NOT_SET};

  ImportOptions m_importOptions;

  Aws::String m_requestId;
  bool m_graphIdHasBeenSet = false;
  bool m_taskIdHasBeenSet = false;
  bool m_sourceHasBeenSet = false;
  bool m_formatHasBeenSet = false;
  bool m_parquetTypeHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_importOptionsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace NeptuneGraph
}  // namespace Aws
