﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/Array.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kafka/Kafka_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Kafka {
namespace Model {
class DescribeConfigurationRevisionResult {
 public:
  AWS_KAFKA_API DescribeConfigurationRevisionResult() = default;
  AWS_KAFKA_API DescribeConfigurationRevisionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_KAFKA_API DescribeConfigurationRevisionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   *
          <p>The Amazon Resource Name (ARN) of the configuration.</p>

   *
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  DescribeConfigurationRevisionResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   *
          <p>The time when the configuration was created.</p>

   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DescribeConfigurationRevisionResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   *
          <p>The description of the configuration.</p>

   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DescribeConfigurationRevisionResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   *
          <p>The revision number.</p>

   */
  inline long long GetRevision() const { return m_revision; }
  inline void SetRevision(long long value) {
    m_revisionHasBeenSet = true;
    m_revision = value;
  }
  inline DescribeConfigurationRevisionResult& WithRevision(long long value) {
    SetRevision(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   *
          <p>Contents of the <filename>server.properties</filename> file.
   * When using the API, you must ensure that the contents of the file are base64
   * encoded.
             When using the AWS Management Console, the SDK, or the
   * AWS CLI, the contents of <filename>server.properties</filename> can be in
   * plaintext.</p>

   */
  inline const Aws::Utils::ByteBuffer& GetServerProperties() const { return m_serverProperties; }
  template <typename ServerPropertiesT = Aws::Utils::ByteBuffer>
  void SetServerProperties(ServerPropertiesT&& value) {
    m_serverPropertiesHasBeenSet = true;
    m_serverProperties = std::forward<ServerPropertiesT>(value);
  }
  template <typename ServerPropertiesT = Aws::Utils::ByteBuffer>
  DescribeConfigurationRevisionResult& WithServerProperties(ServerPropertiesT&& value) {
    SetServerProperties(std::forward<ServerPropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeConfigurationRevisionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::Utils::DateTime m_creationTime{};

  Aws::String m_description;

  long long m_revision{0};

  Aws::Utils::ByteBuffer m_serverProperties{};

  Aws::String m_requestId;
  bool m_arnHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_revisionHasBeenSet = false;
  bool m_serverPropertiesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Kafka
}  // namespace Aws
