﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/CalculationSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Athena {
namespace Model {
class ListCalculationExecutionsResult {
 public:
  AWS_ATHENA_API ListCalculationExecutionsResult() = default;
  AWS_ATHENA_API ListCalculationExecutionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ATHENA_API ListCalculationExecutionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A token generated by the Athena service that specifies where to continue
   * pagination if a previous request was truncated. To obtain the next set of pages,
   * pass in the <code>NextToken</code> from the response object of the previous page
   * call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListCalculationExecutionsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of <a>CalculationSummary</a> objects.</p>
   */
  inline const Aws::Vector<CalculationSummary>& GetCalculations() const { return m_calculations; }
  template <typename CalculationsT = Aws::Vector<CalculationSummary>>
  void SetCalculations(CalculationsT&& value) {
    m_calculationsHasBeenSet = true;
    m_calculations = std::forward<CalculationsT>(value);
  }
  template <typename CalculationsT = Aws::Vector<CalculationSummary>>
  ListCalculationExecutionsResult& WithCalculations(CalculationsT&& value) {
    SetCalculations(std::forward<CalculationsT>(value));
    return *this;
  }
  template <typename CalculationsT = CalculationSummary>
  ListCalculationExecutionsResult& AddCalculations(CalculationsT&& value) {
    m_calculationsHasBeenSet = true;
    m_calculations.emplace_back(std::forward<CalculationsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListCalculationExecutionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<CalculationSummary> m_calculations;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_calculationsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Athena
}  // namespace Aws
