﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ivs-realtime/Ivsrealtime_EXPORTS.h>
#include <aws/ivs-realtime/model/Participant.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ivsrealtime {
namespace Model {
class GetParticipantResult {
 public:
  AWS_IVSREALTIME_API GetParticipantResult() = default;
  AWS_IVSREALTIME_API GetParticipantResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IVSREALTIME_API GetParticipantResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The participant that is returned.</p>
   */
  inline const Participant& GetParticipant() const { return m_participant; }
  template <typename ParticipantT = Participant>
  void SetParticipant(ParticipantT&& value) {
    m_participantHasBeenSet = true;
    m_participant = std::forward<ParticipantT>(value);
  }
  template <typename ParticipantT = Participant>
  GetParticipantResult& WithParticipant(ParticipantT&& value) {
    SetParticipant(std::forward<ParticipantT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetParticipantResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Participant m_participant;
  bool m_participantHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ivsrealtime
}  // namespace Aws
