/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.deps.behavior.DEGTBehavior;
import net.adaptivebox.deps.behavior.PSGTBehavior;
import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.BasicPoint;

public class DEPSAgent {
    private ProblemEncoder problemEncoder;
    private IGoodnessCompareEngine qualityComparator;
    private SearchPoint trailPoint;
    private AbsGTBehavior selectGTBehavior;
    private BasicPoint pold_t;
    private BasicPoint pcurrent_t;
    private SearchPoint pbest_t;
    private DEGTBehavior deGTBehavior;
    private PSGTBehavior psGTBehavior;
    private double switchP = 0.5;

    public DEPSAgent(ProblemEncoder problemEncoder, DEGTBehavior dEGTBehavior, PSGTBehavior pSGTBehavior, double d, IGoodnessCompareEngine iGoodnessCompareEngine, SearchPoint searchPoint) {
        this.switchP = d;
        this.problemEncoder = problemEncoder;
        this.qualityComparator = iGoodnessCompareEngine;
        this.trailPoint = this.problemEncoder.getFreshSearchPoint();
        this.pold_t = this.problemEncoder.getFreshSearchPoint();
        this.pcurrent_t = this.problemEncoder.getFreshSearchPoint();
        this.pbest_t = searchPoint;
        this.deGTBehavior = dEGTBehavior;
        this.deGTBehavior.setMemPoints(this.pbest_t, this.pcurrent_t, this.pold_t);
        this.psGTBehavior = pSGTBehavior;
        this.psGTBehavior.setMemPoints(this.pbest_t, this.pcurrent_t, this.pold_t);
    }

    public void setSpecComparator(IGoodnessCompareEngine iGoodnessCompareEngine) {
        this.qualityComparator = iGoodnessCompareEngine;
    }

    private AbsGTBehavior getGTBehavior() {
        if (RandomGenerator.doubleZeroOneRandom() < this.switchP) {
            return this.deGTBehavior;
        }
        return this.psGTBehavior;
    }

    public void setGTBehavior(AbsGTBehavior absGTBehavior) {
        absGTBehavior.setMemPoints(this.pbest_t, this.pcurrent_t, this.pold_t);
    }

    public void generatePoint() {
        this.selectGTBehavior = this.getGTBehavior();
        this.selectGTBehavior.generateBehavior(this.trailPoint, this.problemEncoder);
        this.problemEncoder.evaluate(this.trailPoint);
    }

    public void learn() {
        this.selectGTBehavior.testBehavior(this.trailPoint, this.qualityComparator);
    }

    public SearchPoint getMGState() {
        return this.trailPoint;
    }
}

