/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.parser.JavaccError;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParseException;
import org.apache.commons.jexl3.parser.TokenMgrError;

public class JexlException
extends RuntimeException {
    private final transient JexlNode mark;
    private final transient JexlInfo info;
    private static final int MAX_EXCHARLOC = 42;

    public JexlException(JexlNode node, String msg) {
        this(node, msg, null);
    }

    public JexlException(JexlNode node, String msg, Throwable cause) {
        super(msg != null ? msg : "", JexlException.unwrap(cause));
        if (node != null) {
            this.mark = node;
            this.info = node.jexlInfo();
        } else {
            this.mark = null;
            this.info = null;
        }
    }

    public JexlException(JexlInfo jinfo, String msg, Throwable cause) {
        super(msg != null ? msg : "", JexlException.unwrap(cause));
        this.mark = null;
        this.info = jinfo;
    }

    public JexlInfo getInfo() {
        return JexlException.getInfo(this.mark, this.info);
    }

    private static StringBuilder errorAt(JexlNode node) {
        JexlInfo info = node != null ? JexlException.getInfo(node, node.jexlInfo()) : null;
        StringBuilder msg = new StringBuilder();
        if (info != null) {
            msg.append(info.toString());
        } else {
            msg.append("?:");
        }
        msg.append(' ');
        return msg;
    }

    public static JexlInfo getInfo(JexlNode node, JexlInfo info) {
        Debugger dbg;
        if (info != null && node != null && (dbg = new Debugger()).debug(node)) {
            return new JexlInfo(info){

                @Override
                public JexlInfo.Detail getDetail() {
                    return dbg;
                }
            };
        }
        return info;
    }

    public JexlException clean() {
        return JexlException.clean(this);
    }

    private static <X extends Throwable> X clean(X xthrow) {
        if (xthrow != null) {
            ArrayList<StackTraceElement> stackJexl = new ArrayList<StackTraceElement>();
            for (StackTraceElement se : xthrow.getStackTrace()) {
                String className = se.getClassName();
                if (className.startsWith("org.apache.commons.jexl3.internal") || className.startsWith("org.apache.commons.jexl3.parser")) continue;
                stackJexl.add(se);
            }
            xthrow.setStackTrace(stackJexl.toArray(new StackTraceElement[stackJexl.size()]));
        }
        return xthrow;
    }

    private static Throwable unwrap(Throwable xthrow) {
        if (xthrow instanceof InvocationTargetException) {
            return xthrow.getCause();
        }
        if (xthrow instanceof UndeclaredThrowableException) {
            return xthrow.getCause();
        }
        return xthrow;
    }

    private static JexlInfo merge(JexlInfo info, JavaccError cause) {
        JexlInfo dbgn;
        JexlInfo jexlInfo = dbgn = info != null ? info : null;
        if (cause == null) {
            return dbgn;
        }
        if (dbgn == null) {
            return new JexlInfo("", cause.getLine(), cause.getColumn());
        }
        return new JexlInfo(dbgn.getName(), cause.getLine(), cause.getColumn());
    }

    protected String detailedMessage() {
        return super.getMessage();
    }

    protected String parserError(String prefix, String expr) {
        int length = expr.length();
        if (length < 42) {
            return prefix + " error in '" + expr + "'";
        }
        int begin = this.info.getColumn();
        int end = begin + 21;
        if ((begin -= 21) < 0) {
            end -= begin;
            begin = 0;
        }
        return prefix + " error near '... " + expr.substring(begin, end > length ? length : end) + " ...'";
    }

    public static String variableError(JexlNode node, String variable, boolean undef) {
        StringBuilder msg = JexlException.errorAt(node);
        if (undef) {
            msg.append("undefined");
        } else {
            msg.append("null value");
        }
        msg.append(" variable ");
        msg.append(variable);
        return msg.toString();
    }

    public static String propertyError(JexlNode node, String var) {
        StringBuilder msg = JexlException.errorAt(node);
        msg.append("unsolvable property '");
        msg.append(var);
        msg.append('\'');
        return msg.toString();
    }

    public static String methodError(JexlNode node, String method) {
        StringBuilder msg = JexlException.errorAt(node);
        msg.append("unsolvable function/method '");
        msg.append(method);
        msg.append('\'');
        return msg.toString();
    }

    public static String operatorError(JexlNode node, String symbol) {
        StringBuilder msg = JexlException.errorAt(node);
        msg.append("error calling operator '");
        msg.append(symbol);
        msg.append('\'');
        return msg.toString();
    }

    public static String annotationError(JexlNode node, String annotation) {
        StringBuilder msg = JexlException.errorAt(node);
        msg.append("error processing annotation '");
        msg.append(annotation);
        msg.append('\'');
        return msg.toString();
    }

    @Override
    public String getMessage() {
        StringBuilder msg = new StringBuilder();
        if (this.info != null) {
            msg.append(this.info.toString());
        } else {
            msg.append("?:");
        }
        msg.append(' ');
        msg.append(this.detailedMessage());
        Throwable cause = this.getCause();
        if (cause instanceof JexlArithmetic.NullOperand) {
            msg.append(" caused by null operand");
        }
        return msg.toString();
    }

    public static class Continue
    extends JexlException {
        public Continue(JexlNode node) {
            super(node, "continue loop", null);
        }
    }

    public static class Break
    extends JexlException {
        public Break(JexlNode node) {
            super(node, "break loop", null);
        }
    }

    public static class Cancel
    extends JexlException {
        public Cancel(JexlNode node) {
            super(node, "execution cancelled", null);
        }
    }

    public static class Return
    extends JexlException {
        private final Object result;

        public Return(JexlNode node, String msg, Object value) {
            super(node, msg, null);
            this.result = value;
        }

        public Object getValue() {
            return this.result;
        }
    }

    public static class Annotation
    extends JexlException {
        public Annotation(JexlNode node, String name, Throwable cause) {
            super(node, name, cause);
        }

        public String getAnnotation() {
            return super.detailedMessage();
        }

        @Override
        protected String detailedMessage() {
            return "error processing annotation '" + this.getAnnotation() + "'";
        }
    }

    public static class Operator
    extends JexlException {
        public Operator(JexlNode node, String symbol, Throwable cause) {
            super(node, symbol, cause);
        }

        public String getSymbol() {
            return super.detailedMessage();
        }

        @Override
        protected String detailedMessage() {
            return "error calling operator '" + this.getSymbol() + "'";
        }
    }

    public static class Method
    extends JexlException {
        public Method(JexlNode node, String name) {
            super(node, name);
        }

        public Method(JexlInfo info, String name, Throwable cause) {
            super(info, name, cause);
        }

        public String getMethod() {
            return super.detailedMessage();
        }

        @Override
        protected String detailedMessage() {
            return "unsolvable function/method '" + this.getMethod() + "'";
        }
    }

    public static class Property
    extends JexlException {
        public Property(JexlNode node, String var) {
            this(node, var, null);
        }

        public Property(JexlNode node, String var, Throwable cause) {
            super(node, var, cause);
        }

        public String getProperty() {
            return super.detailedMessage();
        }

        @Override
        protected String detailedMessage() {
            return "unsolvable property '" + this.getProperty() + "'";
        }
    }

    public static class Variable
    extends JexlException {
        private final boolean undefined;

        public Variable(JexlNode node, String var, boolean undef) {
            super(node, var, null);
            this.undefined = undef;
        }

        public boolean isUndefined() {
            return this.undefined;
        }

        public String getVariable() {
            return super.detailedMessage();
        }

        @Override
        protected String detailedMessage() {
            return (this.undefined ? "undefined" : "null value") + " variable " + this.getVariable();
        }
    }

    public static class Assignment
    extends Parsing {
        public Assignment(JexlInfo info, String expr) {
            super(info, expr);
        }

        @Override
        protected String detailedMessage() {
            return this.parserError("assignment", this.getDetail());
        }
    }

    public static class Ambiguous
    extends Parsing {
        public Ambiguous(JexlInfo info, String expr) {
            super(info, expr);
        }

        @Override
        protected String detailedMessage() {
            return this.parserError("ambiguous statement", this.getDetail());
        }
    }

    public static class Parsing
    extends JexlException {
        public Parsing(JexlInfo info, ParseException cause) {
            super(JexlException.merge(info, cause), cause.getAfter(), null);
        }

        public Parsing(JexlInfo info, String msg) {
            super(info, msg, null);
        }

        public String getDetail() {
            return super.detailedMessage();
        }

        @Override
        protected String detailedMessage() {
            return this.parserError("parsing", this.getDetail());
        }
    }

    public static class Tokenization
    extends JexlException {
        public Tokenization(JexlInfo info, TokenMgrError cause) {
            super(JexlException.merge(info, cause), cause.getAfter(), null);
        }

        public String getDetail() {
            return super.detailedMessage();
        }

        @Override
        protected String detailedMessage() {
            return this.parserError("tokenization", this.getDetail());
        }
    }
}

