/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.Utils;

public class DriverManagerConnectionFactory
implements ConnectionFactory {
    private final String connectionUri;
    private final String userName;
    private final char[] userPassword;
    private final Properties properties;

    public DriverManagerConnectionFactory(String string) {
        this.connectionUri = string;
        this.properties = new Properties();
        this.userName = null;
        this.userPassword = null;
    }

    public DriverManagerConnectionFactory(String string, Properties properties) {
        this.connectionUri = string;
        this.properties = properties;
        this.userName = null;
        this.userPassword = null;
    }

    public DriverManagerConnectionFactory(String string, String string2, char[] cArray) {
        this.connectionUri = string;
        this.userName = string2;
        this.userPassword = Utils.clone(cArray);
        this.properties = null;
    }

    public DriverManagerConnectionFactory(String string, String string2, String string3) {
        this.connectionUri = string;
        this.userName = string2;
        this.userPassword = Utils.toCharArray(string3);
        this.properties = null;
    }

    @Override
    public Connection createConnection() throws SQLException {
        if (null == this.properties) {
            if (this.userName == null && this.userPassword == null) {
                return DriverManager.getConnection(this.connectionUri);
            }
            return DriverManager.getConnection(this.connectionUri, this.userName, Utils.toString(this.userPassword));
        }
        return DriverManager.getConnection(this.connectionUri, this.properties);
    }

    public String getConnectionUri() {
        return this.connectionUri;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getUserName() {
        return this.userName;
    }

    static {
        DriverManager.getDrivers();
    }
}

