/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html.entities;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.html.entities.Entities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/html/entities/EntityConverter;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "REGEX_ESCAPES", "escapeAllowedString", "", "replacements", "", "", "replaceEntities", "text", "", "processEntities", "", "processEscapes", "markdown"})
public final class EntityConverter {
    @NotNull
    public static final EntityConverter INSTANCE = new EntityConverter();
    @NotNull
    private static final String escapeAllowedString = "!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~";
    @NotNull
    private static final Map<Character, String> replacements;
    @NotNull
    private static final Regex REGEX;
    @NotNull
    private static final Regex REGEX_ESCAPES;

    private EntityConverter() {
    }

    @NotNull
    public final String replaceEntities(@NotNull CharSequence text2, boolean processEntities, boolean processEscapes) {
        Intrinsics.checkNotNullParameter(text2, "text");
        return (processEscapes ? REGEX_ESCAPES : REGEX).replace(text2, (Function1<? super MatchResult, ? extends CharSequence>)new Function1<MatchResult, CharSequence>(processEntities){
            final /* synthetic */ boolean $processEntities;
            {
                this.$processEntities = $processEntities;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult match) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter(match, "match");
                MatchGroupCollection g = match.getGroups();
                if (g.size() > 5 && g.get(5) != null) {
                    MatchGroup matchGroup = g.get(5);
                    Intrinsics.checkNotNull(matchGroup);
                    char c = matchGroup.getValue().charAt(0);
                    String string = (String)EntityConverter.access$getReplacements$p().get(Character.valueOf(c));
                    if (string == null) {
                        string = String.valueOf(c);
                    }
                    charSequence = string;
                } else if (g.get(4) != null) {
                    Map map2 = EntityConverter.access$getReplacements$p();
                    MatchGroup matchGroup = g.get(4);
                    Intrinsics.checkNotNull(matchGroup);
                    String string = (String)map2.get(Character.valueOf(matchGroup.getValue().charAt(0)));
                    if (string == null) {
                        string = match.getValue();
                    }
                    charSequence = string;
                } else {
                    String string;
                    Character c;
                    Integer code;
                    Integer n;
                    if (!this.$processEntities) {
                        n = null;
                    } else if (g.get(1) != null) {
                        n = Entities.INSTANCE.getMap().get(match.getValue());
                    } else if (g.get(2) != null) {
                        MatchGroup matchGroup = g.get(2);
                        Intrinsics.checkNotNull(matchGroup);
                        n = Integer.parseInt(matchGroup.getValue());
                    } else if (g.get(3) != null) {
                        MatchGroup matchGroup = g.get(3);
                        Intrinsics.checkNotNull(matchGroup);
                        n = Integer.parseInt(matchGroup.getValue(), CharsKt.checkRadix(16));
                    } else {
                        n = null;
                    }
                    Integer n2 = code = n;
                    Character c2 = c = n2 != null ? Character.valueOf((char)n2.intValue()) : null;
                    if (c != null) {
                        string = (String)EntityConverter.access$getReplacements$p().get(c);
                        if (string == null) {
                            string = c.toString();
                        }
                    } else {
                        StringBuilder stringBuilder = new StringBuilder().append("&amp;");
                        String string2 = match.getValue().substring(1);
                        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                        string = stringBuilder.append(string2).toString();
                    }
                    charSequence = string;
                }
                return charSequence;
            }
        });
    }

    public static final /* synthetic */ Map access$getReplacements$p() {
        return replacements;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('\"'), "&quot;"), TuplesKt.to(Character.valueOf('&'), "&amp;"), TuplesKt.to(Character.valueOf('<'), "&lt;"), TuplesKt.to(Character.valueOf('>'), "&gt;")};
        replacements = MapsKt.mapOf(pairArray);
        REGEX = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));|([\"&<>])");
        REGEX_ESCAPES = new Regex(REGEX.getPattern() + "|\\\\([!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~])");
    }
}

