/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFImageLoader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.BitmapInfo;
import org.freehep.graphicsio.emf.gdi.GDIObject;

public class CreateDIBPatternBrushPt
extends EMFTag {
    private int usage;
    private BitmapInfo bmi;
    private BufferedImage image;
    private int index;

    public CreateDIBPatternBrushPt() {
        super(94, 1);
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        CreateDIBPatternBrushPt tag = new CreateDIBPatternBrushPt();
        tag.index = emf.readDWORD();
        emf.readByte(24);
        tag.bmi = new BitmapInfo(emf);
        tag.usage = emf.readDWORD();
        tag.image = EMFImageLoader.readImage(tag.bmi.getHeader(), tag.bmi.getHeader().getWidth(), tag.bmi.getHeader().getHeight(), emf, len - 4 - 24 - 40 - 4, null);
        return tag;
    }

    @Override
    public void write(int tagID, EMFOutputStream emf) throws IOException {
        logger.warning("not implemented");
    }

    @Override
    public String toString() {
        return super.toString() + "\n  usage: " + this.usage + "\n" + this.bmi.toString();
    }

    @Override
    public void render(EMFRenderer renderer) {
        renderer.storeGDIObject(this.index, new GDIObject(){

            @Override
            public void render(EMFRenderer renderer) {
                if (CreateDIBPatternBrushPt.this.image != null) {
                    renderer.setBrushPaint(new TexturePaint(CreateDIBPatternBrushPt.this.image, new Rectangle(0, 0, 16, 16)));
                }
            }
        });
    }
}

