# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_repro_env_global_optspecs
	string join \n v/verbose C/context= h/help V/version
end

function __fish_repro_env_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_repro_env_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_repro_env_using_subcommand
	set -l cmd (__fish_repro_env_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c repro-env -n "__fish_repro_env_needs_command" -s C -l context -d 'Change the current directory to this path before executing the subcommand' -r -F
complete -c repro-env -n "__fish_repro_env_needs_command" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c repro-env -n "__fish_repro_env_needs_command" -s h -l help -d 'Print help'
complete -c repro-env -n "__fish_repro_env_needs_command" -s V -l version -d 'Print version'
complete -c repro-env -n "__fish_repro_env_needs_command" -f -a "build" -d 'Run a build in a reproducible environment'
complete -c repro-env -n "__fish_repro_env_needs_command" -f -a "update" -d 'Update all dependencies of the reproducible environment'
complete -c repro-env -n "__fish_repro_env_needs_command" -f -a "fetch" -d 'Fetch dependencies into the local cache'
complete -c repro-env -n "__fish_repro_env_needs_command" -f -a "completions" -d 'Generate shell completions'
complete -c repro-env -n "__fish_repro_env_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c repro-env -n "__fish_repro_env_using_subcommand build" -s f -l file -d 'The dependency lockfile to use' -r -F
complete -c repro-env -n "__fish_repro_env_using_subcommand build" -s e -l env -d 'Pass environment variables into the build container (FOO=bar or just FOO to lookup the value)' -r
complete -c repro-env -n "__fish_repro_env_using_subcommand build" -s k -l keep -d 'Do not delete the build container, wait for ctrl-c'
complete -c repro-env -n "__fish_repro_env_using_subcommand build" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c repro-env -n "__fish_repro_env_using_subcommand build" -s h -l help -d 'Print help'
complete -c repro-env -n "__fish_repro_env_using_subcommand update" -l no-pull -d 'Do not attempt to pull the container tag from registry before resolving it'
complete -c repro-env -n "__fish_repro_env_using_subcommand update" -s k -l keep -d 'Do not delete the build container, wait for ctrl-c'
complete -c repro-env -n "__fish_repro_env_using_subcommand update" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c repro-env -n "__fish_repro_env_using_subcommand update" -s h -l help -d 'Print help'
complete -c repro-env -n "__fish_repro_env_using_subcommand fetch" -s f -l file -d 'The dependency lockfile to use' -r -F
complete -c repro-env -n "__fish_repro_env_using_subcommand fetch" -l no-pull -d 'Do not attempt to pull the container tag from registry'
complete -c repro-env -n "__fish_repro_env_using_subcommand fetch" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c repro-env -n "__fish_repro_env_using_subcommand fetch" -s h -l help -d 'Print help'
complete -c repro-env -n "__fish_repro_env_using_subcommand completions" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c repro-env -n "__fish_repro_env_using_subcommand completions" -s h -l help -d 'Print help'
complete -c repro-env -n "__fish_repro_env_using_subcommand help; and not __fish_seen_subcommand_from build update fetch completions help" -f -a "build" -d 'Run a build in a reproducible environment'
complete -c repro-env -n "__fish_repro_env_using_subcommand help; and not __fish_seen_subcommand_from build update fetch completions help" -f -a "update" -d 'Update all dependencies of the reproducible environment'
complete -c repro-env -n "__fish_repro_env_using_subcommand help; and not __fish_seen_subcommand_from build update fetch completions help" -f -a "fetch" -d 'Fetch dependencies into the local cache'
complete -c repro-env -n "__fish_repro_env_using_subcommand help; and not __fish_seen_subcommand_from build update fetch completions help" -f -a "completions" -d 'Generate shell completions'
complete -c repro-env -n "__fish_repro_env_using_subcommand help; and not __fish_seen_subcommand_from build update fetch completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
