/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.io;

import java.io.InputStream;
import org.cryptacular.CryptUtil;
import org.cryptacular.io.Resource;

public class ClassPathResource
implements Resource {
    private final String classPath;
    private final ClassLoader classLoader;

    public ClassPathResource(String path) {
        this(path, Thread.currentThread().getContextClassLoader());
    }

    public ClassPathResource(String path, ClassLoader loader) {
        CryptUtil.assertNotNullArg(path, "Path cannot be null");
        this.classPath = path.startsWith("/") ? path.substring(1) : path;
        this.classLoader = CryptUtil.assertNotNullArg(loader, "Class loader cannot be null");
    }

    @Override
    public InputStream getInputStream() {
        return this.classLoader.getResourceAsStream(this.classPath);
    }
}

