/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationBase;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.GapPolicy;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class BucketSortAggregation
extends AggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, BucketSortAggregation> {
    @Nullable
    private final Integer from;
    @Nullable
    private final GapPolicy gapPolicy;
    @Nullable
    private final Integer size;
    @Nonnull
    private final List<SortOptions> sort;
    public static final JsonpDeserializer<BucketSortAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketSortAggregation::setupBucketSortAggregationDeserializer);

    private BucketSortAggregation(Builder builder) {
        super(builder);
        this.from = builder.from;
        this.gapPolicy = builder.gapPolicy;
        this.size = builder.size;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
    }

    public static BucketSortAggregation of(Function<Builder, ObjectBuilder<BucketSortAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.BucketSort;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nonnull
    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.gapPolicy != null) {
            generator.writeKey("gap_policy");
            this.gapPolicy.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions item0 : this.sort) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupBucketSortAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketSortAggregation.setupAggregationBaseDeserializer(op);
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(Builder::gapPolicy, GapPolicy._DESERIALIZER, "gap_policy");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.from);
        result = 31 * result + Objects.hashCode(this.gapPolicy);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.sort);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketSortAggregation other = (BucketSortAggregation)o;
        return Objects.equals(this.from, other.from) && Objects.equals(this.gapPolicy, other.gapPolicy) && Objects.equals(this.size, other.size) && Objects.equals(this.sort, other.sort);
    }

    public static class Builder
    extends AggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, BucketSortAggregation> {
        @Nullable
        private Integer from;
        @Nullable
        private GapPolicy gapPolicy;
        @Nullable
        private Integer size;
        @Nullable
        private List<SortOptions> sort;

        public Builder() {
        }

        private Builder(BucketSortAggregation o) {
            super(o);
            this.from = o.from;
            this.gapPolicy = o.gapPolicy;
            this.size = o.size;
            this.sort = Builder._listCopy(o.sort);
        }

        private Builder(Builder o) {
            super(o);
            this.from = o.from;
            this.gapPolicy = o.gapPolicy;
            this.size = o.size;
            this.sort = Builder._listCopy(o.sort);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        @Nonnull
        public final Builder gapPolicy(@Nullable GapPolicy value) {
            this.gapPolicy = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        @Nonnull
        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        @Nonnull
        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        @Override
        @Nonnull
        public BucketSortAggregation build() {
            this._checkSingleUse();
            return new BucketSortAggregation(this);
        }
    }
}

