/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.identity.noop;

import java.security.Principal;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.identity.NamedPrincipal;
import org.opensearch.identity.PluginSubject;
import org.opensearch.threadpool.ThreadPool;

@InternalApi
public class NoopPluginSubject
implements PluginSubject {
    private final ThreadPool threadPool;

    NoopPluginSubject(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public Principal getPrincipal() {
        return NamedPrincipal.UNAUTHENTICATED;
    }

    @Override
    public <E extends Exception> void runAs(CheckedRunnable<E> r) throws E {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            r.run();
        }
    }
}

