/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

public class IntArrayList {
    private int[] data;
    private int size = 0;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int initial_capacity) {
        this.data = new int[initial_capacity];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public int get(int index) {
        this.checkAccess(index);
        return this.data[index];
    }

    public void add(int value) {
        this.checkGrow(1);
        this.data[this.size] = value;
        ++this.size;
    }

    public void set(int index, int value) {
        this.checkAccess(index);
        this.data[index] = value;
    }

    private void checkAccess(int index) {
        if (this.size <= index) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside list bounds (size=" + this.size + ")");
        }
    }

    private void checkGrow(int amount) {
        if (this.size + amount <= this.data.length) {
            return;
        }
        int new_length = this.data.length * 2;
        while (new_length < this.size + amount) {
            new_length = this.data.length * 2;
        }
        int[] new_data = new int[new_length];
        System.arraycopy(this.data, 0, new_data, 0, this.size);
        this.data = new_data;
    }
}

